<?php
/*
 * Set up the content width value based on the theme's design.
 */
require get_template_directory() . '/licenses/wpdigipro-adp.php';
$theme_license = new WPDigiPro_Theme_License_Adapter('themes.php', 'bizzbeepro');
$license_data = $theme_license->WPDigiPro_Theme_Get_Code();

if(isset($license_data->status) && $license_data->status == 'success') {

	require get_template_directory() . '/bizzbeepro-importer/inc/class-ocdi-main.php'; // Demo Data Importer
    $bizzbeepro_importer = PT_One_Click_Demo_Import::getInstance();
    function bizzbeepro_import_files() {
        return array(
            array(
                'import_file_name'           => __('Bizzbee Pro','bizzbeepro'),
                'import_file_url'            => 'https://fasterthemes.com/export-data/bizzbeepro/bizzbeepro.xml',
                'import_widget_file_url'     => 'https://fasterthemes.com/export-data/bizzbeepro/bizzbeepro.wie',
                'import_customizer_file_url' => 'https://fasterthemes.com/export-data/bizzbeepro/bizzbeepro.dat',
                'import_notice'              => __( 'Click below button to import this demo.', 'bizzbeepro' ),
            ),
        );
    }
    add_filter( 'bizzbeepro/import_files', 'bizzbeepro_import_files' );

    function bizzbeepro_after_demo_import() {
        // Assign menus to their locations.
      $primary_menu = get_term_by( 'name', 'Menu 1', 'nav_menu' );
        set_theme_mod( 'nav_menu_locations', array(
                'primary' => $primary_menu->term_id,
            )
        );
        // Assign front page and posts page (blog page).
        $front_page_id = get_page_by_title( 'Home' );
        $blog_page_id = get_page_by_title( 'Blog' );
        update_option( 'show_on_front', 'page' );
        update_option( 'page_on_front', $front_page_id->ID );
        update_option( 'page_for_posts', $blog_page_id->ID );
    }
    add_action( 'bizzbeepro/after_import', 'bizzbeepro_after_demo_import' );
}

if ( ! function_exists( 'bizzbeepro_setup' ) ) :
function bizzbeepro_setup() {	
	
	register_nav_menus( array(
		'primary'   => __( 'Main Menu', 'bizzbeepro' ),	
	) );
	global $content_width;
	if ( ! isset( $content_width ) ) $content_width = 730;
	
	load_theme_textdomain( 'bizzbeepro', get_template_directory() . '/languages' );	
	add_theme_support('automatic-feed-links');
	add_theme_support('post-thumbnails');
	set_post_thumbnail_size(730, 404, true);
	add_image_size('bizzbeepro-post-image', 670, 380, true);
	add_image_size('bizzbeepro-home-tab-size', 380, 270, true);	
	add_image_size('bizzbeepro-custom-widget-size',100, 80, true);
	add_image_size('bizzbeepro-blog-thumbnail-image-home',570, 320, true);
	add_image_size('bizzbeepro-testimonial-size',105, 110, true);
	add_image_size('bizzbeepro-team-size',265, 260, true);
	add_image_size('bizzbeepro-portfolio-size',325, 220, true);	
	add_image_size('bizzbeepro-portfolio-3column-size',360, 240, true);	
	add_image_size('bizzbeepro-portfolio-4column-size',265, 175, true);	
	 add_theme_support( 'woocommerce' );

	add_theme_support('html5', array(
	   'search-form', 'comment-form', 'comment-list',
	));
	add_theme_support( 'custom-header', apply_filters( 'bizzbeepro_custom_header_args', array(
	'uploads'       => true,
	'flex-height'   => true,
	'default-text-color' => '#000',
	'header-text' => true,
	'height' => '110',
	'width'  => '1300'
 	) ) );
	add_theme_support( 'custom-background', apply_filters( 'bizzbeepro_custom_background_args', array(
	'default-color' => 'f5f5f5',
	) ) );	
	     
	add_filter('use_default_gallery_style', '__return_false'); 
	add_editor_style('css/editor-style.css');
	add_theme_support( 'title-tag' );	  	
}

function bizzbeepro_change_excerpt_more( $more ) {
	global $post;
    return '<div class="theme-btn-group col-md-12"><a class="default-btn" title="'. __('Read More','bizzbeepro').'" href="'. esc_url(get_permalink($post->ID)) . '">' .  __('Read More','bizzbeepro'). '</a></div>';          
}
add_filter('excerpt_more', 'bizzbeepro_change_excerpt_more');



function bizzbeepro_excerpt_length( $length ) {
    if(!is_page_template('page-templates/front-page.php')){ 
		$excerpt_lenght=get_theme_mod('excerpt_length')?get_theme_mod('excerpt_length'):60;
		return $excerpt_lenght; 
	}else return 30; 
}
add_filter( 'excerpt_length', 'bizzbeepro_excerpt_length', 999 );

endif; // bizzbeepro_setup
add_action( 'after_setup_theme', 'bizzbeepro_setup' );

add_action('wp_head','bizzbeepro_purpose_bg_img_css');
function bizzbeepro_purpose_bg_img_css()
{
	$bizzbeepro_breadcrumbs_image_bg=get_theme_mod('bizzbeepro_breadcrumbs_image_bg');
	if (!empty($bizzbeepro_breadcrumbs_image_bg) ){
		$bizzbeepro_breadcrumbs_image_bg = esc_url(get_theme_mod('bizzbeepro_breadcrumbs_image_bg'));
		$bizzbeepro_breadcrumbs_output="<style> .background-section { background-image :url('".$bizzbeepro_breadcrumbs_image_bg."');
		background-position: center;} </style>";
		echo $bizzbeepro_breadcrumbs_output;
	}
	
	$bizzbeepro_whoweare_image_bg=get_theme_mod('bizzbeepro_whoweare_image_bg');
	if (!empty($bizzbeepro_whoweare_image_bg) ){
		$bizzbeepro_whoweare_image_bg = esc_url(get_theme_mod('bizzbeepro_whoweare_image_bg'));
		$bizzbeepro_breadcrumbs_output="<style> .about-section { background-image :url('".$bizzbeepro_whoweare_image_bg."');
		background-position: center;} </style>";
		echo $bizzbeepro_breadcrumbs_output;
	}

	$bizzbeepro_breadcrumbs_image_bg=get_theme_mod('bizzbeepro_breadcrumbs_blog_image_bg');
	if (!empty($bizzbeepro_breadcrumbs_image_bg) ){
		$bizzbeepro_breadcrumbs_image_bg = esc_url(get_theme_mod('bizzbeepro_breadcrumbs_blog_image_bg'));
		$bizzbeepro_breadcrumbs_output="<style> .background-blog { background-image :url('".$bizzbeepro_breadcrumbs_image_bg."');
		background-position: center;} </style>";
		echo $bizzbeepro_breadcrumbs_output;
	}
	
	
}

add_action('wp_head','bizzbeepro_favicon');
function bizzbeepro_favicon(){
	$favicon = get_theme_mod( 'bizzbeepro_favicon' );
	if ( isset($favicon) && !empty($favicon) ) { ?> 
		<link rel="shortcut icon" href="<?php echo esc_url(get_theme_mod( 'bizzbeepro_favicon' )); ?>"> <?php 
	}
}
/*** Enqueue css and js files ***/
require get_template_directory() . '/functions/enqueue-files.php';

/*** Enqueue breadcrumbs files ***/
require get_template_directory() . '/functions/breadcrumbs.php';

/*** default setup files ***/
require get_template_directory() . '/functions/theme-default-setup.php';

/*** Customizer ***/
require get_template_directory() . '/functions/theme-customizer.php';

require get_template_directory() . '/functions/custom-header.php';

require get_template_directory() . '/functions/tgm-plugins.php';

require get_template_directory() . '/functions/getintouch.php';
function bizzbeepro_customizer_head_styles() {
	$bizzbeepro_link_color = get_theme_mod( 'bizzbeepro_color' ); 
	$bizzbeepro_link_hover= get_theme_mod( 'bizzbeepro_hover_color' ); 	
	$bizzbeepro_testimonial_image_bg= get_theme_mod( 'bizzbeepro_testimonial_image_bg' ); 	
	
	if (!empty($bizzbeepro_testimonial_image_bg)) 
	{
	?>
	<style type="text/css">
		.background-testimonial{ background-image: url('<?php echo $bizzbeepro_testimonial_image_bg; ?>'); }
	</style>
	<?php		
	}

	if ( $bizzbeepro_link_color  != '#000000' ||  $bizzbeepro_link_hover  != '#82b440'  ) :
	?>
		<style type="text/css">
			a, #main-menu ul li.current-menu-item > a,
    .sidebar-widget .widget-title,.post-title, .tagcloud > a, .wpcf7-form-control.wpcf7-submit, .default-btn:hover{
				color: <?php echo $bizzbeepro_link_color; ?>;
			}
			.tagcloud > a, .wpcf7-form-control.wpcf7-submit, .default-btn:hover, .team-info p > span{
				border-color: <?php echo $bizzbeepro_link_color; ?>;
			}
			.main-title h2 > span:before, .footer-bottom{
				border-top: 2px solid <?php echo $bizzbeepro_link_hover; ?>;
			}
			a:hover, a:active, #main-menu ul li.current-menu-item > a, .default-btn, #today, .tagcloud > a:hover, .popular-posts .posts p a:hover, .main-footer ul li a:hover, .footer-bottom p > a:hover, .wpcf7-form-control.wpcf7-submit:hover, #testimonial-demo .owl-controls .owl-buttons div:hover{
				color: <?php echo $bizzbeepro_link_hover; ?>;
			}
			#main-menu ul li.current-menu-item > a, .main-title h2 > span, .page-title, .sidebar-widget h4{
			   border-bottom: 1px solid <?php echo $bizzbeepro_link_hover; ?>;;
			}
			#main-menu ul li ul, .default-btn, #main-menu ul li ul li ul, .tagcloud > a:hover, .popular-posts .posts p a:hover, .wpcf7-form-control.wpcf7-submit:hover,.testimonial-person, #testimonial-demo .owl-controls .owl-buttons div:hover{
			   border-color : <?php echo $bizzbeepro_link_hover; ?>;;
			}
			.sidebar-widget h4:before{
				border-top: 1px solid <?php echo $bizzbeepro_link_hover; ?>;
			}
                       .work-box .over-backface:before{
			   background : <?php echo $bizzbeepro_link_hover; ?>;;
			}
                       .team-info > ul li a{
			   background-color : <?php echo $bizzbeepro_link_hover; ?>;;
			} 
                       .team-info > ul li a:hover{
			   background-color : <?php echo $bizzbeepro_link_color; ?>;;
			} 

		</style>
	<?php
	endif;
}
add_action( 'wp_head', 'bizzbeepro_customizer_head_styles' );

/***** Adding custom post type - Testimonial *****/
function bizzbeepro_testimonials_custom_init() {
	$bizzbeepro_labels = array(
		'name' => __('Testimonials','bizzbeepro'),
		'singular_name' => __('testimonials','bizzbeepro'),
		'add_new' => __('Add New','bizzbeepro'),
		'add_new_item' => __('Add New Testimonial','bizzbeepro'),
		'edit_item' => __('Edit Testimonial','bizzbeepro'),
		'new_item' => __('New Testimonial','bizzbeepro'),
		'all_items' => __('All Testimonials','bizzbeepro'),
		'view_item' => __('View Testimonials','bizzbeepro'),
		'search_items' => __('Search Testimonial','bizzbeepro'),
		'not_found' => __('No testimonials found','bizzbeepro'),
		'not_found_in_trash' => __('No testimonials found in Trash','bizzbeepro'),
		'parent_item_colon' => '',
		'menu_name' => __('Testimonials','bizzbeepro')
	);
	$bizzbeepro_args = array(
		'labels' => $bizzbeepro_labels,
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'query_var' => true,
		'rewrite' => array( 'slug' => 'testimonials' ),
		'capability_type' => 'post',
		'has_archive' => true,
		'hierarchical' => false,
		'menu_position' => null,
		'supports' => array( 'title', 'editor' , 'thumbnail')
	);

register_post_type( 'testimonials', $bizzbeepro_args );
}
add_action( 'init', 'bizzbeepro_testimonials_custom_init' );

add_action( 'add_meta_boxes', 'bizzbeepro_meta_box_testimonial' );
function bizzbeepro_meta_box_testimonial()
{
	add_meta_box( 'testimonial_meta_box_details', 'Details', 'bizzbeepro_testimonial_details', 'testimonials', 'normal', 'high' );
}
function bizzbeepro_testimonial_details( $post )
{
	$values = get_post_custom( $post->ID );
	$designation = isset( $values['designation'] ) ? esc_attr( $values['designation'][0] ) : '';
	wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
	?>
		<p>
		<?php _e('Designation','bizzbeepro'); ?>
		<input type="text" name="designation" value="<?php echo esc_attr( $designation ); ?>" class="widefat" placeholder="<?php _e('Designation','bizzbeepro'); ?>" />
		</p>
	<?php
}
add_action( 'save_post', 'testimonial_meta_box_save' );
function testimonial_meta_box_save( $post_id )
{
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
	if( isset( $_POST['designation'] ) ) update_post_meta( $post_id, 'designation', esc_attr( $_POST['designation'] ) );
}

/***** Adding custom post type - Testimonial *****/
function bizzbeepro_ourteam_custom_init() {
	$bizzbeepro_labels = array(
		'name' => __('Our Team','bizzbeepro'),
		'singular_name' => __('ourteam','bizzbeepro'),
		'add_new' => __('Add New','bizzbeepro'),
		'add_new_item' => __('Add New Our Team','bizzbeepro'),
		'edit_item' => __('Edit Our Team','bizzbeepro'),
		'new_item' => __('New Our Team','bizzbeepro'),
		'all_items' => __('All Our Team','bizzbeepro'),
		'view_item' => __('View Our Team','bizzbeepro'),
		'search_items' => __('Search Our Team','bizzbeepro'),
		'not_found' => __('No ourteam found','bizzbeepro'),
		'not_found_in_trash' => __('No ourteam found in Trash','bizzbeepro'),
		'parent_item_colon' => '',
		'menu_name' => __('Our Team','bizzbeepro')
	);
	$bizzbeepro_args = array(
		'labels' => $bizzbeepro_labels,
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'query_var' => true,
		'rewrite' => array( 'slug' => 'ourteam' ),
		'capability_type' => 'post',
		'has_archive' => true,
		'hierarchical' => false,
		'menu_position' => null,
		'supports' => array( 'title',  'thumbnail')
	);

register_post_type( 'ourteam', $bizzbeepro_args );
}
add_action( 'init', 'bizzbeepro_ourteam_custom_init' );

add_action( 'add_meta_boxes', 'bizzbeepro_meta_box_ourteam' );
function bizzbeepro_meta_box_ourteam()
{
	add_meta_box( 'ourteam_meta_box_details', 'Details', 'bizzbeepro_ourteam_details', 'ourteam', 'normal', 'high' );
}
function bizzbeepro_ourteam_details( $post )
{
	$values = get_post_custom( $post->ID );
	$bizzbeepro_designation = isset( $values['designation'] ) ? esc_attr( $values['designation'][0] ) : '';
	$bizzbeepro_fb = isset( $values['fb'] ) ? esc_attr( $values['fb'][0] ) : '';
	$bizzbeepro_tw = isset( $values['tw'] ) ? esc_attr( $values['tw'][0] ) : '';
	$bizzbeepro_email = isset( $values['email'] ) ? esc_attr( $values['email'][0] ) : '';
	wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
	?>
		<p>
		<?php _e('Designation','bizzbeepro'); ?>
		<input type="text" name="designation" value="<?php if (isset($bizzbeepro_designation) && !empty($bizzbeepro_designation)) { echo esc_attr( $bizzbeepro_designation ); }?>" class="widefat" placeholder="<?php _e('Designation','bizzbeepro'); ?>" />
		</p>
		<p>
		<?php _e('Facebook','bizzbeepro'); ?>
		<input type="text" name="fb" value="<?php if (isset($bizzbeepro_fb) && !empty($bizzbeepro_fb)) { echo esc_url( $bizzbeepro_fb ); } ?>" class="widefat" placeholder="<?php _e('Facebook','bizzbeepro'); ?>" />
		</p>
		<p>
		<?php _e('Twitter','bizzbeepro'); ?>
		<input type="text" name="tw" value="<?php if (isset($bizzbeepro_tw) && !empty($bizzbeepro_tw)) { echo esc_url( $bizzbeepro_tw ); } ?>" class="widefat" placeholder="<?php _e('Twitter','bizzbeepro'); ?>" />
		</p>
		<p>
		<?php _e('Email','bizzbeepro'); ?>
		<input type="text" name="email" value="<?php if (isset($bizzbeepro_email) && !empty($bizzbeepro_email)) { echo esc_attr( $bizzbeepro_email ); }?>" class="widefat" placeholder="<?php _e('Email','bizzbeepro'); ?>" />
		</p>
	<?php
}
add_action( 'save_post', 'ourteam_meta_box_save' );
function ourteam_meta_box_save( $post_id )
{
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
	if( isset( $_POST['designation'] ) ) update_post_meta( $post_id, 'designation', esc_attr( $_POST['designation'] ) );
	if( isset( $_POST['fb'] ) ) update_post_meta( $post_id, 'fb', esc_url( $_POST['fb'] ) );
	if( isset( $_POST['tw'] ) ) update_post_meta( $post_id, 'tw', esc_url( $_POST['tw'] ) );
	if( isset( $_POST['email'] ) ) update_post_meta( $post_id, 'email', sanitize_email( $_POST['email'] ) );
}



/***** Adding custom post type - Portfolio *****/

function bizzbeepro_portfolio_custom_init() {
	$bizzbeepro_labels = array(
		'name' => 'Portfolio',
		'singular_name' => 'portfolio',
		'add_new' => 'Add New',
		'add_new_item' => 'Add New Portfolio',
		'edit_item' => 'Edit Portfolio',
		'new_item' => 'New Portfolio',
		'all_items' => 'All Portfolio',
		'view_item' => 'View Portfolio',
		'search_items' => 'Search Portfolio',
		'not_found' => 'No Portfolio found',
		'not_found_in_trash' => 'No Portfolio found in Trash',
		'parent_item_colon' => '',
		'menu_name' => 'Portfolio'
	);
	$bizzbeepro_args = array(
		'labels' => $bizzbeepro_labels,
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'query_var' => true,
		'rewrite' => array( 'slug' => 'portfolios' ),
		'capability_type' => 'post',
		'has_archive' => true,
		'hierarchical' => false,
		'menu_position' => null,
		'supports' => array( 'title', 'editor', 'thumbnail' ),
	);
	register_post_type( 'portfolio', $bizzbeepro_args );
}
add_action( 'init', 'bizzbeepro_portfolio_custom_init' );
/***** End Portfolio *****/

add_action('admin_menu', 'bizzbeepro_menu');
function bizzbeepro_menu() {
add_theme_page( __('Bizzbee Pro Documentation','bizzbeepro'), __('Bizzbee Pro Documentation','bizzbeepro'), 'manage_options', 'bizzbeepro-documentation', 'bizzbeepro_documentation', 300 ); 
add_theme_page( __('Bizzbee Pro Support','bizzbeepro'), __('Bizzbee Pro Support','bizzbeepro'), 'manage_options', 'bizzbeepro-support', 'bizzbeepro_support', 400 );    
}
function bizzbeepro_support() { ?>
<script>window.location = "https://fasterthemes.com/support/";</script>
<?php }
function bizzbeepro_documentation() { ?>
        <script>window.location = "http://kbfruit.fasterthemes.com/bizzbee-pro-documentation/";</script>
<?php }
?>
