/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@remix-run/router/dist/router.js":
/*!*******************************************************!*\
  !*** ./node_modules/@remix-run/router/dist/router.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* binding */ AbortedDeferredError),
/* harmony export */   Action: () => (/* binding */ Action),
/* harmony export */   IDLE_BLOCKER: () => (/* binding */ IDLE_BLOCKER),
/* harmony export */   IDLE_FETCHER: () => (/* binding */ IDLE_FETCHER),
/* harmony export */   IDLE_NAVIGATION: () => (/* binding */ IDLE_NAVIGATION),
/* harmony export */   UNSAFE_DEFERRED_SYMBOL: () => (/* binding */ UNSAFE_DEFERRED_SYMBOL),
/* harmony export */   UNSAFE_DeferredData: () => (/* binding */ DeferredData),
/* harmony export */   UNSAFE_ErrorResponseImpl: () => (/* binding */ ErrorResponseImpl),
/* harmony export */   UNSAFE_convertRouteMatchToUiMatch: () => (/* binding */ convertRouteMatchToUiMatch),
/* harmony export */   UNSAFE_convertRoutesToDataRoutes: () => (/* binding */ convertRoutesToDataRoutes),
/* harmony export */   UNSAFE_decodePath: () => (/* binding */ decodePath),
/* harmony export */   UNSAFE_getResolveToMatches: () => (/* binding */ getResolveToMatches),
/* harmony export */   UNSAFE_invariant: () => (/* binding */ invariant),
/* harmony export */   UNSAFE_warning: () => (/* binding */ warning),
/* harmony export */   createBrowserHistory: () => (/* binding */ createBrowserHistory),
/* harmony export */   createHashHistory: () => (/* binding */ createHashHistory),
/* harmony export */   createMemoryHistory: () => (/* binding */ createMemoryHistory),
/* harmony export */   createPath: () => (/* binding */ createPath),
/* harmony export */   createRouter: () => (/* binding */ createRouter),
/* harmony export */   createStaticHandler: () => (/* binding */ createStaticHandler),
/* harmony export */   data: () => (/* binding */ data),
/* harmony export */   defer: () => (/* binding */ defer),
/* harmony export */   generatePath: () => (/* binding */ generatePath),
/* harmony export */   getStaticContextFromError: () => (/* binding */ getStaticContextFromError),
/* harmony export */   getToPathname: () => (/* binding */ getToPathname),
/* harmony export */   isDataWithResponseInit: () => (/* binding */ isDataWithResponseInit),
/* harmony export */   isDeferredData: () => (/* binding */ isDeferredData),
/* harmony export */   isRouteErrorResponse: () => (/* binding */ isRouteErrorResponse),
/* harmony export */   joinPaths: () => (/* binding */ joinPaths),
/* harmony export */   json: () => (/* binding */ json),
/* harmony export */   matchPath: () => (/* binding */ matchPath),
/* harmony export */   matchRoutes: () => (/* binding */ matchRoutes),
/* harmony export */   normalizePathname: () => (/* binding */ normalizePathname),
/* harmony export */   parsePath: () => (/* binding */ parsePath),
/* harmony export */   redirect: () => (/* binding */ redirect),
/* harmony export */   redirectDocument: () => (/* binding */ redirectDocument),
/* harmony export */   replace: () => (/* binding */ replace),
/* harmony export */   resolvePath: () => (/* binding */ resolvePath),
/* harmony export */   resolveTo: () => (/* binding */ resolveTo),
/* harmony export */   stripBasename: () => (/* binding */ stripBasename)
/* harmony export */ });
/**
 * @remix-run/router v1.21.0
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

////////////////////////////////////////////////////////////////////////////////
//#region Types and Constants
////////////////////////////////////////////////////////////////////////////////
/**
 * Actions represent the type of change to a location value.
 */
var Action;
(function (Action) {
  /**
   * A POP indicates a change to an arbitrary index in the history stack, such
   * as a back or forward navigation. It does not describe the direction of the
   * navigation, only that the current index changed.
   *
   * Note: This is the default action for newly created history objects.
   */
  Action["Pop"] = "POP";
  /**
   * A PUSH indicates a new entry being added to the history stack, such as when
   * a link is clicked and a new page loads. When this happens, all subsequent
   * entries in the stack are lost.
   */
  Action["Push"] = "PUSH";
  /**
   * A REPLACE indicates the entry at the current index in the history stack
   * being replaced by a new one.
   */
  Action["Replace"] = "REPLACE";
})(Action || (Action = {}));
const PopStateEventType = "popstate";
/**
 * Memory history stores the current location in memory. It is designed for use
 * in stateful non-browser environments like tests and React Native.
 */
function createMemoryHistory(options) {
  if (options === void 0) {
    options = {};
  }
  let {
    initialEntries = ["/"],
    initialIndex,
    v5Compat = false
  } = options;
  let entries; // Declare so we can access from createMemoryLocation
  entries = initialEntries.map((entry, index) => createMemoryLocation(entry, typeof entry === "string" ? null : entry.state, index === 0 ? "default" : undefined));
  let index = clampIndex(initialIndex == null ? entries.length - 1 : initialIndex);
  let action = Action.Pop;
  let listener = null;
  function clampIndex(n) {
    return Math.min(Math.max(n, 0), entries.length - 1);
  }
  function getCurrentLocation() {
    return entries[index];
  }
  function createMemoryLocation(to, state, key) {
    if (state === void 0) {
      state = null;
    }
    let location = createLocation(entries ? getCurrentLocation().pathname : "/", to, state, key);
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in memory history: " + JSON.stringify(to));
    return location;
  }
  function createHref(to) {
    return typeof to === "string" ? to : createPath(to);
  }
  let history = {
    get index() {
      return index;
    },
    get action() {
      return action;
    },
    get location() {
      return getCurrentLocation();
    },
    createHref,
    createURL(to) {
      return new URL(createHref(to), "http://localhost");
    },
    encodeLocation(to) {
      let path = typeof to === "string" ? parsePath(to) : to;
      return {
        pathname: path.pathname || "",
        search: path.search || "",
        hash: path.hash || ""
      };
    },
    push(to, state) {
      action = Action.Push;
      let nextLocation = createMemoryLocation(to, state);
      index += 1;
      entries.splice(index, entries.length, nextLocation);
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 1
        });
      }
    },
    replace(to, state) {
      action = Action.Replace;
      let nextLocation = createMemoryLocation(to, state);
      entries[index] = nextLocation;
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 0
        });
      }
    },
    go(delta) {
      action = Action.Pop;
      let nextIndex = clampIndex(index + delta);
      let nextLocation = entries[nextIndex];
      index = nextIndex;
      if (listener) {
        listener({
          action,
          location: nextLocation,
          delta
        });
      }
    },
    listen(fn) {
      listener = fn;
      return () => {
        listener = null;
      };
    }
  };
  return history;
}
/**
 * Browser history stores the location in regular URLs. This is the standard for
 * most web apps, but it requires some configuration on the server to ensure you
 * serve the same app at multiple URLs.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createbrowserhistory
 */
function createBrowserHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createBrowserLocation(window, globalHistory) {
    let {
      pathname,
      search,
      hash
    } = window.location;
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createBrowserHref(window, to) {
    return typeof to === "string" ? to : createPath(to);
  }
  return getUrlBasedHistory(createBrowserLocation, createBrowserHref, null, options);
}
/**
 * Hash history stores the location in window.location.hash. This makes it ideal
 * for situations where you don't want to send the location to the server for
 * some reason, either because you do cannot configure it or the URL space is
 * reserved for something else.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createhashhistory
 */
function createHashHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createHashLocation(window, globalHistory) {
    let {
      pathname = "/",
      search = "",
      hash = ""
    } = parsePath(window.location.hash.substr(1));
    // Hash URL should always have a leading / just like window.location.pathname
    // does, so if an app ends up at a route like /#something then we add a
    // leading slash so all of our path-matching behaves the same as if it would
    // in a browser router.  This is particularly important when there exists a
    // root splat route (<Route path="*">) since that matches internally against
    // "/*" and we'd expect /#something to 404 in a hash router app.
    if (!pathname.startsWith("/") && !pathname.startsWith(".")) {
      pathname = "/" + pathname;
    }
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createHashHref(window, to) {
    let base = window.document.querySelector("base");
    let href = "";
    if (base && base.getAttribute("href")) {
      let url = window.location.href;
      let hashIndex = url.indexOf("#");
      href = hashIndex === -1 ? url : url.slice(0, hashIndex);
    }
    return href + "#" + (typeof to === "string" ? to : createPath(to));
  }
  function validateHashLocation(location, to) {
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in hash history.push(" + JSON.stringify(to) + ")");
  }
  return getUrlBasedHistory(createHashLocation, createHashHref, validateHashLocation, options);
}
function invariant(value, message) {
  if (value === false || value === null || typeof value === "undefined") {
    throw new Error(message);
  }
}
function warning(cond, message) {
  if (!cond) {
    // eslint-disable-next-line no-console
    if (typeof console !== "undefined") console.warn(message);
    try {
      // Welcome to debugging history!
      //
      // This error is thrown as a convenience, so you can more easily
      // find the source for a warning that appears in the console by
      // enabling "pause on exceptions" in your JavaScript debugger.
      throw new Error(message);
      // eslint-disable-next-line no-empty
    } catch (e) {}
  }
}
function createKey() {
  return Math.random().toString(36).substr(2, 8);
}
/**
 * For browser-based histories, we combine the state and key into an object
 */
function getHistoryState(location, index) {
  return {
    usr: location.state,
    key: location.key,
    idx: index
  };
}
/**
 * Creates a Location object with a unique key from the given Path
 */
function createLocation(current, to, state, key) {
  if (state === void 0) {
    state = null;
  }
  let location = _extends({
    pathname: typeof current === "string" ? current : current.pathname,
    search: "",
    hash: ""
  }, typeof to === "string" ? parsePath(to) : to, {
    state,
    // TODO: This could be cleaned up.  push/replace should probably just take
    // full Locations now and avoid the need to run through this flow at all
    // But that's a pretty big refactor to the current test suite so going to
    // keep as is for the time being and just let any incoming keys take precedence
    key: to && to.key || key || createKey()
  });
  return location;
}
/**
 * Creates a string URL path from the given pathname, search, and hash components.
 */
function createPath(_ref) {
  let {
    pathname = "/",
    search = "",
    hash = ""
  } = _ref;
  if (search && search !== "?") pathname += search.charAt(0) === "?" ? search : "?" + search;
  if (hash && hash !== "#") pathname += hash.charAt(0) === "#" ? hash : "#" + hash;
  return pathname;
}
/**
 * Parses a string URL path into its separate pathname, search, and hash components.
 */
function parsePath(path) {
  let parsedPath = {};
  if (path) {
    let hashIndex = path.indexOf("#");
    if (hashIndex >= 0) {
      parsedPath.hash = path.substr(hashIndex);
      path = path.substr(0, hashIndex);
    }
    let searchIndex = path.indexOf("?");
    if (searchIndex >= 0) {
      parsedPath.search = path.substr(searchIndex);
      path = path.substr(0, searchIndex);
    }
    if (path) {
      parsedPath.pathname = path;
    }
  }
  return parsedPath;
}
function getUrlBasedHistory(getLocation, createHref, validateLocation, options) {
  if (options === void 0) {
    options = {};
  }
  let {
    window = document.defaultView,
    v5Compat = false
  } = options;
  let globalHistory = window.history;
  let action = Action.Pop;
  let listener = null;
  let index = getIndex();
  // Index should only be null when we initialize. If not, it's because the
  // user called history.pushState or history.replaceState directly, in which
  // case we should log a warning as it will result in bugs.
  if (index == null) {
    index = 0;
    globalHistory.replaceState(_extends({}, globalHistory.state, {
      idx: index
    }), "");
  }
  function getIndex() {
    let state = globalHistory.state || {
      idx: null
    };
    return state.idx;
  }
  function handlePop() {
    action = Action.Pop;
    let nextIndex = getIndex();
    let delta = nextIndex == null ? null : nextIndex - index;
    index = nextIndex;
    if (listener) {
      listener({
        action,
        location: history.location,
        delta
      });
    }
  }
  function push(to, state) {
    action = Action.Push;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex() + 1;
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    // try...catch because iOS limits us to 100 pushState calls :/
    try {
      globalHistory.pushState(historyState, "", url);
    } catch (error) {
      // If the exception is because `state` can't be serialized, let that throw
      // outwards just like a replace call would so the dev knows the cause
      // https://html.spec.whatwg.org/multipage/nav-history-apis.html#shared-history-push/replace-state-steps
      // https://html.spec.whatwg.org/multipage/structured-data.html#structuredserializeinternal
      if (error instanceof DOMException && error.name === "DataCloneError") {
        throw error;
      }
      // They are going to lose state here, but there is no real
      // way to warn them about it since the page will refresh...
      window.location.assign(url);
    }
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 1
      });
    }
  }
  function replace(to, state) {
    action = Action.Replace;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex();
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    globalHistory.replaceState(historyState, "", url);
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 0
      });
    }
  }
  function createURL(to) {
    // window.location.origin is "null" (the literal string value) in Firefox
    // under certain conditions, notably when serving from a local HTML file
    // See https://bugzilla.mozilla.org/show_bug.cgi?id=878297
    let base = window.location.origin !== "null" ? window.location.origin : window.location.href;
    let href = typeof to === "string" ? to : createPath(to);
    // Treating this as a full URL will strip any trailing spaces so we need to
    // pre-encode them since they might be part of a matching splat param from
    // an ancestor route
    href = href.replace(/ $/, "%20");
    invariant(base, "No window.location.(origin|href) available to create URL for href: " + href);
    return new URL(href, base);
  }
  let history = {
    get action() {
      return action;
    },
    get location() {
      return getLocation(window, globalHistory);
    },
    listen(fn) {
      if (listener) {
        throw new Error("A history only accepts one active listener");
      }
      window.addEventListener(PopStateEventType, handlePop);
      listener = fn;
      return () => {
        window.removeEventListener(PopStateEventType, handlePop);
        listener = null;
      };
    },
    createHref(to) {
      return createHref(window, to);
    },
    createURL,
    encodeLocation(to) {
      // Encode a Location the same way window.location would
      let url = createURL(to);
      return {
        pathname: url.pathname,
        search: url.search,
        hash: url.hash
      };
    },
    push,
    replace,
    go(n) {
      return globalHistory.go(n);
    }
  };
  return history;
}
//#endregion

var ResultType;
(function (ResultType) {
  ResultType["data"] = "data";
  ResultType["deferred"] = "deferred";
  ResultType["redirect"] = "redirect";
  ResultType["error"] = "error";
})(ResultType || (ResultType = {}));
const immutableRouteKeys = new Set(["lazy", "caseSensitive", "path", "id", "index", "children"]);
function isIndexRoute(route) {
  return route.index === true;
}
// Walk the route tree generating unique IDs where necessary, so we are working
// solely with AgnosticDataRouteObject's within the Router
function convertRoutesToDataRoutes(routes, mapRouteProperties, parentPath, manifest) {
  if (parentPath === void 0) {
    parentPath = [];
  }
  if (manifest === void 0) {
    manifest = {};
  }
  return routes.map((route, index) => {
    let treePath = [...parentPath, String(index)];
    let id = typeof route.id === "string" ? route.id : treePath.join("-");
    invariant(route.index !== true || !route.children, "Cannot specify children on an index route");
    invariant(!manifest[id], "Found a route id collision on id \"" + id + "\".  Route " + "id's must be globally unique within Data Router usages");
    if (isIndexRoute(route)) {
      let indexRoute = _extends({}, route, mapRouteProperties(route), {
        id
      });
      manifest[id] = indexRoute;
      return indexRoute;
    } else {
      let pathOrLayoutRoute = _extends({}, route, mapRouteProperties(route), {
        id,
        children: undefined
      });
      manifest[id] = pathOrLayoutRoute;
      if (route.children) {
        pathOrLayoutRoute.children = convertRoutesToDataRoutes(route.children, mapRouteProperties, treePath, manifest);
      }
      return pathOrLayoutRoute;
    }
  });
}
/**
 * Matches the given routes to a location and returns the match data.
 *
 * @see https://reactrouter.com/v6/utils/match-routes
 */
function matchRoutes(routes, locationArg, basename) {
  if (basename === void 0) {
    basename = "/";
  }
  return matchRoutesImpl(routes, locationArg, basename, false);
}
function matchRoutesImpl(routes, locationArg, basename, allowPartial) {
  let location = typeof locationArg === "string" ? parsePath(locationArg) : locationArg;
  let pathname = stripBasename(location.pathname || "/", basename);
  if (pathname == null) {
    return null;
  }
  let branches = flattenRoutes(routes);
  rankRouteBranches(branches);
  let matches = null;
  for (let i = 0; matches == null && i < branches.length; ++i) {
    // Incoming pathnames are generally encoded from either window.location
    // or from router.navigate, but we want to match against the unencoded
    // paths in the route definitions.  Memory router locations won't be
    // encoded here but there also shouldn't be anything to decode so this
    // should be a safe operation.  This avoids needing matchRoutes to be
    // history-aware.
    let decoded = decodePath(pathname);
    matches = matchRouteBranch(branches[i], decoded, allowPartial);
  }
  return matches;
}
function convertRouteMatchToUiMatch(match, loaderData) {
  let {
    route,
    pathname,
    params
  } = match;
  return {
    id: route.id,
    pathname,
    params,
    data: loaderData[route.id],
    handle: route.handle
  };
}
function flattenRoutes(routes, branches, parentsMeta, parentPath) {
  if (branches === void 0) {
    branches = [];
  }
  if (parentsMeta === void 0) {
    parentsMeta = [];
  }
  if (parentPath === void 0) {
    parentPath = "";
  }
  let flattenRoute = (route, index, relativePath) => {
    let meta = {
      relativePath: relativePath === undefined ? route.path || "" : relativePath,
      caseSensitive: route.caseSensitive === true,
      childrenIndex: index,
      route
    };
    if (meta.relativePath.startsWith("/")) {
      invariant(meta.relativePath.startsWith(parentPath), "Absolute route path \"" + meta.relativePath + "\" nested under path " + ("\"" + parentPath + "\" is not valid. An absolute child route path ") + "must start with the combined path of all its parent routes.");
      meta.relativePath = meta.relativePath.slice(parentPath.length);
    }
    let path = joinPaths([parentPath, meta.relativePath]);
    let routesMeta = parentsMeta.concat(meta);
    // Add the children before adding this route to the array, so we traverse the
    // route tree depth-first and child routes appear before their parents in
    // the "flattened" version.
    if (route.children && route.children.length > 0) {
      invariant(
      // Our types know better, but runtime JS may not!
      // @ts-expect-error
      route.index !== true, "Index routes must not have child routes. Please remove " + ("all child routes from route path \"" + path + "\"."));
      flattenRoutes(route.children, branches, routesMeta, path);
    }
    // Routes without a path shouldn't ever match by themselves unless they are
    // index routes, so don't add them to the list of possible branches.
    if (route.path == null && !route.index) {
      return;
    }
    branches.push({
      path,
      score: computeScore(path, route.index),
      routesMeta
    });
  };
  routes.forEach((route, index) => {
    var _route$path;
    // coarse-grain check for optional params
    if (route.path === "" || !((_route$path = route.path) != null && _route$path.includes("?"))) {
      flattenRoute(route, index);
    } else {
      for (let exploded of explodeOptionalSegments(route.path)) {
        flattenRoute(route, index, exploded);
      }
    }
  });
  return branches;
}
/**
 * Computes all combinations of optional path segments for a given path,
 * excluding combinations that are ambiguous and of lower priority.
 *
 * For example, `/one/:two?/three/:four?/:five?` explodes to:
 * - `/one/three`
 * - `/one/:two/three`
 * - `/one/three/:four`
 * - `/one/three/:five`
 * - `/one/:two/three/:four`
 * - `/one/:two/three/:five`
 * - `/one/three/:four/:five`
 * - `/one/:two/three/:four/:five`
 */
function explodeOptionalSegments(path) {
  let segments = path.split("/");
  if (segments.length === 0) return [];
  let [first, ...rest] = segments;
  // Optional path segments are denoted by a trailing `?`
  let isOptional = first.endsWith("?");
  // Compute the corresponding required segment: `foo?` -> `foo`
  let required = first.replace(/\?$/, "");
  if (rest.length === 0) {
    // Intepret empty string as omitting an optional segment
    // `["one", "", "three"]` corresponds to omitting `:two` from `/one/:two?/three` -> `/one/three`
    return isOptional ? [required, ""] : [required];
  }
  let restExploded = explodeOptionalSegments(rest.join("/"));
  let result = [];
  // All child paths with the prefix.  Do this for all children before the
  // optional version for all children, so we get consistent ordering where the
  // parent optional aspect is preferred as required.  Otherwise, we can get
  // child sections interspersed where deeper optional segments are higher than
  // parent optional segments, where for example, /:two would explode _earlier_
  // then /:one.  By always including the parent as required _for all children_
  // first, we avoid this issue
  result.push(...restExploded.map(subpath => subpath === "" ? required : [required, subpath].join("/")));
  // Then, if this is an optional value, add all child versions without
  if (isOptional) {
    result.push(...restExploded);
  }
  // for absolute paths, ensure `/` instead of empty segment
  return result.map(exploded => path.startsWith("/") && exploded === "" ? "/" : exploded);
}
function rankRouteBranches(branches) {
  branches.sort((a, b) => a.score !== b.score ? b.score - a.score // Higher score first
  : compareIndexes(a.routesMeta.map(meta => meta.childrenIndex), b.routesMeta.map(meta => meta.childrenIndex)));
}
const paramRe = /^:[\w-]+$/;
const dynamicSegmentValue = 3;
const indexRouteValue = 2;
const emptySegmentValue = 1;
const staticSegmentValue = 10;
const splatPenalty = -2;
const isSplat = s => s === "*";
function computeScore(path, index) {
  let segments = path.split("/");
  let initialScore = segments.length;
  if (segments.some(isSplat)) {
    initialScore += splatPenalty;
  }
  if (index) {
    initialScore += indexRouteValue;
  }
  return segments.filter(s => !isSplat(s)).reduce((score, segment) => score + (paramRe.test(segment) ? dynamicSegmentValue : segment === "" ? emptySegmentValue : staticSegmentValue), initialScore);
}
function compareIndexes(a, b) {
  let siblings = a.length === b.length && a.slice(0, -1).every((n, i) => n === b[i]);
  return siblings ?
  // If two routes are siblings, we should try to match the earlier sibling
  // first. This allows people to have fine-grained control over the matching
  // behavior by simply putting routes with identical paths in the order they
  // want them tried.
  a[a.length - 1] - b[b.length - 1] :
  // Otherwise, it doesn't really make sense to rank non-siblings by index,
  // so they sort equally.
  0;
}
function matchRouteBranch(branch, pathname, allowPartial) {
  if (allowPartial === void 0) {
    allowPartial = false;
  }
  let {
    routesMeta
  } = branch;
  let matchedParams = {};
  let matchedPathname = "/";
  let matches = [];
  for (let i = 0; i < routesMeta.length; ++i) {
    let meta = routesMeta[i];
    let end = i === routesMeta.length - 1;
    let remainingPathname = matchedPathname === "/" ? pathname : pathname.slice(matchedPathname.length) || "/";
    let match = matchPath({
      path: meta.relativePath,
      caseSensitive: meta.caseSensitive,
      end
    }, remainingPathname);
    let route = meta.route;
    if (!match && end && allowPartial && !routesMeta[routesMeta.length - 1].route.index) {
      match = matchPath({
        path: meta.relativePath,
        caseSensitive: meta.caseSensitive,
        end: false
      }, remainingPathname);
    }
    if (!match) {
      return null;
    }
    Object.assign(matchedParams, match.params);
    matches.push({
      // TODO: Can this as be avoided?
      params: matchedParams,
      pathname: joinPaths([matchedPathname, match.pathname]),
      pathnameBase: normalizePathname(joinPaths([matchedPathname, match.pathnameBase])),
      route
    });
    if (match.pathnameBase !== "/") {
      matchedPathname = joinPaths([matchedPathname, match.pathnameBase]);
    }
  }
  return matches;
}
/**
 * Returns a path with params interpolated.
 *
 * @see https://reactrouter.com/v6/utils/generate-path
 */
function generatePath(originalPath, params) {
  if (params === void 0) {
    params = {};
  }
  let path = originalPath;
  if (path.endsWith("*") && path !== "*" && !path.endsWith("/*")) {
    warning(false, "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
    path = path.replace(/\*$/, "/*");
  }
  // ensure `/` is added at the beginning if the path is absolute
  const prefix = path.startsWith("/") ? "/" : "";
  const stringify = p => p == null ? "" : typeof p === "string" ? p : String(p);
  const segments = path.split(/\/+/).map((segment, index, array) => {
    const isLastSegment = index === array.length - 1;
    // only apply the splat if it's the last segment
    if (isLastSegment && segment === "*") {
      const star = "*";
      // Apply the splat
      return stringify(params[star]);
    }
    const keyMatch = segment.match(/^:([\w-]+)(\??)$/);
    if (keyMatch) {
      const [, key, optional] = keyMatch;
      let param = params[key];
      invariant(optional === "?" || param != null, "Missing \":" + key + "\" param");
      return stringify(param);
    }
    // Remove any optional markers from optional static segments
    return segment.replace(/\?$/g, "");
  })
  // Remove empty segments
  .filter(segment => !!segment);
  return prefix + segments.join("/");
}
/**
 * Performs pattern matching on a URL pathname and returns information about
 * the match.
 *
 * @see https://reactrouter.com/v6/utils/match-path
 */
function matchPath(pattern, pathname) {
  if (typeof pattern === "string") {
    pattern = {
      path: pattern,
      caseSensitive: false,
      end: true
    };
  }
  let [matcher, compiledParams] = compilePath(pattern.path, pattern.caseSensitive, pattern.end);
  let match = pathname.match(matcher);
  if (!match) return null;
  let matchedPathname = match[0];
  let pathnameBase = matchedPathname.replace(/(.)\/+$/, "$1");
  let captureGroups = match.slice(1);
  let params = compiledParams.reduce((memo, _ref, index) => {
    let {
      paramName,
      isOptional
    } = _ref;
    // We need to compute the pathnameBase here using the raw splat value
    // instead of using params["*"] later because it will be decoded then
    if (paramName === "*") {
      let splatValue = captureGroups[index] || "";
      pathnameBase = matchedPathname.slice(0, matchedPathname.length - splatValue.length).replace(/(.)\/+$/, "$1");
    }
    const value = captureGroups[index];
    if (isOptional && !value) {
      memo[paramName] = undefined;
    } else {
      memo[paramName] = (value || "").replace(/%2F/g, "/");
    }
    return memo;
  }, {});
  return {
    params,
    pathname: matchedPathname,
    pathnameBase,
    pattern
  };
}
function compilePath(path, caseSensitive, end) {
  if (caseSensitive === void 0) {
    caseSensitive = false;
  }
  if (end === void 0) {
    end = true;
  }
  warning(path === "*" || !path.endsWith("*") || path.endsWith("/*"), "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
  let params = [];
  let regexpSource = "^" + path.replace(/\/*\*?$/, "") // Ignore trailing / and /*, we'll handle it below
  .replace(/^\/*/, "/") // Make sure it has a leading /
  .replace(/[\\.*+^${}|()[\]]/g, "\\$&") // Escape special regex chars
  .replace(/\/:([\w-]+)(\?)?/g, (_, paramName, isOptional) => {
    params.push({
      paramName,
      isOptional: isOptional != null
    });
    return isOptional ? "/?([^\\/]+)?" : "/([^\\/]+)";
  });
  if (path.endsWith("*")) {
    params.push({
      paramName: "*"
    });
    regexpSource += path === "*" || path === "/*" ? "(.*)$" // Already matched the initial /, just match the rest
    : "(?:\\/(.+)|\\/*)$"; // Don't include the / in params["*"]
  } else if (end) {
    // When matching to the end, ignore trailing slashes
    regexpSource += "\\/*$";
  } else if (path !== "" && path !== "/") {
    // If our path is non-empty and contains anything beyond an initial slash,
    // then we have _some_ form of path in our regex, so we should expect to
    // match only if we find the end of this path segment.  Look for an optional
    // non-captured trailing slash (to match a portion of the URL) or the end
    // of the path (if we've matched to the end).  We used to do this with a
    // word boundary but that gives false positives on routes like
    // /user-preferences since `-` counts as a word boundary.
    regexpSource += "(?:(?=\\/|$))";
  } else ;
  let matcher = new RegExp(regexpSource, caseSensitive ? undefined : "i");
  return [matcher, params];
}
function decodePath(value) {
  try {
    return value.split("/").map(v => decodeURIComponent(v).replace(/\//g, "%2F")).join("/");
  } catch (error) {
    warning(false, "The URL path \"" + value + "\" could not be decoded because it is is a " + "malformed URL segment. This is probably due to a bad percent " + ("encoding (" + error + ")."));
    return value;
  }
}
/**
 * @private
 */
function stripBasename(pathname, basename) {
  if (basename === "/") return pathname;
  if (!pathname.toLowerCase().startsWith(basename.toLowerCase())) {
    return null;
  }
  // We want to leave trailing slash behavior in the user's control, so if they
  // specify a basename with a trailing slash, we should support it
  let startIndex = basename.endsWith("/") ? basename.length - 1 : basename.length;
  let nextChar = pathname.charAt(startIndex);
  if (nextChar && nextChar !== "/") {
    // pathname does not start with basename/
    return null;
  }
  return pathname.slice(startIndex) || "/";
}
/**
 * Returns a resolved path object relative to the given pathname.
 *
 * @see https://reactrouter.com/v6/utils/resolve-path
 */
function resolvePath(to, fromPathname) {
  if (fromPathname === void 0) {
    fromPathname = "/";
  }
  let {
    pathname: toPathname,
    search = "",
    hash = ""
  } = typeof to === "string" ? parsePath(to) : to;
  let pathname = toPathname ? toPathname.startsWith("/") ? toPathname : resolvePathname(toPathname, fromPathname) : fromPathname;
  return {
    pathname,
    search: normalizeSearch(search),
    hash: normalizeHash(hash)
  };
}
function resolvePathname(relativePath, fromPathname) {
  let segments = fromPathname.replace(/\/+$/, "").split("/");
  let relativeSegments = relativePath.split("/");
  relativeSegments.forEach(segment => {
    if (segment === "..") {
      // Keep the root "" segment so the pathname starts at /
      if (segments.length > 1) segments.pop();
    } else if (segment !== ".") {
      segments.push(segment);
    }
  });
  return segments.length > 1 ? segments.join("/") : "/";
}
function getInvalidPathError(char, field, dest, path) {
  return "Cannot include a '" + char + "' character in a manually specified " + ("`to." + field + "` field [" + JSON.stringify(path) + "].  Please separate it out to the ") + ("`to." + dest + "` field. Alternatively you may provide the full path as ") + "a string in <Link to=\"...\"> and the router will parse it for you.";
}
/**
 * @private
 *
 * When processing relative navigation we want to ignore ancestor routes that
 * do not contribute to the path, such that index/pathless layout routes don't
 * interfere.
 *
 * For example, when moving a route element into an index route and/or a
 * pathless layout route, relative link behavior contained within should stay
 * the same.  Both of the following examples should link back to the root:
 *
 *   <Route path="/">
 *     <Route path="accounts" element={<Link to=".."}>
 *   </Route>
 *
 *   <Route path="/">
 *     <Route path="accounts">
 *       <Route element={<AccountsLayout />}>       // <-- Does not contribute
 *         <Route index element={<Link to=".."} />  // <-- Does not contribute
 *       </Route
 *     </Route>
 *   </Route>
 */
function getPathContributingMatches(matches) {
  return matches.filter((match, index) => index === 0 || match.route.path && match.route.path.length > 0);
}
// Return the array of pathnames for the current route matches - used to
// generate the routePathnames input for resolveTo()
function getResolveToMatches(matches, v7_relativeSplatPath) {
  let pathMatches = getPathContributingMatches(matches);
  // When v7_relativeSplatPath is enabled, use the full pathname for the leaf
  // match so we include splat values for "." links.  See:
  // https://github.com/remix-run/react-router/issues/11052#issuecomment-1836589329
  if (v7_relativeSplatPath) {
    return pathMatches.map((match, idx) => idx === pathMatches.length - 1 ? match.pathname : match.pathnameBase);
  }
  return pathMatches.map(match => match.pathnameBase);
}
/**
 * @private
 */
function resolveTo(toArg, routePathnames, locationPathname, isPathRelative) {
  if (isPathRelative === void 0) {
    isPathRelative = false;
  }
  let to;
  if (typeof toArg === "string") {
    to = parsePath(toArg);
  } else {
    to = _extends({}, toArg);
    invariant(!to.pathname || !to.pathname.includes("?"), getInvalidPathError("?", "pathname", "search", to));
    invariant(!to.pathname || !to.pathname.includes("#"), getInvalidPathError("#", "pathname", "hash", to));
    invariant(!to.search || !to.search.includes("#"), getInvalidPathError("#", "search", "hash", to));
  }
  let isEmptyPath = toArg === "" || to.pathname === "";
  let toPathname = isEmptyPath ? "/" : to.pathname;
  let from;
  // Routing is relative to the current pathname if explicitly requested.
  //
  // If a pathname is explicitly provided in `to`, it should be relative to the
  // route context. This is explained in `Note on `<Link to>` values` in our
  // migration guide from v5 as a means of disambiguation between `to` values
  // that begin with `/` and those that do not. However, this is problematic for
  // `to` values that do not provide a pathname. `to` can simply be a search or
  // hash string, in which case we should assume that the navigation is relative
  // to the current location's pathname and *not* the route pathname.
  if (toPathname == null) {
    from = locationPathname;
  } else {
    let routePathnameIndex = routePathnames.length - 1;
    // With relative="route" (the default), each leading .. segment means
    // "go up one route" instead of "go up one URL segment".  This is a key
    // difference from how <a href> works and a major reason we call this a
    // "to" value instead of a "href".
    if (!isPathRelative && toPathname.startsWith("..")) {
      let toSegments = toPathname.split("/");
      while (toSegments[0] === "..") {
        toSegments.shift();
        routePathnameIndex -= 1;
      }
      to.pathname = toSegments.join("/");
    }
    from = routePathnameIndex >= 0 ? routePathnames[routePathnameIndex] : "/";
  }
  let path = resolvePath(to, from);
  // Ensure the pathname has a trailing slash if the original "to" had one
  let hasExplicitTrailingSlash = toPathname && toPathname !== "/" && toPathname.endsWith("/");
  // Or if this was a link to the current path which has a trailing slash
  let hasCurrentTrailingSlash = (isEmptyPath || toPathname === ".") && locationPathname.endsWith("/");
  if (!path.pathname.endsWith("/") && (hasExplicitTrailingSlash || hasCurrentTrailingSlash)) {
    path.pathname += "/";
  }
  return path;
}
/**
 * @private
 */
function getToPathname(to) {
  // Empty strings should be treated the same as / paths
  return to === "" || to.pathname === "" ? "/" : typeof to === "string" ? parsePath(to).pathname : to.pathname;
}
/**
 * @private
 */
const joinPaths = paths => paths.join("/").replace(/\/\/+/g, "/");
/**
 * @private
 */
const normalizePathname = pathname => pathname.replace(/\/+$/, "").replace(/^\/*/, "/");
/**
 * @private
 */
const normalizeSearch = search => !search || search === "?" ? "" : search.startsWith("?") ? search : "?" + search;
/**
 * @private
 */
const normalizeHash = hash => !hash || hash === "#" ? "" : hash.startsWith("#") ? hash : "#" + hash;
/**
 * This is a shortcut for creating `application/json` responses. Converts `data`
 * to JSON and sets the `Content-Type` header.
 *
 * @deprecated The `json` method is deprecated in favor of returning raw objects.
 * This method will be removed in v7.
 */
const json = function json(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  let headers = new Headers(responseInit.headers);
  if (!headers.has("Content-Type")) {
    headers.set("Content-Type", "application/json; charset=utf-8");
  }
  return new Response(JSON.stringify(data), _extends({}, responseInit, {
    headers
  }));
};
class DataWithResponseInit {
  constructor(data, init) {
    this.type = "DataWithResponseInit";
    this.data = data;
    this.init = init || null;
  }
}
/**
 * Create "responses" that contain `status`/`headers` without forcing
 * serialization into an actual `Response` - used by Remix single fetch
 */
function data(data, init) {
  return new DataWithResponseInit(data, typeof init === "number" ? {
    status: init
  } : init);
}
class AbortedDeferredError extends Error {}
class DeferredData {
  constructor(data, responseInit) {
    this.pendingKeysSet = new Set();
    this.subscribers = new Set();
    this.deferredKeys = [];
    invariant(data && typeof data === "object" && !Array.isArray(data), "defer() only accepts plain objects");
    // Set up an AbortController + Promise we can race against to exit early
    // cancellation
    let reject;
    this.abortPromise = new Promise((_, r) => reject = r);
    this.controller = new AbortController();
    let onAbort = () => reject(new AbortedDeferredError("Deferred data aborted"));
    this.unlistenAbortSignal = () => this.controller.signal.removeEventListener("abort", onAbort);
    this.controller.signal.addEventListener("abort", onAbort);
    this.data = Object.entries(data).reduce((acc, _ref2) => {
      let [key, value] = _ref2;
      return Object.assign(acc, {
        [key]: this.trackPromise(key, value)
      });
    }, {});
    if (this.done) {
      // All incoming values were resolved
      this.unlistenAbortSignal();
    }
    this.init = responseInit;
  }
  trackPromise(key, value) {
    if (!(value instanceof Promise)) {
      return value;
    }
    this.deferredKeys.push(key);
    this.pendingKeysSet.add(key);
    // We store a little wrapper promise that will be extended with
    // _data/_error props upon resolve/reject
    let promise = Promise.race([value, this.abortPromise]).then(data => this.onSettle(promise, key, undefined, data), error => this.onSettle(promise, key, error));
    // Register rejection listeners to avoid uncaught promise rejections on
    // errors or aborted deferred values
    promise.catch(() => {});
    Object.defineProperty(promise, "_tracked", {
      get: () => true
    });
    return promise;
  }
  onSettle(promise, key, error, data) {
    if (this.controller.signal.aborted && error instanceof AbortedDeferredError) {
      this.unlistenAbortSignal();
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      return Promise.reject(error);
    }
    this.pendingKeysSet.delete(key);
    if (this.done) {
      // Nothing left to abort!
      this.unlistenAbortSignal();
    }
    // If the promise was resolved/rejected with undefined, we'll throw an error as you
    // should always resolve with a value or null
    if (error === undefined && data === undefined) {
      let undefinedError = new Error("Deferred data for key \"" + key + "\" resolved/rejected with `undefined`, " + "you must resolve/reject with a value or `null`.");
      Object.defineProperty(promise, "_error", {
        get: () => undefinedError
      });
      this.emit(false, key);
      return Promise.reject(undefinedError);
    }
    if (data === undefined) {
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      this.emit(false, key);
      return Promise.reject(error);
    }
    Object.defineProperty(promise, "_data", {
      get: () => data
    });
    this.emit(false, key);
    return data;
  }
  emit(aborted, settledKey) {
    this.subscribers.forEach(subscriber => subscriber(aborted, settledKey));
  }
  subscribe(fn) {
    this.subscribers.add(fn);
    return () => this.subscribers.delete(fn);
  }
  cancel() {
    this.controller.abort();
    this.pendingKeysSet.forEach((v, k) => this.pendingKeysSet.delete(k));
    this.emit(true);
  }
  async resolveData(signal) {
    let aborted = false;
    if (!this.done) {
      let onAbort = () => this.cancel();
      signal.addEventListener("abort", onAbort);
      aborted = await new Promise(resolve => {
        this.subscribe(aborted => {
          signal.removeEventListener("abort", onAbort);
          if (aborted || this.done) {
            resolve(aborted);
          }
        });
      });
    }
    return aborted;
  }
  get done() {
    return this.pendingKeysSet.size === 0;
  }
  get unwrappedData() {
    invariant(this.data !== null && this.done, "Can only unwrap data on initialized and settled deferreds");
    return Object.entries(this.data).reduce((acc, _ref3) => {
      let [key, value] = _ref3;
      return Object.assign(acc, {
        [key]: unwrapTrackedPromise(value)
      });
    }, {});
  }
  get pendingKeys() {
    return Array.from(this.pendingKeysSet);
  }
}
function isTrackedPromise(value) {
  return value instanceof Promise && value._tracked === true;
}
function unwrapTrackedPromise(value) {
  if (!isTrackedPromise(value)) {
    return value;
  }
  if (value._error) {
    throw value._error;
  }
  return value._data;
}
/**
 * @deprecated The `defer` method is deprecated in favor of returning raw
 * objects. This method will be removed in v7.
 */
const defer = function defer(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  return new DeferredData(data, responseInit);
};
/**
 * A redirect response. Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirect = function redirect(url, init) {
  if (init === void 0) {
    init = 302;
  }
  let responseInit = init;
  if (typeof responseInit === "number") {
    responseInit = {
      status: responseInit
    };
  } else if (typeof responseInit.status === "undefined") {
    responseInit.status = 302;
  }
  let headers = new Headers(responseInit.headers);
  headers.set("Location", url);
  return new Response(null, _extends({}, responseInit, {
    headers
  }));
};
/**
 * A redirect response that will force a document reload to the new location.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirectDocument = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Reload-Document", "true");
  return response;
};
/**
 * A redirect response that will perform a `history.replaceState` instead of a
 * `history.pushState` for client-side navigation redirects.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const replace = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Replace", "true");
  return response;
};
/**
 * @private
 * Utility class we use to hold auto-unwrapped 4xx/5xx Response bodies
 *
 * We don't export the class for public use since it's an implementation
 * detail, but we export the interface above so folks can build their own
 * abstractions around instances via isRouteErrorResponse()
 */
class ErrorResponseImpl {
  constructor(status, statusText, data, internal) {
    if (internal === void 0) {
      internal = false;
    }
    this.status = status;
    this.statusText = statusText || "";
    this.internal = internal;
    if (data instanceof Error) {
      this.data = data.toString();
      this.error = data;
    } else {
      this.data = data;
    }
  }
}
/**
 * Check if the given error is an ErrorResponse generated from a 4xx/5xx
 * Response thrown from an action/loader
 */
function isRouteErrorResponse(error) {
  return error != null && typeof error.status === "number" && typeof error.statusText === "string" && typeof error.internal === "boolean" && "data" in error;
}

const validMutationMethodsArr = ["post", "put", "patch", "delete"];
const validMutationMethods = new Set(validMutationMethodsArr);
const validRequestMethodsArr = ["get", ...validMutationMethodsArr];
const validRequestMethods = new Set(validRequestMethodsArr);
const redirectStatusCodes = new Set([301, 302, 303, 307, 308]);
const redirectPreserveMethodStatusCodes = new Set([307, 308]);
const IDLE_NAVIGATION = {
  state: "idle",
  location: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_FETCHER = {
  state: "idle",
  data: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_BLOCKER = {
  state: "unblocked",
  proceed: undefined,
  reset: undefined,
  location: undefined
};
const ABSOLUTE_URL_REGEX = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
const defaultMapRouteProperties = route => ({
  hasErrorBoundary: Boolean(route.hasErrorBoundary)
});
const TRANSITIONS_STORAGE_KEY = "remix-router-transitions";
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createRouter
////////////////////////////////////////////////////////////////////////////////
/**
 * Create a router and listen to history POP navigations
 */
function createRouter(init) {
  const routerWindow = init.window ? init.window : typeof window !== "undefined" ? window : undefined;
  const isBrowser = typeof routerWindow !== "undefined" && typeof routerWindow.document !== "undefined" && typeof routerWindow.document.createElement !== "undefined";
  const isServer = !isBrowser;
  invariant(init.routes.length > 0, "You must provide a non-empty routes array to createRouter");
  let mapRouteProperties;
  if (init.mapRouteProperties) {
    mapRouteProperties = init.mapRouteProperties;
  } else if (init.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = init.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Routes keyed by ID
  let manifest = {};
  // Routes in tree format for matching
  let dataRoutes = convertRoutesToDataRoutes(init.routes, mapRouteProperties, undefined, manifest);
  let inFlightDataRoutes;
  let basename = init.basename || "/";
  let dataStrategyImpl = init.dataStrategy || defaultDataStrategy;
  let patchRoutesOnNavigationImpl = init.patchRoutesOnNavigation;
  // Config driven behavior flags
  let future = _extends({
    v7_fetcherPersist: false,
    v7_normalizeFormMethod: false,
    v7_partialHydration: false,
    v7_prependBasename: false,
    v7_relativeSplatPath: false,
    v7_skipActionErrorRevalidation: false
  }, init.future);
  // Cleanup function for history
  let unlistenHistory = null;
  // Externally-provided functions to call on all state changes
  let subscribers = new Set();
  // Externally-provided object to hold scroll restoration locations during routing
  let savedScrollPositions = null;
  // Externally-provided function to get scroll restoration keys
  let getScrollRestorationKey = null;
  // Externally-provided function to get current scroll position
  let getScrollPosition = null;
  // One-time flag to control the initial hydration scroll restoration.  Because
  // we don't get the saved positions from <ScrollRestoration /> until _after_
  // the initial render, we need to manually trigger a separate updateState to
  // send along the restoreScrollPosition
  // Set to true if we have `hydrationData` since we assume we were SSR'd and that
  // SSR did the initial scroll restoration.
  let initialScrollRestored = init.hydrationData != null;
  let initialMatches = matchRoutes(dataRoutes, init.history.location, basename);
  let initialErrors = null;
  if (initialMatches == null && !patchRoutesOnNavigationImpl) {
    // If we do not match a user-provided-route, fall back to the root
    // to allow the error boundary to take over
    let error = getInternalRouterError(404, {
      pathname: init.history.location.pathname
    });
    let {
      matches,
      route
    } = getShortCircuitMatches(dataRoutes);
    initialMatches = matches;
    initialErrors = {
      [route.id]: error
    };
  }
  // In SPA apps, if the user provided a patchRoutesOnNavigation implementation and
  // our initial match is a splat route, clear them out so we run through lazy
  // discovery on hydration in case there's a more accurate lazy route match.
  // In SSR apps (with `hydrationData`), we expect that the server will send
  // up the proper matched routes so we don't want to run lazy discovery on
  // initial hydration and want to hydrate into the splat route.
  if (initialMatches && !init.hydrationData) {
    let fogOfWar = checkFogOfWar(initialMatches, dataRoutes, init.history.location.pathname);
    if (fogOfWar.active) {
      initialMatches = null;
    }
  }
  let initialized;
  if (!initialMatches) {
    initialized = false;
    initialMatches = [];
    // If partial hydration and fog of war is enabled, we will be running
    // `patchRoutesOnNavigation` during hydration so include any partial matches as
    // the initial matches so we can properly render `HydrateFallback`'s
    if (future.v7_partialHydration) {
      let fogOfWar = checkFogOfWar(null, dataRoutes, init.history.location.pathname);
      if (fogOfWar.active && fogOfWar.matches) {
        initialMatches = fogOfWar.matches;
      }
    }
  } else if (initialMatches.some(m => m.route.lazy)) {
    // All initialMatches need to be loaded before we're ready.  If we have lazy
    // functions around still then we'll need to run them in initialize()
    initialized = false;
  } else if (!initialMatches.some(m => m.route.loader)) {
    // If we've got no loaders to run, then we're good to go
    initialized = true;
  } else if (future.v7_partialHydration) {
    // If partial hydration is enabled, we're initialized so long as we were
    // provided with hydrationData for every route with a loader, and no loaders
    // were marked for explicit hydration
    let loaderData = init.hydrationData ? init.hydrationData.loaderData : null;
    let errors = init.hydrationData ? init.hydrationData.errors : null;
    // If errors exist, don't consider routes below the boundary
    if (errors) {
      let idx = initialMatches.findIndex(m => errors[m.route.id] !== undefined);
      initialized = initialMatches.slice(0, idx + 1).every(m => !shouldLoadRouteOnHydration(m.route, loaderData, errors));
    } else {
      initialized = initialMatches.every(m => !shouldLoadRouteOnHydration(m.route, loaderData, errors));
    }
  } else {
    // Without partial hydration - we're initialized if we were provided any
    // hydrationData - which is expected to be complete
    initialized = init.hydrationData != null;
  }
  let router;
  let state = {
    historyAction: init.history.action,
    location: init.history.location,
    matches: initialMatches,
    initialized,
    navigation: IDLE_NAVIGATION,
    // Don't restore on initial updateState() if we were SSR'd
    restoreScrollPosition: init.hydrationData != null ? false : null,
    preventScrollReset: false,
    revalidation: "idle",
    loaderData: init.hydrationData && init.hydrationData.loaderData || {},
    actionData: init.hydrationData && init.hydrationData.actionData || null,
    errors: init.hydrationData && init.hydrationData.errors || initialErrors,
    fetchers: new Map(),
    blockers: new Map()
  };
  // -- Stateful internal variables to manage navigations --
  // Current navigation in progress (to be committed in completeNavigation)
  let pendingAction = Action.Pop;
  // Should the current navigation prevent the scroll reset if scroll cannot
  // be restored?
  let pendingPreventScrollReset = false;
  // AbortController for the active navigation
  let pendingNavigationController;
  // Should the current navigation enable document.startViewTransition?
  let pendingViewTransitionEnabled = false;
  // Store applied view transitions so we can apply them on POP
  let appliedViewTransitions = new Map();
  // Cleanup function for persisting applied transitions to sessionStorage
  let removePageHideEventListener = null;
  // We use this to avoid touching history in completeNavigation if a
  // revalidation is entirely uninterrupted
  let isUninterruptedRevalidation = false;
  // Use this internal flag to force revalidation of all loaders:
  //  - submissions (completed or interrupted)
  //  - useRevalidator()
  //  - X-Remix-Revalidate (from redirect)
  let isRevalidationRequired = false;
  // Use this internal array to capture routes that require revalidation due
  // to a cancelled deferred on action submission
  let cancelledDeferredRoutes = [];
  // Use this internal array to capture fetcher loads that were cancelled by an
  // action navigation and require revalidation
  let cancelledFetcherLoads = new Set();
  // AbortControllers for any in-flight fetchers
  let fetchControllers = new Map();
  // Track loads based on the order in which they started
  let incrementingLoadId = 0;
  // Track the outstanding pending navigation data load to be compared against
  // the globally incrementing load when a fetcher load lands after a completed
  // navigation
  let pendingNavigationLoadId = -1;
  // Fetchers that triggered data reloads as a result of their actions
  let fetchReloadIds = new Map();
  // Fetchers that triggered redirect navigations
  let fetchRedirectIds = new Set();
  // Most recent href/match for fetcher.load calls for fetchers
  let fetchLoadMatches = new Map();
  // Ref-count mounted fetchers so we know when it's ok to clean them up
  let activeFetchers = new Map();
  // Fetchers that have requested a delete when using v7_fetcherPersist,
  // they'll be officially removed after they return to idle
  let deletedFetchers = new Set();
  // Store DeferredData instances for active route matches.  When a
  // route loader returns defer() we stick one in here.  Then, when a nested
  // promise resolves we update loaderData.  If a new navigation starts we
  // cancel active deferreds for eliminated routes.
  let activeDeferreds = new Map();
  // Store blocker functions in a separate Map outside of router state since
  // we don't need to update UI state if they change
  let blockerFunctions = new Map();
  // Flag to ignore the next history update, so we can revert the URL change on
  // a POP navigation that was blocked by the user without touching router state
  let unblockBlockerHistoryUpdate = undefined;
  // Initialize the router, all side effects should be kicked off from here.
  // Implemented as a Fluent API for ease of:
  //   let router = createRouter(init).initialize();
  function initialize() {
    // If history informs us of a POP navigation, start the navigation but do not update
    // state.  We'll update our own state once the navigation completes
    unlistenHistory = init.history.listen(_ref => {
      let {
        action: historyAction,
        location,
        delta
      } = _ref;
      // Ignore this event if it was just us resetting the URL from a
      // blocked POP navigation
      if (unblockBlockerHistoryUpdate) {
        unblockBlockerHistoryUpdate();
        unblockBlockerHistoryUpdate = undefined;
        return;
      }
      warning(blockerFunctions.size === 0 || delta != null, "You are trying to use a blocker on a POP navigation to a location " + "that was not created by @remix-run/router. This will fail silently in " + "production. This can happen if you are navigating outside the router " + "via `window.history.pushState`/`window.location.hash` instead of using " + "router navigation APIs.  This can also happen if you are using " + "createHashRouter and the user manually changes the URL.");
      let blockerKey = shouldBlockNavigation({
        currentLocation: state.location,
        nextLocation: location,
        historyAction
      });
      if (blockerKey && delta != null) {
        // Restore the URL to match the current UI, but don't update router state
        let nextHistoryUpdatePromise = new Promise(resolve => {
          unblockBlockerHistoryUpdate = resolve;
        });
        init.history.go(delta * -1);
        // Put the blocker into a blocked state
        updateBlocker(blockerKey, {
          state: "blocked",
          location,
          proceed() {
            updateBlocker(blockerKey, {
              state: "proceeding",
              proceed: undefined,
              reset: undefined,
              location
            });
            // Re-do the same POP navigation we just blocked, after the url
            // restoration is also complete.  See:
            // https://github.com/remix-run/react-router/issues/11613
            nextHistoryUpdatePromise.then(() => init.history.go(delta));
          },
          reset() {
            let blockers = new Map(state.blockers);
            blockers.set(blockerKey, IDLE_BLOCKER);
            updateState({
              blockers
            });
          }
        });
        return;
      }
      return startNavigation(historyAction, location);
    });
    if (isBrowser) {
      // FIXME: This feels gross.  How can we cleanup the lines between
      // scrollRestoration/appliedTransitions persistance?
      restoreAppliedTransitions(routerWindow, appliedViewTransitions);
      let _saveAppliedTransitions = () => persistAppliedTransitions(routerWindow, appliedViewTransitions);
      routerWindow.addEventListener("pagehide", _saveAppliedTransitions);
      removePageHideEventListener = () => routerWindow.removeEventListener("pagehide", _saveAppliedTransitions);
    }
    // Kick off initial data load if needed.  Use Pop to avoid modifying history
    // Note we don't do any handling of lazy here.  For SPA's it'll get handled
    // in the normal navigation flow.  For SSR it's expected that lazy modules are
    // resolved prior to router creation since we can't go into a fallbackElement
    // UI for SSR'd apps
    if (!state.initialized) {
      startNavigation(Action.Pop, state.location, {
        initialHydration: true
      });
    }
    return router;
  }
  // Clean up a router and it's side effects
  function dispose() {
    if (unlistenHistory) {
      unlistenHistory();
    }
    if (removePageHideEventListener) {
      removePageHideEventListener();
    }
    subscribers.clear();
    pendingNavigationController && pendingNavigationController.abort();
    state.fetchers.forEach((_, key) => deleteFetcher(key));
    state.blockers.forEach((_, key) => deleteBlocker(key));
  }
  // Subscribe to state updates for the router
  function subscribe(fn) {
    subscribers.add(fn);
    return () => subscribers.delete(fn);
  }
  // Update our state and notify the calling context of the change
  function updateState(newState, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state = _extends({}, state, newState);
    // Prep fetcher cleanup so we can tell the UI which fetcher data entries
    // can be removed
    let completedFetchers = [];
    let deletedFetchersKeys = [];
    if (future.v7_fetcherPersist) {
      state.fetchers.forEach((fetcher, key) => {
        if (fetcher.state === "idle") {
          if (deletedFetchers.has(key)) {
            // Unmounted from the UI and can be totally removed
            deletedFetchersKeys.push(key);
          } else {
            // Returned to idle but still mounted in the UI, so semi-remains for
            // revalidations and such
            completedFetchers.push(key);
          }
        }
      });
    }
    // Iterate over a local copy so that if flushSync is used and we end up
    // removing and adding a new subscriber due to the useCallback dependencies,
    // we don't get ourselves into a loop calling the new subscriber immediately
    [...subscribers].forEach(subscriber => subscriber(state, {
      deletedFetchers: deletedFetchersKeys,
      viewTransitionOpts: opts.viewTransitionOpts,
      flushSync: opts.flushSync === true
    }));
    // Remove idle fetchers from state since we only care about in-flight fetchers.
    if (future.v7_fetcherPersist) {
      completedFetchers.forEach(key => state.fetchers.delete(key));
      deletedFetchersKeys.forEach(key => deleteFetcher(key));
    }
  }
  // Complete a navigation returning the state.navigation back to the IDLE_NAVIGATION
  // and setting state.[historyAction/location/matches] to the new route.
  // - Location is a required param
  // - Navigation will always be set to IDLE_NAVIGATION
  // - Can pass any other state in newState
  function completeNavigation(location, newState, _temp) {
    var _location$state, _location$state2;
    let {
      flushSync
    } = _temp === void 0 ? {} : _temp;
    // Deduce if we're in a loading/actionReload state:
    // - We have committed actionData in the store
    // - The current navigation was a mutation submission
    // - We're past the submitting state and into the loading state
    // - The location being loaded is not the result of a redirect
    let isActionReload = state.actionData != null && state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && state.navigation.state === "loading" && ((_location$state = location.state) == null ? void 0 : _location$state._isRedirect) !== true;
    let actionData;
    if (newState.actionData) {
      if (Object.keys(newState.actionData).length > 0) {
        actionData = newState.actionData;
      } else {
        // Empty actionData -> clear prior actionData due to an action error
        actionData = null;
      }
    } else if (isActionReload) {
      // Keep the current data if we're wrapping up the action reload
      actionData = state.actionData;
    } else {
      // Clear actionData on any other completed navigations
      actionData = null;
    }
    // Always preserve any existing loaderData from re-used routes
    let loaderData = newState.loaderData ? mergeLoaderData(state.loaderData, newState.loaderData, newState.matches || [], newState.errors) : state.loaderData;
    // On a successful navigation we can assume we got through all blockers
    // so we can start fresh
    let blockers = state.blockers;
    if (blockers.size > 0) {
      blockers = new Map(blockers);
      blockers.forEach((_, k) => blockers.set(k, IDLE_BLOCKER));
    }
    // Always respect the user flag.  Otherwise don't reset on mutation
    // submission navigations unless they redirect
    let preventScrollReset = pendingPreventScrollReset === true || state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && ((_location$state2 = location.state) == null ? void 0 : _location$state2._isRedirect) !== true;
    // Commit any in-flight routes at the end of the HMR revalidation "navigation"
    if (inFlightDataRoutes) {
      dataRoutes = inFlightDataRoutes;
      inFlightDataRoutes = undefined;
    }
    if (isUninterruptedRevalidation) ; else if (pendingAction === Action.Pop) ; else if (pendingAction === Action.Push) {
      init.history.push(location, location.state);
    } else if (pendingAction === Action.Replace) {
      init.history.replace(location, location.state);
    }
    let viewTransitionOpts;
    // On POP, enable transitions if they were enabled on the original navigation
    if (pendingAction === Action.Pop) {
      // Forward takes precedence so they behave like the original navigation
      let priorPaths = appliedViewTransitions.get(state.location.pathname);
      if (priorPaths && priorPaths.has(location.pathname)) {
        viewTransitionOpts = {
          currentLocation: state.location,
          nextLocation: location
        };
      } else if (appliedViewTransitions.has(location.pathname)) {
        // If we don't have a previous forward nav, assume we're popping back to
        // the new location and enable if that location previously enabled
        viewTransitionOpts = {
          currentLocation: location,
          nextLocation: state.location
        };
      }
    } else if (pendingViewTransitionEnabled) {
      // Store the applied transition on PUSH/REPLACE
      let toPaths = appliedViewTransitions.get(state.location.pathname);
      if (toPaths) {
        toPaths.add(location.pathname);
      } else {
        toPaths = new Set([location.pathname]);
        appliedViewTransitions.set(state.location.pathname, toPaths);
      }
      viewTransitionOpts = {
        currentLocation: state.location,
        nextLocation: location
      };
    }
    updateState(_extends({}, newState, {
      actionData,
      loaderData,
      historyAction: pendingAction,
      location,
      initialized: true,
      navigation: IDLE_NAVIGATION,
      revalidation: "idle",
      restoreScrollPosition: getSavedScrollPosition(location, newState.matches || state.matches),
      preventScrollReset,
      blockers
    }), {
      viewTransitionOpts,
      flushSync: flushSync === true
    });
    // Reset stateful navigation vars
    pendingAction = Action.Pop;
    pendingPreventScrollReset = false;
    pendingViewTransitionEnabled = false;
    isUninterruptedRevalidation = false;
    isRevalidationRequired = false;
    cancelledDeferredRoutes = [];
  }
  // Trigger a navigation event, which can either be a numerical POP or a PUSH
  // replace with an optional submission
  async function navigate(to, opts) {
    if (typeof to === "number") {
      init.history.go(to);
      return;
    }
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, to, future.v7_relativeSplatPath, opts == null ? void 0 : opts.fromRouteId, opts == null ? void 0 : opts.relative);
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, false, normalizedPath, opts);
    let currentLocation = state.location;
    let nextLocation = createLocation(state.location, path, opts && opts.state);
    // When using navigate as a PUSH/REPLACE we aren't reading an already-encoded
    // URL from window.location, so we need to encode it here so the behavior
    // remains the same as POP and non-data-router usages.  new URL() does all
    // the same encoding we'd get from a history.pushState/window.location read
    // without having to touch history
    nextLocation = _extends({}, nextLocation, init.history.encodeLocation(nextLocation));
    let userReplace = opts && opts.replace != null ? opts.replace : undefined;
    let historyAction = Action.Push;
    if (userReplace === true) {
      historyAction = Action.Replace;
    } else if (userReplace === false) ; else if (submission != null && isMutationMethod(submission.formMethod) && submission.formAction === state.location.pathname + state.location.search) {
      // By default on submissions to the current location we REPLACE so that
      // users don't have to double-click the back button to get to the prior
      // location.  If the user redirects to a different location from the
      // action/loader this will be ignored and the redirect will be a PUSH
      historyAction = Action.Replace;
    }
    let preventScrollReset = opts && "preventScrollReset" in opts ? opts.preventScrollReset === true : undefined;
    let flushSync = (opts && opts.flushSync) === true;
    let blockerKey = shouldBlockNavigation({
      currentLocation,
      nextLocation,
      historyAction
    });
    if (blockerKey) {
      // Put the blocker into a blocked state
      updateBlocker(blockerKey, {
        state: "blocked",
        location: nextLocation,
        proceed() {
          updateBlocker(blockerKey, {
            state: "proceeding",
            proceed: undefined,
            reset: undefined,
            location: nextLocation
          });
          // Send the same navigation through
          navigate(to, opts);
        },
        reset() {
          let blockers = new Map(state.blockers);
          blockers.set(blockerKey, IDLE_BLOCKER);
          updateState({
            blockers
          });
        }
      });
      return;
    }
    return await startNavigation(historyAction, nextLocation, {
      submission,
      // Send through the formData serialization error if we have one so we can
      // render at the right error boundary after we match routes
      pendingError: error,
      preventScrollReset,
      replace: opts && opts.replace,
      enableViewTransition: opts && opts.viewTransition,
      flushSync
    });
  }
  // Revalidate all current loaders.  If a navigation is in progress or if this
  // is interrupted by a navigation, allow this to "succeed" by calling all
  // loaders during the next loader round
  function revalidate() {
    interruptActiveLoads();
    updateState({
      revalidation: "loading"
    });
    // If we're currently submitting an action, we don't need to start a new
    // navigation, we'll just let the follow up loader execution call all loaders
    if (state.navigation.state === "submitting") {
      return;
    }
    // If we're currently in an idle state, start a new navigation for the current
    // action/location and mark it as uninterrupted, which will skip the history
    // update in completeNavigation
    if (state.navigation.state === "idle") {
      startNavigation(state.historyAction, state.location, {
        startUninterruptedRevalidation: true
      });
      return;
    }
    // Otherwise, if we're currently in a loading state, just start a new
    // navigation to the navigation.location but do not trigger an uninterrupted
    // revalidation so that history correctly updates once the navigation completes
    startNavigation(pendingAction || state.historyAction, state.navigation.location, {
      overrideNavigation: state.navigation,
      // Proxy through any rending view transition
      enableViewTransition: pendingViewTransitionEnabled === true
    });
  }
  // Start a navigation to the given action/location.  Can optionally provide a
  // overrideNavigation which will override the normalLoad in the case of a redirect
  // navigation
  async function startNavigation(historyAction, location, opts) {
    // Abort any in-progress navigations and start a new one. Unset any ongoing
    // uninterrupted revalidations unless told otherwise, since we want this
    // new navigation to update history normally
    pendingNavigationController && pendingNavigationController.abort();
    pendingNavigationController = null;
    pendingAction = historyAction;
    isUninterruptedRevalidation = (opts && opts.startUninterruptedRevalidation) === true;
    // Save the current scroll position every time we start a new navigation,
    // and track whether we should reset scroll on completion
    saveScrollPosition(state.location, state.matches);
    pendingPreventScrollReset = (opts && opts.preventScrollReset) === true;
    pendingViewTransitionEnabled = (opts && opts.enableViewTransition) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let loadingNavigation = opts && opts.overrideNavigation;
    let matches = matchRoutes(routesToUse, location, basename);
    let flushSync = (opts && opts.flushSync) === true;
    let fogOfWar = checkFogOfWar(matches, routesToUse, location.pathname);
    if (fogOfWar.active && fogOfWar.matches) {
      matches = fogOfWar.matches;
    }
    // Short circuit with a 404 on the root error boundary if we match nothing
    if (!matches) {
      let {
        error,
        notFoundMatches,
        route
      } = handleNavigational404(location.pathname);
      completeNavigation(location, {
        matches: notFoundMatches,
        loaderData: {},
        errors: {
          [route.id]: error
        }
      }, {
        flushSync
      });
      return;
    }
    // Short circuit if it's only a hash change and not a revalidation or
    // mutation submission.
    //
    // Ignore on initial page loads because since the initial hydration will always
    // be "same hash".  For example, on /page#hash and submit a <Form method="post">
    // which will default to a navigation to /page
    if (state.initialized && !isRevalidationRequired && isHashChangeOnly(state.location, location) && !(opts && opts.submission && isMutationMethod(opts.submission.formMethod))) {
      completeNavigation(location, {
        matches
      }, {
        flushSync
      });
      return;
    }
    // Create a controller/Request for this navigation
    pendingNavigationController = new AbortController();
    let request = createClientSideRequest(init.history, location, pendingNavigationController.signal, opts && opts.submission);
    let pendingActionResult;
    if (opts && opts.pendingError) {
      // If we have a pendingError, it means the user attempted a GET submission
      // with binary FormData so assign here and skip to handleLoaders.  That
      // way we handle calling loaders above the boundary etc.  It's not really
      // different from an actionError in that sense.
      pendingActionResult = [findNearestBoundary(matches).route.id, {
        type: ResultType.error,
        error: opts.pendingError
      }];
    } else if (opts && opts.submission && isMutationMethod(opts.submission.formMethod)) {
      // Call action if we received an action submission
      let actionResult = await handleAction(request, location, opts.submission, matches, fogOfWar.active, {
        replace: opts.replace,
        flushSync
      });
      if (actionResult.shortCircuited) {
        return;
      }
      // If we received a 404 from handleAction, it's because we couldn't lazily
      // discover the destination route so we don't want to call loaders
      if (actionResult.pendingActionResult) {
        let [routeId, result] = actionResult.pendingActionResult;
        if (isErrorResult(result) && isRouteErrorResponse(result.error) && result.error.status === 404) {
          pendingNavigationController = null;
          completeNavigation(location, {
            matches: actionResult.matches,
            loaderData: {},
            errors: {
              [routeId]: result.error
            }
          });
          return;
        }
      }
      matches = actionResult.matches || matches;
      pendingActionResult = actionResult.pendingActionResult;
      loadingNavigation = getLoadingNavigation(location, opts.submission);
      flushSync = false;
      // No need to do fog of war matching again on loader execution
      fogOfWar.active = false;
      // Create a GET request for the loaders
      request = createClientSideRequest(init.history, request.url, request.signal);
    }
    // Call loaders
    let {
      shortCircuited,
      matches: updatedMatches,
      loaderData,
      errors
    } = await handleLoaders(request, location, matches, fogOfWar.active, loadingNavigation, opts && opts.submission, opts && opts.fetcherSubmission, opts && opts.replace, opts && opts.initialHydration === true, flushSync, pendingActionResult);
    if (shortCircuited) {
      return;
    }
    // Clean up now that the action/loaders have completed.  Don't clean up if
    // we short circuited because pendingNavigationController will have already
    // been assigned to a new controller for the next navigation
    pendingNavigationController = null;
    completeNavigation(location, _extends({
      matches: updatedMatches || matches
    }, getActionDataForCommit(pendingActionResult), {
      loaderData,
      errors
    }));
  }
  // Call the action matched by the leaf route for this navigation and handle
  // redirects/errors
  async function handleAction(request, location, submission, matches, isFogOfWar, opts) {
    if (opts === void 0) {
      opts = {};
    }
    interruptActiveLoads();
    // Put us in a submitting state
    let navigation = getSubmittingNavigation(location, submission);
    updateState({
      navigation
    }, {
      flushSync: opts.flushSync === true
    });
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(matches, location.pathname, request.signal);
      if (discoverResult.type === "aborted") {
        return {
          shortCircuited: true
        };
      } else if (discoverResult.type === "error") {
        let boundaryId = findNearestBoundary(discoverResult.partialMatches).route.id;
        return {
          matches: discoverResult.partialMatches,
          pendingActionResult: [boundaryId, {
            type: ResultType.error,
            error: discoverResult.error
          }]
        };
      } else if (!discoverResult.matches) {
        let {
          notFoundMatches,
          error,
          route
        } = handleNavigational404(location.pathname);
        return {
          matches: notFoundMatches,
          pendingActionResult: [route.id, {
            type: ResultType.error,
            error
          }]
        };
      } else {
        matches = discoverResult.matches;
      }
    }
    // Call our action and get the result
    let result;
    let actionMatch = getTargetMatch(matches, location);
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      result = {
        type: ResultType.error,
        error: getInternalRouterError(405, {
          method: request.method,
          pathname: location.pathname,
          routeId: actionMatch.route.id
        })
      };
    } else {
      let results = await callDataStrategy("action", state, request, [actionMatch], matches, null);
      result = results[actionMatch.route.id];
      if (request.signal.aborted) {
        return {
          shortCircuited: true
        };
      }
    }
    if (isRedirectResult(result)) {
      let replace;
      if (opts && opts.replace != null) {
        replace = opts.replace;
      } else {
        // If the user didn't explicity indicate replace behavior, replace if
        // we redirected to the exact same location we're currently at to avoid
        // double back-buttons
        let location = normalizeRedirectLocation(result.response.headers.get("Location"), new URL(request.url), basename);
        replace = location === state.location.pathname + state.location.search;
      }
      await startRedirectNavigation(request, result, true, {
        submission,
        replace
      });
      return {
        shortCircuited: true
      };
    }
    if (isDeferredResult(result)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = findNearestBoundary(matches, actionMatch.route.id);
      // By default, all submissions to the current location are REPLACE
      // navigations, but if the action threw an error that'll be rendered in
      // an errorElement, we fall back to PUSH so that the user can use the
      // back button to get back to the pre-submission form location to try
      // again
      if ((opts && opts.replace) !== true) {
        pendingAction = Action.Push;
      }
      return {
        matches,
        pendingActionResult: [boundaryMatch.route.id, result]
      };
    }
    return {
      matches,
      pendingActionResult: [actionMatch.route.id, result]
    };
  }
  // Call all applicable loaders for the given matches, handling redirects,
  // errors, etc.
  async function handleLoaders(request, location, matches, isFogOfWar, overrideNavigation, submission, fetcherSubmission, replace, initialHydration, flushSync, pendingActionResult) {
    // Figure out the right navigation we want to use for data loading
    let loadingNavigation = overrideNavigation || getLoadingNavigation(location, submission);
    // If this was a redirect from an action we don't have a "submission" but
    // we have it on the loading navigation so use that if available
    let activeSubmission = submission || fetcherSubmission || getSubmissionFromNavigation(loadingNavigation);
    // If this is an uninterrupted revalidation, we remain in our current idle
    // state.  If not, we need to switch to our loading state and load data,
    // preserving any new action data or existing action data (in the case of
    // a revalidation interrupting an actionReload)
    // If we have partialHydration enabled, then don't update the state for the
    // initial data load since it's not a "navigation"
    let shouldUpdateNavigationState = !isUninterruptedRevalidation && (!future.v7_partialHydration || !initialHydration);
    // When fog of war is enabled, we enter our `loading` state earlier so we
    // can discover new routes during the `loading` state.  We skip this if
    // we've already run actions since we would have done our matching already.
    // If the children() function threw then, we want to proceed with the
    // partial matches it discovered.
    if (isFogOfWar) {
      if (shouldUpdateNavigationState) {
        let actionData = getUpdatedActionData(pendingActionResult);
        updateState(_extends({
          navigation: loadingNavigation
        }, actionData !== undefined ? {
          actionData
        } : {}), {
          flushSync
        });
      }
      let discoverResult = await discoverRoutes(matches, location.pathname, request.signal);
      if (discoverResult.type === "aborted") {
        return {
          shortCircuited: true
        };
      } else if (discoverResult.type === "error") {
        let boundaryId = findNearestBoundary(discoverResult.partialMatches).route.id;
        return {
          matches: discoverResult.partialMatches,
          loaderData: {},
          errors: {
            [boundaryId]: discoverResult.error
          }
        };
      } else if (!discoverResult.matches) {
        let {
          error,
          notFoundMatches,
          route
        } = handleNavigational404(location.pathname);
        return {
          matches: notFoundMatches,
          loaderData: {},
          errors: {
            [route.id]: error
          }
        };
      } else {
        matches = discoverResult.matches;
      }
    }
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, activeSubmission, location, future.v7_partialHydration && initialHydration === true, future.v7_skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionResult);
    // Cancel pending deferreds for no-longer-matched routes or routes we're
    // about to reload.  Note that if this is an action reload we would have
    // already cancelled all pending deferreds so this would be a no-op
    cancelActiveDeferreds(routeId => !(matches && matches.some(m => m.route.id === routeId)) || matchesToLoad && matchesToLoad.some(m => m.route.id === routeId));
    pendingNavigationLoadId = ++incrementingLoadId;
    // Short circuit if we have no loaders to run
    if (matchesToLoad.length === 0 && revalidatingFetchers.length === 0) {
      let updatedFetchers = markFetchRedirectsDone();
      completeNavigation(location, _extends({
        matches,
        loaderData: {},
        // Commit pending error if we're short circuiting
        errors: pendingActionResult && isErrorResult(pendingActionResult[1]) ? {
          [pendingActionResult[0]]: pendingActionResult[1].error
        } : null
      }, getActionDataForCommit(pendingActionResult), updatedFetchers ? {
        fetchers: new Map(state.fetchers)
      } : {}), {
        flushSync
      });
      return {
        shortCircuited: true
      };
    }
    if (shouldUpdateNavigationState) {
      let updates = {};
      if (!isFogOfWar) {
        // Only update navigation/actionNData if we didn't already do it above
        updates.navigation = loadingNavigation;
        let actionData = getUpdatedActionData(pendingActionResult);
        if (actionData !== undefined) {
          updates.actionData = actionData;
        }
      }
      if (revalidatingFetchers.length > 0) {
        updates.fetchers = getUpdatedRevalidatingFetchers(revalidatingFetchers);
      }
      updateState(updates, {
        flushSync
      });
    }
    revalidatingFetchers.forEach(rf => {
      abortFetcher(rf.key);
      if (rf.controller) {
        // Fetchers use an independent AbortController so that aborting a fetcher
        // (via deleteFetcher) does not abort the triggering navigation that
        // triggered the revalidation
        fetchControllers.set(rf.key, rf.controller);
      }
    });
    // Proxy navigation abort through to revalidation fetchers
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(f => abortFetcher(f.key));
    if (pendingNavigationController) {
      pendingNavigationController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    }
    let {
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state, matches, matchesToLoad, revalidatingFetchers, request);
    if (request.signal.aborted) {
      return {
        shortCircuited: true
      };
    }
    // Clean up _after_ loaders have completed.  Don't clean up if we short
    // circuited because fetchControllers would have been aborted and
    // reassigned to new controllers for the next navigation
    if (pendingNavigationController) {
      pendingNavigationController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    }
    revalidatingFetchers.forEach(rf => fetchControllers.delete(rf.key));
    // If any loaders returned a redirect Response, start a new REPLACE navigation
    let redirect = findRedirect(loaderResults);
    if (redirect) {
      await startRedirectNavigation(request, redirect.result, true, {
        replace
      });
      return {
        shortCircuited: true
      };
    }
    redirect = findRedirect(fetcherResults);
    if (redirect) {
      // If this redirect came from a fetcher make sure we mark it in
      // fetchRedirectIds so it doesn't get revalidated on the next set of
      // loader executions
      fetchRedirectIds.add(redirect.key);
      await startRedirectNavigation(request, redirect.result, true, {
        replace
      });
      return {
        shortCircuited: true
      };
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, matches, loaderResults, pendingActionResult, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Wire up subscribers to update loaderData as promises settle
    activeDeferreds.forEach((deferredData, routeId) => {
      deferredData.subscribe(aborted => {
        // Note: No need to updateState here since the TrackedPromise on
        // loaderData is stable across resolve/reject
        // Remove this instance if we were aborted or if promises have settled
        if (aborted || deferredData.done) {
          activeDeferreds.delete(routeId);
        }
      });
    });
    // Preserve SSR errors during partial hydration
    if (future.v7_partialHydration && initialHydration && state.errors) {
      errors = _extends({}, state.errors, errors);
    }
    let updatedFetchers = markFetchRedirectsDone();
    let didAbortFetchLoads = abortStaleFetchLoads(pendingNavigationLoadId);
    let shouldUpdateFetchers = updatedFetchers || didAbortFetchLoads || revalidatingFetchers.length > 0;
    return _extends({
      matches,
      loaderData,
      errors
    }, shouldUpdateFetchers ? {
      fetchers: new Map(state.fetchers)
    } : {});
  }
  function getUpdatedActionData(pendingActionResult) {
    if (pendingActionResult && !isErrorResult(pendingActionResult[1])) {
      // This is cast to `any` currently because `RouteData`uses any and it
      // would be a breaking change to use any.
      // TODO: v7 - change `RouteData` to use `unknown` instead of `any`
      return {
        [pendingActionResult[0]]: pendingActionResult[1].data
      };
    } else if (state.actionData) {
      if (Object.keys(state.actionData).length === 0) {
        return null;
      } else {
        return state.actionData;
      }
    }
  }
  function getUpdatedRevalidatingFetchers(revalidatingFetchers) {
    revalidatingFetchers.forEach(rf => {
      let fetcher = state.fetchers.get(rf.key);
      let revalidatingFetcher = getLoadingFetcher(undefined, fetcher ? fetcher.data : undefined);
      state.fetchers.set(rf.key, revalidatingFetcher);
    });
    return new Map(state.fetchers);
  }
  // Trigger a fetcher load/submit for the given fetcher key
  function fetch(key, routeId, href, opts) {
    if (isServer) {
      throw new Error("router.fetch() was called during the server render, but it shouldn't be. " + "You are likely calling a useFetcher() method in the body of your component. " + "Try moving it to a useEffect or a callback.");
    }
    abortFetcher(key);
    let flushSync = (opts && opts.flushSync) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, href, future.v7_relativeSplatPath, routeId, opts == null ? void 0 : opts.relative);
    let matches = matchRoutes(routesToUse, normalizedPath, basename);
    let fogOfWar = checkFogOfWar(matches, routesToUse, normalizedPath);
    if (fogOfWar.active && fogOfWar.matches) {
      matches = fogOfWar.matches;
    }
    if (!matches) {
      setFetcherError(key, routeId, getInternalRouterError(404, {
        pathname: normalizedPath
      }), {
        flushSync
      });
      return;
    }
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, true, normalizedPath, opts);
    if (error) {
      setFetcherError(key, routeId, error, {
        flushSync
      });
      return;
    }
    let match = getTargetMatch(matches, path);
    let preventScrollReset = (opts && opts.preventScrollReset) === true;
    if (submission && isMutationMethod(submission.formMethod)) {
      handleFetcherAction(key, routeId, path, match, matches, fogOfWar.active, flushSync, preventScrollReset, submission);
      return;
    }
    // Store off the match so we can call it's shouldRevalidate on subsequent
    // revalidations
    fetchLoadMatches.set(key, {
      routeId,
      path
    });
    handleFetcherLoader(key, routeId, path, match, matches, fogOfWar.active, flushSync, preventScrollReset, submission);
  }
  // Call the action for the matched fetcher.submit(), and then handle redirects,
  // errors, and revalidation
  async function handleFetcherAction(key, routeId, path, match, requestMatches, isFogOfWar, flushSync, preventScrollReset, submission) {
    interruptActiveLoads();
    fetchLoadMatches.delete(key);
    function detectAndHandle405Error(m) {
      if (!m.route.action && !m.route.lazy) {
        let error = getInternalRouterError(405, {
          method: submission.formMethod,
          pathname: path,
          routeId: routeId
        });
        setFetcherError(key, routeId, error, {
          flushSync
        });
        return true;
      }
      return false;
    }
    if (!isFogOfWar && detectAndHandle405Error(match)) {
      return;
    }
    // Put this fetcher into it's submitting state
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getSubmittingFetcher(submission, existingFetcher), {
      flushSync
    });
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal, submission);
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(requestMatches, path, fetchRequest.signal);
      if (discoverResult.type === "aborted") {
        return;
      } else if (discoverResult.type === "error") {
        setFetcherError(key, routeId, discoverResult.error, {
          flushSync
        });
        return;
      } else if (!discoverResult.matches) {
        setFetcherError(key, routeId, getInternalRouterError(404, {
          pathname: path
        }), {
          flushSync
        });
        return;
      } else {
        requestMatches = discoverResult.matches;
        match = getTargetMatch(requestMatches, path);
        if (detectAndHandle405Error(match)) {
          return;
        }
      }
    }
    // Call the action for the fetcher
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let actionResults = await callDataStrategy("action", state, fetchRequest, [match], requestMatches, key);
    let actionResult = actionResults[match.route.id];
    if (fetchRequest.signal.aborted) {
      // We can delete this so long as we weren't aborted by our own fetcher
      // re-submit which would have put _new_ controller is in fetchControllers
      if (fetchControllers.get(key) === abortController) {
        fetchControllers.delete(key);
      }
      return;
    }
    // When using v7_fetcherPersist, we don't want errors bubbling up to the UI
    // or redirects processed for unmounted fetchers so we just revert them to
    // idle
    if (future.v7_fetcherPersist && deletedFetchers.has(key)) {
      if (isRedirectResult(actionResult) || isErrorResult(actionResult)) {
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      }
      // Let SuccessResult's fall through for revalidation
    } else {
      if (isRedirectResult(actionResult)) {
        fetchControllers.delete(key);
        if (pendingNavigationLoadId > originatingLoadId) {
          // A new navigation was kicked off after our action started, so that
          // should take precedence over this redirect navigation.  We already
          // set isRevalidationRequired so all loaders for the new route should
          // fire unless opted out via shouldRevalidate
          updateFetcherState(key, getDoneFetcher(undefined));
          return;
        } else {
          fetchRedirectIds.add(key);
          updateFetcherState(key, getLoadingFetcher(submission));
          return startRedirectNavigation(fetchRequest, actionResult, false, {
            fetcherSubmission: submission,
            preventScrollReset
          });
        }
      }
      // Process any non-redirect errors thrown
      if (isErrorResult(actionResult)) {
        setFetcherError(key, routeId, actionResult.error);
        return;
      }
    }
    if (isDeferredResult(actionResult)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    // Start the data load for current matches, or the next location if we're
    // in the middle of a navigation
    let nextLocation = state.navigation.location || state.location;
    let revalidationRequest = createClientSideRequest(init.history, nextLocation, abortController.signal);
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let matches = state.navigation.state !== "idle" ? matchRoutes(routesToUse, state.navigation.location, basename) : state.matches;
    invariant(matches, "Didn't find any matches after fetcher action");
    let loadId = ++incrementingLoadId;
    fetchReloadIds.set(key, loadId);
    let loadFetcher = getLoadingFetcher(submission, actionResult.data);
    state.fetchers.set(key, loadFetcher);
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, submission, nextLocation, false, future.v7_skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, [match.route.id, actionResult]);
    // Put all revalidating fetchers into the loading state, except for the
    // current fetcher which we want to keep in it's current loading state which
    // contains it's action submission info + action data
    revalidatingFetchers.filter(rf => rf.key !== key).forEach(rf => {
      let staleKey = rf.key;
      let existingFetcher = state.fetchers.get(staleKey);
      let revalidatingFetcher = getLoadingFetcher(undefined, existingFetcher ? existingFetcher.data : undefined);
      state.fetchers.set(staleKey, revalidatingFetcher);
      abortFetcher(staleKey);
      if (rf.controller) {
        fetchControllers.set(staleKey, rf.controller);
      }
    });
    updateState({
      fetchers: new Map(state.fetchers)
    });
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(rf => abortFetcher(rf.key));
    abortController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    let {
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state, matches, matchesToLoad, revalidatingFetchers, revalidationRequest);
    if (abortController.signal.aborted) {
      return;
    }
    abortController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    fetchReloadIds.delete(key);
    fetchControllers.delete(key);
    revalidatingFetchers.forEach(r => fetchControllers.delete(r.key));
    let redirect = findRedirect(loaderResults);
    if (redirect) {
      return startRedirectNavigation(revalidationRequest, redirect.result, false, {
        preventScrollReset
      });
    }
    redirect = findRedirect(fetcherResults);
    if (redirect) {
      // If this redirect came from a fetcher make sure we mark it in
      // fetchRedirectIds so it doesn't get revalidated on the next set of
      // loader executions
      fetchRedirectIds.add(redirect.key);
      return startRedirectNavigation(revalidationRequest, redirect.result, false, {
        preventScrollReset
      });
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, matches, loaderResults, undefined, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Since we let revalidations complete even if the submitting fetcher was
    // deleted, only put it back to idle if it hasn't been deleted
    if (state.fetchers.has(key)) {
      let doneFetcher = getDoneFetcher(actionResult.data);
      state.fetchers.set(key, doneFetcher);
    }
    abortStaleFetchLoads(loadId);
    // If we are currently in a navigation loading state and this fetcher is
    // more recent than the navigation, we want the newer data so abort the
    // navigation and complete it with the fetcher data
    if (state.navigation.state === "loading" && loadId > pendingNavigationLoadId) {
      invariant(pendingAction, "Expected pending action");
      pendingNavigationController && pendingNavigationController.abort();
      completeNavigation(state.navigation.location, {
        matches,
        loaderData,
        errors,
        fetchers: new Map(state.fetchers)
      });
    } else {
      // otherwise just update with the fetcher data, preserving any existing
      // loaderData for loaders that did not need to reload.  We have to
      // manually merge here since we aren't going through completeNavigation
      updateState({
        errors,
        loaderData: mergeLoaderData(state.loaderData, loaderData, matches, errors),
        fetchers: new Map(state.fetchers)
      });
      isRevalidationRequired = false;
    }
  }
  // Call the matched loader for fetcher.load(), handling redirects, errors, etc.
  async function handleFetcherLoader(key, routeId, path, match, matches, isFogOfWar, flushSync, preventScrollReset, submission) {
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getLoadingFetcher(submission, existingFetcher ? existingFetcher.data : undefined), {
      flushSync
    });
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal);
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(matches, path, fetchRequest.signal);
      if (discoverResult.type === "aborted") {
        return;
      } else if (discoverResult.type === "error") {
        setFetcherError(key, routeId, discoverResult.error, {
          flushSync
        });
        return;
      } else if (!discoverResult.matches) {
        setFetcherError(key, routeId, getInternalRouterError(404, {
          pathname: path
        }), {
          flushSync
        });
        return;
      } else {
        matches = discoverResult.matches;
        match = getTargetMatch(matches, path);
      }
    }
    // Call the loader for this fetcher route match
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let results = await callDataStrategy("loader", state, fetchRequest, [match], matches, key);
    let result = results[match.route.id];
    // Deferred isn't supported for fetcher loads, await everything and treat it
    // as a normal load.  resolveDeferredData will return undefined if this
    // fetcher gets aborted, so we just leave result untouched and short circuit
    // below if that happens
    if (isDeferredResult(result)) {
      result = (await resolveDeferredData(result, fetchRequest.signal, true)) || result;
    }
    // We can delete this so long as we weren't aborted by our our own fetcher
    // re-load which would have put _new_ controller is in fetchControllers
    if (fetchControllers.get(key) === abortController) {
      fetchControllers.delete(key);
    }
    if (fetchRequest.signal.aborted) {
      return;
    }
    // We don't want errors bubbling up or redirects followed for unmounted
    // fetchers, so short circuit here if it was removed from the UI
    if (deletedFetchers.has(key)) {
      updateFetcherState(key, getDoneFetcher(undefined));
      return;
    }
    // If the loader threw a redirect Response, start a new REPLACE navigation
    if (isRedirectResult(result)) {
      if (pendingNavigationLoadId > originatingLoadId) {
        // A new navigation was kicked off after our loader started, so that
        // should take precedence over this redirect navigation
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      } else {
        fetchRedirectIds.add(key);
        await startRedirectNavigation(fetchRequest, result, false, {
          preventScrollReset
        });
        return;
      }
    }
    // Process any non-redirect errors thrown
    if (isErrorResult(result)) {
      setFetcherError(key, routeId, result.error);
      return;
    }
    invariant(!isDeferredResult(result), "Unhandled fetcher deferred data");
    // Put the fetcher back into an idle state
    updateFetcherState(key, getDoneFetcher(result.data));
  }
  /**
   * Utility function to handle redirects returned from an action or loader.
   * Normally, a redirect "replaces" the navigation that triggered it.  So, for
   * example:
   *
   *  - user is on /a
   *  - user clicks a link to /b
   *  - loader for /b redirects to /c
   *
   * In a non-JS app the browser would track the in-flight navigation to /b and
   * then replace it with /c when it encountered the redirect response.  In
   * the end it would only ever update the URL bar with /c.
   *
   * In client-side routing using pushState/replaceState, we aim to emulate
   * this behavior and we also do not update history until the end of the
   * navigation (including processed redirects).  This means that we never
   * actually touch history until we've processed redirects, so we just use
   * the history action from the original navigation (PUSH or REPLACE).
   */
  async function startRedirectNavigation(request, redirect, isNavigation, _temp2) {
    let {
      submission,
      fetcherSubmission,
      preventScrollReset,
      replace
    } = _temp2 === void 0 ? {} : _temp2;
    if (redirect.response.headers.has("X-Remix-Revalidate")) {
      isRevalidationRequired = true;
    }
    let location = redirect.response.headers.get("Location");
    invariant(location, "Expected a Location header on the redirect Response");
    location = normalizeRedirectLocation(location, new URL(request.url), basename);
    let redirectLocation = createLocation(state.location, location, {
      _isRedirect: true
    });
    if (isBrowser) {
      let isDocumentReload = false;
      if (redirect.response.headers.has("X-Remix-Reload-Document")) {
        // Hard reload if the response contained X-Remix-Reload-Document
        isDocumentReload = true;
      } else if (ABSOLUTE_URL_REGEX.test(location)) {
        const url = init.history.createURL(location);
        isDocumentReload =
        // Hard reload if it's an absolute URL to a new origin
        url.origin !== routerWindow.location.origin ||
        // Hard reload if it's an absolute URL that does not match our basename
        stripBasename(url.pathname, basename) == null;
      }
      if (isDocumentReload) {
        if (replace) {
          routerWindow.location.replace(location);
        } else {
          routerWindow.location.assign(location);
        }
        return;
      }
    }
    // There's no need to abort on redirects, since we don't detect the
    // redirect until the action/loaders have settled
    pendingNavigationController = null;
    let redirectHistoryAction = replace === true || redirect.response.headers.has("X-Remix-Replace") ? Action.Replace : Action.Push;
    // Use the incoming submission if provided, fallback on the active one in
    // state.navigation
    let {
      formMethod,
      formAction,
      formEncType
    } = state.navigation;
    if (!submission && !fetcherSubmission && formMethod && formAction && formEncType) {
      submission = getSubmissionFromNavigation(state.navigation);
    }
    // If this was a 307/308 submission we want to preserve the HTTP method and
    // re-submit the GET/POST/PUT/PATCH/DELETE as a submission navigation to the
    // redirected location
    let activeSubmission = submission || fetcherSubmission;
    if (redirectPreserveMethodStatusCodes.has(redirect.response.status) && activeSubmission && isMutationMethod(activeSubmission.formMethod)) {
      await startNavigation(redirectHistoryAction, redirectLocation, {
        submission: _extends({}, activeSubmission, {
          formAction: location
        }),
        // Preserve these flags across redirects
        preventScrollReset: preventScrollReset || pendingPreventScrollReset,
        enableViewTransition: isNavigation ? pendingViewTransitionEnabled : undefined
      });
    } else {
      // If we have a navigation submission, we will preserve it through the
      // redirect navigation
      let overrideNavigation = getLoadingNavigation(redirectLocation, submission);
      await startNavigation(redirectHistoryAction, redirectLocation, {
        overrideNavigation,
        // Send fetcher submissions through for shouldRevalidate
        fetcherSubmission,
        // Preserve these flags across redirects
        preventScrollReset: preventScrollReset || pendingPreventScrollReset,
        enableViewTransition: isNavigation ? pendingViewTransitionEnabled : undefined
      });
    }
  }
  // Utility wrapper for calling dataStrategy client-side without having to
  // pass around the manifest, mapRouteProperties, etc.
  async function callDataStrategy(type, state, request, matchesToLoad, matches, fetcherKey) {
    let results;
    let dataResults = {};
    try {
      results = await callDataStrategyImpl(dataStrategyImpl, type, state, request, matchesToLoad, matches, fetcherKey, manifest, mapRouteProperties);
    } catch (e) {
      // If the outer dataStrategy method throws, just return the error for all
      // matches - and it'll naturally bubble to the root
      matchesToLoad.forEach(m => {
        dataResults[m.route.id] = {
          type: ResultType.error,
          error: e
        };
      });
      return dataResults;
    }
    for (let [routeId, result] of Object.entries(results)) {
      if (isRedirectDataStrategyResultResult(result)) {
        let response = result.result;
        dataResults[routeId] = {
          type: ResultType.redirect,
          response: normalizeRelativeRoutingRedirectResponse(response, request, routeId, matches, basename, future.v7_relativeSplatPath)
        };
      } else {
        dataResults[routeId] = await convertDataStrategyResultToDataResult(result);
      }
    }
    return dataResults;
  }
  async function callLoadersAndMaybeResolveData(state, matches, matchesToLoad, fetchersToLoad, request) {
    let currentMatches = state.matches;
    // Kick off loaders and fetchers in parallel
    let loaderResultsPromise = callDataStrategy("loader", state, request, matchesToLoad, matches, null);
    let fetcherResultsPromise = Promise.all(fetchersToLoad.map(async f => {
      if (f.matches && f.match && f.controller) {
        let results = await callDataStrategy("loader", state, createClientSideRequest(init.history, f.path, f.controller.signal), [f.match], f.matches, f.key);
        let result = results[f.match.route.id];
        // Fetcher results are keyed by fetcher key from here on out, not routeId
        return {
          [f.key]: result
        };
      } else {
        return Promise.resolve({
          [f.key]: {
            type: ResultType.error,
            error: getInternalRouterError(404, {
              pathname: f.path
            })
          }
        });
      }
    }));
    let loaderResults = await loaderResultsPromise;
    let fetcherResults = (await fetcherResultsPromise).reduce((acc, r) => Object.assign(acc, r), {});
    await Promise.all([resolveNavigationDeferredResults(matches, loaderResults, request.signal, currentMatches, state.loaderData), resolveFetcherDeferredResults(matches, fetcherResults, fetchersToLoad)]);
    return {
      loaderResults,
      fetcherResults
    };
  }
  function interruptActiveLoads() {
    // Every interruption triggers a revalidation
    isRevalidationRequired = true;
    // Cancel pending route-level deferreds and mark cancelled routes for
    // revalidation
    cancelledDeferredRoutes.push(...cancelActiveDeferreds());
    // Abort in-flight fetcher loads
    fetchLoadMatches.forEach((_, key) => {
      if (fetchControllers.has(key)) {
        cancelledFetcherLoads.add(key);
      }
      abortFetcher(key);
    });
  }
  function updateFetcherState(key, fetcher, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state.fetchers.set(key, fetcher);
    updateState({
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function setFetcherError(key, routeId, error, opts) {
    if (opts === void 0) {
      opts = {};
    }
    let boundaryMatch = findNearestBoundary(state.matches, routeId);
    deleteFetcher(key);
    updateState({
      errors: {
        [boundaryMatch.route.id]: error
      },
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function getFetcher(key) {
    if (future.v7_fetcherPersist) {
      activeFetchers.set(key, (activeFetchers.get(key) || 0) + 1);
      // If this fetcher was previously marked for deletion, unmark it since we
      // have a new instance
      if (deletedFetchers.has(key)) {
        deletedFetchers.delete(key);
      }
    }
    return state.fetchers.get(key) || IDLE_FETCHER;
  }
  function deleteFetcher(key) {
    let fetcher = state.fetchers.get(key);
    // Don't abort the controller if this is a deletion of a fetcher.submit()
    // in it's loading phase since - we don't want to abort the corresponding
    // revalidation and want them to complete and land
    if (fetchControllers.has(key) && !(fetcher && fetcher.state === "loading" && fetchReloadIds.has(key))) {
      abortFetcher(key);
    }
    fetchLoadMatches.delete(key);
    fetchReloadIds.delete(key);
    fetchRedirectIds.delete(key);
    deletedFetchers.delete(key);
    cancelledFetcherLoads.delete(key);
    state.fetchers.delete(key);
  }
  function deleteFetcherAndUpdateState(key) {
    if (future.v7_fetcherPersist) {
      let count = (activeFetchers.get(key) || 0) - 1;
      if (count <= 0) {
        activeFetchers.delete(key);
        deletedFetchers.add(key);
      } else {
        activeFetchers.set(key, count);
      }
    } else {
      deleteFetcher(key);
    }
    updateState({
      fetchers: new Map(state.fetchers)
    });
  }
  function abortFetcher(key) {
    let controller = fetchControllers.get(key);
    if (controller) {
      controller.abort();
      fetchControllers.delete(key);
    }
  }
  function markFetchersDone(keys) {
    for (let key of keys) {
      let fetcher = getFetcher(key);
      let doneFetcher = getDoneFetcher(fetcher.data);
      state.fetchers.set(key, doneFetcher);
    }
  }
  function markFetchRedirectsDone() {
    let doneKeys = [];
    let updatedFetchers = false;
    for (let key of fetchRedirectIds) {
      let fetcher = state.fetchers.get(key);
      invariant(fetcher, "Expected fetcher: " + key);
      if (fetcher.state === "loading") {
        fetchRedirectIds.delete(key);
        doneKeys.push(key);
        updatedFetchers = true;
      }
    }
    markFetchersDone(doneKeys);
    return updatedFetchers;
  }
  function abortStaleFetchLoads(landedId) {
    let yeetedKeys = [];
    for (let [key, id] of fetchReloadIds) {
      if (id < landedId) {
        let fetcher = state.fetchers.get(key);
        invariant(fetcher, "Expected fetcher: " + key);
        if (fetcher.state === "loading") {
          abortFetcher(key);
          fetchReloadIds.delete(key);
          yeetedKeys.push(key);
        }
      }
    }
    markFetchersDone(yeetedKeys);
    return yeetedKeys.length > 0;
  }
  function getBlocker(key, fn) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    if (blockerFunctions.get(key) !== fn) {
      blockerFunctions.set(key, fn);
    }
    return blocker;
  }
  function deleteBlocker(key) {
    state.blockers.delete(key);
    blockerFunctions.delete(key);
  }
  // Utility function to update blockers, ensuring valid state transitions
  function updateBlocker(key, newBlocker) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    // Poor mans state machine :)
    // https://mermaid.live/edit#pako:eNqVkc9OwzAMxl8l8nnjAYrEtDIOHEBIgwvKJTReGy3_lDpIqO27k6awMG0XcrLlnz87nwdonESogKXXBuE79rq75XZO3-yHds0RJVuv70YrPlUrCEe2HfrORS3rubqZfuhtpg5C9wk5tZ4VKcRUq88q9Z8RS0-48cE1iHJkL0ugbHuFLus9L6spZy8nX9MP2CNdomVaposqu3fGayT8T8-jJQwhepo_UtpgBQaDEUom04dZhAN1aJBDlUKJBxE1ceB2Smj0Mln-IBW5AFU2dwUiktt_2Qaq2dBfaKdEup85UV7Yd-dKjlnkabl2Pvr0DTkTreM
    invariant(blocker.state === "unblocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "proceeding" || blocker.state === "blocked" && newBlocker.state === "unblocked" || blocker.state === "proceeding" && newBlocker.state === "unblocked", "Invalid blocker state transition: " + blocker.state + " -> " + newBlocker.state);
    let blockers = new Map(state.blockers);
    blockers.set(key, newBlocker);
    updateState({
      blockers
    });
  }
  function shouldBlockNavigation(_ref2) {
    let {
      currentLocation,
      nextLocation,
      historyAction
    } = _ref2;
    if (blockerFunctions.size === 0) {
      return;
    }
    // We ony support a single active blocker at the moment since we don't have
    // any compelling use cases for multi-blocker yet
    if (blockerFunctions.size > 1) {
      warning(false, "A router only supports one blocker at a time");
    }
    let entries = Array.from(blockerFunctions.entries());
    let [blockerKey, blockerFunction] = entries[entries.length - 1];
    let blocker = state.blockers.get(blockerKey);
    if (blocker && blocker.state === "proceeding") {
      // If the blocker is currently proceeding, we don't need to re-check
      // it and can let this navigation continue
      return;
    }
    // At this point, we know we're unblocked/blocked so we need to check the
    // user-provided blocker function
    if (blockerFunction({
      currentLocation,
      nextLocation,
      historyAction
    })) {
      return blockerKey;
    }
  }
  function handleNavigational404(pathname) {
    let error = getInternalRouterError(404, {
      pathname
    });
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let {
      matches,
      route
    } = getShortCircuitMatches(routesToUse);
    // Cancel all pending deferred on 404s since we don't keep any routes
    cancelActiveDeferreds();
    return {
      notFoundMatches: matches,
      route,
      error
    };
  }
  function cancelActiveDeferreds(predicate) {
    let cancelledRouteIds = [];
    activeDeferreds.forEach((dfd, routeId) => {
      if (!predicate || predicate(routeId)) {
        // Cancel the deferred - but do not remove from activeDeferreds here -
        // we rely on the subscribers to do that so our tests can assert proper
        // cleanup via _internalActiveDeferreds
        dfd.cancel();
        cancelledRouteIds.push(routeId);
        activeDeferreds.delete(routeId);
      }
    });
    return cancelledRouteIds;
  }
  // Opt in to capturing and reporting scroll positions during navigations,
  // used by the <ScrollRestoration> component
  function enableScrollRestoration(positions, getPosition, getKey) {
    savedScrollPositions = positions;
    getScrollPosition = getPosition;
    getScrollRestorationKey = getKey || null;
    // Perform initial hydration scroll restoration, since we miss the boat on
    // the initial updateState() because we've not yet rendered <ScrollRestoration/>
    // and therefore have no savedScrollPositions available
    if (!initialScrollRestored && state.navigation === IDLE_NAVIGATION) {
      initialScrollRestored = true;
      let y = getSavedScrollPosition(state.location, state.matches);
      if (y != null) {
        updateState({
          restoreScrollPosition: y
        });
      }
    }
    return () => {
      savedScrollPositions = null;
      getScrollPosition = null;
      getScrollRestorationKey = null;
    };
  }
  function getScrollKey(location, matches) {
    if (getScrollRestorationKey) {
      let key = getScrollRestorationKey(location, matches.map(m => convertRouteMatchToUiMatch(m, state.loaderData)));
      return key || location.key;
    }
    return location.key;
  }
  function saveScrollPosition(location, matches) {
    if (savedScrollPositions && getScrollPosition) {
      let key = getScrollKey(location, matches);
      savedScrollPositions[key] = getScrollPosition();
    }
  }
  function getSavedScrollPosition(location, matches) {
    if (savedScrollPositions) {
      let key = getScrollKey(location, matches);
      let y = savedScrollPositions[key];
      if (typeof y === "number") {
        return y;
      }
    }
    return null;
  }
  function checkFogOfWar(matches, routesToUse, pathname) {
    if (patchRoutesOnNavigationImpl) {
      if (!matches) {
        let fogMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
        return {
          active: true,
          matches: fogMatches || []
        };
      } else {
        if (Object.keys(matches[0].params).length > 0) {
          // If we matched a dynamic param or a splat, it might only be because
          // we haven't yet discovered other routes that would match with a
          // higher score.  Call patchRoutesOnNavigation just to be sure
          let partialMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
          return {
            active: true,
            matches: partialMatches
          };
        }
      }
    }
    return {
      active: false,
      matches: null
    };
  }
  async function discoverRoutes(matches, pathname, signal) {
    if (!patchRoutesOnNavigationImpl) {
      return {
        type: "success",
        matches
      };
    }
    let partialMatches = matches;
    while (true) {
      let isNonHMR = inFlightDataRoutes == null;
      let routesToUse = inFlightDataRoutes || dataRoutes;
      let localManifest = manifest;
      try {
        await patchRoutesOnNavigationImpl({
          path: pathname,
          matches: partialMatches,
          patch: (routeId, children) => {
            if (signal.aborted) return;
            patchRoutesImpl(routeId, children, routesToUse, localManifest, mapRouteProperties);
          }
        });
      } catch (e) {
        return {
          type: "error",
          error: e,
          partialMatches
        };
      } finally {
        // If we are not in the middle of an HMR revalidation and we changed the
        // routes, provide a new identity so when we `updateState` at the end of
        // this navigation/fetch `router.routes` will be a new identity and
        // trigger a re-run of memoized `router.routes` dependencies.
        // HMR will already update the identity and reflow when it lands
        // `inFlightDataRoutes` in `completeNavigation`
        if (isNonHMR && !signal.aborted) {
          dataRoutes = [...dataRoutes];
        }
      }
      if (signal.aborted) {
        return {
          type: "aborted"
        };
      }
      let newMatches = matchRoutes(routesToUse, pathname, basename);
      if (newMatches) {
        return {
          type: "success",
          matches: newMatches
        };
      }
      let newPartialMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
      // Avoid loops if the second pass results in the same partial matches
      if (!newPartialMatches || partialMatches.length === newPartialMatches.length && partialMatches.every((m, i) => m.route.id === newPartialMatches[i].route.id)) {
        return {
          type: "success",
          matches: null
        };
      }
      partialMatches = newPartialMatches;
    }
  }
  function _internalSetRoutes(newRoutes) {
    manifest = {};
    inFlightDataRoutes = convertRoutesToDataRoutes(newRoutes, mapRouteProperties, undefined, manifest);
  }
  function patchRoutes(routeId, children) {
    let isNonHMR = inFlightDataRoutes == null;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    patchRoutesImpl(routeId, children, routesToUse, manifest, mapRouteProperties);
    // If we are not in the middle of an HMR revalidation and we changed the
    // routes, provide a new identity and trigger a reflow via `updateState`
    // to re-run memoized `router.routes` dependencies.
    // HMR will already update the identity and reflow when it lands
    // `inFlightDataRoutes` in `completeNavigation`
    if (isNonHMR) {
      dataRoutes = [...dataRoutes];
      updateState({});
    }
  }
  router = {
    get basename() {
      return basename;
    },
    get future() {
      return future;
    },
    get state() {
      return state;
    },
    get routes() {
      return dataRoutes;
    },
    get window() {
      return routerWindow;
    },
    initialize,
    subscribe,
    enableScrollRestoration,
    navigate,
    fetch,
    revalidate,
    // Passthrough to history-aware createHref used by useHref so we get proper
    // hash-aware URLs in DOM paths
    createHref: to => init.history.createHref(to),
    encodeLocation: to => init.history.encodeLocation(to),
    getFetcher,
    deleteFetcher: deleteFetcherAndUpdateState,
    dispose,
    getBlocker,
    deleteBlocker,
    patchRoutes,
    _internalFetchControllers: fetchControllers,
    _internalActiveDeferreds: activeDeferreds,
    // TODO: Remove setRoutes, it's temporary to avoid dealing with
    // updating the tree while validating the update algorithm.
    _internalSetRoutes
  };
  return router;
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createStaticHandler
////////////////////////////////////////////////////////////////////////////////
const UNSAFE_DEFERRED_SYMBOL = Symbol("deferred");
function createStaticHandler(routes, opts) {
  invariant(routes.length > 0, "You must provide a non-empty routes array to createStaticHandler");
  let manifest = {};
  let basename = (opts ? opts.basename : null) || "/";
  let mapRouteProperties;
  if (opts != null && opts.mapRouteProperties) {
    mapRouteProperties = opts.mapRouteProperties;
  } else if (opts != null && opts.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = opts.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Config driven behavior flags
  let future = _extends({
    v7_relativeSplatPath: false,
    v7_throwAbortReason: false
  }, opts ? opts.future : null);
  let dataRoutes = convertRoutesToDataRoutes(routes, mapRouteProperties, undefined, manifest);
  /**
   * The query() method is intended for document requests, in which we want to
   * call an optional action and potentially multiple loaders for all nested
   * routes.  It returns a StaticHandlerContext object, which is very similar
   * to the router state (location, loaderData, actionData, errors, etc.) and
   * also adds SSR-specific information such as the statusCode and headers
   * from action/loaders Responses.
   *
   * It _should_ never throw and should report all errors through the
   * returned context.errors object, properly associating errors to their error
   * boundary.  Additionally, it tracks _deepestRenderedBoundaryId which can be
   * used to emulate React error boundaries during SSr by performing a second
   * pass only down to the boundaryId.
   *
   * The one exception where we do not return a StaticHandlerContext is when a
   * redirect response is returned or thrown from any action/loader.  We
   * propagate that out and return the raw Response so the HTTP server can
   * return it directly.
   *
   * - `opts.requestContext` is an optional server context that will be passed
   *   to actions/loaders in the `context` parameter
   * - `opts.skipLoaderErrorBubbling` is an optional parameter that will prevent
   *   the bubbling of errors which allows single-fetch-type implementations
   *   where the client will handle the bubbling and we may need to return data
   *   for the handling route
   */
  async function query(request, _temp3) {
    let {
      requestContext,
      skipLoaderErrorBubbling,
      dataStrategy
    } = _temp3 === void 0 ? {} : _temp3;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD") {
      let error = getInternalRouterError(405, {
        method
      });
      let {
        matches: methodNotAllowedMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: methodNotAllowedMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    } else if (!matches) {
      let error = getInternalRouterError(404, {
        pathname: location.pathname
      });
      let {
        matches: notFoundMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: notFoundMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    let result = await queryImpl(request, location, matches, requestContext, dataStrategy || null, skipLoaderErrorBubbling === true, null);
    if (isResponse(result)) {
      return result;
    }
    // When returning StaticHandlerContext, we patch back in the location here
    // since we need it for React Context.  But this helps keep our submit and
    // loadRouteData operating on a Request instead of a Location
    return _extends({
      location,
      basename
    }, result);
  }
  /**
   * The queryRoute() method is intended for targeted route requests, either
   * for fetch ?_data requests or resource route requests.  In this case, we
   * are only ever calling a single action or loader, and we are returning the
   * returned value directly.  In most cases, this will be a Response returned
   * from the action/loader, but it may be a primitive or other value as well -
   * and in such cases the calling context should handle that accordingly.
   *
   * We do respect the throw/return differentiation, so if an action/loader
   * throws, then this method will throw the value.  This is important so we
   * can do proper boundary identification in Remix where a thrown Response
   * must go to the Catch Boundary but a returned Response is happy-path.
   *
   * One thing to note is that any Router-initiated Errors that make sense
   * to associate with a status code will be thrown as an ErrorResponse
   * instance which include the raw Error, such that the calling context can
   * serialize the error as they see fit while including the proper response
   * code.  Examples here are 404 and 405 errors that occur prior to reaching
   * any user-defined loaders.
   *
   * - `opts.routeId` allows you to specify the specific route handler to call.
   *   If not provided the handler will determine the proper route by matching
   *   against `request.url`
   * - `opts.requestContext` is an optional server context that will be passed
   *    to actions/loaders in the `context` parameter
   */
  async function queryRoute(request, _temp4) {
    let {
      routeId,
      requestContext,
      dataStrategy
    } = _temp4 === void 0 ? {} : _temp4;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD" && method !== "OPTIONS") {
      throw getInternalRouterError(405, {
        method
      });
    } else if (!matches) {
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let match = routeId ? matches.find(m => m.route.id === routeId) : getTargetMatch(matches, location);
    if (routeId && !match) {
      throw getInternalRouterError(403, {
        pathname: location.pathname,
        routeId
      });
    } else if (!match) {
      // This should never hit I don't think?
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let result = await queryImpl(request, location, matches, requestContext, dataStrategy || null, false, match);
    if (isResponse(result)) {
      return result;
    }
    let error = result.errors ? Object.values(result.errors)[0] : undefined;
    if (error !== undefined) {
      // If we got back result.errors, that means the loader/action threw
      // _something_ that wasn't a Response, but it's not guaranteed/required
      // to be an `instanceof Error` either, so we have to use throw here to
      // preserve the "error" state outside of queryImpl.
      throw error;
    }
    // Pick off the right state value to return
    if (result.actionData) {
      return Object.values(result.actionData)[0];
    }
    if (result.loaderData) {
      var _result$activeDeferre;
      let data = Object.values(result.loaderData)[0];
      if ((_result$activeDeferre = result.activeDeferreds) != null && _result$activeDeferre[match.route.id]) {
        data[UNSAFE_DEFERRED_SYMBOL] = result.activeDeferreds[match.route.id];
      }
      return data;
    }
    return undefined;
  }
  async function queryImpl(request, location, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch) {
    invariant(request.signal, "query()/queryRoute() requests must contain an AbortController signal");
    try {
      if (isMutationMethod(request.method.toLowerCase())) {
        let result = await submit(request, matches, routeMatch || getTargetMatch(matches, location), requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch != null);
        return result;
      }
      let result = await loadRouteData(request, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch);
      return isResponse(result) ? result : _extends({}, result, {
        actionData: null,
        actionHeaders: {}
      });
    } catch (e) {
      // If the user threw/returned a Response in callLoaderOrAction for a
      // `queryRoute` call, we throw the `DataStrategyResult` to bail out early
      // and then return or throw the raw Response here accordingly
      if (isDataStrategyResult(e) && isResponse(e.result)) {
        if (e.type === ResultType.error) {
          throw e.result;
        }
        return e.result;
      }
      // Redirects are always returned since they don't propagate to catch
      // boundaries
      if (isRedirectResponse(e)) {
        return e;
      }
      throw e;
    }
  }
  async function submit(request, matches, actionMatch, requestContext, dataStrategy, skipLoaderErrorBubbling, isRouteRequest) {
    let result;
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      let error = getInternalRouterError(405, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: actionMatch.route.id
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    } else {
      let results = await callDataStrategy("action", request, [actionMatch], matches, isRouteRequest, requestContext, dataStrategy);
      result = results[actionMatch.route.id];
      if (request.signal.aborted) {
        throwStaticHandlerAbortedError(request, isRouteRequest, future);
      }
    }
    if (isRedirectResult(result)) {
      // Uhhhh - this should never happen, we should always throw these from
      // callLoaderOrAction, but the type narrowing here keeps TS happy and we
      // can get back on the "throw all redirect responses" train here should
      // this ever happen :/
      throw new Response(null, {
        status: result.response.status,
        headers: {
          Location: result.response.headers.get("Location")
        }
      });
    }
    if (isDeferredResult(result)) {
      let error = getInternalRouterError(400, {
        type: "defer-action"
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    }
    if (isRouteRequest) {
      // Note: This should only be non-Response values if we get here, since
      // isRouteRequest should throw any Response received in callLoaderOrAction
      if (isErrorResult(result)) {
        throw result.error;
      }
      return {
        matches: [actionMatch],
        loaderData: {},
        actionData: {
          [actionMatch.route.id]: result.data
        },
        errors: null,
        // Note: statusCode + headers are unused here since queryRoute will
        // return the raw Response or value
        statusCode: 200,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    // Create a GET request for the loaders
    let loaderRequest = new Request(request.url, {
      headers: request.headers,
      redirect: request.redirect,
      signal: request.signal
    });
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = skipLoaderErrorBubbling ? actionMatch : findNearestBoundary(matches, actionMatch.route.id);
      let context = await loadRouteData(loaderRequest, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, null, [boundaryMatch.route.id, result]);
      // action status codes take precedence over loader status codes
      return _extends({}, context, {
        statusCode: isRouteErrorResponse(result.error) ? result.error.status : result.statusCode != null ? result.statusCode : 500,
        actionData: null,
        actionHeaders: _extends({}, result.headers ? {
          [actionMatch.route.id]: result.headers
        } : {})
      });
    }
    let context = await loadRouteData(loaderRequest, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, null);
    return _extends({}, context, {
      actionData: {
        [actionMatch.route.id]: result.data
      }
    }, result.statusCode ? {
      statusCode: result.statusCode
    } : {}, {
      actionHeaders: result.headers ? {
        [actionMatch.route.id]: result.headers
      } : {}
    });
  }
  async function loadRouteData(request, matches, requestContext, dataStrategy, skipLoaderErrorBubbling, routeMatch, pendingActionResult) {
    let isRouteRequest = routeMatch != null;
    // Short circuit if we have no loaders to run (queryRoute())
    if (isRouteRequest && !(routeMatch != null && routeMatch.route.loader) && !(routeMatch != null && routeMatch.route.lazy)) {
      throw getInternalRouterError(400, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: routeMatch == null ? void 0 : routeMatch.route.id
      });
    }
    let requestMatches = routeMatch ? [routeMatch] : pendingActionResult && isErrorResult(pendingActionResult[1]) ? getLoaderMatchesUntilBoundary(matches, pendingActionResult[0]) : matches;
    let matchesToLoad = requestMatches.filter(m => m.route.loader || m.route.lazy);
    // Short circuit if we have no loaders to run (query())
    if (matchesToLoad.length === 0) {
      return {
        matches,
        // Add a null for all matched routes for proper revalidation on the client
        loaderData: matches.reduce((acc, m) => Object.assign(acc, {
          [m.route.id]: null
        }), {}),
        errors: pendingActionResult && isErrorResult(pendingActionResult[1]) ? {
          [pendingActionResult[0]]: pendingActionResult[1].error
        } : null,
        statusCode: 200,
        loaderHeaders: {},
        activeDeferreds: null
      };
    }
    let results = await callDataStrategy("loader", request, matchesToLoad, matches, isRouteRequest, requestContext, dataStrategy);
    if (request.signal.aborted) {
      throwStaticHandlerAbortedError(request, isRouteRequest, future);
    }
    // Process and commit output from loaders
    let activeDeferreds = new Map();
    let context = processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, skipLoaderErrorBubbling);
    // Add a null for any non-loader matches for proper revalidation on the client
    let executedLoaders = new Set(matchesToLoad.map(match => match.route.id));
    matches.forEach(match => {
      if (!executedLoaders.has(match.route.id)) {
        context.loaderData[match.route.id] = null;
      }
    });
    return _extends({}, context, {
      matches,
      activeDeferreds: activeDeferreds.size > 0 ? Object.fromEntries(activeDeferreds.entries()) : null
    });
  }
  // Utility wrapper for calling dataStrategy server-side without having to
  // pass around the manifest, mapRouteProperties, etc.
  async function callDataStrategy(type, request, matchesToLoad, matches, isRouteRequest, requestContext, dataStrategy) {
    let results = await callDataStrategyImpl(dataStrategy || defaultDataStrategy, type, null, request, matchesToLoad, matches, null, manifest, mapRouteProperties, requestContext);
    let dataResults = {};
    await Promise.all(matches.map(async match => {
      if (!(match.route.id in results)) {
        return;
      }
      let result = results[match.route.id];
      if (isRedirectDataStrategyResultResult(result)) {
        let response = result.result;
        // Throw redirects and let the server handle them with an HTTP redirect
        throw normalizeRelativeRoutingRedirectResponse(response, request, match.route.id, matches, basename, future.v7_relativeSplatPath);
      }
      if (isResponse(result.result) && isRouteRequest) {
        // For SSR single-route requests, we want to hand Responses back
        // directly without unwrapping
        throw result;
      }
      dataResults[match.route.id] = await convertDataStrategyResultToDataResult(result);
    }));
    return dataResults;
  }
  return {
    dataRoutes,
    query,
    queryRoute
  };
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Helpers
////////////////////////////////////////////////////////////////////////////////
/**
 * Given an existing StaticHandlerContext and an error thrown at render time,
 * provide an updated StaticHandlerContext suitable for a second SSR render
 */
function getStaticContextFromError(routes, context, error) {
  let newContext = _extends({}, context, {
    statusCode: isRouteErrorResponse(error) ? error.status : 500,
    errors: {
      [context._deepestRenderedBoundaryId || routes[0].id]: error
    }
  });
  return newContext;
}
function throwStaticHandlerAbortedError(request, isRouteRequest, future) {
  if (future.v7_throwAbortReason && request.signal.reason !== undefined) {
    throw request.signal.reason;
  }
  let method = isRouteRequest ? "queryRoute" : "query";
  throw new Error(method + "() call aborted: " + request.method + " " + request.url);
}
function isSubmissionNavigation(opts) {
  return opts != null && ("formData" in opts && opts.formData != null || "body" in opts && opts.body !== undefined);
}
function normalizeTo(location, matches, basename, prependBasename, to, v7_relativeSplatPath, fromRouteId, relative) {
  let contextualMatches;
  let activeRouteMatch;
  if (fromRouteId) {
    // Grab matches up to the calling route so our route-relative logic is
    // relative to the correct source route
    contextualMatches = [];
    for (let match of matches) {
      contextualMatches.push(match);
      if (match.route.id === fromRouteId) {
        activeRouteMatch = match;
        break;
      }
    }
  } else {
    contextualMatches = matches;
    activeRouteMatch = matches[matches.length - 1];
  }
  // Resolve the relative path
  let path = resolveTo(to ? to : ".", getResolveToMatches(contextualMatches, v7_relativeSplatPath), stripBasename(location.pathname, basename) || location.pathname, relative === "path");
  // When `to` is not specified we inherit search/hash from the current
  // location, unlike when to="." and we just inherit the path.
  // See https://github.com/remix-run/remix/issues/927
  if (to == null) {
    path.search = location.search;
    path.hash = location.hash;
  }
  // Account for `?index` params when routing to the current location
  if ((to == null || to === "" || to === ".") && activeRouteMatch) {
    let nakedIndex = hasNakedIndexQuery(path.search);
    if (activeRouteMatch.route.index && !nakedIndex) {
      // Add one when we're targeting an index route
      path.search = path.search ? path.search.replace(/^\?/, "?index&") : "?index";
    } else if (!activeRouteMatch.route.index && nakedIndex) {
      // Remove existing ones when we're not
      let params = new URLSearchParams(path.search);
      let indexValues = params.getAll("index");
      params.delete("index");
      indexValues.filter(v => v).forEach(v => params.append("index", v));
      let qs = params.toString();
      path.search = qs ? "?" + qs : "";
    }
  }
  // If we're operating within a basename, prepend it to the pathname.  If
  // this is a root navigation, then just use the raw basename which allows
  // the basename to have full control over the presence of a trailing slash
  // on root actions
  if (prependBasename && basename !== "/") {
    path.pathname = path.pathname === "/" ? basename : joinPaths([basename, path.pathname]);
  }
  return createPath(path);
}
// Normalize navigation options by converting formMethod=GET formData objects to
// URLSearchParams so they behave identically to links with query params
function normalizeNavigateOptions(normalizeFormMethod, isFetcher, path, opts) {
  // Return location verbatim on non-submission navigations
  if (!opts || !isSubmissionNavigation(opts)) {
    return {
      path
    };
  }
  if (opts.formMethod && !isValidMethod(opts.formMethod)) {
    return {
      path,
      error: getInternalRouterError(405, {
        method: opts.formMethod
      })
    };
  }
  let getInvalidBodyError = () => ({
    path,
    error: getInternalRouterError(400, {
      type: "invalid-body"
    })
  });
  // Create a Submission on non-GET navigations
  let rawFormMethod = opts.formMethod || "get";
  let formMethod = normalizeFormMethod ? rawFormMethod.toUpperCase() : rawFormMethod.toLowerCase();
  let formAction = stripHashFromPath(path);
  if (opts.body !== undefined) {
    if (opts.formEncType === "text/plain") {
      // text only support POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      let text = typeof opts.body === "string" ? opts.body : opts.body instanceof FormData || opts.body instanceof URLSearchParams ?
      // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#plain-text-form-data
      Array.from(opts.body.entries()).reduce((acc, _ref3) => {
        let [name, value] = _ref3;
        return "" + acc + name + "=" + value + "\n";
      }, "") : String(opts.body);
      return {
        path,
        submission: {
          formMethod,
          formAction,
          formEncType: opts.formEncType,
          formData: undefined,
          json: undefined,
          text
        }
      };
    } else if (opts.formEncType === "application/json") {
      // json only supports POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      try {
        let json = typeof opts.body === "string" ? JSON.parse(opts.body) : opts.body;
        return {
          path,
          submission: {
            formMethod,
            formAction,
            formEncType: opts.formEncType,
            formData: undefined,
            json,
            text: undefined
          }
        };
      } catch (e) {
        return getInvalidBodyError();
      }
    }
  }
  invariant(typeof FormData === "function", "FormData is not available in this environment");
  let searchParams;
  let formData;
  if (opts.formData) {
    searchParams = convertFormDataToSearchParams(opts.formData);
    formData = opts.formData;
  } else if (opts.body instanceof FormData) {
    searchParams = convertFormDataToSearchParams(opts.body);
    formData = opts.body;
  } else if (opts.body instanceof URLSearchParams) {
    searchParams = opts.body;
    formData = convertSearchParamsToFormData(searchParams);
  } else if (opts.body == null) {
    searchParams = new URLSearchParams();
    formData = new FormData();
  } else {
    try {
      searchParams = new URLSearchParams(opts.body);
      formData = convertSearchParamsToFormData(searchParams);
    } catch (e) {
      return getInvalidBodyError();
    }
  }
  let submission = {
    formMethod,
    formAction,
    formEncType: opts && opts.formEncType || "application/x-www-form-urlencoded",
    formData,
    json: undefined,
    text: undefined
  };
  if (isMutationMethod(submission.formMethod)) {
    return {
      path,
      submission
    };
  }
  // Flatten submission onto URLSearchParams for GET submissions
  let parsedPath = parsePath(path);
  // On GET navigation submissions we can drop the ?index param from the
  // resulting location since all loaders will run.  But fetcher GET submissions
  // only run a single loader so we need to preserve any incoming ?index params
  if (isFetcher && parsedPath.search && hasNakedIndexQuery(parsedPath.search)) {
    searchParams.append("index", "");
  }
  parsedPath.search = "?" + searchParams;
  return {
    path: createPath(parsedPath),
    submission
  };
}
// Filter out all routes at/below any caught error as they aren't going to
// render so we don't need to load them
function getLoaderMatchesUntilBoundary(matches, boundaryId, includeBoundary) {
  if (includeBoundary === void 0) {
    includeBoundary = false;
  }
  let index = matches.findIndex(m => m.route.id === boundaryId);
  if (index >= 0) {
    return matches.slice(0, includeBoundary ? index + 1 : index);
  }
  return matches;
}
function getMatchesToLoad(history, state, matches, submission, location, initialHydration, skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionResult) {
  let actionResult = pendingActionResult ? isErrorResult(pendingActionResult[1]) ? pendingActionResult[1].error : pendingActionResult[1].data : undefined;
  let currentUrl = history.createURL(state.location);
  let nextUrl = history.createURL(location);
  // Pick navigation matches that are net-new or qualify for revalidation
  let boundaryMatches = matches;
  if (initialHydration && state.errors) {
    // On initial hydration, only consider matches up to _and including_ the boundary.
    // This is inclusive to handle cases where a server loader ran successfully,
    // a child server loader bubbled up to this route, but this route has
    // `clientLoader.hydrate` so we want to still run the `clientLoader` so that
    // we have a complete version of `loaderData`
    boundaryMatches = getLoaderMatchesUntilBoundary(matches, Object.keys(state.errors)[0], true);
  } else if (pendingActionResult && isErrorResult(pendingActionResult[1])) {
    // If an action threw an error, we call loaders up to, but not including the
    // boundary
    boundaryMatches = getLoaderMatchesUntilBoundary(matches, pendingActionResult[0]);
  }
  // Don't revalidate loaders by default after action 4xx/5xx responses
  // when the flag is enabled.  They can still opt-into revalidation via
  // `shouldRevalidate` via `actionResult`
  let actionStatus = pendingActionResult ? pendingActionResult[1].statusCode : undefined;
  let shouldSkipRevalidation = skipActionErrorRevalidation && actionStatus && actionStatus >= 400;
  let navigationMatches = boundaryMatches.filter((match, index) => {
    let {
      route
    } = match;
    if (route.lazy) {
      // We haven't loaded this route yet so we don't know if it's got a loader!
      return true;
    }
    if (route.loader == null) {
      return false;
    }
    if (initialHydration) {
      return shouldLoadRouteOnHydration(route, state.loaderData, state.errors);
    }
    // Always call the loader on new route instances and pending defer cancellations
    if (isNewLoader(state.loaderData, state.matches[index], match) || cancelledDeferredRoutes.some(id => id === match.route.id)) {
      return true;
    }
    // This is the default implementation for when we revalidate.  If the route
    // provides it's own implementation, then we give them full control but
    // provide this value so they can leverage it if needed after they check
    // their own specific use cases
    let currentRouteMatch = state.matches[index];
    let nextRouteMatch = match;
    return shouldRevalidateLoader(match, _extends({
      currentUrl,
      currentParams: currentRouteMatch.params,
      nextUrl,
      nextParams: nextRouteMatch.params
    }, submission, {
      actionResult,
      actionStatus,
      defaultShouldRevalidate: shouldSkipRevalidation ? false :
      // Forced revalidation due to submission, useRevalidator, or X-Remix-Revalidate
      isRevalidationRequired || currentUrl.pathname + currentUrl.search === nextUrl.pathname + nextUrl.search ||
      // Search params affect all loaders
      currentUrl.search !== nextUrl.search || isNewRouteInstance(currentRouteMatch, nextRouteMatch)
    }));
  });
  // Pick fetcher.loads that need to be revalidated
  let revalidatingFetchers = [];
  fetchLoadMatches.forEach((f, key) => {
    // Don't revalidate:
    //  - on initial hydration (shouldn't be any fetchers then anyway)
    //  - if fetcher won't be present in the subsequent render
    //    - no longer matches the URL (v7_fetcherPersist=false)
    //    - was unmounted but persisted due to v7_fetcherPersist=true
    if (initialHydration || !matches.some(m => m.route.id === f.routeId) || deletedFetchers.has(key)) {
      return;
    }
    let fetcherMatches = matchRoutes(routesToUse, f.path, basename);
    // If the fetcher path no longer matches, push it in with null matches so
    // we can trigger a 404 in callLoadersAndMaybeResolveData.  Note this is
    // currently only a use-case for Remix HMR where the route tree can change
    // at runtime and remove a route previously loaded via a fetcher
    if (!fetcherMatches) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: null,
        match: null,
        controller: null
      });
      return;
    }
    // Revalidating fetchers are decoupled from the route matches since they
    // load from a static href.  They revalidate based on explicit revalidation
    // (submission, useRevalidator, or X-Remix-Revalidate)
    let fetcher = state.fetchers.get(key);
    let fetcherMatch = getTargetMatch(fetcherMatches, f.path);
    let shouldRevalidate = false;
    if (fetchRedirectIds.has(key)) {
      // Never trigger a revalidation of an actively redirecting fetcher
      shouldRevalidate = false;
    } else if (cancelledFetcherLoads.has(key)) {
      // Always mark for revalidation if the fetcher was cancelled
      cancelledFetcherLoads.delete(key);
      shouldRevalidate = true;
    } else if (fetcher && fetcher.state !== "idle" && fetcher.data === undefined) {
      // If the fetcher hasn't ever completed loading yet, then this isn't a
      // revalidation, it would just be a brand new load if an explicit
      // revalidation is required
      shouldRevalidate = isRevalidationRequired;
    } else {
      // Otherwise fall back on any user-defined shouldRevalidate, defaulting
      // to explicit revalidations only
      shouldRevalidate = shouldRevalidateLoader(fetcherMatch, _extends({
        currentUrl,
        currentParams: state.matches[state.matches.length - 1].params,
        nextUrl,
        nextParams: matches[matches.length - 1].params
      }, submission, {
        actionResult,
        actionStatus,
        defaultShouldRevalidate: shouldSkipRevalidation ? false : isRevalidationRequired
      }));
    }
    if (shouldRevalidate) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: fetcherMatches,
        match: fetcherMatch,
        controller: new AbortController()
      });
    }
  });
  return [navigationMatches, revalidatingFetchers];
}
function shouldLoadRouteOnHydration(route, loaderData, errors) {
  // We dunno if we have a loader - gotta find out!
  if (route.lazy) {
    return true;
  }
  // No loader, nothing to initialize
  if (!route.loader) {
    return false;
  }
  let hasData = loaderData != null && loaderData[route.id] !== undefined;
  let hasError = errors != null && errors[route.id] !== undefined;
  // Don't run if we error'd during SSR
  if (!hasData && hasError) {
    return false;
  }
  // Explicitly opting-in to running on hydration
  if (typeof route.loader === "function" && route.loader.hydrate === true) {
    return true;
  }
  // Otherwise, run if we're not yet initialized with anything
  return !hasData && !hasError;
}
function isNewLoader(currentLoaderData, currentMatch, match) {
  let isNew =
  // [a] -> [a, b]
  !currentMatch ||
  // [a, b] -> [a, c]
  match.route.id !== currentMatch.route.id;
  // Handle the case that we don't have data for a re-used route, potentially
  // from a prior error or from a cancelled pending deferred
  let isMissingData = currentLoaderData[match.route.id] === undefined;
  // Always load if this is a net-new route or we don't yet have data
  return isNew || isMissingData;
}
function isNewRouteInstance(currentMatch, match) {
  let currentPath = currentMatch.route.path;
  return (
    // param change for this match, /users/123 -> /users/456
    currentMatch.pathname !== match.pathname ||
    // splat param changed, which is not present in match.path
    // e.g. /files/images/avatar.jpg -> files/finances.xls
    currentPath != null && currentPath.endsWith("*") && currentMatch.params["*"] !== match.params["*"]
  );
}
function shouldRevalidateLoader(loaderMatch, arg) {
  if (loaderMatch.route.shouldRevalidate) {
    let routeChoice = loaderMatch.route.shouldRevalidate(arg);
    if (typeof routeChoice === "boolean") {
      return routeChoice;
    }
  }
  return arg.defaultShouldRevalidate;
}
function patchRoutesImpl(routeId, children, routesToUse, manifest, mapRouteProperties) {
  var _childrenToPatch;
  let childrenToPatch;
  if (routeId) {
    let route = manifest[routeId];
    invariant(route, "No route found to patch children into: routeId = " + routeId);
    if (!route.children) {
      route.children = [];
    }
    childrenToPatch = route.children;
  } else {
    childrenToPatch = routesToUse;
  }
  // Don't patch in routes we already know about so that `patch` is idempotent
  // to simplify user-land code. This is useful because we re-call the
  // `patchRoutesOnNavigation` function for matched routes with params.
  let uniqueChildren = children.filter(newRoute => !childrenToPatch.some(existingRoute => isSameRoute(newRoute, existingRoute)));
  let newRoutes = convertRoutesToDataRoutes(uniqueChildren, mapRouteProperties, [routeId || "_", "patch", String(((_childrenToPatch = childrenToPatch) == null ? void 0 : _childrenToPatch.length) || "0")], manifest);
  childrenToPatch.push(...newRoutes);
}
function isSameRoute(newRoute, existingRoute) {
  // Most optimal check is by id
  if ("id" in newRoute && "id" in existingRoute && newRoute.id === existingRoute.id) {
    return true;
  }
  // Second is by pathing differences
  if (!(newRoute.index === existingRoute.index && newRoute.path === existingRoute.path && newRoute.caseSensitive === existingRoute.caseSensitive)) {
    return false;
  }
  // Pathless layout routes are trickier since we need to check children.
  // If they have no children then they're the same as far as we can tell
  if ((!newRoute.children || newRoute.children.length === 0) && (!existingRoute.children || existingRoute.children.length === 0)) {
    return true;
  }
  // Otherwise, we look to see if every child in the new route is already
  // represented in the existing route's children
  return newRoute.children.every((aChild, i) => {
    var _existingRoute$childr;
    return (_existingRoute$childr = existingRoute.children) == null ? void 0 : _existingRoute$childr.some(bChild => isSameRoute(aChild, bChild));
  });
}
/**
 * Execute route.lazy() methods to lazily load route modules (loader, action,
 * shouldRevalidate) and update the routeManifest in place which shares objects
 * with dataRoutes so those get updated as well.
 */
async function loadLazyRouteModule(route, mapRouteProperties, manifest) {
  if (!route.lazy) {
    return;
  }
  let lazyRoute = await route.lazy();
  // If the lazy route function was executed and removed by another parallel
  // call then we can return - first lazy() to finish wins because the return
  // value of lazy is expected to be static
  if (!route.lazy) {
    return;
  }
  let routeToUpdate = manifest[route.id];
  invariant(routeToUpdate, "No route found in manifest");
  // Update the route in place.  This should be safe because there's no way
  // we could yet be sitting on this route as we can't get there without
  // resolving lazy() first.
  //
  // This is different than the HMR "update" use-case where we may actively be
  // on the route being updated.  The main concern boils down to "does this
  // mutation affect any ongoing navigations or any current state.matches
  // values?".  If not, it should be safe to update in place.
  let routeUpdates = {};
  for (let lazyRouteProperty in lazyRoute) {
    let staticRouteValue = routeToUpdate[lazyRouteProperty];
    let isPropertyStaticallyDefined = staticRouteValue !== undefined &&
    // This property isn't static since it should always be updated based
    // on the route updates
    lazyRouteProperty !== "hasErrorBoundary";
    warning(!isPropertyStaticallyDefined, "Route \"" + routeToUpdate.id + "\" has a static property \"" + lazyRouteProperty + "\" " + "defined but its lazy function is also returning a value for this property. " + ("The lazy route property \"" + lazyRouteProperty + "\" will be ignored."));
    if (!isPropertyStaticallyDefined && !immutableRouteKeys.has(lazyRouteProperty)) {
      routeUpdates[lazyRouteProperty] = lazyRoute[lazyRouteProperty];
    }
  }
  // Mutate the route with the provided updates.  Do this first so we pass
  // the updated version to mapRouteProperties
  Object.assign(routeToUpdate, routeUpdates);
  // Mutate the `hasErrorBoundary` property on the route based on the route
  // updates and remove the `lazy` function so we don't resolve the lazy
  // route again.
  Object.assign(routeToUpdate, _extends({}, mapRouteProperties(routeToUpdate), {
    lazy: undefined
  }));
}
// Default implementation of `dataStrategy` which fetches all loaders in parallel
async function defaultDataStrategy(_ref4) {
  let {
    matches
  } = _ref4;
  let matchesToLoad = matches.filter(m => m.shouldLoad);
  let results = await Promise.all(matchesToLoad.map(m => m.resolve()));
  return results.reduce((acc, result, i) => Object.assign(acc, {
    [matchesToLoad[i].route.id]: result
  }), {});
}
async function callDataStrategyImpl(dataStrategyImpl, type, state, request, matchesToLoad, matches, fetcherKey, manifest, mapRouteProperties, requestContext) {
  let loadRouteDefinitionsPromises = matches.map(m => m.route.lazy ? loadLazyRouteModule(m.route, mapRouteProperties, manifest) : undefined);
  let dsMatches = matches.map((match, i) => {
    let loadRoutePromise = loadRouteDefinitionsPromises[i];
    let shouldLoad = matchesToLoad.some(m => m.route.id === match.route.id);
    // `resolve` encapsulates route.lazy(), executing the loader/action,
    // and mapping return values/thrown errors to a `DataStrategyResult`.  Users
    // can pass a callback to take fine-grained control over the execution
    // of the loader/action
    let resolve = async handlerOverride => {
      if (handlerOverride && request.method === "GET" && (match.route.lazy || match.route.loader)) {
        shouldLoad = true;
      }
      return shouldLoad ? callLoaderOrAction(type, request, match, loadRoutePromise, handlerOverride, requestContext) : Promise.resolve({
        type: ResultType.data,
        result: undefined
      });
    };
    return _extends({}, match, {
      shouldLoad,
      resolve
    });
  });
  // Send all matches here to allow for a middleware-type implementation.
  // handler will be a no-op for unneeded routes and we filter those results
  // back out below.
  let results = await dataStrategyImpl({
    matches: dsMatches,
    request,
    params: matches[0].params,
    fetcherKey,
    context: requestContext
  });
  // Wait for all routes to load here but 'swallow the error since we want
  // it to bubble up from the `await loadRoutePromise` in `callLoaderOrAction` -
  // called from `match.resolve()`
  try {
    await Promise.all(loadRouteDefinitionsPromises);
  } catch (e) {
    // No-op
  }
  return results;
}
// Default logic for calling a loader/action is the user has no specified a dataStrategy
async function callLoaderOrAction(type, request, match, loadRoutePromise, handlerOverride, staticContext) {
  let result;
  let onReject;
  let runHandler = handler => {
    // Setup a promise we can race against so that abort signals short circuit
    let reject;
    // This will never resolve so safe to type it as Promise<DataStrategyResult> to
    // satisfy the function return value
    let abortPromise = new Promise((_, r) => reject = r);
    onReject = () => reject();
    request.signal.addEventListener("abort", onReject);
    let actualHandler = ctx => {
      if (typeof handler !== "function") {
        return Promise.reject(new Error("You cannot call the handler for a route which defines a boolean " + ("\"" + type + "\" [routeId: " + match.route.id + "]")));
      }
      return handler({
        request,
        params: match.params,
        context: staticContext
      }, ...(ctx !== undefined ? [ctx] : []));
    };
    let handlerPromise = (async () => {
      try {
        let val = await (handlerOverride ? handlerOverride(ctx => actualHandler(ctx)) : actualHandler());
        return {
          type: "data",
          result: val
        };
      } catch (e) {
        return {
          type: "error",
          result: e
        };
      }
    })();
    return Promise.race([handlerPromise, abortPromise]);
  };
  try {
    let handler = match.route[type];
    // If we have a route.lazy promise, await that first
    if (loadRoutePromise) {
      if (handler) {
        // Run statically defined handler in parallel with lazy()
        let handlerError;
        let [value] = await Promise.all([
        // If the handler throws, don't let it immediately bubble out,
        // since we need to let the lazy() execution finish so we know if this
        // route has a boundary that can handle the error
        runHandler(handler).catch(e => {
          handlerError = e;
        }), loadRoutePromise]);
        if (handlerError !== undefined) {
          throw handlerError;
        }
        result = value;
      } else {
        // Load lazy route module, then run any returned handler
        await loadRoutePromise;
        handler = match.route[type];
        if (handler) {
          // Handler still runs even if we got interrupted to maintain consistency
          // with un-abortable behavior of handler execution on non-lazy or
          // previously-lazy-loaded routes
          result = await runHandler(handler);
        } else if (type === "action") {
          let url = new URL(request.url);
          let pathname = url.pathname + url.search;
          throw getInternalRouterError(405, {
            method: request.method,
            pathname,
            routeId: match.route.id
          });
        } else {
          // lazy() route has no loader to run.  Short circuit here so we don't
          // hit the invariant below that errors on returning undefined.
          return {
            type: ResultType.data,
            result: undefined
          };
        }
      }
    } else if (!handler) {
      let url = new URL(request.url);
      let pathname = url.pathname + url.search;
      throw getInternalRouterError(404, {
        pathname
      });
    } else {
      result = await runHandler(handler);
    }
    invariant(result.result !== undefined, "You defined " + (type === "action" ? "an action" : "a loader") + " for route " + ("\"" + match.route.id + "\" but didn't return anything from your `" + type + "` ") + "function. Please return a value or `null`.");
  } catch (e) {
    // We should already be catching and converting normal handler executions to
    // DataStrategyResults and returning them, so anything that throws here is an
    // unexpected error we still need to wrap
    return {
      type: ResultType.error,
      result: e
    };
  } finally {
    if (onReject) {
      request.signal.removeEventListener("abort", onReject);
    }
  }
  return result;
}
async function convertDataStrategyResultToDataResult(dataStrategyResult) {
  let {
    result,
    type
  } = dataStrategyResult;
  if (isResponse(result)) {
    let data;
    try {
      let contentType = result.headers.get("Content-Type");
      // Check between word boundaries instead of startsWith() due to the last
      // paragraph of https://httpwg.org/specs/rfc9110.html#field.content-type
      if (contentType && /\bapplication\/json\b/.test(contentType)) {
        if (result.body == null) {
          data = null;
        } else {
          data = await result.json();
        }
      } else {
        data = await result.text();
      }
    } catch (e) {
      return {
        type: ResultType.error,
        error: e
      };
    }
    if (type === ResultType.error) {
      return {
        type: ResultType.error,
        error: new ErrorResponseImpl(result.status, result.statusText, data),
        statusCode: result.status,
        headers: result.headers
      };
    }
    return {
      type: ResultType.data,
      data,
      statusCode: result.status,
      headers: result.headers
    };
  }
  if (type === ResultType.error) {
    if (isDataWithResponseInit(result)) {
      var _result$init2;
      if (result.data instanceof Error) {
        var _result$init;
        return {
          type: ResultType.error,
          error: result.data,
          statusCode: (_result$init = result.init) == null ? void 0 : _result$init.status
        };
      }
      // Convert thrown data() to ErrorResponse instances
      result = new ErrorResponseImpl(((_result$init2 = result.init) == null ? void 0 : _result$init2.status) || 500, undefined, result.data);
    }
    return {
      type: ResultType.error,
      error: result,
      statusCode: isRouteErrorResponse(result) ? result.status : undefined
    };
  }
  if (isDeferredData(result)) {
    var _result$init3, _result$init4;
    return {
      type: ResultType.deferred,
      deferredData: result,
      statusCode: (_result$init3 = result.init) == null ? void 0 : _result$init3.status,
      headers: ((_result$init4 = result.init) == null ? void 0 : _result$init4.headers) && new Headers(result.init.headers)
    };
  }
  if (isDataWithResponseInit(result)) {
    var _result$init5, _result$init6;
    return {
      type: ResultType.data,
      data: result.data,
      statusCode: (_result$init5 = result.init) == null ? void 0 : _result$init5.status,
      headers: (_result$init6 = result.init) != null && _result$init6.headers ? new Headers(result.init.headers) : undefined
    };
  }
  return {
    type: ResultType.data,
    data: result
  };
}
// Support relative routing in internal redirects
function normalizeRelativeRoutingRedirectResponse(response, request, routeId, matches, basename, v7_relativeSplatPath) {
  let location = response.headers.get("Location");
  invariant(location, "Redirects returned/thrown from loaders/actions must have a Location header");
  if (!ABSOLUTE_URL_REGEX.test(location)) {
    let trimmedMatches = matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1);
    location = normalizeTo(new URL(request.url), trimmedMatches, basename, true, location, v7_relativeSplatPath);
    response.headers.set("Location", location);
  }
  return response;
}
function normalizeRedirectLocation(location, currentUrl, basename) {
  if (ABSOLUTE_URL_REGEX.test(location)) {
    // Strip off the protocol+origin for same-origin + same-basename absolute redirects
    let normalizedLocation = location;
    let url = normalizedLocation.startsWith("//") ? new URL(currentUrl.protocol + normalizedLocation) : new URL(normalizedLocation);
    let isSameBasename = stripBasename(url.pathname, basename) != null;
    if (url.origin === currentUrl.origin && isSameBasename) {
      return url.pathname + url.search + url.hash;
    }
  }
  return location;
}
// Utility method for creating the Request instances for loaders/actions during
// client-side navigations and fetches.  During SSR we will always have a
// Request instance from the static handler (query/queryRoute)
function createClientSideRequest(history, location, signal, submission) {
  let url = history.createURL(stripHashFromPath(location)).toString();
  let init = {
    signal
  };
  if (submission && isMutationMethod(submission.formMethod)) {
    let {
      formMethod,
      formEncType
    } = submission;
    // Didn't think we needed this but it turns out unlike other methods, patch
    // won't be properly normalized to uppercase and results in a 405 error.
    // See: https://fetch.spec.whatwg.org/#concept-method
    init.method = formMethod.toUpperCase();
    if (formEncType === "application/json") {
      init.headers = new Headers({
        "Content-Type": formEncType
      });
      init.body = JSON.stringify(submission.json);
    } else if (formEncType === "text/plain") {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.text;
    } else if (formEncType === "application/x-www-form-urlencoded" && submission.formData) {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = convertFormDataToSearchParams(submission.formData);
    } else {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.formData;
    }
  }
  return new Request(url, init);
}
function convertFormDataToSearchParams(formData) {
  let searchParams = new URLSearchParams();
  for (let [key, value] of formData.entries()) {
    // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#converting-an-entry-list-to-a-list-of-name-value-pairs
    searchParams.append(key, typeof value === "string" ? value : value.name);
  }
  return searchParams;
}
function convertSearchParamsToFormData(searchParams) {
  let formData = new FormData();
  for (let [key, value] of searchParams.entries()) {
    formData.append(key, value);
  }
  return formData;
}
function processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, skipLoaderErrorBubbling) {
  // Fill in loaderData/errors from our loaders
  let loaderData = {};
  let errors = null;
  let statusCode;
  let foundError = false;
  let loaderHeaders = {};
  let pendingError = pendingActionResult && isErrorResult(pendingActionResult[1]) ? pendingActionResult[1].error : undefined;
  // Process loader results into state.loaderData/state.errors
  matches.forEach(match => {
    if (!(match.route.id in results)) {
      return;
    }
    let id = match.route.id;
    let result = results[id];
    invariant(!isRedirectResult(result), "Cannot handle redirect results in processLoaderData");
    if (isErrorResult(result)) {
      let error = result.error;
      // If we have a pending action error, we report it at the highest-route
      // that throws a loader error, and then clear it out to indicate that
      // it was consumed
      if (pendingError !== undefined) {
        error = pendingError;
        pendingError = undefined;
      }
      errors = errors || {};
      if (skipLoaderErrorBubbling) {
        errors[id] = error;
      } else {
        // Look upwards from the matched route for the closest ancestor error
        // boundary, defaulting to the root match.  Prefer higher error values
        // if lower errors bubble to the same boundary
        let boundaryMatch = findNearestBoundary(matches, id);
        if (errors[boundaryMatch.route.id] == null) {
          errors[boundaryMatch.route.id] = error;
        }
      }
      // Clear our any prior loaderData for the throwing route
      loaderData[id] = undefined;
      // Once we find our first (highest) error, we set the status code and
      // prevent deeper status codes from overriding
      if (!foundError) {
        foundError = true;
        statusCode = isRouteErrorResponse(result.error) ? result.error.status : 500;
      }
      if (result.headers) {
        loaderHeaders[id] = result.headers;
      }
    } else {
      if (isDeferredResult(result)) {
        activeDeferreds.set(id, result.deferredData);
        loaderData[id] = result.deferredData.data;
        // Error status codes always override success status codes, but if all
        // loaders are successful we take the deepest status code.
        if (result.statusCode != null && result.statusCode !== 200 && !foundError) {
          statusCode = result.statusCode;
        }
        if (result.headers) {
          loaderHeaders[id] = result.headers;
        }
      } else {
        loaderData[id] = result.data;
        // Error status codes always override success status codes, but if all
        // loaders are successful we take the deepest status code.
        if (result.statusCode && result.statusCode !== 200 && !foundError) {
          statusCode = result.statusCode;
        }
        if (result.headers) {
          loaderHeaders[id] = result.headers;
        }
      }
    }
  });
  // If we didn't consume the pending action error (i.e., all loaders
  // resolved), then consume it here.  Also clear out any loaderData for the
  // throwing route
  if (pendingError !== undefined && pendingActionResult) {
    errors = {
      [pendingActionResult[0]]: pendingError
    };
    loaderData[pendingActionResult[0]] = undefined;
  }
  return {
    loaderData,
    errors,
    statusCode: statusCode || 200,
    loaderHeaders
  };
}
function processLoaderData(state, matches, results, pendingActionResult, revalidatingFetchers, fetcherResults, activeDeferreds) {
  let {
    loaderData,
    errors
  } = processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, false // This method is only called client side so we always want to bubble
  );
  // Process results from our revalidating fetchers
  revalidatingFetchers.forEach(rf => {
    let {
      key,
      match,
      controller
    } = rf;
    let result = fetcherResults[key];
    invariant(result, "Did not find corresponding fetcher result");
    // Process fetcher non-redirect errors
    if (controller && controller.signal.aborted) {
      // Nothing to do for aborted fetchers
      return;
    } else if (isErrorResult(result)) {
      let boundaryMatch = findNearestBoundary(state.matches, match == null ? void 0 : match.route.id);
      if (!(errors && errors[boundaryMatch.route.id])) {
        errors = _extends({}, errors, {
          [boundaryMatch.route.id]: result.error
        });
      }
      state.fetchers.delete(key);
    } else if (isRedirectResult(result)) {
      // Should never get here, redirects should get processed above, but we
      // keep this to type narrow to a success result in the else
      invariant(false, "Unhandled fetcher revalidation redirect");
    } else if (isDeferredResult(result)) {
      // Should never get here, deferred data should be awaited for fetchers
      // in resolveDeferredResults
      invariant(false, "Unhandled fetcher deferred data");
    } else {
      let doneFetcher = getDoneFetcher(result.data);
      state.fetchers.set(key, doneFetcher);
    }
  });
  return {
    loaderData,
    errors
  };
}
function mergeLoaderData(loaderData, newLoaderData, matches, errors) {
  let mergedLoaderData = _extends({}, newLoaderData);
  for (let match of matches) {
    let id = match.route.id;
    if (newLoaderData.hasOwnProperty(id)) {
      if (newLoaderData[id] !== undefined) {
        mergedLoaderData[id] = newLoaderData[id];
      }
    } else if (loaderData[id] !== undefined && match.route.loader) {
      // Preserve existing keys not included in newLoaderData and where a loader
      // wasn't removed by HMR
      mergedLoaderData[id] = loaderData[id];
    }
    if (errors && errors.hasOwnProperty(id)) {
      // Don't keep any loader data below the boundary
      break;
    }
  }
  return mergedLoaderData;
}
function getActionDataForCommit(pendingActionResult) {
  if (!pendingActionResult) {
    return {};
  }
  return isErrorResult(pendingActionResult[1]) ? {
    // Clear out prior actionData on errors
    actionData: {}
  } : {
    actionData: {
      [pendingActionResult[0]]: pendingActionResult[1].data
    }
  };
}
// Find the nearest error boundary, looking upwards from the leaf route (or the
// route specified by routeId) for the closest ancestor error boundary,
// defaulting to the root match
function findNearestBoundary(matches, routeId) {
  let eligibleMatches = routeId ? matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1) : [...matches];
  return eligibleMatches.reverse().find(m => m.route.hasErrorBoundary === true) || matches[0];
}
function getShortCircuitMatches(routes) {
  // Prefer a root layout route if present, otherwise shim in a route object
  let route = routes.length === 1 ? routes[0] : routes.find(r => r.index || !r.path || r.path === "/") || {
    id: "__shim-error-route__"
  };
  return {
    matches: [{
      params: {},
      pathname: "",
      pathnameBase: "",
      route
    }],
    route
  };
}
function getInternalRouterError(status, _temp5) {
  let {
    pathname,
    routeId,
    method,
    type,
    message
  } = _temp5 === void 0 ? {} : _temp5;
  let statusText = "Unknown Server Error";
  let errorMessage = "Unknown @remix-run/router error";
  if (status === 400) {
    statusText = "Bad Request";
    if (method && pathname && routeId) {
      errorMessage = "You made a " + method + " request to \"" + pathname + "\" but " + ("did not provide a `loader` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (type === "defer-action") {
      errorMessage = "defer() is not supported in actions";
    } else if (type === "invalid-body") {
      errorMessage = "Unable to encode submission body";
    }
  } else if (status === 403) {
    statusText = "Forbidden";
    errorMessage = "Route \"" + routeId + "\" does not match URL \"" + pathname + "\"";
  } else if (status === 404) {
    statusText = "Not Found";
    errorMessage = "No route matches URL \"" + pathname + "\"";
  } else if (status === 405) {
    statusText = "Method Not Allowed";
    if (method && pathname && routeId) {
      errorMessage = "You made a " + method.toUpperCase() + " request to \"" + pathname + "\" but " + ("did not provide an `action` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (method) {
      errorMessage = "Invalid request method \"" + method.toUpperCase() + "\"";
    }
  }
  return new ErrorResponseImpl(status || 500, statusText, new Error(errorMessage), true);
}
// Find any returned redirect errors, starting from the lowest match
function findRedirect(results) {
  let entries = Object.entries(results);
  for (let i = entries.length - 1; i >= 0; i--) {
    let [key, result] = entries[i];
    if (isRedirectResult(result)) {
      return {
        key,
        result
      };
    }
  }
}
function stripHashFromPath(path) {
  let parsedPath = typeof path === "string" ? parsePath(path) : path;
  return createPath(_extends({}, parsedPath, {
    hash: ""
  }));
}
function isHashChangeOnly(a, b) {
  if (a.pathname !== b.pathname || a.search !== b.search) {
    return false;
  }
  if (a.hash === "") {
    // /page -> /page#hash
    return b.hash !== "";
  } else if (a.hash === b.hash) {
    // /page#hash -> /page#hash
    return true;
  } else if (b.hash !== "") {
    // /page#hash -> /page#other
    return true;
  }
  // If the hash is removed the browser will re-perform a request to the server
  // /page#hash -> /page
  return false;
}
function isDataStrategyResult(result) {
  return result != null && typeof result === "object" && "type" in result && "result" in result && (result.type === ResultType.data || result.type === ResultType.error);
}
function isRedirectDataStrategyResultResult(result) {
  return isResponse(result.result) && redirectStatusCodes.has(result.result.status);
}
function isDeferredResult(result) {
  return result.type === ResultType.deferred;
}
function isErrorResult(result) {
  return result.type === ResultType.error;
}
function isRedirectResult(result) {
  return (result && result.type) === ResultType.redirect;
}
function isDataWithResponseInit(value) {
  return typeof value === "object" && value != null && "type" in value && "data" in value && "init" in value && value.type === "DataWithResponseInit";
}
function isDeferredData(value) {
  let deferred = value;
  return deferred && typeof deferred === "object" && typeof deferred.data === "object" && typeof deferred.subscribe === "function" && typeof deferred.cancel === "function" && typeof deferred.resolveData === "function";
}
function isResponse(value) {
  return value != null && typeof value.status === "number" && typeof value.statusText === "string" && typeof value.headers === "object" && typeof value.body !== "undefined";
}
function isRedirectResponse(result) {
  if (!isResponse(result)) {
    return false;
  }
  let status = result.status;
  let location = result.headers.get("Location");
  return status >= 300 && status <= 399 && location != null;
}
function isValidMethod(method) {
  return validRequestMethods.has(method.toLowerCase());
}
function isMutationMethod(method) {
  return validMutationMethods.has(method.toLowerCase());
}
async function resolveNavigationDeferredResults(matches, results, signal, currentMatches, currentLoaderData) {
  let entries = Object.entries(results);
  for (let index = 0; index < entries.length; index++) {
    let [routeId, result] = entries[index];
    let match = matches.find(m => (m == null ? void 0 : m.route.id) === routeId);
    // If we don't have a match, then we can have a deferred result to do
    // anything with.  This is for revalidating fetchers where the route was
    // removed during HMR
    if (!match) {
      continue;
    }
    let currentMatch = currentMatches.find(m => m.route.id === match.route.id);
    let isRevalidatingLoader = currentMatch != null && !isNewRouteInstance(currentMatch, match) && (currentLoaderData && currentLoaderData[match.route.id]) !== undefined;
    if (isDeferredResult(result) && isRevalidatingLoader) {
      // Note: we do not have to touch activeDeferreds here since we race them
      // against the signal in resolveDeferredData and they'll get aborted
      // there if needed
      await resolveDeferredData(result, signal, false).then(result => {
        if (result) {
          results[routeId] = result;
        }
      });
    }
  }
}
async function resolveFetcherDeferredResults(matches, results, revalidatingFetchers) {
  for (let index = 0; index < revalidatingFetchers.length; index++) {
    let {
      key,
      routeId,
      controller
    } = revalidatingFetchers[index];
    let result = results[key];
    let match = matches.find(m => (m == null ? void 0 : m.route.id) === routeId);
    // If we don't have a match, then we can have a deferred result to do
    // anything with.  This is for revalidating fetchers where the route was
    // removed during HMR
    if (!match) {
      continue;
    }
    if (isDeferredResult(result)) {
      // Note: we do not have to touch activeDeferreds here since we race them
      // against the signal in resolveDeferredData and they'll get aborted
      // there if needed
      invariant(controller, "Expected an AbortController for revalidating fetcher deferred result");
      await resolveDeferredData(result, controller.signal, true).then(result => {
        if (result) {
          results[key] = result;
        }
      });
    }
  }
}
async function resolveDeferredData(result, signal, unwrap) {
  if (unwrap === void 0) {
    unwrap = false;
  }
  let aborted = await result.deferredData.resolveData(signal);
  if (aborted) {
    return;
  }
  if (unwrap) {
    try {
      return {
        type: ResultType.data,
        data: result.deferredData.unwrappedData
      };
    } catch (e) {
      // Handle any TrackedPromise._error values encountered while unwrapping
      return {
        type: ResultType.error,
        error: e
      };
    }
  }
  return {
    type: ResultType.data,
    data: result.deferredData.data
  };
}
function hasNakedIndexQuery(search) {
  return new URLSearchParams(search).getAll("index").some(v => v === "");
}
function getTargetMatch(matches, location) {
  let search = typeof location === "string" ? parsePath(location).search : location.search;
  if (matches[matches.length - 1].route.index && hasNakedIndexQuery(search || "")) {
    // Return the leaf index route when index is present
    return matches[matches.length - 1];
  }
  // Otherwise grab the deepest "path contributing" match (ignoring index and
  // pathless layout routes)
  let pathMatches = getPathContributingMatches(matches);
  return pathMatches[pathMatches.length - 1];
}
function getSubmissionFromNavigation(navigation) {
  let {
    formMethod,
    formAction,
    formEncType,
    text,
    formData,
    json
  } = navigation;
  if (!formMethod || !formAction || !formEncType) {
    return;
  }
  if (text != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json: undefined,
      text
    };
  } else if (formData != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData,
      json: undefined,
      text: undefined
    };
  } else if (json !== undefined) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json,
      text: undefined
    };
  }
}
function getLoadingNavigation(location, submission) {
  if (submission) {
    let navigation = {
      state: "loading",
      location,
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text
    };
    return navigation;
  } else {
    let navigation = {
      state: "loading",
      location,
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined
    };
    return navigation;
  }
}
function getSubmittingNavigation(location, submission) {
  let navigation = {
    state: "submitting",
    location,
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text
  };
  return navigation;
}
function getLoadingFetcher(submission, data) {
  if (submission) {
    let fetcher = {
      state: "loading",
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text,
      data
    };
    return fetcher;
  } else {
    let fetcher = {
      state: "loading",
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined,
      data
    };
    return fetcher;
  }
}
function getSubmittingFetcher(submission, existingFetcher) {
  let fetcher = {
    state: "submitting",
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text,
    data: existingFetcher ? existingFetcher.data : undefined
  };
  return fetcher;
}
function getDoneFetcher(data) {
  let fetcher = {
    state: "idle",
    formMethod: undefined,
    formAction: undefined,
    formEncType: undefined,
    formData: undefined,
    json: undefined,
    text: undefined,
    data
  };
  return fetcher;
}
function restoreAppliedTransitions(_window, transitions) {
  try {
    let sessionPositions = _window.sessionStorage.getItem(TRANSITIONS_STORAGE_KEY);
    if (sessionPositions) {
      let json = JSON.parse(sessionPositions);
      for (let [k, v] of Object.entries(json || {})) {
        if (v && Array.isArray(v)) {
          transitions.set(k, new Set(v || []));
        }
      }
    }
  } catch (e) {
    // no-op, use default empty object
  }
}
function persistAppliedTransitions(_window, transitions) {
  if (transitions.size > 0) {
    let json = {};
    for (let [k, v] of transitions) {
      json[k] = [...v];
    }
    try {
      _window.sessionStorage.setItem(TRANSITIONS_STORAGE_KEY, JSON.stringify(json));
    } catch (error) {
      warning(false, "Failed to save applied view transitions in sessionStorage (" + error + ").");
    }
  }
}
//#endregion


//# sourceMappingURL=router.js.map


/***/ }),

/***/ "./assets/components/ProButton.js":
/*!****************************************!*\
  !*** ./assets/components/ProButton.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! dompurify */ "./node_modules/dompurify/dist/purify.es.mjs");
/* harmony import */ var _astra_utils_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @astra-utils/helpers */ "./assets/utils/helpers.js");






const ProButton = ({
  className,
  isLink = false,
  url = astra_admin.upgrade_url,
  children = (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_5__.getAstraProTitle)(),
  disableSpinner = false
}) => {
  const onGetAstraPro = e => {
    e.preventDefault();
    e.stopPropagation();
    if (!astra_admin.pro_installed_status) {
      window.open(url, "_blank");
    }
    e.target.innerHTML = dompurify__WEBPACK_IMPORTED_MODULE_4__["default"].sanitize((disableSpinner ? "" : (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_5__.getSpinner)()) + astra_admin.plugin_activating_text);
    e.target.disabled = true;
    const formData = new window.FormData();
    formData.append("action", "astra_recommended_plugin_activate");
    formData.append("security", astra_admin.plugin_manager_nonce);
    formData.append("init", "astra-addon/astra-addon.php");
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
      url: astra_admin.ajax_url,
      method: "POST",
      body: formData
    }).then(data => {
      if (data.success) {
        window.open(astra_admin.astra_base_url, "_self");
      }
    }).catch(error => {
      e.target.innerText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Activation failed. Please try again.", "astra");
      e.target.disabled = false;
      console.error("Error during API request:", error);
      // Optionally, notify the user about the error or handle it appropriately.
    });
  };
  const Tag = isLink ? "a" : "button";
  const linkProps = isLink && {
    role: "button",
    href: url,
    target: "_blank",
    rel: "noreferrer"
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createElement)(Tag, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_5__.classNames)("inline-flex items-center disabled:pointer-events-none", className),
    onClick: onGetAstraPro
  }, linkProps), children);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProButton);

/***/ }),

/***/ "./assets/components/PromoCard.js":
/*!****************************************!*\
  !*** ./assets/components/PromoCard.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _astra_utils_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @astra-utils/helpers */ "./assets/utils/helpers.js");


const PromoCard = ({
  className = "",
  id,
  icon,
  title,
  description,
  linkHRef,
  linkText,
  children
}) => {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    "aria-labelledby": `section-${id}-title`
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "sr-only",
    id: `section-${id}-title`
  }, title), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_1__.classNames)("relative box-border rounded-md bg-white shadow-sm overflow-hidden transition hover:shadow-hover", className)
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-6"
  }, icon && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "inline-block mb-2"
  }, icon), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "relative flex items-center text-slate-800 text-base font-semibold pb-2"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "flex-1"
  }, title)), !children && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-slate-500 text-sm pb-5"
  }, description), children, linkText && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    className: "text-sm text-astra focus:text-astra focus-visible:text-astra-hover active:text-astra-hover hover:text-astra-hover no-underline",
    href: linkHRef,
    target: "_blank",
    rel: "noreferrer"
  }, linkText))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PromoCard);

/***/ }),

/***/ "./assets/components/icons/Star.js":
/*!*****************************************!*\
  !*** ./assets/components/icons/Star.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);

const Star = ({
  width = 20,
  height = 20,
  fill = "#000",
  className = ""
}) => {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    className: className,
    width: width,
    height: height,
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2358_55923)"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.04894 2.92705C9.3483 2.00574 10.6517 2.00574 10.9511 2.92705L12.0206 6.21885C12.1545 6.63087 12.5385 6.90983 12.9717 6.90983H16.4329C17.4016 6.90983 17.8044 8.14945 17.0207 8.71885L14.2205 10.7533C13.87 11.0079 13.7234 11.4593 13.8572 11.8713L14.9268 15.1631C15.2261 16.0844 14.1717 16.8506 13.388 16.2812L10.5878 14.2467C10.2373 13.9921 9.7627 13.9921 9.41221 14.2467L6.61204 16.2812C5.82833 16.8506 4.77385 16.0844 5.0732 15.1631L6.14277 11.8713C6.27665 11.4593 6.12999 11.0079 5.7795 10.7533L2.97933 8.71885C2.19562 8.14945 2.59839 6.90983 3.56712 6.90983H7.02832C7.46154 6.90983 7.8455 6.63087 7.97937 6.21885L9.04894 2.92705Z",
    fill: fill
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2358_55923"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: width,
    height: height,
    fill: "white"
  }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Star);

/***/ }),

/***/ "./assets/components/icons/index.js":
/*!******************************************!*\
  !*** ./assets/components/icons/index.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Star: () => (/* reexport safe */ _Star__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _Star__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Star */ "./assets/components/icons/Star.js");



/***/ }),

/***/ "./assets/components/index.js":
/*!************************************!*\
  !*** ./assets/components/index.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ProButton: () => (/* reexport safe */ _ProButton__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   PromoCard: () => (/* reexport safe */ _PromoCard__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _ProButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProButton */ "./assets/components/ProButton.js");
/* harmony import */ var _PromoCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PromoCard */ "./assets/components/PromoCard.js");




/***/ }),

/***/ "./assets/hooks/index.js":
/*!*******************************!*\
  !*** ./assets/hooks/index.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDebounceEffect: () => (/* reexport safe */ _useDebounceEffect__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _useDebounceEffect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useDebounceEffect */ "./assets/hooks/useDebounceEffect.js");



/***/ }),

/***/ "./assets/hooks/useDebounceEffect.js":
/*!*******************************************!*\
  !*** ./assets/hooks/useDebounceEffect.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _astra_utils_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @astra-utils/helpers */ "./assets/utils/helpers.js");



/**
 * A hook that wraps a callback function with a debounce effect.
 *
 * This hook is designed to delay the execution of a function until after a specified delay.
 * It's particularly useful for handling events that occur rapidly, such as typing in a text input.
 *
 * @param {Function} callback - The function to debounce.
 * @param {number} delay - The delay in milliseconds before the function is executed.
 * @param {Array} dependencies - An array of dependencies that trigger the effect.
 */
function useDebounceEffect(callback, delay, dependencies) {
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const debouncedCallback = (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_1__.debounce)(callback, delay);
    debouncedCallback();

    // Cleanup on unmount or when dependencies change.
    return () => debouncedCallback.cancel && debouncedCallback.cancel();
  }, [callback, delay, ...dependencies]);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useDebounceEffect);

/***/ }),

/***/ "./assets/src/common/block-icons.js":
/*!******************************************!*\
  !*** ./assets/src/common/block-icons.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Admin Icons
 *
 * @package Astra
 */const Astra_Admin_Icons={'close':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:20,height:20,viewBox:'0 0 20 20',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M5 15L15 5M5 5L15 15',stroke:'#9CA3AF',strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"})),'search':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:20,height:20,viewBox:'0 0 20 20',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M17.5 17.5L12.5 12.5M14.1667 8.33333C14.1667 11.555 11.555 14.1667 8.33333 14.1667C5.11167 14.1667 2.5 11.555 2.5 8.33333C2.5 5.11167 5.11167 2.5 8.33333 2.5C11.555 2.5 14.1667 5.11167 14.1667 8.33333Z',stroke:'#9CA3AF',strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"})),'popupclose':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:44,height:44,viewBox:'0 0 44 44',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M16 28L28 16M16 16L28 28',stroke:'#334155',strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"})),'support':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:32,height:32,viewBox:'0 0 32 32',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M27 16C27 22.0751 22.0751 27 16 27V29C23.1797 29 29 23.1797 29 16H27ZM16 27C9.92487 27 5 22.0751 5 16H3C3 23.1797 8.8203 29 16 29V27ZM5 16C5 9.92487 9.92487 5 16 5V3C8.8203 3 3 8.8203 3 16H5ZM16 5C22.0751 5 27 9.92487 27 16H29C29 8.8203 23.1797 3 16 3V5ZM20.3333 16C20.3333 18.3932 18.3932 20.3333 16 20.3333V22.3333C19.4978 22.3333 22.3333 19.4978 22.3333 16H20.3333ZM16 20.3333C13.6068 20.3333 11.6667 18.3932 11.6667 16H9.66667C9.66667 19.4978 12.5022 22.3333 16 22.3333V20.3333ZM11.6667 16C11.6667 13.6068 13.6068 11.6667 16 11.6667V9.66667C12.5022 9.66667 9.66667 12.5022 9.66667 16H11.6667ZM16 11.6667C18.3932 11.6667 20.3333 13.6068 20.3333 16H22.3333C22.3333 12.5022 19.4978 9.66667 16 9.66667V11.6667ZM23.7782 6.80761L19.0641 11.5217L20.4783 12.9359L25.1924 8.22183L23.7782 6.80761ZM19.0641 20.4783L23.7782 25.1924L25.1924 23.7782L20.4783 19.0641L19.0641 20.4783ZM12.9359 11.5217L8.22183 6.80761L6.80761 8.22183L11.5217 12.9359L12.9359 11.5217ZM11.5217 19.0641L6.80761 23.7782L8.22183 25.1924L12.9359 20.4783L11.5217 19.0641Z',fill:'#4B5563'})),'book':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:32,height:32,viewBox:'0 0 32 32',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M16 8.33639V25.6697M16 8.33639C14.4428 7.30183 12.3287 6.66602 10 6.66602C7.67134 6.66602 5.55719 7.30183 4 8.33639V25.6697C5.55719 24.6352 7.67134 23.9993 10 23.9993C12.3287 23.9993 14.4428 24.6352 16 25.6697M16 8.33639C17.5572 7.30183 19.6713 6.66602 22 6.66602C24.3287 6.66602 26.4428 7.30183 28 8.33639V25.6697C26.4428 24.6352 24.3287 23.9993 22 23.9993C19.6713 23.9993 17.5572 24.6352 16 25.6697',stroke:'#4B5563',strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"})),'checkbadge':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:48,height:48,viewBox:'0 0 48 48',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M17.9993 23.9993L21.9993 27.9993L29.9993 19.9993M15.6687 9.39336C17.1038 9.27884 18.4662 8.71453 19.5619 7.78076C22.1189 5.60172 25.8797 5.60172 28.4366 7.78076C29.5324 8.71453 30.8947 9.27884 32.3298 9.39336C35.6787 9.6606 38.3379 12.3199 38.6052 15.6687C38.7197 17.1038 39.284 18.4662 40.2178 19.5619C42.3968 22.1189 42.3968 25.8797 40.2178 28.4366C39.284 29.5324 38.7197 30.8947 38.6052 32.3298C38.3379 35.6787 35.6787 38.3379 32.3298 38.6052C30.8947 38.7197 29.5324 39.284 28.4366 40.2178C25.8797 42.3968 22.1189 42.3968 19.5619 40.2178C18.4662 39.284 17.1038 38.7197 15.6687 38.6052C12.3199 38.3379 9.6606 35.6787 9.39336 32.3298C9.27884 30.8947 8.71453 29.5324 7.78076 28.4366C5.60172 25.8797 5.60172 22.1189 7.78076 19.5619C8.71453 18.4662 9.27884 17.1038 9.39336 15.6687C9.6606 12.3199 12.3199 9.6606 15.6687 9.39336Z',stroke:'#007ABD',strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"})),'spectraBackgroundLogo':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:629,height:807,viewBox:'0 0 629 807',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M155.35 384.598C22.04 384.731 -50.5339 218.96 41.6946 124.989L370.474 -210.002L405.115 4.20929L235.903 176.068C222.848 189.37 232.348 212.283 250.911 212.265L473.541 212.041C606.852 211.907 679.425 377.679 587.197 471.65L258.418 806.641L223.777 592.429L392.988 420.571C406.044 407.269 396.544 384.356 377.981 384.374L155.35 384.598Z',fill:'url(#paint0_linear_3240_66110)',fillOpacity:0.48,fillRule:"evenodd",clipRule:"evenodd",strokeLinecap:"round",strokeLinejoin:"round"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('linearGradient',{id:'paint0_linear_3240_66110',x1:'240.999',y1:'-289',x2:'252.522',y2:'770.375',gradientUnits:'userSpaceOnUse'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('stop',{stopColor:'#F4E3CC'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('stop',{offset:'1',stopColor:'#F4E3CC',stopOpacity:'0'}))),'redirect':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:20,height:20,viewBox:'0 0 20 20',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M8.33301 4.9987H4.99967C4.0792 4.9987 3.33301 5.74489 3.33301 6.66536V14.9987C3.33301 15.9192 4.0792 16.6654 4.99967 16.6654H13.333C14.2535 16.6654 14.9997 15.9192 14.9997 14.9987V11.6654M11.6663 3.33203H16.6663M16.6663 3.33203V8.33203M16.6663 3.33203L8.33301 11.6654',stroke:"currentColor",strokeWidth:1.6,strokeLinecap:"round",strokeLinejoin:"round"})),'download':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:20,height:20,viewBox:'0 0 20 20',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M3.8335 13.3346L3.8335 14.168C3.8335 15.5487 4.95278 16.668 6.3335 16.668L14.6668 16.668C16.0475 16.668 17.1668 15.5487 17.1668 14.168L17.1668 13.3346M13.8335 10.0013L10.5002 13.3346M10.5002 13.3346L7.16683 10.0013M10.5002 13.3346L10.5002 3.33464',stroke:"currentColor",strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"})),'superfast':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:21,height:21,viewBox:'0 0 21 21',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M13 10V3L4 14H11L11 21L20 10L13 10Z',stroke:"#334155",strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('circle',{cx:8,cy:8,r:8,fill:"#5733FF",fillOpacity:"0.24"})),'secure':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:22,height:22,viewBox:'0 0 22 22',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M9 12.001L11 14.001L15 10.001M20.6179 5.98531C20.4132 5.99569 20.2072 6.00095 20 6.00095C16.9265 6.00095 14.123 4.84551 11.9999 2.94531C9.87691 4.84544 7.07339 6.00083 4 6.00083C3.79277 6.00083 3.58678 5.99557 3.38213 5.98519C3.1327 6.94881 3 7.9594 3 9.00099C3 14.5925 6.82432 19.2908 12 20.6229C17.1757 19.2908 21 14.5925 21 9.00099C21 7.95944 20.8673 6.94889 20.6179 5.98531Z',stroke:"#334155",strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('circle',{cx:8.33,cy:8,r:8,fill:"#5733FF",fillOpacity:"0.24"})),'nativewp':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:23,height:21,viewBox:'0 0 23 21',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M12 5H7C5.89543 5 5 5.89543 5 7V18C5 19.1046 5.89543 20 7 20H18C19.1046 20 20 19.1046 20 18V13M18.5858 3.58579C19.3668 2.80474 20.6332 2.80474 21.4142 3.58579C22.1953 4.36683 22.1953 5.63316 21.4142 6.41421L12.8284 15H10L10 12.1716L18.5858 3.58579Z',stroke:"#334155",strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('circle',{cx:8.66,cy:8,r:8,fill:"#5733FF",fillOpacity:"0.24"})),'googlelove':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:22,height:22,viewBox:'0 0 22 22',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M4 4V3H3V4H4ZM20 4H21V3H20V4ZM6.29289 11.2929C5.90237 11.6834 5.90237 12.3166 6.29289 12.7071C6.68342 13.0976 7.31658 13.0976 7.70711 12.7071L6.29289 11.2929ZM10 9L10.7071 8.29289C10.3166 7.90237 9.68342 7.90237 9.29289 8.29289L10 9ZM13 12L12.2929 12.7071C12.6834 13.0976 13.3166 13.0976 13.7071 12.7071L13 12ZM17.7071 8.70711C18.0976 8.31658 18.0976 7.68342 17.7071 7.29289C17.3166 6.90237 16.6834 6.90237 16.2929 7.29289L17.7071 8.70711ZM7.29289 20.2929C6.90237 20.6834 6.90237 21.3166 7.29289 21.7071C7.68342 22.0976 8.31658 22.0976 8.70711 21.7071L7.29289 20.2929ZM12 17L12.7071 16.2929C12.3166 15.9024 11.6834 15.9024 11.2929 16.2929L12 17ZM15.2929 21.7071C15.6834 22.0976 16.3166 22.0976 16.7071 21.7071C17.0976 21.3166 17.0976 20.6834 16.7071 20.2929L15.2929 21.7071ZM3 3C2.44772 3 2 3.44772 2 4C2 4.55228 2.44772 5 3 5V3ZM21 5C21.5523 5 22 4.55228 22 4C22 3.44772 21.5523 3 21 3V5ZM4 5H20V3H4V5ZM19 4V16H21V4H19ZM19 16H5V18H19V16ZM5 16V4H3V16H5ZM5 16H3C3 17.1046 3.89543 18 5 18V16ZM19 16V18C20.1046 18 21 17.1046 21 16H19ZM7.70711 12.7071L10.7071 9.70711L9.29289 8.29289L6.29289 11.2929L7.70711 12.7071ZM9.29289 9.70711L12.2929 12.7071L13.7071 11.2929L10.7071 8.29289L9.29289 9.70711ZM13.7071 12.7071L17.7071 8.70711L16.2929 7.29289L12.2929 11.2929L13.7071 12.7071ZM8.70711 21.7071L12.7071 17.7071L11.2929 16.2929L7.29289 20.2929L8.70711 21.7071ZM11.2929 17.7071L15.2929 21.7071L16.7071 20.2929L12.7071 16.2929L11.2929 17.7071ZM3 5H21V3H3V5Z',fill:"#334155"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('circle',{cx:8,cy:8,r:8,fill:"#5733FF",fillOpacity:"0.24"})),'zerobloat':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:21,height:22,viewBox:'0 0 21 22',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M12 3L12.4472 2.10557C12.1657 1.96481 11.8343 1.96481 11.5528 2.10557L12 3ZM20 7H21C21 6.62123 20.786 6.27496 20.4472 6.10557L20 7ZM4 7L3.55279 6.10557C3.214 6.27496 3 6.62123 3 7H4ZM20 17L20.4472 17.8944C20.786 17.725 21 17.3788 21 17H20ZM12 21L11.5528 21.8944C11.8343 22.0352 12.1657 22.0352 12.4472 21.8944L12 21ZM4 17H3C3 17.3788 3.214 17.725 3.55279 17.8944L4 17ZM11.5528 3.89443L19.5528 7.89443L20.4472 6.10557L12.4472 2.10557L11.5528 3.89443ZM19.5528 6.10557L11.5528 10.1056L12.4472 11.8944L20.4472 7.89443L19.5528 6.10557ZM12.4472 10.1056L4.44721 6.10557L3.55279 7.89443L11.5528 11.8944L12.4472 10.1056ZM4.44721 7.89443L12.4472 3.89443L11.5528 2.10557L3.55279 6.10557L4.44721 7.89443ZM19.5528 16.1056L11.5528 20.1056L12.4472 21.8944L20.4472 17.8944L19.5528 16.1056ZM12.4472 20.1056L4.44721 16.1056L3.55279 17.8944L11.5528 21.8944L12.4472 20.1056ZM5 17V7H3V17H5ZM21 17V7H19V17H21ZM11 11V21H13V11H11Z',fill:"#334155"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('circle',{cx:8.33,cy:8,r:8,fill:"#5733FF",fillOpacity:"0.24"})),'compiler':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:23,height:22,viewBox:'0 0 23 22',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M13 8V12L16 15M22 12C22 16.9706 17.9706 21 13 21C8.02944 21 4 16.9706 4 12C4 7.02944 8.02944 3 13 3C17.9706 3 22 7.02944 22 12Z',stroke:"#334155",strokeWidth:2,strokeLinecap:"round",strokeLinejoin:"round"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('circle',{cx:8.66,cy:8,r:8,fill:"#5733FF",fillOpacity:"0.24"})),'check':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:24,height:24,viewBox:'0 0 24 24',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M18.3602 6.35938L10.2002 14.5194L6.84016 11.1594L5.16016 12.8394L10.2002 17.8794L20.0402 8.03937L18.3602 6.35938Z',fill:"#22C55E"})),'xclose':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:24,height:24,viewBox:'0 0 24 24',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M17.9396 7.75255L13.6916 12.0005L17.9396 16.2485L16.2476 17.9405L11.9996 13.7045L7.76357 17.9405L6.05957 16.2365L10.2956 12.0005L6.05957 7.76455L7.76357 6.06055L11.9996 10.2965L16.2476 6.06055L17.9396 7.75255Z',fill:'#F87171'})),'heart-logo':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:30,height:30,viewBox:'0 0 122.88 107.39',fill:'none',className:'inline-block'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M60.83,17.18c8-8.35,13.62-15.57,26-17C110-2.46,131.27,21.26,119.57,44.61c-3.33,6.65-10.11,14.56-17.61,22.32-8.23,8.52-17.34,16.87-23.72,23.2l-17.4,17.26L46.46,93.55C29.16,76.89,1,55.92,0,29.94-.63,11.74,13.73.08,30.25.29c14.76.2,21,7.54,30.58,16.89Z',fill:'#1e293b',fillRule:'evenodd'})),'astra-logo':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:40,height:40,viewBox:'0 0 40 40',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('rect',{width:40,height:40,fill:'url(#paint0_linear_2971_69719)',rx:'19.9999'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{id:'pattern0',fillRule:'evenodd',clipRule:'evenodd',fill:'white',d:'M21.4952 11.3394C20.9235 10.2236 20.3519 9.1077 19.7647 8C18.8281 9.91771 17.8915 11.8354 16.9549 13.7532C14.6364 18.5003 12.3178 23.2475 10 27.9951C10.5404 27.9966 11.0808 27.9959 11.6214 27.9952C12.475 27.9941 13.3286 27.993 14.182 28.0003C15.6282 25.1883 17.0646 22.3713 18.501 19.5543C19.698 17.2067 20.8951 14.8591 22.0979 12.5143C21.8965 12.1229 21.6959 11.7312 21.4952 11.3394ZM27.9861 23.9851C26.6931 21.4095 25.4001 18.8341 24.1035 16.2602C22.7358 19.0199 21.3667 21.7797 19.9945 24.5372C20.5591 24.5368 21.1236 24.5369 21.6881 24.537C22.4409 24.5371 23.1936 24.5373 23.9466 24.5364C24.1569 24.9967 24.3625 25.4589 24.568 25.9212C24.8774 26.6167 25.1867 27.3123 25.5118 28.0008C26.4201 27.9926 27.3285 27.9938 28.2368 27.995C28.8245 27.9958 29.4121 27.9966 29.9998 27.9948C29.3282 26.6584 28.6572 25.3217 27.9861 23.9851Z'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('linearGradient',{id:'paint0_linear_2971_69719',x1:'39.9998',y1:'-1.19212e-06',x2:'-0.0009992',y2:'39.9998',gradientUnits:'userSpaceOnUse'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('stop',{stopColor:'#E976FD'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('stop',{offset:'1',stopColor:'#583EDE'}))),'starter-canvas':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{viewBox:'0 0 1916 872',fill:'none',x:'0px',y:'0px',enableBackground:'new 0 0 1916 872'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('image',{href:`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAB3wAAANoCAMAAAAcVGsfAAAABGdBTUEAALGPC/xhBQAAACBjSFJN
			AAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAADAFBMVEXt7u/q6uvm5ufFx8rO
			z9Hw8PLV1tfy8vT19ff29vj39/l6iYxeXm10dYK4wcP19vvj4+FygYVkYXKytba+wsNnanlscYCI
			kJSXnJ+orLCDjZHc3d4eKjaMk5ckM0BLTlrl6OyfoZ9TVGFFS1GbqamSl5olOkiwv780PEyEhok6
			RFXQ1ttYWGfc5eU/SV31+fjf6Ojx9fT////09vX//v/+///9/f3n7fD+/Pf5/v799O4+RUdcYWD1
			04+UxczXlV5ip7zmvYRSkqPw/Pr36cWdaV1KUWfB3ea/lltkenz86t212eK6gWf24aq/1M2Ed2pJ
			c3rSroyFgnlxm6HY6O65sKSTsrTq0rTmxaCUjYKlz9bX49CimYxbX3XRuKCHucHCmHbB09bYzcKp
			vL3O4upVWnFbb22Mo6DR3d7TpXjksmKihGNsbGZPVWx8aFdPZWa4po7/wQebuLmXtraiursyMjI3
			ODgpLS8lKCobJycgISMZHB4qOTY0Pz9FTGKqqKFYNyxPKRtDIBI7GQ4xEgpQOBNtOx93ZTxnX1Vr
			VT1uSzJkURRYQx82LSILBwUMDQ0CAgJnVk4mDAcZCgYnGRE+NygXFhIoKB8OFRikubBePzRfDwlt
			HxBfTCpGJhxCPT1XU1ZRMCVANw8OHiEtQ09xWiZKRkdzd3LQN13rDFP+AVExLQtPSA4rMyWjOg7I
			uTTwmxmHeBGpnhvfexRqcSPQXg0OXgxMBxC6ShDt9fJ+UUUQJShRQzO90stSTVD8zAm3bSH6v8/O
			ETXtkKXbc21fRj2OIw+0ycDX4eFjTUZIPirBu7H3+fVzYw25zsUUM0Lj2M7Qw7bq5eDw9Op2eE5R
			TjsNLTGzzJ/A1LB0mk+DjWOJq2iZtnynwo6FnYpcflTM3MFJWltJYkWgs5qBfTV+p645TTEZNjId
			YGpYXSyMZEQER1KCZyaTdkqmnHGQTiOWdiuhhC2zfkiZi0r+2jf1ukPPjjiyIyGzUTfIakvYVjDj
			fj3zlHXtoj71x2wng5Gk69RSAAAAAWJLR0QyQNJMyAAAAAd0SU1FB+YKDgQPO5c8YJoAAIAASURB
			VHja7P2LY1v3deeLkgKfEEiLBF8gQYAC+IC2IMiiKNoqdDo94wYdd5qmk+PRnUzCO+OwsD33GMlE
			EgASIGBJlBRLlgBahEBKtkTJoqmkjqdJm8ZVrai30/E4dnzkNKqbxk7sPM7tvefef+KutX6//cKD
			IkUaksz1pYjnxsYGSOHD7/qtR1VVVTVqE//jf/yP//E//sf/PuV/FksNqqq2qkryl8VisVgs1qeq
			mhoJ31rELyGYxWKxWCzWpylCb11dVX19fS2LxWKxWKwKSBjfuqqGhvqGehaLxWKxWJ++wPWiAL5A
			XxaLxWKxWJ++6mroq6oRda8PhsVisVisjaA66XwbWSwWi8ViVUQafK3We30oLBaLxWJtENXV1Uj4
			slgsFovFqoh058tisVgsFqsiYviyWCwWi1VhMXxZLBaLxaqwGL4sFovFYlVYDF8Wi8VisSoshi+L
			xWKxWBUWw5fFYrFYrAqL4ctisVgsVoXF8GWxWCwWq8Ji+LJYLBaLVWExfFksFovFqrAYviwWi8Vi
			VVgMXxaLxWKxKiyGL4vFYrFYFRbDl8VisViseyOGL4vFYrFYFRbDl8VisVisCovhy2KxWCxWhcXw
			ZbFYLBarwmL4slgsFotVYTF8WSwWi8WqsBi+LBaLxWJVWAxfFovFYrEqLIYvi8VisVgVFsOXxWKx
			WKwKi+HLYrFYLFaFxfBlsVgsFqvCYviyWCwWi1VhMXxZLBaLxaqwGL4sFovFYlVYDF8Wi8VisSos
			hi+Ltb5qsGy22ZqaGz6VnT+0paXV/unsunJqa++oWX6L6k5bV+2q9tlQ/aC/K6wNJoYv635WdYvN
			1qp+UDtsNluzvGyBy9211i6brb3nXh+kWVXdTlRv4+ofWtsJ1K5efpMWp9PVdq9f41pegdVa53Y6
			bVvgh9tks3WaEVsDP9Yuq7WxF95Bx8qftm+rBx7g7b3PfhVYrGXE8GXdz2ro1j+FkTvObulvuuBy
			v9UKH9Luujvto7qvr8AW0U13QceVqJ/Y67wbQOIrtPUtu0l1K+zbXvpV3QdawSuwNta44KcGnOyz
			OZ0tZvha8M8W+aMeWOmTNjZ7xXvuHHTcd+8Ii1VGDF/Wfa0hHbg96G5aha2q6nA6fTUrgy9+xhcA
			Ab1Xy+rCmitVdTtY0wFL26a7eOwK0NVoH3S2byr9qu4DrQS+1qptQNaG5eBrtXidnjv9XDXVKE5V
			Lvu9fgdYrBWK4cu6r4XEtQmQ4QezU6kx3XyX8N3+qcH3oZ417HpFvrG6p77Mq7oPtCL4PtSwZUuD
			fAlNpeFrrapb8XtINnnbloYtwHRn+51i3izWfSKGL+u+Fn6ySuB2kbcRMWiLNMRrcL5Nn47zxV33
			ruHFrhSoDzB8QQ+pL6GM812N8M+dJvwgU8MhLNaDIIYv6/5Wv1zjpI9W0GbyfQjiIasK31pLV1ez
			Ic5bZekf6LeI3+1NliFwyZ4hi0X7Xe+xOBTwSG0WS319jUW7owou1tTDvRbLJmtDTb9pl7RPR12J
			JcX6Ggc8WbVx1036Tq2N2jM04CU6+lp8pobi3Up0Vbd19Vt0KDX0NHcNOGrqxbXttLuiV1Xu8Bo3
			4YPVO/Al9uDbtbVPvRNepWnxu8Q7ou7Gru1/u7bNJrhk+OunxCuo0rZokLuuly/fCF94RBc8QoWv
			+CGI8yr8YQwMGX4YcmO5Z4v2Jxn+rlg+5d9HFmudxPBl3d+q8clFX7SUbhmDrmqSjpfga/FQso1a
			m1LdPSiyb7qRiBZ1OVB3yA71JlsfptWqycO4vNzVSPdaelppBbFb/f9R1SX26S4s86l3eA1Ppu/a
			/Gz0DBgqFyYeXxNlQxfsltC1yU579MpnaqxpFXv0imQi8edGwasqe3g17U7jHfgeOnps8mE94s8Z
			Z7vRLZZ4R/Qt/W0C1HrAocCqlngFeigA78SHqdDVw8614vhtderuHBKjDnxEDf18Xb3y5ys39tQV
			BhkoR5rhy3pAxPBl3d/aZJNZVm3weWtXRFwROdaBv7tIAbua69pFH/ab2rX0G8xMWh6+OgcpsRp3
			jvfa1X20SH+n73PAhLeqFu0OW4+1FHwb6xSZuGtxqRZN5XHhbglddpk+5HLQYdm1bCIXvb5S8C13
			eI0WxXwH4qq/Qz7Mor5vTsVArMbid8Sq78a11fAXAL2oEvA1v4Ll4UvOV3sXW+0l4DvkMb02bWN/
			WwF8d/jhV4SrjVgPiBi+rPtbSAD0i2hrWra0U4ERcawL74UbfW6nZ3MrmqEA8qB2M4LQbrHbhG3r
			Gej1YgnoQJcWt6wZ6AbAeHoH+qsoOVkk6WzxC6Dj577H6e7stWlAp897m6NtwF2QT9swgOjaZh/w
			yFwfC+3aNmB4NnwG+kOhS42a18Mh+reU2C0tcLudrQPdXhWJW+AoBnstNQ7VNgvumV5V2cPDv1Fc
			m9ssXV5JUQShx+V02/x11jq8s6W5uWXQjKzid6SO0sy7HE0udf/LwrfgFZSGb5PB+TZSdZatt9OD
			oY1C+MLP193Sjjyn12/Y2OYzPfemDqdeisZi3e9i+LLucw2J5V1kQj8RuJY45iK3hoFGHzaTojhx
			vzRu1LkBfRBZ5qLUpIcMpUaNXWqSDgIdfSmZVwxxNjhcEkt2uDCAa5/VTaI9hFQjFrlQSQzxj1xt
			ccJVr6hqxVC5iJqjmUcIF+2W8naV5ka5P9wG4daPBhITtNGQqtwzvKqyh4evDfdmbXMJ940H57TV
			4E312+CpKIpcAzd2NpgfZXxHcEtynY1titz/svAteAV3dr74B4YLg+r1A85i+Iq78M8u+nurx1+0
			MamBin3b76bCi8W6F2L4su5z1Qnq1FDEuY08I36K+wkyvSqbiC8ULa3fVEO+rbEEpoz7lKk+COsu
			ubkXN3c4VeendvhAbMoSlhqvSPQSaujU1kdxj7RNMXzbRJCZypQJa4jskrsldNEiK7lOPHoKgtNz
			9fTVyldc8KrKHh7ctUPkdW2SmKN1c0HNOq/6VOgljda38B3BLTvEGzLgNOa5oUrB1/wK7ux8h5xq
			Hl11Rwn4CjOLR9UiN95m3pheBP6l5GzhQiPWAyOGL+s+F2Y5A1uGyDUCwcDy4ud6t7r4KFxacX2t
			lpRVps5Xlhrh7jG2is6aHu8QFhqF1g+eB3ctb8Gt9M5L2G5KFiFjKFlRI7sm+D6E1B0gBm/uJOo6
			xKbFuzXUVT3UJZCN3aBsNYZYahF8G8senvn1qvAVmGu0a0+FXHMZVn0L3hHcUm0ypma/LR92Nr+C
			OzvfXqfWEMxRAr7irwkMZJTZmF4h/IWgPPBNr1kbSQxf1v2uLvzIRhcKxhY/v7sIiuIjWaeAoWND
			fZ19oMU/6FyR88WPcPR3yBW7vK6mzCI2YTN8OrdNyGdEvHE3aplLsfPFYwaYwctwIIDr8aXQ+nDR
			bkWusHjUkEBeNeVSKe39aqlRsfMte3io6hrHQDt57qZa08GBiXX5xYP8LvnSrSXfkV6nxuYtOgGX
			y3Y2vYI7Ol/1ZvW1FMLXYvz5ltpYvv0yQ43FejDE8GXd7yLUYuAUDU8/gqxf+wA2w5e4Uz2gp/gu
			53wlpBrRMzloxyL2aoAvPhIwqaUWywzoWuNu1E9/h/SHJZps4OH2gJ9UaoDm/i34UjBAXrxbY4sK
			vJeWadVc38HuTcZXbIBvucOzNtZ1uEy3Gw6u1/wowxSDwnfE0MhEfdLl4Wt+BXd0vkZgqxuXhm+Z
			ja1ihYCbW7EeKDF8Wfe70G711iiCBHhe1yLzh0s5X1l24253bF7e+aodrvDjfHM9xlpFQLYAvk1V
			RBHVWtqMg3jqCuBrt5aEL1rIth430AGey2XBJV/8O6J4t4XoomBylcMmAemps5aDb8nDkyVCLn+L
			w1/kfHt154syrhQXvCMF8MUkthXDt3+Fzlddc14evqrzLdhYO+R7/ZvKYq1CDF/W/S5cTm3vUn0t
			sBVR0iXuK3K+mKvr7NjesHzClam3sx0/+/GDXCwlak0xtLCyyPrdKb8MkmFpUlfZsDOlOw20kd0F
			N9nvkKwp3q0BQ8aVVmt9naNjUGYllQ47lzw8fK8Gu7CBleo1zWFn3M/OokcVvSNdzsI4/PLwLXgF
			d3S+2nK5YXdlna9aeVbw3PWOgYFmK4v1AInhy7rvBZ/igz7pAxGpiktbhCxyvnrq752ynbXezkiU
			IYdWpIOf97Lyxi4Cp7hByfG8SDeJGkrv6rGWhC8mRXdsFvlTPmdTiyR28W4Nw3qRSMYsKDEEd1Mp
			+JY9PHyIyDzeZCtyvkMF+zfK/I4MObW/ddSSJS3PzWovhm/BK9CTvPDtKpXt3KX9nUF/Oi3rfGlt
			XeS349tq7nC1zr93LNanKYYv674X+lTt076NIrB+Wc1a5Hz1fsGbWlfofJES21o04jrUtWJRy9Im
			NpCM3dLU69BbGRMrZKWTT3b3LwHfh+CYXT7axSYRQu5Xn9e8WyrUob1Q0RC8SHB0LaJ+BumOr7oY
			vmUPT296bPEVOV8ErCjZsbY1DdhN9bHmdwS3FO83HoNLrrw7e/FOCvIXlhqZXgGlKdMRUzVQqWxn
			tO6tdAC47fLOl2L4FH8X7bvU566vqeGoM+uBEsOXdd9LjFSQaTaiXHZzQe6veQGROl31qhBFZCht
			DfUGY4QM9NQ0yp3YCYiqD6QmG7a6RusmBAlBAQ1fO+JtU5Pe+BiFMFOaG6yN2H5Y3FFqqpE4ZkQH
			lQ5rf0cU7pbQ5eyuhv0hpAcaRKdlh9rgAqnWW/yqyh0eRc3xfzh1IClwvlSj3FtlFcduaM1R9I5Q
			dW8TdtLCt5QqfhGXru6eTW3Ud7oQvqZXIG7ytPX1DKj554XOlzK6m+AIetqdzjs5X2r54e3vqevy
			Gp4bW3q08IcZ60ES/76y7n9RY0YZWRUf7+pqaPGaL35ce7sHOt1On3qfmEVoTIalHpQawh/2G+/H
			HXS4nF6y26KbIuHHZeumJpamz3hq7eC2EVyFjywFX3HMZHeHDE9VtFtaFAWeeYgr6GYp89hp6x1o
			V1s79ha/qnKHRz21bAMDLYOuYufbSKZVad+Mx15YpWN6R8SWg36b1uJRFkARZ91F8DW/AtGAi9Ta
			VNr5yhbUbvxbQbmT87VuV9O/lX7tuRuxHNrFMxVYD5IYvqz7XzSSQHV0/U495aZEqZE2ZKBFK0gS
			xtNtbLlfQx/3rRKCuHgoV0dlwpWAszpHwFrVrdXkdJgCtA2OQQ1D4v9SyXm+/ZqPpAaP6gpt4W4p
			V9gi4eKm7RuaC4Ya9JZ4VeUOTx2d4OpvKoIvXLGZ92x8WaZ3RDpS/aD0PbfUFMO34BWof+k4FUtv
			mcEKoj2VcXfLwFf4ePhrwG54NRiM5lG+rAdKDF/W/S80YmoxCk0J0lxsqTpfmig42FXl0O7b0WSk
			N4lm7Xnl+ijGbbWPbvq8F2PrbG0qlBpFgNXptxeuLNaIUtpWddPtpeCLbJDLph3GIynYrSjU2YKb
			uDarr7dnG/F9sIlaMhteseFVlTm8h8REQU9bVUsJ+Fqr+oW776gpSlUyvSPalsqAivaHevDJla7a
			uhLwLXgF1noHPrq9xloOvvLHMdhZdcc6X3yxu2p6W9u7eoyvpr7LJYY+sVgPihi+rAdMd85prd9h
			2VHAyPq+vtqCrWr7+tSNsEFjh/pfQX7ewyOqzanImyw7Sv53qd9Us+Pu/x+V2m2V+Wgbqutq+kql
			ExlfVZnDq4KHlodSY3VPzaZSeza9I+qW1aYd1fZVl99x0Ssoevvv8IiVyAj+xupqTnZmPVBi+LJY
			ancq7cqGXz00vSP3mWprZHZY2318kCzWncTwZW1sNVQ14BqlV6vQ2fDwLXpH7iv1YNazGDfczuu8
			rAdYDF/WxpbIW3LqC4YbHr5F78j9pIdqsdTI3dvW3K1oGeYs1gMohi9rY4tqf6SXIm14+Ba9I/eX
			+jq01O6C1HMW60ESw5e1oUU1su5+Q67PRodv8Ttyn6mWkqfxIB3se1kPrhi+rA2uhmozZ2r7+vo2
			9od64Tty36mhxwLadF/GxVmsFYrhy2KxHjA91NjIhUWsB1wMXxaLxWKxKiyGL4vFYrFYFRbDl8Vi
			sVisCovhy2KxWCxWhcXwZbFYLBarwmL4slgsFotVYTF8WSwWi8WqsBi+LBaLxWJVWAxfFovFYrEq
			LIYvi8VisVgVFsOXxWKxWKwKi+HLYrFYLFaFxfBlsVgsFqvCYviyWCwWi1VhMXxZLBaLxaqwGL4s
			FovFYlVYDF8Wi8VisSoshi+LxWKxWBUWw5fFYrFYrAqL4ctisVgsVoXF8GWxWCwWq8Ji+LJYLBaL
			VWExfFksFovFqrAYviwWi8ViVVgMXxaLxWKxKiyGL4vFYrFYFRbDl8VisVisCovhy2KxWCxWhcXw
			ZbFYLBarwmL4slgsFotVYTF8WSwWi8WqsBi+LBaLxWJVWAxfFovFYrEqLIYvi8VisVgVFsOXxWKx
			WKwKi+HLYrFYLFaFxfBlrY8aGxsbWKzPpOCX+17//2J95sTwZa2HBHjrWazPoASA7/X/MdZnTAxf
			1jqoEcFbW1tbz1/89Rn8qkUAM31Z6yqGL2vtamyob7AOs1ifWVnhV5zpy1pPMXxZaxb43t33+sOR
			xfp0tZu9L2tdxfBlrVWNYHzZ97I+47KC9WX6stZPDF/WWgXwrb3Xn4ws1qetWoYvaz3F8GWtUWh8
			Gb6sz7xq2fqy1lMMX9YahfCtutcfjCzWp60qhi9rPcXwZa1RjY31tQxf1mdeVbX1DF/W+onhy1qj
			MOrM8GV95lVVy9VGrHUUw5e1RjF8WRtCDF/Wuorhy1qjGL6sDSGGL2tdxfBlrVEMX9ZG0AjDl7Wu
			Yviy1iiGL2tDiOHLWlcxfFlrFMOXtRHEzpe1vmL4stYohi9rQ4jhy1pXMXxZaxTDl7URxM6Xtb5i
			+LLWKIYva0OI4ctaVzF8WWsUw5e1EcTOl7W+Yviy1iiGL2tDiOHLWlcxfFlrFMOXtRHEzpe1vmL4
			stYohi9rQ4jhy1pXMXxZaxTDl7URxM6Xtb5i+LLWKIYva0OI4ctaVzF8WWsUw5e1EcTOl7W+Yviy
			1iiGL2tDiOHLWlcxfFlrVDn47qnp6ujYPNR4rz8zWaz1EDtf1vqK4ctao8rAt7GrY7NjqLOjZdO9
			/tRksdZDDF/Wuorhy1qjysC3q2NoeGRkZNPmEvQdqd1ePXqHj7rResMWoz2OtlIPaOzpsa7i49Na
			K7TsY0xPzGJJsfNlra8Yvqw1qjR8LR1twyP0kdU0UHhfVW/L5pbuTct/1u3YvEO/0tPSXFe8yaij
			aXNLk2Vk2FrXUHjfpp4S+6zpEKpZ6RNX9TCIWVIMX9a6iuHLWqNKw7drs7wwMtSxyXTPyGh/v3V4
			1D6wrP8c2WJg4Oj23lIbW7qrh4e3b940XNu9o/Dhzf2l92ti+p2eeKT087I2otj5stZXDF/WGlUa
			vh1d6qWejgLT2tCJzrOhzjo80tPV2wZ4s7YNDFhGhxvsPY5+q7xxx+YaR7ddsM8y0NK/fXi0ZmCg
			Rt0Kb7YjYEd7qqr6W7ossLP+Tnu9vNvSudlRVfwIFb7qE1tqajodtVu6BnpGhi3ba3q74By3kPva
			Ds+7Rdt4dPtAbxs74Q0rhi9rXcXwZa1RZeA7pF7q0S+SwPl21YtLzZvbLJ39o9au7pqazc1gYLvt
			PaPNLc01vf2jO1q62yzd/QS7Hke3ZdOoo9Ni6XaMiq3wZsvmHoxsDzdYNg/1DLe1NNd1DVjF3T39
			vTUN+Ii2zfYR/RHS16pPPNzf7ajp7e6vsbfsgMtdNc0tNQRfua9N8LxVw+rGbZstPZ3NI/eaAax7
			I3a+rPUVw5e1RpWGb6e20mvpKFh+Hant6uhurh0eru3soZPRvnp0t9bazRa43r0dTuxVO1rAMPd0
			19JDMPy7Y/Om4eHq7h7cag8hcLS5qcWxY2RYhJ1r+/DuLXT38PAQuOJNGJaGE/0R0vmqTzzc3zU6
			3AP7tQ5Yhvs7d8NR9DbiFnJfwzXwvPrG9uHh+tp7zQDWvRLDl7WuYviy1qiS8DWs9A40FZb6jgw3
			1gw0tY30dFtqaizdFsBxjb23F+BbA7ztRFu8hyzqyA4BX1p7teAisbWrjbYS+xkZ7XG0dDXKNV9r
			T1tXyw5xN635WnD/bZt79EcI57tHe+L+fvEcI/1DeBmJu4nwLPZF8NU2bmtyrCq3mvWZEjtf1vqK
			4ctao0o738amTsFcR0HUWWpPzebq7S39Dvja3jjQ0t/WLOG7vVNkLhMDJXwJgs39YF6BkgaU4kdi
			NdhahO9Ic1OXvaZbwpfWg5s3w+4d/VuMj6Ddqk8MwB0Rz4HwBWOLe4It1H3R82obj+xwbG5aNlGa
			9VkWw5e1rmL4staoMnW+fU0tQz092wc6OhzmO0YesQPt9mzq3rKluxrc6/BwHeLPIuG7CWuQRutH
			Ke9pi8H51nXXY7LWdg2l1maMZ1u7mgm+9Riuru42ON8R5Djuv9D5jsgnHhlB57tFdb5doxTnhidW
			90XwVY9yeGQUzXT9vWYA696InS9rfcXwZa1R5dpLbhrAktqmIUchfRt7+xuHd/f3Wke7+q3DPZu3
			7ADe1vYOCPjijSMWYqDZ+e7uHRodHequ11Fq37xleLStZQfAtw6XbUdG7WrYeXioSzxipKa7qsj5
			qk9sdr5NNSMNA44R2ELd13ANsFbd2DoAz2/n2qMNK4Yva13F8GWtUWV7O+/ZVDfU0zi8p5C+I329
			QOVeeEx9V0dTU9vIqKOjpcUune9wPUB7c92w0flSwtVwX2dHB2JaQ+lDjqaOjpYasLDNHV3W7S1N
			TQ7N+VZ1d9TBI5qaWrYXOV/tiYfNznegqaOrkZ5Y7mu4caCjbbhWbrxlc0sTAJu1McXOl7W+Yviy
			1qjyU432jFC4dk9/U+E9VrXDo1X0cjS3dLTW4+ruCAWGTQ9raBg23zBaa2htNVpvHR5RHyHPG+oL
			SoNG5BbiibXnGMEQ9EiDVW4xIvalHxAd3kh94fOzNpAYvqx1FcOXtUbdcaTgg8Argu+9PgjW/Sx2
			vqz1FcOXtUZ9Rub5jjgca98J6zMshi9rXcXwZa1RnxH4PhAGnXXvxM6Xtb5i+LLWqM8KfFmsZcXw
			Za2rGL6sNYrhy9oIYufLWl8xfFlrFMOXtSHE8GWtqxi+rDWK4cvaCGLny1pfMXxZaxTDl7UhxPBl
			rasYvqw1iuHL2ghi58taXzF8WWsUw5e1IcTwZa2rGL6sNYrhy9oIYufLWl8xfFlrFMOXtSHE8GWt
			qxi+rDWK4cvaCGLny1pfMXxZaxTDl7UhxPBlrasYvqw1iuHL2ghi58taXzF8WWsUw5e1IcTwZa2r
			GL6sNYrhy9oIYufLWl8xfFlrFMOXtSHE8GWtqxi+rDWK4cvaCGLny1pfMXxZaxTDl7UhxPBlrasY
			vqw1qrGhgeHL+uyrqraB4ctaPzF8WWtUI1jfKuu9/mRksT5dWavA+DJ8Wesmhi9rjUL41tbe649G
			FuvTVW0tw5e1nmL4staoRoo711r33OtPRxbr09Ieay1FnRm+rHUTw5e1VpH1raqqrt7EYn0mVV1d
			VcXGl7W+Yviy1iq0vvW1gN+qaiAwi/XZEvxaA3qBvQxf1nqK4ctas4i+gF/gby1/8ddn7AvJW1vP
			7GWtsxi+rLUL6Qv4ZbE+o4Lfb2Yva33F8GWtgxoJvyzWZ1aNzF7W+orhy1oPNTYyf1mfWdGv973+
			P8b6jInhy1ofNbJYn2Hd6/9frM+cGL4sFovFYlVYDF8Wi8VisSoshi+LxWKxWBUWw5fFYrFYrAqL
			4ctisVgsVoXF8GWxWCwWq8Ji+LJYLBaLVWExfFksFovFqrAYviwWi8ViVVgMXxaLxWKxKiyGL4vF
			YrFYFRbDl8VisVisCovhy2KxWCxWhcXwZbFYLBarwmL4slgsFotVYTF8WSwWi8WqsBi+LBaLxWJV
			WAxfFovFYrEqLIYvi8VisVgVFsOXxWKxWKwKi+HLYrFYLFaFxfBlsVgsFqvCYviyWCwWi1VhMXxZ
			LBaLxaqwGL4sFovFYlVYDF8Wi8VisSoshi+LxWKxWBUWw5fFYrFYrAqL4ctisVgsVoXF8GWxWCwW
			q8Ji+LJYLBaLVWExfFksFovFqrAYviwWi8ViVVgMXxaLxWKxKiyGL4vFYrFYFRbDl8VisVisCovh
			y2KxWCxWhcXwZbFYLBarwmL4slgsFotVYTF8WSwWi8WqsBi+LBaLxWJVWAxfFovFYrEqLIYvi8Vi
			sVgVFsOXxWKxWKwKi+HLYrFYLFaFxfBlsVisDavaHdsrpB2199eT32sxfFksFmujqnZ71ehwRTRa
			tb32fnryey6GL4vFYm1U7aiqDP1QVTvupye/52L4slgs1kbV9gpZT9To9vvpye+5GL4sFou1UbW9
			cvgbHt5+Pz35PRfDl8VisTaqGL73TAxfFovF2qhi+N4zMXxZLBZro4rhe8/E8GWxWKyNKobvPRPD
			l8VisTaqGL73TAxfFovF2qhi+N4z3f/wra9qvNeHcJ8f0Ketxrq2TWXvq6q/14dXXvf62O7rN4fF
			QpXi36P1e/Hsdx4afvShysJ39Hfq6+uXfU55bAzf9ZMlGAx6bc0lsNblrlu3Z2m07Ou704E01Vbw
			gMTTtLfdBc4dnfJCrcMT9Lb0fGqH0tjltdWUe1CN17HcLptW3dKttgkOw9O7abWPg5+t+mQ9Td6g
			x15v7fF0Whur19ZUTuzrLveBb87dHQD+LIJBwy/aev2QV3sQ9F+gtslS0SdmVVAl4Dvyv3h+F872
			/KvfG/5f//VjFYXv738uBPq9ZZ7091v/gOG7vrL46/o22d324nv6atbRPqwCvhU6IHiaHofbsfpH
			qvCtatnXtqmuxbPmvwjKHUq1rdla9o+D2prq5XZ5N/Dd2tdX02JbPX3VJ+vxDGzqG4LX0VizCXZ3
			F2+trjZ3Zw/8FvTe3U8c35y7OwD8WfT1VWtPu24/5NUeBP0XYPh+hlUCvqP/5nFi7j2A7x9+7t+C
			4/6j3yu/i88zfNdZZEkbGx0t9Y30iVOFn6P19OlTX90It8FlAkBjdZ/4iK2SN6jn6o42Gc9KPo28
			qO5IvSDOVf+0/AFZa6tg83p5IOI9rJeflXdzQPbWau1A6qsbtvTgmWn/hrdA3NOowtdu24I39uJx
			ywfVVtX3bMJr1SZorPRQ4Lmq6+rpFcET1tf5h6q1a/qBidcr3h15n/6uGN9M7ZWs6DCqCFbVNru2
			W3iK2rpa/Y2VL6v0k4EcHfiG2bfVwgMbt3RsFYdZ8GuzomOxVrc6cOs6j8X8IuGCuFZwxWr+ddUO
			oIp+RaqqVvrERREa4w/Z+BtRhddqC64YN6EfpPYruvpfCPovIOCrPRpfXFXtivfDuq9VAr6/3/TH
			X/iDNTvfPT1d1XBW1VW3Cvj+PsJ3+H/5k8eGf+ffffF/ewJA/O+f+HdN+x8ZHv6//e7e4T3/4d8S
			fB/9D1/a/B/3Dv+h48tf+b27f/J7rvsEvtKSav/RO8G32N0ej60HDQ24IY/H2wLHuqnD6/H211ur
			tnn3uTtrtXN9Pw6L4azM01jljrrq9T3W2dx+79YG3fkud0Bwe4vHiz4EDsDjhQNQ77y7A6qx9WkH
			YunYFuy0WmB3nhq5/21VVv0twHvQkEv4qs6qZ2u1fldLU9CB19weY7x4pYfS197l3deHr8hrq7PW
			+L2e1h5xrceqHpj6evva66zqlvq7Ynwz1VeywsMQr6d+m8OqPmVtU5fHXae9sfiy3JYyT4ZytFer
			u7JUd3jdrT1FvzYrfkuEAW9wtBW8yJZm+GkMNBRcwZ+I8dcV3hxxAM22aiS5feVPbIav8Yds+I3Y
			5/E6utxur8V8RfulFD9I9dpd/kKo/wXU973R7vW4e7c5Vr4f1v2sEvAF4v4rhNoanW9XV3/1cDWc
			jqwcvn8o4Dv2xB9+7vcs//fWfws0bvlPlv/8J0+II/lX/wnh++gf/esnv/oFvNgy/qd3/+T3XPcJ
			fBspzta2r02EuBqBdVtsbdb6gQE0NFVN8If/FjBDtS3wIVLjabO2wQ2bOizauaqH7A78BLA4HPbS
			TyM/1GqbYEc9+3CP3bhHS1ULkLjGX2fVnO9yB2R1eNsaazvBFg80VcEd+p13d0BDrdXaS7MEwW1V
			dTjAc2yrbeiF/fd1DDTWqm/Bpna4uxmgIOG7Sa7HPmQ13AVHB6+uDXZhCN+u+FD69jUh5OFzun4r
			WPK+fRZxrbYTfhTywNTXi/DVtlTfFeObqT5gpYchnW+7XXtKeunaT7rOAy/L7u8p+WTyHWm31Ipd
			WQS26gt/bVZ4LA2ObQ3au6O9SHeNtccP7roND8J0pVP4b+3XFd8cOoAtNgv+WbNl1b+nUoYfsuE3
			oqOqcSjY31jfiXg0XNF+KekHCdf66GhW/wth/C+gve90wWFc6r/Dflj3tYrh++gf/e7w5zseW/Oa
			b1VXV9cO+K5erfN99D//3l584pH/5V8/9vufgz8DHv034kj2CPiO/iEcFNz3eYDznrt/8nuu+wS+
			IsPEO1Bl1Yxmzz7xIUlWAv+rd3bKz6+tnVa7dDd0bowj9jngg8Di6HeUXttVP9Rq9mHuir2pli6o
			STGb4CmNCVdlD8jqwK0stuot6IWszU216p2rPiD6gPM49JdmaRUuiXayhXYLBkx7C0h1++pU+OJF
			o+iuFrD0W7sBHFXtltUfSh9+1DdsG2jE47AQfBu29ePRtNapB6a+XuCLvqX6rhjfTPUBKz0MWvPt
			6bZt0p6ytsmuvrH4DuFz4LtR6snELqq6PEFbm8gTovfN/Guzip+O+n4b3w58c2mviFbzFc35yp+V
			Bt/GzoHGxoHuhhU/sUi4ghfUSXlXhh+y4TfCLn/69JSGK9ovJf0gxQOqqu7iF8L4X0B737fiHyTV
			NqPzvcN+WPeziuH7+Y4nhANd65ovArCr/xHDLStwvuGnntr3r58Y/TeY8vX7TX8q49D/eq/B+cJm
			X/33X0D4/sFanvye6z6Br/hTf0sT2gZpNOGv630DPY3io4X4B2Dy7gO5YasWb7ujGhNRxLmuPvgM
			APUt8zQgC60LwjVxAVTbvG2fN2ixGtd8yx6Q/Jzd11fn9sMBefb1qXeu+oDwA87jqNdfmjiANq+n
			s6bRWtcKRqWxZ1+d9hZYqx1N+7zuukLnSz9M412dbtyh17H6Q0FmwOdsm1V82iJ8a5s8sDO/16Ie
			mPp6YVt9S/VdMb2Z8gErPYwqzHb2NvXoTyleuvrGdtILgjei5JOpr6Wv3+1o1OBb9Guz0rdEd75V
			phdJ9nyT5K3pSqPx11WDL8Kyut2y8ieWCVfw+0R5V4Yfsvk3YrsGX8MV7ZcSD0o8wHpXvxDG/wLa
			+04XCtLIlt0P675WEf9G/tcQZRyvPdt5T5XZeq7I+f4ulRr9zh/9R7r2BwRftMAG5/s7fzT29Pi/
			uwN87/zk91z3CXylJe2x1WlGEzDTvM3rMH2aWWzNbaCaBvj4cbTjgp96rgv+DC//J7gG33YVvu3i
			Hahub7f39Bid73IHpMPXZscDwjCnuPNuD0h/afIAqiyd7t76ulb0bHUG+Pb4m9p6anTnW9UhYn3V
			lirzXZ3bcH9tPas/FAnfZqsRvl20t03qgamvl+Crbqm+K+Y3U33Ayg5DfKxj+pL6lDLXVr6xnVut
			VhN8i35y6vtZrcO36NdmhW9JcyuRurGm4EWazG4J51sEX7DMlnZzXvjKfhbWwh+y+Teizghf9Yr2
			S9kn4Cuj3Xf5CyH/C2jvO10ozOFedj+s+1lF/PudPwL+1X++/Yl1yHZ+pr/HdH2Fa76g/4KLzuDB
			f/9zSOH/x+9hmHl4+N8QfDEmLsLOf7CWJ7/nuk/gKy0pBRkd4v92I/ayGGqtVj9aGuE/fh3FD+GO
			esyi3TagnRvVV/5PcM351mHukLW/pZ4uNNT00EeUIXi5/AFJk7OvbwtZktp67c67PaBG7aWJA8Dd
			1ezr2YSLhda21mrtLaC/FgxhZ7mK17i1o8p8V/82zPIt+Pmu5FDIxVGkFBcra0TYubsLE59rtQNT
			Xy98vutbqu+K6c2UD1jpYVSpH+v16lPKXFv5xlK0GWFU8slwQ6ID3qPBt+jXZoXHYt1ko2znLfva
			zC+yjPPFA3AYfl11+Fq3buveWrDzFf0srIU/ZPNvREnnq/1SEnzFA+rq7vYXgv4LWAzvO/4RscXv
			WPF+WPe1Cvk38vmxJ4aF9VwzfEdGRsw3rDDbGbnb+m+p5Oj3P/cnT9AV+H70P+yT8P3T4T/83+8E
			3zs++T3XfQJfseBY19JRZR2w1W0acDswC6qxtnNbvdFK1LZsq4Y/xR3Wro5NcG7Xzs2vqWr5p+mr
			bqzf1lTdaPHAh3MLXvDX9fjbGmsHDMHLZQ9Is12NA+1brJuaOhvUO1d9QOqnrPbS6AB69tkb6/vb
			qxu3wh8HeKv2FtR4aqzVLXrYGT77bTVVmwa8loK7evY56hvthZWhKzkU+syGvTU3VnXDwciEK3h/
			+m2b1ANTXy9uq22pvivGN1N9wEoPQ/dU6lOKl66+sVvgZdX2t24q+WT0OLu7ub6xxtbbgA9s2Na5
			qb7o12alb4m1zdu1qcpia6o1v8jSzrfGbe8bshU4XzoAgJ+7uDXLHX9P9RIt/Yds/o0o6Xy1X0r6
			QTYOwAPq9rXdxS+E+l8A966975tsLXU1HUXl4FX3yycJa3Uq4h94Tsxi+i+U8nxP6nxJ/+FZf+T3
			HgP47v/a1yO/O7zn0f/iCf2ecL5w8etj//WOzvdOT37PdZ/8lxELjt5tm7D2J+jtp0oTbzDYscVq
			dL7Wvm2YAoIlRnDepZ+v6mmCQBl8oBtTgWiP9kZ8Nm+X0fkud0Ca7bLWDsCN2/q0O1d9QJrFUV+a
			OACLOxjEvJnaLjiurfVW7S2o76ID1eFrrcJDQLNjvgv4Ay9x5b2zCpwvXIdDaILXT/BtbHOLJ5EH
			pr5eKjWSWzaq74rpzVRfyQqlOV/tKeWar/rG1tnEAZR8MlS9wy3eSUEkv7em6Ndm5b+X+CbiI80v
			srTzxfe/yV7gfMUBwEar6Tcif0+D+iqx9kM2/0aUdL7aL6X4KwqvUVXdqn8h1P8C4o20yZ/jpt59
			7Za19S5h3T8qcr4je0QGMZzvAfe4ZzV8WzN8h/fsVZ9w9Hf2ChqPNuwd1g4JN8Eek8N70NfuWc3R
			MXzLyPiRUCuv1FeXOLp6Welf22c+X7Vq1W4LtWKP9dVld7SiA1LvvOsDMh8BNW8oeVzFB6q1MCy4
			q6p6xZ+0pWTujNgoX596YMY3o6iHovFAtFdyFwdgfL/VN7ax8KdQ9IY0GptJNNYat1n9T0f7PZEv
			crnXUl9q53QAImV7LdLf4xK/AIVXzJvUqy96Tb8Q6vveYLXeZd8u1n2oYv6p0dp7At/CAxEJVzqb
			h0tdZPiyWKySaqxuNhT5PtiqA/9NVc+sz4Tu86lGehx63Z/8novhy2J92tq0z912r49hvVS/1ev2
			eu1riqmw7h/d5/AlA87wZbFYLK2LOeuzoAcAvp/Sk99zMXxZLBZro+q+h++n9uT3XAxfFovF2qhi
			+N4zMXxZLBZro4rhe8/E8GWxWKyNqu2jlcPf6Pb76cnvuRi+LBaLtVG1o6py/KvacT89+T0Xw5fF
			YrE2qmq3V1XIfo5Wba+9n578novhy2KxWBtWtTu2V0g7au+vJ7/XYviyWCwWi1VhMXxZLBaLxaqw
			GL4sFovFYlVYDF8Wi8VisSoshi+LxWKxWBUWw5fFYrFYrAqL4ctisVgsVoXF8GWxWCwWq8KqOHwr
			VVPNYrFYLNby2kDwZbFYLBZro4vhy2KxWCxWhcXwZbFYLBarwmL4slgsFotVYTF8WSwWi8WqsBi+
			LBaLxWJVWAxfFovFYrEqLIYvi8VisVgVFsOXxWKxWKwKi+HLYrFYLFaFxfBlsVgsFqvCYviyWCwW
			i1VhMXxZLBaLxaqwGL4sFovFYlVYDF8Wi8VisSoshi+LxWKxWBUWw5fFYrFYrAqL4ctisVgsVoXF
			8GWxWCwWq8Ji+LJYLBaLVWExfFksFovFqrAYviwWi8ViVVgMXxaLxWKxKiyGL4vFYrFYFRbDl8Vi
			sVisCovhy2KxWCxWhcXwZbFYLBarwmL4slgsFotVYTF8WSwWi8WqsBi+LBaLxWJVWAxfFovFYrEq
			LIYvi8VisVgVFsOXxWKxWKwKi+HLYrFYLFaFxfBlsVgsFqvCYviyWCwWi1VhMXxZLBaLxaqwGL4s
			FovFYlVYDF8Wi8VisSoshi+LxWKxWBUWw5fFYrFYrAqL4ctisVgsVoXF8GWxWCwWq8Ji+LJYLBaL
			VWExfFksFovFqrAYviwWi8ViVVgMXxaLxWKxKiyGL4vFYrFYFRbDl8VisVisCovhy2KxWCxWhcXw
			ZbFYLBarwmL4slgsFotVYTF8WSwWi8WqsBi+LBaLxWJVWAxfFovFYrEqLIYvi8VisVgVFsOXxWKx
			WKwKi+HLYrFYLFaFxfBlsVgsFqvCYviyWCwWi1VhMXxZLBaLxaqwGL4sFovFYlVYDF8Wi7Xh9flv
			rKM+f69fzWden4kfF8OXxWJteK3nh/k3vnGvX81nXp+JHxfDl8VibXh9Jj7NN44+Ez+uewDf+kf6
			WPdSj9Tzj+vBEf+0KqJ78mnOP627FcP3rrT9wP4yOnhw/2p0EB5QUuXvETqAXwcO6JfhmnpjGR06
			cAhEl8SZelNJlb9HaHz8kPwq1BBKXJJXVqVm+NIuNIsTXfK25ua2VXyeO6LRWHxiEhSfjMcTyYlE
			PB6fiE9MTEzBTfHJqRRcmIDbpqbizqlUKhVMpWIef9AVUFypYCjUtCJ1rGyzVW9b8vGa6GpLS+F9
			8AxwOhaORMLpcCAUCofC6bEwaCw8JhSJBALpQCACt4RCEVAoTJvDOW42NtbR0T42Fm6HPbbiLZFQ
			GraNwAPhckTui77hH2zVstzxbrOs/Kf13OEjR6eFjoHg7OjRI0eOHz8B+uY3n//myVMvnDh9/PjR
			o2cy2UxmZmYGzmZKKXPkhRe++Wx7+7PPvnjqxAl8BOzqCHwdpR2fPXsWv2dz5+Bk9ix96cLLudnZ
			DEic4nk+k8/nZ/OzcDGbz2ey+bl8NJs/k4VL8AU3ncnCIWVn8/m5HGycJc3l8WGZWbwnm8zQA2Pw
			nUniBvlsJpHJzmQzUvhqMnnYNCruB2XkycwMXpink5lsEs+SdFXcND9/Lz7N60eHWXcnhu/dqP6A
			mZ+r4q3xkYZLB/XrB8VOJYLpUjGLEbSFNxXpoOELUavyVuevAbMH1LMD8kTecl7/Pi+gO070Lcau
			kcDjCOAh5K99BQgeL+CvCuAhRK0EsgZjQePGFdO33utNxRMA3yQBeDIB1J2YnEggfqcmALrRqfiU
			c3LK6YR/rqnUFPB3KuZ3e50uxelMKSHb8mTRiXonpnaoX6VOkF/qV1mWdRiw22EUPapFQpfuHEsj
			SUNAylAaGBtAdiJdwxFEKeAVCBoKhBCr8C8QwrvG2tvH2scQwWITkL/V5hnDB0aI3LDHQBrui4iN
			cCu4vaNF/AWwTf9XcL7yn9aFI0cEHVUBMl86+tLx48dfPn76xKmLF08Lkh69RKzCf5nS9D16/PTJ
			rz377LNfO3nxBDz4OEIdCXwc9n8UwHvsWA4JPHv2LJznZnMIXGQsKJ/DGxC/hMUzebgJwYsERvwC
			POfy2RxRNZ85R3flc9lcFu/L5nP5BTrPZ2fhi9gMt+UR2cm5BBIXuQtnBG2iLbwORDDdh7dmMgK1
			ANUswhkuSBjPI3Vn5sWFmeyMRG/2XsC3vvFeI+zBFcP3bvTInXG6Gu9rvNavwtZAXuGES9thncDF
			TtlE4APnD2oOWHJYnBdZ3QNGBh865KB/wFrd5y5PXgndoXH7kKCwvCAZO67+08A7Pm7Cb7MdTuyE
			X5W1Kn2HdPY2Wx9Z8Y/rcswbQ/hOJIm/E4logsibiCWnglNA3xR6Xvh2OtH5+oC9qZTb43P5vC4A
			cCDQXmhbO4pZWAKIK7m3pdymwtKuCL10RAVqD4fSoQh8ga8NhBQgMHE3Qo4VyQkgDSGV8Ra4ABuD
			qxV8RQSPjaEdhmtof21h8r6RSBpuggcp6YjYBVIYTPVYe9OdtOL/pI8cviLhe5b+ofUFZB5/CfCJ
			X3TyEsL36OyMwG4Z+mYuHT9+8eTXvvb8yZPkfPExsKejr8DX0Vdo30hg+JoWGJ7NZWaJvWfzcAWI
			fOwsml76PkPIzQnnCxvOAVUzCFhhh3NkWJHE6Htn58D6whbi3mw+ls+rTMWHZxPCyqI3Rkebz0is
			ZoXzzdKfFOI6mWWk7zyd4vlVaYLh2nxS3kp334NP80es9xphD64Yvnejvru0ukWcFuRVMav+Kx2B
			NpK338jaA+azAwYPLC7p4ejzWrSZvs7TqYrZA5oX1lHsOKSdL+90S6BXXrSPG92t0QU36zweN1pe
			HbJDIug81Dykx5ub5Zm1b8U/rgUMOoPFFb4X4QvWNw7QnQDLC1/I3VgcGTwx4ZyMp0BTUwBeX9AL
			1tflUxRpTaVJVfGrIVjeocZ7iz2wang79A3L4Zn+tXSUMtF0R1OHuoG2wxLCqHI6AEgNhCPpxcBY
			JCBCy6FIOk0ARlvbPiaQincIOxuSMWdhaHFzuOTx+P2X8cRmg2/4gotSNnFq87c3fYGMd7mwc9PK
			f1oA3yNHkbsSvkjfl4C+x48K8JIFJpAeE9QtbXtBx2DT06dPfvObp149cfoEPB72cnSauA0UxrA2
			sBee6liOUA9eF5iK9AXugg8m8s9iGBkDzrNAVHKvefGNsJ0Fq4snaFiB0RReXhJBZmJ1nqLMQOA5
			vDqXzRK987NJcrYA3WQ+OyHC09GEjC/ns3AjXSA0JymmPKG6XqLvjEZc9LvZeRl4vhfw7WP43rUY
			vnejvrsNNBfA10hccYO0vCYfu98EYgSvWOulrR37Ve/roO/9hmA0cdewDqza3fOq+cV/DhmGPmAw
			u8VrwYhVO/0jvtqXDzgbv1S2jqObHbpjALrZroaZ9S+Nu6bV31XAN4aknZykZd5JdL5iyTc+cbll
			30Tc5p6cap+69tRT7e229g7/hHMqvq/7qfhUaqqpy+9ztbd3tAYCNnNwWUWvCaomEjaZvlbiizsE
			UYUX1mAvMW7YUwttIZ+0jHFuD6ECSiicDsNZJJRWQriyK74xEh0h/FI4Gf2xOFGURXxMmGwyhZ3b
			w+EXv/Vtg/4MvvCUzgpu/tYyznc18L0iA89nVedLxhe+jh4/cvwI4hcvAz8p6izoW4LAmbOvHD9x
			/IVXL148fRpXiQnf8gwN8PSxadr7sWm6BAg+m0P0npnFQPTs2WPTR44exVvA4+ZygNo5ZG9uNpfL
			IVhzc0jZLCA3lxH+FzeZAxM8N4dOGSk7l80Qp/F29L1wmheUzeQTSbxLJS5ewJ3B3UkywnSFsAr8
			BR88Ayb3KsWhZySHr85rdvieOV8jfPfoutdceyDE8L0brYfzNS7nGtZ8DeilC/sLALzfvNZbItas
			Y1ej7kGA6UFJ4gMmEh/SV4LFiQPPHAbsni9heBHG9nLoHTciV7W6xljzuBnBdv1MBpzVdKtmE4cL
			U69WAV9pczGlKp6YoEwrNMLJnj57X03S4piasO4bqtlr32qvGtq+xztR02B/+OF4cGdP254u594n
			mx+yB5RCU6c536Kgr9EEqwQV25UPObfoF3Tn22F4tB6Cpv22NMl/ZYCOa7iBcFoB5xuJpMNhJKvb
			7xUrvnK5FtELpxLJYQw6K0pACYQwphxKh0I2tMj+b337z1aqb3/7cx3rAF9J32l1xXearCoy8wiI
			TsnFTh89lgHyzJQ1v5nXYBvgNWx7BM9eIs/80vHvwAUMQKPBJr6/BuDNYeA5p2Vbge+dPnri+JFp
			SoPCpdtZpG4uP5dLzIr1W7xVLADnZnGtFxeIc2h04QJcI1BLozwXpQXfLKB1DiAKzjeffx0D0sjX
			vFj/zWaSSbqSkFflCq+ILCelwZ2RX/N0Fb9mNCts+jD+b/AGvPLn3/gunOW/J67OfA/O/gLu+8uZ
			73/jr34A9/35N+DkL77xxg/wEX9N960BvqOjo3tGGb4rlfHNNv6Y4Kf2V/jTgp8R/US+e0z8qP7b
			9/HH+gPDrQzf4mjyikLO+9U8Kj0CXc7xmlZ/hcc13OvQkGtCsIg2G7KwDpqArCdgCfLit0PPf1Zz
			qkSClQrd8VIXEbd2aXTHcX1XXerVSKwv9Rriz5ozNgSaxbed7K92g2DukB5wXjV8Cb3xCUy0UhmM
			BO61ZhLxvftqHPG41Z26tjMxZbfEJ+zX942mUlO7WmrsiVjT3tSeptS2hwJpb5kMqqZSC66Swgb6
			3jniXOB/mzqMJrtFc8AdEr8ll5yF6+3oGAuFlHQgBCyNLCJw02h8PTZ3iMLMIqwcpoznMFpjjETT
			+m44khYLurhejGfh0N+snL2gb5Wh76rCzqgrVy4dNSU7H1HBi74VLr1EoeOzaAnLOd+ZmbPoXYHT
			r1DEWThf8MAniMMUeT52TOXvWaQvYhcxO4uR6OkjJ06czmVoHThDmVQ5DEeD552dm81gLlV+Ac6A
			x7jMi5lVFLPW1oUBvXOYFp1Rk6GzWswaoZtP5LNnCLzwNZHMJqPCAuO/JIWe0c0ikOdnVG87r67+
			Yrw5I65ms2/SrfMZM3y//43vvvwDYutfzv6F+OTGD/fvy1MTfPHj/Ltv3D18ibaj1j2jO9n5rlhm
			+P7FN/5K/Jjwp/ZXAqx/NfMD+qOoEL7qrQzfAv3pITp7YvzgHQl80PC1/6BOWJ3CuvHdb3S2BTce
			QALTiYxIy2VevPG8xlvcxhB81gLQ2trvAYo6Y2LzIbvMarYTgEsUFYmrQ+OGkyERmjYlXKk+d1xf
			3JWb2g/JL/u43Y4n4ku7MES3w7kadB4ylButEr7RiYkkITeeIOOLoWdQ245YIrG3fXt/PGF1T13b
			Oxm316SmmqzbRmPxeI+jdtuUM77XPTo0UFszCEQqTrrq0C8VmF5z5FlfLr6zmqT9Ney+6XGTyX5c
			bFEWvh3twN6wEgmAi01jnnMkjT7Wc/myG12urDQi19tOtUJwP3pjkfUcGaMyIloxjgSUJTN770ji
			spHnlf+0rhy+AV+HKe9qWrIX6SucL3hYcKzIU9SZ2Xz5Zd/MzOz0UUpvpoxpxO8LJ05cBPSeoOCz
			yHkG24sVR2h7cal3FvOmgJxnc8cuHTl9fBrhOwNQxYTnPOIZL2cohowAxtVc4XQRvBiSXpil9d4z
			8IWcnc1S4RDlO8+KnOf8bCIPj8vCmUpbWVCkolh8aYVGMzIOTZfhjw010Iyp0ML1zmcnCrOd8aP6
			L7N/ToB9+fsafF/Jgxs+Nl0A3+PwQf5X+WNrdb6A3lGOPa9UZvjqPyb4qanwvfoG/Eheeq0Avtqt
			DF+jxg/96dMSuj/c/8wKIs7GCwfNS777C7lrulysA0bHq1tfZLCxDPggAVdPhTYsCWu2V4BWnh+S
			pwX8PaQnWA0ZV3nNF4QRNuCXbG+zRUaS1SyrUmpra0PSPmyKNw/djfONxgG+iYTIskpMJPAq4PfZ
			vdH5fXuDjp756GjK9SzAt7ltcmq7JTiyL5na22rvmbzauzc+3Gx/KIXx2JKerjCirFvcJs376ka4
			pB4vbX8NS8ZNLcDfDoRwi+GJYHebW9vR6HaMteM5fQFVA6EQIBeznH0BCjOnQ6502n9zwY35VMY6
			IjX3GTbB8HQa05/xXow8h4G+gUWj8f32t8UJrfDSyq+4akRyucDztpX+tBr7Ll05fIGE+KXiIElf
			LNE9foRs8FFVubya8Vxy1TeHy7lHyUEje19+4eKpVy++8MKJ00dF4dEl6XzPnr0EtD2rlvoiiXPH
			po/BJmcp3XlWEBmj0hkKKKN9zZCLzWByVYYYnJujSDMGm8nizs5lMGsqLzKgkxRMniMMg6HFW+mm
			ZFbDbJ4WfrPqKrCaYkXuPqPellTrjWS+VXb+6iSFn7NF8P3rH/wtOV+g6n975Xvf+97fwq0v/wXc
			/N8K4Ps9QPLL33tjbfAd3VXXU70XxdxdiQrh+91j3yPnS3yFn9afw88Irv/lD/6fBfDVbmX4GrXj
			mV2H5MUnHh4tS14tzLzfjNj9BWHnQuwaVoDVuxyCs/pqr6G296AGXRlxXqYFh87e8UOHTMQdV28Z
			L1jqVVFsTKwyplwZsq70oDMR2FKy9LfZVFSksva6AbtDhsurgG+QCnsTyQRoIpmYxJgzVhpt3dOw
			99pEvGrnXnvC2W6dnGrbu3NvzUSqc0/j3q5E0rK3YcSt7G25ut3iU5SQp4yn6yhrQZs6DHHnkuHp
			MvlSIudKNdftX2j6XNMXrjV94QtfaPpC0+Pazh/peLIJuAsAbuluV2+1tFAIeSyQBo8bHgt14Ipu
			IK34/Uu9Fl9IGYt0pNvB7janO+B+f9gW9neMPTE25k8DbvsjYJrHlBbw+SE0zoOBbxm4+nd/963a
			/w4nf/ftP/v7v//23/393/3d3/0PvPqtvzM448+tzfk2NvYdRfq+haLV36OXjkj2CvweIRSr7M0S
			l8pmPM8eFXnTZwV8j5+4+MLFV1898QJYX1wKBvqelSVNZ8+KRd2z6qovJTtjAjQt+QJiadUXb0C0
			ztJyrYg9gxE+l6GoM8D4i2cWEL9UEDx7LgdOF4ErnC8QOCoWeWmtl6LQ6FzxGbJqudFMNiE9bkYt
			KMIC4HnxMAFedb2X6Kst/hbAN//K2cxf0GIihpoJvvgBDtB96S8K4fsX//N7f3n1u3cP3z243tuz
			bUt15y6i76ime024+1hm+L5ydOY7f0trvq/9hQ7fv7z6t//ze39VCF/1VoavQW//6dP6qu7TT46X
			X/I9qEH4oJrobFzqLchwNqnouog2q5xFGjuMBDYv9h4sQV08ccjCIrtwvmq4+ZBa1Gso8xWINXTT
			GFLjy2qMeVxf3h0vWPAlWbQOVpRgVZTKrFIYL9c2l9Yq4OulcHMijgVH2OVqkjprxOPxWHwSIZyC
			q9jiaio+lXK6UnG6PhVLYAVw0DnpdDqBREp6BS00tAKgDnmlkMbFKdDl3a/moT/3rW997nOf+xZ+
			fetz6u6bWlp7t7f225vaN3d1tHa0o8D6dm5Xmtr6A9sHPG5buqu/P41FvIFAyON3O7Y3eZ4MW360
			vbV3m/vJFo/okgFSugP+jq72gMXudfe2uxaxC1YoreD6rwG+f/Y/vvV3//lbf/gtgC9w+O+//e1v
			fet/fOvv/zsyuFTc+drdrPk2AnyPTSN933kH8XtBZF8dOX4F0Csyr5C8Zy6dOUY1u+gJZ/SU5xLW
			9xJA9xj21TiC7D31wqmTL5785qsnRLmSyHIGxr4mgs5Y3EtZUgDfd9H/zoo6X+Ij4ReAKet1gbzo
			YrM/fvTR5957NEdpV2dnRxcexRRsBG3uDNpaNLgzsttGQo0q5/PJLDXYyJPTTeLlGRFYjlJVbyaj
			hpmJxzOUkiWJTZ01YJNkcn4+eRVLkebnS2Q7yzgzfGp/943vaVf/2/e/+8b/8YO/VeH7Fyp8//IH
			//P737gr+I6MAHutmyyWnVtbrj/2o+u3LDXb+2os19uaH7b/aMcu3QSPjlj3DO8Z3WPdg8Hp4dFh
			6zCwGb+E9uA1OIGNGodl7hYuJuNNQHPrcMMwUf5eM/OuJF4EviTxNwm8jD2Fa77yp/bXV/9WW/P9
			wTde/j9m/1yF7w9U+Kq3MnwNemI79t84dHA/2t8fbt9xoAC62gLv/gIvq17eb7xysASGC8irul7N
			ARd9aRwW6D1vAK7KYq3Y95CxqlfNuZLn40V1vod0EBfFnYc0QhvQq6c5a/DVDS/GmfWMZsMa7/XC
			GqOh1cJ3kztGQecElRdR+BkvYbEvtdaYSsWdqTjW+6aCKZcz5fM5nXA1Fp1yxidSKWCv06cEXKHI
			cuDV0GqKPpfH7UqF3hedL5AXTz/3uQ5pctuf7Ni+3eNo7vZ0DwF16db2jqb2dEtLwBHqfbIJTG+/
			K9AxhnVGgUjI7bV5WiJPuu3b23zuXv+P/EqTgK8/FHhCCTT1t/ssDsVub/IN/sn7YINDgXR60QTf
			vweTS1b329/6H3D57wG90vl+2+B8O4rIu3Ln2yjge/QSWN933iH+Xjh8+vDhE0eOfOXIf/3Jvwcb
			DM730j/85L8+9w8UkT47Y9m371lL+YznjBagfu2l46dPnTh18mvPfu35UycunhbtJoXvFc2uKN05
			N0spz/lZtdkktZ4SrR/zhF/qo5HFxlXSxPbk5+zUmyP32hnH3KMLX8pRRHoWS3XfowVfTMVCgM9q
			6Va5m+Rj89FsQiKW2mRmtF6SCbqYpzpfMMPZpJaMlckkZHcrEBD46lW8hJVIZeD7jb+a/3Mdvt/4
			6xlaWsTP7pe/8+ffffkHf4vUfYkYbNxB44o+CgG+I8N7dm6zd3Ztbrl+fcf1a52O/ms/7O3qv/bM
			U+e379xj5A/IunfP6E7rqBUvPzr6KJyri8O1DXusAKXGUasVLsApAhfuwy337tw7bKUd7Bl+IOmL
			fz7s3T26c/S90Uf3Plo7iu9A0Zqv/Km98X0DfDG7SsL3rzKYO/c9w60MX4MeGwfcHtwztP+ZJw/u
			P7D/MZPZNV85aMxvLmpdZU583l/M3YIeGwbnW0RddMIagA8WOd/zBwqLes8LkyvaSR7Sejir9b7m
			bOdDuhXW6KpmO9s1W2wg7zjBV6sgshdEk1X+DrXJm6+bDS/d+PYqnW8MOJtIJJJJBHBcwHdCNNmg
			DhtTk8GpeBBuSQV9Pl/KF0e3G0tFXcBjuDRB9PWFm+4oM2ILloLvROLHix8qm260aLvXQtdY7dve
			1NTaCq63o3Vze4d0vgEMOkeoYUZ7JB1Oj6Wx3leJuD1udyQ0Fmryb/d0+G0dtnQ75j3bIgGsRAor
			2Lcq7GtvVfxjg5FFH9B6UVGUwb8xZVv99z+TJb1U5Ptnf6au/xrXfNW3oqDpVfUKflCNAr5ofS+8
			RfQF/J46deHUiROn/+EnP/nJ17A6CKzsP/zk2Fd/TNlYr83WbLnZZtcyrIrhOwv++LWjIt3qxClk
			77Vnv3by1EXR8UrS9+ilY0ep1ChPbSbVaiNkcEYNClNzZ9EtMkOudSYmqnO3LuRr5pbyN3/641z+
			H+a+2Hb5q7e/uum96E8fzdifTWTn3ls6kxcudlb1r/m5RDKPTTRmVW8rmjzLYl/aijickUFmkWGV
			fz1J9yXngchUl4TrvfNSb86XhS9+nKulRt//xndn/1yF73dfmpl57c+/gfHmv4arBfBdCX0lfKuu
			2eue6bx23XLtmc29uyxP1Qy0/PGzQ52dzxjgOwzAsfbsrNpZVbXlvZ66R0d3Vb+3a7RqVHrZ0dG6
			TVus1trdjVW1VT01tVushFpMot5Su7t6556enT09W3bueTAj2XDYPdW74KXXVe/c2VPV01PbYy0H
			X/hbSS01+gH9bNQVgr8+O5P93jcMtzJ8DVR9+0d4at25f/uTwNNHfvhDPa/Z4Hz379dXe4uJeoeR
			CgV3Up3RAc30OgrDzcbezg660XFQS3pWxywcOK9hl9Kbf3rgp+PNh5rHb52/1Twu647Ghx6xPNk8
			dKDZ3jZ+6KeaE262bxn/4XizZXzoH9pujd8ClKorvONPtj15y/L2f/yh/ZGhW21DbeOb7BqCLbJ7
			1SPPPNn2yPbmuua2RyxDdW1/2vZjDDNveaTP/pPbOyRrC+DbJr7b2lYBX/dNgVxc8iUH7BQ1R/MP
			T05M7dhqiU9ZvKngVF9/x0TKkdrucTv6Pc7meEfUae+qmZ/c3t/i9PmUQaV87+aOgot6xpXJF8uA
			cdncq/JR6sflCvKdHhjGzGXRJjKM1bvUPQMhHPJ7QpRlJTo2A3ZtYTlJwU89KNPUjjLtieC0hfTY
			WGBQ8aWVhVVVGsmoczuAt8NmM7wpKwo7NzZqzlfA90Wg78l3Tp6E71P/+096foJjEVD/8MWzX/qx
			HL0A8K2xULpVmVrfnBinAN/YGfrk1661P/vsyVO47Hvk+CVqs3Hslenps6LSNydTrkT+MiU2G4Sl
			RBlAKAaghRVGNFdlZh7teS/36HNfzOVuf+n52erc7dhCT7W96sc/vfnss7VLdtHgmeiKvjeZS+YS
			SewCLQqF88m87GmVUbOa5zN6zhViF1d/qVcW3UThZ7XDFQkIfDUxv85NNhpXQl+AL6Jl97b+XX2W
			bT+yPPvMtYGdfdf+eKD/kWtba57dYci9Apbu3NZVY6/r731uYNvWur1bt16317apMN1TPTBwbede
			x3Nt3fa2a83btm7aiZlb4HQdz3Vt2VfX6xhwPLu1Zu/eBxO+7zkcA/a6Nge8xt7OumuOXse29f1x
			VRqCUvcNfMebMcH5wM4fXif4Dv3wR3ojKz2MXGh1CxtrHLxTWnOhjLONDLA1rv0WFPuac6wMzleg
			9nce3rRj3GK5fuAftjx8niLP58cPHeipf9K+45Hx6p8ecvxEt8DPPLzrmbqvPnNr/B/qbj1TV/1I
			nRZ67hsav/XjJ/7AvumRQz27r9ubtwwZws6qrX1iqMa+3fKjuhpLm+X2k0M/3VHT07zrkR/V/OR2
			nyHsrHK3zZAKvRrnG4wnRLQZLW9yHld/wQIn9s1vnoo/E5/smtoc3B4P/qjJOznVee0Rr8unuJyW
			eFM8ZplomnTWtHx90hcIKC73nacR6elVeqmu8YYSmVePl7ncoedjPf64ePDjEuDt+ibtxisdY1gy
			RH00sK1GGgcRYYONkOLxiObOYclfW6tgMNwK7MVlYaxKioQ8cC3tC1GOtDLoC6TL1vmWvP1bX8NK
			J9tYGE7DY6023f7e+acl2NvQd/QSZVwBeF98Efj74otfe/755wG+X31LpllNf/UnZ3/yD8cEfb96
			7doX28o735mZ2bNieRisr4AvWN93T4luk2IXr1F/ybM5ijxjSlVejlSgMQtqzFks/grvi6ZUdn3O
			5n+czT4695PL/3D5TO7MH148PveV2/lYT9Q+1/ZoNlkV3brlxxijxkD0nFjmJc3Ktd98fj6fSCbz
			83rKs26GMwk1ByurZjvnkwkNwjp8k/OfwmCFxpXQVyRc7dmzqbmnamd1Tc+W6raa0b3VNTXX91p6
			Ri2jBuM7umfvXss2y75r1+re++K1az211/r7mhvs6iLu6K5rLdt27+1uaba31G3dVfPFLXtxwXh0
			eGevtarG0tu9c3dPr71t54OZSr3H+lxV28CWIce+rp01X6zZWvPc3i6G792obNj5T9HqHnxs//W+
			JzEI/YQhv0rtJVkwqajU0m7Z1KqS3NV6bKikLcy4cmgw1qB7SG0uaVzqtasVvYduH+h75InxtusH
			LABOddX3SfsPn9zyyPZn6q4/MX5bS7n6j8888sQzP7SMPzb+1epHbtU988gjWtLV0MOPjG957E/H
			H37iyZ7HdjzTdl2dn9A8ZJEEfaTHsmXXk5tq2pofeaJ5U9XDP6ppHtr0o5pHfvRMTdUjRWu+AN82
			3f2uYs3XczOYjCaSyNskNthI0FyFeKKneXtysmbC3Z6KO9pTU09OTE7FWrtq/d6U4vQ9Oelwxoda
			LFMTluybTpcv4Ft0+e8ceNabYei01ZpsmK8XBJ1LOtkWLWW6kNntJbYei4BrFW2s0otYKpSmZKtQ
			mghsg5ttoqUkueNWoKSfhh6h65XTEmxYdpQWAFeUQMi2ig5Xf/btv/HLzlntwPdw2OB+7/jTkuxt
			6Lt0RWQ7o/NF9r74LA4meuut09Rcg3Rp+pJoezU9naNmUJhzlS3T4RkDz9OnKdv5hVOnTsLO/hGc
			7/Hjcrbg0WMy7+oMOl8UplxRp2bKWTZbX9F8SgBYeOEvxjMzSdjuua/kjn7hJ6dOnnnxS1+5VvOl
			WFviS/n8c/mtmQU0rcksDWGgYQzJ3FwCzK7o/pxPAnqpp4bIpkI/bagyEpVGeDIjsrzI9+blneR6
			EzT3aP17OzeuhL4qfIGse0ZH91Ka1HvWPTtFxrMpRrxndO9uR1fb0CZHl2Or4/beOsfW7QM1Wy1W
			sc2e6ua9Xc3NXQNbewbqnqtygDWWztcOm9u39jq2bulqqwGC32uQ3hV8R+32Lstzz8Fr2fncgGXr
			lq32AYbv3ahsb+d+zLc68ND+/XueBHT2jd/S0GvgbjnEFhQdlWrzbDbHBRi+w5fIrjpkRK/aU8Mh
			+aqC9jzeMQ52l9pwHJJDBMXC73n8d15vtKH3nzQu95rGGukpz3JIYLNFW8ClCDKW9La1FUWXhWpN
			N7YJ/9u2urDzZe9EYi46MRGNT0RTsXg0LlKuvGCDJ7s72yemUh3xVKqrsyXl8wS7vD6nz6Uo3e0u
			V3v8qXiqpbvF6fOAfXQNhlc0iNdc5aumPRsLd5tWRN7CAPQdBRylybsRpG5oUaFAcoDGI/jpSxQX
			2cZax8j5hv1jWFyEBb6BAM418sD9nnQ6IgCtYCza8zem3s5l9Wff/ta3bDQuOCwj22La4ErXfCV7
			G/quHD58QS75In3fefF58KrPPg/APE0tJo/qVb5Iz7PI1zlCb5l6oxw12pjGRd8XTp385teeP3nx
			hdNyyRepi2evTeeOTaPvnctRNa+IO2fVoUaq9aXyoFkqx5UDenEWLyZh5eFxV06dunjq3VxuLke9
			NHBXedGHEicOSnQDdRMYaM6LjCukb14MPdImHellvmob5+xVaYjFdEKisGhvJbpgiXznewbfYbWr
			xp5R627MYd5D+bzDuB6s8wcTpkQl0u3R90aRz3seslprZQaVde/OvVV7pXbu3b0TcL5HPG4XbLxz
			D35V7X5Qw84gfFl7927ae33nzt17d+7ay/C9CzWWhe8jP/pTynY+eAi86J/eekyWEu039tUoXOFd
			icctG4YWceYDpuyqwiwr1f4aJvrKKQoFMWcsM1JTnMWco3GZZ6VWHx0y5VrJVhyHxk0lSHppr3GK
			oGp6BXItev5ym4GoRsq+La8NibDz2/pqb7Ng9Srg67l8eSExR343FgumUkGALvjg+cmJqSkabJSK
			x1KplA++gh4bsNfl83kUZ8D1piuYmnC6nM64y+2P+AZdg6GVel/zHCR1AVh1sMuBtAjEhnLhO7CX
			elQBa0OLwN/AIk7rTYeombPoq4HgDav0bbVRxw3cHP0xdpOEy36/H7tNkn0NpH2KbzAQ8rfCxnhC
			c4zw/Kbn8k240qrJBt9jYvCgDG3D01AbrfaVOd9GDb6EXo296H2fR+v74slTFw4fPy76Ox9Ri45o
			NFEuM5cXQwVLZzwfE7MEj58+jdb35DdPvvrCCydwtsIxan51SeRu5c6eyYmsqzOAUow509xezfUS
			H2dpCi9dkIW9IkNqNpc/e/Y47vscuWcs9QUCwwWaCCxHFFGyVT6Rm0PewgntbiKfiOazWoONTEbL
			vpIDjKh5JM36lWjOUF40DhSUC74yBP0pwPdO9DU02dgjyohEwRC1uhoxwZfKazBzee/oo+8BfWXK
			s3VUTbgCYFtFIY51dOcoVeUI0wieee9eWaMz+mDWGlG2896972E8YOfOvdiJ07r2H9EGhG/JsPN/
			otNDz2hcPnj9SY26ppxmHcIFq7+F1veOS7/njc00CjOcTeu/RfMU1AFG2lrvuEOc21Xc6snPequr
			cQN9C5pfFc80KhqhoA0JHNLgK00v+l6z821WkVtQ59um+uTVwHch5V2IRSnjKhnzuIML6IDjE3KY
			4JQrFnNOuaYAyt6g4vG7Eb5etxLw+d50Ol1xZzzudLkCacWnKIqv486jazUIdxjaShpHDRa0mmyX
			MeT2slS9s+nFfcrRvKBwIIwB6FCaBiSIxd5IxA8shG8/Bp1bW8mb+v2RAI4/SisAX3hcOu3H0iPs
			kRWSvKZLNP0oJMAaHpP/0D23jqleN0zslbZXHVqIN68Ivhp7G/rekuhV9SLS92vPv3gS6Xv4yJUj
			ssnGkUuXXjlKjSPBq747K0cslKHvEdlj49QLx1999ZR0vvBQePjpi8enj16ans7lztDEItTZ/Kyc
			sZCdNfjeWQoKY7FvlhZtKYF5VnO+r108efL4a7ncu3N5mv27QO04qK0GFfrSGIb8bFK1vtT9iuLO
			ebXEKGNwu3rCFaVXJSa0EUh4T3ICgXsVS32vClCvM3wbVkJfFb57wOU2ViEaq0at1t2jVTvfaxw1
			O19E8egIkHXPMFYZvffe7tHaEQwrS8aOjD46ggwewWj1CFyFfQqoYxjbah3B+DRsPLJa8N0PwlAA
			Avi994bhL49H8WWMrv1HxPA1pjs/UnPoSWF1Dw3teOSWubq3HEpLdNQoM1GwhPNFh3ugGLfmFV+1
			nldLc5boPW+YoqBDl+zuef2ascPVoXHzRSN6jfMSxk3k1SLO9NVG2c4FQC2MNqv4bXvEdEebFqVe
			TYerhQVvLArOdx7w63W7vUF3PDkh6AvGN+ZKxQDCLjC/Lp/f7/WB8VWUgDsAFAbsuibB+Lrc6bSC
			wwp8K4SvibNNaqqycVG4lNN9vL0kWDsMWVvFaqFWz+0ES3C8ixhnpsFENCFBFPNSRw2EL4IXl3op
			ruynfCzcktgLJA74I36KVGOPydDYmBhCiOilFeEwjgAWrSn1DtHYUGssLAk8Jp4E3fWYzO6iIqiV
			wLehAL4viu8Xpd5568Kpw6evYNeNS5dw5RdOCb5n5jJHb2TKz/WdmcVoNaY7H8d131dPnTh+4vhL
			2GMD+Hv81KuvnsbF47OYcpWTvjVH4eXZTGG+s+x1QcnLs2IZV8w2wodNv3b83ddycxh2zoglXWpF
			maTC4Fk5wih5Jpkk3hLBEyLsnKQmG3m1z1VmPq/aW2qpIaLKWHGcz2h9JmnNFxttJK+i9b06ud7w
			bVgRfEX+0yiAtaautm7XbnttXU1NVVttXQ9mW5ngi+hFAiN5Hh15dPTRR0eH1VVhvBPueXREXBgh
			lzsiubUTuTVixYePjjyg8N2DK+JA3fe0AmeG792oNHyF91U7Ov/w1tOGbhoFGVb7i2p3jVeLO22U
			cLznTe2b9bwqU7qVo9D4GgPPRv6O62FnlcTj58UCr2HMgskAa87X0GVSZ+244cRAXhF4xoSrIYO7
			LbC9b5vwq2U7t0nbK1eIVwHfmx4wuwDbKBjfYNDtdgeD0YkkjjYCpZDAcDIF1tfnc4Pz9fo8PsUd
			cPsCCF5nLOWadA1GIp4AmMB0YCVJV8a136aCTKsmrRWWWe0GCj9ewGTzti1NLQK4xrh0O9UVhXGN
			F4f14niiMA4qag/TyEBa9EUDi9FgvAlHB4bFrEFgL673AjMx9xmIjGY3hMhNKzSPEMcTilGEkRC1
			j1b97ZgYkCStr+yXRSMLRb1TWDAZHfJK4Vvf947B9774jmTv8wjfdwC/2PMK4XsJ2PvKpWmaezQ3
			l5s9fK5cg2e8/ey0nEp4+uKJiyeOUrrVEZHrfPGFV0+dmn5NoBczrs4SfTNyWIJgrs7e2bxkLppe
			1fnmKcKM3jc3PUfZ0vm52blZDF7DBdhmjtK08jRYIZkTvndO5E7h5WQ2mchkE9TvCp9mRlQdJfJi
			uTdL8WWi8gwFpZMIYpntjD2uZNx5fT/NG1cG32ENvpaexrrdPZaeLTVtozWjVW0IX2O2M1lfDDbj
			BWDv6AgQGMPRks1IV8FXZDRhmkArYtjaHQ8ufdHlDz86/B529YIX87cM37vQMlONDjx58IfYVfKJ
			/U+Om2cmlPKy+80rv8X3GoFrsrvmXKpyK756qpVxlpFIeD5kDDo7dOYKFDsOmXywhtsCA2xcATZ0
			mDR2c242tm6WGB3Sw81FuqWd4aVbFm2lV10ibhNLxKtZ8/W4Pe6FaCIajU/EvF6fL+iNBaPxOFzH
			fzE4TU1ha6ug12bz+92+Vq877XX7FJ/P9abLpfhcTmcwFPKgQ4z4fO1kfq81fXFlAC5ww8ukXS0X
			U1Yj2bgDOIAOfb+0BU1HQPaGRPwYZyuEaE4gMTNio15W6Ej9dO5BaxvCHCwPhqbDAQS13+/HNV+P
			PyAyoEV1Ukhco+IlEXdGaEu6RkJqqDmsxprFEvNYWCNwOAxHuPxPSze+AN93tDznF9+5rPleoi/C
			F5wvsheN76Uzx85iydGZ3OylK0fL5jtjte8RHCp4+viJ06ePnyYHfOSoGLhwGozv8WnMeFazncG5
			5kS8mbpSiYgzec7ZWdX40tBAAjHiF4cNTucMEpMDz+XlFF/a7EwM9kaozdOaL1UczcmEqyytWVNn
			SX3SghqBJoObkcN8s2oYWmQ7J5NyvAJceWE9P8w/37AS60tNNkijo1Wjj26prh+tte7ugctVPaMj
			rOX0+fWk7+crDUGpewzfg6WuHTR/aSwtMRqhBHf3FywAa/w9ICB8x9RmNRPL6HwPaV0l5ZLveROB
			qauzXutL1+3aUF+tz9V4iU6TQ1qy89DQUNHIhKKV3LZmc8PIt5tXJrXOaNXwdV92+93R6ERiIhpL
			xbzu2EJwKTZBU32jqWh0KhaLpoKpFFhfj9/f6vcH/V63O+BR3CnF53S63D5fAs48wLVQKKQMulyD
			vrRfo9+1O+JXm8trTMJa6YxBA347qHoWA8Vq+ZHK77GQYG8kkkZ/HhL9NQIhYViRg0hdiUKKNkfG
			ImmKTkciASWCi8RhGzzOA9aX4Bui1eKQkg5RvRIFnWl78Tw49mgMn87gcNXvUGRM/C0AfwSIZ2xf
			MXzrEb4vSvK+ePlFI3sx8PwWzjrCmPMrR4+eu3QGRwJOU6D37JV3cyVSrjKa9z1Kk4BRJ4i84Hyp
			r/PR06dPHT96CeF7TPje2TM52WFjNmuIOIt0q1lRojsrv/LiBOCLlcK53Jk5sOGJnDqyNyNC1LIx
			BkWe4QS9rygYohYbYnnXlOVMnTZEKrOY3TufjAnKwiWNzeR8J+evEnyvEqKz6oM0cievTqqK47+J
			ycmJq/OTTrxhYlKcwvnVJPxDI03P3Vdf37B7dfClQDFaWxkxpggxaxkNr9ueVvxRuP66R/A1NKwq
			XPo1lfSq11Tm7i8N3OWoLO8jpu43wdcUc3aU88OFphecsAg8G/l7QOXuuNH3OsyNnY0Dj7QMq3Fz
			oNmgcRW/bSVxOrRS7JZIyFoxfBv7gh4vEDeOs3yj0WDMHbscW1ig+b6A3hQ4YECyD/tKBj02P1pf
			j9ureNyKB0yyaxLTr3C6AtbLpt2AJCfQd9C30sXfQhespy2vsM0VEXaMAEv9qtCEhjuajO2zxkQ+
			MyA1jVVGgQB218BoMmU5hyIivjyGt0XC5IZxXyLmHAG+tuJu09TO2WMDTAvPKyBLLpdwSk+SVgRW
			tQTqsbAegw4Low1XqE0HzSxEJzzW3r5y+JpoKzlsM8EXc5cvkfN9TThfMKuzZ869m5lZZr7R9JGj
			x1+hYUZqvRI2t4KHwy2XwDxPv3Ys99pZzbuqmc5ZY6GRnBVInapErjP5YHDEZ6+cvnKUPDP9m8PF
			XKw3mhX50bKxRgaMbj6KxJ2jeUYz2Qz1t9Ire42SA3tlG2eC6oy8PZHERGg5WWFeZTTaYDF2gSYP
			aoHp+WTiajI5OZkA0jpxnPXUhFMgdxJuhvveTOLCsSYB31U63xGJWwTwqCQxqzLaYPAtbNZcbH8L
			FntLdWouWOItMMjL5TqrS70FLth8xWEoMioYG6hVG5l7OhtSrOw6f1XHe8i81mscbKSHmw3tnLUM
			5xXgVbjfW+Usr9ZfQ79pNc7Xe9NLi74JBK37cirodeM0o/hELAa2N+ai7ym82YPO1+12K0oAo86x
			BI5ViHl8E5NOny+NNjAQdjoHBxW407aqxV8tAF02cUo0q1K/9XSqpvYwYZeIJ7KX4WRMjUN3dIRl
			ORGmRlGrKnStkVBACYlUqZBYiEUYY8iZypH8EbFT+BfABeEwIhvucPvDfj+53jDhd4yG+0ZECZG4
			gJ43bFz31cPOlI4lJgRHZDNLsspjY8v+tAzsBfiaIs2X8Z8adRZhZwlfcL6XiJ5z03O56eTsu+++
			myku99Wu5KfRMB/Bhd/jVCF8BH3va9Qo69I0ZlxpYecccnM2I42vhl9hdaX3FRFoGryAK7lHT506
			dYwytXLJXH6OwCs1p/ayoku5vKzwBYOZXEDvO58HnJrxOzGBJnhedb8qeg1QFmVJanfJqyLsfJVM
			MDL9qhqaxmytqxPCMmfnjbpacIM6l5DKmxC+9SuhrxG+KnfhdM/IntE99xpJG0cbDL77C1o1G8qG
			DLN5NfAWTTEqML7Fja4MtxTPEDygtZQsEYN2SA9s8L2iqreQwCbfq4NYx65a+Gtc8T1kCjqLAUaG
			5GZzWa8YzKtND9RGFqnDE8oEnd8uvHVNztfaF3R7vUvBeJJGK4ANXrrsdtOM3/hUFF0vRp5TLnC/
			Xq/HBvD12Nwunw0Z7PY5406ny6vgqAVXAJX2OV3pCHhjr7uYstfay/PXvOqrGt92wVyaS9Re0CyS
			7hdLqyREYlou7YZV+KLvFRugk1UCaHsJz7h5WJxjg0lFSSN5KcfZD+zGNV+0pYFAxO+XKViwKTlf
			MrzhkLC76TQ1yJLeWrhdQVbMt4poSc4Rmugg2C7R20rPR5usDL4G5wtm1y/NrzihMQsI30vU5Aqc
			7znpfNFrJjJn3n13YaZ8znPmGI1YwLwr8S36WuHjsdvGa0exxVVOJDyfPYMLunKqAo0UVIPMNMkX
			c6eo+SQRmJZ8j5x69dRFdcGYmmxQo42caLExp7JYzFbIyWXerCg/yotAcj6hDS4ysVgt9k2qXTW0
			eLQ22gg2UW+kKQzz4HvnJ/CmyflsUuPrm2h/VV29Gp+cvzpvlkpggO/KrK+hznd4D00MxHqgYTE1
			kFUhbSz4HjREmEUo2XRT6RwrY81vMXkLb73zIF+yusbGzgcKLhjG+B7QhwaqzTXOG6uNjGVFkr92
			wxQjo9U9ZAg5GyYZGd2vwfcaUq6a1aull3r1621FCdAFHThW6Xy93ss3by7FJhKTE4lEdMHr8bs9
			XoxCT0TB+aZiU1MYf47FwPm6/a02v9+vKOCBFbfb63I5cbnXq8DZoE/BXlA+XwAMoifkdusLvvKs
			o7VVJ+21shQ2OF+aRiTB2/64OGsXNxJXw5GIGualfyHRCwMgPKYaX4QbplgJ6xsQLhh5S15ZRJ7x
			ItUAp0OEzoh/DFkuF349FM2GvytEnJo6Top+HdSEAx+Fi75y9ZjIK77UcqMxuXosY9/05GOilnhM
			FDXdGb7S+Naaws4v4rKvKiAvzfe9dPQ1ke187tKZHMDzDCo3m/ngxgfnTIHnfBF9sdnVUVwzxioj
			DDznMPYMTH6FWCxqfEXysmxlZVj0zash5Ky2QovWl2p8j5569eJFBC+AFf7Ey+G/HC3ozlJWc35W
			ut9cVkxSmM9r+8sWRZ3lMvCMzl+D86W4sEi9mjc+aD5JML2KCVsiYi2/s6rFTWJudPKqCDEnVfJO
			UqxaN74Udq41WN9l/29ZC0HwQOYiP+DaePDVVnaLsqv2l+BrWbbuL76433jLcqvAqgM+qBUcmRZ8
			zeFmQ6GR7CBZMuJs4HCp5CqD6x2Sg3uHxguWescL8auXGmm2V4tFDxUGnNu07zb9SjF/VwHfJcCt
			PxYF8s5jjpXb4wH8xrDDRjSG2c5TeCtQOBgMevw2zPhVEMNuv8cTdwF+XT4PJjy7lICC/ZIjaXcA
			Mew2Vh3Z/K1NwLKxpvamds/yMeiCSLPgrWZ82zt0BxymRdq0jDkTS9OENjSzYmftND0wFBLEI1cM
			26RpEVdkVIVF/a9qQTEDGv+RUyXAhrG8CLEtEpzxSdMiVwrj2GEKV4tnUBd6x9q1JpIi4BwRS8kU
			eo6IVWY/dvJoVW17eEXwbdDha/ub1hefR+9L2KXJvpTpjGW+Yr330pkr5y6hU0X2RnP5zLkPlj44
			Y3S+uTnzsu8xNLhHj0xTwyuZbgX8naaBg1eOTp+lqUZnRaUv1u7OUrZzVqJXI2VGzPQVS75nqaHG
			9MVTFy+JByZobhHxV/SNxLh0QqwCCwQTlYsWerWRCuodyYRqZefpLpHiPK8Rd0bNuZJ4vSpSn2mD
			JFUnCbyKdWHaKDkvS4OT6uquytykuiPCOMJXs77L/t+SPalY91IbD77mrGbV+uqcLZ5QVBRKLlNW
			VOYWo+PVzO1Bjb8HddNbnGalD1I4oHWWPF8YfZaDFezaRT3HWTO6BRnO48VtrEo532Y1Aq3HnEvl
			W7WptlYtKGordLxva1dWAd8YDrO9GcNF3vnERBSwCs4XO15NYKVRfGoqhkW+KUx59oIptrk9iuLB
			mLMfoOuKulwxD9EXkBtQvIBuj1vxBdIhrx5k7gDf2ITeEfsr+1w+pf3O6NXIC6djHe1/ghf/hM7x
			KlwLC/8awfQl8rsYAxY518DWMao4GovQMm9IZmNFhOMVPhkfiXVEwj6LBVkRT0Y2+ikqjS2dseek
			eBhdpcLftFxEpuVjkaml9Y7UOkjK0LO4Q0BYhL9xW5ut1SZhDNeX+2k1mpzvO/qi7/N/41ejzVTf
			e+nSkSNHLr1y6QyiF5zvOeQdkDcaWzgH9F26+cFSImOgr9n6zuTFJKSjR2ml99jZs0Des8fO4sjB
			iydPXpwWQ41wyXdWlhKJVhc0xJdqhhCQeUMDyFnZCQtLjeDhxOyE+k8WHFGgeQ6ITKZZNGcWOc6z
			eRW1GQFTLPGd0Qis0vgqHjtOVtCHCMrosygD1pOyKPkZ5/8KyiJiJycMi7xIVxGINnrd+WxSpbO8
			PmmC73L0Bfju5a97/LXh4HvQFGI22mBToLmIpqsYFXiHbQ+YsFsQfDbj95Dp3yEDf43FvHrYmRZ7
			xwtXd7U487hpiVfNcR5fjr6a59XhWyoVq00ftCAXeiV/DRRuW+Wab2NfPHrZ47kZw97O8Wh0we31
			BoHFcexxhYN9kb1TYHtTvimAr98/BnD1+jHTGRjtiikAYGzMgUVHHjf24UD4gkKKsLjIWT+AWQkF
			AoHB98ErL7rSvuWdr+ZwMY1ZnAjiau63vQNXdsOUJSXcIyVBURUQumGkZFMH3pcmQsKWWK6Llb7U
			VIOgSe0lBXNlShSV+Y5R9nKayoLD2FdDdNqAPSg0ijCAFUviWQPC8yoRkTQdNsSbJYG1PpK07gtb
			B/CJcOnYZhM9N+605ivhW4/Gt7ZPa2ll+xubWt17mKp7aTLgpUtXAL/nKOx85Uwud2zuTCy2sLCQ
			yGUWlkBZY7lvwQJwHjtpTKPtfe2YcL7A3ivA4dOnXj11Gp1vThC0Jn87dvnHiefiW38c1UPPc5e/
			lN+Xjw1cnktsy2/bOpd/Lhn90tln1Q4b+fyzl+defy56eVt8bin//IQYmIBh52ejX9p3Zu6LcwNz
			2WevzUVvZpNq3LlzIXF5W3ZrdiIWy9qz22KJzoR0wfgy6F9mJqvONxLZVjJTCjiaJI9Ll5P0La1u
			lsibTEwkKdKs4deUviWzp2VIW+5TPkVfbe1K4VvLuufaaPDdb2pVpVX4lootGzi83/CY5cuKlnO9
			B1Xna7zNSN3yzleNQBcEnmVdr9rjatzU0mp83K4t8JorikoUF5Vgr07fAvwaYaq7XdX0qgxuLqTv
			qp3v6wtLN6Mx/DCaTMTj8djNJW/w5kIUSxyRvlPA4Ukcr5BK+YI4LsAD1hjhm1CAtS7FrcC31x2f
			hDPwzO4g4FfxhBSf4qbFXSz59Q0ODr4P/94fdMHXYCDtvrPzlQge69C5O6Yu+Y7RaF4ceEA5yGkR
			RKYAsHCkiNVI+5i0ugERbg4QmkPYmCpNq8MYMxZmVGIwIpszU3AYXXMaXTDtLkCYFxW+wNxARK43
			RyJa0Fl01dDhG6KyJbW/lWi6QdFsxG4kFJYrwOE7rPkanC/C90Wtp5Wa40y1vcBIsq3Y2eoKfIHx
			Jec7dyaK8AXrm1+4AReyOnEzhdlXZ3O0tItLva8dO3sJ2Xt2OkczF1795tGzNFfhbP7sbM1Xfqcm
			t5Cwf+krP96q97i6lplLXs5Hv/JsMv+lZ7+49Vr+2efPfGnuCzkaooDw/crWuWe3fSkTWzpzM39Z
			JFnR8F97cuByLLltbuBa9tkv5bfO0bovGeCF7LVMfOIy5gLGFvI3MzOdWb2sWJJQDTkTKhPJ+aRm
			f9W4sxo4Tkrri8vOMrSMRURJkQgt7qMzGbzWYCvd9Lxa2yTgW78S+O7exV/3+mujwVdvpqENTNDS
			nvffiaArVoG3PVDi/pK3SfQWLfvqX3hTQZcNidtStUR6epVeTGRqqzFenr7Nzc1m22tqvKH1urpV
			st9Vc9GwwbvIdo4vxWKxiSRO9AX3OxHzXt53+fK+VBzDzhPU5Wpy0gkQBvqmsNLX5g8AfIG+MZ8L
			bK/idvncLo/L6Rp0K+R7vR6flxaGwe6GI0qg6XHX4qDz/ffBHONWfnfQr0SMmVilACxTqsR3uwCv
			aoX/BMuHxKQ/cq9imVes6ooItDYwAW0wMhnQq6gLs2lhe5GlaRm6VmBHfmoxOYajdm1jYHdtfgw5
			Y+4VNbEKULA6je2xkN0KOW01fUst68UMLm2pVx2hoDaTHFPTruQkJeGFIysJO6tRZ3K+hW2tDl+6
			JNZosSwIuHsOvuD83Lkz2JEZ4xnS+gKFowuZ8k2esxRXhv28RpnOZ8XV3LGjp06eOoXzkc7OzsK/
			3Fdnq7+YeS6x8KWtP8ZZwSLnOb+QvZn54lziS1/MJ6Nf/OJz2cTzXzr3Xy994ZWcWMidzV/el8xc
			u5m9llx4Nn8zn5XszeS3ZhyXs/lr+a9ksje3Jma2ZuF3keLR2WvZm8l92ZsDyUS+N//stplMr74I
			rI1UmBEonhGUTErKSmACjCeMWVXzasiZBBSeVHGdNNxNxjkOj8coNOVFw26TWpIWwXcli7591l2s
			e64NBd+DB7WQs7Fh8/6iRdyigl5zTlUJOhtZemDoQKmbS0JaIvegPrq3sKGkOlKhaKZRUbdIraro
			kGGtV3O+yzhcw7Vmo+M1YHdIDTerc40MkDVeRBa/XVBidMuYE70K+E4sXI6C5hJofoG4Ny+7F24G
			o2B2oxPxWDQuBywQfd1+j99vUxR3MOp2K15svTHpcw763Daf0+nzgSUGW7yEi8hejyfkC3gDg4uu
			UMTlcgF633e63h/0KQHYBwC7fN5VR9EIo8IKozFqlbEonWxAzEhIU7KzzHYOiPaPEZlcnA5hLREF
			h2mlN034GwsTh8M0tCgdolH3rWPY7co/5hvzK34bHKoIarvTYsU47ReFRdTcSqzyhkOigRbxNaTC
			1zC0N6wnPqutnUV1L10jlq8Gvgb64mWEL7WCJPgePXIEjS8633cBvkBPqt5G64v0jUUXYqZos5nE
			szkxQOHsWfw+Oi2uTk+/cvw0PMXZ2RywFyh6ZjaTwwXePLVTFs4XK4/Ekm0SsZnAvKvZ3IWLp06+
			e1bkPOMScX6GcqqySTnLSAz/y2cSlOucoS6V+QSxF+0v3pCX85jySFltuEJWDzZrRUZZ0UdDBajm
			fOXarZo0lZwX2E0ieZPzk5OY4ZyUCVlaEFqu70pHTZ5XLzVi+D5I2mDwPSgTnvcbna+pQUapFd/l
			rPD5g8YZgajxcbPz1fpqlISvMdysB50PmpzvodL01Ub1FlQTGQYFyjXfIUOOlQwjawu4zc0FFBYW
			V9K32XSmWt+2gibPBSwubq6hVyWtAr5gbcETwUf0BHwGAXyDN/ct3Qziii/NFoS742JyIDpfvycA
			8KXgst/r97mBuZMuZxyY63I6vRh29nqDXi9s5wsoPl8al4QHlUGny0nG16eEfC6bx6+ABVbulPJs
			miRoSnaOBLBPpNblEaEbIGuaFulW4IlpZkI6PJYWlbwBJT2WFjVGITHEFyuJwsLMUqXRmI3AKxpN
			grsfS4PpbW31R0RilwR8eiwsoswBWi5GfxsaoyXgMQohq02bx4jDIXWYwpjR/qoAVscxgJteGXxr
			BXxFc2f57y2CL8Wcp6m+l6YKAn6vLFyh4bkJjGAsnIudyc3OAXyXLs/pxC0ywbOUVHVs9uy70xhi
			PjuNzle02jh29szsGXC+VEBEpETuYvAa05txGTafkc0gsQYYqAkov3j66PFpgHAuL9Ofic74ldSi
			ztS/OYlJWBnKc55LyKZWgFvaXz5D5zgtYUaiV9jeGbWoKKEu1wJViZ95DZ8yj1nGnZPJqYRqfa8K
			80umlq5c1QuM5qXJnZF9tNTrmH51FeFby/B9YLTB4KtRVx/RW8DXEslWBi9czr7qc4oOjRvqdQ8a
			8qv0swLQFvK2cMn3kLHWyDg4YbygdUaJzs3j5imBBcu2Knib9WyqIa2wSM9sLtHmGQH7dsnJCvoq
			79vNpVpxrAK+c/GFpZuXl3DJFzxHIhENLnmDUbiojlaYmkLbOzXlC6ZsrbaA368E3Lj66/b7kK3g
			eGMI2zedlG0F5MW1X7/Ho7gUxTcIfncQUPs+dn12wiMVH1YKDw76ArY7wLek8cVl4DDNt6eqH4w8
			p9WeGcBchUqCcIDCWAgnF0WwsGiMYI01RgHMBKP0aFErFI7IELXoSRUe89hstlaAsMeTbk17wn6b
			WgYcwXqjNDzYRr0lEb7YMUst7w3Lob1iL7LJRkTLv2rXcrDCxpEKBH/YIr3MT0td8q1X4fuinGb0
			jiw0wrAzNaISAxWOYJNIML/v3nj3HBjXJDrfhQu06ptZWIjBjzqZyZZxvjMZACUlVlHU+RI63+nc
			GZl7BVdmz+ZmsXwon5mlkQozxu7Os1qTK9EyEiB96eKpU5dEbVJONnQm6uIAhRxlN9McQsAtdnzW
			Hi2SseYNzZzF1CSa5TA/L2YJ4uq1tuArEKkWExF+RVlQUl2vlVlVaHIT5HxV83tVYjWpLupmtYKl
			N5Oqx1bXfMlQS/jeedGX4Xs/aAPBt7FP2Fy9nYY5kdm06mukcnnje/6gniklcIoNmNVIcomAtOGi
			Eb8F7ZwNHP7dgjojQ5qzsZyoLICHtIG9QyVmJRhWdptLkbm5bJNJ83rvrTbTDc3LaDXwnVhYuOmN
			gesV8J2ILQSDqVg8MZnA3hoUdp6YnIhPBVMLflsrwdcb82BI1u32uXCqr2Kz+b2uSaeCIwfRFrvd
			IXcAWKtgGw74/ic4dTp9Lh88ArmNty7f/rlsN+f2MYwoK3KxNoQZx2nR9wKNKVKW6n8wvwrohnXH
			EWxUFQikiZI0WFDOF/JTRw1asR2ztY750fraWtvbW21hBVgbFinJYgu/KDIKh/yiUgnzr+Q8BZGx
			HI5ooWUanmDss6Gfi4xoaZDFku9YOB2+A3wbCpyvNlBQOl+A79FLlyjtavrokeMv41TBKwK+uYlo
			bGFp6a2lhblcZmIJ4HvzcrZ8q6sMwBfTo4TxRR98htZ9p4m8VOo7OysbXEn8qqu+IuhMowFpLTeL
			8xROX3wlR00lZ2U7Scle+EpQH2h1CLDALJjgRCKXyKvW11jtm6HvmayA8IweexYNNdDXzoORJdeb
			lClXcgE3YezCoTbL0Kp64XtSGF9aAhYZ0FevXlWj1NqKsVrBpDvfBobv/a8NBF9wvnLJdr9G2BLJ
			y6XSrkoQuMQ0ooOEXkPPDL2WyDxPQd4nMFvK8Rqm+B4yrvrqpnd56OpzE0xLuuXbNZflchGR9YTm
			NuOc3jZ9aGCpYLPugFez5hu9efmyxxMH8k7gx9fEQtAbxPYaWHsUo6mC0anoBJ4teWxjit+ddnvj
			S350uW5fyulKpdzeVpvb/eak0y1cbyjkgY18zsFBXOx93wnwfd/5JjbD8ty86fZf9gOzBxVP+V5X
			Heq/JoPjxUznpg4RJ0biksHFSUVavjEyNkQzeyn9OUydmcGfYu1RRJsrSC2cW/0RSVbhgrHpRXur
			H09asQYX13bh9jTmSuP+bQK5mPsMyA5heRHla4kRguqw3jDNKZRW11Twq5YdhdU5DGF16TethO8K
			vgK/NEwBRx9gaw0a4Is9Il86euncuwuXaMk3hvBdWlhaIOu7dNNz+WamfNYVYHF2VkIWvS6hF5eB
			4XJeDPGlzs05sr55Q48r4XzFqizcSRaW+jmLTpJ5EXkWE3vhFM6yAtJiGJLssZGYwLDzvKGfRqYA
			vwK+2XkiqmDwjLqci742KYPOMzN6TrSA52QWW2oQcCcp2IzLLImr8EWPS8CdwN3kpNhIq/1V485X
			J3FHgHfd+TJ8HwBtQPgahxaZkFti1bdcWdH5IviS7T1QNKXX5HoPmKGtotfUz1mjLtneA8VLveOq
			79UG9pYOOQ+NF7K3JH1Lu1vZw9nYzNnoeYsWfbWQswm5BY99e9XwhQ9mj2diAvOtKN85CH53YiKe
			BPim4rF4FD6/wQJPgYXy2sYwtOxJxS7bbNTdOeacdLk98ZTbg8ON3MRed4A8qJNsrxPR63zTpYDz
			VXwej9/vtvkxXB1wuVpNA30L6Gs8Q/qK2h7qogGnmGVFbaciSkh21qC5Q+mAGPOHdb3oTUVRb4Dq
			hMIRxQcnHjE5EFxu+5go/gHetlIfLVs7Gd92P1b3YhkxWtwADexF4NrwqvTL6KOR6QHZdTIsna4M
			QSO3jc43rA44kgHvtLoerKSXr/M15VtV9WE/KwN/33rrrRvYz1ks+Irq3GNiHILMdkb4wg8YvsH6
			zsUWbnpuXl6YyZalL3jfWWzfjNMDAcG5aWF8kb5zOE6BuJunib5501wj6sWcJQjnZX+r2bxMdc7J
			G8j4ihVfYB1tnRXWV7TUSCbmsPw2UWKQkZ5oZbK82hRfdcqRamxl+FkPRKs1vaK5FcI2IXB7VUSh
			5UrwBJUrXZ0XaVjz84ZMafprIpeb66taYcYVw/d+0AaDr3lQ7/5SrC1J3f1GhpYyvuo6rrlbZMED
			5Lm+yGvu4mzkrnbpUImQs7Gk99AyztfgeZuLZ/G+XYzbktdN/FVLetX0qlvaOZy+XbjGW8JQrwK+
			YHCjC959KUQv9rVKYGcrOANbEJ9I0aovJszGYilvMOhp9eBqL8DYgy01vD5l0ukMeuJekM/p8nvc
			QbgjEPIFfApw95/A9ZLzdQGJA4FBn9sdpIxo16Av4vK6W0tHnHXzq005CofE5IS0WNUVs/sC1L5K
			jLPH+6kVRtqTFgFoWvwVtbWBiFjiBWy7MdoMl1uxaoq6OwN4gbdU0ORpb0IKYwYVdpf0R0THZ9iV
			h7pY+cO2tN8velWF0mO0yBwIKEpENo9UO2sAY9MRdZzgGDndMbESTLXCYTXjaiysUJrWSuDbIOBL
			uknfb93EvpJv3cBhChh4xoFG02+88QbW5+bOnLl0Jjd7NhGPUqEvKpnPAHwvX765NLEMfSnl+Swm
			Ns+KvhrHiLxnZ8/iKi62rMJzMLcad/Na8e2sMJsiLk1WV/BXbYuFF9V5vXKSgpg9OEvzGMD4ovPN
			5+eLOjpnDMN4ZwzMxQqpGX1VN5GYF7VDaqpzUm15pbW/mhcpVlhjdBUdMA0OhJOJycRVMsRXNe5q
			a8hZAHc+99orx4+fBgn4ctj5AdGGgq9pqJGZq2r2c8l+keYbVbCeL8HeA4VI1peDDXFm3fga/G8p
			/qqdNQoWe6XzNV4pJK9exWsYTTRUPu5cKuxcYmPRPKOwwlfGogtt79v6rvR9rcb5ghaAnYkJWeob
			n4xTdyv0wbjmG6dOV7FUKubFFlfoeGPxmJvm+bpSk2BuvS6wtEF3yhkIubHvM/pOtL3/RPHmf8LB
			gz5a+/X53C5MuPIG0j4X5karYedrZtPboQWeO8R0hDRV6lLeMl1I02QDWt6l4bwCkQhjDF/DYAAA
			gABJREFUmnOAFlj0YKYS3bRYtkVk+sNh2xh2Vgbf296K13Fx1w/et6PV72/t6PBjD42QPyKmNlBD
			rFBaDmyAx4bT4YhYKcZDCJAnDlDXrLBaVkSrv2G1adZYQeQ5rE4gpM5atPPQSsLO0vm+RaKGzu/Q
			xRsXbhymfpJHjx458tIbqGNYjDt35swcEDQHf0phnS8CGK4vIHwvLy3EyweeM/kc9dPAuDPhF9d/
			EaISuzS8CL8yBZrNql9iqKDYDh9IfZzl2i5Fl5NiUC8N9KUJDGJ5F+GbkFW+BvxmtARneYUWmuXK
			77yhr5XWPENriGG6aBgSiDMW4knB2fn5CUp2SGKB8eRkQoJ3Evs+S3pfhT8aXnv39OkXXjgNX+x8
			HyhtLPge3G8MPBdNBiwAbikWnzebXocBpaXssKGB1cEDOnILoGsMNx8yLveKW84XJVqNmzKujNFn
			HbzGDGfTeu/bzeUlHXE5Rou5RXrU+W0dvAWNrMpqNU02ooBWb/BmlJZ8k4nJyQlCLw02SmGzDVz8
			jceCvhiy1xMMKsHURBwMLmYzA3xTTgBw0AN21jkIPPUobgAKJlm9+eabTtKgy4cZz4O+gMvn9IHx
			dSohH5YFe0uv9nYY6Tum9c8gLEbSAV9ADFMQ/lYhfmHzxzT60LQ7rRCAqXdzQKHYNCHPL4qBsI1G
			JNRqa+1otYkBRe1UodvR0draYfOH0j6cTBgW/SWpiRbCNURlxJRXBRT3ywHCNEkilF4MyHxp1fuq
			+VaGVpMSvDLPmrgcCos8sdAqnO9bIuz8Fvjet5beWrpw4QZ2l6RRCkeOvPzySyCwvgK+03COcQzV
			+S4kcrNLCN+bN2/my08XxIRnaqdxBuA7S56XqEuJVviVI+ebNcacxUDfbFadLZid1fArp/hKn5ul
			wqIkUjYn0qpm52dl2Hl2Pp+Ym5hLJkuMMspmKfN4JmNcBZ6fUecIzstSIlHDq/nd+fx8UkuvSk7I
			22hheJJWefHWeFwkP89PYbpV8ioFpWlvV+F/gwg4584BehG8+I/h+0BpY8HX1F2jdFVvydTm5bKt
			dNdr7Gd14MBBww36mECDQy60vIcK7K+20nvAMLrIBN1i3zukfxmbaBT1qLqlw3aFZvht+jJX85pa
			OWtbmZ5Af4a3V13ni2u80Vji8s0Y/vWPqE0k4gjcCbgeiwZTwVQ0jhW/qWjKa3OnwAFPxSbiqWDQ
			h5p04lQFpzPlcTvjLiXiAT6PBZz/9E8i4Py+cxGg6xrEZlhOtwLb+sAcKy7Fp3i9Hm9HKfR26GMF
			cVU2PaikRQ8rrCwKpJU0jQKkODQwd5DSrOBWJHFAFBX5yLHSEMFBcqUIYn8knR5rReMLTre9tQOd
			L6Y8YxtK4KC/3d0RwrFNsANyvCEPri3DE+MsX+zlEcChC0hu8r3ITYR9ILCYlulTWktndZF3THTT
			GBOLvRFhkKlN5ZjsxkU1UqtY8yXfi85XxJzB9h6+ceXcFexpdZTgexToe+wYhp3PzCGEBXwvLGDW
			1ZlcJrp0k7SUXSbwTAlXOMNIxp7PyhxnGXbOCAuMMeYZg++V5lf8y9OJzKJK0qgjBDFSOCebRybz
			1FND0nee3K7mfOXg3rx5LqB+TV3yTerxZel9EyKVSp1TlJ2f190xDVogd5wUk47Emm+Can4nZcYV
			3nHVEHWez8+de/fcK8ePf+eFF144AV8E3waG7xrVAF+7dl2/fR1Pq3bW777D9rhd/e7G3bt27tq9
			8/rKn2eDwbfU2N5Sk4qW7WZV5G7N4WdDUFlf+DUQ18Dhg0WO11jee6gwx/mQttBrRrA+qLcgu7m5
			2dTDqoC0ek7U0PKO+G3N9hqXfPUEZ43BhZ63xC5XA9+52E1c0r0ci1PQGdAbTwq7S+nOFHmeisdi
			U66UD0gcT8Wi0Qmnz6sEFYCvc9KF3a1osq/TqaSxwaQP2YtfTsp1xuZXeL/iDQOCXQp44wCWHXk9
			SkcJ46uqqWlMzOhF3ynKbdHRLiqYgCzbNcMNgwqObQAGet1yC+CwS0zYTSuDAQoro1cF5wvUtWF2
			VWuHv7213Ub5yn4RAEYKkzdGo5ymeb40lAFuUgLY0QrBHsJlX+riQZY3ouABBMj4FtYVieVdaYbJ
			tmMrEDUlmoqTRNw8vKqEK4o5yzGCN4i9CzhIUDrfl46D8z36xhvTOMd3bg4QmZyQxlckPOcySyp9
			M9mZcu53VtL2LLAxnyMnLO1vXvXAstRIn+mbFSFkid9ZMVdwVsOoSL/Kke+luYKUfCWznWUJMCZc
			YeYBgHhes77zhtOyIm8rHK+oN0pqUWYaUpTMqiMTNEAbwtBIXOSwtLwS2eIuzAyLRqPn5mZnX3sF
			6fsCO9910EN40vBQff3t68DR3bU7C+6/vQthKwh7XZxcf+z6rgZrY23D7qqqnVU78RG778Rr0gaD
			r2GGkYmt5pLesqMTDpjoa6rOLU6/MjbPKOhcdbAQvUa7W5DmXJRopXXX0H2vcXhgAWr1jpHNpi4b
			ZSPDhXdIgLaZmft2W2GTDe3OEsw1MH9VzjcWXFiIRbHPBmpyYgKbXSVkpRE2fsY2k9EpVyzlUrxg
			fFOu6ETch/0yXD5cy/U5FbfLOel0xp0pQKA/8KZzUK73+ijdGdl81Yd3+QZd4IEDvojPh8OR3CWD
			zmoTSRqWK5pHImiReABaV0h2m5KpUNQ7I+DD/h0Bmj2EcWOfmPBLsWFPJIzwBVrabGNI3tb2dltT
			u83vjyjpcLiDJhmN4SAGf4gmFolxv3CepoRnDFyj76UmWjTHISLaY4QiwN2Askj1TaGwKdI8RuQd
			o0kLosRJtNwwLPmKXlc4Q2mVa77viDXfGxRyPnyF5vheunLpyNGXVL0xfRSdbx7Dz1Fa9L1CBJ7I
			zeaXSAsLUUOvjVIZzwjfMzQUYY5ALJd8ZeyZ2Js1lhplVf6KdVw0vlgVRJ0lkzLbOQfYy4mzpFjZ
			zahonpfpzkk5zJduwrKhvLHeRy3TxfOZrOmq2tDKuOhLuVUE7qvqdmJgr74EPGlo6qz2lZQNNRL5
			/Jlz587MYdw8O/saON8TuvNl+K5NgFd4B3fveuj69dvvvVcFJDXdvft2wfaPwTdGG+prwfr27NpV
			S1ut5Jk2FHzV1s4mQ7vfjNn9ZS7rqcolTLAEs5G4usM1B5eLJxcd0DpY6QVGhshzIX7VVCtD6FmQ
			t7CuqLiF89slK46GSpNXTYgmP1uql6TIubplHq7Q3PZ2AbULnq1xNWu+6I2WYktesLgJgV9MsZpA
			0xRLRanuCBtdpbCVs5JKTaWmYgmXL+QJAEgxjuxLuT0+RC8A2OdH9i663nS+ifT1oSFWFNjISUOP
			FAxAg2GGB+JwJH+TsdjIaHs72kXPSFrZRZ8pZwMuKrJts7gDiOijaDNYbngCzLcKBHyhgCIsrOg1
			iRN5/SGPPwzktWHIud3T2gSXbGOhsXCr3+v3jwFzx+AZx7AHlkxwxsaUYdqJggvNmOcVwKbQIZEu
			Leb4IpEVhULHos0zxp5l38iQiDxTcRHWGctyo7A6RSksiRxeUZ0vlfkK54u29x1pfBcOq8b30qWj
			Lx3BsPPLL2GDyeiZ6Bl0vujbopdi5+DPp+iZM7l8JkozBmMLsYnMMhnP8JWhCHP+zBmq9sXmVmro
			GQPMxRlXsxK/6HllNW6GuJpMihFGVHRE9M0ncolEIk8TgaktB+KZPDDl/ImGk8msWJ3FblUyCpw0
			0lU1r9IXzxvymfNiqsKExlPB14TkrO6LS2pS7mTutVcwufn48ddeO3bsleMvqEL4rqi/JMO3jB56
			aNf123jW0PDQrttf/tmX36sqpO1usLX4TUnluxooyl/fULv7vV3XN9n7r8ttVvJkGwy+an/Jou4a
			BTHm0o2eC8cRFdTsmhBbDF1DeZGJsocOGNFrukz4PW9Cr1bdq41R0Exv8Tze5oLJCaZBgUNFxUcC
			v20lbLFG3DJ21+x8S4D9rgYrxJaCsdjS0mUc4ptIxhNUZYT5VthXI4ZB5mhsKRak/lSBVHwqijHo
			oK9dCXtw0RfscMrvcbtSKdeky+lyu990yvpeJzbWcJI9BiIqHo8fzDLAN6RMDioBv8vtb21q0hOs
			xGqvFLVPTot0YIwlyzIiIB1wlmYZhCnhinKh0ujCvW63N0A2WNYZiakJlODsD9sC6TEblvNiwBkc
			d3u72427bfXbWjvasWcksDWihH0+WiJG3IeofTQcw2BYNKFM00qvNhkBWYutPtJUyCTmEVKTjTCN
			ERahZfGltqAUyA2LGcTUmwN4Pxi5M3zrdfgK9r4j8pxxlO85gd4jR4++Qbb35SMvXwGjG8N2zrTm
			G6XmzjH8Qc7lsnmkL34tJJdJeUbIniH+np2j5lbS82YRuSLnSofvjOp987LUN0MZV1lZQCRjzKLq
			CCuN0P9Kgyuzp4RZBtrC335zmHxMHTASqLwow51IyFmAeGciITKiRPy4IDCt9WI2lBfJOQkiKUuE
			oue17Qwcx6Vi6hSdTL72ynHKsHqBUpzFhYsvnIIvhu9aVf/Q7tu3ib4PPfbeP//8Hz/ccrt4ERd8
			cf3ueloZbkDTuwtXha9fvz507drD13dW4SYM38LfONNAhXIGd7l+klrbqgPGtlWGqURFMuQzF6O4
			wPQWlBgdMqG3ZGvJ0q7XzN0S+DW23XjbGFrWqatO62025lXd0gH8tm54b8kGk7eMXTaKV3ul4V6N
			841Fg7HogvfyTW9sIop1oeh/40Fc/AUvjOZ3KhaMBYM+9K6+VGwqmoqnvIrfB2YTbG8Q8Gpze1w+
			zGSeTHmcrsE34WanL43zFFxY3/umD9xu2m/z2wI+zHv2OQHIitPvaRelRKYkK+zkPBZYBP8qhdCl
			ZhfYwYqICpews1VIZCPDvQBfd3Ah7Q64BY/TgbDo5hzBlhqIQWxo1TrWgYu97R5bezsQ2IMJXG6s
			8MXxCRHsWBlWaGSg6Mwh4s1YJYyJ04GAXGSWg3vFlCMJ47GQoneNVAcWycYbdOsYRZvpRLR3DsnE
			50hgcXEF8DU6X8y1ojIjwV5pey8Be0EvAYCPXDlMQeZobjaPHa6AtCLqvBAD+grru7QQxOG+5b0v
			ut45TFvGdKv87BwV/mKwWS74zs5ltOG66qKvMfF5VpAVzoC5CVlmlANLm0MjnBT0Fc058sRXRDFC
			No515cmJaDwZp6yDeDwxT8VuExNgZZOUioCV53ABk7NU+s4YVofnZSrWvGm00fzkpKHvRjJrtMVZ
			86VsNnHuOyK1GePMJO2CBt96hu9dCv3u7V0Yc951+2f/+POff/jP7902gvQhIO+u2nqcxltPM3ml
			rj9c8/S1fdfadl7fxWu+JX/jjNnOwtvuL4HeMiHnMpOJDpTDbgkKlxoYWLTuq/fVKI47HzJnWunL
			vYaJveUnBr5djF6juW0zJEypxUOFceYi3VrO9xZiuG11zje+gNbIC5/Hly8H6eOOEmSjWHgEH4Kx
			eCo+GU8Foy6XEnJ5U6mpqanYVDzo9fsCXiW16Ha5UorHH8TezQBUn+JSXM7BgGswoDjxoi+SxsAz
			GF/sauH1KQBfgLMy6HN6/ZrdNbaRpGZWOLJeocVX6XkFhNNYVBtWIgExShD5G0grIY9nye0N4kgl
			L1CeqosCouMkNnkMjVGX5lacCNzu7/D42zsw/Oz3p/F2BLENUIzDeNMKTSwKhWUutWhbiYjFGmPp
			pdUeG+I+ZGxaIlks9aZFsa9adhQRWdCyKxYdUFh0pQYMhxYHFbiwGud7kyLPby2JXGcdvm8cEfh9
			4w2Eb1DAd3YuGvNppUZI39xs0ufzLQSD2MF7mWXfvERtPi+rhrC9FaFXO8mUFrpj/KLgc0aLKsu4
			M3pfHK8gOzej8U2KpV7R2jkZxb/+RK4BXopF5+MYe8E1EAzFRGncRwpXRpKJGIZp5rU+kzMZarhh
			rk+a10LSss/VxOR8UqIX7rlKUeZJYwdnKi2iwqLvnNC4e+qFF16Fk1dPvHqRne+a1QDYvH19Zx+w
			9+egj35x2+hir+96rLZq506gLhjd67fxpPqZP/7heP/mp77+1Ncf78dULErRYvgW/sbtl+nORawt
			Tr4ql3JViOASSVaHSuPVpN/VM5wPmTZUu2oU51up1UamQqPSvtdYWlTS8r6t971Se1aJS7eMLaya
			S1HW4H7NjSUN5C2fN922qsEKYIzgg23Ju4CR54koJTrDLVFscJVM4kSjYCwVxHmAEZ+SQvLiaN8p
			BYcGegfd2CnS748pzpQTW2iAXIO+QV8o7XJOgv8NYYIzbOr2g/P1A3ydk4NOp+IG8+v26OAFCrc3
			EXk7xiT0wrSCmw65lICYFUiLrqG0GCYYIYtLjSYDbrfHS50t4TvtDsE/MXoI5/VhnHfMbxtrbW9F
			9gJlsc7IhvD1eEKekNvW2upvtXkoQWuRbG8ImzeHaJmZphCm5fHgMwoDS8nLNC8YU6NpYVnNnxqT
			c45ka6uwHOor+lGS51XHGWFsevF9BeuUVu18RZ3R4cOyxvcIDRI8gmnOx469cYmCzgsLZwB1iWjK
			t+AD7ProayGWy2VivoUlwK8PNpopH3jOYH/m2bysK8rIplVZdL1ZSeZi7CJz1QFHwgxTyw3Z21n0
			naQKYZHgTDFnteGkKAJO0O9eLBpPxeAPvxh1Nk1im9NYKhlL4a9nnFAcRfAmaBmXosrYckPNlSLg
			4rSi7OSEviCcNThdPdCsli8ZBhBmszlMbP7OC8cFdy8id9H3wil8v8rOd62CX2c8u3779j9/9NFH
			v/zFLz7659sNhvsf2n19JyL3+sN1b5/vf/rjjz/e3HLt8WtPffLUtcdbzsN9otSInW/Rb5za07nA
			8hbTuCAyXTihyNg3g64XutpDhdg9VJrBRY/Q2Xtof79kcKHv1fKbzZ01zHMDh+6gZiN6l1nANZXz
			qjw2g/gWkPhtA4VlsNoEdt0Rrwa+mIkzEUenFAwuxRPU0ArzcdACg69IpTDrOYVJUiHFGwTjG52a
			isdSAVfaFVTAD6ecbvdlL15S0jjiCPkLJ4OYB43XnAqWwwLqgHduvO6cdLlCPp/bB85Xjgtsam9v
			6minEG2EYstkaoXZDUgI02S/CPVzpkQq6m+Bm2A4/Kb7pofg6/Z40nILbJQhYr/I21YAe6vN7wEA
			t7Yiev3AXdgOByng3wURqtqlXOaQLyAHKlDCFT05HUNasldMcqDyXkzBCkfEyVhEb2VFp2oHZ2F7
			ZU+rsbAwzLDDwUWFRiOtxvnquvDWDZluhadXsMEVwfcoXMQbL03ncolozBXDFleSwGCHs0mgL1pf
			AHSibJ9JZGkmKxOcM5lZ9TwjynwRyll1xVes+c7KADRtklWvEV3lqMBZOcRIfGdlb+f5rDrWiIqN
			JjDbPhFLxjDFPjoJRjeJfcajCGR0vhNRADS2PqXeL+RhsfvkvNZ2Q1vNTQoY62VFpkph2Z2SGlXK
			0cDqKz/7yndAJyR96RvRewJ974lXT7HzXbOoqBfY+6uPPvrFL375S8Dv7QYDfWsBmXuvP3z+2r59
			T127dq1l87V9v/7Nr596vKXl481/fP36TnDE7HxL/sYd1Ap9i2lbUGlkoK1xPpHZ7h4srDYqhV81
			gKwFkgu87gF9epFWanTgQH9v50D/08jf8yb+/m7hem+JYPMdpQecaSG3mKi3TBHlAtN7h2yrgmXj
			Zi29WpQ7rWqwAkb1gnH4hI5e9ngx6BzHjzlcZkOfEQf6Yt5VTMEV3xT43hiexDGRSvEqbo8THO9l
			v+J0uQN+H+ZXKS7wxIrvTedVsLjUicOnKIA94XxdTuebhGeAr6Gol2YFUoHtYBpbZvgigobptE80
			jcSOGR6/n/pNBSRfRWlRwOv1ovmlnhuA4IgoM8J843SAUoqRvRhebvf4KcrsH/Pj7ARc36WlaFur
			P4LZVgGRowVPrgj6E3hxkmBAtKuMRDx+McwQxwjL/KmwyMMi5yu6SkaoiBcIDBuNidRoWZ5EKc7k
			n5X04mIAL4ZWAN9C50vNrcD6XjiMVUYg8MBHjrx8BHs8H8Gk55dePgI4BlMMxtEH7nEhhs4XByyQ
			9fUFwfmm9KSrUgQWE4yoqignm1rNSrBSq41MVh20qxUbqUN3aUs9/VmOXJD9r0QJMKJW9Ig0ZEsh
			ljGzPp7Iw6/exDyu+iZo4Rf/JgQmJyeSmBKYxxuTNBpBRWtWK0iicHOJwmDxJ8LMnZWdPv6d4y+I
			r5cFfk+9IOLOL5x69dQpdr5rFoadH3rs9pd/Ab73lz/7JZz9tN4AX7C9t9/e9tS+pz55/JOnPvn6
			bz75+ifXNoP9/Xjzb+t217+HW2DCFTvfot+4p1r0WqODxc2tinzweSNmDxqSrQztNQ6aq4pKxpsP
			HTAA+JB5I+Pyrvw6+HRvZ3dvZ29350Bnf0HceVwbq2CYXzQ0XprAb5dHr9Y3wzQj0FQzVI64wg3f
			0i2xtqXa6Mqw8jvUrLOX8LuawQoJNL2g1yntijpLxjHwTPVGwN6pqTej0eBCKugOAoanYuh7p+Jx
			zLDyenxeb8rl9Xg8AQVI6/c6XeCIgbVghMEFvwn/fAEgbRp7RwnnSz05fOiJg0q7Dt8xLKVVAHKD
			izR9dyyk0GSEQFpR5NTdtBJye8ICvKLbMnjqkCft9rrhCNxeRLHf4/Xj6qwwp2n0vjZgr41izh02
			HFvUik2ccRxxO3WfDGDk2WMLB5D1gQhQVsGpCOm0Wt0bEiMaZNWwCEzDwxR03uBjsZYJk6zF3AYK
			PFN6VThN+VYRva8k+V6xWJwm2xsIkHFepfO9qRrfJUx3Rud77soNAPGJKydePn7kyInDJ14GDL/8
			8ssnMCx9eIHynEWS1RK1uZpNxoILClwLppaWhHUt6X2zFFlGkFLDSLkInJmVt+QMQxXUuLOMPlPU
			OSs7XYkUrExWkHlW8FnEnDOFgMzjAjBmVsVFhjMmPOPiLnZ9yWvJztiMii5iVjJVDmltr9AFZ7Cn
			xkooa3it4oQAPZM7fvz4d16WX985oTpftL6nXrjIzndlQjKWpaMwvj8F6H4Exvejj37+i1/t1B6F
			i747Pv71vqeewkDzb37zm8c3A3m/COztunV9N7zzuAU735K/cU0tB9VFX9UAl1ztLWVxjbcau0ou
			k091yIjXQybGFlheDa546WBvb3cvqnugs7Pz6aKMq3FjQytzotWdTHDRlEDEp6XZTFbDtKJb6m23
			2rQQsnGgYHMRl0umOBv+rQa++OH8+utnFmLRxOuxhSCt9SYnJ1KpBBqOGHndINb7poKpFHgoXHJL
			pYDKLpfitsX87pgzaPO4XQHq1oxIdikBH5lfJU2DBNNuRXETfDEu7KLaXx8OGBz00Sovxp7BoyqL
			i0qAujgqi2KcELKXZgfSAF30u7aQVmAEoERTTIVGaQ/sGtxvwO1x+8Ujyab6PR7qJWkj49vu78Ai
			31Y/dr9Ih8bSmPaFE39DvnR6EEcxiZVkn0+s+WL7KhH8FnMVMNCMrSfh+uAgPJIOI0z9nan7FTXH
			wgVjAdz0mFbHS2vHEel7MUIdoHTtNC0rww5X6XxBSxfeAue7dIHoC773gtAJ8XXixMsnUKdwXfhd
			SlGi+iLR4TmfiS4sBJd81PcquAyRMjSgiCYYacZXYzAxVWev3mgyK/Kes2pZcFZM4c0YhvGKAYF5
			fLhuf0WMGtd9k6KoKCkGEAKP52kIIV7D1hfi/nnq0pyXrbAyM6uj7TKafeU46ZXjeOHl7xxXg87o
			fl89dZGdbzlJIGKS1O3d1gZqokE5U7hCK0F8/Tb219h9fddt8L2UbPURnf7zbdxq9+762p1VWE60
			75NPrl375Ddf/+Txxx//8PEPP/54oLlux/Xdu1ZIXIM2EHwb+xZani7RXrI4AG2ErKGFc0EoWptT
			ZODwQd3Qmj2voXjIFF8+pOdYSQof6O5E8g70dnfBWWdvofc1DDAqCdvm5dFrDASjR70lEHxr2bTm
			svlTZmPcXK7K13BtFfBFz4vrvktgfGM3vVjDgaG+FGY+J1LBYDw2gcuDUUw3jWHZL00ZRFPsBKTG
			/EGfM+6x+X1KwOXze4C9OGPPh60n0LSKGLTH7aHors3jd7uozbNz0ud7Ex4jjS/4zkXs0owojQyG
			Amr7Kh9FdMkowlVPyOOnADB61HBIoXA0TTmC/boBwWl3yO8RnTWobSPGumXIGYf14movBp39YwA9
			m9s9FsK2kUootLjoSqd9g2GcouAbVKilJQ0HxklK4fTgYEDYXlyopQxsuFmRLTxotqGCQwjFYKOQ
			2r9qDDAs5ylgAVNY7e0cJsJjFF0s+MKd5X9ajSXXfJfodAFxS8u+hy/gCvCpCxcvnHrr1KkLpy4I
			+p46cerUWxcOv3vl3DlcWqD1hVjsTCKTFz0nfVSQNFM+5TmLU3uzOeF2szKNChOxMhnDSMFC86vd
			o3bcEMQlAme00UQUBxZ3qMvD4mbZbDIv4tGi1+Q89rvK59Wi3oxYvMXHoGEt4K52dUVB5iK9huRV
			ZyNPT+M1NfZ88YWLF08WOt/y9N1o8K3COtwqZPBO+H3FNsy34YbH5L27DadYavQrou734fv/BPj+
			UsJ31+6q6z96+qmnEL2ffPJ4y+MUeX685fzDSOy70QaCr7XvxuOA1v/X0/uNTnd/mW6SBQMDS2HX
			QF6T8yWqOs47unrPm+LJh8wuWN73u6akqoPne7s7MegMAvh2Aoj7jeTV6CutblkAFzBYJ6CpwRXw
			0lJofW8t62X19dy2t/WItdr1uRx49eurKTV6/fXoXBL7aERvLnltE7EEhvuowBKX16YmaYiCCF3G
			pInCsHMc13o9Cx5wsFMxcJ6YC63YfE6F4swKOt+AjwLMPp/XH0D0gkEGPPvSPuebCF/EcnsHfuES
			62BgUQlTQBcDzLj8G47IRlZAN98gLgT7bZ502h2mYDAGnQGS+FzutNtD+MVTNMqyp0WEnhRtLw4s
			ahfLvq2tCMIA2PHwGFA3MKhEAoOD74P3dcH+AoMhOKeQNvayJL66kPAyyQuJC/cHZJUvQh6sulgr
			xk5WVEo0JmYWhYm9Y6KjVUSkR2Pyc1quJ0e0XOo7wtfgfKnGCGPOIMDvYaDv4cM3LiCNL4pxg4Df
			E4fJ+CKIqSL4xo1zOGIwgZ2lcrl8Jkm1snEq3EmUXwnNivQpPfSclwVGwv6a8DtrXPqVG1GilXlZ
			OKtZYNUA04RAGXaWjlgLQmfNA47IXxfQlq5lZlbvfLPiJFvwx0f2teOvHJ0+e/bYNJAXTo5NHz0u
			e2ycQN978a0C58vwVbW7akvPpuvVVbtEt6rdt6l1RkPxhg1ggIm93wcRfz/6hWizcX3n9R29T30d
			4PsUoBe+QV//+lMtNbcpjH03R7Wh4PtBS+f/tjn466f10UZl22kUzwfUx/MeLNXVuSDw/PRAb9dz
			AwOHDhTg11hEpBtfja7nDwJ0ezu7EcBdYIHxWleXNlvBPLRX/3fn9KrChlYqKC169yrD2q+MPKsj
			i8rWDRmCz7faClZ7zQi+y3m+r0fjMXC+uCTov4mNnZOTCRrnCxSeosojbK0RjxKBJ+Log6NT8Qmc
			Drhw06c4U2B9PX7FrbjdCqVYBQIucL0BX4BaS3p9iifg9tta/X63zYPOdxJLfRGbISouCmH7jEWy
			g9JyYiw2oqh9HQMRdKBpxRPxI6v8ciUWpylgxDeA8AXwgsQGojIpHMKcZhzca0PL29ouv8PgfDGV
			ORDwve9aXBxcBPQOLoJNpzZaVOFEIwXF4mx68X1F5G9JWEao3lesQofkbKJAiIyv6HQlB/dSHa+o
			8KUq35BMlZbZY+LxaZG9tUrni+lWb92Q/D18+F2MOsPNJ4G+F8H5vnVRBp7R+Z565+TJk1QX/O6Z
			MzmaXZ8DKyu6PiZzOMgqO1MOXbimK9mrlu+KVCoMKhfANjurX5vNim0yYviRdLzaOMCMRl9RnJvJ
			Z42OOKtbZInjTBm4rjCDymyJyXGbZjLMyy7R1Eg698orr0yT5wUdPXoUCQz4Re8Lxhfe3bfY+ZbV
			9arr1T01P26r+fJPb2MPq+vYL0POUVCFBKVcq58LfSIqfb9MxL7+yNCv9/36k0/2oe395De/+Tr8
			++Spjx/G4UfX2fneSX0LT3k3x1JLmwujzUUYNkztPa853wMGKOtmt4TzRWHKVNdAb3/Bqq/O2d81
			ZGDpNx/sxQcCe7s3d3cjgjspAn3ezF51ZK/G3vL8fXvIbEG1Xlbat0XGlW+ZE6iay5rf8f6ufocp
			Kn3LGJu+1awlWBWv/q4SvslEfGGJxissLd1cCsai8UlsMEkTZmii0VTUG6MWBzFyvwtAYpwyOOny
			uheCvoAylXJjypLP58FEqzSu3GJRrgJ4e9P1ps/jUfwBrx+XfcG6KoM4CunNSexylQ5RPytMJsZA
			MsZjEXpKSPSAAssranxFsY8S8rtD7hAgluLOovEzPBQDzm4/zhrG0l1ctFUitOQbJtPbgWHnVgIw
			Ol+b34aVQT7XomAunL3//iI+v2gbLdEbSBNqwRSL6Q7qSOEQhZ0FdcVMQIo7C+erj1Wgoin1Iv0l
			QPlb5OhDWo8OkcSdHluN86UK37co2/mGSHhG44vwvXjh4oXTF0/DbacPHwH2Hkbv+xbQ9513Xnzx
			nXfA/8ZwqsHc3Jm5TF5TLp8wdLrKmAO3aopVRtT1iuhzJpeZLdtiw1D+K8yywHHWgFV9Jm+G4Jo3
			UFfmTMsHlUHoapCrYhzBKhaOCbL5pCgvppVl9YuGObxG7EXuXqJ/iF+gL4aeX0Xfe5KdbzntxBqh
			6+9VVdd85cN//MePfvurLSLo/BDRlxZ7H6Iv8L2/oLXe/5NsL7L3F7+6XY/s/fg3v/46gPc3n3wM
			6P01wBdc8G8fJmRju6u70IaC740Pbi598MHC5qfVVhv7V+B7C6uJ1OJeU/C5MM8KDWx3d+/AVocp
			j1lLqpLnejhaYy+aXfS9mwm95IMHKPRsmF3UP+AwpFqNl7a7hoBz2ZG9JUqD2mSvK32xV15RG01u
			7SLZl10MNtrdobudapTETkELC9hn4ybw9+YC5jvTPF8x0jeB0E1hk0LqMQQOGKPOrqgrPjUFwI56
			lbQv5UWPCcbW7Ruksl5c8cWlX6frTezO4VZ8acVGSVcenwLWF50v3m7zNjW1UwOpwRBNDUyDA9aM
			IWYUy2ofqjmKAH0DIbfbHSDrqyB64cmwSzOOEaamGjRagXYUCQNvw2OyrhdP2qnOyEOtpQYHQzQF
			KRQC+C7SmGDqoOWhjGYswqWDWHT5aJd0JCotpbWWHSYN1lcM643QNAVc6ZWTBSkvOkx9t2TFUkhW
			KYs9hVfhfMHvgu3F5d7DSxR3pvkK6IFPAZRPH79y/MjxI0Ivi9DzyXdOvkjCftDvvnsDdSafp4FF
			udkc0Heu/LKvWJEVCFUTqNT0Kx24at6VLAU22OFMVlvnVct+C3KcMxkze7Orc7PFwWTxrOqoIpm1
			RWRNEoFxEVlwl0b7ivG/dAPel3vl+GtIW9kwG1tmE3+P4mCFi6dOvsXO9w66vuv29dv//JUPP/nH
			Tz78+Le3ttBi7q6d1ykY/dCux2p3V4HvRfhK7/vRz7HW959v765+7+GW3wByAbvXHhfoBfa2DMEO
			6ldWVlRKGwq+b11cWnjng9eff+ra04Yl34Iek+f1TCtHYQOr4ibOxquG1hr9AFCA58BAf1n2ovs1
			295D/bTU290J1rd782bcxbZOWvbtHDC01RjCRCyHtL2O8oVGashZzW5+u7lgnIIeVtZaYWg0bjPe
			1Ka2moRvyd6urjYTs4ugO1R66Xc1vZ0BrvEF7004iV1eiscWsJyS5ipgThXOFsR1QVwdpAFHlG1F
			S75Y6wv4jQWVgM+X8rgVmw2MJwWT8Rujzj5fgEYOKj4XXKXUY5ufOmNhnw3YyOP3tTdRrS5xKECp
			VCFpKUODPoV6XJArJTuNG7o9ODswEPBg2lIaV5bdHgo6+xGcnlDaF5DDjKjiNpSmhV/yvrTmiw4a
			UPv+INXZYm/lwUVlkZ58MBTy0LCiNMagIxj4XgxQ9pc8JMqZSguIykh0WDR4pqYeYoZvRPSWHBPT
			fMdooTiNgwepckm0vlSbdlBO1wrCzgbnK9Z7lyjovATG9wL63huU/Hzh8BWs9MVAKRi3l1468vKR
			ExdOnZTsfR75K2YBv3Pj3JlcDiOrZ6aRwHPFvFNvyArIinFGOVr3lRFlQ2/nJDXEmlUbS5r8r0pW
			1fOq14wXMjLrquzC7R1wLJ9EH6UwjylaSWlss6ZS5owgsmp7NWHqNNyRu/SKSl5A76UjgF/i7/SR
			46cvnnrrFDvfFQg4uuvLX/zwHz/55B9//vFvt7y3S7ak2iUi0Lu//IuPCL4fYcyZ+mz87Gc/u73r
			veqWIIaZf/Obj4G9SN9ff/2pj5+hRKwGhu8K1PfByWhs4YN333n2xWvLrfYeLBjYq10yQniZ2YC4
			5NspfGtvvynJSqdugcQ9GHOm9V40vpuBvJ2a/e3V+zjv7xoY6Bropwrf/q1d/SWKjHTMGuqKDByk
			UYG3KETcpiPUPFdBJlFp9wgm93d1DQj4Dhm6SC7ngAt6Ta6mzhfn9rq90YmJheASIJg8LxJZVPwC
			dbHsktZ7o7FEnBKupjDXGeELkI4FU6lg0OZVbK1uvwd8r+L2iXTnAOZeuQZdLoVg7La53R7s7uzH
			IUjgfhWf36N0UEXtIs4REpZZdHAEu+haVETREK3iBkQrZ7iIwWVaoKXodjrgDajwReR6sFo4Itg4
			Fva5kJx+uejb3tHe6klTEdEgWnPwza7AYBpbUYeVwUXMr4r4KelLIThGyEVHaJwCGVyCLN5CvJVr
			wDJ+TLlWEXW6AsgmXG9gMR2OpCn5W1pdYc/Fq4K/I5TIarKdL1DYmZZ7Cb1kgDEDC/4dBvhOHzt2
			9iymC01Pv3H0pSNHyPuCgL2/eVEXNcfCWcBHsA9WLleAN/2a4Ocs0ZHWcLMyAq3lValFRlpJ0mzW
			kIqVVZOpMlqms8n/ZgqmO2SKUFseyaJ9c17HqBiHlEtotUo4k1eLpMtULZwWmMwnCuFLIwvz+blL
			l14B7p7DDmEIXkCv+D565Di8xRfZ+d5Jt9/D8PL1nVvOf/iPCNcPP/4VtmfehV+7aJbC7Z8he1E/
			/0RU+v6M4Ht969S/IHQFe3+N1vep/ocfu45J0A13fTwbCr43Lt54PRa98c4HHzyvpTyXHKCgJ1Hp
			KVaqzS0fbDbMJnq6m+LHWCl0oGBZt7wGegVphffFuLPKXqS4tL3j4wMDvQO9AD+8OjCwtcuhdpdU
			HXDJEp/m5oIS32ZjW2eDbjWrLldsY9/ab9f24AD2IvoBvlvpFnu/o99hbzNyVs3v0p5Iberx9iqd
			LyI2uhRciL7++s0g0HYhTpPcRAs/wV/8Fsu94IeBwVOYKQv8nYrheSzmTPl8Hq/f5ne7XQTdADpS
			X1pJu50+xQ2YxcAz+Fwsx4U7bDYvTh10+fxeFzaBoqZVYEDBgdJkA4rvBtKLaBIVWnKV5b1kFUMe
			D4acidZp/ALwXvb4/X4AZyjtwaYcZE+xU5UPUZr2IHxFsnMIM7RwMToiBhQOAu0XB993hZy0AByS
			vaiomAixSGN9I2GZWYXzfPGAaOaRXLoVRMa+HhExozdEHaD9MuaMR49zDmVXTBr6gFMjAmnRPOsO
			7SULnS8QdwGDzXgGp4cp4RldL1lidL7HjqFJBfweEyuXR06fvnjxLcTvN3X2ogEmiqNbPjp9LJcv
			BJyhXicj2koKs5sVyVYyvEzVPFkt5qxFpFX8zqg9r4xJzBqMjdgtTmMuiduMbAZNM39F6S9dSKj0
			JeXEGcFYTSfLiNg6XExigbCEL3E6oTnfeYAvshfbhtG/I5qAv4eBvYaEK3a+pXQba3ivNzxUe/32
			rz785Ofgfj/88G3ELnlfML63b//ql+R8Ke78C2QvwveXt3c9HPyXIND3k4+fAvR6f/31X3/9k/PX
			r9/eDb6X4bsi9Z25eOPd6MK7H3xw42S/YdG3uO7XUTAs8OAB06JvcVOrgrYZ4Hwxbwo52nteN72l
			+DuuXervFXYZM602dyJ9Mewsln27OwccQN+9zzy80zHQax/tHRig5la9gMGtss2VGbxvG8jXPFSU
			7GxSCeOqLujaMczcr95qJ+4OIH+7uuhxXeSE+80P1s3uUFHgeVUdrpJAVPC1mG8Fp0BY/ECiNV/s
			LwSwhROayY4dNqhAJQ6+1zmBza5wGTiOs3w94HxtHg86XjdCEQmM8Wa3G27xDJL1xapbDEy7PYrz
			TWwD7QYUI3wBsoMBjMwupvVRQoNidTVADa8AqdRwA+O2wFmsz8VgNEZwPdhSEst7I35KyPJhHJjq
			aPEUw72ixVUrtrYiiIewn8fgYGBQGcQl5sX33wcD/P6gojpcyrQK+MCPpyOywTQVMCE1sQUlXFJC
			crSRgC8t4oawmTTaWmF9xWAF9L6KmM4kW4YI+4zOHf6OwEePrWLN9wZBV5CXEq7I/eIysKTvpWM0
			ehdH8KIBPob4PQ78fYv4q4afBYFf/JsX/wYofPjIpWNzGgkL201qC7hzaudmEV3Wbe+smu6cF+zN
			ZfNYCiyCyRm1xFdvbJVZVf+pjKxEkpyl6Uf5vGB5XjSG1owvfknwavTN6GZawp0QnVRP6XGiNSXu
			/Qyi99ylK7JftoG+R44DfC+w812Jdt++vXvX9ce+/JVrYH0/+fDjt69f3ymzpW7f/vK//+UvAb7U
			XuMX1Nr5lz8D/H759sDUlOZ70fh+cm0cUL67vuHuybtrg8H33Rsnz51bwLSOd55t2ay1mSybbqVX
			9N55auAhY0PJQ0/LADJ62X69scYy6D10UC74gjZ3Y7VRC1zehiZYALhrfPzQ3md2jHZJ+CJ9h8AE
			D3RtdZjAO2RAH8LvTllXJVisGV87RZi3yt0NCfAOCPxiypWjizgM9HUUuOqiPwBWD19sZJ+Ixxbi
			uPI7AcYXu+rm8ZNJdNug+HMqGk3FYq9HsccuVflOTkxSBFoAOeWbCvptNmwyie0acXkTuzUqLuz9
			7AX8utEP+20em82Pg49wFJLT5Qu4FaePbKOyOAhueXAxracxKZQeLNZ7B8E6+kLocjHU7AaTi10g
			KV/Kg1FomkmEQWNytRgqxtYYlHuFiVTh1laA71hALOemEbTvY47z++8HQoviAsA4QMu8sgdzaFHB
			ZxTdraT3RiYPKi7MBBuk8iQlrTbaoKTlNI19EH0kx9SpvjSAgdqE0Oq1HAoREsH0kByPtHLne0OS
			l7KsFi4cXjosem3IcPSFK5emBX3J/coANPL3OPhfij8DgvHrRXF6EgAM+L0yPY25UqXpJ+buykQq
			rcRIx28iqzrfPI36zc7OaulYhs6Redlq8s6LuRnqrjVjXCHO62VHInOZum7Mi5XbRFkBV/EZqZSY
			TrGqd15yWZpkcrwUeAZHnDsD6MWWnZK+kr9wSm3E3sJV3zU7393VVbtqd+/edbeVq/e/bssukdft
			16iS6MNf3d5dj3+vYFD6n38pna8G35/hv3/e8i9Tr//Lv/zm42u/+TWGnH/9VEvb7XU4lg0F3/i5
			D869u3Duxgexcx+cfOf85gP7S9le02KvjDuXp+8hQz8rbW7CoaeFhSX4Svqa2SvHExluQINLrrdb
			nIL73da5bZsw0NvgPrC+e3/0sBVw6xjt7u0d6Bwf7x/AGPTWrf1qwFlzump1r8CvqbeV2ZuWccJy
			SMJWHb6U6Cy420urzl2wTT/Bl/g7YIhvLwP71Thf6lgfwxk3wYVg1BuciMWwyAihHE+IxOc43EGT
			3ODTCnOfJyYngb1TCN8Yjl1wplwpj9/mVmh1F70ungMoPT5sfBGiq15/KwDaTW03wBLjSrBbAQJj
			IBgQiGFnkeeMUd4wWWfyuuiIEWARJbCoIE89bjc8xC16YHnA7mLxkTSTSjocWFwUYWtc3aUSpjAu
			+NpkzFjxOQm3hN/FRXH5/TQaZjHJKC1aSg4uRsJilmFE9nZOY73xYIDgKx/2/mCaPLhsQBmRy71g
			nGnO0VgrDlmIiPEJckRSWpJXePw0/NWxmmxncr4LhzH0fENg+DD5XoFfuKbB96zGX6pZFQC+cOHi
			xYtvXUQAa2lYf4NlSOCZz56dLRd4llMSsmoulaj6NS36ZrWGknJu4KyhxChjwm6mfBmRqQRXXSfG
			gHBWJC2jy1WpqrrX5QSbqeDVI88Fj8Kdy0vZ/Bw530IdRvoSfPFrrc73vfoui72tZ0tPT01PT9W9
			5uSnKCTwrz7+5OcfYvvITbt27sZJgre//NtfihXfX2CJ0S+lwPv+aur1//dvfvPbj+V671Obb63L
			nyYbCr7RG28tvPX6wgfA3xsfnPzmN7+gB5/3l3a+B4tWeA+ZVncPlTS+Bw7s1yLIeOHpwmVfQd1x
			Y97V0xinJr+8s7+7t+Gh7u6nd3Y37xy19nfiCvCP9o5ahw7t3Q7w7ST41uzdsxNQ1tvb22V9zj46
			Mrp9yDDEYEhvrDGkYbcwIm3QLeN5m0x2bqaoMrFVFB4NbB3QRXHnrQNyDRi/dJNrnqwgz95eLXyT
			cYwlB5ei0eASEPiyOxVMxKLxOWpyhfFntLuxOE0zj04kcdxqDLzw5OTUFM5dxeTn4JTLN+X2tLqV
			AOU6g01F44qJyIoLQ8I+j4LBZmzvrPgCHq/L66ZZR3iqRBYXwWhiEBg7a4RlAS3YXIztYqaSHF4P
			XhfQh6uxbk+YsoQD2E6SFEFHrFD9L0B/MBCmXCaRKB0aG8NGGwrlUocU5z+h49XgSd9ouZ2LaUUM
			IsS8rsCgE4uDIqLxh2irAX8lKE4qhPLBgyR/B8MYkhbFu2J+AsI2gLnWVGrUirFnfHAoLAug8JDC
			wvxiZB6eehV1vjdEQ+fDwveKoPPhAuc7qwnIK/2vCEADgK9cOX36wulTF0++dfLkO8hejEKffIfc
			77FMAXaNtMzI2UQZteZXRKNx1TerlvXmM4K+WjdKObpI5y4mJpdezRXuWCZN6ZMRMnnRcW1CiyPr
			IeU7C3xtPpPR1nyJvvOmh+YSubwag54Hh33m0jmyvZcwH41S0g4fvnKCzg5jOdd6rPnWDlja7DX2
			bVvbarZuqb3XiPz0dP36rqr3fvXhh4DfDz/87Zdv396Nra1+9otfSPh+9HNJXvS/v/jFh6+/PvWb
			jz+WqVZf/3j7ztvrQd8NBd/UZCx2cSH2wQcfRN/94INvXjz5peKEqwMHDYMED6hji0yLuwWziQzR
			Zm1sb38nIbO7c/M2wGlX5/kC9AJ3Vec7fujprqcPPd2LhpeKfOure3uHRzu7e+prRru22Ue2dnYO
			VO/p7a7b22+tqUPc2ke7d+zd2lW3Z9tIf2+vxeoYtttr9tSolNX7OOsGWA9DS7qqhLwlvof6u7qG
			7P06NwVut3YRVrv6icZIWmz6IQVb9RtoPLBV7HpIJljp1tdI+1XV+caxf4Y3GFy6uYRTBYPB+ET8
			9ehcAnBL2VbRKEWfX8e2zpT+HJsC9k5MwY00DikaTfkAsorf7QP4Yo4VLvoqASSnz+vxeP0+m8cV
			8OAEe483gLMEg56AywmQxrGEyuBgKPI+OF3pOiPhdITGFuBukMa0JIyp0HCGjhaIGw6FPGht/WEb
			hp0jokqXMpgjYFrTaR/130DOwV7H/OF2zCpOA1/B7eLibpqoG8CryvsYXQb8k71FeOPi7eAgrd8G
			5BThgMitdg0qFF3GBw8qBN9BfNGwx7AIJ1PCVtg/1t6O3LWNhW1yphFBHG2+EohIk0x9ovGvg1U5
			38PC9x6mEyDwgjRktAB82ARfXPrV6HtWZmChCT5y5fSFi6eAvu9gA6yTcHKKwE31RKjZjLH2lyia
			la53TnavMqU667nOwvbmZXjakCqVKZnThU028vlcUoCS1mCzestIJHuygJWmJV3jCm9OADoxMS3G
			Ial2toDyuIX+IGF7k+qGmdylS+d0x3vlsJA+vGIdnG9t9cAmy9Y2R+9zFou95jMM310N13dW3f4y
			eN+PgL6//CllQd/+GGPO8IUtrn4G4BXwBR7/Zm7yXz7+Lfje/w+W9z79o51V6xKV31Dwjd44E3/3
			xrl3b0SjC++ePPXqya8ZelztN/H3oLmqSLe9skNksfGF7639WNcrG1yJcl1C6tbuzoMF0WYt4jz+
			9NPAM5xkpMLXsbfbXl/VvNlqf29gW3d3Xd9AV6d9YNu2bXu6Gi09CF/H6MBeMKFdu3dX7+7dttfS
			UNO1daBtVHW9Wpx5qETCU3Op/Cp7Vz9Gl7u6HMaFX/gSzhega6fLA9hui+iLa8325mYRhpZWmLyv
			eecFJvvtttUlXIGxjQXd3mA0mFrA1pGY23zuHIE3mZDDBXGeanxiQmZdIXzjWGYE1hf7TqaCPlfA
			63H7Cb4KRXCBaO50UAl6/G6/z+8J0GAFm98dCPiX3G6/S8G5RlgEHFhcVMBzDoYIvjhtIOBaRAim
			F8OUoxRCt0jJyYFFGqOQ9oMJxrzltN/fKoxvgFKMRYcNJGaE+k8qtFIbxkHBIU8oBM81uPg+zgJM
			i3BzABn/vovKiQHDYkwD+VJniLKaA3KiAgak4Yl9vvSgD+PM77/vGsSO0IBwXwT3vjgo+k6maZDR
			2Fh7ayu6XnjFY4Biajct07YDPrU3pUjTwm4bq3C+5HjR+S7guEBscIXZzm+JqPOCdL4ZOX6I2GvK
			vzqmzgsQybunRB0S9p+8ePHE4SOXLl2hJhxXLuVmNQssGzxnRA6zNleQ3LA21ogGIEnwYuDZSN7i
			ld5ZGQy/hGXJSUAvPDIPIJ0DLKpJySKWbYwS5yRycxK74jqCW5yQRz4m2Er8lRDG9WG1mJf6tk1o
			HM9h8+h5yXw6smlT2PmwptPYx+TCejjfnTtrd1XVVsNX1a7azzJ7r+/aXbvz9u1fffwh0PfnH/7y
			y9evP3T9yx+i5/0IcfvzXxB8fyHY++H/9Vryk99SXyssMdpRX7uGFGeDNhh8v3lj4V0wvecWzn1w
			8tQ3JXyXSboyrfXK4UOyOZV5MC9e7X9u60CXg24WmVPE026s0h3oPG9Y3v3dcR2+TyPLeqmfsyjs
			7d68p7PK0ly/bbR7eHTPyMjIbtjBc3v3jO4d7bJatjfCNcdo155tvV29NXsG9nT2jvQOj+wZBTlM
			k3PlyutQmTTnNnWkETpf5C59O8wbiapeyq6CywM0bYnoi2eY46y5YHGhy9GPDLaXeD4Vw6ur8wXA
			Lnjd4FJjqdTSwgLB991zc3GaXg6nUcp2jsUnFmILKbS+U/FkYnJiYiIWm4pis42YDxtrBL1+b0oR
			WczudMANe/R5fdhS0ufGiX82bLTsirj8HvdNP85b8ClOYBggLjS4iIW3i+mAb5Am+oYQyYOK7MMY
			FqU9Yex5gTgUva/A90b8OKfQ4xeDCzBWHUBzTLnFESwVwn6OYZHghD74fUxpVqTtVRapDReNLEKe
			OqmMWEGvHfZhCBoo7hOrxyFs3REO4V8Vgz5grRa0XnQNYm6YyLQKUTtJG3hd5G4Y2Ys5z614cCFR
			wCSzrXBpmoqTImIu0yqc7w0A7w1yvGh+D1+gS0ua8zXD12SBdQn8vnGUcnhFd6xTOI/wNFUlvYN+
			+K0PzqH7NUSLwfxqo40oRGx0vrMZkeoM/BUeuXQ+lUjLOjZ95OWXXhY6cgJs5aVLl6bPzGFseWJu
			LkncnVGDxdmZvBYmnjA5XUCpvLUgAk2NUScmpqlSPWE2umr8WoawRYVRltKtRKkTWl/B3UtHMPR8
			g8LN2MTzwno5X0y1kt+77q5d8YOk3buQvh+Czf3oZ+/t2nX7n4HEH0nn+zMZc/6IGl79X/nXP27B
			ds5fB/bevr27fjfDd5XqO/fWu2CcPgD8Rs+9+83/76unTz79dP/+suTVekkeKOV8D5p7WoG6tm6F
			fwMD/f0HuwV5ZZ+MrQDfAUPM+ZAO3wPUvVlta9W7DUuM9g4ND3SO2Eda9mzbJhpNbhvtQSgjfBsA
			6uB8R7uBgD17No8M1dV27rHL4p+CcPNyGc4GTzqEOc39XSJr2fiQNlrwJbTamyV1e2ngIfatRqNL
			xO3V4TvQpTpgzXObzO/qnG8c061SQa/bm4oFU0sxmi0Y+yCKH1PY4xnbbGA97+s0zwiNcXxqKjmZ
			APNL034x8Sqo+FyplNfjgTOn0+t2h7DcFgDrd7twzVdxpxGTYH69AUy8CuJ0I8VL7jeCwwveV8CT
			DlK7SLSgwKfBxbQcYR8Ry6OYqyyTsDCnGBtaganEvQKDMb/ZH/IRcDG/OCDSmwI+kT2VDkTgCDG7
			WcGkKWIvZWMpgy7hbhH51DMLV2gVwUTqRYV/AAToGQMuHMLgUgaV9500jUGBLV24MIxxZX8I86so
			zuyniHMYLyGJ1UXjMA1XkGlXKBGKhoNdjfMlzyv+0fdh2WWD1nwPq9nOmVmdv+R+C+n7xjE5toei
			0NiMA9gLXlgUJD0P/L1xJkd7Updk8+ooX8Bs1tTaeVa2fRZ+N6PGkwu6Z4DdxWd6+eXDCF38d0QA
			+MTLFOG9QmOXEskZU2pyhpyvAZ+CvzkTbvNJna0Tqu8lhysuCJ2ZSJzRtiDyJhKyzyR22JAL2zmq
			NYKjmT6Ww9xn+CPnxgUi8Am0vuvgfIG79fT9GU11Nr/Yhvrd17/82w9plRes721MsyLj+wsRdSb0
			UtXvJ/l/afn6J18H+H78x9hYo3593p8NBd/ojdcnX79x49yNd6NnbpyE/83f/OK2rzlaCltMFvVu
			Nthbjb2d3V0HtURnijo//RwI4NvVPTDQTb0huwWBuxG+prm86H2FOgcGOrt7MeiM4xQo4bnFUm/t
			7rburmnZuwMev9cCTB6xd3dbRroeQufbDfDtHK2Bfe6t6bbU77UPbKkH4lXVbu0SIWdTuHloOezq
			Bldqq7S+/Wq6FXX06MUm1QRfVZ0DAr5dFH+WX2r0Ge4oT/1Vrfli54x4zOtOxSeWFqILN5cm4lT7
			C95gQvTXwI8rXPaVUwWBtxOTE5NT1PIZ8RsT8FW8NrC4LmfQrXjTbqwn8vrB8bbSwCPs/YxBYsXj
			92JDKrcPzLbiwtZPixi+BQDT3D2AoC8s6nLSYuqPaCaVDoxFQosCw9RhGXOh0PkieYHEkfBYKEyV
			RIBoHy7BYldHCTv8W4AyqgffVxQRccZ4NrjsfxqkpGl3ejCE03vToj00Zo2JVlgEYSrPVVxqjtbg
			P8kLLsW1KLwsWWuD8x0b86PjDtOSL01HCoj+XGGxNTV3FlMa4G+KlTvfwwXoXSDnK6LOiN8rxloj
			o/E1hZ+BviIEjRfeQBRjGPrI8ROnL1Al0vPPP//ii+9cuIJNjUUOtKi0zVASc04U686Kb3Mylmpw
			zcusGJ8+duTKywad0C8KFwwsPnLk6NzEhMyLysp136zJrlKaM8ap1QRlNfnZZHxFtn5CElj0Kp8T
			aVtiVzIIjdnTaoJXFv44wFyxHCVbnZvOiTcud+YK/sFzQVvxXbvzRfLKr8++dlsb6q/fvv3bD7Gw
			97fXr3/5H39O9AXv+8lHPxPslXVHn7z2L+B5v/7rpzY/89jt9Xt7NhR83333RvTcyRvv3liIRm+c
			PIVx5+e/tvXZ7tLe96BMdj5oyKsSAecDB56mRV1T0PnQgMOxFeC7daBzKw0kojJdynYG+IJh1FOu
			ZKIVhpx7ZfPmbr3DxubO0S3dnTWjW1s691h79tbjPraM9lRVjXbttNS9B9cAvo7R+i2jVbD5nr2d
			vQPW0R7rHrDd/c1lummoDaaK78LNdfhSu4y2ZgdGju3SxxJ+B7b2CuMrhbf205ovXjbW/+I1uxnz
			bxtOVwPfBAb75qLxhfhEMr6wtGBbwiEK2PcKG+5hvhXgFuPPr4P5Bd7GSUkwvtFUbCoWh+/YVMrn
			S7lSisfd6nXjoF8EqwLe1u0BxrYr2FojAMYXG1GFPF6fz+MO4pKvE8cw4NLp/28RCLwIGkTfu0hL
			vSFqDAV0wrCtEggAzRbRQvoC1FojhMTFMt9IJOwHyI5RODfkSysuH/WNEgOHqEMlVilp5UEkRZQP
			AT/Tsm9lOuSixWJBb4U6OBO3xWL0op4fDSadQIyDfrFECekKx+OWkWYbnvnRQQvjG1J3FaY/G6gy
			iUAMD/dRy6uVO1+cH0h+l05oSVL1vZTtfFh437Oa7z1rjj0L/L4h8ItZWKoXfuPYG7QMTK2gCb7/
			f/b+9anNO0/3hbEB4wCxDZgIZOnGgCULhQgL0G0UXOuNZzTl2bvGU5lJ78crZtbu9IikKlbc1dM6
			oYM5+SAagQ0ICI4gBBHvqt68eKq6ilKjTvUb1gTFu0nixnY6dk+8evdyTU8y07PW8wc83+v7+92S
			cJLpEPdMz6zkBoROCEEcPrq+h+u6FkuOjo4ODA5r9NUEtTR2zls7F4xWjRUaNIu68TS9kJuJzz8K
			W8IvV59xaeC6OHt9YD4emN42kjUeyjVpheAVflQ57RvYroi31ZVDCFGAz7Om2fl5jmsD2PkYYa45
			T05NTUwRfLPrmUQiPjGpRTPNJOQvOTknxp1/L8q37OvBXvy4e+1t9g/uQN3+8plb93+OJAVI34/+
			7t79HHxZ+v7wvz/o7e29ceSYPd2R7vh9leS/VvBNbCSy2eRobMUfziYyyeRyLJNJ0v/OUvM+MnL1
			vc9Z8JXw/ZZI+9uWmvASQedCYx20r0nfoilfYLgFfNIbG+uP5ND7HVSfTVxwJvyKxjDuTV/XUqGv
			gxCuq6jQ62uK6/VM5LriGrpXHclN3LVOX0c3NbbQF3HVV1dfUmNsNDWScD36L5SaC1lcqI4b6+Sy
			biPvDx2s5+avVnEW0leWm4Xu1eBbI/q9xrojjXXbWr/7Psdv4+COe778x82/MAPC9kV8bzU1e1e8
			sNcw+DlSkJDr52VfiOCFCMav/GH/LDZ9fV7oXn+Arrawb0ZDQ7W1yWDwE3GZvg0Nra0WS4Nia8IE
			FWauWptaLQ1WhYSv0t23FlxbU0jz/gPRF+PDUd6c9diw8gvLScQWWEVIkRWZ9Wz6CMMNoivxtSnK
			jpVEtVbeDuaqdFQKWG3AGPrVat5OXsQYsfQlIcyPiDfMU0cxJdbgsplJM3OusFjMJcCyXjbI5SSb
			EME2xerG8i/fB+BuhfCFsWSrsNtim8lWD3tr8DS2iDHyCJyzyubcxB0pX+y+LIi25IIcu1rX8Csq
			z4OfJ34/p/e77YD+xS5S/8iGtMGKrY/Mjcz1DzB9eY03N9kswEtSOO8S+TlJf+DujJ80J8nHS9C6
			4n0gj+CBS9cLcCzxq40n8+pRDqho+OYtnPsK0cs85jEvIcULrSuFA6Y4/Zwlqqv5FwuTU8NDiZnJ
			iXgmsygr7tx+niYtrHV8fy8936+V8kX5eP9+e9utF+4QfH9y6xc//1BK3w//Tmv4amXolf/We+Rn
			76RPptWOtPNkOv0VA3wfOb5W8F3JLGx5s8lkZuYhwTe7HlvPLmzF1mPnjH8jQgYLHDeksfN2/H5f
			LBMdEb5TJtORgrReoiDQSMTSIROBQKpn/NJHHTSwkYj2/frXcjPP3/8WU4wfCe1eWaJuYbksUwV1
			4ma+qaJCV8GWkzodAFxHX0tfhPsYieyi4Qq7jc9MOH/OWu/BQuPHo0dN3NttZAHbeKSukdeGjubG
			mDXi6njayiQucNm5Pncra2SWyFrT9xHoiuNnO4JvyE9g7fPJep3Ph4WjPj/9SfNH/AgU9Ia9PhK+
			yFrwRRYiPg5cCASXQvB1xsCV3x/2RUjGhv0Ra2t1M8FXCSu2ZkszEExyt9nQ0FDZCpfJSg7dJX1s
			aWpqVtZI+NJHykwH2OvxoCpMItecMttksGDUphCNOb43KnyS4cvsYv9kTixqbeUIXmGqbLWhcm1J
			cb0aU1hERCKxJbUdvZvi8VxMdmEeaYtaLMTGBjZ8FDkINqGNYTVpcUU3rSn4fpgVi21TcQG+BjPD
			WawNcXG7CZu9xN7KnlbeNwKM3e4m8YKBu75yY1h8GUIY3G6X27WDnm9/dpHwS+zFCUvfhbzy1eg7
			8Dn0ndCqz597rMoxrNWhocH+OeT/XsP+ET6So4MTQvpOjuXjfaWKLOjwbocacbeP/53Eib0zYK8s
			NQ8QyyfnC2vP16/zyfUB+rj++vWBwfkprBwFZLk436Tlf6ChqXwI7+S0VN85qu40jLBwDYmUbzwx
			NTkxNJ+ITw1r9MVrDXrtAPhyz7cAvl9R+RJy24rsdh5zTsuTtlKwuLQjXdqRQxaubbOni9raSDly
			LFAR3aOjg+7akba3pdMddLMd94JTVtkTmlLEndLyXJv9D26idQuhCPvT6VsvEGN/dffDD38koow+
			/PD/1XaMWAfT+3977mi6TXpAp+0n05pT1jfw/ZLHE4e9CwtJP2nf5FbQ6yPRG8tkE771TCxz5VsV
			Z771ve/9xbbGbz5AkGervsUt3m+Bvuw5pdM1Nhrz8D1i5FyECj1HIrCSZZryLJXJ2ILqM0nTurrv
			aKVnqSElW7VIBb1mcqUDbrV7sNWzka4BfEn46gW2cY7P6oTrVCNbLue5+hnu/u02z0cxlFVfIwaa
			6wo+THVH63NjzGK3iF8J6NC9zsngfUcEeiV1jVL4sv/G76HnG+ib4T9uovnV531rweddCQTovNcf
			kHu+YX8IE8+kfCMRbvcGgqEgAgZ94XCYlXCk2xrx+xULPCYN4XAkDBcrPkj7NlhslT02IlprZVMD
			HCYV0oxBZclgVuidyEtvqDjD7SLlMacUbrZyqxRTWDZGLhaMouyxEe0RghIikmDOZpasc62I/GVl
			DAhj9Qh2k9giyh+GTbN0i2bzSgunG9BTdcOEA8VjzFObOc9BOEcKA0ig1yaUtYteK2DRN2XxiFRA
			ZnSrhwOXeM7ZDf7iDTqY3nlwWkYA89avW4QUYi6rh15S7CDViMRuomATZkHswhTgV4Qbbfe5Kqg9
			T/xLB7eBV2HktL6xHhsZWec1pP43pyRfJ6XDlRi92lZqLhxoBnfFKzT+NNM33w/dy7L30urE1bFQ
			aHKosPd7HezNad/rqwNDM9JZA4o31DcjZpunZTTD785f+LIHfLa0RxNlZ7C3PxMfGhoepoucHTE+
			NjU0v5gbdh6Ze0zlS1hNnzzO+LTbd5eQvjtu7ygvK+vooGt2HWJedhSVP1FeWtTWUWR/p76mKN1G
			75KzpWoH3SCYTGfaSks7itroQfcWpZ85nD7+8vEiNZ0+WQRK0y3/fsR12637H36Ezu+HBF94Tv7o
			Q8FeKXzv3//ov921d+wVGQrp/SdP2ju+MdnY4XF4JRDPvOUdSc4lAwtebyKW3FpY8G4Rg9evXLl8
			xqSveu1bFY/MO+eGrkiSHsECr9H0N3+jWUdeONuowfdvmL28MFQBRPLolE5iVCfQBYMoKMz678sA
			QaaZvBNLWlmnZuGsF8o3j2TBdXyXRp1efiV/YF5LSM5GHEcL/ay0c1/sJ1lfL72aG40MXile99VJ
			nGqNXlb7IquJq+V0sk8u/uYQLZaQTGg+7/vMyNeOe77Y4e1DlRlqAzu/9B/NH5jxJZBh1NdH0PX2
			0RU+RCiwm2RfMEjwDc5CFWPW2c/jzxGLgeDb3Vzd2mAg9kb87N1sabAYlFZkCbY2NFmbra4GW1Ol
			x2IlxQuXSYuiKBboXvZKNm8q2LqFZ7JNmi9aN1HTtSIXiMRsA2fx2UBeyEoCbVMrL9dKZwwr4R2N
			Xxs3ezEBbUtZ81aQtzcxKEWEZvcO0VTmjq3LqrDfhUj5i7osBpaxJFk9dApzKrdF+GUxQc1mBU/T
			Jp0o2diDA34bXOj60nt1tadVTDozh3GeE4/cHt6Kom/ZQ+ytxHhWdY/HuoOeLwE3wUVnQrAPQ8IL
			28vOzF+Nvo+Qd/vM86Q8ncxrX8bvILaI5/oHBvp59nl9ZHR+Spuj4v0i6fuosXabkByfFVlYcE2T
			9I3HE5eYvELnrk6MhYKB0OTE8PWCLrAUv9dXEUJ8/fr8fDw+E5eKd3r8i3eXHvMYL1S+E1PshI1p
			K97FQjYjXmMQfAV7kwRe/KofV/l22A/euFFX01J/vM1+os9oP95WVF5GepXk8JFIdxHfpUM0hdPp
			qsbuPpP9sOncjXrTkcN2wimuJ/Ur1DAYbi9Lp9s6yvacCB9JVwVPlJaXwlW5rMheBGD/u1lmSt/9
			xS/+O2acib1/9+HPf/QjrjXLpi/D9xe32ux72QAa7lgc4/sNfHd0HPZms9nECn3EEuvxTJZeO2cz
			W9nYQnY9efmTy8nMG+fqHvz6e3mPjby71RGTKO/qWWJK+NbVXTir+UYeQeeVbgR5KwQ2UXfWixqy
			sQ5FanZnRGv2CITvEYFeoygx6zWc6oUI5kKzTg5kyYgjVr4MXxPuY+LnpBMnPIFMyldOXUlP5+2B
			vjkAF85CH2XvDJOUvjn1yrtEmq6V8NXxyrKoQesE8XFznVGDtJTKddukb832td8d7fmG4Nkc8JPW
			DbB1s99HasPnW/EFZNM3QFdxnC+dEFaDfQxf3IeVL959SoTga+huam22+CM+SF9FabY12Ej7dldW
			NjQ3NNiamxBjZKlUDAZCL26x2Ai+KWavwm5RNquimKNmkZnggf8UerYW6YncJELuCWmAr8fV4Kls
			hYEkGsJMXxLCbCjpikqPaJdZQPe21uvFQ9tEuC7mja08dGwxW2zsP0XCucntwTaRACuPOmNSymUR
			Y8/0/T3s72FOmUXf1ib8PBpwK+nmHrFlxN5WrUKgt7b2uGXcoJtnwGRwEm8Ck/Kltx0oX0YuTuZZ
			+LINxFz/Z0rP84NDExO5IecCDayh9zMOWHIOa4gecBRBC4Ni/mpubnEw7/nM2b5aoXd7j3dsPNRX
			UCvmfzdY74kv9ufIy6AdnBgbD/i8UxOrOfF7XQOw+Hx9AG/zE58x5/h9H4XhwWMkdCeAXnrhgg0s
			EYzMW1TxdU34ct35cZVvaTodma1rq589savjnN9kP0mcKW0DQNMls4FtvOowze4rOUHquH42/Mzx
			Zv8e0sDQugJO9CVgL5dqS8vTD2aPtOmD58DcdLqjvNzeVuT8QxedC34W+wv3fv7fSe1C8/7o735E
			8BWtXsneO/c/+vjWsTZo345bOOhrHi/O6OsI30Q8GQ8GMslM8vLl32Syl+eCcW8ikwlvxIi+y8ll
			ejm9pf/1Ef33/uaRIMHvV4CCLdKzygTi0YU6Y+OFekFfTSKy7GXlq4UD6ljSgtcQpibOAGxEOO9L
			AmLMcXrgChFpJLaDhRiukCVnsetbwYVofuQjdTrxkPIU8BWmU9y0rc8v+35ulqC4XCNzAOtkbVmb
			VRZSVlcwXyXoK0rjRlkJN0rsm/J3krpX5Bw1FmvsNRU6d+ys59s34+U/mCLcFA7PmC71vuULeOk6
			tuCIEJPZWdLvjYR9/kAQqPZF2G8SJhvhgL+7m9irKA3NzU0RRA1GFIO5Ae6RSKw3NDU10FHZ3Opq
			Qp9XMcBY0gZjZ0jfTTNdQ2/yEwKPoDJT7ADpdgG+bATVJPZzPMAaUc3maq1ujXL/NmW2pWBoFW2y
			AZU2a48HO8Me220etTJsKpsGs82csqVSNpmwC6cqDDwB7ilmPAO/0p0ybNoUi1ULP2jgiCUZ8kDc
			TiHml0OUhEkV5qewKdyKqnWTFL6y5NwKsuKTW5LYzbtG+EJYPvNsNPaSdqB8E4vzPizDeEXuzkI/
			vfe/1T+nLRsVhPROTGhq9xGjq8mJzwUyS18SeVkEE3L/F2kCiwTLz8HWNiyOT4fgTYUGRhxj8n28
			owZPtPj84qVLjy4XDU6O+99a8I5NDDzS+H2dpO/g9etCBV8f/mrk/Sywx75IMY8XXD82yT98P154
			xDX2ipcpiWtzUviu/x6UL4RqZNbU9k5o9qD9+MtE0ZNtbW2HT6ZPpo+XjIc1pZomcdt2rDv0ZyBp
			+mez/pdPHpltPo4KNN10nO5AbMWl420AcWnH8QdLr9nTLx+3F9nTxyEb07vsu38/M0u/H/rypPN9
			FJ5J+f7o7/9eNHvvc7sX8L338a2bt+j57iXBe6vj1u8j0ehrB9/sQnYlEFyPra9f/g39c43FAhu+
			uUwG7d/1TIyIvHU5duVc7IYxL31l3ZlbrWIdCF1P4V1FoGu8IKrOYl+IToXy1etzxWIdb/uaWJhe
			aDSdNZ01NhJ9X/u+mHQWyJWNX554rhBiGeekLKYLu1UHV54rcL2xrl58PywomUxgtF58A1NjHR5d
			IFd6PH/+8tHBo5qdlVgmQjhSQYs3B1WoeZNWdhbPl+GLFxp6OYilTV1p0851BdtG9drw81dQvmKe
			tA+zzrOh2b7Agu9t7wKJlgUf/RENMHwDvhCEr7B19oYDfaFggADsFUtHQS47+yyGQMAQaWjobuju
			xv0iCrZ4LQYMKSmWpubq6qamVgPPWKEdrFg9VouV440IjZi9ChqCeMdZA/J/iZo2MyOQh5WE1xWX
			eEk0Vla6PTYSvk3oEyvIBTSbCdY2dwNBmXWs1ea22gybKWXTYkNeIZKGbaJ1i1kqC+w4xPKtVUkp
			isdDqAbYLQb4NcMtC3Vnhj43mjEWbUVPmhAPv0ibGAjDtJeFB6+aMKzlRsuX932redm3p5LPVMtw
			XzfUuJC9Lk+tMH12fwmTjbzyZdN/jnsXHsTSfjjTLyyuxCoqjzwPC3RM5Ld8J3MF58lC6VtI36GB
			bHYRGQti/GpwkCA+uR1k28IRxniVCP+CZgJAL/+L8IbGMY0X92ujVpdy5BWfrw9NTtK/kZnJ1et5
			7Xv9dYnd11d5+GoVivsLwo/+BfRO/nBoamr6SwQXbqcyfCW5igDhOz80KKrO9BuZmphKbND1l4Tw
			/T30fEs70t2zdelnZkPFx+p79el9N1qORrrfebn3wWvGWf9JzFMdb6w60qJ7pmhfIKSrIcJ2fGfW
			/0z66HjgWM2JxnMn9tjfaTxRcyNg3F1VVdddR/iu66bHmK0/vq+qN12kM9VX7WuzHz135Ibp2L+f
			wnP6/Y94uYjbvqR87yHU6F6Ovfc//MW9uy/cgrXV3v2EX/vvib5fK/jGVhJBvy+TjCVjI78ZuRw7
			vTXj38omfAtb6xm4PV9OxjIZ4u8VHacNyjAjfBbDyByVQIJX7OQSgc42NvIENOcoAEGseysEOzWL
			ScFVOujejWdBuTqkAJoEffU6rUEsOUvCt4VVpmjwii3gsnaVLhil8jU1CtNKnXaqF/BFt1WHh/+O
			wO7RfMbCIxNYf3tU7vQK5cuAxSavSZcXuyY51ywv534afkp6Y24Cq0AeS1DjiYiurxyCrjuaqz3v
			aOCKRMrKjB9NX1Se/Qtvv72A2Sqir9gvQoTvgoju5fkrUr7BUDA0G/QjXEESOIyQ37Cvu5kOVK79
			kYgSeWBVzGYhZQnAPqvBYgnSRUsUqrfJYlNIAEPsEpCDa0xdg2GJPuM8fZ3ZLMrP3G718HIRMg5s
			tkoISk+0srIyilFpNs+Qc8wNrT1iVsptRruXlGoKA1gcmJBKbZL2tXHYITykXW4WodGU1WzmaCKM
			PRuwx0syOSo2iEjRch8YoUr0KsIqwoZb3VZeFcLYddSioMEMDDeRKIefZKW7GpVnVsB0Ul3JVWgU
			osWeEZ58T20PP4CbHvfLK9/5BL3N8wfk7zYD4rnc0Z+Db2GHt7Dfu20QOl92Hh6kh8v0z0sL6FUI
			wMnP5xaXncenC1yk2P0bhi3+vukQ/6uIx8WoVUF7V/D30vXhSbpL39Sw3PR9XYw6C8nLZ4m+w19B
			9k68OZqklx/Z+NT09Pjvks5SJCMvWKC3n162DGW3skP06xvW4pCH4hl+YXPpkVWjr5xqZEfZ2Vkf
			0h0/1jzbktbP+o6Egz9rnt1HAjecLm0raqsK/SydDpxIv+wPlbB4PTobfIeUb6Qk1NxWM3vu5Mvh
			2Rs3Zt+4EapJdweK0y8tnUsfbp597fi52eaTVc3p9J/Vt9UEj6QPB1vSpfa2PzR27RjuTt984Rcf
			cXYv6Av4CuHL7L0vroUB9K1bbfv3lz1Rau/4/dD3awTfJw4nVxILiUQmFku+Ghu5fPmVy7GNlYUV
			XyKzseUNZzPJEfrIJunaa28f0RF+v6dl+35PLxuz3GutM/H+D+aLGxtRd/6+TqrYPHll51av4Qp1
			XN0F04WzrH1ZZuZ0r2zw6uRjyG9j5HFpbgQbK8odKq4U8AUntXtjhrpFDkFBcBJ8sQxcwN7PWE0y
			gPN+VjKiF71bXW6NVyBUJ5q7vI9syg+FCdUtfgdGU0HhOTfuLA2e63PWG/S9Du4Yvn7o3hm0d4Vh
			UOCtt0nj9vkXUFTm0RnOLfL5uPLsRw6DPwj6+n2oNwfFn1zSvgHSrQZfc3dDgw9hC93o6BpgpGGx
			NpgNKDU3WA2EW9grW5D6a8MZAlqEYEu4FaI3yFXpNewgKTYOTxA7spx31NpEMhFjVR5Xa4+ntbWJ
			LgGuKFD/A3stm6OVNoaoh4C7mUqZLRaLmbeGbCkryWybTVFSGJ6yifVhPC7hm67p4QAkT4rgq2wq
			YDpua+ClICuegpm+FKVqaOJWEbfggkWk2RLlIWYXhDN2i9y1Pbzsy4q3mlUvbK/wRq8euGdN/K3t
			aXIx7ek5fnnlC9E7Hxcf8XlkvLMTcVZMXomcQbbf2AbfSTla9WjL9zO7v+h5ZhcHhjQHLJzJJSzk
			5oIFesfHhV2U6PHGxYd4D7BhuN8/L/q9ecmbLz1fuj4x7u+OBCYGcnPOAsHc9OXq8/XViR0XnseG
			FtmkK7a+tb6eKfSn/lwBLOE7FeeXMFx0nh9azMQH5a9vGIPOifk5aXA1wvR9bG/n9MnIbFXNiRv7
			7CdPzFYQU7tPlhx9bTx8nOHb0dH2dCD4Du6075mwhO9rs/6Xj50LFL/cbEwXj/vSJ7tnG9M1RXXN
			T58k5j6zNHuw7Tid6WiZbU5HQro/O378mG/25ZPH/f5d9rI/NHjt6F6Tlr2F1u5dbPd+RNKXh521
			QEE6PpTHvRdupe1E3712LkJ/A98dHIeTWR652sjGsiR9X9249srlhM+3suDbWF95+BCuk1vrW8Tm
			ra2tK288V/GtU9+XA88vad1bsWYrKsoYnmo8y6PLWiOUECqmkrXKsV6OBhO7TGfONtZduHD2LKBG
			8EUVW6cXhWo6NdbVmVqk25XoLIPxon6tr1Lb1aoKHPoWVKNxE92RUY+v42/DdeNGPHZjY11Noez9
			rPOG5mklxCm3eAVF9ZrxR10exOIWk3wZobV9jbnxK1NOK9Mbj19x4flIfZ00varT1o+O7hS+cHcO
			+LHUMRua9nkXAj5vX9+CX3gLsfJl3UvXhjjVqC9E8F2C7g3Sn1gkLAT94UgwGDDQn1Nv9xuRCL6m
			22K2WKF7SY0q3A5usFqbbRYDKsA2G+w3XKSAzdznhSA2rFksgr6WtSDJXwXTxTyOjIBCbOO6XZVu
			gNvTFIWOJJgRSVM2W0rLObCapUEkDJfNyAy0mjmLkBdtrShjp0hRIwOQraV419dshTRGS5muSJkV
			86aBcEzwjwrbSJeSwoS0JaqgNYxyN9+XdTj6wVYR/uBGVxqzVkxet7unVRSgq3n7qFIgmMew6Bn2
			9NS6rCR6Xdiw2onynS/EL9efF9mKWJSg5fbRIhttbJO+249HdoBzHd/BQTze4HBO+RJ7C9qiuZDd
			8WlpcAHwxnPo9Qv1yx3fuB/9XkHVbco3V3seHpuN+KYnBzWXDcFd2fAdwKWhyZ3ON48NDYzEYleQ
			ULxx7drGenZmO38fObBqNDmjxQcyfAfnUXeeH+LXK8TebH9iUIy1acfvSfkei4Qa7b3jgG/zyfTJ
			G7MRO8PXXnb8z5aCxwDfIy+Hlxi+6aOhkLHK+Mxxe/rY0zq6U7p7/IjTnk4ff6YmPPvSt2eXXk5r
			8D3ZMj472/3OntDskZr6gPdA27+P4KR0+tYHdz66c/funXtM359/xGmC9+8I+N7JwffDX/zqQHpX
			W+nevd94O+/0OJzJBBPZRDYbj5G+/c0rn85d/s3ljN//ljeb8RoMYV/Gm0lu0fvWVmZr49XnKk68
			JHu/goJ6ab9sMlXwOhAPFnFggjZzDBxWVOk08upFs1fwymS80Hj2AqTvGSadXirjo+2dJn39TbVL
			VR3FXL6mb1NfphJv1c7iFkJ0m9rZ3u6g2zudFRV0L3q4OiZkZ6eTvkNxp+OIqbFUdRQBchf2OlSH
			w+F8uSZn8vzZrdtGbbFXVp0lPmWRWyeehVC3orCMTrcut40s96iE4DYV6l6jNrBl1JaWTHkAc+93
			B/D1wsUZWb2BvllECHpFqKCfGAyDSczNeP0rKDaDwP4+XySAVIXQUjDkDxN4Cb6IX4AIDhoCvm5f
			pJvzF3wRS5g0rQK+Wg084NyEnCO8I/O+tbWSbvLYFAtq0rhZUczKkkJn1kgEr60RkitIv8L80WNl
			mwpXa2trgw6LQq2Ab2VTkwWZgMgDRjcWj8rbuE/qUdxNVdHjWaNWjGRhqhnR9U8plpStBzPPVnDa
			DRtLMzFbicosYU8Ku0+bPPylIAnJZUXSEqlbi8tshaOVC5GArSIUkIeYrS6ewAKIm1xNBNdqxm+1
			m9Q5IgW57YsprOpqulhd2cqF51oelY6SVif87kz5xofmMRM0L1u/2pFAGZpZjCv/RfjKAayJR5Xv
			0CAeKMdedn+efGSyimeaZwIzMzK5AP8y/DnuBuaBYT+/excXtSVeUVN+9FidnCIFPXE9V3jeVn5e
			pbehnUrfseHB/pEYsLsR28Dnaxtb2SF0bic/F8Jjk1NS8gq7TnrlIX6bgO8EbDcy2XkB30vg70gB
			fL+q8rWDq3XptH42cqx3tiIN+NrTVePdacxVQSP+bImULxrDz/iDgG+ZvWbW/w4Wi463nKg5SvAl
			5XvkuN1efEJf0jx75CdLs08zfO0t4w/Sdn1kaTZSHJx9+Zljx45hcusPDV78zG23Pr5//6M7d+4S
			be+gxowC9B067rPwvcNV5w9/xKcf3b11K73390TfrxV8vaPZRGIly7mgyU/XvYnLr/5mI+td8G7F
			fIGHYW92gW7Lbm0Qexe2YtfOnbjxvW+h6PySsUpip0XSp4Ix3IiisOZVZZJlZzbCyDlW5drD9H7h
			bOMZ+jhrajGZzhhFY1enr3E4TYdUp6NTpfciIZWPdRJjO4mizl30CB10ob29na5rq6hwMnz58XRO
			h6rTE3zV+oMA7i4Svocc7Q5HOwIG28SwMUi7bdFW6F7Jw/p8y1fCN1dXNuZErhZlJIrORtHy1YvX
			GwVhC7mdYDG1pTPlfTeMksD1O+35wsbKB5cNFJX7YPLchxCF7tlQdwh/VyNerjn7fH3YNaIzaPku
			oegcCIYCWD2CAuaMX9C3me4Nv+fuSISYaiZpa3iorBmswnXDajWAkA0NrQ2Qkx7FbCWJrFi6DX0W
			JTi7//ixby8pwaWlJWJ5US0kqssmerSumjLn/n17AfNWG+Crdx4rd1kJkt+pj1ogbtk+w9q690mS
			pQbDSUM06rS4nB6b02bDvFXUejJlU6qKDQpyigjZJFbdUZS+LVZe03XZzAYzEhgUrjG7rByIwNYa
			JHtR4Oa04GhDFMtFXEMWfpFMY/hj8QAVhK8Hi0S87CviFiR+6RQl60qOHnYjz9AcCad2onwxiivw
			mxO/8wXn5Bnelhn+PP4Ob1O+2weuBgcltqF6ZfTCo6mAV8fGQgTfuNbr9feN97GTFcDr1xKE8Jpt
			vl8u766uDq+ubgfwJUnfsausfHOVZ63dK8Tv9aGJrwDfJGQvfEKuwanr2sbGnOSqDInYdv+4tCmR
			1frFgcF5sW6EXxLYm0mgGgD00sfvR/nyqlH6ZMVs9/FelJ3Hm53pk42zgeMSvumXg8Fn0vbI7D7u
			+eIrjhJ8sVZUN1t18uBs+DiR9gihuDtYcvLB+JF3lmb3nTzevETwnW227zl58ifh2aOBpSMnsb9U
			+u8hPanj1q276O4ScUWO4Ic/v0vcvYuT+3zlR1L3Cvze+yBt32v/vdD36wXfWILgm8gkSP8mL7/i
			S8Rin/5mJONfiGW3/MEwqaq/zywkk1tZaN/1rezCG/pT3/ubb31LX9EsNneF9DOKlSPZBT3CW0M6
			Hj0GfKsqxHqRUVfoW0Va1fg8Cd/nG88Qps+asLgk/Jxr1PYSVS0mWB1S2x0lgNwuwifOFKudjpeN
			uuKDxNb2g8UHi/dVVKntTuF2QQRUO1Wdrq7YoRYTe0tLDhpNxN72ksa6uoP0uRxWF6Q2c1FFEsEH
			j+RDiOoac+w15kQ6PaZJL+kr6s4CwuLnl2u+7PAh2KsvXAfO6WCdAG9uBVh+y515O694V7zeFQ4x
			CvV5Q36xq7kAKRMiKvt5wdfLAQvePijlUAjukgFfELucQa47g7whfzAYiYQj3RGsH4Uj4TBxF6o2
			bHgYIZbZLNaGVqAWiUENra3dFltDpa8BhWiLYggaFMPSktMfjNSUmGqqipxFzcer9c799U1tJ61l
			9qetpHIdra17j508Ynhnf2mltbX8wabZWuy0R48eqU07n7adtFYdeqps/2HHX+6v3bQrTkvKut+9
			b09d1dNP7nUeVMrLmsqDTzuPFxssIKotCmTC3cqs0BPiGCQPRq0wF0aHi92fEbLALWIzvWZAldlm
			lbG8Ta2gsEuB0TSWfdEehtM0dolQaSb81ta62d6ZE35r6a26thZTWK1s1uUh1etKmc2RyJdXvgif
			nxkamsIJERisjNP70OCghPIgLvUNDcm8QA3AHKMwwSlGBYXnie3OG8OsfPlL+N7D+arzto3Y6Xwi
			Pc6EBIS1gasA8p8xqLco/KoIvZyZRGc+o35XJ7Rt3+uv5+adhVQe5NPVyR2QF8fE4AD8MQV+wd5r
			I3PA5qVLvID16PrSxHw/r2lxVxf45UL+wABMSmDrHM/2J0TAb36k7XGVLyExMl538plIoN4u4Xvy
			5PF3IuOvndw37sdwcroqVJxu62s+/I43VML2kzWzAcJxusM0fsJeN+4/drJ7vB7wDR19pnvclL4x
			fuI4KeX6ky2zb6RP7OmwV/l21c1GDp7cc7D0DxxdSMJ9P528cIcNNT68c0dMV/3dh3ehglGGZv37
			0Yfbj3sfY39qrx1t3/379z/Gj/C1gu9KZjS+4CXV609kYpc/XU/EXo1dvpxBmzf4kP5S+1ayscQ6
			Zp63MtnE1tZC5ty5l35dW6F/4+1zWsVVp5k9SldIvfH7339JukTqBXzl0JRe29IVdzSeaTQ1oux8
			xsQis4VxrdMd7SStKiJ9CZmd6CnTFSb+JnXQuXgAwnIFP76ArxSiBF9ELjgcqnrQZNKRsiRq1wmi
			7nKoJSbTEQT1mhoLC89HanLpf6x+hWTVaYSV6Upyq6gwRVAnp6uN2niZzqStKvMdXuL33Fpwfvo5
			7zu5M/jCWGMG+JUtPK9PTK72RSIE4j7hrsE9XzoT8oX6/D4vsbbPz/PNfUE2eg4Iz0kCMHaRIkRg
			X9hPGH4YVvxI+FUMaxGsD1laq1024aJsa2pqslpbW5ubLBh65v2jteBsW3FxU+CZw5Hap/31R9Kt
			zqZuZ7PT8p136knARq2OpqaO6manx17zTGNrZadhc9NVZtU/XXPknRZlf7Nzreflp0qbqtXoyRSh
			12m22fbVO5uO7ak6XBuxW/Z2N7f1HA+avm1QPBwX6OoBVa30/TXfZTrPqUj0XAycg+ARe8QuW0ox
			c/Cv28XwJe3raWK3S4Db08RVa09rU6vbTa8ykPRb24NSdE8tJrDcIuoI6O0R/O3BhpHVE7UoSvhL
			wDenfAm7eMP7jPaOQ1w9PMQnUzgh4hGbEQqYzy8ansgFGeWsnguqzsODvFokhq0mOPO3sOqcCzzo
			K5y0Qq1EDlzlhG+c6BuYZ/gScgGuOfDvOvTv69sIfD3vcCULz9qsswDw4E4LzxPzAwP9pHo34LRJ
			9I2NzF26BPb2X5q7BNvrQvU7Nh2nJzcnd6NF5Xl+HvqX9P/UONs6x+cFfPN938dVvsfTNZHwjfpz
			N15uK24O33jmhr+75vjJtn3d/nMt/siRDntH2t5yrqTqXFG63ufVPdNmt9N9fKYikr6H3giGi5uD
			zft8/nNEJ5M/eKM+EDiSvhE8UXUicOOZE/7uQ/obJfve2JNO1wUD4RtFu9Q/sPJtY4MNtpK8d/8X
			9+/e593ev/voY0YvtC8d97aRF+r3F3dvpffvZ+0rP30D3995HE5kSfTOZLKxmUQi+enl31z+NHPl
			1cvJxOn1V2OJAP6KJ5LJRGw9Rvdb8L2V2VjY2jht3Lq2sPD2VousxsqFG0arcHw0fZ91rgg/IPYK
			+GrDyNLfGXdvYY/Js0S5OkJvi5xYriHUHpE91L1qO1G3pFMt0fPMk/4Zh3oUApmULftmAb4OrSJM
			SFbR821vV/dxwK6pXG1vFIPLdSb6EhF3wJEJNZrd5JHCoEA5ZsVeWSZpY2UU1fCcCi4cgRavKIzS
			T1oWnYXX5TZDDr5VMjdfj+bbdqJ8gzMkaVdWWK6w1dWCX1gUQfr6tBYw3gOYfp4NocI8ixGrcFg4
			TQZDIZa+uBT2QfNK5RsJY6OoNULyV1EiqDI3N3k8HlhvuEGqqKWhtaGBpDAJX6DZoIT3+ulxnHsr
			jce7D+kONx3W99qb9tvqnu5+En1fp8e1t9VC8G14sqm19Z3vG75vdXYf/X79kX1Hm51Wp/U7JU8d
			aqh2Kt/W1zJ8LU3Ow9b9TuvT9S66bLW29bRZiovFBhNyk2D/bMU0F9q9sMUypyzRlAEOG5aozWNG
			lRn2GmZl04plYREO7OJtXRLEmLFiSy2PqD27WxWzy201RxWsSdVyR7inp6cWVhq1tSg/0xn4WLpJ
			ElvNaPeCveEvr3yJrMP0hhOhbJm7fFm8DeNjan6IwMkF1AHglAXvsKZ/C6auts1A02MNDsmi84QW
			+Dspa82CvZi4Gp9CTSuxmJiZkbkH7Kfh5+6v2DXqmx6/OjZIIF1dnRikJ7eobUCR/N0ufgtjfbe3
			fEXp+fr1He4bTTF8wV5CJdF35BLMLfE+Qm+XFi8NDOEFhUiEAFoXpXsVas4YWcOyFUvfCYQ3jeMl
			yTxfMzAgw40eV/m2Fe06fvjYLjhUFR0+vju961jRYXvb8Y7de46ld+0WtlXpZ15+uagjffz47l1t
			RXRPutcueFp17KI7HX85fXjXYX6Adw6l7c88Qw/0zJ708V2H0+lju4s6ju05dLwtfTJ97Oln6NuV
			7/oDrxqlT9564Vf3pZfkvTtw1bj/0Y/ufSzYK+j7EYIGHzkEfR/b5OprBV9vJplIZLKZkfVsJvbp
			K6/AV4M+Mpczvvj6gj+24ov9JrGQyYzGEhmfz5fZym7FLm8sxJKx9Wst0gVDrAHppckF2y2/JLyo
			uOFbVZXr+RpzHVT6Gt4k4n5wo/GMUWsfA3FHCb4VRrGZ9LLaXiNlbQUbTta3tz8t4VuFB9VX5OFL
			yleV8HW2GI11ROt2x+7GRmEibdrjaK/XBo+1WeOjcvO2zqTJU7nLK+rYOp6h5oVmo06nuWpITSyX
			n7Q5Z+FurZE2V5/O6WS9cduRM6vcUdl5JbDiX5lZWeEtIp6g4b+pvr5uH1IW8CfVqwGY42awa0QC
			lwONgv4Qhp/7gkL7+hHwG+mOWCB8wxElbGiyNGG6CVELJCqbK4lIVmT0YXjKZbG2NliiZhKcZluD
			YjG3Njz99Lf3FTc1lbQ8XVJv2Ffd/e1vV1Y/bVGOHK4H4p5xu17usb5sNR4ubq1ttdG1Su3LR8wv
			6aPf++tTtif/8sjR2mJX7bcV89P1L5ufJgRanq6IHv12NLrvr5+KHra6/9JScbj++4hEIM2K1N9W
			F322CRMPT4/LZlZsJMKJy8Raq0gwjGI6y5BSrDyzRR8NHnrpYDYovIRkc5kRqdDAKUyVlfT6gX46
			A6yqNxUXiV8rgdqNiKWeWvahTInDXdtqsRJ7ibxh8++Gb0755vDKFBZyF+idgjMxv4Oa6+tYEiJo
			9C9evHiRxe+2lm/B1JW8dhi1YaGTBXTxOFjyFTqR4xLkgFI2sx4bQZF2MR73illnvzSTBHdDswJs
			kyApJwtDQC5qG8gDRNXXP2f4Kq965dSzOEg4/27py+u6cmd3YpDhu85TVETfEaje1/uRSEQHqWB6
			BTCIJzUO3Ts/PzQ4ANpK+BJmGbWQvhxNgVhk4jloTG9M38fP8+1oK2qzFyFviDhbJvISitqwj1sK
			O+c0+Avn5nRHkT1N6O2AgSShtw0Zt20ddPVxXHUcSUjpjo6itjaYXOGGdNpJX8HE46vShO6O8j/o
			uPN+u53Ze59Xeu9/xDYbH334o3t379y9o8GX43w/g9+7t06Cvo8p3L9W8E3MZLFslFhMEoA//fQy
			9nq3ErGRZDKTyGysrAdWEqNIHNzKeH3+iM+3tZDZSsayMdShz12p6tXpH/TquX0rW8BGFIL1Oq5B
			Y/MHFytyVs2y7aulK+j5DshC4n1dbXarxtF+QFPJB9vbi6Wyrtl38OC+fQTWQ4xZB5edBXxl3dco
			4Guk+zzDTtOmGtVxUNfSUkWyuqWl3tFeLILuJXyZvfUmba9XWEJrylcz0jDqtBExMfplLASs1sTW
			67V75VTxtgq1FvcgS84FxWijbkfw7VtZWZkh+MIY0B8K+LwoH4a8fu9bCwxfnx9tX9Y2fi+LHVK5
			bOrMBecQXxHg7m/Qx0bPCFZA6G84GFYaGhqiVqsSCRsiFltDcwPGh63Iqm+tbCXwNTVYDLiC0Ewf
			DU1v0+U1gyFQVeyla6LNDVburMJkivjWxErS5aqlL65scMPkIsXZutj3xeSweTPqdqfoog07Qykb
			x+yyyzPbMDfxhpEFe0cEWShft0vk+GJmytVDlDVbUA520fdWLDYzB/BaUmZOOTRz3gMHLhlub24q
			bHvpUrScXsJ3a2WUnk7Kithf5ET0eFL0o6LATM8aPMdwsw3rRTb6WSxmvEB5GN6J8h0GX6c0YSpJ
			OaX5VrGAXdy4tji0OjRMWMlK+n7B5LPUvcNwsiLALOamrTTpK6rOY+PT8YW3FwipU/OLbCI92p+c
			G+1fXH8D9RCpfOmfBgleWZwmVQndC9OO+NT4+OTEvLTggvq9/jnqV+v5Xt9WdwZ9x34Xecek7xbz
			d1LAt18IWqRMMHtHfhwbQTox4/fS/PAkwXd8Zn5+fhjl+aF5pi+vagn4LqLrSy9qJqcn4fg8gAIC
			9rD6fw/KtxQZgR32sjY7ooxAUI4K5E+ldHURbkZMINGTrmlL24uIqXZIZrg4pxFISFd2sHsG8bkj
			zWGDnGBEnC1yctqCXThLptvK/rBV5/329As8YiUWemWA4Id/f//ufclebB59hr2y8mzfu3+vvePW
			47hkfq3gu5L1e72JhDf5SbZ/9PLly5/GEolsJhu7/OrlVzOZTCzhz8aTl0fprC/80BD2LSxkt7IZ
			L92STGRi195qecv3htgpkqmBImaXHTIYrbLlK/HFuzrCqVmMPbPyrSP4tlTptcIulG+xNmi8T8BX
			d1DtdLRj18jhIPiajBp8dUL5ahtBqsNJmvugw4EqtamOMOxoJx3NB5117JERRYCvqDrXa+3eHHyN
			BfCVSQ967fnL9q5mtgHran1B/qG47iUxjLUdvrrtOjhXjDbqdwJfXsz0+1fwGX9J33rLhzBfxBst
			+Hz/3edDIHqAowW93iCMOPzBJeFr5fVD7AZCoSCSavqCYlHJ6yPl2x2B9jUEDQYDscxqQB9YISZa
			hKczjCmqKytt5iaLGVu0SiSiKM0KqVAlGDSssQ+WTaQSRgHQVrFx63Ir0R4CcRPv7JCgzmcWycPs
			cruwdESwtNq4YcuGkm4XJylwCIMVvlQuq4HdmemFgZUXkVwIPXCl6DnCd9pqtbjMitXq5ugjoi8R
			2JJip6uoDYkPsOIgurqxiRxl3+nWSuwcVWrPCDFN5pS7B9vGOIeXA5v/QGf+QYxNW6zNEZScw2Fl
			Bz1fDZusdMXpNL3ld4YIj5mNde7d8pTu4gDBl42ePxPmqxWdoXnFQBGmfDXlKxq/eNipeOaNK1eu
			vEXsFVYT6yNwOs5k+udimSz+YcTjU9Nj4FnBTjCKzsOA1Xp/HN9rcE74ThN9Cb+vX9/e9N1eeM4f
			g184cjX2WQjzC4XBxQHifD9/53UB30uX5rB1tMHSF83ngcHhSbySIKbiNQbp26FFYYmNBWlN+g4h
			1Jd+A8NDcgacIP37UL72DmZuBwMWqldeEsfvYknBPTs6HrnwuTFAf8CWr0DmC3eYvff4lAj7c8Lv
			3/0c8MWiETtefZR73659P4bfRrn91i1O9/0Gvr/rOJxNzgS82XhiPRufS5LeTcYS60Tf5OVYJhbL
			Jkj+LniTI6NZgq+f4LuwQH+tt3wBGFJm6Q5vvR3Lbt3QGSt6UW2WVeWKqiqdBHGFqDuLS3mOcW2a
			a7aQxXqdqQVndHJwWndUdRRLD2cBX6P+uNrZ7ijHv9mbgK9R9nwL4Cu4qDpUhm/7QfacNpUQelW1
			EwdxW1VL6ozSbLmujtd+a2B/JQyc+RuajPlZKwlfvTBt1mSvJKw246XLz3zrC27Ub5e+j4xqyWks
			8fvaibezMIhcCcwEVrDM6494vfB79vW9hX1d339nIRzwMWv7+mZDIvjXL20lSe4uBdHsDRB6Q36e
			yyL4Nnu7oYwN9B9YIcVrU0jidSvY8CWi2jDv5HFVEz8tcL0ipgmjSUItgTcIYi8ZAOk1raHa6oHf
			o9vjVswel5lUc3Wl2w2v5U3zdvymsBRMAlMRe782enArmrTsw8xOkVF4ewhb51YeuIIBFgcCu91E
			TpvVklIItVZCZpRksAsTYuaUyxI1pxQDZq8MUQVe0shqQPSSEiWARz02i9uNfWGrsqkI+PK7LRXd
			BHTB3U0boouJvmari4sBEX5JEt7BtDNA+1n5quUnAMDwpYJIGwRSs4sXB7TC8+ek+Qq1zPVp+CZm
			CIzzg0Na6RmVa/oft38BU8Prmamxmey6NhQMdTl38WJyfWM9Oz+8uqpZYeWwOIHxqnlZbI7Ta4Th
			RUlfUXveJn7zo86vb5O9fEx+IXvHcubM4yJkiV4ATGJeioeX10XSE+atXp/D7i9p30s8fTVwaWBg
			eHKSBO0iG1lxZTzO+MWrjyEuRC9i7ptezAxPId+J7Sanpgbn+/vXH1v5dkDxliHrvqyttFyIX1DS
			rp37X+TgDeP0MXha3Rfil6Tvh3/3o4/uffR3H/KOEVZ874HG4vhQvBUcL9xK7y8rs99Kn/zKz+Lr
			Bl9/POHdSPgymdFMPDGynhjNJLKxTzOZkVhiIZ7NBAOE4Uw2k3hIf5x9C35SWP6wL7OFIKSMbyG2
			lX1b31tRdQqCV1O+VSCxOFsBFmvrSHKVSHhecV8V8EVuQgXrZV1e+WqJBUL57iNu7mvh7Ib6dsch
			SE8JX6OugteLBAx1ouwM+Faw02Oxqta0tLRU8XNqaTG11OXyiurqMHF1pE5bvkXjVl/QosV10jxD
			lqI15mrfTJefutKyIMRn7foC/hYWpLcxWbeTsjPkLs/LoOe7QvrVL4IWvDMzDN8FTD/7+1BWBHxD
			2CwJYWOMnRXA3T6iJWcBB9EcRpM40t1M5A2GAwY/cdRPCjKFwSKLAYrPYPPY2BOZAFppbbCaEXxE
			QLRg6VexLAndawhaIEENVlKIUeT2ssWVx23bTNVabZUAtyvFxd1tunfThh4tfSZ1SfIX3pIeRq9L
			pBIyS10WcY7UqgfmWVZYTXLcn23TEIUjdBQVZyz7WvnlAtGSqGo10zVWZAyT5jXAwYNjgRVCNb0J
			gaqxAACAAElEQVRuoLPuqMWguBVBXg2/9CxYDBN3YUGNk5T1gaWbpH6Ype+XgW+B8tUyigqjirbb
			ZXAaIPs0EXy57KxJ30IAT+b8nlGf7hdkJKE8IBq/WDTiKiuygt/CINJQYo5nkrg7OjRI4vfiwCjB
			F3JykXAKOZmXo/MQvryek6G3eXq8xYLQpZz2vf4IgT9Td15d/aJV37zXpRC+U4lEYj6ewGyUHEuW
			35D3jBi+9HkEI8/XX4fkJfjOzw/Lheerk8M8lA3pPzTABWhwmEfGBwjS/BscRu7RY087d4j3jg5U
			l9l/qoze/xeCbsGRTt/6mDGb4y88NO599Pd/B4sNmDp/RCDW0CvZW4Dfex/csu/ngN/9X1X6fq3g
			G49nAhmCLP3tzq5vxeHlnMhmL4/8JpNNjmQSdG3Am0DiIFHYkFnx+R76Hz4khZRA9TmW8ROFFxbe
			8FU9eQrBuqKdW8FN39xQs57hq9dcKkTbV8BXSGOxj1ShWTlL4MoS9D4Hndc72h1HhVO07un29kP4
			SoKvno09KpydjhzNOh2AL76oBbirq29v32MyCSFu4pyFOvab4lozwbdekFh4YIisJTHzLPaCxEyV
			tLcqzA7MBQnqtCxBLQlRWzoqrCznUP3IIdT9jlKNGL59gRV25OUFklAw4BPLRSti8wiE9mLUyou7
			B1Bl5j4fmr7BPkNoKciRhAEOXiBiE3wDEUhfErERIqrFTNK3G2NV8JXgzVmrq4no29SgKJUEL1SY
			bVY4YHG6AlEXX2WxGqwRhZQysnI9iEEwu2ybyCzgqeHU9ooz3J03XYDkbdKlFvoONjkyxQlEGI4C
			QpH+CwGMdD+Ph2vTLtA3GiX2bpqjttSmQuA1Rw1KVInCzdIG82d60vS0XBZXdDN1GwaUNiAaT8ni
			VkjtpqwGiwf0dWnCV3zy9PREzfzsSCdD+dILAyuXm1GKpzMGZQc9Xy0IUAsqksJ3ouCKYaB3YHGe
			4AmfG7R9xcizQPNkIXvlhhF3cufeWmeuEn5Z+mJhFjNLc5l1PoOU4AFhfww+Dy32j15cXL+WgadF
			bCPWv0qk1NaBx8YGiL3DibhICurPLNL9eQZ5XYN8fuz5ulZy3jZplTv9Qp+NwqRAUq4ZsdyLsra2
			lLsuxp4x6xyLgb2XMPRM0vf1gddRGSA9i1qBHP0ehuId5OXoQeIyurzzdCbXAmYdHF/sf2zli6mp
			tjZ7UWmR024vevTmjn/x+F2o2fEX/OseN+0f39GMNX6Vk7+kfP8OPlfAcIHwLZC/ueM+4FvGc1vf
			wPd3Hlg1Cnh98HCOJxOwiMmOLi9/svzJ5cz6aGwku7AQ8ZOcWs+i/uzLxFbCBgMUcNi7lQGTfQuJ
			DPHXt3DujRMnhNEGQHpK9HyhZfU87syBP7kdX71YChbbweIQubyi6Ws8SvCVs8V5+IqadQWdBXyN
			LYCvGNwq73ToJBEPdqoqfZ34IsC3sd2hirRhunSkvh7ul0bN5JF0L4NXqlqdTg5ZmURft2Bo2bRt
			WjlXdta8r4y50AiR+pDr/uZ1rqS0SZfnsbzXjuALv0C/HwNX3sCMf4b3jUgHr3iBXr/YH8FSp48T
			jUIIkAsSZ4PCVyEE7WsgZRycpQfy+vzwwKJTXzhAt/khYq0GQziM1SSLVbHZrAw0jgki/UrwtRDc
			IHKxa0RvCpwoDUAxWq90SwR93wY0bd0elIU3lVo3feWPr228vbBg8dIbbzJ56Y30btTqISaTVIXx
			JHq0HhELSHi1cU6RlV2pXBzn29RqQ+gvCW9msduCeCOD4TZJXgPAT8/XYo5GLWYzPkXhLxl1eTBP
			ZVDw6NEGD6c+cBhDCsPVcNqybirwyFLouZgVW0+rW5bG/wEU3wS1WfFGDKLqTM/+yyvfyYntvpAF
			Gb1iOHdieGiVWAuH4sFsZovwk5zrv3hxIKd9C+N9JXxXGb5v8cSvpC+JPvQ3uXE6xx5R0KtiKgvk
			ZTyTLJyLXYT63dpa37o4sDowqWFxEsI3Tt+Cp5TYvIKFaA6/kJ+Fsjc/65zTvZK//4LJVX7Uajqe
			WRfWGgD7Yp69dMyR4L20HiMJPADpC/r2vw6FPwitPjYxxJX64QlGLn5w/gkFdoX7Fa//DmGwDUEL
			j6t82zqOvfPOoUOHO+zp4kbdZ/EpT2UFevuJZGn6i0/z9y/rKPvDV7EPiL6u5K/IUUDr9yM4bWD1
			6CO0gAvI+yh9Pz5Ztr/sceIFv1bwzSTXUagkBmdGk5l4PJ7IJkeXf3Dpk2RmeT25lcgkVvzE5oTX
			R/dIJJPeh7cND4MPwz7fgn9rK5NZ2NpKbCW3uhcW3nrjRk7DVohIIpF1z0JY82bU/DgqNKcrvneV
			iB3UQvmOtjsOGnPDVwxf1cldWH3FUdVB8OVpZ1UoX91xh6NE4oxu1ODLuDfVFeFGHlQ2NaqOvRh0
			FgNVBNT6em3BSPOyygUS6fMLu7z6W2CxkaeqrDJr5WMNwfKFQJ7e+aavzmTMl5+1Ga2dTTv3AbqB
			mRm/cOsNoPJM/wlXmLu8akQ4DkkKh/wh6a/QxxPOfbA4gjMlwTcAU2c4U4rsXxg/+8MW2Fyh+hy2
			stmyAQ1Pa5PH1VBN8EUPOIqOL6QlwY+HnomlVouZjaAVK/aDecK4ye0GxNxm2DT+8f/1f/2Yj//6
			Y+3YMJjRvVVsHAcMKFpcIuvewwkJUQQsoL3Li7pE2yZPK8arzCRhcdce0qyGTauBTgywf1Y4ypAk
			NDGTnho9QTxL0s2Yt0qZefeIu8Vi+AoUjWJE2qNYSAanrKTygVp31JxK/QMq5KloCq8HrN3YgMZY
			OMH3Icw3d6R8tQ0hqYDZmUou53LPd3V1dXAV+Jgn9m5sIN1n9GJu6uqRQCNhbDW/mAFkM2zDyB6L
			BB+5/yrtnwSABrmZPKS5Zk0Mza0PDvbPZbKJ7HpmfW5wQnZgr068vjo83z95Vezz8OOChSPr8gAi
			RY+3sOn76LgV/J2/TLDg2ATQrsEXP4Cct9rIXQfovo7RK3679PrAdfolwe9qbJLXpae43swcHsht
			9Qr3q3VtEmuY17zij6t8023FodCNmubzzxy/MRs+WdSBFaI2e9suLBFh1hlrRR0dpf9ecni/ygFr
			5v2lbbduCQ+NOwX4vSff5d7vRx8iUzDP3w+3t34/+ujWrY69wunqqx1fK/gmMnHIogC8NhKjo1mS
			v1kSv8nl5YvLyWQym0nO4M+zz+9fIFUcG80EIXwfQg6T6N1a8G5hC3gLgbJvn3iDNW0VD1Hlpq84
			V0EmA8qpZ83tWYBYkJerz7I4C/hK9yhZgt7b7jjG6b31mFk+BHI90d7+HW4T6+tVVeXwP31Ze7lD
			g68JD2eqqyMcFzMXTc52Rz3MrnKRu+znLPu7rI41W0ldTtzqdXnhqi9s2mr9aQ3Ser2Ar1yp0m2f
			aM5dVWfUaaPQOi2xeEdlZ0HSGWheBmqIJHCIXSfhoM9KOBT0+rn362XlyycBSWDANxRg+PoZveyF
			hY4wJHVYiSg88+yH4waMmFHItdoqK5sqK3uqWwlomGiC8OXhZkxdKT6luQHkNWAMCxPPTdy7rQR8
			zWY3ZxS4PS7k+LKmNIgaL3HNRoKTHogobIXotblwimEqWDJbrewPycTkkWcPlK+yRpS1WQBpErSG
			1KaZni3EsAVqmdhLUjaVgqI18KIvaV1lU4lCrlsVNucArUn2YpiavsZl8WCCmhjMZedUD5fHSbLz
			lJfV0hzhQfCI6Pjin/7vhm/htPNkfspKc4XkVSHAdVJ4ZQyxcksIMRjbmpsDfYX4FbL5Kr9J+g4T
			Z9GYzfTnwpEG5ueZXwLGqD1zvXmABSIAJW2ftq71Y1ya1O18kliXGdKk7/D11YH+xfjU5NjU5NS8
			KD5rDd/FLBZx57jwfP2zheft9F1d/RftnUXM4fjQogbfjTl6WpcG5PeTQCb6jsSSl0Zl2flS/+uE
			fghfhu/UMEbGh4e0AN8BTjha1OaltTq5eNVB9H1c5VuKTCJj+ulg5FjdbCSd7iizt9mL2pCbYHdi
			m+id88+kO0rt/5HhS+J77/796Zsv3JXozUvfe3kBzPD96N52+j46eXXnVrrM/g18v9RxOJ6B0T7w
			619aC/Rl48TgeJLEb3JkOZldT3izyVjG733L5/cRY4nG4eBDKF+vL+z1ZrcIwQsrC+sx78LCQmLr
			jXNVFU9WnRLwFe1SLjqfEqzRa51RJi0XeQWs9fwF3AbWacpXxhWICrLRRHwt31NcUqY69jlUTDvr
			ih3tnXvtZaR5K/aqquNwcfEzTrWonMvOB/FFJlHpPai2O9r2FBcXkVQ+JLITBHzl+ZyU1ReYYBRu
			FWmV4gIM51V8/ot1MmUhD19Tbj5L09D5frIuV3bW70j5ClvAGbz3aTiF3QY6vmL7SPhOgs1e3yyU
			LqRuiD0VQOK+4GwIzA71seDFYJaX7hQgWhv8QcB3Dfgl1hCTDFGx3dNT2VqLdSHUlN0WDC8hrYiU
			rkGxNFssrQ1WEsKkJi0GCGGLx6L0tPZ4GLVaQFAlhpdsctqZ+GeNKja8EwUxCwWaYk3Jw27LCK4X
			4cAWErkGNxrITbzcGzWbifMpDCzTNzJblRRBPWpWXGaMe5mjiAG2ooNsNdDrBKvN5bZhgOz2pgWL
			UwRxC6rQKY71jWIk2kZiF5AWT8xs9VhTRHRI8YamSKQb7DVA9CoYtjIY1m4bdjDtPKkNKee8qQiF
			q0MSvpLFXDWe7yf4xrjuPMpzVxcHhzTBPDlG7B0buyqbxGIpluE7IOArK7ck+AbmB6T5ojChGGBL
			CpbEG9eubGTxaMPz8xNz64uZja0FIXzHhgbZhqN/cYi+14SE78g6zxMPT0wNEe555vn6JcHe67nC
			8zb+oo/8JZTvOL18yMN3YHGgfyAH32vS5xkt39ehfC/Nvd7/+uD1gYHrA2Laapp+E2JMfJh3ngc0
			zS8fgeHLul9YZT+2wxUiBfX2dHj2SN14JG3fVbLvyDFSu8feObanscRetKc7UFJkL3L+gY2pHuu4
			ZS/bv7cjnRO+Er/5paP70nYDlhsCwnn+fij5K/D7ixfwgF/9lcjXCr5e/0IIXoPE37A3tDYTJ62b
			jRN+L2aSK97ESsKbuZzc8mUSAW/Cu5WNZXzBrZXbQdgYitTYjM+7kIx5IX0XtrbeunHtyttVVbmd
			X140qqrQ53AFfVihr9AIlTOg1MsSMgvCo3DGkPPDBx08+Vysdqp4V0t0auchbrPud7S3q50l0Jq4
			qd3RWb5LX45pZ3bmMPG6j/FM3UFHebvajh3hEkxcNWpyV0xdCRairiymrfI1ZU2uakzetsqr255z
			ZNSsQ3QF/d5CWEt5LdaJt7lg6XficBUSEpaE7opMiYP6hXnCygqPNIOwmHH2YvAqKKz06QhK8cu+
			+hjDCs2iJ4zUI/SJ+5BUCMcr4ssaHQbijWjiunogfSut1a3EUBeKzFxsZrWIgSuI3abWVhSkDYgE
			pBujJCYVW0+lB/PNm65qcbjZR8qsLRuZAV/4RnOGr4VLzCx8XU0IHGIZnDPccLGrRpOngaBMd4cx
			FYFa4azBzZQNIYIes5gNsyF4yRZlLw46RRYSVpw2b3PeMIrZBH6SylZXU0/UZjUTwUkb21wKPy1i
			sceWgtFVq6vZ0h3mvAmDn4UvEdhwG/NlO1G+YsNXM2dGx3YVwbvsCymV7/zgYHx+EU5UyfUkHbA0
			HpwfuDgwWGDsPDnGBGYPCYYj0IrJ3oEBYWScK+Sub+R6tXwRMFrv7yesrWfiM1zrpqe0np0YnMsk
			pCAdZMdkWF3Mk/wdnpdlZzR/h7E+OzkZJ46vrm7Xvbmm7w7Lzlen8PAbkr70vQbE/Dae7ob2Q7DX
			1RwT+NLA6uDA6zxZxjtYY0xfNHuRCCWNrLTH2xgRZXIR1Dg0NfW4yvcJBAIajx/vnm2smw2ffKb7
			jUO94afTdeHw0X3NobqifbPhn73T0ZEu2iFl/n0d+/faiyB8c/jV+HuvcPPo3h1JXqbv5xWfPyLp
			a/8Gvl/uOBwMrniDQa9/pm8Ff7j9Pl9idORiFgXnRCKT8SXimfVsMptdR0hdZmE9mU0kkwZUnR/S
			nybi78KCl65dCfsWsAC88Pb6VuxEldgB4t5uFa/5anE/Fex6xVVnCV9dbuCqQruX7qDqLJZrvrp9
			amcxW18cdzg6O/e/pNM5He8I3NWXOh2dJXicqhKYaDjr9UY7ys4w2TioY3tmtHrrSgi8TkepGLQS
			8DVp8DXly8jbVK9RODYbjTqNyTq9XktYkKVqXR6+JqF8JbILbJ61bq8YmZa012k1bRbKO4DvdC6h
			Buo3JCwmAWAuRLPzBmthbPrS7SGIXZa9bDXpx/BVaBZX0we46+XBLKhpbwglEIXk69LaWtDgj0Ss
			CsDYam1qtdW2Wpoqq6sbmkSnVyFZaYui8AwTaEuDzdbgtgK+CrEXynTTDIdk3tmJVot4PtR1U9pG
			D4rONjN2gpAdCN9luE9x2oGHQ4ew39QEA2dxNTKIXK5mrB6xq7TBbO2hr4/aDJuKwarAUIu+ORt0
			uMxWt5VB67ahpUuPrKToNQKBFh4eLg99iQUZDC4EBNM5eijwOsWbvSmP2xZtRd7RiW4ecn5oCBvC
			fBgiEf/amnJ7J3u+UwXOkJOCvcQnKdtkMtEiJq0y9JoXord/VBSch+YH8upYdn7HuEk8JFP0+Fjl
			zZr+PMw4le9ansJcxGVSx6EDGVz4WEhMTizOJeTsMTaM1lk546GhdLl5Km086KcY4z3b6/lMhe3D
			zjnd+2V7vni++RYvS3fxkmFDiN91DlgQA8+kfEn2vo6RK86GEmbPE1P8XAdEwV081o/5NCZ+5HlJ
			38dVvh2IFNTZjweDL6PsXD9taqsbv2E/GAq/kzbOdhc9HfQ/Y2f7qv/IB8aTb318l00k72xr/HJ8
			r0bgO/dyx0f3Hik+i8rzLz6Cx8ZXfyJfK/jCXz9I2ncGxeelQGCFtG9yNJ7IkujN0lvcl41nMuuE
			4ZU1vw+TGt5scmHFm/U+DHvDPt9DQHd9PRHG9M6CL+xF+m/VjRstGnwrqk5V6XPejBXI/eWis15b
			ySmkr0S0SZJX9FW5HWuUqKpgu0dtfUcvZ5i2TRfDh5mIqTPVMQ1RXD5ilHNQwG5jLjCwQPoyLPmS
			3BISoQp5qwyZnaAVm8Vkdq4FbDJqVhy5Z6HLa95c1RnwlXDWHoqu35nyxcSU0LFcUvaKkLiQXw5V
			9cHWqq9PG8di6uJzCCNWfFf6KpSeUXX288Azj2JhDRhTzn7o3qAB887sk9zcYOlpra0k2FZXiohB
			qwLM2SwKd38Jxza3UMKYc7KCyeCsu7rSCqGrReNWK3LPl9mLnEJFcVngYkWMd8FCA+m6PaRtmzB3
			hUxDus3NhWg3Vn/hu4EquMWWMhisdD9FMbuht4mrKXqzGZCa4LbaXKSj3QTg6JoFtpAuq0JaXGho
			j6XHRsrcTKId9pJ0mcirQBmnPERwVs8em9vjbugO++j1R4Re0BB+EbfIu0Zrhh3t+cLFebowj3di
			W2jvMM/oZjauXLkSI/ImM4vZiwPS2/mHdNug5jSZWw+eQEIDlm4QqjC4ihFg0DcHXyLvGzhBRxf8
			5MqxzNzLPw2i78wcZpsXRRADm1DKuAKieX9/Bk1lUdbGci3hbhy+UoOruVGr13ORCo8A+MtE+k4O
			Lhb0eAm/WPad08Q6nj9dJyadBX4HXr9Ev5fBVYQ/0Y8CN+rJqSnpbaU1kAm9137MAB4B0Oc57jg+
			9JjKt+Mml52PtfiOphvHI+ljNYfTjbMP0j9ZCh9P1812d7wcDD+TLmv7D93y3Y/FXBK+7B+5Xf7e
			1eCLuvPd/OSVVnr+rPq9cyvd9tX9qb9W8GXjBQKvN4RA9GAg4OOco2Q2wMk4iZUVJFQns3FweCGR
			yGYDmWTCu5DxkUomMexfyPq9mVj2IVeh/eHwQmbBd+5a7DkRJ6iX7NXJ+WG9dnXebFL2gNnlOb+r
			kxvO0rUIxynNzDHvYZFb6ikcKs7hEdSV14voXAlFk7HRpAX21tVpyld7cWAS3lRa5blCp+0Ziacq
			y+Jy6Uk+lTo5r7W93Cwlcd5dROI9X9LWkgp3ZC8plKyoPnsxO8UEhuL1Srt8ErWhWSF/RehviAvP
			IXETXTs7yywW4QuYtfKRIg4Se/uCsHg2sG1VMBxGdRmOU1bA19pUW90K1cnSE9u3ZjNWjZi5CsEM
			oKYbDcRMK9yS3ZW1UQxccTgfl5032TqKh41hK4lyM3BoMWPeyeXpkaVmNHijBkIuSsZEXw9uYVEc
			jboa8L03DQpCjuiUBauC9STe8OXYPyRCQEnTlxpczOsUOsIWLBKzxvZgEBomzp4mOHYom1wQt9J3
			U6z0PFytUMRQvewnGQkHufgM+Fr8hodKagfezlMTU9y1ZTfF3MCy7AQPw7Spf3T92pUr68BdZpSn
			dOGTODGF5Rlp3lwQsoDpqTjJOTozyINbROABSd9c4RXomuvPr90MSp5rLwCmhuKJ+DzODiQwwxTv
			l1PSolmcZasNDGwNDGirwnHUnseGVzWrjXzT9/XCovOX6/leHRuez+8WxcR8cyGNBX3nRMRRP4H3
			9cXXB1B7HsTC1OAQ/zon4c3JrxXm8qpXnoFbNP3ukC849JjKt6MUZedz9cXptL1uPHLyZEljfRXB
			98+WwsfSptnu0peXwu/YS0v/Q9MXjlRpCF+EJ2wXv3fuFSwe3b2nRS4U8vejbfz9xb0D6bayr5xu
			9LWCL/sNEnf9fErHSiIBd2f6W+xbCWKG1pfNJhYyWVK0CyRys+v+zHKW1O8KoZdTcRI+bybrI+Ub
			FvAl+bu1kHz1xpNyzajqlD6PH0FYvbEiV6DNDWBJQazBSsspNOq0YWS+tiKHM6PcBNZr/dgCzSnu
			ZBLMNmnhuVKHcqSflL7ayJUmjPMNX2FXZdIVXKfFMum1SWxdgQelTq/X/CaNWgJSvq0ro59y9Wit
			/81M39GqUYBtrXiIChVnv1weCiBLwcv7RH5mMjdyMfzM8GXRK75M3D8Eo8oA5th5Ngv9XshkAwm9
			4BrmncEaxeJGi9Xiqq5usFaT8rVZWfNaxKwzNoE9vO1rsXjgLwnEEVEbohC41a0egpq1ukcqX7M0
			r4BzB7HUrNhSqCnb0Ej2YNwZLpZQv62tLl7yjWLXlwHNy0eeaENDU3OT25ravK3AxlJJkYSFMyUi
			FFBwZu5bsfOkRD2uHpLGViQhoa2s0I+Cyeco6XSPNQVbahdCBV1RngETHlds7+HucbsakHDsDeM0
			EjEEec6ZWRxRHpp/N3y3Kd9J0aW8ikZlvnzMFWSE1g/MZ2MQvhv0/1dWbshMTcMaEc1cXB6akNbN
			w3IyempYXCb6btO+gl1i3Je7wjyLBavF4Zx45gmvOAlCxvBQf3xsbCqjTSzxDHW/3FQC+nnrV9y8
			GJ9g+l6//gV159V/2eFqu/Qdyj9fOeCcyb96uCbK5ig8g8BEX8D3OlayBoWR5pQIXwJcB1j0c639
			2kbB4/HLmMH4/ODj9nxJ1HaP65xF9rS9cTx8sj5Yd/zIuIDvSeNspG3PLFG4o+M/dMv3JIa1D9yV
			xzbtuw2+2uDV/XuFvd97j8w9f3yr46snC36N4PvEYfb6XVsj+K4todnnDcTj2DaK86LoindlJpBI
			xhOJFUJwIhH3ZtdXvMlMIruc8Pt94YcQv2FvZiEQDvsM3oXww/CCN+xb2IrFNt4+xyPMVVVVesks
			AUmMWxkrcuNKupzLlV6EH2nhC1qDVdo7av4cmvLUXJel8tVrPVtdXlkyOelynSRtvkasKV+TNnul
			y+0UbZtq1uemrYx6ufOrCXL5AiCXC1gYJihVco6zogFOV5oKB6Vzx872fEOYl2KIQvliZxfX+H28
			8Ev85V0iRq2oPEP3kqbF2SB/ARefgyFu8WPRSPhV+oNLoaDfbwgbSAUjqkiJNEAewlBDaehptTZV
			tjZbo2beMsKsFc5YLDz4TEK0J+qxygUkTyVWa83uHvDWppWdK82bKWYcwQ8JCZspxCGQ0rSaLQCv
			zUPkdMOzuRWDV9gvgkOly+XuIRxiECtqa2pqbbLZeB836vKYzQaPhU7MBHNO6uXuMbyigVo3UdrK
			M1s99DMYzMRhl01x9SgKg9+COjSR2eoSO0Z4ailPk8uG+zX7fL4IRyDjBHtXgK+ZXo6Ebxt+t8lG
			XvlOaLoXNlIYmkLBVIrgSbGyOvTDLNqUW1fef/fd5+dZ5l559/l3z6Ko+jydmZ+48PzzF+gNx+AQ
			Tvshm3GGvvrsu/T5XTqen1unU17z/S491OIiXYXb8LUTE88/X//8DAvot97v6up67xykI8nn7ORY
			pv/d999//9X1s+/S53ffx8nZfoL28/jyRc76e56ufW4R/lKr1//qr97/K7HzO/L8Xz3/V6L2fOn5
			578L9F5//sIFX46xLRcuXKi/UN/Y0oeh6vF6uki/iMbGCxf4Gb+7/ur74jj4/nNzG/jEx7VrZ94v
			LqYzz79ybSM2MjLS/1fvvvtXWPUdGMjSz3Ehg7krSF8Mn83NiU73NRa9Ixv8sQ7nSS5Szz+u8t2b
			PhmZ1aXb7B3putlwuju07+RLUL5B//HjdVC+aP52/AdXvvR264W7H+fxe/fO32ri9744ybd+C6Tv
			5ywecd25/Cs/la8RfMsPL4G+ayDw0hr4G+hbWZmJZ5IJqOCHxGJ/IpvMriRIEHuJyolsgl6hZ+KJ
			WGaF/mg/XEDlGRaFdOYhvRsehv3+8EImE9t6a+uGcLuSfhpGsdZrFKlHujwoBX6FO5ZWRZZbwFo3
			1yThq5ed1AKA8WfZJNbMqjSJSeckeHNQlTpaRBgh3MhUIEML4G3MDWfn3CR1eZMufe7nKYCvVmvm
			r9HnXyNoMl4P+OYks6aDdxis0CdqymLBKBCaDk1zx5dQ2sf+zV40d5nDzFkvhDKKzozgAE9bcSG6
			z8+tXoI1byBxyZrgGzCEg2sGvyGIRmcEflakahUSjkQlEp5N1ihJXQVzxZYom1xhxomARdxzQQXD
			qipaGWXI1lZ7SOcSd2u57gzA2TZTmygxRxF+kCKlC/MqBSlGVraMRNUXa0UsZC2eKNebQV4P3+Ku
			rmxSosLiI0pwhb0lVnYVmGFhEBumGFbb7U0zqG5LIR+QvsoFb2d+HWGw2rCBpNADuNyVreglW1M5
			e8mUy+2BzrdFIr5wOEDM9dOLSkNQtHwhfLFbZd6B8p3Qas5gxcSUmBUS2fB5JTw5EZ9PxM92qV3q
			Fdamz9HZF4m9iT9VO9vnJ7pELkhnp7NrarCLbruGGrKqql0TQ0Pv3cSZm07nB3NzN53qWbQ73+vq
			7Bqa72pzqhjyV8u7Jie6Oju74sMTw5MfqJ1dXfQ1HdOTyAAeTSTm5sroEU6vv3/zptqm4rj5PkaL
			n+2iq+MJiN8PnGrXd+ewiDR8vUt1dq1yyfm7qrNN/WOWvXNtdCUKz/Ts3s5Vl/dwnJjarpaX4KKD
			ngvBtx0/jkqvALrWr90UiScO9d31a12qQ1zauHZB7XQgCEVVP4DJc3+X09k1ODC0OjD3HH6QM/Sy
			YQoBTmzevA7RG5NDZvlV4UWhkn8PyveZyGyLs6jD3mYcjxzvnX1w5NRs+M+O+v3PpPWz4dJn/MHi
			p3eXH/9DA/RxjnQaVeccewvV790cfO/cv5vTvve/qPiMvaN7t259daeurxV8ibiBJRSc/f4lVsCB
			mZXETCLr5UGslUAwSDI4mfXOJLj9O5pJ+FEg20qOJPxB0ej1hv2+xFvYGF0g9j58+BDwzWwtZBi+
			Vac0byi9jP8R4YO5srNRwFdnrNDrclDW67QgpJyFlABY/lQWprXKbn68OJdqryUUyfkpWDvL+0jB
			y9lGptzXFx7aM9MGrkx6zWpSXzANZtKZcqg2SWmt02lVcw2y2rPPu0AbdQU/wY6ULxgKsvL6rpCx
			ooa8wEu+nGkUConycl+QN444XUEk+/KYdEjsB/eFWPoGvF74QAd9rJYDQQhfABjD7BFiJBZnzQbS
			uZVoAVu4zgxrDVF5hga2RQmEVmsTdntIeEZdlR7mmbvalkrxsHNtdWV1pZV0sMdM4pRoaIZJpQWD
			yOwWSYBlJNtwrpWISED3RKMcDWwT3hskiS02a1O1K2oR+0aAq8GCCSm3TYHppI0w7rGQlMUSsdXd
			4zErm4qiIJVBEV1iRCuwTzSmrDHJhUd12TYVugiDjU3F1tpksZi7w2FfGBHHUL5hMe3MgU+RCL26
			3JHyFRk83OudGpqamtDgm/uMIvTE1A+HZvaoTrWzmO95mqjz4uL8fPxZItD8cNdNIm4n9uy6puaf
			pduugaIOp6OLIPSeWMAjTC0u3qSrsv398y8SzYbi5XRKLHMQDycn6FxXgvTiHpUQDvKpH3AG8OBo
			Zi5R6nSqpxffpyfgpAPwhXMjUdbZlZ2aGhqaJ/iqF4hnpH2Hu+gBRL/3T9WTTsdfcbX5x/TwZ7Fp
			RLjPwfdqSTvYjxBQtYSUr9ruEPClJ+OgJ9c1t9GFz230jZ8HfJ18V3Vjo7Fdcpiey8bIyKUuB/0e
			Bkj5zr3fSUDfhao7hzRiY3gjV3IWC1YjsumLTa3hqcfu+XaUFptMjYcIJ0X1daaXjxtv1B82VR3c
			Z6orOXyEbijad6OlBFGD/4EPsHf3xx9//JO7nwWwBl/ePSqsPX9x8fmFW/B3/mrH1wq+xN0lErxL
			GHgFhPsCKzMkc+P0V5tQHKZrZzLZ0Uww6IuvAMMjiUCW0JrIkvQ1BIm68AXe8q0AwQtvGQwL+DO1
			QMJ3y5c5d+MGys659dgKXW7RV6/5H8uKdBVbQeuF0YUuv9Sjk1kNOmkarRcjz4JaUhtL54rcOQ4S
			FhisM9bpNdzWmWSRmCegTcJkEm6TUgXnC8m56WmtiwtuFxaVtbQFwXdjjucmSX59XtnqZVtbpy0n
			5crWshqg35ny5VGrkCg+c8G5zy9o65P2VXIIGr4pLI553hl7v7xg1BcSZWkIaF7yxbCzmMNCSxgj
			d9gzgoG3Qtgxp8xKU3Mz6T5F6cEEssVKYDQLR0lOVyCx6WnCohEGkT09rW5iMMN30+zGbi93fAm+
			rZUel7JJshZoRa82ZbWRzoSlc0q4W5EM9nCioLvSbSPVC4MrF+f7WrkVG1WUhoZWuFDSI3Cp2mwg
			FUz3JmHeE4VXJClwq8u8abitWHp6XDDKVPDgsJPmIGCFDTWAc1tPq4co72avZ1ePBWGHNrNibu4O
			R6zsaQXNayD2KoaHDyPd4bXbSljpxnU72PMdnpgeE/VdrjDPD01NjslA+au5SjTgS0cHmFTEyve0
			s72dlO98vKyzXY0Pnz793Lt026HnzjxHepaIeg07wk4H4DtxiNh79tq1a1deHRjoIoH6an//IsG3
			a2Li3Okbe4h3754+fXpiiu7VFZ+YnIagfC709s2udnWKW8mLmbn5W+2O9tPzp8+cPdPm7FTp06vz
			8wPrgK96GpYWU7tUh/MCGsFEXwcpXzFp9SyR2vEBt3tH2jvUJ1avXx8mqf3WNvjWd3cjf6x87Oo4
			gdVBPzWPHLQ4iNbr/deu0PEBcZjwCaqffo5+2I1rjfhxz507e5NedDx/6VJ/l6O9C/3xuY1b/CKE
			7TVwglHnjVy7F7Yg0L6E3xG2B8FP+NipRtuTeDtKi4SXZFo4MxfZ24q0O37ZZIV/LzkKhfi9dYCU
			L73/5O7P7t79W0neu3Loij/uFOYdbfOclGtHOfzevbX3m4GrL3EcFvNWpH/9gaU1wi1Gb7wriRVE
			4ATXSAXNEHLfHI0HV0IoOY8kkyuZbOZyIpFczngD2Pdlm0mSCmE67/dnFvwPGb7sufEq+2foRKoC
			g9PYYhSGz9o4ldb2FYpYy+XTa5EFdM9TVRWnentPVZ061XvqVO0pXZU2Fs3N4Lo6bQ1XTi5rXy9m
			q+p0WjSCiWWq0KcCxfIedYWF40L7C22eKu82mds4yjV0c+6U8hBw1eeL6JpYz60Wydq6Plf93ony
			nZ2dhXINCb8M/BmbwXBzCK5XsJHENX1C3/Kgs48Hm/uCIf8sLyH1cfc3JDw2AGY0iaGDgySBA5h5
			xpJRmOMz2ORKUZqbrICtYgHdsGTUY8U2sM3FDhnWBpurx+WOEi1tVtKvPW6sG4G9rp4es5lOq0n2
			1taSALbRF7tQSIZINaewgmvxECx5DBlOki74SEd7etwoICsGDhUktrvdFjPdzxNtaq2sBHcRHkhP
			o8digXJ2uxCshMgFaGKXxbC5abDZWluxEmU2E289ZoPVjHmwKPIZoqSVIYhJT+MVAYf1iqErej2Q
			EmaS4SBCniIM3/BDxdAdCRPQkbNoMOzE4Yrk2RiyALAYFB8cTMxPSSE8KUIG+Ow0UminpkgzEhjH
			gBWCb+d7i4sDgK9zHtXTs0SjF3nDSMKXlC/Bl1AN+J7GZPTA/CLBt/2DHHwnJicOqk7HmWF6/GEu
			IU9MnCnv7CweGxs30eUzbLc12N+fJfg6Xl2c759PqCQxF/uxUjtA39LhVF9MoL57gM6e5eXiCYbv
			Kpq+q10Op7OziwetfgyJ++PV1SHV8Qh86+jzcw5HuzEHX37pUVqudq6zFfPGBj2XZzfWAV8VHCWQ
			XlA72w/R+VfpBcmtS68DvirGrtfXIZWdXWJ6exhlZx51viZnnNfXc2Nnc/0DQxjRfmyHq478m8jy
			Rb6v3V6QgZDO3RMnZds+fcFDFiYq/Ds4oHxf+FjQ9+NC9Qv8/gq1Z946up+bvbr3yOjV9uLz/W/g
			+6WOw2tLELxi2AoqmISPd2XFi4QbYvFS0NuXSCay2dBMIvnmciI+mkxiGHp0lKTvesLn9y54F0gJ
			J70+/0NvZCGxsJBI+MMLWXa/IgbfqOi9QqpRalS9yBnUa5jNhwvoKySv9Fp5mfu+xope4i594JSP
			U3T09j4l7bBy48qmHCa5MCzNLTksUK9FFOmkQBWJgnVigBrBR4hayBlPbfOENOb3jISMza3v5ga8
			TNrUdB0/FznDrKUpSh8NnvCW/e3cYHadds2O4BtAWAJXkvv8or7MMph4CtsNmbOAMaw+Dg30i7qz
			cJ0MiA3hUCgoNDHcObyidM0NYPpiP8lePzyMg4CNxfBQ6W5qipD0DfJSr2KxtdaiD2wwWKwNzYgV
			dPFYFBEUdpM2D5L6bHDRwNwVwVd4bKDtG3VhYqrVFYUj5CbdvUexuBT0ld0eCF8YS3l6YH9htVpI
			hSpm5AKm3KgpR0kXt7Y2VbdG2SXS7LJGEWsUNRN3N2/f5uAiNycwKGuwfFaa6LsDw2bF5SKFbkPS
			Eb06IIlO+p2eABaDSahH6TaPi9ePxUJR+CFKzEFMWUV47VkxBIMEXzwq5/mu7UT5oss7BmMMJN7F
			5xm+k1PTU5PjWtt3AqPNU1MTC1wkbudx5OegfAcG5uOlBF82xzgj4Ts42EWMvjYE+KKIOzlxyNHp
			OM0rrQPzUL5dmbn+F50M34nh950MXzoYvsNT79Hj3CD+nejqVN8b5nCCxcUM4Hua4DaY6CL+Y8aa
			4PteF1d4E/NDk2MafBfnJ8YEfF+/fn2u04FKeD+k70g7KdL3VleHux6FbyN99hOad+fgC/yGSCEX
			Ibywf279LD23CwTQLnrJIPd8Cb7qC/DkIvh2Xbo00EU6ebF/PRa71uUg5KsZeiLwGxkS8M0rX4RB
			8MjVCDZ9h/DC4fHzfPmtLCeA7UKy5gascuwt6xDBRIWfPv8h+Z4d/55CgQV8P2YAQ/v+LDd4deee
			pnzvbs87ypWfP6N+f3nsq487f63gi3bvGg9bgbV4DwZWgt6lIKrOfpK+KzOZ0VgiEc+OJkcvIvIo
			Q/BdT8aJyICvN0H0TSSTGa9/y+sluZsl/buwtUBS2LdA2vfcVvJ0i65F4rdCgkjWnfOTU9qks16D
			FZTwqRx0/5w+zvOpBuBTp3i/1qj5RYn1Htny1clHJ7ASZ3UyIlDL5GVac7dXMJboyxI2b/woZrNZ
			yMrdXm7/isawtnEkKsksd5m7dQLn8ufQTDTyP29+XEuOYZk0Mu+k7MzwZdpOhwRI+7QJaGE2GRD+
			kQxf7ulyWVqsGXFZ2s/KF18MZysvhqJncSX8OfxIE/RD+IYxcxVW6N3SVNlNStew2W2wNGNBFuuw
			UMKVlU0NTSQ3ATdPU6XNpcCI2Wp1NUATuzy1SKJ3E3pba2tredW3tZW0azXpYpt5E2s/ZsWDvPuo
			Gy7OPW6SpKShoYFtiDbEjPLmJuyrYD5Jj9dDUjVqNVvNADZMMzCqfBs5DRzKS4/gJuWrmDcNKUtP
			D0cJ0s301QabB6mFUcUN1Z6y8HAzUgR7sHbUIxaN/MxWwq/yEMPekP9rfv9D/C6wakQvQyLhSHBt
			aQfKd2hqavIqBwcSeuGHOMVDunTk4Ts9jUGsqTMEX7Xz5rk8fOe57OyMo7zK8B3Mw3doaBJ9U/r6
			R+Dbqb64uAj48krO+6RkWeCy8k0MT5U6OjvfoG/8Nl3+QCYNzq0/C/hykCDB1znPtlGDzzo733U4
			O5E1PPUByc2zbKk1JMrO6Pl+19FJOlp9FUtGDF914LPw7QR8Q6TqnyiE73QjCeXn5nixKdNFz/aa
			hC+DlOHrOAQJ3JWDr9o/txG7doausDvVs4vzGL1m+Apey0Vf4Jcnntk4i+n7e1C+Iu1PENVeRh9p
			rkZrR1k6T2l579wXfSF98ymEf/hjrz2NeSscP/tYCuDc2PPdj+4K+N69e3974NHnlZ+Zvvde+Gbg
			6ssch3nWGdSFzAV8SezOrHgB4bVgeGltJpnJLCQzM6R8l5PLpHxHk4l4PDNKLM4mFsLEXu96JpG5
			nFjwbiSyXm82k13wE4ED/ojPm11YiGUzsXMtLVg30svUH53w0xBFZxFIoKlDMWfFQ1m6ilOnzj8N
			3p4633vm/Pne3md6cYrj2+dqe/U39HIU2ViXSy6Q40/PaBNZxMSWuqP19cYcpbWoXh1oiWhfuk9j
			o1Y6zgURgckifTDXTNYbha+G0Ox6Wco2aS6VXMnWRsq0nnVFTgDLJrf4rBfFAKMsA+xo2pmg6mX4
			YvZqHNXn6dlZ7Bb5hfLVjK3YVdLPK0h9s3SPPtEoFh5XHGEEMHuxtsRdYT/fGyYbkd4TpPbWCLgA
			ke2p2toG5BelWistD2CnQSRFNzVYve+dmictoK9irXiy0g0T5tqKKhKX1U899eRTVS3R2zaXpae6
			p1YbIG8h+Or0tadOVZkNHpfNbHM/pX8K9qMVT7l69BVPQvpGn3qyym2mb/IUHCjBVIslGrW4o00N
			+pKni90WtGafqqhweTxPPvlUz3n6R3H+fA8dtSieVD0ZxXSVgZBNDCb0mg1iJZieP1aFe4DmqIhV
			2lQUgjxGsLFqpARg4PyQhK8B8MVyr7Lmf+g3PAxGImj6YvWZ3tbWvrzyXYzHMWIljKkIvkMTYwK+
			E9PjEr5T0/DAmpooVh27SjvV9xm+KsN3MAffiTOOznbAd16D7/CEhO97gC+7XjF829Xy+QHAl7eY
			its7Cb743hiSTkxMFrV1qm/TN34LpV4ZNbjYf8vB8F0U8OUY4EV6sM5zJDLnBoi+uxwO5xl21prX
			ys7XX/+gvX3Xs47253PK1/78FyjfPkd7e0dB2Xn8Kqn2rvgi9pF56OrZjY11CV+m7wX0fLE9RKx9
			dlHAd25kI7bxrlredcCpPjs0hTly5DX1izgGXvSNacpXSt9FZFP8HpSvVnHmd75UcHtpW2Gmb5m4
			WatTf3buCKDuyN/xC+BccPpvcxB8X9CU7yOl51/cldhl7m6j773Prz1/A98vdxxeWgstLPHB4CUO
			h/zelbUQid4lZB2tZLLE2iwBd3R0+QeXL44SfGF3RWo3iyTYjNeXXU5mk8mFlWQm6QsvZLxbdOuW
			L7Lg877lW9hYSby6tf7qadn51BllQVb0TmVvlxGkyUTcWKGvqoLY3XP+1yXP/+Vfnzhzoed7P3nv
			5T/pPXTyL4tf7P32d4qfT5/dla769aFjLx+r/+BPKv7o2e+8fEhfcfhw3TvP/snTf6Tfpdv3wa0y
			/f9hfM/5naP/pV5v1DwoNXnLxhuNdQKedQUzU1pLGEoWYlbb5aU76fO5R7p8GxgjW1x15oeRP4PR
			qL2g0GmFdGm7pY1Da87ORPQdlZ3R4EUgILaDSP32TXNvd3ZWzDeLwWY2e2aV6+NlI/hbYdqqj8vN
			iFvAylFImHKwWg6KajXx92FoV3t722zwNsZ8uxuUiKPcbra0WtbKHI7GCIaeHOo+xRzRQal17u+s
			D5qj1qbO9l0NDTaby3jTYfRYa9SbXerNDrXzeKXZ1lNZo9IfVmdb+RPtlZUt9Cf4Zhf9Mf+2xWZV
			INUcN2/edD7tMqptR1A3ttnbHVFFcXY5Oe7XFXV7ejxRV09DMY/Jqp1VyqZSqnY29VjLVWcbRoEd
			J486bzqd9CfaqTrqFOT8GiwiuNC8qVjdCGHYxAyW20PX3t6UCUa4ObUJ2xCD2Sw8NMLI7GLhiysI
			vhG/gROeIhE2/ULsxA6UL/1/80MecB6fnJoaEmnwgO/01PQ0to4mWfmy4VW5qj5fTHJ0UsBXfW8+
			jrIzFoTQ83USfNnSigSpegUuT2iRTrLyVU+jGUyylMjnaHOcGXiR9CKykobfJzKfHQb5SV6qfVev
			drSrjjcI+n6T6cJZHneeGB5YLHW0d57mEFz6FTqG2TN5g74gi34yMXngA6ej/blJJBMODtN/Mu75
			Xn9Wdb7/olPliasR+tV3kdye6Gz/TM93fOwNh6O9uED5Xg10ql3vYUV3rn/9+S7VeXaDlW9nx0a+
			7PzetSvXrnXt7/yA7oRWNG6I3XI6Dj2vqmp8AvYl9EuVAUk/ls4crHxlA5gtJoeGH1f5lrV1lJZK
			5uKjtK2UeMv+iUjzbbPzR5qu6ijvoP/shNXSjqLyIjptY7pK12eEELaVFrWV0h3LcB/6XMqMbku3
			Oe0daXuRuBvdhNvaSumatrbStrZ0WjzEv559ND21A1rZ+eOfSPp+LGvPH7HmRfv3/vbAo0Lpu42/
			9z6+9Q18v8RByjeQ6BPoXRMIDvSt+IMz2SX/DP298a8ksdkbjyeSyVECb3IkSaQdJbxml7O+Pq8X
			5efl5UwyFs/GRpMZvy+zsrCwktlaIDT7kbWQyMSy67HLz4mKM0aehTIUeAKUTPC9MgojCnEfPdQu
			sZfg++0HH79//rmSE71/ff69b1dVVP3qrx8c+/P//L3z/5+//PMbvz73F6Y/+evvn333r6v+6I++
			0/huhf74viNnjpfp/8j462P/peKv7VV/ZTxWv+s/EXxz2z06rQPM01k866zNSkMos0CGhhVtXGhf
			ObnFJM7lIeXMsvAIdVrhmV2o9XK2WZ/PUMztKMsZq/z2FI+Z7Qy+3PMVDlei6CwKz30BeS43dIVG
			r88vWsDaeBYcJAO8GAxvLD+vAXMxOohEJNSpI83l7Y70AwMqz+HuZiVob3dGLJXWsOpQS+laS31n
			e8QSAVDVcpX+3D9jsFmb6I/6080kiwm+FQ22mnL6S8pbKw69q7r2qHpTLrEwfB046zz5jDVK8MVI
			LX087a5T2+qtbo/Ltb/d0WA20D1sLqsnioI09oNajzuxtkJIuPnSppJWHT02ZW+78yQe9+TxYjzk
			zXLstdQzfDet6AMTaIm+UbfbStcotuoeT0oiV+YrEYVTloaoBaj1ySCFoOHhmuG2gc6trYUJvmuM
			5QgXnyOGpZ30fOfmMtn5KWlvNTXF1hAM3+mZmalpnreamhaLSCR2r9xox1bQ8LCA77yA77zs+ba/
			zyPTz9KvgZTv/BR2hiYnGL7nhtlJkdDZXkaKdlDAd1iDLyyhtsGXc3XHpti6km59BL5svTV41ql2
			ZbpIimPI+QNi/5nJYVheDQn4vv766s3ytj/+Y7rXKsNXdT7r7Do96ficgavpIsLuwhjDdxovBP01
			qtp1BSXjubksSfl2hCwAvjc33ngbMhbwPfT2xhV6VeZ4dz22wfCNXYtt0I/x/Jmbjs4pEXQ8OSE3
			fTdykQq5CyJdYfBxvZ3tZcTQNtHnJSoyUNs6isBD8JaEbGlRmj4RNDtKy2RbuKyNdW9pWSmDLS0E
			bxudg1MW3diGe7WVoYAN6yyiLBhemsbktLw3bDvaikp5lrq06F+3P1zK8M3h9+McfvH+j7LgLOXv
			5+G3YPGI6fsNfL/UQfD1J1ak9MU76s3+vqA3sRLMkCAKzmTi3szMSnKGwJv9wcgoyJtMetECTq6s
			BVeyRNfkJ6MZuF5lRjN+vy9Bknch4/N5t/xbBF82poxlXq3IqVxd4RiS0MEVbD9hlFlIVae4wXv+
			1Pm/eOnES+d7jedP6XvPv1TR+1Kv7tRfv3T+PMniiqoqY1XvqYojunpjfcvRI0d0NbqD+iNH6nRH
			9DWN+ornK+p1uvo6vamF5G3dNnMMGcfAJWdp74xtX2MudEgOLjNXRe1Z2mLViWQGMZ6Flw3idjH1
			Jehr0otswnxBXQO+nI8WMRGahcfOlW8fuzPPyhauGLXiTSGvyFAIydwjYecM+8g+0sUcKSjyBXOm
			z4CvzxcS3leIZmDTDf/LQNzx2aABm63dkYhR7TpiMDQfIYnqDN9eM9jLVYOlwqGW65QGS2V5V9v3
			FXO32t7pPEKIrnOqLVFPTdetFgthr3hvuaOyx71PLX9SsTVUVlfWVtY6HMW2aEMlwbXOtkmnioFn
			kKN1DmdND3HWurfdwVh2ciigy9WD1aKGdxw3n3iyqUfpPbnPsKmUtTsJp6RzDYbbdGzeXrut1KkO
			U2VTk5VlLUrLQvve3jSY3a2WTXa6tAq9qylfs9mmWJTuhkjELwytAN+HmGjGnvMawZeksMEfjFg4
			UjDMQA5+eeWLjMBsfEq6S/L0ldC60zPe+Izs+TJ8E1jindpb3jU1MUHK18HKN0HwvQn4DqHsrMG3
			0wGDii76rBK0AV8UBN4lzpQ72g/RS6INhi/GkSR8h6cm6WXQNvii+jslQ5MGyhxq56vz84sDgG87
			iDw09CJ9m/4POtUPIE8JvurZ+BDYK+F7/fqcs/Pmav/NzpsI+h3p7HSecXQ9e/Xko/DFqq+jvb38
			qlC+oenx8elxLPkOIWh4fW6jq7PzEPKXruF7YwNZlp2xi4xyBtyfAd9rBN8rqrPrOaK0Gtd2pKeG
			QN85oveP2Q+a4SviFWS20eMqX8If3jqwYdRRTjxU2yBb6VGL7EUdkKsQrR1F9o4yorKdbiuz484k
			Xe3lKDsTXcFoEszOorZdhFi6G92lvJQeh6DbVgR/KWZraVFRB32nUucu5y56qNI0fV8nVDeznB7m
			Xwu+rHxfAH7zAP4ZwfdnqD7fu8/K924OvoWZR58zevWN8v2yx+GlwEwiHhTgxYGRZ2TczKysJONw
			el5bAWyT2dHl0czoSJYl8DLcJunqlWAgS7eM0l+YRDa5HF9O+gI+BPt6E96EL5nJJhKZrZXEgjeb
			iT1XwFqmToW+8BCFYD0nDmK4ivu7/Ol8L7/xQWdqz/eKW3jy6kYVuqdGDCxLZa1v4c8t+W9lNLbk
			Uxzk4hEK0LKiDGbqpMLFOpIpx16pZvOCVws7koVnSeg66RxdJ0hs1OWtqHMpv3qx0iutoAscsvBr
			2Bl84dPMdlUBaVwF4rKhM1tV5aau+jBR5cO8cwiwng1J9gakRuZoBrpd3Bezzn5MbUWcjpr6Tke3
			gW0lLFaSvGp6TVk7TjK3Ta+YI6rj6NoSydVaxdITtTQTqpcM3fTnW3X2GqIEXz0pX9VexZFGL6nq
			foOr5qazymqNWt3VtbWkfIt73FF3RbvjZfMmfbHZbOUoX4JvPfaQbGWkfG0pgq/FFvXA5grZCE3O
			NpXIjQclpppLCbsMX2UzV0F+qc1hqq2ubuYh503OM+QxaMxd9bgUKF+3eTt8U5up89ZI5C0faVrM
			VvGUNxbubq8pD9cYvgZDMBhgLCthzGN9mbJzTvkmib6Ziz+ckn4awl1ycnJ6fHrG54tPS5OrMQLg
			c4TQicl2p3puYioP3zJYY6B5yz1fnqEi5etABUBtI1Rhz5e45HQ4ne/Svcod6gfvq+p7LzpIMAOm
			gO+ZYSw2FcL3qlz3GZtn2+iJoVL6r3dlaHh1YB4AHGIH5Wc7HX869zyBFkCDw9UFEdKnlZ2v/5+k
			pWGqob7K8HU4F9Vy1ef8LHxVUsOOaQlf/t4+evrvz8OPeq7/RQLraWwIAb5d9KNh6OqCMMGiH2zX
			lWtEXQ2+z9EXXkt0qY4WsS7Ns2yDAzIjaYT9qUc05UsXYW79uMrXXlbTYd9duqvoQOmuA7uL2kro
			5PCuXUVFB+wH2uy795UeOFxcdCB9wF60+9CePfbSQ6W7d+Hue3aXtu06YKeLu0vp8q6i3UUlRQeK
			Sg500Lm2XbuLDtWU7NptLzlQZD9w+NBuuv0wXbuv5NCeUntJzb4DdnyJfd+BQyV7dtnp5n/NFnCZ
			VL6E3hcKxO9PuPN7/56EL3aO8uj91Z37Bb3f7c3fu7e+stnm1wu+M4lsIphTvrC7CgqvSX82O7My
			sxJfiSeWL745ml2+nB0l5MYTJHOzM4lMIgELStSkR5eXs95E8pOLyZGsYcW/sJDxL2xlfVuxhWRm
			a2srs+D3ZWKxGy0tT55rkWuvOm20SrZGhaLEtVXYLDr/5wK3fy7QmzvpPS+BfL5XDkKfwh4xDxrr
			W3TCODo3XmwiBIshZb0cgdasPcSAFZtuCfGqqzvCGQzQuWKKKsdgkylXLNbV5WwkZSVasrdOfoWo
			QZtyjlw5My69ZvdsNGrumdJBU7dD+ELQIh5QoJRrytOhwCwWfgNCB4uSM1thBRZ4mxcd3tk+3jDi
			pSN2kiQsY8rKGxQPBHvnAMG45olyb+CJ0uKgoG/ErOwnQj4MO9p1DucxxXxEVc+buzu7DgcVS9Rj
			M5DWqr0dcbbvvUm4tNapqt4a/c7Nm0/amHFtXc6Htpoup9FTW1v7ZCWXnUtqEbbQ2f6O2epwOM2b
			qWjU5nGbHG31mGmOptsdFgvKzmYLdoldBGCb+2jHzYO1lS7SsTisZRK+zs38UXfTYaysrq62oeW7
			6UpB8wrlS5Stdm+aLZUuRTaCtX6wWbFEwt0LXla99BOHg8E1QxDClz7WbpPq9WPuMBL2o+FL6tiw
			tvS7B662Kd/k6Js/nLw6Ls01RJwu4LvgnRI7v9wFfrFT7ZicRJV1MgffxSzBV00gIABl5xeRJT8M
			5fvB7t0ffNBF8B0WJhv0R3/PWboN8E10OrveIz4iE2n+XcAXO8VXO7fDV9g/Lg7Mc0bDLbk7vMrw
			5aHmoS4S0/2vEgGvafCd46yFIYfs+b53EmYbBN/vMnydjkXi/p7PmGxgAXhXy9XxqwU93wP0HK8t
			MnzXu5yOzgyqxQTf8q4DBw4cQtm5vbOzrOSA86R69ppUvuUE32vvkhLO/PBZp/OA/AnGZD4FHooD
			IaB8SfhyLhIHTCw+ds+3o77tYH3xhZKamsb6mpqifcb6g/U1xSU1jcZ6+576xuL6mn01jTVHi+hK
			unkP3a2u5uCFmvo9pbtqag7WH6xrLMadihtLGktq6o0HDx28UFJKD1Fzoaauvnhf3cGa+oPFjabi
			+mJ6iPrimnp7qdG+q2ZXsbGk/mAjPURj8aHGxj1tpf/KPd8XJHwL8Yux5xx87wvfjb/9HPV7T/N8
			Fvj9+Bv4fpnj8NLKSiIxk1O+wUTcuwSv5zUSvdmVlcCSd8WfgLZNoO5MxCXpO5r8Ad0vmc2uBIN+
			YjCBObtC8P0kuXwxsZxMLPgyC6R66d5bpH6Jv34vnYs9V/HW1qstmkEkf4bZBoNIgK6ioqKK6HpK
			glfI3vOa8O3tFVq4VpO+tXT2Ri+p3ydZs7JvdEuF+BAxDXIqeVs8cC5AISdgGxtJ+5qO1En4GrXi
			sjF3liWwUafLS2CTSZuyqtMK0ZoO1uibr7Lr8k1f2SyWNQDhNLkT+BJaZ/2zcr+3b1YIWIIvMzdn
			cSUOgmk3RpjFDfRFnBnZF+ShaC8SI2UrGJtHjF+6WlVL/f4ih5NEn99AJxZ3nUM1GkzqTaVYVRVl
			101nUHlQrhYrMGl0KXWdqmkt0t5eXF/e1eE3latVNmu92lFlM9OxeUwtt6bqRWdXdTxVWa1rby+p
			rq5tfbpT3Wez0XXFJd9+ek+xy9OiAr4et8vuUBvMm86bhPKoi/juam2trt6jqi21PWzDnDK7Kveq
			TsIw/THf9+2f/KT424zklxyqvqe2tlpRoHVTZgatQc41R7FjFO0xKDn04qFgmxFBbC/wSoBde3jb
			gMJyxKAg1wnFZ9CWBG8wSCd0ZfjLwLdA+ca2QN+pSXa0uiqaraDvzEJmYUpzmJwamnpWbe8Ym1A7
			HbumpuIEX+d78Xgi+yypy0Uk9wr4IhqQyKNukASegPolYJLybT8nswpvOts/AJ3pYbqwljT1LrGv
			hVVuO+nlEODrULFqNE7H2BD7H5N2vEUAP0fwXh3qcrar88hCwgzyq/3XupzqmfX1zAckRL87x13h
			YcKsKuatOp+9vvqs6vyAV41UdWCxy1netQ2+DoejLh8kqArle5VkuPos6XJENpym7/Aipwte6+rM
			7/m2O5yHrj3X7nTu4tkpmGRuEHzLHOqzicnd7e1PXM3TF/EJSIBC+nA+2DiXrPjYyreo8VD9wZri
			4sb6g3t213TUGIvBzX01JReK20qK6/cRWOnYVXbwQnFxTenBxsbig7vq62qK9xwqqyk+WEKoJdIS
			t4v3vEssvVB8sKaxqKjedKGkvqauuAYULi4p3kfMPlDUSN+jpKbYXkOX6X4lJoIx4bjkYF3Nv2LR
			mfF77AVxbFO/KD3fvf9RDr7SdmNb7zcft8DvEr5f+Yl8reAbmpnJCviKqjOhNMh2G4GVxOjMzExw
			JptJjs5kk6OjP8gmOdpodHT5n5aTcJvsCy7549n+bHJ51B+/uPxJcjRG55MJXyy7kN3KZDLJzAqR
			OLPgTdD5y1vZWOx0TuwKl2cZqMAN1Qp20NBo25svN/daz5/vfqf3wXm8naFrH9D7t+mj98G5Ew96
			K3tvnNtnfNd4VNfSUlFVUfHdCn1VxWtVxS0VZ/SkfTl2QZvl0uUTFrgGzEjkxm5do5CumlFkLgDY
			lBu3Mpq0nIbcPFZjnSnntGHUxq9M0plDW60SP6wWZMhO0XptAZi+w47sJUOzs14pfLn9yxtE8L0S
			PJ4VA1RiqwjK1++Xg8+BPlbNAU39+vkmFs/+ECIYUHT26lT1Db//LdVZH+B936DFE3E4jgWPq/a1
			Bw61KuJQiw3Kgw4HwdcCO4wjnZ3GtYjaWbz0dJljt1F1tFgt9V03K6xmcyplPkwy1lrPM1Z0PFVZ
			S/AtKi4uKW1Xy2trCb5o63V1lVmsetV5xOaurK7c397pMhsYvm6PzepphT/Wni61pdqFSrHTaapt
			KmL4Aug30f5cYvg61Yqeak+1VeG135RGXoawgkFnxebKl6kJvWZgFyZWJGpJ2T7kJMW120uGiIJQ
			Y7aWBIwV2MBxxpEhHNzJni8r3+ToxTenhKOVhoyr41OJhYUZCd+J+GC8S1Vrxib3dDrUyS+ELzqu
			efh2Ar5DOfhOMnw7Pxh69SaskwHfoQnAV8ffkuE7Pg74nhifnvbRv87niKVDiDAcvOXs7Dzd308c
			1qykFs+SBs4uZrranO9vbMwxfBFSODA/BA2NGSvV2fX+9esvdrHZJMN3qFSF0t0O38ar8nWHgC/O
			vkX/2d6lhwIq3+tUCfI5+DI1r11rbHdgz1d18vKRBt/YBon9A1OTjWq7KgrneNTJYY5VnGcLEhEw
			+GM5/TwC8fu4yret7NCeokNqUduhXUVF5Qc6dpkOqLt37T5QVHqgqKN8z4HyQ21FRYdK7W27DpUV
			HWijW3btais9RNeVlO8+UF5SemhX6aHSXQdu7unYVXSgaPfuPbv3tHUcOFB0aNeBRrpt9+6OQ4eL
			dh8imqu7d+8q6jh0oI2+F32L3Xa6+yGub+8+YOd56X+149buF/L03TZ7dffOR4K7d+5/Ju53m+Fz
			Qev3G/h+qeNwCFFFM2tBCV+SwdkECd/Q2sxMYjQx4w/G/TPxeHz5Yja7DHOreDaTHU3G6HzIn/UG
			1/riyYuLhOOVeHL5k+XRkZHR5eXllZFsIpnJxJKZrRVfOLvl82UXkrFMZmsjdvnnrz5XlXOd0EvP
			KwjXigrZyT2vFZrFufMfeH7+/F//p4oPSvTPvfifWm781RHd2Rf/t1/r0r1/oT/07f/8nyu++963
			zt39y6r3nv528YX/4/if6Cve21dXc+DlupummqK/bGwhIouwYA5TKohFEqKWBSgoamrUishaEJIY
			i5ZkrZOjWbmStBzH0hyxjCZTnr1yYcko1a/mB60pYq3wLAsAO1K+swxfuVrElIWqHff6QwG5bcSW
			kzxxFQj5SOD2yaYuqstBOXCFYSuvN8A7Sxz2y+EKBOhy1XGwpOSgUy1HuK8hYLD0+IvKnWFnmU5Z
			cqrvGNscDxQl0uYoCkYiFovS8Iyqnl+zkPK9bXCq7aUOh87mOtp1s4WVrxklaxsp3ypzymJp6Kmu
			1beDA/Tns1NHTFU7nYfeOXTo6W8rZn2n4/uKLWVtpS+JbgK+iHGIemor4U9Zrzr3VUP5ppzldW7D
			cS44O1VHScnTTz/9J7clfJ90V/dU90DzGgoErqhU16IKnooKQw2b0L10BAIcG8jDzFC6YsZZwcQz
			XR3kFrBhzf8Qwhf3X1uK7Kznuw76/nBqTCpfiaLpeCIxNc7sHZtKzG904TfCbzNDQ4XwLZ8fkvB9
			Dzwdukk83piYGJ5sZ/gOAb6nEdQ7OYGq9QfDQ12cpjCI2L0a+mWbcvDtu3q1VJad31adzmc58hZD
			V7ucBPDseoYDlNT5/sX+xfcwE9XVpToczxLBdmnwnZ8flvAdQQZR17PQ3wPXr6/ThcXhK6oK5Tsm
			giO0Pd8xTfGj9kE3jD9Bj5udp8cizCOSKcMdW6l8OSXhAsN3YxeGojeuxdZxr62R2BW1Uzyp9r3e
			MfkLnZwYYvORQV5sFvCVUQtcel5/bOVr53QFXsy1t3V0lB0qxRwzD0DTFeW7yovKytrEjHOhqXOH
			vbysA5tHbR32NnxJB6azbmJ0qgiDzBjlOmBPs6DFyYFDGG1u4/VeYLZUs9EqxcwXPca/Jnw7Om7l
			2Lsdvnfz8L3zeXm/nzv6/A18v9RxOEtknVmRe0aYvspezPQt+UOkaBOjmcDKmj8YID7TpUTyB0Tm
			TBwek4lEJhAMJOKhYF98Obl48QfL8cToyG+JvsukfD/JEJszGYxmZRJhfyyT8C74krFsZiGzHrsc
			u3yu5UnN+Umu5dTVVZ3qlWNU2miVVms+f7zq53/8v/3n8x8cOPXkP36n58bzf/LUdy/8l++dO37+
			1ydK/sv73+49+93zx8/9Ze93v3f0O7V/tKtOX/H+r+su7Pl2VWnVmaf/surGqaqqU/qqU1VIFq6q
			qtAi7LnDC0iyNJXtWyFkTcbcTpBWeTbKfV4e05KjWPLQMK2NR8uur4C7FjKozz9OfsdX9xXgi8M3
			K4vL7DOJQvRsyOvtE1FGIr8oEIDzRgBXB7wh4ckxK002+B5+r1+0g3kCi+AbQj3af6Oc5Am2gdTy
			FijfoL+51V/f2fmO2qmkDMWqw646lm4ra2nVoYftlVLp6FQtBivB16AYHOWO9vYWm+0o6VSLucet
			HH1CTaPsXF6VSlnhcwXlq+4tI8Gqe+opgq/qaH2KrnW7bE861LRi3kxZHJ0nNzdvE3zh69xTa6vt
			6XH1tNJTegqzyqm2zrrU5nFWvio6xpqO3XzJ0fmki0j9FEnfh7LibBDTV6R+zT1RDu618ZqRSzGb
			UWsOB4NcXBeTzpGHa1xrxjrvbcQ6Yas3CPkP9xGsXin+tdmd9HyTf7/+91jRe/OHE2NjVwv4OzZD
			8BWUmoxn5890tZffFJF656aGnnM6Gb4JKN/5wRx85wfjQ88K+LLHch6+4rjpVAm+77LyRabPZ+Fb
			RlcAvm85nM5di/PDQ9z0LXJ2dp2bz6xvZDA3TQTrX+xwOJ5Q1Zudne1dgK8D8AV7B4cxWjd0/fX/
			s9Ph7MTKmEP9McGXXjrMT16lrwZ8hW+1hC//kON4F/Adu6p2dZZNAr4Di6cxejXHC0I55SvgC5ON
			5+nx3ueer6qWZ5JJpD3d7MTsmGoUKcli4mpesJc9Nxi+LH1l6fnx93yBQRXrvaUE3TLmaDlY2lZU
			hn3cso42MJluhadGWREWeXcRYIswu1yOfwltpeVlRV2lWO0tBX9B1FIiXhEGn9uAZuJr2wG1qAxz
			0PZ0aRFWh+3EaAxDt5XyM/jX9MPaa++4deiF/PExM1jDL5edPxalZ2F6Vcjf7cVnxu+vXvim5/tl
			jsPZRHwm2JerOs8k3iTpG/Kv0dXZxEyQlFIiMUN6+M1sZnQ0G19ZiYO+dI7+aM/QdfHs8nIiOYpq
			NCnfT0aXf5BMLo8sXybhiwp0MuHfii1nfN5EJhlLLCS2YpcvL187d+WGgC9cqtBlrag41Vtb0N6V
			81YCxA/OPzjxoOfBjROu8ycqUXg+8YCutXl6a99ofYCbe8+/92TtuXNPPXXqyXMvHG0hjlfVVpyq
			PXXqBqIYqk6dOlVxSjuqqvRS0Bq1UAYej4bfFVye4XZlyoPSlHdhNophLFSpc6tIPKtVCN+C8ehc
			yqBRlzeLls1fEWLMbiI7WzUKCfj2zQakJTOL39m+QERELbDxlYgz4ktenqPi8/6+0BJGrgKyZB1i
			32c2vAqEAj5RyT6sqjUHDx7cV9+plgWCgG+3u+mE2u5USw0PlQZIkGJCrqG3TXW+pBiCvc79ar3N
			0kDwVcxEYoKv0ePad1NtURRL78vOLrUhZSblW5FCgG41w7e4uvZJh6Mc1WT6Q1pZ29PQ1FRbW1nW
			5dRv3jY/rTqOAL5ddkWBHXOPDWm+lmKnc3/v7dubVTfVis3baVF27nSmeKhZwNfZ+aQHD2pV8s3e
			fJHZ0qNADVvNPTbzJsly8NbgfwjrDMYwxC+xFvwljXt7LfgQi0WG2w8JwUH/Q79IFgwbln53pOA2
			5ZvcIvhefJPzjPL4JenrnREzx5OJ7OKLXQ616CYRr7Pz3aGpK9Cl9KI4jmmkAvgCMc9qylctgC98
			OIYBX8cHQ0OLrHxJ0U5N1jgege+BdrX9BJQvwZceb3h+iBTzUKmzU32uvz9zbQvezsNw2aDv0vkE
			lLiza6N/jqRx51lmL087OyZWr79IL7r+9Nln/5Tu893rq+t09/jY1fpOVr5ahX0Pwzff8xXwbVG7
			iJ3D7Fb5bKfTcWVufVvZOQffjXP04M9CF2N/e/1S8l16gPTesiL6qQ7JmGTOhhicl8J3SCs752MG
			Nx7f4aqUDalKO3I2Vx0Yw4JTRkcbDDOw+svCtuMJABg4FkpZ+HK0aV94s/TmTSwnEW+d7IyVM7Hq
			ENZZRVhiIpzL78u2GumOUpa8Hf+aoYV7SfkeeOFAXvzm1O8LH98tgO/HOdPJLy4+Y/bqha/+VL5e
			8E2OxkM8bRUKLq3NwDMjToI2mJiJZ2cIvUHO8U0kYomLiexyZiWLujTSFYjTM5l4kqTyJyMXk/GV
			BGneT0j6JkeT0L8kfbOjy8uxrHeEaEzsJfpyEuHy5cuxja2t5260VDxX0aRHsbdFnxO9tdqElRTA
			jOAb53OjzpLGEs29vblZrNre2lNs+lwhQdur0fZUwUEimOjL1NWZtJhBrku3sJYl/jbWGU0aNQvT
			f7k1zCPZBXvAbGtl0onZaYFeDb9a2lHucbQwX5GbqKVL6Hfi7fwEwzfkm5WpRiIPIUAoDkXYLmNa
			BB1xSCDv+i70eWWgL+ad0QbmNGA/kpB8uEksAPeRCg4FvP5up1rCveC1YmfXOQMC9MLNJyr3k+6s
			gskxEl+b1zANfMRxEysvapuzuMHa0Nyllihmi1lHf7L1DU37TqqO9i71ZrvDWWG1pI60OdrpD2Z7
			Z3tLta6zvYSkbk1n557ap3raOztrn6ptbWpobqo1dXao7aRqnkgTPG8j2tWBlPhTHpvVarFZi5A7
			ANGjVm3eLu1Sibhtzs688jUfcTqrHtRWu13QuLfz01a35XaR2yIUcgoRwlZiaRBDVmvwso4okYhC
			l4LB24bbSNJEtRmvMZbAYPppBXoVBC34wztRvnyAvoNT25Tv1Yl4fGacMUXwTRBIuzD53KWqB+JD
			yDfoov8V+fMQMhnOOB2O9wZF2Vl1XIOqhUMjoeeQ0yHhK1aN6O5/iiBeBN6OSfiS6nTwwNVYI/1a
			L1wdv6rrcDq/Ozg0P49wwqFbanvn6flMdv0NOKOQlhzYoJcB788t9p92qsDyB/SAZwcGUKaegPCc
			WF29pTq6Vlevr3Z1Oj9YJfh2qoGxq31quej5jl+9mle+4zzfNT5OX9k+jr5zZ+f02DR984F4J9MV
			A1dz1+j1R5eYtxL2khvX1p91dKlv9S/OYa95fXTuFr30g+i/qTo72B1M/Nhsrcn4lT1fPoT6zcP3
			K+/5MkKLAFw7O12h/kyP2AERbJcl5TaiMVG1o6zoiaLSjqJddKNd0NdeWl5UJpwmO26Wlt7EylBR
			267PkPQPFjOICvdeu/3WgXdeeOGdF7YfDGCC78fb4SvkLxD8t3n6FphO3jnw1QvkXyv4JpJZVJ2J
			v33Z2VkvKdwfZrIrQYIu/c9P9F1amYHchaVk/IdxXj5KxLNvJuLBoDeRyMwSgy8tk0aeSYyOXvrk
			k9/+4DLhd4T4S/DNJC8n/z6eWcaYdGwhm4QaHiGlHNvIbm1ce+O5V2+cw4ZuVe+Tor5csM+rlZwZ
			xb0PHmjUfcBSV148X9tb8BUYfO7tPVUrogdz8P3MUVVVkV/l5TyjFn0LgAh2Ngqj51xEUm7iWZej
			r9b01ew1RANXV6fDJdbOsvKsK7CbLlgxkinFSCeuEKc7UL7jaPf6ZsdRQvYHQtOzIWFfNetlpLJT
			c24Lid67kVSkRR8xmqcBZa8XM1YBnz8k7h4IeH34RPqyORwksbym7L95bMlgCBKWmppqCL5+YlGw
			mF6EBw1EKIPhyTanvc3Z5qzwP7A2tLY5ilOKYoi87LTrmpvr99Mf47Y2h7OMFK3bfcTRpsKeqr29
			pVbf2Unwra4sVR1PVjYRX5sQeESauLW1ReX1ztKUNWVW2ujBnfausv2VNiVqNpt7lO87yxztarmz
			3ma+fXyvumZZL2pz3s5r25ec+2uV6kqXpcdlfaThK/q83AzeJMkbaXB3h/0G6Nm1YFAkSKDn6w+C
			uUHEKCxhzMqAjTvSv3wPWZsOBn43fHPKd1Sj78WLb/5wWhu6YgZPxRMzYv9oKptJdKpdz2Lr6CaR
			bWpoioh267mZqXdvqp0fYJpIg+/Q4NCzvBY0RcpXwHePs739uWFsIQn4EodOS/hOfxa+IVLA5aGx
			q2XlTjUDanHM8C3V6Tid3chmFgDf/sGJ4TMkwU8vLs5t0H+QdxcXPyAWX5inuw8PTTg6nZ1jq6t4
			XYC5K9Ku9Jng20XC+uquz6wacdm5EL4hR3nnLjiLTA3NnyVF/XxGbOlu0A90M59qRPDdWC9q73I+
			t3hxlPR01/rcPNIhiLgTH9BdOfgYHl1D/AvCZtWA3PiVIQty6vmxe75cP+4o3X3g0IFiKFugs7ie
			cLx7D12/q6O8qGMXtO6uPYTQ8qK2mkP7Dna0FR84ACgToHcdJIW8C5q2lO6JyalSmHY8Cl+trvxv
			H7bQYT+ZTqePffy3r7300ku/fOmlX732MwLvn2n937v37gjlKxyvflaofu8UVJ/zrd/XvnrL9+sE
			3ycOJy5mZ2ZQdQ4aLmaDUL6J0YQ3GCSeJmZWFoJrIW88sTKDmejRzEpiis7NZN7cejMxszSTnR/N
			EHwJtPEgAfriD1B5XvzB8sgnIyNZUrrZ5ctQwMsXlxOZy9lMJpaNEYBjl5dj61uZ7MZW7NVXdSa9
			mLOSS0V5was1fc8zaunsg17JXQFfnNbmcO2mhzh341xt76mq3kfg+zkUfrLFZOJkhTqmrL6FtG9L
			C3jaqNFXy/PVaalJbAzNsNblDbCEo6SwphQTWI2FjWMR7pCjuG67qxfTd4fwJeyGSPnOhvqmpwPe
			AJye2XNj1su5RSFRYZaGkgH/7AKgPM3TVyLtSGhlr1ckCPrQ8uU+MbZ+A6Hm5ia/Pxjw+5eWmrsf
			GJaCSwY/nI1vPHnCHzEoSvjBgwdhw+2Ht9cMkaVm/Wu6B2uRsBJptlSdqETor0Wp7G0wKA0NiN6t
			fKqJTipra59q0Q5iMZ0+Vf1kbXVr5flUqqey1uqytrptDW5PbW1rS/3BmtpWl9tmUZ6qbG2ia2pb
			PWZXymp1W0nCnn/pWxWpNWwNnX/wxvrrr//4x6/2maW6NadsDx6krD3VLrPNGjV/lr7mVG2Pomwq
			5kjYF7ZE/ATfhwHDGhEWW0RhEeXE01W88gsqI+3rYRijV+FAJNyNbV+6m+/LK9/RUU35jl7Etm/+
			GJtKJOJC+RJ8rxF830UhdQ+9RklMxd9Vu0j03ySVq14bRlGVy86IBRbwHRoanuzS4MtmUF1dzzJ8
			/xS5f3tJlU5NAb6i5zs+xvDto+/W4WgncdpernY+y3XfgfnV4f5nCb7PLWY21uMir2944n1Sp+sk
			OeeId7cWBz5wOOF5oXaR8ISjx9WJuc5O54vXSfq+SKAfWF2n2wDfE6rD8Za2UyXhi2+P1xsM37Gx
			E7z6iyf9bPwDp9pZpuKRn+f4wJv0Y3epVzTlS5+71A/6By52ORxd64vYPT4E5fsu/ewJ2H3hY5CH
			nQcHcGB5SeT55vn72KlGRY28yXuwpq6k/kJN6cGamuKaffUljSVtNcZ6e3F9Y82exmK6lu5U31bS
			eLCR94FrDl44WFRTd+BQY83BmsaamsYLB+uwhtR4sKi+rr5+z2e+jQhO+jfPGUy3sQHmM3975JeF
			B/H35Y+l9L1/n5XvvbvSd/LuNv0L8fva9rXfO7e++l7U1wi+5Yfjo6PxANgL8Mb7Zmbi2WwiTn/Y
			Eyvx+EofHDf60PVdSYxm43B7Ds544/E3kzOB0ArJ5EQ8vkx/WeLBQDyb/MEPPln+5JPR/uwPlpeT
			GVhgJRm+l5OxzGUSwssJwm82SdJ3OYZFpPXY1rVredw+yK31nu/BKevdBw965W3i0oNeid8Hj5Sn
			WfrW9jJ9ewVx5afc55z2PXWjSq8NJQOS+hb4YrVA0TYKP2d9PjxBTCdrViDaIlFupRf2Hnq2mmzE
			wHQjXy2npLXtXs3XUss8Ql6iAC8r4J0oX4BWlp1J6vp4vRcrvP4ZGawAzM6IXjBd8PngO5l3f5Yu
			kwERYeT3z3Kur3CahMdVt98bCJL0XSP4BEjxBZWwAePATZWWiMLbrw8fKg8VM84qtxXDQ8hBJWVt
			iEToOsVqabBU2qxWaypliVo8PRiAAn1rxfFkbVNDK8IFSfu6UuZUKoV7EistyO4l6NIj2DxW3KPn
			qdpWq4Vu9SCP153KQ9TT47aYlR+/jli762yjcZtYm4Jlhjn1lMvsoUexoRcsVo7yh622h9R5GMNT
			YX/gIb2uQHU5uMb5iUG4WUVEhnUQDs6oOwfXlh76HxqIuQ9Rb6ZfUDji+93w3fsZ+F6kgyMWtKrz
			GP1vllO+2TMEIOwLjd14olO9MhOf2XVTJRapN2+9T/JOwLfzvWFUVp9VuwDf+WENvoimwCrXs8OD
			dNV72BN6vqud4Ds9TsrX4ahj6YkhOlK8kJ8qF/fVdaB3YH5gCHu+js5XBycm5uNd7WoXwnKx+bs4
			Ryx7Vr3ZNTDwnooRPNWpPjsxic9XJ86qavqP6fd//RWn8+bG6pyj82YAP1mHhC8DWFs1Esc4Mbd9
			7OobJL4dxHbi6dQHTjys2u50votUo04647Q7z125QDgm+G5cUbucXYsXB+iimhjKdHV2NWKw7C06
			c1Z0eUn4DolNIyLv4iK7bKxvFOL3sb2di+pLdh80XigpObiHCNxR3FZfc+FgY3H9wQ4ickfxnuI9
			dLnmQk1RTfGFXTVY7SUCl9TvKS7ec6Gm7FD9vn10c9HBAxdqsPJbTI9Ss6/o4O5H4atlBv/bspdn
			q0++/Bok7y9J9f7yL/gN53/GzV+i7/17dyV8twUuaFu/dx+de77z8S37N3m+X+IAfNnbGVRNJLxY
			PKJjKRQM0KUQYXktGJqZIWE7k0wye+l+gZnkxUTQn4gn34zPXPrpxdHRLF2XHb3YT+xF9sLIYpal
			L1ecs5jAyi5nEoAv4TeZvJxcvpzJbCWSsa1YbOPKG28ApB7Wtr2FcveBFLy9D2TNmVEsIIxPmNE6
			l+/8nug9V3vu3I0bEr5chC7E7jYCPwljD80fo0VoX47wbUTZ2KhlCuu0LSGdTIMwin3fHHzrTMLe
			AyVrMbFVYLKhuUuy1hXStyIXnfiVlG9AlJ2nZ6cR0StTFEKcdDQjV4x4i0j4Tob6IHFhOwlXLF7+
			lRELGMASSb8hkS/o9Xr7/P7mhu4w2BsO8pgv0mt5+dXfXNlkJWXLi6/hhw+DHLuHA9nzBGNLJJyy
			KRYrIbcharM8sFlTFpvbanW5KzFMJelb3drUigJzNeG1x0VkxWG2gNL02cybwYTtSo7/raytrsTD
			pMyuHovs6xJlCe2tPVbfdYLv6upqQPOLTCEmwVpb60p58BhWc4qDAguUr3nT4nI/8BN3/WwaKeC6
			BODCQ0NkGAeVJQNpXDhtrD1UoH8fPsTPT6IXrA5GvL6VHSnf0dGMpO+bQ9PjOS5NJzLZHwK+Vyen
			4vH3kbaLZV0fAer5qfjUVKOKlIiycxwFPC/hyw5XnV2dG3TdMNTg1PDQe7gfyUX1T4cHUXbuR0R9
			V/lesJeVbx3vM2HYCcp3fOwgTwuX9C0OMnzn54eGbxH3XsXw1QSSBxcXt7B23EUw6+9/jzR1/+B7
			HfxagMTqxAR9cdvVsffpPOKMro/QHb6LgasuwPdqfaG9ZLEIVtDgS9/4iasCvkRfh7N84j1sadO3
			VG++P4f4QPZ27pLK99rGxtvlBN9Ysh+CeGr4LN3jGhy5pujyi8OCvUOi5MwuV3RcYsMO4i/eMOz8
			+Mq349DuskN7Sux7dh86VHKo9EDHgZKS3XsOlBwoO3Ro964DeCs5sGfPobIDh/aUlpYUHdh94NCh
			PQd20V0OHego3XPowIGSXUUHdh2ie+2mu5YcOnTAfujQo99GRPyW/ZuXnUvtx/YdeenIS3T8+pd/
			Qad/IQH8y5ek9L3/EeB756O7haELhfpX8ldr/N55If0NfL/McTg7mknE1/rWgjN9M96ZAE82z6z4
			g8GVYCBEUIYtEt0QDBGV2SKJLq7MvJmNh1biK1mi7+hPf4rRrGAiS39lLmLkKpFNjiZGRrMZYHc0
			kYDURfBCJpaJ+ZKZJIrRl2Ox7Fbm8tb61uX1rY0rTU0sc0HZ3hx2a/OFZ6l6RctXquDzJ07U1p44
			JXvDvZW9D0Tp+dypWsHdU6c0+PZ+Hn6rKnQaSPVcdqYTVrIEUenFLNEpas/CmstYV3f27Bl601KO
			6GgRPh2NjVx15o6wqFjrdJqdV4Veej1XVGjGGxU5+u4AvhzN6x8X+bzc2QVjZ6f7fGwzyZenZ7QF
			4FDAF/CKySu/gK4YkuZTqF+ib0BacNClSKTb0uAPBojC9F+aFCKJYFDYEPSHuxsarAonHeGE4wcQ
			QEAIxsaRWTErkeYGq80WVawum42gaSYS97iaoq6GWvBXwLe2srqyld5I+kZtVhswyevA4pQOhS+Q
			GHZVPwVEV7qbolGLxcp8BanpTMrS09O6SH/56ZB+kebbKRK+tqdqPVGLIh5sUzZ+FW0VaVOxRJoj
			xN6gH1POXFimF53d9ALTQGcM4TXDUjAcCQUi3XgFsraEPOMlQyBsgOINolYQ5NDjnSjffvBXSl8u
			PAv+Ts7Q/x0z8Hom+M7Ep9glY1JmHtERJ/WLz0PDgyLDnqeZkUHEzd2CY1g7cGGQd2f7ETUva72F
			u8W55iuOiUV4TEH6Diyuz+GhB0hDTgwlJicWM0PDE4OwjKKHAtgGtW8E2Qmn6Ktjw6vXVxm+/F9h
			deLq5x1j2ulY7oCzljw42mGev0s/z1xpo1LXtAPwzGSSIyPJi0NIP5yQTl5yzkr7ieFtNc8Wk/xA
			cyNzI+v54/ex5/s7j/TvvOILr/yDHWkc9uMnXz5Cx0sv/Qr4femXv/7lL3P0/eVr3Pa9/wuUne/f
			K8z7/dnHdwt7v39bOPh851Z67zfw/d3HEwTfN0fjK5lMsC8bmlkJxOMkn4JxLxsRziwJSUxgDqxk
			EyvBINw3QkHUpuPBEME3S39YfvvTn2ZX4IQ1OvKD5eXRT5ZHRn7zShKkHYnB9DmDRm8Wa770yZfN
			bCXB4suZ2DLeCcBbG7HYtcsnuKmbn2R+kCsoPxDYFZ9kCfqBtJusFWhuYneOc5W9506fvkHXArS9
			ueKzfK/NXeYJ6CdPVenF1pCxpaWC31v0WpQvxzO05N2nNUtM0smNZz595ZVXnmsR1WVu8UL5olnM
			QDbqpENHztuZ68s6rdErqEtwr4Ab106VL+gL+M6Gpomh09Mi2wg6lmg6LV0nZ0Lc5w30Bbr7eJtX
			DmKF8plHsJOkG7B6xHaTfjajJOXLS8CBpSA8Nug/fii4Bu1LYG5QoAA5+CfMEvg2aUd8kEKEJlas
			FotNsSrmKBhss3pcZnO0qbbHaqtsBnern6KT1obq1tYmhA9ZrSmrVVBXoU9KjsAKE5guenpIMzdY
			W109HpfHarUoIgUQd+yp7Oc/+lMCrSlCr+Kpre3p6XmKnoAoOZuVlIJ757VvBGIfE1YPIWKXgmvh
			paWwLxBc8vthpxEkAGPtiNiL6EAs+Bpw7yDR1w/0BtdwsoNUo1HSvVx6Hv2/ufA8NZnr+GbeYviO
			XZWpgoDvBJM3PhSPzyPNFwXVefZoxpixwK+kLB+DXHLNXeD+p4Dv4PBY3lBLGzfmT5MIFcLHxGKC
			qTXA9drBoVWCev8AIRfZh4n5iWG6TXhaaXs8Ar70NPG4wyg559g7PHn1XzjGvvCWyanBea4V9xfA
			9xrcqa6JT3CITMZGkgPDcpV5UrBX/sDDQ8ReTEv3D6yy8r3UP3eJ+cvcpU8jj73n+7/2kU7/5Miv
			vvXSt+ij4ACAmb+g78d3foFkIw2+0nTyLorPf/uo+gV6f/UxwfcrP6GvEXzLD8eJvisJaKXMWt8K
			qdpEAHQNBQMzXm+QV39XwN+VmRXMQPPZlb5gX2gpmEDe0Q+WR/+ff1rOJrOB+Cejv/3ff/vPn/6P
			//G/zwX6RzILMIFezni9SXSAk7FEZj2WTSzQS1mCb+xyduRyIns5sxDLEH23Ni5ffkMUlnmsivXv
			iUL4irpz7/lcw5e0bm3lCY3GJ5p6TxB9e08QfM/1CvF7qvfPmb9/3ntqW+u3Vy4g0UcVi18dVK/A
			r7SONAn66pnAGn/1LUY2gj79yiufkvbV7J2xnKTT5qRFPoRO0HebjWbBlBXzV5O+O4MvKswhkSQI
			D43Q9LQMNiLG+n1etpQksTuNeMFQYHbW5+9bAHG9SC/C0NV0SI5jEWt5CUnMZnGcoL+hIeJl+PoJ
			TSBSOLCEGSQEDPgqGwz+gEjeI3yhAYzcn7XbrICJvmHlgWIxm63o29KbxW2zWhULsNvUbBNql8vJ
			tU1E1KZKa0oUmQVsWa4SMR8CvIxOUNjqdveQWrYQqV1Rjxt1aiA6Zbba5vivfp8GX0WJ1ro8tT2e
			WoslpVjpi/GwMNSAWIajM32LMMMXY1RoZBvolGS+zx/2o3NNPF4yBMNhf7c3HA6i9avwv3bDwyBp
			ZSwZoeqMPvlOlO8oK9+c9J0Q486TM/CgmRKrqpPTE9NM3aEpIeX4WORpqMH51YEBsUcDF2YmT4H0
			nRfmToM8B808GoTL8fzQ5FhO714Fdq9K1Un/XKb5GJtalHbI9PhzEI5E4NXB/v555B7OTA1PzDN8
			5TfPs5eF79WrE6vXJX5Z+I5d/UrH2MQQbJkLlK+UvJrw5VzAJMN3Ur6JFyCa8gV7ibIk9qX0pYdi
			/GJ5GO4dc/8myvc/5oHk4J8dee014Bfvv/7Vr1n7vvQXLwn6/vKXL73wwgsCvvc+2hb3mx+9uvPI
			3u9rL9xK7//Kz+lrBd8V+ruQnZmhV/SzAbR2g30zSyE/FA/9cV6C0aQ/JKEbor/I9EYMDmQT0/RX
			O5tcvvjmcmL5kx9cTMbil/+ff/r//tNPf/o/fjMXjweC8R+PJrLo+SLnl2ibSWYTG8mMjxCcvLyc
			gf/G5WRmeWQhthHbWCclHFt/9coDUWh+oC0TSbKe12rNYtxK0FnOSJ8XX/PgwXnpTQk5jOoz07dX
			9H97823gR4efW0wmoXJb9GcA4Rx9ORFJslcnB59bzpw58+rPL3/66f/7P083aobPULxGYdEB6orx
			Kgw35x0k8SgVIu0hd+joG38l+CKhSOT5isFm9togXoKyIu5oZUZMXtE9sVLkDwW4+CwI3Cdbvxhw
			Dsg5LNSd+7zeSFNzJMAameAbCgK+QimiDhJuqGziPHmE6ykPH5LgNSsgs5C/BuJvEwH5QUSx0Jsr
			avO4rC6b2dxaW00KtsnaQNoX9G2tbiX4VroKKs2sZtFRvm2mhwE4hQ7Gacpmc7mslpQsTvOUFs74
			xJ99C3F3M2VV6LvZrG5Xj7UnaqFv6vIww/FN8Fji3Uz/rImjeC2BKWfoegh5+hED4Yif1LABU8/+
			7ghWitD1xRaSOMGMVgAOzwH/zpRvP9F3TtCXxO/gD6Uv01Q8ER8ixTulHYSROBSu6GBKp2L6+Ybo
			fVCr+04I7VtAX+lqLO7OMhhjv/PC0UPTnSjwIkaXAzT6iL6QwRK+nEYwx6PCq4MDxLK5OQ5AHBoe
			5Krz4sDgvAZfoXuFyJ0cXs2zd3jiy6H2c64anpfNWphc5Zwh84XnddyUnJtn+HLReYp/A/JXQOxd
			X99aXxfwFdpX4lcEDD6+t/P/sgcCgo//2WuvvfYt0Je0L+B779da9VmWnn/18Qt3Prxzn+B77xHP
			Z6bvzz7b+r1z6xvl++WOwyuYbqa/sCHUl9cCMyuhlRWi7dpSAMhFwALIixtDoTUAOBSMr6BYGZiJ
			xROZxPJybBSRvsuXLyYWL775yU8Jv//j0j/NhxLrI9nM5WzWl4jFR5D+S0I5lvRmtoi6y4hiiEEP
			X85mtmIbdOXlWGzr2okHD05InfvgfK7SLCatzj/w/LcTJ3pPyI9z507gOA+5ew7X9Z44Rwedp9Mb
			p08/RQDOq91CAj+yBVxVUVVB1D1zBmTVteh0Z/+RRK2x0cR9YAKu7ozujPGMkd7PPPfcK58u/+Y3
			n3766SvfbRSpRhx41MgOHURTvez0yhFnYLeihe00KgqOqiquOOM6Nr3cCXx5r2h2nAWwX9hFhmTd
			mbUt6d2VGaIv7/nOhrwBLy8gweLZH5jxi+AFMXGFLaS+IC7PItHI193U1Ar0+hm+QBMp4AhecBkM
			9OBeUq/+sBIhGD1UwvTxECPPLH3pBN5QisFssTRYoDltUWtlj82C3q9LTDv3EHFZ+laSBm6yWMya
			NOW2rKg1Y2w5z0qFwYkJrJ5WW0oe5hTmo1PmPi55DntTIsDBioQlT4/b1kPf1Wo126wMcfqyhw/N
			srUcJnY+jHRHMMocFN3sMOrJpIUjYZ4eMxCcfRFf2I/2L7rCDGDU5f3EXlLMATzGzpSvxC9J3/+b
			C88kQKenprBhG5+Jc+1Y4hPTT7wzM0gcpLchwi59iGUaWXhmAGulZ95vJVaLN+mxiHsP59grrB0h
			eGdmQlOhKYBXtFuHFrMMPYxVofpMEnh+dbV/jjT3EPySYTIplO/8YF74TkjhS9QsKDv/y1XnzwCX
			nxSrfqQizEv4Zlj6Fghf1r6EVYIq/USyLi/gK15/oMG9zuzNZOhuqyTV+aHwaJfm+h+B7zfK95Gj
			g+hbcpTg+zev/c3fgL6/Rv35pV/9WtJX8LfitRfufnj/3v07BN9C+ua178+27f3e+duPb92yl37l
			Z/W1gm8ocfFiFmlzxNjQWoh3jgIzYX6Rv7Ymw31BXhbAfDnQh/uFMm96/TOkbUeX49nR5A8S8Ww8
			m/xk9Kf/9Mk//fiffvvJJ4v9yU8+uRzLzF3GAHRmNJnZAooTyeTyMlywkpczWajfGEIHNy7HLme2
			rr1x5Q3CbKUGXnG45Gfb/28Hx88x9iz1b8GsVeEIFpq/6A6fgskl6NvCAMY01ZnnGhsv0FkirrTF
			aDHixtOxT3/7m1f+8fSnZ797wcSuGkZp88xFaH2LTqs2s4EzT1pVyHfJXfhLaycVVTuGL3d14TFJ
			r398YuYqJKRvQGwYgcO+vpkZsYLkY2/JWdw63ce7vX4vG10FZkOiD4yPWWwfLbzdWtnqC2HOyhDk
			YoffgKwFvDILAlINkeomSxhxC362nTBABhsw97yGuas1nn9WbIo5klIwM+VmEWq1IU/hKRC4uqGW
			QfxUdWVrE+lZLg0rmwaz4TZImQJ8IYOVh4ryEJ9E/dnq7umxmAVzGb+E4+65uf+KcecFCy6lmMie
			WovN4vb0iLu46Usw9mwzi3tYIn70bMMK5qsYvktLoqsbWlvzw0hDCF3YXoXDS2LlCOGaXHQPhlGu
			pn/79H/KDpRvdlRUntnkCsfgEDd2h1BiHpSSVSsdg7ir+KAzg/JEbLFiqEikIAwze2XTU8jeAXHM
			S0rSMaHBUHR7p0N9cfxrmC6Ytoby7WdWzTFkpQom/TlEwF9lIs5th6/ouWpYn4Do1cateKYqT1bp
			5iymq8bRaGaxPUlnJqfxJprck3Qd6s6Svuuy65uXvax86fYhVOsxjTYpW77i1Ycme3H09w9w+xpK
			XkPwJf7ZvlG+X3ik3wF7Cb708au/OQL1C/ZK/fsXGHzG1FUOvtszF36mBf7e3b55RMIXDtVf8fha
			wTe4cjGRCIZmgFPSvf4lEr1LgdDSGtpeLIdZ7fbNJFaA3iX6U78SXJlZWsrESTTF31x+8/JyPIHl
			XdhvvPnpxR/89sfx+FTfTHb003/+59/+M1F4OTayjIWjTDYe+3QjkxldxqgVGIzJ58xWhuC7HiPl
			ux7LxK68gWZvXvM+kFPOtvM7g+/pE0RerB1x7VmDbe+fb1O9fO4Gid8nq54T9D0DnfsKjn88e+Y0
			LvI19OnMc6+88ukrr1xeJvhefuUV0seE6DMmzk9oZPa2MHwxWYVAYY4uEg1efQF45VFRcGZHZWcu
			NWPeSqQlyPJyX2BGFJuF4eTMzIqIWyD4+qc5SZCADER7ediKvxC7Rl4OFxTD0P5Ad8MbHEAY9PP+
			awjcNZDWJv7Qw4Z9kdpaF2lFjCvBbJEgpYS5/ozqsyLibw0pJWxWIsRSi9WlEP5sFouV+73VtbmZ
			Z2791mIYS+FRK+Jvyizha1Ae3laAX8VsENLXrFgwwJXDKEndhf7XX3/9v75Of/vXu81iZclGYtuS
			svIINX1YPQruTedFqToSiRBJMbcMUSsnnQ30T9rPgDUEBH79PFJFZyJQvmui5M7j3gxiEsHB0JdX
			vhdHc0dSwPfivJiOmmdwslZdxfswTgclcAdWUewVbwOD80Ib5umrSV+538oFV2KOpC/uAX1KMATz
			pqensUs2BclbKD0nFmW1l+GLFVnQdz0zJ1dmBXtz8BXCd7gQvsxeVB8mJse2HeNypnmSSQvICuBO
			i8my6ekJ0Je5PDY5pdWLZdf3WuFByncRSn5M1M4FfXNDZ4Bvcp3eM3NvzeF1wuA8K/h+8YDy+Eb5
			fuGR/snR73zntdcEgAm/3zoii88vCaurv8DbL1+684t79+7d/+jeCy88knj0MVteFXpO3rlLwjfd
			0fFN2fnLHIf7AtnRmaVQIhgg+JJ2Wgn4uc68hFobSo7o/jGB1yB8Q3y2b2VpLZ4JrkDG0t+VxEo2
			G7sYD8ZXVpIXf/rTT//pn36z2N/3m9/+ltj7z3T8dvlyNpHJZLfo7sl4NoGGL5ttLMeWP9na2iL4
			ZjIxLP3SmSsPHpw4oYleqYBtfD66I+Xb23ui98bpEzz6XCsIXAjeJ6vyOviGuKKKCXz69OnLn37y
			6W8+JcIK9pLmpc+nP/2fKDfHYqdfeeW3/+OV7/4jAfrMWaNJp5PbvqR5TXpZbW7hSWk6cru8j0I3
			J3t3pnx5mwiJRWwXye9cgSbg0t/Y6T52kFzxrqz0zWIk2u9jy6tQ3wwp35CAb6hvNjRNWtePuEE/
			F5lDISQK+ny+bu4O039ret0VWgJ5/EFeO4Lzhj/cUNkQ5jksnrpi5+eHInce4ndpzcDi92HEEg6b
			zRGbS7GZGZitKDi3ArutWOKtFCCmc00ei6JNOAPaGLqiB4SJB9QvTytrvV7IWChcqNjF119HzZNO
			X59rxrUQwKAt6twGBTi20cVubZgajx/BEFk4gN1leqr4N77GJhuYcg4KQyv+506A9S+tiRvXxD0D
			KEBj5IGXr7688r2IFXjJXgnfATkctcoV5eFVlFAxaTwECw3WuQMMXBbF82LYeZEZOTC/bbVIuDsx
			KmWWvAg+IEjKSa7pqamZmSlsDU9NT8swJc1gemxykevKGVmcFQXoRZKQYncHMNSE76A2az0xBU0t
			8Dupyd580bmAvpOM4EmuL5PyBXrHBIbpCjqdZBWMO0wPiWev2WNc24Zfgi9CD8ege8dywndIgy8v
			UfcLf0psRQ2KMsAiF6BFz3rxG+X7BUeahC/B9zvfl/wl/L72rSMvMX3pTQKYpO+dX/ziI4Lv/YLI
			hRcKR6+22W7c/cD+WAFMXyv4BvpWRkNLfdlpErxrfi/X1kjwAr5Bv6g6M3vxZ0lsHsGMnz6vJOgu
			RN1kNp6A8k3O9MUT8eQnP/3ppblLiyOXfnMZ8P3n3/72009+M7qczGazmTjdmc6Mji6PJkYxC03C
			d/lyIuHzQfwmib/0OXblwYkbD5pyzV5RgnbRhR0p3+fQGr5xGi3hXjl8VcvyVzZ/bzx540lx8ZSQ
			v6duVN2oqmo5c/qVTy8n6Tkv/8+z3z1L4D3D8peEL135P//np6+eOfvqPxKFPz396Sv/eIZdnzGh
			dRZxRy1G4cuhF9PNYsCKG7yFqK36/7P3L9BtneedNyrJlu3GcEemTKWuGcIGGoZGYNqOE8cOeM6s
			+Zpw1Vn9oonX8Tj5bGYlzqKajkjKnQ7uJM0bCALE5hUXhu0mQBKAkspImubr2BJRxGnKJtyuI9sy
			Oef0fDMtO/7MFRQwqbhpO9PTrvP8n/fdG5uUZIuJY0/GfAFubGxcSVH84f9c/s+O0PMelS/KVXkM
			EctXVr+zbHCFBqOA7uhc8BQKXrplllRwUkSig7LOOSjMN6CLPT63B3VWqIp2+9zutIeu+zzu3iDG
			Hy0tBfxAjRdSEWMbUA1db21oZGesHm8jzJEJwY2bDX7mb4OAL4nh3kaCb29jI5DIydsOa0e7xcqy
			9xjCz1DCbH1V324lZSzhu9lEtOX5fyh6RgV1w3muvTrPJVnNzNTmrD2bTcNhAwW3BN/fy3PVNNdN
			i6xwQyNfb+QNIRwMp2fk3l3StQ2zsGxm1QsSI6C8LCAMVy+/D6VVCDhzocNywM8KmXXvUkOPd085
			3xARN8byt6jHnQdEZvYZQU9ROzQsM7sihSs3A3ydo86c2pTSVz5mWPoas/IV8OJ5uwRfgV5SlSR6
			ib5KigTn+LgxfV6vwVIGBPAArrkV0rkLbIw8L+Er2Iv3MSRrrafj/NSTsnN3GNIXMWehsrmtWMJ3
			hhU3wr9tmMkAAIAASURBVMx6pDk5npS4ndDDzqAyqV90G0GpzhneVFMZAd7M1GpmdXVhSLT3zuzo
			8RXwnQ8thEILsQV+KCqeJX1FDTcuTPDdV7671tmPf//7H/r+l7//VVK//5GDz0j9/tq/0+ue/6//
			+7/+31z7LOD7l//FNG9wB31/aK68uvbCvffd8DP4dL2n4LvsL2j05yWBnt6gH3pniWTtMldcBeAt
			6ZYwpjvR35/lYCHAGPYXUiQGFK2oJjB0IRHLYeJCIqZWfqMaWVmY1xY0gm/1jZOf+lQVn0+LGI1E
			BMaMJJBYi6D/sVgMV1AHXdRIF5P6VaeIwFOZVkaunVWvVYae9wjf48TeU52nWzHu6ERnZ7q7k4uh
			Txj0BW11KVwv5e/ph27q/svjJ8PV8Bukcx9/6qmnHifyku69887jx7u7u6skh6snq90keqvd1Tde
			//wH33/jnb/6wTs54ft+tqi8mQuusCejzZijxF83PmTQ1pz3fWhPytcLeqYKgVSB5C1T1IsJRbMY
			ZRRgm40kadxUKuUVKEYQmu7nS7Fidgdmpc1kwMtk9rm5ySgw6w54CmmX3d1LiO0N+GeRccDnr8Ay
			3b601OMLLsOFw2mxOTDZp6FHtMY2ovgKNlebDes9y8ubfmhhHkJA+OxtauojIjY0nCcIZpvbO+pt
			iDbDsJm1b7uMQlsszS3NXEHNBpaN8K9szDasN9IZIGYWN4OsaA2GzG3+/T///Wfiz4iKnzQYixNi
			2AhKN2C+kihyblwniq+vN8EK08cfJRvwWQLw9S3zb/QyR3no970B0edl0cor7oFKMz9nh33chgTl
			Swca9qZ8pfgtGtJXduVKhDyjuxPrawDYHZD9Q4ODzxBgWdkVFwYGjYZeDFKY1tO+rPV0+g4JE0s6
			ByA7Z6B6IRrHa/AVd4jPD3BRUmQF43R17bs6Py+eTA86D+izcqenhyRnJyeS9GTTwwg5PzMsRyXq
			6BXtxEmWvwK1TNsA11jTxwERCmefD6GDp4dEry+3G4ly58zo6GjrVKmUmcqUtCFmL2ech00JX/4R
			DC3OD4T4o0I+Tz8gpq+eA2f60tpXvldYv/6VD33/+wRfkr/f//J/1KPPJH7pxIVX0nbjt/7LX77y
			/33l/3rlP9dmHV0Sfa41Hl04e98N+/C9unX70lIKZpJKYmkJvRdcZwL04g+Vl8PMQf5jhMMgMMM3
			SH+dEyh+LixqaqGQIuqqqoLpC7FYpRqunqzQl5LbrlY/RedwguCrFdxu1GQVFQK2ltASYTaZ9BYr
			aEdaK6oIPatqpBhZzQC7mQ2mrx2lz3augd4J34sXafOTv/vJG7Sh9U1s/mhH2Ln1FPGXi6E7T48W
			I+HRzlbXiVrTUb3JdIPwS+w9QV+dx8ukfMuv4pt4/fE77njqDgLvnQ8/TPAl6gLJ1ZORavWNcPUV
			wvDnH7/zxhvvRGCapC86lVAf/QExI/hOxJsBV+4nNq+HdATrUngv8PW6CwFO4XoKqVQQMEW18ixM
			INzuVJLnHBGPuesIZlgiwxv0BZM88igoPbG8dIPH6/awLPYFA3lSwWmXxZKGF3RvAJ/BOAbCEeel
			oI/uCC8OK60GtlpEGNrv74H95CbkbmMDe04Cw5sNxN6eLGLHSOmeXz+/jsJlq6OuGXq3rhkI1u2e
			j1lQf1XX1cikxLyk8+D5etP6MlqY1tfh0Iy5CXroGTI3TYr3maSIev5ec0N2sykrrLGas4TdBmCX
			nkGI3saG5UYwuIfpCTE/u4TmZfp1Jgm8NMuF3YDwMqeBkdtFAzNHoOl/QgAiGQXR+MTJ270o35DA
			byimGYFnsExme3dAd1B8Cew+I8PSfJ8FrkViHWosgHdqYegRGXqel6VTpBMfkZVPpduYhZOi9Mmk
			e2XgeUaZX/gC4fYL9NzdK0VRdDVPH5sBMxGxBcgWznVL4auszEy4GbKn70gHx6eHv7sw2D+tjyke
			n/DoHlZ0/mAqoO9iJceva+VEsABw0t2JdzQhyp7jKFteQARcKt/R1tG6zlFLhuibyRSV6RlUOMdl
			fy/HCWRlWVwM88V3X5xL96cX+Ac0sHO9M8p3T7g5/C6MLrp0nf2THxJ8hfgl+fsfIX+R+f2qnvrV
			LTf+y1/+6C+ffr0G30vE71/XLJ8fu3AvPnz+9O/qvQXfoK9IRC24Z/2FILN2CTZW9EemoPf3+lHc
			jIXI9JLwuZLiwEe0VTBoUIuNaalYLkQieDFXiYXL4ZMNWrU7oiWUfi62KhaVAg8G1hKkcwuwoIxF
			cxW1mAvHCLlriWJibaWoRiL0H5Dom8mw7LVstMr23l3Vzt/E6ZtE2zfo4jf+/if/nz/65k+++arp
			Dp2WE6daT7VaAODO7im21Eq7Ccatq6Oduvo9YTQCk+qlo6dPnx6tvnI8nCuT9v0Nou/jRN/HP//5
			4395PPLKcQLyq+WTP65sl0++EQ6XCcMPv/9OgijKrIT0Fc1FBGAONt8IWSvQCwIDt2Kg8M0PmULP
			e1O+kLoF5mcqFSikuO7KS/D1ed1e+FoFUdnMudwkj/51QypPTIC9pHcJtoxkkTN2c1cRcTwdCOTz
			vqC9zukspTkZTLcjuhFcCnDOIejtDS7BB8tubaxzNjY2+HpBJJ+/gQffItHbC7g1eDF7z8upYBcB
			ubEXVczrpGbPNzY2N3c01lvbW1qcNieXXHEmuN52DPsdCDwv87DCdaF5Mch+mU4N58+voxpad58E
			ZdO/9/u/98xsXNBXIfKCt6j1ymabRQV1E9Eb5V/0XteXIacRHV/iAmZQNIAQOcGXftF9DFWubqaD
			/GuO3378igf9AVzSdUjfJWTBEZ7ei/LlqLMMPUv6MmqV+Z0LPH1m6BkJVqONl3HMwhdhYW5FGpTt
			wIPzU8eVR+anpp54sXvlpSenurtXO196eTV1x2TG88FbvMnSNW5X0uc+err1ts5J363jT/k+EMzf
			cpMnGEjfcWtrMH1NKj31yPzx1UeeWNUeLo4+f/zhR6ae10YTj0w9sbr6yOOr3cpLL071P7Iy9eTK
			4/Hii8dnlPQ1ntItdyaDp6/5YD7ofXL40amhqUdO+0p33Bn8wPiRUulO3x2tHvplG/fc8oG0u/Oa
			0xN35O90p2+5c8KXvu1XksHWa067T09MuDJJ91NH6Q5PBehd3OkeldJ3TiZ9R9EsWNfZOpoh+E5l
			EnG9wUiqXV38Dxn9viJw3c9x50FZqIbEOX+9E8r37nsPH7jCTTfIjYlHd999+AB6cd752b071sd/
			+MPvM36Jvhx8/o9G7heh53/3734Lzhu/9d+ef+nJ1+n0lyeffFEXvpcpvRL8fewCLDR/eouN9xh8
			Z4P+RCCQ4EhmUJe3nO5CcQmMBZbY4hl/m7AHHUx/jHxBQDqVwOAEBbMYYmoupcS0hLqoqmPb4Yga
			9icimrtAmlhRSOomEik3roG+mFuYCKkouaqgIKuaUzW3x1tE61EkEimu5tOltYyIOsvGXxC4zax8
			/wjwBXm/+cbF3/j7v3v1m3R9B3zR+XsKtletraORYqIYjmhF91pn6xq9NT0EXU9kloXQp0+exFiG
			zs7j4e5o+CSU78nXP//4HY+T9j3eHab39Uo5nKu+UUH9Nl0Qn08+zH26dBL0xXCkm0UPr+SqnKFk
			0Fas/01c02946OZf2kufL6d6IWO9BfpHQ8+QF+XO3mSw4E673YEJrqyCyJ3lPl+f28vV0T5YlvkC
			bApNStjtpTOniJHrdbvzHo/FZrGV0r5UIJWZRdpX/HPTbwEJYbefvbNcrkZnfZ2V+OzzNgRQHczB
			W+HCCO3Y4/WBvps9S36HtRF5ZJR1+dxufg13Jp9Pp0t1dcdxyuCyroT8b32Ho6WxDyljTLNny2hc
			rHMb8TotIWd5TlHT+fPzv/d7z0zPBgV8G2RL8CYbdDSx4qYHNm1urm9unqfnWW7kYmyWug34hZ4F
			ZxsbWPkGhcIl4gagd6FxRYJFJFeQiVnGD6EBd12GDdZbw9esfGOCvib4huYX2L9KMFSoWVl9NTT0
			zDzqnU2R6AExo1bC1xycnu8eGnpEWU289IRy/KXnhxLFz68kXkwod0yWJu446pnIXHfUEwh6jj48
			cY17wnXL5NHJWydbb81MpDPJyadcxOE7le5HFj6vPPLE1Mrn+x955Lj2vPaItlp8vPjS6Opxrbtb
			ebH4/PwXtNEnnz8ejz+xOh53H50s3dE6eefENXfkvaXnh797bjh9652T463vn3xq8tqJdPKOOzon
			3J7xyTtveb/b4znaOvErt5z2Bp9qHS8lb/tgyXf6aGn84eDENS6C7y3u9OmjD/tO33I6flwZJBFO
			YhutvsTeUaCXlpS+a0p82qizMtA7bKo8G8anFvqZJGS99+CO9c54O9+3w7j5BuIPf+GDGH8Yu4H2
			9YOHjbu+a/DFLKOv/PBPJHxB3w9B/gr1+1WI39/9b1C/v/Xvfuvoy5/49Kc/+YXXq90Pv/zYjrW7
			8OqHf/3XL2OY4M/C3vcYfJcCSjCVICGVYFsrgd5lEsRuD+ArSp+XdPG7JMqfCwUOSSYwfpB0L3K+
			MRU0xYhBNYbxCmrCrUSIuuGEVkwkFHeBF9M3RteJ06jSqmxzWdbF7ZzWs4Kgs7qytraWTq+tTWU4
			02unD8CnROZ3B3zfstrZgoqrerbjIPhqWlhVVwprU2uRNVLBdIxLsDbyrTIK/TjxtvPE6c6wXCcf
			fvhOFDnf+cHHHw5HuvmYqqqV8PYbb4TL2xcr1epfPiwoe+PNd5ICvvHOm2VVsx5NlqL3ZgPAD5kg
			/JDcPHTjQ3vr8/WlvCR6YeqcShXE9KIk2JoqFDyJdNrNuhbjfukyOeuGw0ZwltO/7hQGIflEfXTQ
			G+SeXwKjx50iNAatFmd9qURyOJUqQSA3QFVzgbDP73M3oAvHa/d6bWCltTlI8BUy0s/JYa5gQpcs
			jBg3vT2by55Pfe3rV1h/IL7+QFz72qfqTzg7Ohq7+tgtq3FpnT2zlhB0XmrgWPRyo8gAC/o2zv/e
			7xvwHfbREVa4iFyjQAtil2i7vrm82UDaGfCFCl7mX2w/Ass8vrqBpT0+Xy75Z5eIvUv4xIFRi7iJ
			P2WK1vYlafKFoDSCP3tSvtC+WowprNN3QRe7es5X9BrpDNFj0OwxiVhwkW0S+/V6ZtleRDfO0fWp
			4tDCIN0wN79C1/vjM8nxicmJieRkIDCeHJ8MTExMBifGg8nJyQCd6FpgMjkxkadfmvF4SusfKM5x
			tRVeYG5FKy4g+ztHrzQ3jywwvQV8Qhie5qKt5OR4ciI/eU1yYnwiMDz9zPB0Kpn00esFxifpZYN0
			63hwwo0XpQNH6RINTuguDtAbQLp3cuKOSV8mnynlWzszmdJoaTSTL2nzQ/Oy+muFdG9rp4Wlb2er
			kL5pzJ3QzTWGZAZaj0OLHDBbgYkBFFeE789T+d5338fPspIV6/ob9NO9fAZ6a8euv/vs2Xvve/Dd
			4i6vu+nrM3/yJz+k9X25PvShL39IlF7Jtl/o31/7td96/tOf/sSnH/3syXL38Rdve+yxIyb27oo/
			/7+JvReE7v3pR0i8p+Cb9BdSgQLDF1rWJ/gKPeMjMUx/mZYZx6Lkakn+UaLb8Oc2BYtaRVFAYHCY
			dG8s6U+pMRVIhf1GRC12zxOFCbs+tod2Y2ChoimJYiyh5XKaul1BRTRvSf8WI8U1rbhW9KDqubN1
			o9VemiIMCw28p1ajzlb2umrdONHZmlgrsqUWLD7SGsYshSM5VGCdSuczqIU+duKhzmq4u/N4Nwnv
			cC4cLofL1ePEU6Lqww8f7/788Ug4XEU5thor02Mr5eob22+cNDgrqqeMGirePmQ4SMtd/fSQGb28
			2Qt8Z5NBQiakry+Asiu4O2OqUWDCl0q7E2nfRIBHHiWR5iXlS6BNipgzlK/XHRTV0XQ16Q0iDu1L
			p33udL7kdlrqShmSzgGfp4QZhaQQCUazcFvpcdudNk9js81md7BhRp3T6WokStEvx+wsjKKW/CJj
			4fW6SPj20nngT7/+B1e5vv614zaLpdlic3Q0yrYlAi+7Si+t48r60vo6WpDON3IxdANHnWeXhL1z
			w/kGjmwL+KLeGo+Rzpecv21cZisuaY8KihJsGxzcwiyaqvzEXsRyZmd7grgRoR5R4I+qQ66EXuJE
			C2qw9pjz1U86fNkueZC7e1GwJHO7Msws/arMIncBrUBFLohaGJCJ4Xlhq8EglvqZLbIGxegGs5Ej
			V0hdYvTI5c8zQwjMcnGwcLqan+9f4SolOZxethlJZyvdKloUV4F903H6vdvtYDVhutz9RvgyXcrn
			M3msUr5UKq0VF9hGBElfGXRm6VtHH7tpra4xfUWpc22Qk175jI34EPaMGLzEgB4cemeV76/fe/bs
			jqu7Tzuvnj1794Gf+rXennXfwc985jN/8sM/kfj9EE4fQvRZF79fJfbS+m/Pf1LCN3z85SNHCL5H
			fvDYbebKq9q664Kk7tkL+/B96/VLt2uknwiiKJryBpc44ysVri+F5O5SUCJXHOTEL/0REvAtFBKL
			aiKR8hdA3oRbC2trAUKrmhOKdrsypiluN93BnfIW3ERfd6KogdYFJZbSiM65SgXCt5JDOPfVSlGN
			rCWIv541bW10atReKpEGjkz9FPAd3Tjd2tl9vHOjtTWjaZFiDsOFtYjSg9GHBNEiCrBaPatrnd3A
			8OkTJ8rVMLibC+cqOTQbnXz4NDp/398ZOR7p7u4+rkbUcEWtYCIi3RO9wMdr/bq6Z2SNvw8Z+JUz
			HHT0mmSwhPLevJ1J1JLihfjFzz/hlm7NIK434c4TVdGMRP+sBW8q4EkC17MT7Obsdqe9yATDnhIz
			Fkgv50uuTCtp33zeXm/Jp9NpJRjw5tPBoL+nhwhMQPV5PV6Px27DXCJLndXJFlXH2CvD6mpu7oH9
			k9eFuT+9nKzo8bMHh/trV4tepm+dpd6CEYLO9vo27hkWDBYnMdl+HXXTDTDA6oWzYZLgi4m+0w3c
			GdyIqi6En3ngA4Ryw3Iz9x0vLzUtZ5GsRVEViVw2KaePDA1Lsz3cydzoX+rBrzddQUyfU8CcbYG9
			JjDshxgW0ndprzlfkfXVZOD5adFtJJw1hNgdFkXLHGce0GcqiFFG7HZF8OVa5KKoZtajzgvoR0Ja
			E6FW4esMTs7obJUVVhO76SdukIMNZ4ZqFdOgOCEQRpay5trU4Tuzu2CLyI1MbCCQlPVWted+y0W/
			TmlwN79GFC6V8kVtXmZ9wd6a8iVVTL+Q9EFdSYmxTyLDa7A3PiyLoIeAXvBXmG+KOjVdAv+clS/n
			bb/ygQ988L9+QCz98pL1fj7jHh98/699/F0eL3j27kOf+RLR16R+v0wI/vKXv4/c739gx+ff/V2C
			768RfD/96U9+7jer4eNH7jpyF7H3B4/tqHs2APzYBf0TyH378L2adXtZW06mggCwVuD8nVswdmkZ
			g12XTMHmmvqd9afYcxC9RSR4UeWsaKpSQAZYKZAUTqjEVAbwxYu5Iujs86ULbh/6jDTkf5EjVtVi
			jBRpjBi9rakE37Ec3b2C2qy1Ylpbi6xMda+RZk1EIkj/WveofDdaO0c7j7fSpUb/g4taWI2qseKa
			G6XX9NKqGgn/iG5ZW4mER1F2dYrE7huVV8ORapjeOH18qJ6+mX037nz49PHjx6tqpLtczVVzuVis
			XA5Xq/TNvfHGzZeuG282AbfmIC1jz+Z6KwO/e4DvxCyqqpKYARsnLqYQc6BPTimSugBHKuB1w2nM
			HY8nONxPcFYUUspei8ftSxXSaQ9pFZLGE96gO+AOej02q83tTuU9JWedM+NOpdP0y5DOeNwY5+v3
			BTGUwevp9fXWHSPkHjsmqpT54thNx+pszSi6IokcbOhxN2JUrg8obmjw/sNlIcvnP9C3pvUpiOk6
			S3Ozs65FuGUtCekKfJ7H2KRsM9DbgPlE3mcYvrNC+Xqb+IaGhmZn7zGno6GJe45J+y41iXHDvfbm
			xmY2kvTPLnFMnj6BcD7XBwcRGGqw3PU3iAAzGN0Aze8NoOpqlv0ol0VJVkPj0tLelG9INPua4s4D
			Mt48uLPcuebv/IwYqyD8rgaIvcVif3GhKLSpOetrGDpz59KwyYBq8oqT/ERPkHR4npZ2lWJsw/Bw
			/5BEl3jqQTlOYdecBlEtDZ/MIMN3jysZCLgJvXn+wkon2FWrWFzNjHLECvQdHZ1anUPr1AysQtje
			ano4PhyfvmRx2Bn4lfZfQ3LEk3At+VmV74G72amYpOpZOp89fPbwgbvPEnLvRub07nvvO0y3XquP
			dOHtKTHzpXZVrlPGpvW0gO+7SeBD137m2s/sxC/k75e//NXvQ/r+Bzr97ld/99fueP5Fgu/nPnsy
			HOl++chjjx256weP3WUKPhv4vfYxg7hnL+y3Gl3Nun0gOjdyLhBV4B/J5c0JvbLZh788S1IKc1sk
			yQbO/c4i5esPkpKFiE1BZBW0kBZQCL4BUrVEBHVsLIGE7kWCak6hQ+6CnzO+ayjQKoZhLqmy4Yaa
			296OaQna5nLsh4X1ajj8oxhMr4ibhUg4UrLbM/Y99fnS/+JRhJ07M3m0IRNsc7EiveCaWtSKRYw4
			jEEBE+MJw6Ojr1TD5VxljF4XF/TBoVIJnz790M03PczrdPcr3WqkXMkRstUwsRcF0W9UT958s17J
			vKOXyIzemx86dqnglQzmm+v3At94PMUfXxT6MdJP/gwRFv6cKCYPTCRTTFstraWLyJxra2kir8eT
			yKczmVbEk93pPKYg+UBwr4dUdNrlsrvz3rwrn3HavW6SGu60p0THZpdcLrfVavP6XD63K2CvZ/De
			JEya64X4ZRrbe3t6PZ7eXk+P1e7qdfV4XfYea6NyhZjzlULRX7uJ1rF657FjNkd7Y1+Xo7HJ4XA0
			LjfwqGACa1/7sWPtLcIDKw1zpaQMOz/jcbS1i3dXd1N9/U14ixgeLD4e8Kqnjwl1di61mvU1+vwo
			UKNf7oCXADsLTeybnUURVqPd4WhATBqamD5SzC71cMOzv6FHYLeBW9/3qHyR8o0xgbnuWdBXOGrM
			L+xAL7SmaDKSRVcIL8+toA9IwxwEkfWVtc4Cv4Oy8EgOPXhT9hqz7dF+hJ0ZQV8xKZDdo+Z050q9
			ntg0RXDXE6OFOBAITkzueY0HJwLpvA5eWqAv4LuyRr+mCEh1dlpG4S25ukL4nR4n+s6MC3dJ3W9D
			hKHFgF8ZdxbBZ+n8ZcxYHPpZlS+B9m5A9sB9vHv32XvvBjPPHgRgDtx3/fsOnz17Lez0JHVxfkhw
			9lSNuqdM6KWNgO+7qn7vufZLXwJ//+RPBH8FfXH+8pdhOvkfOfz83556/tFPfvLRz37xZDnS/cSL
			L78M+v4Aqd8ju+h75MJfGM99337O92rW7dFodGSLlGuKRBSCzICvVLgy1VVTvvIG/6wf9VaBVEoh
			JXtmkfTvGYUweqYQyy0GFSR4EVJWCKgXtyshVY0VEukCyrK4LpoUMonjGMEXEaVEolh5FXnY7dxY
			LqfD92KlIne2K2pODRczvSUrfCflGg2j1wfFGa1/JY781d+0dh4/jc/NONh5ii6QP8qMFtcIUBq9
			n4iagJ0HHD4QeuaV09yaGsmFw4TVcLWyXYHjZY6ubW9XKq0P0f+S7u7TD998+nTnaPcr4bAaI4ke
			iUSr1UolGg5X3zi9U8nuxK6e7jWJXz3+bDpO/xv3UO28JtYqW3Lm02ul0Sl4ErTSj2I0k0F9aGuG
			9umPWOso143W1SGCV0eSl26h212lunpnmjDs9Xo8+XRr0G734C+hPei1W0oeq8VKJE5zJzAbeS/5
			fKi1cjktTqfFUue0HJPGGHTd6nD0NojJAwQoHlfQANPJHu/mnAms3/2D733369/9+ve++6ef/vr3
			/uB7X/+zP/vep//0u9/90+9+r4birzttzXa7o7mxsZmrp9jWuTkrPSUd8LaiDXtNOrJp2DuQBmLh
			O+1hf6xmR0tfm83ZZutyNDc3NTc3O+hIC84Oa1tbW0tzY8NyD703h6MZMwMbHVa73eX3NjQ3++nl
			evz2UxstjualWWszfSZZ6rHDjBLl2y6X1W51NDrsdKujqaGZVPlelS/3+erNRqAvGApyCpZy9Jjj
			pBggiGTwoCy8wj3Y3EoMPgCAF2RB75DhDS0HHkgbDQOtCC1P6GlaqVfHDfjSfYR8JYRCTM7AOXJ6
			eqhfH5s0LDytZsQT80P4EckJGWSmV0tNeINJ/Un5xfnGidoLXF58T9BnPw/9kqXxS4gGNl9K4V7d
			/Eq+RL/KJHpHeZgv5vmuLAzPxJVUUreunIFjyLROYOn2PPTMPJ84WIAGLfHhYfDtUL6H774PG5K7
			N9x774MHANx7geL7DqNq6S/ed5AuPmMo21M79k7tujAmoZ7+OHP9198t/NLr3vPhD19L9JX4ranf
			D7HnJJtOPvLUk4888tknP/vZJ7/4xZOY5PbkSy8+9vKRu+66iwuvduD3yNl7D/8M7b3vTfgORqML
			5fl+UlFaanZZwHdJJHqDSybg+paNQ370GAX8yOEmCNlEWcQ+tRhdySX8GjwnCcoFd2oM9pK5WGwt
			pUH3oslIWczltBSk6CJdhedGQstVSBdrFTUmE8AXIZhrKhjFWJW19JpdmDz/zYadTmurxUi4LIw4
			2ACrNdPaefr4w61iAHArXV9bo//Eo+l0ggOwRTWmasx6flG60CJqJJojzaiimqpSQQJ6jHRtLoci
			7Bdyuc7TJ06MhsvdnZ3HO1FxpYYRKw+Hu6vE6DLeahWh6YdMbUOmWPKOdfOxHdVXouiKyUvvdS/K
			N4MKUPpgkanLjGby9MVXWgHDVltnvaWu1QLd0NlKB+hziKXOUodlydjzxOZ8pmQrWZwZOwqZUx6v
			l0BrtaVL6YyrZKtzWkFht9tdssvEJwIgPNLW12u3kgy2Oa02dobE61ksNqujGZNxxXxcDCJYbtjs
			acCsBTN8P/EH3/ven37ve9/9za9993vf/QP6+jMC7ye+97XvmtPCdcj51ne01R/r4hwvqpSx5dM6
			u1Rxz9H5pqbzC78nk3xYwcbz58+vYyZhs8MFfDfJYHVjQ2+zFcKZJy80wonLz1Ya/MzCh3oJrwVX
			DZ6b6MeIJv4Qge+bB/ryXfHBAiXXy8ubeDN7UL4xg77CaDI0BvaGJHWFmxUngIkfg7qpBmd/Bwak
			zeMqw5dFsmhR0vuARUtwfFgn77iA40Qwc+sEKp4Jl2IgAWqPx0WYGXjkami6c2Z8RoEPlUygzsw8
			sqIpoFocAeUZMbx3/Ba3eCAxc7yU9NWQSoda4VQ1KSw88CpH70Rlc/r9TNhbXcAwvwO8mYkJl67L
			J9xu9KKjGW52VrhwxJX5BU2jX78SfXQEekurOn2L8/HpVCopI97j4hODWQLTNzA4MLDwzMIzcriT
			KRhP+P3Zle+h684euv3gbQcOHDpy+PYj99533e0Hr8P+3UcO3XvkyP2E5c+cOPVXjN0bTzz0qzee
			uPlXbz7BmxtvREPjjTeeeujGE/C64+t03xMPiajzu8Xe6+mFD334w4996cOf+fBnROyZ8auXPiP6
			/OWjTz3+OoEX64tf/M2TJ3/z9S++/vrjj7z4Mqnelx+7Zyd+j5w9e8O/qs0y2g87X826/Vx5K7ql
			9G/1q+WVQCq4BPgGlyV2jf4iUXDFpc+z/iCJXvhBI96cSoTYXzKlaWMhVaMrfhz1F4i/KTVHUpKA
			FwgkCj44QJPyrcDmOVEgAfwj0JfdJiuvEgzVENp+c7L8yhSCrggVHI6sibIrANe+thYphrtH+Yh9
			g2f8ktAjSHZiJFJrKynfqeLa1Gje6y0mtDWUgxE4E246FYsKyr4wYjimFovaj8IR6Gg1Npbbzm2X
			w7GxMsne7e0cCejT6DHqHo3QPaJhngNBcA6Xy+Vc+A02rj55+vRxOj98Wgrbm2siV0rgm2ui13wY
			X0ReW+spm20P8C2trpVKa6UMy1ySwCU48TF/cbaV0BpZ4iJRutfaWia/ls/TI9J5W4ao6kmn826P
			B5YbqHT2Bbxpq9Xpyrvz6ZKtvs6a9sDhyksymP7Be5ZEITA8rKB8uyB9bU5ZbWVx2qzNyM3OLsGS
			ke1YllAnJTw2zPA9/LXvfe3Pvvfd7/3Z1777XYLvd3/zz777Z98j+H7v66YgdF2do87Z1kGStdGo
			dibeLa0vgXfL6+eJu6DwMqFWIebG2VjY90wwuImjxNrl5nR6vuSy00cE5yj9fEorpXwethjLTQ3Z
			Ru4ZhoHbLKMW5c4NPq+3Z3PTz5gFaTf9xGoMSURrE30v9CFCcLoxK0YX04+C3t2ela8mws4hPeyM
			IURQZ3J0oJiyIPwk9WJmfdQ9Jv2szPXrhc+gryw5koHh+PTOcqhrvROlOwKnk54j6YlW3+lfKWVu
			mUyf/uCveCZ/JTNx+s7JzsBTk5ngU7ckJ/J3PPWw2/NU4uH46PhLxYRyxyOPJFLjzyvXuVOlmYc/
			nw888lJnKn3Lw53J0uwsPSp4Rz6ZuaNzcuKaZD7Q+bw7OdHqvSMTSKbvuHVi8o7g6YkPHL3TlWxN
			XvvB8dPvLyXvuOWmic7xa0vBO33vT09cc036qaM+Hb4eWK3NTtSU8fi00q+lUYdFv9cSvVNC+a4s
			DE3Hk+Z4+szM+Ix5TQ8Nip8XTxUUsyDePuX74KFbnzp09Ogt1x489Mu33HbrrbcdeOqpX7720NFb
			bjl069FbfvkoQVgoX6Lvjfc89IHf+rUbv3z6l0+cOP2lm9//1Q/82okTH/rVDz30Kz848aHf+tJD
			X32/zAefPgA+vWvCl5TvfQe/8pUPP/Zhwu+1XzLhlzt/UXX1oecfefLJz37uc1/4N5/97L/57S/+
			xm/CUrf6qZMnH3/i5SNHjjz2sog8M36/8thB+oxy/fW1Bt+fvtX3vQTfQ5GRra3ySvRceWRkjhi5
			FFRqMxSWzGJXthyhojWQSsRSfjqhzSi2WEwpqURikVCWCEVVBRngVKCgJFIKIKoWtYRbW0sBeG7C
			LcE3UVDopKFaqwhBzGVahN4QGn+JaLkxkqGkLH98kc50tUIXtP9GOJOxisLnTKSorUbA3lN2bgfO
			tI52o7fodGerja05SPkWtdFOt98Nbw/Yeqj0JhL0qkU3XpeNpom/RUSgc+JMnxXGKmO5HGd9c+F8
			+kRrhI5G1ugth2O5cCKWi6INKZcbC0fKmNhUPf4w4jHHT99kUry7VK+57PlmU1DacspGHxFO2Das
			e4Av/SgRRIcXNin6QqIowtCkGTwkJdz00/S46ZR2K0imEUvpB+12pwKeVpfX5yPw8rwFNt3w+oIB
			b8lud5Y87rQrQ/B1ulwetBq57EiB8mev4DK3uC73Emi93l5rY3MdOo1s1sZGn8/qstNyWe2lkh0e
			UctLy1a7y+VqbNhcMEWU0corG3z/FM29f4oLPmjKBdedauxoaWgSxhoNBF36fVtHjxGrTcLueehe
			Ybgxb1K+0xDEDevsYRlQ5uPBVcwJWOmHXuxfKbmcDr3VaEm8wyW//AzZ6F/uwattYjKEf1nMD/Q1
			8CBBnJeWexsauUSa7avXN1lQNzbstc9XeExqetoX+F2UswQRJtWbjPT+IkSk54WCG1iA2zFsnUWs
			Wag682SjnV1AWNfkk6WnjrYmfdf5kqVAJ1HwmonS6eSvjE8+1Zn03Tl5+o4PkmJ96hbPRP6DDz+c
			iD/1fHdcmdEeSaeSjzxSTM2krnspPZMcffjhUnLmlow7dcudgTS6w5Pjd3ygNJG5s3MyeO2tHnfm
			aDA42Xr0/a3JYOlosHPS19k5ccfRO9PJtO/aD9KLdCaP3vLw5J2T13jG33/rnb7ALddMHg3ekhHv
			kZ5tYldEOplyo7I5nwdwhcOzYO/qSv+guY5MxJ7NEwyFObSELy/DJwwlVz+r8r3vwNE7jj5169Gn
			jt5yzTVPHb326H233kLr1sNHb7nuyB2Hrrnu8N1nr5Xh5u9/6IO/+v73/9ZXW79PVz5z4qu/euKr
			J0586cRDJ77/pRu//6WvnvjqzTILfPoA7K3evZzv3ffeffArj4G+j334Ok79Svxe88NbhPh9nkTv
			Fz4n1hdI/P42AxgTZV4n+t5z1z0MX9huHLntngNv37fyXoLv7Vvl6NbWuWh06/dDKwNJEjwpeBQu
			cdmJeZn6fJf8qTNjsWBBIY2rLHLBLSp9crEcIaxYRF1VqqBhzgJhjLjlgfj1FdxKQsF4BcXvLxR8
			9AhFWSNF7EsViQ9E8bGYSuiDnhyr0HPp0rdSyVUMFQwFvEpsXYuEVyPdJeuGHD5ob82shlFg1Xm6
			lSujW0enphJrxbQXeg/RZsSeY0US2oqotsYhj4baq4ga4xg0vf0xIi8pYOR8KzFttbN1SlXDMa24
			FkFoOlcMl2PhXCWcO1mJhjExsfrww8fD1XD1leMg6o07iXuMTg/xF0qubuZdwd1jD9Wf4PA4PijY
			7XuBbzKJ8jb0GBW4zi3hSScS6OHy8bjeQoEH9mLIQsFbKATQ14vJvkGfy0eStuCWrUboNCLx4ffa
			02lrxkvwLfXWkZotedAQ3Fualf/6QZ78I0b/wEfD3ttA8LXYmnsJyjwdiO2i0CgrNGKPDw7P65u+
			P71ckfOV6q6+/gdfs7Y09DU2LDXIMDMrX8CXrwC9TeeZv/BsJtGLIpvfE22+m41Ab+PmeoNPGUbH
			Mql/aKeVYnol7YWQPr9MhF3n5l2Ic+EY09C0LPxSubR/SRY3zHqXl2Q7HYw42Gty2U+fJhCcRv8w
			fXdXr3yl0hVdvqZ6Z+7zZb8mo8VoQFZTLehNRih07gd8agONQF9jtu60Xg01s6vBRwaYk5OypvkW
			jjpPTojY8cTE5GRmYlKP307PxPF8tINe2nhckC05fhwz/JIcpuY87riIIE9MZLAvUroTPB8Bjb8T
			HFoWspb3+Us/yI+fkEVe4j67ksDjSSVBHxcT6XQxX1wRFs/MXv7u56dNQyGM3K8gMKLOPH9Y4ldO
			INaV79DPrHzPvu/grXdcd+sHjl57zS9/6Oh1T9165OAdv3L06DVP3XLrNUTlXz56G4ljWe380Fdv
			/OVf/cGXTnzow18lGH//xEOf+cGNJ0792ld+ePOXb/zq93/tQyd+7WZxx1aC7/Xvrr/z3Qdu+8FX
			aH34w5+5juSvVL8//JNroH+//P3vP/JZkr2P6utzn2P6kvj9VPU40feue468LMXvkSMH2eFrH757
			XreP9JfLI3PR8sDWVnxkxe0PBPxzinSUDNYIHBT8DYpgdFCJxeL42+8lwapoRRROKWO5SiySUxGM
			1oqpgpvHLSCBmiAmpLwpCF1CshvkTflhuZHQhOtVBBYdWi4WC5Py3K5UVLUSUyVytw34/viivuWG
			XLU0xeMW5PCjzBqmIWUyxGFcy4yOrqUTa2m/z03KD28Rated8Po8xHnS4olE0e0W5VeaimqsXBiu
			IKRpY2NqrLK9/UKuPxLORVAlHSnSd5Gjt1QlPperucoL2xHA9w1EnFH7XH3l9I6SKsHc3QpYgpfW
			qVNdMJ5m9G7sSfkyS+lHTF/C4op+tKkUDqKBo+DBqKMkinmDfuTUfF45dRBjCANeL6ldHrgAt8kg
			nXxukrOkiTHJF522mTxUjrs0a/yjc6h2CTFoJEyt1sb6emszgrw8hEO04IBPBLdl/zqyppubfkJk
			/1WUOJvu0d3A3s5sJrnM8xREtBn7iCs3icmC6+eJwh7A9xk5T3a6sbHpPOG3kW5pdnuczexy1dDb
			4+pxlTI24ZlF1NzcFA3qAqnBpUCD/HUW4fLZZYHcJb+XA9Esk5flQN91xJv5vWzSm9rDVCPdUFK3
			2hAVz6x8B/WxeCKaPDAPqwuZr9SHKrDwXV3FsLxBjjQLe6e4mGuvFzjvLEU2Cqt2HBXo06uuZBJ3
			kkuXhvWJgfRscLMQIV25HZdk17O1Io9sQNMUOJ58qx7fS2+eQM8bFkxe8mlF8aSL6WJ/cWW1Rl8Y
			ay7EZ/SpDOOTZs0rRvwOsq2zwd4Flr5DRgb9Z1W+h+8+ct3hI4cO3Hbw0G233X3ktvvuvu3IgdsO
			H7rt4IEjR+6+7a67WfnWeooe0juLHqr1F+lVzw/pBx76+N5GMbzti5TqD37w2A9I/UL/fumxa790
			7ZeM4PP/8cPv3/LSFwi9n+Qe30+Cvv+GE78kfMvdxx95+cihI/e8fA/R98iRey7c+3Zq+PcUfKMr
			W9G57pFoNLrgRcMRydqREQavSe3W+Mt2gv6gT83FiZqFlDry3CIJX4XULunVXEyLFHwFUrWpYspX
			SMTGcqQ2AVqCIEK+WgoxYJ/fB99oSDgQXClCEMe2c9WKmgslwjkNGrqSE6iFHq0I6JoFcCW8VmoF
			eFtF1DlfVMN2e2m0lGm1tFpXp1a1tDuiuf3+TR+9Js9zUBTSiwVNcycIu1qau3KKkZjI/ubeiKGU
			OZwLheH8QZ8BqifHwmGVPk5UkC1OxHKRGFdjhUOV7XIVnb7dD99082nMGgxXj5tge+wy3D1RIy+p
			XrxlWysJdPuG1Zqx7xG+vhQP7cUUQaIpLDbYDSNACPV4fPrYBDhvMHwxupctrXy4+6y0uCL4eqFl
			ff6eXrfP7en1WQm+toyb7ue2zy4Z+f4GdMc2CPg22JyODtQNi8Dsspj/Q+fNTQRw/UTfzQZiF4nR
			9T+/aoMrYu+nLERMGVdugJsVphqtI+i8fH7zPNE3yyXNmOvb2OThqLMY5d4QoJub1htg+4zMLA9y
			wDQj7hFuQC3WOj3FeiMpY9K1gKkM6jQI4nIhw7IUwTy2SCCXZ4uw7kUYelOUXsHjcvmtC67Mylcv
			uZLSV0jhRd1AUpmfTywsJETTrq7XBiU2Bpi9YlKtMDNm8hqdrjMzl7D3SuDbDejxmlPGcM1KY1qW
			MMnR9eOXPP94zVDjZ14TswEOS9HnvkwmQ9il/5QIRcHJGuHm1SgHnWEwoqRgZ56k31n6jDkhxLl4
			lyx8BXwH9JNuzPX2KN976d/xfffdd/+BA++7++4HD9599+HbD6Pg+e73Hb7vffcdft+9B+6999ev
			NZU4n9LbiU7JbiNZ6CwakE5xvdWp02ffRWNnuQ79gBbE72Mf/jBXXkH9fuka0PdPbnnpCYHeTzB9
			P/koKd/fOFktV8vlcrj78y+CvgDvPRcOnOW6scP78N37uj03srU1cm5gqzqnzCvnAucKS8GR6GzA
			7OYs/lgFtWSQrSUBX/+iWgykCqni2FZuO6ZBxaJWmTRjIuHzBhAHRXBU4xEKXn/B7UspWgGTjXz+
			RIGtgOEPXUDaEgsp4IpayWlwntTUUIx0qIg7Q3PmtoUIpiN/9GORCb5YufhGGL6TraLiuVTS1HCm
			NLU62mprdbqKa2tpt9eT9vj9igfh1kLBraGmWqN3UFC8XgTBE2lMQkQbEin02HYM9IVUR73XNhE3
			TGK3GCOoq6R/1RisnWO56BiRuZwLd8P06jSt49Xu6qvVN46bla1UwMfkTn0t6Yt4s+2UGFBshfDF
			2ht88ScoKNwleYavDl+flxCKsUW40R9kC+cACVmCJ3wiAwg7e/1Ca8zq8PUHAl6PJ+BzuXyN6CRi
			+Ho8szU/MwwkYAcoQmtvvQWyl32j/JwcXWL+riMvi9JhQV+ud27ov1r6fv3rc3aMBDzPmdt1lrfn
			m7CDmDPgC2eNzUYxVLBJdBpJ+D7jPg8irzedJwZv4g70SNwfswhBbeNZ1ht0mM7Oimy2+EDZwL/e
			syLSvLxc+8aXZckzh9Nl3fMmfeN7qHY2Ont17upKeAAhZsUoopKjFeA1qXs3Y5rRioBvEfAdEh1A
			wzXuXibifCXNKcqeDX7W4Ev0HcYrSjeN6ekdlUwzE7tah8d38rcG4qv0tjKhNxlw97poobG8NVOi
			/6oehKMSPEVihRO/KyLsvDKHqSs+zN8iVLt9wRkpesdFtdVAvzS+FuQVyrcWd/6Zc77X0wkZ2vu4
			SJjX3Qdw/Xo6fu/7bvile6Xy1Zt5T1wieU+c2Nnpe+Khd63QubY+fs9ddxF+H2P+fuWxz4jOIxF9
			vobY+yjYS4voC/Z+8Td/88eke8thlr6HDr185MjBA/gu7n5b39V7Cr6R/nPR6D+qW+VUUJ1bSEZX
			UoFzUf6zFCwsmcqdl1KhRIIH+8JtP5iIKYh35rae236ukvAHColiCL06alHxsVsl/CdTaKkl9voB
			YnfB74XmLdDHWPQJ+1MBwDfhVTQVkxdQe0woRHS3At2bE9Hm7VhFiGABX1p/xFdyQHB1qnTKznHn
			0bRWzK2WfhQJk/S1pYvFIsbouOlNeApu+oRd8MJWmkQdvQt3wkssFhMOi6i8IuKWx3JjMYLsWE6l
			v5gEWBK4uXK4iIg0YtKw6IjlYpEccXe78mq5+5U3KiffKFc5Ao4Bvxx4Pn16d4D5oYf+rSkNfDOn
			em0nbKR7Cb1Wu9Xu2lvOFwpW2EliGqCPfpSYUgSWIoTs9noxRAHpXyRjZ2f9Xn/Az86TGJ7nxc2o
			YEYYGp6K3Hzj6/EGA65en9dusdhcPX5/j0+GPFB05OdSpR4e8NxgPeYkVelf3lzHCdDd5AH0DdyH
			w6Ha9YbN5c2eTdKe655z//C1f6Dzn/7D195k/cM/lJp5TuB5HtwrYLsp4Etf8igHnbOYGZhtSYuo
			M7PX52gCc9dB4GxDk2A4gtT8wKbz4lmazuP9Mk65PlvOx5zlwis/LjmCzjHmhiW9uX1ZVGih4spP
			+nlJV/p7qHbeIX01wWBRAC1Sk8LhanBoWLJ3iC0eOf0rEr50mptbQM532HB04h6bS7wv3lz47kCo
			QUrEnYfZn1K3kTTVEPP5SrYdJpTLrt+9oHd8NkAcTae5/i+YzrTm3QhELSTQWzUnkr5M3yjYu5Lm
			uVuQyXzyBpJGwTO9/YU59r1m7i4MmKudh94Ob+f79IEJOw6CxXzLDdeT8v0S8fSvTlzV+iuWvtzn
			+y6PFDxw6C6mL2LPX/nwh7/y2Jce+xIt0PeaJ14U7H3gAaIvsfcLBF9EnUn6dpfL1ddfPHTw4AV2
			tPqZRhi91+G7EE3MR8NltXxuqzyyFT2XCMyNbAmp6xOaV/ytmi0knk5w7wkc51OKqgRJ+o58a7ty
			MVZI+UnlYphRJYdSppQbqrbQk+IBgj4UW6Ep2MfDYdmYUihfAJHEcEpJoSYKflcRoiHG/ObUEEtf
			ZHxzqHyG4N0WFdCsfStjQg2jAnrDbs3kUc78I5UeGs60tno0jZSv2+fhMiEfsOOH7yFtfL4C/Lbc
			3kTCzWZRSqKoFUM5VV3UYolYLFdezPEHgDH4PK9omMgQY0PKmJaIlHNqONbdPdXdHYYJZaVaDseq
			OYw5ov3j3dXjNdl7uaTvqQ0b4s2t9o0MkdcuaoVde1K+gaDPD7WL78QvBu4uCfjSAS9UsB8BZpK+
			xN5ZEWPgYRjYeP1iUiAXtM8yfHm+fHC2lxDsstlc3Cikf94S7EHVEYeY/b1tx6ybfoIv6Vs/A6lh
			c50Esai1kvcnKPcQfM9vNrZsrGfPn4dPRjssqDrgNQXrqWP14uSkY20cSj7fQOjcJIxKXCJYTADm
			PWCUyUt3ES4brvn5YFImfecdUMPE3PO0AYD7ms4vr+N+WVxrIgITd4HzzU35LTXMyrGZEr78oUEG
			nZf9wkrSr3/zUu/SD3ETyejNzeW9KN+aqdXTBndjotNXD44O1jp3hdXkAhC0oFc6i6jzwLxupjE9
			U2Pv1cKXG33N3Bwf36F854U1tJ74la9xBc8sQzYbByaN57vaNYuRaR5QNIgsbrq1NZMmBQz8YrwS
			x50RdWbdS/Atwo4DU0F4NdJlQE9LA779c3O1wLNR7iwNrn525Sviw/ftChOjYIoRfMMNsJeEgYax
			WsXm0pNcJ1pPnz1w6VO+w+vswXvuOnLXERl8foz4+2HCL5teXftSTfh+4tMvfu5zqHZG2JlWleh7
			8okL916Q2v1fvR3WGu9R+KbUeDCgnVstb20NfmprYCUxlY4PBCB6YXgl8r7Ab1BJaIpoOwJ8NVVL
			+ZWxygvble3nFnnEgqYSfEcQ2E2lSE8CfGgqUjACCTgu+Ikby2JMMCtf8BdZXwX10dx8lFAjCZKa
			EMHhCg/7JeDGVBGBJhxCC//9xT/68R9d5LJoXm+M2uyteU/arRXVNTUajYxmSu5Ewefu6QFwgR+v
			z02v6PV5eRxEodCAfYVEL72sEkOXUSjaHaZX1ULhWI4ITNtcGFFoTgfDgLqKEYhaLNZfzSHuEh4N
			R16lN1StjnaOdlarr75arm5XXzleX2snurS36MQJ1Ie1boC88Fdi+KI3Zw/wJR1L8PUH0SkU8PvQ
			j4vxfwK+AVyf9XF2l+ErZv3xh52gxKwIatDDMI2owcuzeAm+Pf4eb6+rtwf/Oj2zZvguNYiqq+WG
			3ub6+g2Gr58kL9K8yPUSiTlYC5ksxu9uNm6eb9g8n23rQxVV1uFw1h+Dd+QxYQ99THpEH3PW12fP
			Z0WImThJ6pZYC+SKrl7abYQEBkj7HC0MWcZvNp920wcL+sP7zJBHwhe3tQg/rOz6eRxsY/iKTHHj
			ZhOpcR2xZuULj2f+/V4WEKZfdy8C7agnYxjj05uIENBXQw99tNjcq/KN6dJ3wai/WgiJJqNnhmSR
			lTHCSPYazc+LhK9M+Ur46tZOEr97gq+5YFgnJyd9B4Wv5ZDk+4wspBYdxOYmn4mdktf0JFeZetaf
			yMci1uubFVXPPvq4nE+ni+l5ZV4qX8Yv8Te6EgV8Nal8G3kLDidnasq3H+ztl2Hnhbe7z1eEna/f
			SUpxgA9iYOBhJpg8PUYs+4FYuKpvzOsrXxFAf1fhe/eBQ/fcc5dUv49x6PnDXPd87WeeeIkzvp9g
			5fvpRz+HYmdSvlWgt7taLZ986ef2zt9T8C2X57T56Ei0Wo7OR6ILxUR/ZD6R7NdW3UpASSXXikXx
			t6qgaLEzGHAq/i5riyl/QFFDY5WxUKXgR+GtFiWRqC36/YkUScUC0ruphK8AuVsg0gZ8fpnr9ctV
			CBQSEZHpSbiRikUHKynnEHwf6SlijFwM0QWGicNwwGLDDbpQK1yP9WNWv+E1zBAgTKrR8NpoKY82
			XhK+Pj+Kf+jC7WVh6OcTXS7D1k6MHRAOHAVF1RKhcAhKVtVUdZteshxDNjiBWmiNMYyeJHpvkdgb
			5Wo0zKMHH+7sPNE5ehz1V+GV7u5Xju8QurUJC1xwdeoUp6eh1Jm7G6x7XXvL+QqSBvlzBduBBjEt
			YMlLn3B80gMUgWPAl+jLaV3cC/DFIAF/oFZM14NComVwBXf0+jy9vb0wdWqQfTesdzdlApSe1Gk7
			5uxl3Sv6gQBgqN51JhkXPjcQRom9mw1N2ea++pamlqaGRitkL8H3WH2djXdgtWyxtnQ5MAGwUeZ3
			Wbcuy4JmKNXG8yJm3NSY7SJKS/ASSbONvpIyK1cj54H55Og4kXU0t3d0QSFnW/o4QdzUdAoh7Wy2
			J9uDWio/N/Auy5RvQPYULbPSlcOJl9jYSszRFP5Wfi9+UnAbIU3vf2v4mvp8a0nfkFarfSb6wt95
			SEpdVruJBX1iIFA43y/znitzRe40qmV7p2f0zdXCd/ySkmgjVQtPSTm+iAPPw9PT5iZis/Idv6yN
			8/jk1dd91eALgyvDFnoi3TpK0jdf1JR5MdVXpHtXdeU7pxFuabH29WKwdEB3mmT41ugrpa9RTP42
			eDvfe59xqi0DvQRf0r43vO8sF/yePXvWbF2Fa3yDuDgr/ZxxlLOl77LyPfvxewR+dfXL+heFz0+8
			9LnPParD95ME33/zb377t+EwSfQ9Ttvqk4c5aH4fvv19+P606/aRgURxoUz0HfkUSp6j/f3nyrPF
			hXOpeCo2okYLpaKQuwHlTEwNLikJ0W6UYiMNzo6OvYCGXxQTL6paaHtMVBUjyesroPSZgeddElqX
			AewT7IVe1rjaOZGgp/NrYSWRKxZSGMuQK45Vci/A7AqjF8ZgcgXj5dy2SP9GK2N6IhiNwRdRN5VQ
			wyrzuRpJFLWC2y1fx49QM2b04MU3UfEr3gWhN12Eni2q6YRWzm3HiKuIJSPdm9uu5kK4VUnEIkUS
			yZoaCodzaEtSc2FidBVTf092d3Z2voKpDGEkfru7u0/rhc0n9BJnuVN/CqLXtpGxy7XBZ4487xG+
			AYFTpiry77PLgC/H80VE2V9g+MKjWAyB53ujKsvHQWiib5CoAvhC2GGWPEIEvY4NK2s9WXa0vEmM
			3VwSuVz/Zm+9xdKLYmYBX1K/DUJMGn0555cbGrJZCN/zfS2O9noH9GqLkLv17bCO5Mhze319W0uW
			Q8pNgrAAME6yuorOWNjjw9Zj7Rxaxt0JpOuzAZ8ZvucFfFu62js6HPXHurJsCd1Hovc8dunm8wB3
			D0v4TYwVlH1Fsyjk9kvnGL+UuRhrxGZW+MDCtN5s8PpoQ7dseunUs0flW5O+iDkvhGTYWaR7iRhp
			PqHmeX5QNvg+M0jsjYhqqyILX+mnMT2jS19cXC3sxmVceLxWb6V3HDF8deFrdu9g+JqhWmtW2vnk
			wtpyL0XQEz7CqC9Yu38g0zqad6eLCYVAWhTSl2Qv2BtFufNKMeEGeukLdtDewKxhMjk9xMXOsf7+
			ASPwPD9YazWqwfdnyPlK1F4KZBzkz1qH77v3bs4L/7pM5Yos8X333XD33Xff9+u0ve/uG+6+4QY6
			QKe7D9//9lYp/bT4/fjt92AJ/HLlFdqOvvTXNfiKlC+Hnb/4xS+e/HE13A0Cf/7gDT+njPV7Cr7R
			8sjCSP+5c1tD3YGFaFRdiZbn/cpANKUqQTWlxirhFAmrwFKAmBjTggktgGRwsEB/wwNKLPdC7ltj
			L6T8mElIylVNRLe2Y0RfVYPFpNC4AQnBlB4BZZMsP26HOOYhg5g56E3EYkoaKWB63sXFmFrZvliJ
			acS6sVwI435jubFcJcQY3uYY9Da3AUMf5wiTbhCYW3TVRNFNz+sTY9AFfH3I+NKrFHxuEsH0znxu
			d0KhTwgE6jn4XMYWy2oC/tK5XCQ8NoZ650W24uAZiIg/RyNqTlvQiqjrfgOlVtXq9huvdIfDr3Sv
			dY5209U36NQpcasz+KYTD9WfQHcRHCB10Ut6l84IOSP8vKdqZ3b6nGUeApABoHMpuEmfK7xcD4dv
			mD5iiCr13iVRPIWWolkkLnW0Quoh5yv6aljj9bjaLLYGWd6Lp15HbleW/y4vN9mPnept3CS9y+dl
			+GCs8/30Sqv1Fnw1rTc2ZJvaWlo62kj4NnbV3XRTe31dnc0mY86WY5Z6a7PFqedy5eJa52UON58X
			NVd0hFDe0tHR7mgDQ89nmcRNWUh6uZZwcB10PdXVZutorwenHU1Nfe381C0bdNMmP+p8U+MmEtg9
			PcuzHGJmi0n+TAgK+0RxAP3GoCytp0f+qnLSwkvI9fUgmoB9r3dPDleGsYbe4yvWosZ1zhoJXlFh
			xcFn9rxCrHRB170IOkvhayR9p3XxexW4G5/UbZ312mSjRkqXvkP0wmcM7VuzroTfs+kVJi6b2N1r
			yJmfiQAaCJqfBEM/PIoyNMhTfedk2FnUW0H5ctyZs75IFPPL6ZONBHxpjSzokee3Wfm+5ZLVWAaM
			7jNt5eiid7+2+XLv+96zB2kdEvTVK5+v+/BXrn3ic5/7nKi3euATXOtM7P3tz372iydPnjwX7i6X
			j5988ecl2t9b8I2NrJzb2orSr/25/phaTJ0bSfimFG11PhHQirkoqb1gD/2FL6S0kLpYWIwpS0EN
			ldAEXI0wNPatsTGULweIp1ouMZLbUhVSiwngLcCZRp8ssOJFElrojBTIS8LYh3YjhExTGAdcgDMH
			kqsa9/yQDEXxMQYdkAiOhdRcRROwVUOCvdvC+LmippRiTNVigG9VcbPkLoi/ntxVjJgsoaeB6Itw
			NP2FdRfEqeD1c92VRt9fLFaOjWmLhNfyGPG9qMYU9D4VtVgxgbekqhjhp+UiuVj4JKYOvtJdfSU8
			2nn6ePfJarmCTwjVbr3Imfl74qFTrSdY8W602qxI8TJ47QxdtFq49gZf+rEjajy7JLKSCJ4CvksE
			X/r24ICyzAPt/WJGbS9HgwV88WPfZEMMofv8PWyUseyX8HVlu3bCl+4snCk4oNxsOdW4vLmOOmd9
			5MGyIXo5+rzZst5I8nSd1G62JevoaiFk9iHT6+yz1LdL2VtXd8xZb3PUtSEYzCVR56Xu5R1RYcUE
			Jrna1t4OH2nMNdpo2+iSgWcB3wA2y9zISw9pzHbU93XU19uOOZpazmcdWaSLN1sa6BZ+7s3zjY0g
			akNPbwN+AflD4BJgygGDHkzX8YtPaIReL99BpCjoHt4e8Bipix7s7cXb+WmDvU/rPhsiBq2Jwio5
			YcFcnjs4ML8wJ0wWuct1QThKTtfKnQWAp5W3lr5yhJExhlfkaCeMWxG7HSZhPciTlWQzMVtvwTV6
			R2D7cogV6d7JPaherCS8Xswx7PFkqTXTmldECFmUO6+IFWX4zhXTvb3Iirg8ATwwOT45I8cJDhk+
			2P162Ln24zTD96dVvv8rr8MHDh68/fZDrH6PyMrn677ylWsfZeErip0lfOV4hWo1Eu4Od5986RM/
			p7f0XoLvoehcbmEkOnJupBzYGtnaOqckzvVH50aL89EESVC1rIW0YLC4lNKUxYT6dEAJacuBhFC+
			KZKqBN/KCySGwdlCIpIYGanEQM9UILgsYOvTqSsv3Py33s8pyoIngRooH6Qp7ChJBaPwSoHfFU85
			yqkxeC/T61wk1BF8Y4uAL5s/cz0Wj11AU65aIGmKkqjcds6HWq5EIeXjYise8S6D3T4/uo7A3oIY
			Z1ZgCNNLJxboRRVidyQWUnJjCHbTa5BaQbevqi6SmKe3ERFNwblYhV6m8kK4+3h352grsbdcDVfC
			lUp1u9zJ1JXqF7FmWyvIy6neDclbu1n+7qngSkxYhubjEiHU5aKAaNm36d/0sWnxcoN/s0e6cy/1
			CPgSc1DXvAmjKk5tcty1QRYZyYxtT0/fhr1R93Ui4bspIcwFv412WyOi0Otc8LtusBcCWYwdWs9m
			G4i3DY0bjpYW2mlxkPJsb7c469qtXG6F6bp1tnonHbFZrC0ojpLwbWoS4leewWKQl8Ftra+r72pr
			62txOJqQHm5qnOXvv9mALz++sbGdXqOuvr4F4emGRhRrZRsbBHlx7fxmb4/4LBYUHi/4fSCYihoz
			CFv6PSHJ6/X0egDZAH5rIHR7eNML+oqw5x69nc3St2b2vKCneA1OiDg0qq0Wiiu6wVOx34CvaYw8
			NF+cuPOWzJuYNOqTTcLVQLKISA8NGpOSDOUrEr67MH65oPNeK51pBTwCoaan8aLmSsBXJn1XJIFR
			cEUH8vm8i84ePG7Cl8QoBl7DGKowsECyd6A/1G9SvoPvnPL9RV33Ie9L+D14+0GBX6jf224j8fuo
			HnX+Cwnf3xazjTBcIRwJl7tPPn/h5/Sm3kvwvT2mVsrlaDm6NTASHSAGzy1Et7a2fJGFSDmV0FLd
			WjSUWCrEIWcXY1ogpS0GUkqQe4BTSiw2lshVQuBsAHFlbSE2MpLrVxKpAKckpR8lmCs3RhWpv+AO
			wInD7dZLsEgoF8zmHNqPUFdF8EezT2UbxtGkfRWMXri4HdXnD8J8cltF27EIENO9Em5UHxXS/KQs
			ejeNAKLPXYAG9Lm9aD0qEITpLaQKpG1JrtMLIK8cCcfCY8Re+mOp4rSIgmgtF4YID3fn6LevghPJ
			8dwr3Z2dGRK+EUw/qr5aDYe7O9HtC83L7GX/LasNPb2sdl08jEBEnLHvKmXye1K+ou9rltUsKojk
			FAx4Im76pUkT8dEv7Mka/ZvsqIifAObTbkr3CG5f3RQNrcviQcubDU0bjl4xQ4+hvC7vCrpm7V0t
			TUxcueFCK9xBTvzbXG8kubmRbWloaSPh6+Aa5Y5sR7vFxk1Fssa5jvBocUIBd/UBvk1Z1rhcSdXE
			yV7El1ta2jrqGdb1zpa2vj5H8/lGcReEj1n4Njdh2yDUMlw2GrNdHfS8FtLdjex3hd4j7vXlLPJm
			Y1Nvr5dr7Ym+/JFMZCQ8gKrX1dPj9gZ8gCtJLJTiBgJun48OEnx70BjTi8inp4cu9jTVSM/6Pl2z
			mBQVVws6eOX090Gj3DnRb7BX9BmZm3z1Rt/p+ND8fPytsJfUJavwaGYWs0ljTfrSOS6SvqaQMyqf
			Z3ZJ2ssq3z3HnBFkTnuCuwrAkvlSKR0fnl+QvUZzusGGEL5zGFBVyqc54jzhRsia4RsHfOdFh++C
			YXIl2DsoWo32le+VFwYVHzhw4OMH9dTvXXcxfB979HOPPqo3Gn2ajZ0hfjFXsFruJunbffyRffj+
			7Ov2ka2FaLRcDkX7o+WRkZGtc/0L56LlvCcUI+WrBdfUUC7uK0QUksHFRdomEoVAKuVPLWG20eLi
			YihXWVwKBkVsOaXM05+aeQUWGz6vHIsTFM71fukfpFfkpkhy+rzwxvLDDIPDojBhQswYsV4YOpLy
			RbYVzlPb29wEpKUSYSR6K0WYP9PKRQnCOQWdQJhZqMGaMuHvEe1MnMmT3UbAcMHvTbm9zGRR/hzW
			3AobX+UWEwhZE9FjqlJEsXUsp4Uw/lCJKUVN1YpEZGGBFY5UKyR96b6hHLG2s7WTyNtdjkRy4fBo
			9ysnu8Od8HVlLyvYSJLmFWVWULpWq0soXlcvs9iVKe0t7FzzHFtukAaIDF/uvBW+EJzZFT/oJr+o
			MOKt7F/169FiHqYnQIx+Ib+/kdTlppC6Ar6i0xW5342WriZR2izYCyI3LAlzK9Q9Zwm+TevrqG9u
			Y9WLqfcd7Y72urr2YzdxqxFWndVZh8gzAtB9WWFZRaztaG/JijB002ZTSxYRaoL0sfq6NrQPOfo6
			+rj8imVsdhnwXc4yfDk8vQ7lmyXgNnUdO9aebWljUDc5Gjdh88yilyHc2ExcFUEQb4MXjW/4pSMi
			B72+Xj+3ank9HrcHs528MPpCbS1bIPbgsIdIDANPzx6U79OSvsZ8hVqv0UAtNCpcrQb0dqP+VSPj
			e3nhy/gl+A7Mv0XgWdRImWLPYsx9rYhKV7RxUfF8ZghngtZwfHdC+TLpXt2vY4/4nU2nvbsKp2eS
			KcVNJCUVq8edZdR5DtKXtnlMmk7W2EufK6bpZ8KG1/jZGQA27CUH95Xv1ayzh88e+Dj4e/CeQ/cc
			ueuuI7f94AfXiS5f4W+Feqvf/sLnIHxfZ/iS+Og+/uQ+fH/2dXu4HB3YGomNhKLnRrYGoluDI/PK
			wjnFXQ0riRVPMqHEQprHk8aAwFgCkegUJifAaNKnhGLwpQqdIeUb5HDesjI/H1P7lUIAtv78t74Q
			9MtBwEhQBpf1do4AfDjQflRIB5iHEGtejkDTaySUItc15UjKwoMqul3ZJuFZxE1hUruqMJ3czoVz
			4m6xWC6KRiVuzE24/TKuvSwqnIXRBgqdvX43O24ILexLFXO5cDFRRMFVKBeFs1YsRrtI7oZVuF0m
			Cin0PmmLi3NIQ5cX1VxELcdir4rCr0h35+hotcJOV9s5OF5V6YPhv2VbV/QVmdArkr28A+rae8WF
			q3dP8J3VlS/bLRmOiFC+fglVv19OBFha7l2W2N2UyDXmBYhxCEahMpf6ApgOtnlanl3S5S1PBHKc
			cGRFbJnHHWyaNDAC0U1NG5uNmxx5djj6GH1oua2rt9YDpDfxF2/rnHVSBbewkM1mmxyOtj5HY7Oj
			/UT9KQJ2V5eDqEvsbW/ra8k6mrta+oi+jgbuACaKZpeCLHwJvkuzjYK+jex+1dTYRA/NtnU1NWcd
			jUDveUhgRvAm7WctFjuixyKB64VPSSAY9HiDQbffx97X9InM5Qt48i7MX4QM9iDQ7BYWxB7spa8G
			vjdcEnaW3pICwosCv/NDErYDcsueG1xsFdF1ry58hfKNG1Fn9mSmh8TfWvhKVw1jTRh7cv6RuA9p
			yPjQkEK0SsXjV1NIrT/JnlfA407uYu9MPB4PEnyRvxXSN7pD+KLbKK0wsWeUlHjNmWFhuCk+uwzs
			NLgS9N1Xvlexzh44y+r346AvB59/8BjDl8DLzs5Qvhgr+KTwuAqHI5Hu7sf34fuzr9uj5Vg0tKDN
			qZHcYDQaGQFQIyP9a4mEUl1J+TVlJayt5QupMxjeCwIX0ViERqJgQYstgnqam1UvMEuaNbWgKQV/
			MMh/64N+rRAUZUFyTIOIdAaji8xrQNINhboMPrN65sAwCd8iwVYdIxJqSjGhjm2TJIVbZao4dhHy
			NKbmLl4swwCLGEz3QjeuCr8qeGUIL41amRdHn8HjAjayDIsOoro5Siobddoqu20U2eF5MRbRFjFO
			gSS4r1CEBbSmnqEPIuqYRrDWYlGiPpGWXj7SORoOV+Httb39QlUN0+eB8MnOh1o53my3t8L9klWv
			LLLSc73MYjvb2+4p58s/QuLOMhdEMTvBYy86gKQpE0LNUrz2Lm8K7MrumlpGl10TdUNj8aDlxoZs
			NsvE5bTwOj+CiOpospzaXJboXRdMht4VZN6E6eOppkYQOesgVDagJze70dRyrN5srHFTPQO4XnLY
			Cjy3dXW1tVvq2vs66jEnmPTusfqOlvYu4m1bX1NbV7alpcPR19zc0tLSxOw9L6C7RC8gc75NojKa
			7bGaHO3HWtra+xwtTax5G3nEERY+DliO1TU39fSiZhYIDno5uNzj5j5wSFyStj5PIADfQ5AZpIUL
			IriLjRiQnE7vMef7tCF9GcGLAr+x0IJo8eU5vkxeMcxoYcUYp8eexWywMTw9vdtecpi9sd6UkuMz
			ukKdqE0yqnF3V1B5/E1xumtsoX7/y976pmvC565lfMcxqmhifCY+PZPEgCUJ3xXQl/EL1Qv6ziVE
			ednMGUWSm+BLwjc+NCzHMs7r03wFewelbde+8n2rRdr3LOh7kKPPh44cueu2RxF1hvKtwZeV72+c
			rFa7w5C+jx/8Ob2b9xR85xZCC0TQaG5oPhoj3ZrrH1BCudhKIpWKdAeCqXSiO5VaS4RjqTQPr4P2
			LRRg1+9HwVVqUVNAYjEq0J+YJ2inCiQklEAQtbe+hILMZNDQaKyDg6moovjFCJmAe0nMg8V9ULZF
			oAwkUhoyrvCe0oj5vkSlosYWCcmphCdSQccvGnO3K5VwbiyHcQ6YS6SwRUcixr4exvwGZq9Xv/QV
			vJLF7rS3UNQU2EoSYxfVEEYJaolFFXJ3cUWN0GHUXtNnEYU+CIQ5KRwLa5FIIqypari6/UalGquG
			X4lE1LBKAM6RIg+Xy5XwaDedMxkMC7SLZC8th3CzkhSmbTNz15XutffuDb6z0pLJgK8IOy9L5bsk
			lS+TM7ssoGzA16R8N03CF3OJYFzV2ySsKETYeUmUWm3Y7O1NXGIltC6eRaR5GcaNG6hubmyiqw1N
			LW1dfS19XdlsSx/J0Pb2jvaOjra+DgSRmb4ION+Evfpj7V0WS309S+O6NoYvNwF3OdhO4/z5hsaW
			NpRubTSTSKbdrGBvlqvN6E5LDGHYYm2iogqAzTra67ta2i0tWRF5xgwkmFzRtrcpe6yjubkXy9ML
			BcwJXghet9fD8eUeN8xYMFcCipdgnKZLYUEM+KYZvunX3hq+pqlGWGO1fiNTxVVMH0E7ALw+w1MV
			CCQm9q7MIejMwtcgb1yffjA9xMh+06zvhJHa5aSvhO/EuKF43zxmPDH5ZuvKopfl9RUfFwxI9hJ3
			k0E6Yc0k40kRdhZxZznZKLqis3eun7/T8TPxM/KpZ+Ksexm/oloN4B3QZa/k777yvZp1+LCB30NH
			7gF8P2mwF/VWX/jcFwzl291djpzr/vzBn9NbeU/BV6UP16qyMDiyEDrTPzISUvvPqZGFodWpBSUa
			CQZSiQSJ4KKiFRNFImyKcJRS4Ajpm+VJRospuC1xQjVF0IPVhlIgDYwRvugrUhTNKybCArWiPhfw
			VVKi/hjtHiIjDFwElYQ/4S94fSl3JBfLcY0VUrmpBICLscGBlL8QDiVSMS03tr3Nw39zFRXdQGou
			pRGoIX+Fk4evBl898yvKnsVxb8HnobfqUzhSvbioRiokeonG+BaIv6EYjK9SpIHRbxSDtbMWiuTW
			ImUlHFEWVLVaHctV6R2EI9VIJELqN5xTK9VctToV3q5EVvN5KF8ry16HS6peKXrtSPny6sVpj2Fn
			WSbl35SjAADkTWGOIeAqRDCu9TJipadEbUaeGANI59rY2vUeP2dw+fb1JeOG9UaH0+LcWOeaZhGJ
			NpQvtC+pzlMonGJ3jPOkfNuIv0TKlqYsSdAWkchFNNkiNG/9TTdJ6csiuK7upmP1Fkubk8lb3+Eg
			VHKbENdRtXTQc7W3tPU1t/R1tDUh9EwvwUH3bLYBFKZnR1a3cZMIu9nUZD92zGaDJQdY3EMngi58
			OHqJ522W5uYmwi/+DWx2FFWBuWx16BEalxZSvIKyfIRuY+Ia67V0em3P83zNvb70NSiUb0wmKPWC
			Z8heg72rJvZK7ylT2lfWW+HGN5O+Mzp6J3YEnnetyV2FU+M/dUBZJJYnxoWf5cRlCTxOuOUPA0Re
			zAmky4kkHYtj1eCr533noH0ZvvydxuNnjEg7yWWIX9EdZeDWvIb2le9VrrMHhPr9+MdvJ/oeEfAV
			65OPPvqFzwK+n5XKF1nfffi+HQsmPCvzMSW3NZAbGCyPREPFaHQkqsJQcX4uGPCnUsWYWlxbUzja
			TFcTQUIwXfPBHiP1whjm9aKANOAjniaQESapmlBQt4xLRSuIAlNRUiWthDQlsCwU6LLf65ftL3Sg
			qPjcKXZkTqjhXBQjhkJKIhdLhHIVYiAJUW+qOBZRc2OkjFV0BNEfsZwKM2kUWmmFVEJd0EzUXV4W
			gtekgn1i0gKi3Sk3eH1GC+VysdBiLqwpRfBXYU/J2LyaKMRpN4w5xXC7Wu2O5RLR8Bl6qWilMlYN
			v4pm5FjslUg5nKtU36BNNFzOqdVKNRxZO27ngb2iu8ghFG+vbO4V1MVFr2fP8JVoBHz1eIIOX6ll
			5awDA75CBi/r8F1ibmP8nw7ZJR4ZIOWwUezMxHWcsp6yN8p4sxFyFuylTVOj41S2qVGWXTkQdkZb
			UBNh9xS8poh6f8u1VM1OiF5ir1C+x47pRVj19ZZ6HrQAcUva1pFlyJ5vbHK0tbdBOjudHc1t9c6O
			LOqmmuqDLPyz3HJEChjYbRRWklkLYtftLdlmHsOQFaaUzbRttjvqrc3Z5maHy2a1Oqx2EsCgLjsW
			SnHLs3MwXzadd3lEhBlHXcTcBH2t5WlDX669KN+n9bBzDPui4krkfEP9XJf7TK0rhmAxMLeTvQK+
			O6POIuc7PCQmMryJ9B2XAdrxicmL39n7+pb+zK1XTd9W8WoT42b47ixsJtai2noC2DWk9UQwSH82
			4kM1+Eb1Nl/EoFn9CvieUWofEmpOmEPDerOWGCNokHhf+V71OsylVx8/+PKhe16Wyhfo/S5mGn1B
			wPeLJwm+xwm/YR2+Z68/e/3bayDyHoLvL91enuuPhlRtZFubHxmJjoz09xN6B85V4/3RaFRLwddq
			O+Iuxt3E0VSAnawAWB82pIJjY4sFOSYnFaQTUZYOz2uJlM+XAoPxRXd2o04acb4etjVIpYLc7eIp
			6MZC0u4ZXbd8zUdc7I/1D6jRhKbM5RB2Rs4Z0e6wqoafVjQke9n1KhYj6YvkM6YJJ2JqKuiTWV0W
			23CdMKSvIXxJXi/7Ux6IWm0xtqhxnVWuoERQ05WLKSmC7RnQnvPISow+VtBWDUdI+YYiiVi48kb4
			jVyuGs5p9H60sUo5okaquYhaiYQj6traGuncjJS6zXqFsyiwchm6F1Fn4u8e4AvV12CGrww7S1vI
			Wi2VuCnLKnhJnxW/pJdRbXKxM+bLG2FnOUVe+GWICmjwdnNjozG7uSwizMvrRuIXrMXAILQXnd8E
			e9Fvi3Bzc4sjixMr4myTJCB9AbE3HTt2kxF/1nPBdc6urhbSqxwrzrY3CxtJR0tXVwebbBCd6+rQ
			7tuIjiGnhYvOsi3IfTdwlXMjw7c32+ysJ7pbmvE8vU3ZXuOUzTqc9Q57s8Nht9usrmar1cXhZ9a2
			njTGynpcjGAOMfNunmmsy958qZQv5VstTkvdHpSvLLGK6drXFHamE7OXQSEuhub7dwSdF/SML1ts
			kMoz5XzlGN6hoem3hC8J359cEbG/w2d9t3bod77zTR1zd141fPP8ajLqrJdy7RTAAswy9m1ickBR
			SMWiYLn/csJ3bg59VTPxRKr2GPxMEHWu8VenMDg8JKXvvvK9unWftKA+e/jCy5iqIGQvh52/8LmX
			QF/0GlU/Ve2Gje7nXz6Mn+vht/1tvIfg+77bu4eiIwPnigryvkpoZGRrYD46oJzbWjlXjm7lSARH
			NG0UNsjaaiLgDwQgfwNQwAVMplfo6tIsN/T6g0rCFwxqAcSmMe3XD6NIzCtSeHYCksJwe/YKx6kg
			aqz8BQ+sDcSoTsQAlUTQlwiI0YMed8GnnIHhVVFDZ49aTBS9Xr/Xo2laKFEg+ua4SIp0MYtVDOQt
			wuMyFUTe2KurbJP0FfK3QTYgBQOAa4jzvYu0XaS3rS0q9NQJrYq3jaJrjZhbFCXUCkR2MUbXIuho
			qryaC8PSQ4sQdrcruUhY5dGCuUo4t5of5aSv3aCunaureu15hJxplfIuQwP/FPBdrxVcMVw3/Tp0
			jS2kbnaZJ+ExfJeWzRlf2Bw3GA5VS8s9sq3Ij7opZHtZ2y6vb260cDfRslC+tYUypxbM13XoON7c
			bGxsadlocThQ9Jw9zw5W51FB3bJB92t0tNUdk8oXyGXRW1/fbrN2tTkcTR31Hdnsqbau+noSu1C4
			pKD72tpAX74fLrPI7bbVceB51tGwNLvU0NwkJhdlQVvAt75+o7kXV7K9zGPswxvJYmlubnZZbQ67
			o7mX26zzaZeubfM45fNMXzFpVlDXLcjrymecdeBuHcqw96B8IXfHjG4jid/F0KDAr1S+8wK/tOZW
			ViOM34gottKFr4DvtHC5ktN8hqSyu7L0lWOIkOD9yVvq3EtQ/J1v6s/z8FXDtyQBW7OBHr9ccvgy
			thwTQSUF+A7oYedapbOodp7rHx6fnFYSpjA7Sr6nd3hRSy2s2zrvO1zteR2+XsDXYO+LBN+XHsVE
			3y+g5Kp68lPwsD/++ZcP0DrMP9q39Q28p+A7r4ZCI+WoFp0fDI3Eyv0jI2rsH0ei0fI5Ur5DWr+S
			XtOKkWgi1e1ZSZGsDRJlg5C9AX+KNC2XLHuX6BgdVYibpIkDXBhdCPiYtmBugacseN3wvtD9rmS7
			L+hIx724H2nOgj8AE+U1zePGaEL1YoWeKYF5hcWipri9ntNenxtR5lRChf9VLBfKhTGdAeFh1Fsp
			RdKw3lQt6rystx1J9C4bIWl6DPQspC2RV11cVGJrmHSEgYgqHVCVlIJGX8waxmAjTBoMqaEEjzgK
			hatjpL3HcjnMHi6G6bZYJUfSuBzORaole6m1VZZaSR/JXnElQ+h19aZdpZIMPvfuEb6zZuWL74/l
			q4Tv+rKuawVLe3U3SD1ArXfuLrNblQ5f2kj4+jc3RbhZL6la38ium5Er4su42GzMkrbtzW6Kp6Pn
			IxxvtGCoHwHXzo4Y7FXV0tfSt0FQ7nO0ibTvMWk1aSHs9jkcfR1dTX0tLfXtXX3ttLra2tsaG5uz
			LW19XV19fe2iKgsEtnCAudlqaQziO3HA1NrRJDK7vcjrthAa6y12omy2eQPFVdne5t5mnB3Wm2wu
			u9Vp4QR8M/1bOPIuKF6GL7pI03mJYsIuMKxneV0lZ12dpU6A9+rga1K+Y4CuEXg2KV+ud+byIG6N
			eQYyrX9XwndhYL42bkggOG7qNBqcZzeMK2Z9xw3SXQa+u+XupXf4qeFbs7J8s7yxrouTAtVBUr5x
			wLemfOdE2FkiuH9wZjyumT5qYCjEMJc862MgZnhQxLBJAO/nfPewDp+l39nDHz9w4eUXRdQZuveT
			nxTspYW4cxVxZ8Lv548cOnjw4IGDAsFvY+T5PQXfQaU/Gju3tTUfmz+jqPPa/Fb/SHQrulU+Vy6u
			za8lfKT7AvSHo5hOJfxBODj7A4BvIeULpPiKzwcoB7SUj3uAUwXoYwKxyBEX/CkMoE352M25oA9X
			8AeF1RLKrSBCSQOjyklJ+XyJIoYbRGNzGGRf2a5oCfaBTAtTojQL50TKl1hMqMzfYkLx0cuFcmOL
			CiQwiVU0HS8HjJyvX+pg3y7+Bl4jkYwCadK99ECSvj6NxXpCWdSKMW0xQjcQUSMqW47AwUOtVl6t
			hMsxLVbM5V5F529uUSXp263FSJ1XIqqaq5ZX8hlXvpQxAs2SwbysBFxrb63Yiji8p7Dzkq58TYv7
			fHVBazAYsG0S/UAGepeNRwKg/nW9/HlpuUnwmKcEsuTljC6hm+C7uUPvitn0SPdmO1qyjY21QHTj
			epYOQPVmW6B8uQm3BZXKEL99Xae66lj0Ivdb32Fpb3G00f2a2ro6Wujc3tHR10Gqt629o6+pEZVb
			fW1djr4up8UmlW+9lduGHE4LW3wh6bvkyDZnswzZpt7mLiDa1gy929fWDKXbzOh1NTvq6unfwel0
			ORxE32YugcvbwVsicF7AN58XYWdPgilMn48yNkudU3BXLuB3Lzlfwq/BXoO8i7rZJM82emZQzPad
			719ZiXCRL86A78C8Ybgsxa+hfIcRdgZb4kOX9vqOm5OtO+H7d7sQ+3e7DppYfBn4GjORxHNPSNvK
			XfBNTl71Gk8GA8Eke0YGA8k4GzWbpK+hfAHfhelpRTPjfEYXvmfA4Bk5KSIuQgWSv8P7yveq1tmz
			IC8afj9+8OUXXzSU74uf/O5Lj0L8fu6zPFihWoXyrR4/+eKRI0cOMYAlf98mAL+n4BtdWSDNpvZH
			5waV+bmwopQRej53rhydi2jnUmmlqBZTuYgaDvAYWUwjoi1xNUDcAmoDqcT8ApdWBdBm5MdNHGsm
			YZwKGHVOnK3labSi7EpU6S6z/RJdI7om3ImUH93Dam57K4dxRdu5WGyrAnvntXyx6Obn8gRhZen1
			F+h+2xWed5/gSiz0JcWwrxa5ySjg19Zk0Fn4+Ao7QbP29aVQEAZgn0FeN6Fo8Kjk+mekkeNaLFIo
			JhYjJHiLsTVVqYZz6pgajqlPl8NqSI1VSPfGIokI0VlLxHK56qvFaHc5Vw2H87KhVy7TLskthJ97
			pexNIwS9t7DzrICvUdIsOrg2l41S5PUah3uIsGzRLBBsCjuvC5dmMZBIwBeTAgm+2Aj4AsXZrI5e
			zuzyTCNSuKhuBnybNmVMmhVxU4ujsSHb0gLWCjuq8+f7sm1tpJBbRAj5GJ/a69rr2traePhCcxMB
			tq+ro4tEb1tXV5cNejeLhmFic1dLS0eHkwSrgK+lGVXMjc1W2xL9GNjqyp7NurIE4Oasq3mjXcAX
			vN3ogvJl8hJs7ZZ6p91lq2NzT4cd6HXk7a6SvVSy58XqBXu5tdftBo7ttjrGrkg3M3Ulf/dS7RwD
			fWXc2SR9FyV9MdUX6MU4I0wRXInoQ2xrwteY9BcfrsWdpwnWwpKZFN9lFKVpzxR2/tarQ995+ltP
			fye0PfadwW/9IR0ZIvD+Ufzid0J/9J3B7Re+88Lv/N3T22b4pid0+I6//747Jw+4J++/I+85euf4
			nUcmb5u8f+Lo5IHSxG0f8JrhG7zaQulxrruis6y4ngF8+3X4rgr60lmkfReGFC21C77GMhy5AN9p
			oxSLfnT7yvet1/Ug79kDBw5+/ODHbz8k4fsJxu8nP/noo48+8TnEnT/7OhdcfQri9+Enrrvuttsk
			fz/O/H176Puegi+Khke0+VA0thCKzkdJBQ+MbI2MlLei5egqKd9ytJhPVItKMZViEwwvG2rwgoNz
			AIZUiRiSwAQxUqDIBqPeGQoyVXALqWzo3ZrwFVNl2PGZ/Z75UNCXcnsVZWGEPg/EInPAYmWrUi6X
			q+VIpLhSTNPfR8lRdyKhkihWMXS3kMLMezQm0ct6MKCQ8Bzwb4fkjFafnKuws/UI8C0UFBRlw5sS
			GEZhVcK9iGejv5eYkbSixNQQNyOlMMpXjYUrajhSKW+PjcU02GxFItqKGitj9lKR3kBZjW1Xwrmi
			1VUrstIrrOwEW3spk8FVIJjJ6+r17LHPVw87L+vxZHyK4eCyib6yZIrga2Z07VaAFQJ3SX9YD3Ds
			32SjKgFf5HAJsE243yZtG3kHE/okfjcdTsd5GYvmnt9G4m4TNi0OnmWPSbrnTznQLUQHN9oYvHUW
			S3uHraMd8G3qa2nmSbwdpG9J9XZ1tBFvCb4txOq+tpa2jraWdouzzea0IKBcV2dtamzqaWxstvTO
			NrDZxmxLs4PoS1q2ubeFM751VhLBzb02C1G3Gd3UoK+VDtutlnobyGtnANtJ+YK9cA2mS5HzzXOk
			uVRyZYi8ljpLfd1O1cvnvczzlVXOV1C+7DH5jKjN7ReKV8B3rmgIXxF2JoE7NCxKrtjZ2VC+w4Sa
			y8VzL6t8v3Vm8Dsj33nh7771ndB3hkM48E3UQQ9/5zvbA985s7j9ne3v/B0fN+BbMinfGyZLpSPj
			918/7jnwy5PXHw26Tp/+QMDz8MHxO6/bqXyvXvpOCKdp+U5nTMpXt5c0S9/+xM7KaVGFxp9IjBtm
			hs+IuDwAjJ/PvvJ963WWG3250/fQPbfd9oRQvp9g5fvoS0Tflx5FuTPmKjB6Sfm+dO21NfzSY9Gs
			9Ha8lfcUfNVIOKfNJ0KxIVje5XL9uYVzWyMD57bK56IR5dxCql9xp4hLc0qAlG/A744xSgMpUrxu
			OuAD+VKBgC8xL5uRUBWNm3kFgjXuYvBgUECW5S83nnLuNwBJTZslQUo3nsmbQvtwQo1Fo7louUxC
			mCAchtAtrqUTBXcqoYUxaIjgmyDBSh8ixnKLhFKEkTmhmyLZ7DOmsvrXUxFZBL1s5m/Bz1XZChw1
			ikXCr5ZCGDqhaYv01zF3JpZLLCpE4DMFLRHRNJK16sVXVbQXxxYxUTFXCYV5/iHqrtQYLKfV3MXq
			mq517aK+meFL6iqDQqtekfdFvW3zHpUvtxXJYbsGakUYWj8i7TBY3TYxZE1cBrLFHTZFibI+JqFJ
			xplZ3uq2kZtNPVk+ks1y8JnvQbuNm4TMzaY2ZxaCm66cb2zKNjQ62hxdfc1NfX2OFkcX7fLEhPa6
			+q72tuYWZ51o5bV0EVbb+jpom210IEXc3Nfl7CL+dnV0dBF8SQW30RO0Ab8E4452urHNBvoS+KwO
			O+SsCDw3LJPylXFlOlnrmO0uutqLemZQl0lrtdU5SfPa6uudVmau3NhR+syW/TjzIh7bM05Mf7DU
			4sy71p68nWOxsVjIpH13ZH1joUVukHlm8BnR4GuYKs5J4SvqrYT6RXYzLsPO8aFBfS5D/Ar1zubO
			XQHf33kuNPidb4W+9Z0X6GsA3A19E6gd/M4L37z4zcHQ2N8Nhv5uyAzfpHe8Bt/3TR5yX5f8iOto
			+si1pdPpWyfvH3/f5G3uW30+/R4CvvH4VbhT1sRvrfwqOTS4s+LKHHjun+vvj+80/pjeLXvp+YaH
			+NXFoGL6jz2/r3zfYqFX6KwQvsTeQ3fd9uITL3661mn0yS/oyveLr3O1VfVktfv48eevuUbQ99Ch
			2+FNCf6+HfR9T8F3Xh3I9cfiK4H5WCSyQrjpLy+ci46c24rORc9Fy1uKkgnmFW014QtA+QZTFwNI
			/aaIsEoKAWg09gKdKXa+gtkGYZrjvmzwTKRdXgpK5mJXOk3KrKuUxRDTftEZrGnFogpPC0JhQg2T
			1kRNc65MZ0JwDjo4t0KULK5pkKFFegxJbZVnD2nQscRRcD5V3or5AvI1wuHKSE5Bf2/KVAONDwTo
			nVJYtheUYoL9uVKongbkI1oxnNLQWqUtRhBH19yxSEILxRZfDS3mcrFwbgyx8UqV3lY1Eonhbcdy
			4Wo5HFnJ16QvJ31B3xKrq7RL6F2OOfN5j8pXdueum9hrgi/JVyRvmbPrDN9lnky0JC2qZEEVY3ZT
			wFbA17huCF/WvXygJdso2dzU5CDsbrIZRpczKyLTcJM81ecgwbqxQV+c4m3p6MJI3qaO+vq29va+
			Lhk5rrPY+tiJYwPdwI4+AjbBl7jrbOvraiP8OhF7dsDwmUjcQTe1dzi7pPatq7PZrc32XpfVZp1d
			Wu5qmF2CuuXwMh204OmdLkFiFyd8IXKtJGExz8JOz2DjkcpWnJi/VitJX9K9+TUCMC3Emi0WyyV5
			XrEsfN6D8n1aIHdXxdWgDDvjmqhZNhtbgb/9XOpsDLiP62VFwmBDFjsbMwDHr8A1Xf+OX3W1s3kB
			vhPJgBF23mEludttcgd8p9/Ccnqn+K3tzpjgayjfqEn67oL6jCy0GjcfkuQnGR0qruXXivvK9y3W
			2eu5xRfK99ChI0duu+5FhJ0/KaudP/0owfdRGG0Avgg6d5cJvg8/f8s1rH2P3HbPods58nyWO5V+
			1nfznoJveCBM0nJEjS2MbIUGF3LRc1shDAYc2ToXjW5Fy1rAvYRmHwSWwTGlnEpxS3wq6fah2ipQ
			8KW8KL1KoUUouEQ45owrZ4h9QbhMBjmqHAwuGYHnwDKwvVhU1R+pa2pELcZ4fBFm93IRE8wrcEYx
			ce7VMAb95d6oXqz+uPrj7Wr1jWq5ikGIkUgRFh5uhnYMTUcapi9pCRK08crWjwcvqr5+ZS3gHhk5
			E4sqDQEJ36VaBLqgKewJAurG4FKpgcZnEpwCjkXC5UXYOicKWsrt86e0SHRFRfuvpoYr22NVtRjK
			VYvVXOViTg3RGw+rkVyOvgV6Yxk4KZGg0n01uJh2NJNZK9G5lCmVIIjx9z6zN/gu6yYboodIpHKX
			ZAOuwCu35wrONokKKh3OmyKVu7ypB4uZvX48oElP8upA5sumns3NnsZs00ZWHGoCaZvgrAEKd9iy
			jY2NDX0tzQ5rm6UNVpAtfdY2K0whW6wd7U1NLQ5HO+lNDtdy3Li9rq7D0ZwlwQsrjmwTUZig3dXl
			7OjqaGnr6miny7YOwLelr+uUrc1hs1m6bE6b1SKkaIfVZnc4SMvaGpYaGxyOxhaHC9qXtG4zKV8i
			p7TutNs5qIDPPjYCPkDrJOnsJOyW6DlI4DJ/S/RvRP8aGTTxljKZVsHYehli3rXEEcuevJ1jouI5
			Zg49LxpGG4K+Bntl0Hml2L+g8cjBwVrGl52M4XIlCq4EfHFrfPryQtNcCfUTo5Tqd3Y1FF256Qjw
			dU+O77naeRxvcddbubqHJ4cJvv39psFGc7VqZ4LvgB5d5hxxcnwcnl87Xmp8xii8mjkTo/9rq6v7
			yvct1mFZa/Xxg4fuAXuvu/YJ3d/qZWIvlO9LDN/Xucv3U7DZ6P780aM6fY8cukfkfQ+/HWXP7yn4
			DiUGU0TarfmFhWh/LJpTR8pbZ6JbIyPR8nz/ucGtqOINRvrD2pqvAFtILeDxF/yotSogtYu+IoIu
			C8yUGxdLwQBivUERXZZtRVypxfdJeLw8QzehiDqpArwcmbsaMQu+UjFMNFDVsVyYGYxDucoYXV1U
			E0U1qqohepfRiiiuQrsxJgDT7iKG3sfwhEWl6Pcpzz373N+H/NH4c1vPhUa2fqyskJj1K/P0mFrQ
			ObCcUhbpDSCurmpaeRSjhN30dHF6U5GEqigxxcPPvlZIaWtKOBahjwfFqUSE2Jt7gz4bhEOLWmyM
			PiWQuMnFiova2PbFN94o56qRYmSNA5lrrrx0uKJvvbS6VlpZW1tDenFtNVJ0pyG49gTf5WWhfNfX
			jeoqhu/ypjFySESOBSz1sLPuksEQFf28BmcJvwzfzdoxXebSV699YzPbyDfBNKNpY6ORdO9mY3aj
			w9ZCKObOXpuzrq3FwYnaFkSdSbla2mGU0ULIdcpeXaEdnY7GbF+To6tvw5HFzCJEl0nsOom7zq72
			9i7CbztqtuwbfW3WZqujo61NwJcee8Ji24BD9oatq62hoaGxDcVTXNWM/iGio9NplbYmVh3CVqfF
			YkMOHnXLFohem40Er7UECUx7VmzoU5C11QJ66xJ3h/gVB+iJrspkY4fyHeOaq6drNVcsfY12o4F5
			fZiCiDuzvUaRva1ExjdeqyqaFmFnqXz1dPD09OVzrBNGy8/45E+rfD3Bib3Dd4bhe5nu3rdaMHfe
			OVTQlPIlBi+wy9W4pGwqObnbBRMvrR+YTqxMTY1Orewr3zddZw+flc7OOnqvueX5l2S58yc/+ckX
			H/2ciDo/+aSodT4Ok42ph++49egtjF8ReT544OMH8FQ/s/Z9T8F3QVmIxeZzI+cGz21tRef6Y7C5
			2opubY1slcvnRsojW1PplfCCmlOKhM6i4lvzw95KkZtgIBXgBiSOP+MyIBO+igghq1qi4CsIUykF
			1huYN4R+IE0r8NgCDYOLiix70dG0KCbYI9JM1GUdGRNSOJxTRVkUieQ5HriA7l7CLwqu2OIK434h
			ZbWEFpjfGnnuuef6Q1tbW8/9PfF3nj4obCe26Fio5vXsK/B7Svlh4oyxDLTjgbPzWn8KdVzugLuH
			XkBJY+ywomGubywXJZWsaosJjXB/PFYJkQiGBUgs/EIOjUbble2L2xcv8hetSoU2b9DVN7ZfLYfD
			GMilrk0V82tTYTjFaG7i817hK/2nZKCZdzYFc+WX2Gf4nt/UM7j6rZvGrbhd6uDdyndT3rzZs+na
			aGnEoSbO9DZlNzYQhd5sdHR1tdhbNpo7+iB4bZY2QLdtw2ElCGcdjo72OoIvhG99u6xVdjrBr46+
			piY62/r62rLZU5C4baAufCS72trbbR3Odmcb8A2J29zsaKebDeXbTruYVdHW1tzY0OBo8SOuzJht
			RnlyvYXoSgdI5h6zscOJ3W4j9tosxFinkz4igL42W4nQi3PGabNlCNh4fhFVFgXOFtnaa9mJ3z3n
			fIXixWQFOo/EpOPVDuW7MGiKORvlVuyvIbXttK56hb+z4bEhle/wdPKyXDPlfAV8f+cScftW8PW5
			Uca8Z/jSkiFv0/BCPszwnNi9MInh8spXVFzp0xX656fFs07MJOOKyexKWInwK+tR7AllbXVqKrNa
			3Fe+b75EzFlMVQB9r73mmucfofX8Ey8Sej/JBVcvvfTS5558kpTvyZOf6u5eKU4df/wpnb1H7jpy
			D9Ar2Psza9/3FHyjI6Fo/7mt6MhWbiDK0edoPwnfchktRySAq+dGtf7Iajg3NxeASk1pPoyXj6Ol
			qOAj8BJlzyR4lJ9a/FEEmU91TNAS84bor40mCooxmaAAp0n4YRBeNUFZujd0Lu1oCD5D6P4IlhZE
			uR9pAsExDuYiEk16N1fUIvRssaIGo8sEKXB4eSgFKGd6eIIO0eFAMvT3gC/WyO+PgLlbKR8RmQ80
			iLAzsKqIzwy0Ez6TCHhTBf5E4A6kFtm9iy1E2B4rhXEKKS2qqUpMC8fCubCYQVgJV8be2M7BHfoF
			ev0cYGuiby6kSgpf3N7Wgcw43sZozO7uNc+e4Lss87myJLlmObUpa47lpRE47pH32xRRZxlSxpNs
			1lTuph9NSTsXKqVJ+TY22W2uTaJvY7ap0UE0benaaLI3NWCAEUneFmuzxYqwsLW9j6DbYnM6bDYH
			5ilY6+oxNdDC/pDsqWHt6+tyIoHraHY4muxWq4UQTZC12ZzONtQ608ZCELa0t9msfaiYbrM5HFbi
			nq3N6YTsZGlrI3xau7oaGxzNDRMNVsAWy24V6tTKNVY2J3qLsNdipWM2pxUKmOFLStfGGxvcM4i+
			Fr2lCF+WXbS1XBJ9PraXeb5QviOi4chc8TxoeEzGQvM13WtqMzLmLYhy3jh/Ycu1vHGpfIcFjq8A
			X3l4YnK8YjTz/t1l230vt8bGJ30oXB7PBN9kBXAKBOJ0TgU7YXKBWLD4tHBm+MwQnfg8fOYMzlws
			JqYoGEtMNRpHwnZwfsAwdza5WxF+oxx3RjKZg83E3nTN7QqKlyPRE+O6Lk7kS1OZqdWV2L7yfet1
			FusAKq4OHTly5LEXn6D1EiP4kUe+8MiTjzzy5JNPPv75zx8/3t3d2X384c8//vhTz18D8B45Imqd
			D3C+9+3wunqPwXckF82R1iWxG1vo1/rpwEj0x0Tj8pZY0ciPo5o2FY9Mra4piZU1+GdoKcXrLq6t
			RJGOJS6OMW+BU3TC8iWEK7OUg8jqmBZTEouwXubYMt9nDHyuiOxuriJzvZznHcsxwZ9m7ZsjguWA
			9DG8WAzKF7OTfFzSDDdL2EnDeFlVijFF9DnlBkDcra1nn3vu2ee+/dxzfz8ySPCljxjbW8/+cU4R
			hc7Q5wWuuFJEfTUi2HR2k44OQ/muIZeNimi3X4BeCau5mKqEoiRxSe6y41UIww0x0wgV0q9Wq9Vt
			YFZ+jdGHAt4HeLfFumha26/m1OKe4GtYYGxu6tg1MrjrNdEqLnoEXgWrBYBlj9GmWeX61+mefpPy
			3WTV3ENCtzFrtTZxz5GdhGyTo6Wti5ja2NhIzCM+2luIc20WZ4vd0tfS0tVmESiGS7Oz3uJoytbp
			Bhn1lpbmrJNErM2JmHKzw2prb3N0tbTRTleHlUuuSPtaOtpJ/TqsbX19TrrS1tZlAXA54ouiKyZp
			XV1zw1Jz4+ysrwHPZwV6IatBUy6povvX22RxlbPORtdtgK0Nd7IZVyx1Uu+aAHuZ3XodzJLGe1a+
			sbGd1c6LOyqeYysy4qzr3jlTm5FRZ8UjjYbjQvlOCweJuBw2eFn4jteMpmC3rA8vqk30fbNJR3Lg
			b4ZnH+iGGjsiyLW7xjFqiHuhiLKLZ7Di9B8K3KWbaDuErzPYiw+l4nziRTswxPMq3B8RnzDDF/ZW
			c6awM+/2c9yZXi0eTyU8CaPpdzyugN3jSf1bnkmlS1NTEL41+O4r3zdZ198LcJ6FCD548OWXjxx5
			+cUX6QwGv/TS81iPPPLUk4/r66mnXrr2NuFxdeAwJC/Y+/b4PL+n4LsQi0bnSeCSzlXnY+oZFfAF
			c9HtuxXd3qqcWwj1B6ZSqYiinUloke7u48fpo8/rJ6vlMqk3VCALcFZ0cuJirCJgOvajmDoGbQvO
			jvGdxsSddNhWTOsFOlVyvCOO5/A8dPcxA81s6EzKuMDTiRIJAVGUR6lqKBVIuBHKTmw9R+8/NPLc
			N0BgSOBvk/INKPSNQQY/u+ATvh++AOhdYKONQgCATSludxxCXWUHy8WcVpAuHQR1TyER0tQFBRI7
			ppJwjdAdYouwtqpGq0/nYmNqhQiLSb8ceybQ5iLwDJHo1ZWvWQJj7QW+xM8evRhZRJv/07oeRDbV
			K8ttE2d99VC0Ud4sMro9JtL6zdjdlJq5pzGb7XHYHT2bjcTgjWzWjpGBpFp7eXYuR4ZbrC0dLRYS
			sM4u5G5tbRttlo4WuEqSZG1pysqQMzRrS7YZnbx0BrUdpHydCDm3AL501Imcr62LYNvubEP9lrPD
			QkTuIu46bUj5WhmXTlszAbC5uTkYaJid9aOU2cZ5XafAaZ0TspbgK0UugIy0LmhLzMXdLALmFh2t
			lhpb+cK4Rahfy07luzdvZ32Y79iOXqPFGnpjxiAjWeq8w1hSWEsK8k6z8p2pwVd0AE/PvCl8WflK
			YHJM1jRN6C1W0OfRd+NxjhzTV1II15SYX0ZrSFEGFX2PzvP6WV8+rqqQK8XXU0pcCWA4qRJPDQVo
			b8hHCliHr6SvqdpqRYSe++enx8fpReJxJZWc0L+/JP2HhySeSEon65kzxQzJ3gwpX3Vf+V79up70
			74ULB4i++nrxRSYwGCz4Syc6P/L8S9cdYfIePnsYWV5G99uC3/cQfH/p9lAuuoAsb3lrYaQ/Hs6p
			URLBA6EtEr6Ee4zNRgAAgABJREFUqly0Us3158KaGglXqpXqyZMnn6R1Es01ZUnMXfzMCezikr6Y
			sUxTnJmsgrgv8M4L8p45ceuVl/4iLLBzYzEkfNETzBbTGuFTSaghtYjSKVLX9NkhNEQfK0YGnkP6
			moPNAz5l+1mC8nPP/f5IKoAmJNK4yFgXlDMaPTCh+YjhPneAtgWFtD3KwEh1V1LAu9+35lPQhOQr
			8nhf+hRC2liLxHIYPFyplqtaGCViVRLEle3tygtC5Obg3wH6Qu8K/butQ1gQGZs9wVdKXaF8ZcGU
			Gb3rJn5ytfKmkemVcthUWSUA7BdBZoFgxjCEcWNPT5MjS2fSuU29jg1r1rHhQFIXI/p6s7BpBH2t
			1g67pcPusHW1kXZts1pJ/Townaitvm5DhJ0Ffu2YqevoayF9a7O3IPVq6ejq62rrIwlMjO1oB347
			WPkSfRmlHRYLAtV0boemJeFaR+wlCltZxEoxi5wteGprY0ZbEFRGgTVT2MpqGBC2QBrTE/CXkLzi
			U4G+nDp8nQZ6LTtrryx7zPmKHqMRPsdiO+POetY3pq6sRkShs2CvaPHVhW9czlOIT+vjfA34xqUq
			nrlMtbMUtzp8BX0Zvnpj7fjkW47s9Rh2GUkFYd50wgCq29iZdxvX6MJLG+MkL+ge3nkvU1icjJ0A
			faV8vnmmMGRyLexs0Ddqij73DxDTiwlir5gsyN9P3LNWXJzmoDMnlCfHpxMrmSnQd3VFU/aV757W
			2XsvXCD6XiDyflrHr0Aw41eu55+47tDBA5ipcD03Cr995s7vIfi+7/bofEyJRkjjjoS2QgvqyHx0
			RC2PiBWlj+jhhSqabAmP22+cfP3Jk48/+Tqoew4wPLelE1gKVrOEzZF6xcaQsTlxQ+4FCWXxIEP+
			7nj8tyrbxv4273/LzHfEtBNcKAW/aI4HK4mcqsWK6MmdVwi3W5WRkb+XWd/neGckBEUP+m4pwURM
			VSB6/csEYK2YihQLCu2kfAF6PvwhCSkaad8zuUhMU4qpgt+X8KqKtxApJFRS16qihbqjTy9G1JBG
			0h7vivPXZdbqmHXIwH1ajGTKVba3zXFnGX2WIejtvcBXt7qo5XYNFJvxq8edezjnu/MmYSwpy6ma
			xOP8m2xEKe7jx24DRtH3OhxZbthpI4Fr3dg45bC39DkcvQ476Es3cty5y0GSkuRrH7qHrH3WdoSb
			gV0oXzkWAdaQWUdTSzPhuwOB6ZYWa5/Nidpm4jXDl9jrJPIi52vpcNKGKE5XCcB10KntFkampR7F
			ycTPep53QDtWFsaMYA4rIwFtA3wtDGYA04lYM1SzAK+MJNeLL4O/FotlJ2d3lVvpmN6Tt3OM076x
			p3fCd1HfQPmuGHFnAd+FhfnaRIVhMcx3WKZSzfAdepOoswweTxqFT5N6NFk6So1PvCV7k8G03Au4
			tYSykBDi1oCuvhIeHkrm4X03HDoTCQ9OC273grjLvNwykMUOn/Q175sPJCV89bjz3I5aZ2bwSP/8
			QrpIqjnBnwrGU/GZGSWdX9POzIioM39rM3FtBeidWiNOT+8r370sFExdOHjwwoWXD154+cKnAeAX
			XzbwC/5yEPqlJ247eABC975777vvbX0D7yn4KvP98ZGFciy2EhpRBxdiC0OVc/0cdh7ZqlSq1UhY
			xZC8ynb15Ouke08Sbc9VcmWmZwUZXxMmKzv5C/KCs2BwTt+K9K4kcQ58xpkD0jLs/EKNuhX9ybdB
			XzptSyy/kOPYs8LVVjCpUgiKoTgdCCgaCsWIsVsStc/S5lkWv88++9zI1nMjz/35Vm5BjYUiKWHa
			xe5WkUCBHT8S/hRMKotKgSuxK8VcLqStFXz+hLZK+ji1QqT2clvxWC6UWIwpizG1HMtVy2qsuBbL
			vZFTYUtdeTUG+w1NVaF8K9sX9WzvNkefDdHLh7avGr6/dPsO0SuB+59MVwzOrv8nWa68abpzraC5
			pnxBXb9/necsmJ+B0NvbZN9w9PZmm62gq6XOumG3w0Ija7U6MKAAFG6x260uaxsRcWMDKVb7hv2E
			k5RvdsNSv9GczWIowjFITGdzswsezK4NAjV9kWRuE7Fgh93JOtfWZRP2FpZ2iN4OhIiB4bq6dla0
			ACCXTNm4dbeuw1LPt+GuwC90MBPWJuBbx7BGyZSFIWyp022a62W82ZTgRWEVPUfdlZd4A1djsmH2
			dg5J7o6Edkpfo+aKPrKt6OSVwnfAzF4ushKlVlhJU9g5LnTv+BXgOym9JY0BQ4LGxpW3oq/bGxTP
			FfCl3SnFx9zk5fEsYOzxgmeB5HA67UkvwJXTw1t9DCMfT4u7pbF1s202Xegklkj24mkJxCkMVjD5
			S+JktpcUrb7z9L8+rrhJ39JnDvphxItr+bx2ZkIG1cfHZ5KKtrqaGR2NqLHF5Pj4vvLd4zp8Qa5P
			80YPQD/24nWcASYCv/TSNS8eOUjsve++699m9r634Kupg0oi1q+sRPpj0ehIfw7lV1Hwa2uruv3j
			rXMhkqi58uvV6slyWQ2HQc1yWJequctSV8/dvsBf2Br8zUka1yqrcrUE8CXad7smfcEuCeNvYQ95
			YHhqYbCDD0VTWi6kYIawVqxsbf0+gXebRa4ufp979hvPbXH6dwSXL4S0Mxr3Hhf8KYjo1GrA605p
			mlpMLWhoVtJSConaEBqNoW5RpI0Ka624Sho4t6gmwrGYkiieWVRfjZVPnqxqmkZCOFeFzH21ElNi
			eNM5eqJFNSYzwBdrp4sm/F49fEn5SrW7I8WrQ/M/bV66mnYEoo3Qs1+EnHtMmV+/pLGfpK+Pdnqz
			vU2INbtOEckQvq23Wu0O0rpZ9o1yNDvsiDtzBBkg3bA3E1Fpn3Ca7XXY6tr7MNnPqLdyNfP8g2Z6
			EvuGjSuO20js2tq4WqqPNSvp23aglqPJDF+LiBDzIj67XegbchLvWdjqU/5QOsVpX36EKL2qZ/iK
			NK1FalwDvkaK15zrNSTwTlMNk7nV1Zls3GAKO6PWaswcdo4t6OSV0xXUuRWzseSOoLOp2EoGnWs5
			X1ludVn4jtdAK66a48yCvyx933TmnzcjqqwC3nQqxWFkoJNQmgZ6CbietDF50WNsF9I7l0eHMxDs
			5hNdFzqZ8DvPFPYyfVn5yrhz9BLtK0qu6D+hckZRxuMJJUlvf0bB0JVEXE9jj8+cSayVplYzq6tr
			IQ5G7yvfva3rLxy+QMr3oATwwQtG+peroF/665eeuOaJvyb4Xs+69959+P7U69DqoKomVuZjIbU7
			FB2IjkTnUPqMTGl5q8wCeKxS7i5XT1a3c7lYtFxTozmDi0KQvsDiVIreSk6mfxEkFuFloYKl7pUF
			0mNC8+oYrsibawngbYPFvNWBvE3PqoW4CqpQcPtTKbdPUdVAIFEoKPO5rcFvjKDB91nSuM99gwhM
			X9/e2vpzrr3aKv89mKwoaiyRKBhGH6kUksBqUfH5YLnBfs+LGn3YcBOJ19QzPndaW9HQ4UubmBrN
			5ZRFpbhYDNM3F45Vc7mFhLuoRarhi5WLFXWsmAoThMMo5YrEYrrs3TYVPhtlV3tVvjWarv+nGoPB
			0PO75K1usrGjgdd0hWRvD2vfwibOfiMFvI44NOb0wZSxuZ1IRpwEge32rMPenLUTZAFfBzpq7RtW
			a99Gm9VqFbaNVpvN1dy04axvbyHla5X1VvUWB0//czVDNYO2dmsLNxmhFtnZAc1q6bJA47YTkvuc
			zi5nBx3oAEHbEXUGX73NniB7ZDTbIcfFvAXxCnU2USnFLUkSsMdEVFmYSjN+6+trc4pqwlfOULDs
			cLWq3wHi2u7ephpxpZWKyPOuuLOR861J35VdwnfIUL6G8BX+VtNiYl6ch9i+mfKdNGqtdoy1H6+l
			ft9E+E7m+Y4BtycpNS8D9K1X/grHF4wvDwtlfj4PcxgiOKWY4Ds3t9PeSq6F/mKC4BufURI82jeu
			FfP5omJE3mfii2ur8AldW9EWedTxvvLd0yIlS9L3AJP3AJ1evmDUXx158bEnrnvi2muvw0SjQweu
			x31J+r69r/9egu/tSlSNRVOQut0R2o7MxyrR2KA6Ul7Y2i5v/ePWVrScK0dOvh6ulHPRkZxa2d6W
			anQb5N3+FmvUbXOWltD5LcbnC5zehfh9wai24kOcDq4tca0ixbK4PSceXqu4UmPsaUX/8wi3dEJP
			UKqg8MzgIOy2SLRqiURKSURJtQ8kQqiz+gbJ3ee+8ezWcwzci9toPRok5fv3z9E3qrK1JKZBpBRS
			v4ovUYRPdKpQ1KYKqYA7ERhNLGrFVDpxxh9I+RNat0L/8/EiiUSFNG0xFAsrSncVBiCVRUVxkzYO
			IQyPRHECEw8TqLzmDmU90atXQYsAtEz67kn5mmPM6zvkbo8RZ961ahVWYiv6jHqaiL09PUxgyV4v
			rvrphJ2sy5V1QcpanPV12NRbNxxWNqqG/RTPBnJxxRXR19ZmZQHsYPw6mtF0a0E9tFWno43Ls+xM
			bIy1d5JM5hpkawuRHbFjZzuKojpYuorsLXty6MrXabEHAx4XvRO71eOx2512ulVoWgS262wWs5at
			l9zdMQ3wknXJTZZdfb47S63E5V6qnWM13TtiUr61wDOOrOhdRmwsOSCFr2AvVzkzfuM14RsHfOO6
			8L0ceidqBVd6mLnWfDTBcE6+RdzZEwzQdiLgTgfod9tt4NMgLE5z6fzl1or84jlR+cvReEFuOSwN
			AKNwa34e8F3YEXaO7sj6zvWT8o2fmZlJcJfveLyYXylqxiQHNPgWV0ucQY8tMp73le9e1vX3EVEl
			eWkdhgQ++LJQv0eO3PbidTg9dt1tRw4Cvm+/8H1vwTekJkPzoZBCojcklO5WCM1GMe42+n2O346c
			K1e3YxU6lKsKguxaUgHL2PCu+ihTDdaYpLBB1LExdCCNMaJfMN/IGWMBYDg3QibT/Ug/iI6l2CLc
			MQoFtvpIpYLaIpp/QujaheFHaGBs5LmR3wd9/3ybtr/3+zL2zHHnLWG/EVLQK0HnWDERW0ylI4sI
			Mxd93kJiYYVI700FNFQr+/yFasqXLqypYW0lrKXoE7pSpJeLosLqjBoJjXFfMrxDorHwG8RT+gmM
			hSKxippK8XAkuv0FI8F7cXv74q4f3x7gu8nj/S4TZGYNa0hdM4/NYtdU6MzQfa2J8VsQBEZzEV00
			8F5vb9bV2wv4Oq31Fhvga4N1owPwRayZznZXs51B2nXK1mJ3sfDlKLTLSpA6hYoshw5fp0t4VjkQ
			siZ0dhF5Sft2Ads2p4wYd4C17WjwdYoqZ0lg3Orsc/tc9GZcNnqZXp+nGR28VosNtlb0/mz1ciaC
			SazuCCbvDDhfEb9mEtfp/UjS8WrP1c5jhN6QaGvfKX1N1c6QvobBRnFhANVWQ0abEds5c7HVdNwQ
			vvFhGZS+csbXLGv19G/trhOy4fdN2Bt0uTjf604nFcXjMSne/ByTdUXyVVyWJHBLO04rBofnGMVp
			AeOdFBb89XgIvoMSvv16xdXK7qRvf/88XEWSCa53HlcAXyWp15WBvWtTU1P041yLndkB333lezXr
			+hsIvtdfOPAJlr+Hgd8DkL8XXj4o8Hvkttt4kKCe8t1Xvj/9uv0jpvXRj3zkYx/ZfeBjH/voR8Uu
			bvwor4989GMflfegdT9dx+0f5avGI83rfjyGn8a4NO5aey1xRN5U2+xaH7v00KXro/IdfOxj9/PO
			x+6/X76T+7GnX7t0fexNDn70SreZvpmPXuaZPmb6BvmnZ9xNfK97hK/M0p43EEsYfu1vZQRZMvZv
			N6+8uKHI32NarHy9EMK9PZs+3hNTCQisLnhWIPSLxlnCrg01ViLYTPDtBXxFhTFGCUEXwzHZbqP7
			O7kXSQ8Lw+2R9bKD72Slhzjh9Eii2W5rc9pQ66wDWMpePYsrr1mDQbuHHmRxOelEgLfV1dmaXfSq
			zb02q4g3W2TYeRdVL7miNxLtDC2bDlguAbFxuWflyy5XRuDZmCq4CO0bE/SNSPZqQvgO6pXOw9MS
			uyLwPKNHnTnjO33FFl+90lncOjGpZ3lNNH6rVqNSIAjdm/bE3W5JXvCzBlaeAlWqXZausGrzGms7
			+byhh5v13LDHrQwK6buz01fXvdJiEr2+k5Nx7uydnEmg3CpVG6aAWqtMZgrWVoNiDMMelO99+4vF
			LP3yXqidWPzSht03iL9Yhw4dOAzRK+7/dq73LHz317uz9gRfgdtL4PoanWT5FFLBPfrRHa4ZOnsR
			W2bqNr0m4AvcFiR8+WkAX1e212VtRQUzEZF5RcoXFc8OHspH8HURfNnLEdVTLjFBEey1tdgs7e1O
			h8PVYjVSsvw4dAeLMbtowUWzL+tfKX07nB0i7MzdvbxQwszZXboI+jwe2nN7bXV2i8dqQR2zxSlr
			l+tF966hVndbY7y5yL287r18qHovylcaOptSvv2QvoscdOZeI4xcUNUVFeid60eXkT6oV2hbkfQd
			Fm1GotZ5WgjfN6t0lmLXSPGKNl+T2/P45JvnfIPJPN0cSKcDioBvjZuXB+1qKcNrKpPh6xkzf/nE
			j9PJLQBs1sFE30FFh2+/2VaytkZq8E1ylFnLF9MJfZ7veDyxsjqVGR2dmlrT2bsX5XsfvCLe8xti
			Kn57D4uo82HEnw8KAB/kgb9YBw8evp7vinLn69/O19+H7/56R9fe4auT9DXGKy7/tmdT4NfA7SVu
			zZK8qGXukcr3NX1TIAAj0dvbS48TO5g6bOdGIuspQlx7fb3F5oKqdchB9Fa7HFZsRzza2msXV0jK
			oiDZ0g7lu2Gtk2N8Gc48XZGTyVnCuJUNIK3s/kjYdTprype5i00Xba2MYKct4A54Sy5LnStvqbez
			rwYmJnGtFIngOptTdipZ3gypphvrd2Z2d2z1i91PtmflK8k7JlK+akztj5k7fWN6u5GodJ434CuG
			COJLGjsPG/CND9cKnccvsasavwStE5O7ws56lPbNMr55+EUF4gHFA/YaovcyKyNAOzUK6o2OZmqL
			mYxTqbRSkviVT2OSwHkdvgkSvvMLtU7flZ02G3q30fDM5HhKT/muFNOK1P/j00pxdZUtndXYvD5+
			cI/KF0B5r27kt09fhMELZvHLCeCD+ukgItIi43u9yPu+PT84PMs+fPfXO7p+OvjW4AoAv0Yi1sj8
			bm729uhp3Jp1JPRuQbCXw869jN3XWPnqwre31ysi0SLqLCLFVmhSgmir0+XasHHkGMoXOhYDc3uR
			5MVdxSQDqxUNux2Wdovd5bD2OUWilVSuqxkVXJjzl6XHoV/JivrpZjZ/JPraWPrCMaPDydZVNiF8
			2T8D1pBBtzefzFsyNvrjXU+H3Pa6eieXKOvhaZ2Woi3Yctng8WXQXLurebvzinjsVRVcmaqdEW5+
			WsacIYPV2FysGBPoHZRzjQR9VRQ6z/MkwVqTr07d+DRPNSLcTkD51tg7kbycV+TOHiOj3spUAM0H
			kldE77hnonVyMpmcSKYM3XsJew3E0ikD7IK+dBqdyqxmCLkZcYIWXt0ZiC4Z8jdtjkDryhcVV8Ud
			+V5jN0Y/JGjalEj5xot5CF8J37iGyjUCvhFz3qPyvVey513H4LuygfS8T0SSib74oV04fP0FbA/f
			K6TwgQsHwF7aHDZ+UlIAv12vvw/f/fWOrj3C97W/RaGUoK4UwH/7GrK+BGD9QBOjV2w4oyvCywXu
			KyoI+BJ9mb+9vVC+4gv7vXwJqrpYl6IgipBYX+90uhyYp8va1ypyvsTSNE/uE1MMRJ+vyNJaWuxO
			q1WMNeKBB4K8zc29vfSFkbuIOaNoi8f8MWU7pF1Vl9C9vO1i2wy63eNzk/hlreT01AkwMxcFeS07
			07gGLC11O3BsuawyNrcUme9jsewQy3usdlZ17Tui7xJjDaMNY8ACWzyLJqMd7BX4la2+w0bK16hz
			Hg9OBC9DUDk3QSft+C74GnxOXtHkOZlvDUzSc8cDbpPuNZRuKbNrTSHYy8KX6Uvyd9QJb2WnQLIz
			cxnBXAs/CwSn06x8ib2G8t3BXZa99NPrX4iPj6fist6qmFAM+J7pR+x7dWqlGEKXkUh170n53mvC
			iaHs3lt7goUA8AXap68LJEjp6wLwe/js4QMHdN2r/6RE8Pnet+f19+G7v97RtRf49sguIdK5rzFd
			gc9N4m7va710XPQO0ek1Pm9yLZVgL8tiKFzvZo+XlW+vp9fT4+l1MW29uuCl67xhpLpg5ghLDHTU
			Om12Fw+iZ9KCvXRXD6d68xygBpGt7I5xCn7MTlsXuG1B1Nlis+qTd10y74vqLXo6R3MzNDDhtktP
			/VoEd8XwIZue/LUHfAG3L5gMuvN5T8CTz7u9lnoeNciNSLVVQ61YTnME2VKLKut54B2jey1SHluc
			0tqjTpfSOtv31Odbq7USlyiRL+4YriD52y+bjEwZ3/iwHCQYl7XOSVlvxflfQmkyOBG4vPI1r4na
			cN0ddxmfKF1J+OaDeaSIkwGfZK8JvXLZVp019mZY8I6ORkYjEamBxWoVF1MskDOX4LcWfsYnKgHf
			gR0mV7uXyPrOKNxcNKNwxjc5I2SwtrYK4mdW1dCw8a3uRfnuL2PdcIGoegH0ZQSjpvkCqpEP8xCF
			t7vMqrb24bu/3tG1N/gKhjaJuijmKyneptcA3td6BXp7oIxlAVaPVL0sfL1ebw9XNftpC+FL/O2F
			2vV4etwE4h4heGvstYuC5A000WKgAWBs454iO2hqh+zFIzgKzV1HIn1LKD0FRyqr02IVJVFOq2wM
			dol2X+hnBxK3VmHM4RSsZSdIpm0X8xcJXwlXJ/5Aw5YhTX+1076AJ+31uG266LWI4UdSt4rLOjM5
			LXW1WqzLZoV3J3gtO6LUsolpbzlfVaZ8x+ikS99isSjZO6iTd5H2FkKc7d2pe4dFk5EUvzPTiDrP
			MHtZ7QUmJgKXZ+8lKV+9BHrHXQJXCDznk67x8WQyGUy5ZchZLitB1yx4UVeMvh7M75s6F8EiAJvp
			K5TvFNBL7LXhOcSXdZf6zTfn0/Oy3FmnL6d7ozXZOyIMnheG4mf4W5lJoOtXwHd8WiH2kuTOrF4W
			vlfT53v9/ulefYfIy7L3+gv3XoDr1fXYQvwevpd+nD+31z/0ThOwtvbh+15ce4QvqMrFzUxhCGAh
			WV8DRmX5Mi56EWU2sZeWl4PLhZ5Nn5eV72ugrwsKGBIYi1O3nPB1sbaFgwYiycirisIqBKJlubM1
			T0qW8Jt2iSi0DB5bSPNC+nYQqC1sTFkv4Mv8tUvysn62YDSRzYCvVchci1NfDF+n9Jt0EQcyGSex
			AEaFJH/dLntN8oqRCRK0eulV7apOZYuZwPKBl62P1lXxJYnhPShftZbtJewCwFC+qqaHnYXR1eLg
			0CCwMzh/CXtrE41El+84os4cfya6TAQnksFL0Tmxq5BqQo8+7w47T05mLsten7szSOyNk+7dwV5d
			89YATOSNrBJxo5FoFOQN82bK4K8MQo8yezOMXolgg8AiAYxzmuE7gKXDd1eTr+AvSd/5Yf4ephMY
			cRRP4jue4UpnaHCwtzboaV/5/pTrBvr6i0sO3nDDvXz6eb3qvvLdX+/o2hN8Oab8t0AvATgrypWz
			fGqiHWGdgR6iXhFpFqlco7JZv1YAfD1M7DTB18MhaKB3Y8NuZ93bq9c0b1jtp2y2EwQqu1MAliFq
			tWasGTs/B/cXMXytNo4SQ/l2OU8ReNmB2cLK1wa97BLlWoLCDgFfRLatsr7KaZOjifRYs00+JYw4
			bBBKmVYL/SnnkCcebtGjzkLX1sLEaPnVY9J1lh0c5tvqpEius1xOCJunGO2+dU/KV2XVyw6TI6Lc
			mZSvTPoOSo/nwaEzgwzgoUFjWtGwrHTWbSWn9XKrmWmdvZPBictHnXfFnccN9o6bGn2RBA5c9uG+
			Vk96cmJiV8yZqWtglyCXccLNgqhrrFw0l4vkBIOnpugcnpJZ4J0ZYsav9dJW4PT8UC3uvJu+fKBf
			N9oQyjY+T8KXlC/Ye6a4yq+VmVqJLZran/eY890/ywsxLhA8vF7UPyPcfL2xpL3V2/7y+/DdX+/o
			2gN8CaioquKqKHnRs5ll3Zt9jVnaIyqpevkmaR/5Gs69OnrddEKG1yPEMtHX0ytPrl5wkePOqIcC
			DGU1FAlfq91pMwqrEHcmDOPhpJ3FQTtjEkXLp5C/dbbbbHU4whg7RfTdsEqgt/BTWGGTYbHpiLXK
			6bxS6Fq4/lkecpL6ttRlIHwzpbRgrzPDcxdGnc6M1SanBholyk4eUqSXWNXtkMB1dW9GXb3GeXcM
			+urha8r56tFmveSKU7668hXCd3Fx8AzAe4a5u0P4Dstcb83XeZzpK9t7A+MkfMffjLumIyb2SgMs
			Oie9E5fcP+XKuMYnAsl4SmevlL268nXKHz9xjtE7khvBLBY6MYBxLBJlDTzFFJ4y4EvQFV+ybstq
			lF4xfQ346q2+l+refr3diN/2tJLAHGBC7Uw8sYI2J9K9a9JXcu/K9/7773/wgfvpJLb3m/Yv3f6v
			eiuf5CH8RC6/HuTtVTzpVW/lzj5899c7uvYG39eA3xpjharlkLEsnRLk7ZV4BnF7e0Rm143As9C+
			HhFlTu9UviVXhquouCfXziPrhSpFYhW1VFbRY4SErwsuG/SoZpfNXpJE5pYgp62DU7YdSMECqPVC
			+bJcZvZyoBm8tXGm1spq2ipejz0lLVx2xVzWX94JntKfaAKwTZTuZDKtrcAu6TE24ZDDe3eGivV8
			rRDBhgOWkQau5XrNtlYWXfladsWdMXxhb8p3THfYUAWIib1S+S6y8oXuxYlQa5a9KLYaju9mL8NX
			t9aYSI4Hkpdh7+7+Xem3MaHT15i1QCvp3p009nV2uiaTwWAqoLcYQfiKgikbo3eKt5zwjQjeSgQb
			4lceikSJvRGG75R4sEA4Ys82E3qNuLOAb83kalehcy3u3D/I2jZ+RgF86YeAFl96/tEpBJ3PmDPe
			e1C+H/vY/R/bXw/uuHY/zuK06/jP52e1D9/99Y6uPYWdXxOFznRCV5DLJdtyQUyWvrKFiHf0IHOv
			3kHE/CXl63Gz8k2LjiIPcr50xUXwLXHrLgeS4RtpE51Grc5WUNBis0mAQh9zpxHumdGRKiqTRZmy
			TRhO0cMkvmxw47BZhcK1cRQa2dx2Hi4oQ8+1kLMAMHK+NunujKdxlvLpEv0Zz5cyohzL6ZR9vXL6
			oHOHVaSpaUgmd/UCrF1C16K7N9dKr+SIo51FWHuudlb5bLKXnIPyLfZL5bvI8B0m+EqpC99I6Wwl
			Qs7DesaXc76SvQIrwcmJwKXC9RLtW5vfq7fkjJt6fd1p3457pzvdJcJ6MuB2p00xZxl1ps0UNC+J
			31bJ3hHO9jJ+9X0Rih4RAGb6EqidetzaVtKbg2vFVwCwFQVXQ4OXjTuz2zPUMEnffhQ8L3BWd/qM
			kiL4TqDSma2tWqemiL3T5p/DHpSv+f+kZMEV/sf+L3ur6XZ992N820cufaQJmT/lH76dz8U7+/Dd
			X+/o2ovyNcYhNEknDL1BCIlajjqj6kqXukL5orIKVz0SvQBvj8cN7UvEdYG9aeyme/MuAFVP4lqd
			gokCpKJ6irmLxiKUOJPyJfTKVK6sWSawdgn6WgR87U5BLSe3FlllcRXbQRs5W6tUuOyzoddcWfjJ
			mNF8lft/bK2o93HaMvws/BIyNC3ha8CynvO6uowVj9b7fM3zEvTw86WmHDV2mxuX9jLPV42NYeKH
			GK0wgiuqOkfKV9OtnQcXWffSmTg7PEz6d4iNrYSvpJHx5aorqXwNr4zgZDB4CXvHJy7LXpxndNdJ
			czV00Oc2PSCQHs+44a4RMFlrWKF5SzY94OycEiHnVrA3N4Ic75TEryn5C/qOMHx5iXC19OSgs5XZ
			mzFMKLnyKr0wqAxeLu6sq179NELSFy4a0/EhjjoLX0kEnaf0YUa6vt+L8n23/w7sr3347q93eO0F
			vq81MVmhfHsMOSvFLnfo0uHXOJkLCrPy9XBtlcf9Wo+HVw9/cc4XejndK04MYm40cvWmiaUl4dnM
			PlREObDYYrXLmmXwF6HqXhf3HXFttFUKX6w2IjAHegmeohqqzsLRai6drhlo4D7YFUljKZ1lytcp
			CqG5f0koXwtLZqYvo5kVr5DZNuO5RH3XzvizxVm7yvVZTgPLRqXWjkfU9LLMHddu3IO3szrG5c0s
			e8dEwlddMcWdQ6izIuFLCB5m+A6ba61MxVbGWIXx2iiFwPh44BKbDIM7lwhhsHdmp+czL49nPBAQ
			Q44mfJ0T6eTkeDKQkuwt5U11zojvT9lG6XJUxJw5uxuR8BUqeESNqlEhfUewEHgeFdLXaBA2yras
			QLHsOsJLpRPzKPsekM1GOwLPI6DuCEtfKN/+hSGSvjPD8VScfgbjCrGXlG8rB51nTOj9qZXv/np3
			1j5899c7uvaU80WGd1MCVwaXpdRl5vYI/PYI+CKXyzIXl3R6ze3pec3d8xqpX+R5BW6ZvS46gcQu
			oaJlZlcKWoIvsr02p0zagr2uvAuPt7usHKZOu4RE7mLpK1p2QTnAVhYb23ThCzYLzGJ+EQ8RFEng
			mqMG85arsKwlu4ArPwnQi8MWJ9MgnxctSqYGJSZlvSmRW+c0ap1rMeWdzUWmxqS6WmeS3p+0qwF4
			Dzlf0Fa0+I6ICDTJ3hV1pRjrl42+SPiCvYNDw9PDOxfjVkwT1CPPM8xPCc2J4GQycNmZRnpEedI0
			W3BchJ1nxndPPKInIupNBHzJjK8z2OkmkkH36jOMWJTWipxZ+o7C0UpUOkciorl3p/CV8BWbcxK+
			At41S0qryP5K7csITi/MD/FUwcvQt5+1L+thEXweHB4HfIeQ8UW1FT4RjEL4moLO+8r3F27tw3d/
			vaNrb/B9rXeH3hVukC5d+b4mde9rkKVsnsHKl1t5DdFrKN/e11w15Yu6Z5erZMUOj02AvM2znYZT
			UNRp58FFeQFgzvjmBb5dyOc69bPoDxLCF+AWLHOyoRUgLquiRTib78bhZaugrk2KYn4WvBBCzCh2
			lpN98dRWro6FNtObkcwdSpywra+7tEuoVuxsLqaqHdl1SOK3bod35V6Vrwg7c6fvHOgL5avFQnqT
			0RD6jBbPsMqV1BUjFUTG1wg7S+Vr4DaZHA8GLw/eyfGJiRpz9ZtmxvWg9W71m/TlPe5k3p1B59H4
			RBClVnkDvnqZsw7e0YyEL9gbZu6qNe6ORHeuuWgEtpOwe9Z1r9iWdNMrgFjoa8BXKN/LaV9QlxO+
			rHxHFgbp25kWGV+lyMI3I1p8x03oHd9Xvr9Yax++++sdXXtWvr26CzNndsWWgNprXmlRREVbt5tL
			m+l2z87F9lRppi9TNM02zXnsIurMgLVzMZRT1Dln7AK1HmxpP92cdnmIgSyBbVwcxWlaAWF2uLIj
			sesUQlK4aXC/r1TAulrFtF67cNiwSDTLimirSBLr3b8W2QpMJGf4lhCElsvkzmHRy5VNydxah9El
			DUY1LysZYjbuIj8dOHVdfFUFV2blKwLPoupKZRRDAMc0tBkNLnJxs1S+08JSQ7fWkIXOcV39Tu+a
			IMhNvpfrK+LZgXLNmPuL2JrycpFnndd8mYzHzbqX2SiZOeV0Its7ypr3HBSu0L3RyAr4e07XvTUZ
			vHqOpO+qlL5Ttp34tYqzSP1y6DkxPzik22zs6jbigquRfrGQ9MV0o5n4mfjM5Pj0wgoqnekjwYoI
			Ou8r31/YtQ/f/fWOrj3Bt2Zj1SOzvLods4g8u8SWCCnUbC9nesU+txNxuBl77AyZd0no5jnfS6o2
			4yK4YqACTwBEoBkBYfa14uSuSyhkURTdy87OOGKXUWMRVJYE1IuqTPBlnoq2JC5klnSzOHVmi4FG
			HLIWYWqrlMOioophi7tza2gJVzOiy1e+pkXPEBtcNQ1H2DUjoW6H3DW5UTr1exnWlT+Nt7Oq6ugd
			E3XPKsM31h8Tnb6D0L3DJH0HhfCtkVdWOxuJ37iErwHLieRkMnClibwseMel0tXj0DN6i7DoU7rC
			I5PBuFcO7+WEr9UUcHaiZpmEL9grQstC90YEb/VjcieiV0FH2Pxiagd49WFIOng5+Az4QvnuCjxH
			52r1ViP9YkNfC/PTpHyT45httMqjHaZWZbXVuKmdal/5/kKtffjur3d07Q2+QvgSgKUTMwePPT1S
			Arte44IpUUcllK9g72siuiyvYuMSmVsOHOcFhHnliY30R5fRyyaTVoavcG92NeeRGCbRmxcPyKfp
			AaCy7pGBhG+XUw5I4LCzKEkW1VfcVCTHMnAplQQt2GvVFaxt59KrqUQEmCFNz8XKLM/lV7qItlik
			PDbnd42yZb3ZqKZhL20I3tV9JMLltXj1npXvmJ70jdUGG2kxOVVwkcPOw9xpNC09nE30rVFXXJrZ
			S8J3PJgcvwJ65Qyjcb0neFxXvtNXVL760wYCqdoUI6tuKWmrAZggtxo1ZG4kuoLIMmd/cWxV7EeF
			IGb6zkWneMxgxoRfvqgxWLT8Wln56g6TA5dI337ZbCTyvv0LC/ipwWAjUcTowqnMVDF0xvjmdGuR
			feX7C7X24bu/3tG1F/iKiiohfcFPlzBiFrpWTkRIsywVFVRS77qkZO2V1VXQqnkRW3btijNjn4ln
			FR298JEU1/g6Z33h54zxRM3pfHPaVbIKzw0RLxbmGXpFs03WFQv42vVZhDxkQcBXxqoReabH6kHk
			jE2KYDHZSPp8CEoD6HUZ2X/K8thoThL3AV3rLTV+CjtJixm7O7p3dbTuOOg0yqD5bHM6Zch6b32+
			uvIV5c6xGCb4xnTlu8hNvWeGzuipXS56npbKN27kfMVAQfNgBFK9Iuo8fgUCm+GLxT3CwwZ8r0Df
			mWDKY4o5y7YgkHLUOUWn0daM9LUyp3cNzXtOymFWvxE1EhHRaWnwvLPmSjC4ZIPfhkBwXpsfFEnf
			+YFLm30ReNbjzrRDuwODSPBimpEY8rDG1VY1YY+9iX3l+wu19uG7v97RtTf4ClurgqizEvCV9BXN
			vq8xHPNpKWUlbrmHiGuahcBFoLnEZct5Dj7nUV1VkuMRMs5WdsHg/l2r7l6VYcla4gcIgQx+4wmE
			LHbYpcujrTYWwamnWXnikIFwprlNNvPaxEY4TFptOm1rMlgPKBvOkzZLvc3tFsrXqJGucVd0+zIo
			62uRZZP9s948tEv56neoq12xSDVtzhzvpc9X5Hwld+Gz8TTqrPo1QV8YSw4Nn+GMrxm9QvoayjfO
			Pb/TZuGbTI4ng1fUsLrwHa+FmQV8428F36B7xxQjjjqLamenPNXgu4u+58BevoiIGQtRnb4CvplW
			YUpp26l7M7Ljl8udCb5DouJqx3CjWrWzSPyOCO3bPzA0Td/lGUSd6W2VijLjO27aJPeV7y/U2ofv
			/npH1x7gi64hD/tlcLUyQsNGe24vi968ywglu5iMdslKBJmFd5UArl1GkvMCsTZRpJzRJwux9rRY
			rMLtylpi+mYEOx1c75zJsIC1siukzSYbdW1GsbLsN5K047Zcmx5a3jG9yCaHI9joLeOPMNGfXqmE
			15QhZ6fs4DWagGE0ycNgObAt3TWcFrP23dntu8NP0mnO6tbtDEGbBgma3Ca5ylrUX+1V+cqS5xFV
			0De0uLgY07jiSlpLkv6Ny4rmWp+RkL4wmOTDBOAd1VUE3uAV5gHWpC/qq2ZMhs4z04DVlbjLglGv
			teJ0r01wMSOqmTJTrRkQdGpVr6qCiwYTV8w0OidbjngXV1RVHNFH/EqPZ1tN92ZExxFXXtE/p4Sv
			WJf1uappX96fHx4fn1aK/BSrK7FBvcXXKLeaGdpXvr9Qax++++sdXXuCb2/Pax70EL3WYwSTsX1N
			L4HKi5PUsvxll71Beouu3MLAinfyHFsWBhgiAkx0bGU3C+DSXmIQZmzSV5If42JvZ7tLN8Byip5e
			q1CwtfizU0evcMmS0xMseiDaKaurnKIei5U1iyAR69TNsPQJC3pfEjp8udg5bxE36hpV175muNbV
			ypxrzb96U+/uMiyj78hUAS2Lp8WbdDr3rnxlwRWzN7Q4H4otaHqr0RBqnc+QQt1Z7LxD+saHRdTZ
			RMnkZDI4oXf0Xp69O70oJyfAYobvmxA7pZNXFLoZCVope1sz4C+nfKfOMX3ZxGqVM76R1XN6EdY5
			4buhGspXxp1bpwyXSlPs2SqH/TJ8B4eUQT3pu7Db50qgd0QPO0P60jelrZTQ/CSm+BrBAB6kOD69
			uK98f6HWPnz31zu69lRwJSqWuclXrzeW3bbiMi9iwaxvkaKVIWbkdME1kdotsdYljJUEhkuohILo
			tbVi/i6I1go8tjrlnYFzIwSty2Q2qxJDeC2isUhKVZsEuM0oe3ZadETapFTFswuDKr3Zlw00MlYU
			dNHHAYhsQrAzI9jeKiLOoi7aZiP05jlWKY46LSbxq8edRa+R0b8ryqB3tRpdUgdtDP2tq1HaaQhh
			Dj/vRfmi10jO8ZXmzlC+CzFN0+G7OLi4OEzs1eut4jXdqzcbsdWkOeNLwpfg+2YUndyd8uWwcw2+
			l39sHLrXXsqvrBI0uz/1qU+dpFO52t2NViH6xNMqHZ1H2DUywiZWBOJzq+cYuatGCfQU+BtVVZn/
			lfAdHW0d3V1zJWyjhdtkKT0/rwyJ4QosfAekyDUp30ukb3yoCPhC+M5Py29tXOfvzJnQvvL9hVr7
			8N1f7+jaU84XPs2kfbmrV8L1NbvkLyMyb5f0LfGZCczXGLEgaYntmRm+1rxgMUTrhhNyFyhtBT1b
			La2sX0vE0xKQXpJzAK26PzNfMoN1ScqTiUSjr4RvWy1vatg/ShQySp2GcK4TatkpB99YZehZtP+K
			hK9NbwXO66skuW4xLal/hSOGIXNNU4vMoteU5jXuWSvIMt1Tp3td3aEr/vNcqnylqeQYR5253RfW
			VlqMDSYXB3mS7+IQ2LtL+epjFUzlViZKBsavWOtsjjqbhS8sKaaHZt5U+Abz6dWpcnn7uX989htb
			33hWrm/84z/+9+d+/JsnPzU6Rb8aoxK+o7wD5csx5nNRnb1R4Xu1GpmLqVE97Nwt6TuaGd2hezFg
			UA9ul0rFBcSd5/VmI3PcWY5WmOs3Kp55u0CkBnxXV1dXxDQj4/sDhIcXY/vK9xdq7cN3f72j66rh
			+0u3czsvJ33RzGuX+VyX62+MkLNdpHpN6NVVL4d07TKITEy1ErU451vieX5ifK9VZHpFe64YZgRP
			fSGYM9YNA756F5A+9M9p7PINrc6aSYY0vmgl/Uobolk7aNYqqq30lK1UnExgEuHiQwJ/E7L/t1UU
			RuNJSnZR6szK16LbdFiMlK9Ada3PtzYvUIL0cvYau5t+dfiKEDQy1iycM3tSviPSZ0MUXdFFEd5W
			MXEB5TtIypeEb035mpK+uvYVxs4mak4kxyeCE1cDXyPjO4FGo2EDvpd9bHLq5Kf+8RvfePaPaX3j
			Gwzf5/4HXfwxnf/42eeefW67/KlzcNgQ8B0VlVec4DUrX+yTdI7OxWJz7MZRU75S++4IPrPXBtdV
			w+Jqfgj1zix8EXde0LVvfy3lO2ICcP/CgMbwLa32D06Lb2wCZw4/zwyG1H3l+wu19uH7P9e6/6P3
			X/j8X53+ygMP3P+xj37s/vvpwAN0fvyvbrz3Lx786P1iuORH7//Ix+5/4K/u/eiDdIePfORjH6Uv
			utPPPuzqHVh7UL6yqJm9MtKonapleQFe4bps8Fa2D4n+Hq6Z4u2GIDLafBhxrDHtJdEx28pXCcCt
			da1Ir5ZcBD9kYfPptOjSlXVXVmM8oFUvSrbZ9F5b267OXUlHsa0T4/okN8FmU3WxU7QfZUp5gVj+
			uJAR5VZw06BPBBme/urkoiB93qCzJnklgHcWUxna16mPCqz1Aeux51q6V0afnaaGI6PWa29TjVQ5
			VVDMM1LnOO0bk6MVFhcXhfCd0RnLYee4mOdrnqoQn54xUTI48dZR5xnT5F+6mkS9FcH3CgHniXGl
			/OMf/+M3CLFE3j8k3D733//7t+nrvz/77P/4H/9E7AWBv/3tZ5/9xzJ3D4VHuxF4hrEVsTWCyHNU
			1jlz6fMqoXhujhuBEYYeldJ3anTUXG6lO22IyPNqnuA7CJMrOVdwYUFWPNecncHb/oXabv/CQnFl
			tVRalT2+pm9pciK+GIvsK99fqLUP3/+51v0PPPE3dz1w4S9/9/67Cb1YAPIrH7r7xb95ELtEWj5I
			N/71gx/56EcB3Pvvpy2D+d1+91exrh6+h9g3I613D2Xs+TyneV2i/ydvqq8q2TdKnKPl0C3xa8O6
			Udog9NpBWnveyh2y4HKGTwjv8sheYSmFCuRWW8mG/hC6ZN1MglTMOWLbK6dI3xpezjbd2dGAr/Sr
			shmD7OvMzbZ8x1YLy1m9/0dnHL0VvFO9BUXvJRKdxDx5nf5gozBIj2jrhc6m+LNZv+qwFYMJ62pv
			Qe/yrRla6aw2cG1YZomntb41fK83jxSMjcFqg4PPc3TiTl8dvqFBtnUW3lNG2NkYrCBbjKZ3R53H
			g1cbdTaGKMyITqPBmSskeyNbWwgwQ+J++9t//O0//uN/+tf/+v/3r//9v//nf37un/7pn7/97X/6
			JzqGe/w5KeI/35LdQ+GIrnwNf40p3V6DbbCiLIYN5TvFZ9uOeivEna3S7IqUryJ8NgR8hfo1Kd8R
			GWweWegfAXiF/CX4rq7EzkwLb00pfmnNnAmpq/vK9xdq7cP3f671sQfGSM4+8MCPrn/qwfs/+siD
			Tz3w/C/d/7H/8189cP9L9z9w4anr7r//qQePHn3wIx958QdPPfjA+566hh7z8lNHPvKRB546+r8Y
			fG8Xrbwu6S5ltQv05vNGqZWoqEJWV0pfK08iko1CGVa+GTqeZyeNksteytjAYcCX/ia2trLy5eaf
			VoxCcNoyVifGnpMUddkkcWWJMyvgGoSdhgZ1yomANatIUy5Vv6J7UTnlbEAdvkxkvDd6P3n6m2wH
			g53IR4uJgjxSIV+ysP6VRVY2E39reVrDqcoArZPtIut2wXmnwYZE7u7AtHh259XAd7fy1Z0l56S7
			ZKw4V+S4s/B3nmbPZSl8dd1rGinIrb47o86Tl4k6j1+GvTP6cKOk8NgYnLmMreT4wsgWgszfAHyf
			/TbWH/7TP//LP//7f8H69j//5A//8J9p/SFR+Rt//izf8xtbW+VREXjWZxqdQ4fvKqtgxi5nglel
			Gr6M8rVJf2epfNFrtMphZ9FtpAtfmfc1SV+Qly8XWPnSV3Flba0YGp7Z/fMg4VuD777y/YVY+/D9
			n2x98t9Cx37si//Hjx588GP/58d+9Fd/TTD+z6f+5MH7H3jy5sceOfHAj0Yf++z/84H7f/TrP3rw
			kdbb/vNfPfj6f33s9Rs/8aPrrvmb/9XgmxadRbKC2ZrXm3qF8BWVyXZB3owMM8M7g5VvhrQv5C9o
			nGexyyI2I2ubMhlR7SwmEaEUmY628iGuk87LPl6rrnydYpaC0bmrz/TTzTNqHb8Si3UC6RaRT7Y5
			DU9IPeBca+dloGe4b4n/TuvC2kmfBPLpNGletrgyx5p36F7ds0pvUKrTpazFkMIWoyhLRJcvdbmq
			VWEZjht0zz0oX9Q5S9nL6JUGk0WMFQR9B0ODQvjOyKFGcR2/uJg2kr6Xq3XWA8pXUr7j+vhAiEER
			hI5PX6p8Z0a2/hwxZZHh/ff/QpT953/5CVH3/0Gnf/mXn/zhT3Dm9Yd/SMr4fzz77D8++z+I04xf
			EWSWZpOr56bOYYgCYLxCIF49d86kfIFfFEmP7nK5ylh1sw1YXCmIO+tJ3/6Bfr3fyFRrtSD5KyHM
			gee52OL0uFHpLAq6WfhO7SvfX6i1D9//udb9//v/9gDp2o989j8wfImx99//0fsf+MQjP7r5gb/5
			9QcerP6/fvTrH/3Eqfs//W/v/9Ff/M2D73vfExdOPPDAg+Gzf/Pr91944N1+91ex9gJf6ZIhUJvP
			2HVTDaOxV5DXat3IbEijCpa7jN6MvEKiktHMbb4y5yu0sYBvCbXOFhLBJUz5s7WWOACcF7MThEGz
			09gzErsW3dBZiFCjO9ciFbCwmKqN/eODrU6Dt3IsoKCcKLwSEXDpmoW3RFsoX1LETnhslPQ8stPY
			mPqEjEIrS+1kahySvldGa3DtMbVMca33qKaD96p8VTnPSCR8EXWemyNaiJm+QvjOGHMV5BIp37hR
			7pzcEXWeRNRZHJmYeDP0Cmfncdn0i2fadffUuX98jsXsP/3xt/+JuPuHpG//+Sd//+9pAcD/TGr3
			j/+YlC/d8JN/+cP/P3v/HtbUnff94mhiwDhFnOR+FBnvkRHHi23dKJJIhLUzi8lcRmpqgWLCDBeD
			2EvIgsvS1lpH9KKeAK2VYq3Vjge0o/xRG6Ixz6St8sveW6nI1IoDfZ6bZ267pcoUWw6GOxlCTPx9
			Pt+1Vg6AFjyCTz4rWVlZSdYKp7x4f45obpO1z1APZjD03aqqqGKHJ5SV7fwI47yfoxrm5il8/nkV
			137Dm3C1g2+04ZdwVcfKXlgajlwC6nJ9NlDybif0ZeH7ET9SgQv7luEDZRj/PXr00lm+uRWv/yvh
			q8aIb0NFUPmOKQvCd3SZLLUtcXJCgqL3lRZFgvy4vCMBdsrFsN25pK0GbFGHIjGhPC53pbzj79cX
			yxTyVNjdXDNZ3NW29BmD7xEy9I/zMVdjwhWbVHWCrydi3c4YLv0lifAicK+TDlUsimcRGgNPAZo8
			mFn6YmoTfh7OwgIQwiMM9bLaBBF9gpW+rIf6V9jWKpkAE6ce4UE4mcv5np9nGzRjBheIVWC6X0CW
			G0uEr+d7Q7J49Z/JS1jMN4/EEHI163VmR+D86lc/x3BwtbdIiSc6R0pfmNePpt505p+x6dXevlde
			VezF8vP+nmsfjkmP6BF1uHqH9zuzshcDvZd2ET8pl++8jfc6e53Oe/mpvtxcwYEzFfZhuhVPmX2D
			4csm+nKzfP1GLMBB/NO24ME9t7oP9qHkdVIuk5E4mIG3bo/JbDKh4DWRADDgGJhsxEdNRiCxyWXt
			6+4G+loM3cDXBrbet2znBdJbo4oL+zY0NFRVfd5AEqG97K1CEFf58FvH617SUwW7bBzm8p1R+PIp
			V0ff9he/Rznicq5n1vnMjjPajVlWfGNnVvhWBJXvmLIgfEeZJZb/Xq6QX20DMStb3KbowHRmuE2Q
			9y5p+a1c8d3kDoVcoV0B64442JG4/O/wYMJ3qpjJ8jO/fdpvfhg2Aviy/SG5NOZfcv2pTpzgW2rU
			cReALFAXtS+X5YxpV9erZxEgo3eZHddX/ctZHJerCZersYVRXTJmF6N/OJn09mWznmaRBCfO7/xL
			DrW8SPW2Yfbv7OwdSMQV85KKIiQx6VxJnlD9/K+4gYF83RJbIfRvPye9nqu5nln868mRUYLD+3n+
			eeyE9SteKXMv5PKc/fOpfMlTXij795r080X/3O+1vuG/LHz/jRv1i+caUYcrgl/SZYNj77HtoNNa
			GlounPXBd88A5bvX1+eKRH73Bg40es+X67x7MHzZIK+fD5ZnL5HYfp7q98u6DUBQK4NJVoBVs8ls
			t6PWtWCdEXIXVka8teODJgc8iyRkmdxml9PWB88y1AN+G1j4lqHfmTR1JlHeHaz/+fOdDTvITEEv
			e33+ZraxM9/fGRYCX9L1i024entzGaKXC/vyc41Y2XsUVTHrgMbQ8Nb3dwfOSdy955NdF+A9BJXv
			mLIgfEeXJSoSW9vSv21TJOa01cxqZpWvoqm9tXmp/EpLTfkbiS0KmSyxPUOu6FCo2lu/nS5vamvt
			WClvrml9VfG03/0wbGTw5SK7GNSdNcuPuiTP6pfcNmnQiJ5kpC1prwF4vU6aVqAeJd2oMM2KFcSs
			KMZs5mqkIdz9VXIywJfEeuE8daB8635VjfBlRwLO4qD4M75PBt8H8pf+6OWyoH7O7/D6hnmHNBsv
			Zj3HfEkSicL+28+JNv4VcZE/z/fFYoc9gD6qO3GiGkcKnqhmD+kj/s9+7q98va7mn3MOZm/0l+sb
			+fN/+9m/+TW18iKbh/HzPihzDa5+/gDK95B3ki+yl4VvwwU25YpTvmybjW1ciyu/Ul+2v6R/yLdy
			33u+XOfKgR2evVFPPvLJK989fPLze9x6czfCE/gKi9Hoho16i9uO2VQGswF0LSDW5HG7TG4HQNhs
			sNoYvdJhNrvQD21yu913lEonpmh1o85F+H70OTfSiDiaMbMZYEuaX3HwJTtY5UvaW2GHjV9yjTZI
			7hWrfL0ZV95iIz7sy80SRI8zRoSPbucf3Hx46/u8v5mb47t7zzGEb1D5ji0LwnfUWUJiYpwCi47k
			MkAxC9TERIU8Xo67ZGTPYtC8f5PBcxTxMnhQLJfJ//bM1fmeOJHEN6siEvfECeJoPsG5mznhCx9s
			s7xlvpjwTFZEEMNLq6uTk8mkXaI+fsk24Khj8cuW/cJzAL3JyZgWDR+JbOkSfDz+jIv5JpGmHF7Q
			/oxPrHreV3aETmeu8OhnJGPqeY651ZxD+Vfc9MBq/qU8fjn38PPPc37rX3rLhclL2A78J1AmsTHf
			n3t91b7QLTvR4ecDsqzYLhk/8+ss7Wt5xQrc533eaZ8LmmMvz/WRTTXiHM9w+ejQLlLZC/BtuVBX
			5wffPXyZr1f77uXjvrjaG5jrDFq3soTTeLu9W75wr0/acuDl+zxXcggn621lpHDICkrWbXd7PFaX
			3VTvpDwmQ5/BUv/nsnrLwe4+xuO2WtW3rUrnrTIHY9vZ003ZgcTofjaCAGYcTmcf0PfzBm7KAmuH
			DhE/85qqz6tA+V7Y8TkX8i2vYsO/AdlW1dzUQpLxXMfDF7tcAXtB3LLa19dR0lvpu513QOPq6OYt
			/l2rSXHVtmO7Gqqqg8p3bFkQvqPPEhISsKQXOJuA/TTQFNhXQ5YgS4AL2QO0xcoizIwmD8oT4uXy
			p/3Gh2Mj6HCFIe7n0Ph1zXNTnqupIRvPcevnuG28O4V9iN3tfdmU2NjY9OeeS58yxXsU35PI9nOx
			aPjU9OdqyPGfi8VzTZoCr8En/rea/wYPwtOmkCfGxvI35BixU/D5sZylP8cusCedf6L3QdbwKOyb
			iY2dPj12+tTY2KneI3KvwQOQNwhW9FxsTTrcxvqdmD/WdO91eix38dlUsgw09ilTp8f6nj3d/3XP
			+R96RMqX4JdXvgjf7dt3gfCtq2vg/M7b+BYbnPLd60t53sMV+wZU+e729zq/t2+A25lTtrv97vHs
			9e3d/d77m7kOVq56k4fymC1Wu4diTA6GUlqd9fUHy2wH653OO7SDcVhten1f2XbG7bj1o1KtoRwO
			i8GE+VdGN1Dbdd7ZbzHc+nxHAzdloYyFbxWKXezC0UA80HyhEWw2VFT5ZVxxVUZcvw3sL8lLX9Jf
			kniUuciuz+8M1MVE6M1cLRKJAG/eum2Pr675vcrdpM4IVHZQ+Y4pC8J31BliFrkKFJaxXTSwz0ZC
			vIzcJBDeJsrl2HMjnvA2gTwX7Wm/9WHYCJTvhLDJYaELFsAnyWRcJsdNDgtbGDZ5QdiC0FC8P5k8
			EkruhIbCbri/gN2JT4VHwiaL4SHcQi0wGR8hD7O3YliIhXI7yGcWHAyYAgecjGdYEKaYDFvcM9ib
			UPbjDTcnwhMniyezAhAfJ++Ue3Iof+Yw7gmoSbgVPisUzsWKxzCyzX6hofh1Tebez+QFCxYuxCNM
			wPcEe0PZE3kN95HdeDjxZO7rIF/DRHKSyWLu3LAHX8y+YHKYeDL3nZjMfSO975M9QWjoxDCxOGyE
			U41Yv/NHhw6d5eB7FlsyVRO/87HtvPJ938vfbb5iX3bE7949/uMEK/eRab688h1Y7rt7AHvf281H
			fb3CcPfuPRjsrbdg3wy3x+0wmV2nTgN8HQYrQ+XaHN1g9eeVIGvvOBz1t3Jzy/5sY9S2nd3dtEpH
			00qLwWwygly224G+ZnN/v6H7c+w5CeD9CC/I3jWwfE68zg2+fKsKb76VN9n5l7z0JdkFRz5gM65I
			ytVRP/M1tXqbzbbi6Lu5DFYgjrdvBmRv27uXL8oi6VYXQPlWB5XvmLIgfMekjQkP85A2AvhODtpT
			t+ErXxLtfQcTnQ9dgIUN+e7axcP3Eu925o1tasVylzSV3MYW+gakW1WC+CXI3V2599031+0exF7Q
			uYGOaLbmaLf33uZ6A2ZamdHljNVEbvftd2praxmlU6/T6WibzaE01J8/fx7o67Ae7NZpC/+spNW2
			7m6HRqXR6hhsc2Uyejx2zII2k0qlvls72RlHZTv5dKsdBL070etcVcE32UC3c1X1wJyrX3J5z3Un
			Pji8xSd9ObZu9mU88z5nUgJMfNLs47Bj82Z0V29lBfB77287dqgBvc5B5Tu2LAjfoD1RC8J3TNnw
			lS/rbSbrlkN8S0lQZC0sfM/6KV8+7svK3r0EvyTmu2fPIK9zJSt8Kz989813NwzKdd7tP7J3t1+7
			DdYlXfl+GaYpO/vNWNHrdtiNJo/6qx7mNKWlbUqa1ql7HG5rveG88vz5vj5nWQ+t0+qOK2m9utuB
			8KUdDqUF6Gv2eIx2WFymfoOh39LXR8hL5vtWsV2vGkjjDbhXwXe3qqoKrDTCFY7tqOMxfIIo3y1b
			eOm7mbidN3vLfb0NndHRzM78JYlZpDAJXseSG7+lW0mdUTDmO9YsCN+gPVELwndM2QiU7y6ScMXa
			WUx3Prn95K5DFxoQvkT64izfPV70Ym4z32NjLz/UaG8AfLGpBpfhvHvf3r179w3F3gD68o5nVve+
			v+cW0b31FpPJ7iL1vG63ejtTW6vR0VaLnaL1tx0mh6Hvzvk7oHytVivTY7OWIXytVodKpYEHGbvV
			YDF5KPtrdpMde07WW10u4HTZR2zWFddlYyf2ueJbbFTxypeN+f7Kq3zreL8z1+KKo++WLfxshTKu
			0dXRAK/zURa8LHrZ4O9mdhwSIHjrtm1bEL7YzDKofMeUBeEbtCdqQfiOKRuR8uWaXPE9Nnad3LWL
			Vb5VLHy3+KYXscMVOLcz8T+zGdB7/FtjlOzmvc7A4ff37ds3UPnuDnA67/a22vCGey2G+oP19QaX
			22IxG81WinI71D2nT9eqadrhcjO3e20Mw1ic55UEvg6bUllvOAjwtXVbHakqymgCCCutFpOdIm04
			zJa+7j6ny0noW+bNeUYd/JG3vZV3pOCOCm+h76+Qu7/iE65IxnMgfA97i43KNh/1k76EvUdZwes1
			3MYXstuwsf3sBXLmoPIdUxaEb9CeqAXhO6ZsJDFfL3pB915iGzv74HvhEsl29vM67/GbKLh3j7fB
			lX+h0W7vUAWE797BPTY43vopX67yFez9PWUWi+Hg5oPdTsfBbovJbffQbgetpawOh6Oz0OHwnDr1
			VS9NU9Z+J6C3718uium2HTQYHB595y2rEpSvxwToVTJ6jxvIa3QZzP2Gvj4n0Lfe4uxm8XtoJxcA
			RvhW7agqJ07nNRXlrPQN6OrsE77odz5xhI358qONjvKiNyDxajtRvv7w5bcAvqQxJTqhcdQg0Deo
			fMeUBeE72i3hXjYmKosGWRC+Y8pGkO28yxv1Jdg9iasWYG8LwLeujijfT/YEGDu8lwXvNnKzZ5+f
			lMVc50puqMLuyn2D4Lt76Hm9nO59b1s9ts84uGXnMqfhz32W+vp6B+PQ5+aoHYxtS8WFj96ha0+f
			OkNTHgfwtL+vz+LU6K22eoPF5tGrD3W7aI3G43B7lLlqvcbjdjmsBoOrz9DnvKO8g5VLfSx9WQR/
			xLKXNNsor9oBorcCbqv8Co28fZ1/xfa5qiPpzluQv1v4FpNvs+R9m1vYflZHOZfzAOWL8CXeas4u
			nW1oCCrfsWVB+I5yk/3XPe1pv7UHsiB8x5SNqM6XV75sshVONLrQwirf6oaWs9uPHdu6LQC+JNi7
			jR/kS+6/Hyh8d/OFRrsr93747r4hMTt4126+xAhIWl9W5rTiJKNum1JP/3i8kGZ0abuyj+/ccqyQ
			OX36lJru6e4Dc/ZbnJSOTjNYzFaG1q/pcfXTGg9F6QrXHD3W6fYwDoz9wnFcjBtuDX70/Qhk744G
			4nQur0DkguwF9OJmNS99f8WPVOBbPP+Sg68v6nvU20aSF76IYNi9PdDpzNthnr6c+AX8BpXvmLIg
			fEe7ye4xplc2Jsb3DrIgfMeUjXiq0S6+rTPcXABrqGsAArFNrgbClziat/ndGTBN8D1vyJeF70C3
			8+7dAxG82+t83oqpVjgPwdmNfTKsB/usVtvx3ltlPXpd8ZpcRm87vPl07enTtynaYejrR/gqdSot
			bTCZLFZG39ltuaPVUFptWvm2rdu33FY6HA6XxWxyuRxms9FuwqYdhu6yt8sOcVlXwFxAbxURvoTC
			mO/s63DFyd1fsZq3jkzMwKAvCl8c68vRl/M7+wjMJTcH+Jt5t/NhPlGLCwIf/SiofMeUBeEbtCdq
			QfiOKRuh8uWyrbjmVoeAvS2g/Rqqq+oazl7azhbGeDOe95K4r2+O757AEbyVfiFfklu1b/cgmTuU
			55ns21ZvMZhxYoLbZTEZ3daDB+u7ld3q3PLCH3VXuopuuR3WrTt7ak/X1mo8DkufBcWvXquilA6z
			1WGz0mnLaJVWo1Jpc3duvbT87TIlmK3earXSDjO2vEINbOnu3nmB6/DMohckL6k9KicQLudbO9f5
			+5tB87J5zwjfLV7pe5iD79uc59lbd7R5oO79Kyd8/aQv8UzDgYLKd0xZEL5Be6IWhO+YshHGfLlp
			gtuPbdm+/ewur/Ctqmvh4TtA+fJTfFkED5gmuNtvnOB77/mnVnnTrQa4nzkp/P6eMgNOTTC73W6z
			y202YasMh/5Hpb4z90d1WlphWXf39sOFuh4biFu6pw+Vr8FFa7Vqm9pOabRWa5pKpwP2qjS5h7ac
			zX77OK1nHAaL02H0WN12O2n3bDZjsytSzUvQi2FeMk5hB2IXo79V2PiCz7XiUp2xy1Ud8reOzbji
			cq4ClS+fdbWZuwxwOG/hM65ImrRXFPvgG1S+Y8KC8A3aE7UgfMeUjUT58tL3I9JLcteusy1gSF8g
			UFVLy9lLxz7Zw47745Y9XENnXvm+H+h1hjv+1UW7B4lcrpfGoJ3v7zlYfxAbOpuAvdhZw2QxW609
			9I96ujBX36PLydxZeHhLei6lpjUUbbPp1UqnU2n0aHW2r746dZrRpAGHVRRFqTSqnEMNa47uzLFZ
			TRaD0mF1WxkGhw6C/DVbDBbr537oJXnO7JxBzLuqIFj29rbiekvW+S51R97dwqVcbfEqXy7Vilw2
			D8q3+iuAdwsHYFLlS+qN+GzooPIdWxaEb9CeqAXhO6ZsxNnOF/DyNuZbHcKBRsDeqraqOpJxdemT
			vXvYiYJch+e9nODd8z6u9vnNQ2DhiyHf9+5juzmlHCCAkb2bD9bXY2Wv3YOdrQC+DitN5+p69Gm5
			5ce7aVVq565dnV0aMMpzW6trSoMNjcOjzel859SpU7dR8qpSUxmjRqPVFh46dtJGYz2wnnY7unvU
			tAd0rxs9z6CunfwEwc8r1sDm51Vcw8nyKt9IQa6dZDXreiay95fkcuSDrcTxvIV1P28+6hfxJaMU
			Nh/1FvkeJY5mwt4tm/96mNz6+nNwUd+g8h1TFoRv0J6oBeE7pmwEypdjbwvXYQNDvg0tDQ116Htt
			4ODLDrrfw09X2Ovf8Yro3gG9JUsCZykM1L7vB5QFs7KXZa/B4ML5gSazy2GwWlxUj75QRytt+rTC
			W902lUqtK1xGgbjVaJRaTS1NwYaKorXqHhC+HHw1lN3hgf06XdrpWi0FEpnSW+ttaTp4xOM2AoBJ
			48luTKzixhitQeH7OdG+bOJVQ0MDGeXrbetMNC9xOteR0QqATzbj+TDrQPbmObMtnAPyrTZ72Yt6
			l2Uvtqb0wnfzlqDyHVMWhG/QnqgF4TumbIS9nQ8d2gH8Pcv318CQLwY+66ob6i4AfPf4s5fvMgm3
			+wh7A+FbuQ8n+O4espTXa3u27RmYgPX++3+txzRn1L0Wk8lUb3VYrbS+pzNHS1n1enWhDaQvpaF/
			TNNq9JRKp/WcxkELHg1Na3V0j5pR1yJfNXajXW91UFqt7sypWlTCKpruVqdpKYahPPbXgL5mQzfo
			a5a+VWuqWJ8zm37Fb2BvTT7VudoX7SXKt46MVtjiZe/hwyx8uVTnzb6FC+miwxmZu/mv8Cr2ysGX
			DwEHle+YsiB8g/ZELQjfMWXDV747DvHCl22ycRabW7VUE+XbBgLQC9/3edfzXh99vfCtrPTBd/du
			vN5P+b6320/6sp2w3t/DNtcA3evAUUaWeqtSqdPqvuqhGaCwXqkuVNMamtLoNIxSo9Nq6VPA3lqP
			x2736HRNKgAwCF+P22NyG9VWs0ej6v3qVK0G2KvV9ah1Oi1jMCg9diPC19LXZzGbb7HB3oqKz6u8
			0OXtwoU6Fru/YjOeffjl053R8byF9Sj7eZ6PevHLqVriViah3i1sqJfY1m1A382HvWW/QeU7piwI
			36A9URut8CUqbuKIjLxgxK+679H87orDBh96FMLXq3yvnj106BIqX5a9uz66cKGBZDq3ode5peFC
			y9l395BJ996hvvztPtwiEV+/EC9WGu3b9979le97lQHVSdhbY9tBEL4Wl8lkt4AuddjU3fXduSpt
			Ws9pj8lqsjqUtE4D3GW0lNnB6DSnT52+fer0aVrDwD2tlkjcVEy2Mho9lAngqz0F8KVSVToPQ1E6
			HWO1WMxuO844Avq6rFaza0cyal+QvkTrctjdCQt8Lz7CiYpckS/p6FztjfhW1504Qkp8ed3rczxz
			uc4sdI/yPmev05ng968cfdlqIzKacM2zrHxlcBEvlIPJ5OIQuXxiqFwslodMGAc7ZGJZvGzszVkN
			wjdoT9SeIfiKkUBiDkMPbQOPEzbEoUchfL3K9295rPTl4XsIVF9DdRtGfKuwweSFC2ff3YuD7t/n
			Mp79GMyFfAP7ZQB491X+BHvf2x2QIA3w3bsFJymYTEajw2Cu77Oqy+B+X7dNTd82ma1Kh4PRpqpU
			+h6bxonVQv2nTqk1Gp1et1hzW6/RkGgvGEVpjDhNwWTX/ueZU6dr7YtVSng2o9EprVaLwwrHt+N8
			3363GY76OSkrqqjaUQXsbdhxAat/yZijQ2UffXTB19WKczdzuc6wdeRdtr8GMpWj71Ffh43NR2EX
			uXJ1vWzQl3CXoPevWxG+SF+S+Xw28dlWvnJxZMQE0cTx48aPk46LEArHSwUCqUQ0fkJUaIQ8fgz2
			HArCN2hP1EYtfEPFYaGEeXiZGOZPwTDv1sSwMO9jCB5cT/C96r5aduKEgXQN2AoL4Z4PqwlA3pAJ
			rH7hDkLWoRNGHXy9ylec2ATad6fP6XyhBYUv6bHBKd/De3fz9N0TsBAbGN7dUDkM+A4oQALlW4ZT
			jExYh+ty1TttZQe7+5zO83f69JTZrNaSPGaVBpStw2I2my3m7lOnGdVVrfaKitJpNZh4pdKoNB6P
			x4hBYzulu326ttbDpGqAtGYjRalxLIPbhI02XnObTK5+YHI3W29EEFz1eUPDzgZs9lwG7N1VhvDl
			lS+HXS7dGRaifLlOG76g71Fv0JcFLqd7/dKtvG7nrduI9CV9Oi4tnvwMK19Eq1wikQimSiXRotlC
			SaRAJBFFC2GXsFQiCRuDwjcI36A9WRul8J0wYbawLiRioSBUII4KlSysiwgTisRSsTCqSDQ+RD4x
			QigSjouAHeMlC58TC0KFkVERIVLRzBCpPFIQKl0YJREXhS4UjJ8glohFUWLpxHHSmqioiHGC8TUi
			+YnxovHjhOMFkZIoqUgsE0WFhQnGhcvgoJEh4WJJaLJYHj5eXLRQIh8XPUE6IVQoeE40MTlSKAoR
			S2Tjx4eIRIqIBXJpyMSaKaGjDb5e5StTyP9+4QLpMAn29lmuqTNGfKvq6lrqWi6c/WDv+zx9CXL9
			Cn4Hs/e9yvU/mW81iMTvvY/sxSpco8liMpuU1vq+80pAr/P8MqfSyugoCvlLeTSMxQLotfzLYsLA
			rhqAy9C0nrZpYYtWUXaH0eQCBGs8KHLx0f5+swvYrFc73A6Qvm434NducrlNFm+1L2cNDQ07gL6H
			PgL2HiXKl21vhcD9ZZ1/re+JD7aShGXE7183H+amFPl6SxK9SzzSbGHvZh95ifoF9m7byt7ftlwu
			lz/ryjdCKpBGRgpLRbMlklLpOIlUIJQIJBMk4yQTxuKYmSB8g/ZEbZTCNwyU71tFM2TJ1YIIiSwq
			ti5MHlUjET6XHFIjmy2STYwMGRcbGjVbVJM8PkJSKoqtE0+sniAQJ4cIxkeLZorqkmWS2HHjRXUT
			pYDi6EhRUZG4Rvzcc1J5UbpYfmShKFoQWlQjFa+TFY0Li0oWiybUyWSiyIgJ46SiaHmNOGyaOKyo
			SBZbI14onCh4riZWLq4uEsqSiwSCqfLxAok8SiiSyCcqxPLRBl+v8k1UKCbLl7Mjjc5+9BEW+dZV
			kaUBlpYGhO8n7+/mor685PXq3vcHY7ZkYL7VMOhLnM4u0n7ZbHKbHN2GvvPnzztB/ILdsRrMJkqF
			9b0qjcNhsVhgX7+VqqV06l7GptSre2zAZorxeHo0HqPJflvjMpuMbiOtYRirRYmqmE6jHFal0v3a
			a0bG/ZrRDMLXbLY2cNK3gm3p3FDVsKPhws6PDr191F/5shVGv2QRTNzPRwG9W4nj+fBh1rPsC/qS
			SC65sA+wPufDXLh3K2t7CH1hZx7GQp9h5YvN7OULxRLhwoXwGxcycWHIQjl8fWETxCGhC8UL5bIx
			KH2D8A3aE7XHDN+JYWJxgsx3F/gQKpbJhhMuFVeHREcl14hCBdFRRdXjwmJ/JhBGiJJrxiXPVihi
			o56bEhYqFY0rihDFhgvH/Sws7OcTw+U/T5ZG1MSOE4qKxJHJIeMF68RRAuEMQGZEsvC5cc+JJOLk
			2PEhR0Kn1UjDip4TiJLE1fBvet0E0YRkuWxqUYQgWRIVNaNuoVgUO64oVhSdLFwnCKkbXxQbEVJX
			JBElx4pCI8MipsbK5YJQkUTwhMk7HPh6lS8JusmvkDKjQ2dB+JLGktUtdYBewt+GlksfovL1at/3
			ffHfIYQvzvAd2M35J1C8+73dWOFrcZvN6Bi22x0OfbcFsYv4hcVi6XcpNRoPsLe2lunRW/oNLrdL
			RdOwQ62mlZ0/Wmmt3u7QM8q0HrfRTnmsNpvbZFI69DYHjQ5rN63u0Wu1tMP+2muAZyNhL2Y8NzSQ
			cl8u85kVwBcufPQRyXeuq2MrjvxqjepQDWPQl5W+mHTFgtY/3ZlLYz7MpUNvJn2g2d4aLH237dmD
			8N16IVGO6Hm2lW98gixeLOdiuwNIm/C039uDWBC+QXui9njhCyyQx8cr/OE7ERSBYjjwVUyYDL+T
			8hDMoZyoCFXI5aHiiSFyxcwQWViIOCxMFhoWEjp5gjhMHAq8mSwOw4tcHCpThCxcGBI6EZ4fKgsV
			LxwnlIvD5HKxOFQcIhcvDA0JmwiHFcPtgnETxsE/AuPgAHDg0DBZ2Dj49x1OKIO78gniCXC+iTL5
			xFA4BfxPLxPjW4DPUblcoRArJojFoxC+XuVLfrqyxMVZqHzPtrQ0NLRUE+XbUt3Qgtq3peXSu8Tt
			zKpfL373DBnxRfgOCvn+pA4+fBCbStrNLo/d7TC5PTpdWp+hvw/g63Ti2MB+8x2Gwbju6VO1DJNm
			tVhc/S4VRVO0Kk2vtN06rmQ0OpsyN1evpK0mhrIbrYyHceltym4GXkVrHFbQxqkanYa2v4atswh9
			TWbnzqoGr/T1w28DX2vEd5Zk+evFMMB3L9G+RPqyAV5+ri+fZYUZVVv4hYMvZ9sQvtu2bs1LTJT5
			w/eZVL7xZJKbbCz6l+9hQfgG7Yna44UvoBZOEeYPX3m8fKJ4eInCijAg60IQzwog5+RFE8STOdwp
			JsMh5ZPFCsL3yaGKsMkTcBs+5xRieehEWKMGDAuFF04Esk4UyyeGAUrDwoDLcAcehycAfydMDJu4
			EIAKb2gC/J8QhicMk08AuS7Gj00FvAS4GwrPmShWwB/IRHSHLwyBx0PgvGHD+SKeMHxDA+CriEtM
			vFp+Fmt8WeXbUN1SDRstRPmefRfBi/jd7VO99/Q6D+pvNQz4YtcLs9tsYWgPttjwYB2vzQDYdfad
			x1Wf28FQlEqV9tVXp2prcyjAsVNJMypNGqVn1LbuHuttNb0sd9n/qzQ43HaM/dLdbprptnZ361Wp
			qRqKsWm0Oj0DBHfY/wuLfYG+FqBvHyjfapa+z3MCGO5gb68GdrqCN+Oqjr8B4Vt34gMs1UXxe5h3
			MW/2DlggfufDRPkS5hL4HibCl0XvVnZQRXYi/Hcm+99A+T5rFoTvYJPJEu5pifJEub8lsiZPjMdH
			cE0MjsLuYnezRg6Oj3p9JLIEUraGK3JSWaAljNTkA817poShIiIDTofP938PCd734Hfr/9b87sBq
			eN/cx+x2BtT6sXdyGGHvsKt0fAnIwz+jNw96qHzn+1cX+dKb7/2Up1dlNDz4Bipf+EWGv5ErDS0t
			FzjqYJsNbmkhtUa7eeEbYEMI390jD/luqTdYLCa3xcpQHrfSYqI1FKWjlTgx0Ons7uvvN1DYykql
			0+vPnDpNq4oP/rnMptdoVSqt+pQe4Gu19px6R7uMXnbe0O3xkNwrncnR3WfV6zWqxUBfB80werVe
			raZRFps5x7PF7NrZwEpfwt+fsQ0nWQzjUN8qzPnm2zuTmC+beYUZV0jfLVu58USbDx/lBiocZds5
			b2YrkXjRe9gnfLdhutWe95fLE9Azwn6ajxLlSz4VHusZngkLwnewvVzwypKCJb7LT9kLuLxArsOz
			V7gTJcwvCLCLXsM7cF2Cy0pYfCu/5YXABS8DbSX/NS2YNy+KXAKNPx+3WbDy3LmVvuXFlcReXCmE
			BW7YDf+FN3j2qICvIh7UpB98xQmwY/jwepCK2rCJ3OLb8i4Tw+6/TJ44bBut8A1UvvDfHqqwv12p
			amlpqWogNb5+8GXTnXezkV8vgokj+r2fhu9Plx0dJPA1AXw9bpPZ4KA9lIeiGVppsfT3YTsqC0XZ
			KI2KStPmnDqlzd589KN3t+bQKGT1eqXaYbVYezqXqfR9amefk+rBBCuNSt3tdDj0OtJ/Q+NgGGWh
			NneZTc94KNC9bqJ84WJraGCzrp6vquCXiqqfcVK42jveiKCXv6k7cfYwQpSVvpu5kl62sfPbfE9J
			rriIKzI67BO+YO8v/3sifNNlA+D7tJWv/DHB108pPNb3/4QsCN/B9gqw9xVYvVKw5JV7APgFnrhe
			Gz56wfgzIWUvsozFjYsFLHd5W8I9tKRgJYEwXF7AK2B2CV69PF7CsRcuv8eFu8CVP1NoIHTHc+yd
			x6H3ItksmIsYDV95TsDekI0XV7IQfnHlACMPIKPx2SvDh/nn8PjgGxomTkhQ+Ltmw8Qy2TA9zkEb
			2kaofOMTEtiPyISoiro61Ht1Dbz2balrubSX5+6gZTBJdw/ub3V//O7eghFfgwGUr5VRWg0WW45G
			A+KXgTWoXwCwxaHRpX1Vq+7p0Wj17+Qc6sosbt52HCO3Do3eprb2WK3uPlqrd9LnDUqaplIBv2m3
			lVarXou1wR6NxuFQ9nR20jq90o3tn012gLwF6at8+6MLDd6kZ0Duz+G6hgsAA5Cr2eG+fOSXd0Af
			eZeUC5GM58PccECifN9mO0oOKOzdwjmdt7DsXY4ZDn5/eKNF+SoUCtlEuXwiycHDEiEM1aJfDa7w
			R4q/IQly4qpLkMsWxMll+E8b/BMBi1ixQC4Xy+TkDusXlOEL8euUyWWKkKhxis8ixmHoVx6PR42X
			E5dfQoL3Fh+Il4nJLdkJZxMTVx3cH78Q97MvVsjgRBPErO9RDAfAk4XI8D78/8C+oYTHmMoVhO9g
			I+QtQAAvAfrismTJ3ED08gDm7o1Q+S7hz+SVubzuxdtXLha84qUucBexW7CEkPYFjr8veGm7ZIlX
			BRP0riT0ZREMN174LuCxO59bzw/EL6t9kb4rVwp+v/L3cCX4ZWUti95zfgAWcFf+8ZUrnz584QNF
			5r8jbCF2ogvC92FshMrXz+QTYhEzgF1O+FY3nODSnQcQePfuodzLuwe12PhJ5VtmQA72G6wGK8MY
			upVqHa1F9arVAEhpvFI4nYiptTpsWm3Xra3LdTmdW8pMZpPL5WZ+7LF1d1scfct0mBxtoUHpLk5N
			VTGMw6bWpqqsmFnF2A0Oq42Cw9BuMloQXov0tZj7fncB6Ut87Sh/wX5e9TNy/RkRv89XkOlO1XyV
			L0m8IkFfL32xnxXXzZkL+h5mvc1e/h7GMiPipt62dU924kAwjBblO3/2DIFMLhSIkZzx4sgSaZgc
			cxCRufFiuTgeWSeWJyQC4CRHZsTJUCovAF4mxE+o2RQ1UaYg9JXPnDY1cgE8NQFpGCqLUywUTCkp
			EsWuOzJOJo5PEBNuysISJ3KYBpayKJ0oQ7jKJ4qRupi4SEguE4sjSqLxKcjWOIVMoViQ/pZ0YmIC
			eTG+v/HJdQsJfeEqEwfh+8hs+MoX6MdKXxC/SwiC/fD7QoAA5rk7TPySZ3rhGxEF0IviPb8I31eQ
			vtwV5fBK1vXMilxCWcQvsHYJe/Hu9TqdifplyeunfL3wnTd//nyCYHLLo5el77yLBSs5LQsXwC9c
			WN+y0J+6ggAEA3ovo7P6acM3LCww12ry5InwJx329Dy2z4SNVPl67W9y+d/kpUhfkmxF8q5OYMbV
			7vcHKN/du4eK+JJCo4HTfO+P32044g8IaXIwzu6ebguTptNRGuyaQXloDOyqaGxiRTEOq6NHo9Le
			2rLjVufmzT2M2cV4zHSu2tb9o1rp1Pb1g/VRqtTFf1uM7GXgZToKY7sut8PRZ/VYLf3dfQ6l1W70
			KM0WUutrsSx7+yPSzpqTv7x5E6AxBlxV5U17Zq36xBGifJG+WGxEejnzMV8238rrdeYDvsTpvGfv
			lUTQgfGBEB0lylemSN4vUsijokABY9q/sGa8nPBxIUfIOJaSoHPl8nH7Zyvi4Gl4BVMUbYiSL1DE
			yRNBJBdNm58kkS9kc2Pi5IqFURsiBZKk2QWRCxVxIFvj4PhirCtAdLLM5ZNo4IuUK+Lg15TgmLBc
			jNUDNQLFBFDboLDhrHCdXSmAk7Edo9E2JcFuchwi34PwfUQ2fPi+8grreuaEL0vgQZ5nFsMv8EFf
			Fr9L7odg9qElPHxlEbxdjJjH0bfgYmAcmCCYdzqz7F25cgnPXj76+wLrjF7pdTwT/A6hfFn0zmfJ
			y7ubScyXvU8cz78nBF55mb0hV8FK7g7ncX7R64fmdz5t+E6GzxO5P3tDFTKZAj+FnjbAxrI9sPLl
			InNRRSfqTlSxtb7VLHzfI5MDd3Pq9z2WvkMI30H5Vj+lfHfhIEGzxeRwOLrLDnZbHWlpNjONk3o9
			IHm1GhC9Wsxr1lHMbbUuVbusDCjWsNOmsZisbjfTabP9WNbdd8fZ32fp73dqVamJCXo1QzMOhwdH
			+JruuJTnl91x9sET+urr660uk5W6YzYZTW6kb9/nb7/9No9fkvpc9fznPwfp+zyKX7KA+q2q5gt+
			Of4eeXfbXqJ82agvN8PIV+fLFRd5le+Ww4je5YvlCvlgLowS5QvwLREpFBEzoyJFc6aL4qIio+KE
			MyJFkvGiyIgFAklcXHi4JApF6/hoiaBkRtyiOXMkIQpRZKRkQlzR+qiFUqkkArTrwk2xM5OkCwlX
			50vCI8cpZuyfMTdmf2xBnFAyR7Bw/Bxh5OyFgvBwOJlCIZJIpApRqTRupmDBeIkk/LMQqUQYGyGR
			iOJEAmDwOEG4ZNz4cOlnIknBtNmfxQkjJXOioqJ3CxVRkjmSCcDxBdJowcYkxfhISXREiOTAXIVQ
			FITvI7IRwbeAVb5z/fE7VOzX63b2cXfJENANWHzKN+Iqj9+oi1zOE0tgzh180RfyZeUvuS7h1C7n
			h+Yyrpa8EBD3ZcO+/JkWsMidx158+L3oj168O5cN5CJ/vVz1QnelH4LPEfzind+Te4rhfXMfH3zj
			4xMChO9k+PAXhwaV70PZAytf+ObjJyJ8wjbWVZ2o9qU7v++F7vte//O+oTpsDJHsvPt+AH7/YH29
			Bb3Adsaht3UraarrlsVkplU4nRfIazUzNGzq9LSKpoDJSkfPzl27thyndYzF5HI5etS2zh6H647T
			Ceztc6nQYc146Nunao123DS5MGeatOvoNxw0OPusJmyjZSIDFvosFtvRt1n8BsrfiqqfebtvVKA/
			urqBk76/xMuJD/bu2cbTF7l7mI37sl7nw946I962Hd76QV4iq8vuCd+nrXzjkksKFIr586bvj7mY
			tOmz2fulBeunL5q6f/7UEmkI7IheNz8qabxMEVI967OC/bM/mxUzLnnKZ+uihfsjf7v6rajoKZ/N
			lGB5/ow/zZgbFymFX6Lxm2LikpPjZu+P+UxaOXXRi0nzROulkv01s96KSf4sagayd5NkwSyJcH9y
			3Gfh805IQpJmz9uYVFMyZ8a+yDhhVJxiYVF4nEQoLImdt3HT/Dn7I0V/ip6wacai2SVSAPy4TdGg
			gqPXCxdtSvptzabP6pLjikrm/lYofJzfpiB8h7CLBL3kymddvcI7nweT94UlPqxynPXd5/Qx725+
			YQB8r6J54RvF5x6/gjyMmuelL9G+Kzn9u2QlofELfKyXk7wveG9eWMkFfV8IdDvPn8dDl1w4/gaw
			l6UvK3Ux7HuOY62Q9TH7wficH41JlPipZzvDx0kCD1q8CRMnyGRhoRMnh02e+BQKZJ8Re3Dlq0Dl
			q5DHxycmLs5CD2tLdR2f7gxUff89b9x39+59Q6VPDZ6qcH/pu7UelK/BbHZ7HEpq2UErndbV3W80
			USToq9H0W0xumj59Gu5jH2ccIUgp1bbe2+raWpyn4FAqHWrGjf04XP2W/ju0+vap20BprAgmDTas
			lr7+fngUyNwH8FUqrQ47ZbeTaiN4gcVZBuw9+9FZDr985vPPyJVdnse6I6CvT/jWnWClL+IXa32P
			bvaxl1W+mwPYu/Vw9mIsZSRFgYP6TYwe5bsfxOj8mdH7Jb9N3rAocr+gBmg8e//8GSXSBUmb5m9K
			WnSxRKpQSCsjFfP2z5hWEjmzKGlm7My5+6f8tmZ9VM2fZl9eIJPFzZw26y3pAukCEKWxGwTweuFs
			OKBg/7TPZm2cGbV/qqhk+iJh7IYZ0kUA39gS0ThgZvKG+QXzYXtmUvWCjUmfCRaKNiT/9kX4T2Xh
			pqSYqLhFJVM/A3FbUDlbsj88blNN3LRK4ZSSgkWbqhWKBUnrQn4LD06L+Sx5fVzBx6t/K1nwWLOq
			g/AdbBdZt/MrRPa+wjmflxTwuVf3KTgajGFvmNcfx37wjeDgGxURFcXilmVuRMS8iAj/dCxWAnvv
			cFnOBSx+lwzkrzfnij8Tp3z9bJ7X9zzPPwcLw76Dbe4QGth3h8jfYX5zHxd8wxJQ+QJ1wybLyUfP
			Quz2ig9MJqB42hQbo/bAytfPMKA2LguznU9woxUAvSx9WS/0cOF7f/wexEIj0KFut6W+W2110MVp
			BnO/iVIjbbW0xcU4Tt8+fbpWo9Lo1bReTWlpq0P94+laMCCyHd3LlBJ1rbm//44yR9X7FeOhmK9O
			nfLgpEHKjPDth4f7LX199X1Opd2Do43gajK5zE5X3++Auhc+QrsAMt8/7OuTvs+zrTeAv3zSM8AX
			bO82NuWKC/ly+CXzig77insPZy1OTLyPi2m0KF+Ab0GcYt786BIJbM4Ezl1fP18xY/+8GX8SIHxL
			ZknDI+fHKUorJXEz98+I3T9DKpEsmDs9GuH7pyhByf6S6Qvlcck1i5LWS6SY/1y0X6iYtj98Bhzw
			3P5pi95aJ5HGiEQl03772cxNu0uS4xSK5BJJuEQaJyqZIvwseUOkRCL4bON1RZwirvqtz4TohIks
			2f+nyM9KZgOTFRd3T5u3Dg5zUTGt8lzyx3OkkfCvwPh1b05A5Tt/WmRyyW9/u3r/XKkC4fvYAByE
			72B7hfc7v8Lyl3igOa9zwVD8fYHPfPZjrFflvuDPZE4J87+kRPjy8pel8EWALmAYcXyRCGLWFU0u
			/knRXAnwC2z2M5uE5c15Jhgm4pf/mnxu5/nzhoAw/xBJeR4E3rlD0da3+XuyMcxv7mOCb9hkHr5i
			eYICyRAWz8I3QBIHbYT24NnOfp/FMhBqiYlXs6uPHAH4Euzyynf3PXKdsbnk7iGV7z34uxu9zgaz
			24Tsre9mQNSm6ZROlwlEr1ZDU4zZpWRO6QC1DKWmsKEkw1DMKbX+NKGvSlULUlhHYR/oPovFSXka
			m9R6N0PRp06BWE4FfjtA3QJ4SaPKetC/FNYaGV+zG90AfJPyzp0+dDc3IIFZx3M1m/Jc4ct7fh4d
			zxWk40ZdA5d4xcIX+Uvo64dedqrRFm6U0bajRPOyHXzu9Wk+WpRvTYkgTiFC5atI/hOrfC8q0O28
			X/BZ0qaZG9d9hjiUz9kfrZgPynd/pEIRJ3xLehHgW7Q+KmRm5KYkuTgkKTlOuO4tAfpQYkteVMwo
			EU7bL4kTgvLd9GaIIg5AO02hmDdOUl0SpVBM2Y+IjVtQ96YwbgrK6ri4jbMwp0q4f8o8PNs40ey3
			Vi/aPzUO4Dt3/4yZRdMk8B/CtMoXp5SI4jD7asKmTePiNm367XXQz+sXKCQf18QhfB9fTXEQvoNt
			nhe9rPd5Cet85hVwIH5fCJS+ft5oP9r6sMs+hz8TS96Iqz4FzKVfIXkvRhD8XhzaCkj9sX/7Da4C
			mMjf3/N5z/yZFiBd5w0ELq9/A/bwjucA0rLpzr9feS976jFfBbq9xaFYbwR/LjhfgZwtNExMJoGK
			nxR9wxRAI25zsrchZOjkp9Eb8hHYo1C+xEift79Hv4m6l0hfAt0B8PXPbt69bzBn7xfz3VKPIV+3
			1W011DuUth51cU4jUJcBbHoo7EbVz9CnanEaYA9N0zpKR3kY/VenmduEvhTD0Hpap3H29/WDqGU0
			jObHWrvRo9XSp2nV37HglzKZMQ0aZG+f4bzSScNx3W6jx2hyY8qV8o7S+TnX0LlhkPL1yl90Qj9P
			2k7W8X5nLDbay5UbcSN9+XpfnGX0V8y52nq2eHFiAnHl32+GwChRvvFxgpKahVHTFhzYDfDdsCim
			UiAsmR03pfKzmP2Smes2zZ+xv1QhiJLJxq9L+mz+/mnz1yXN/0wgKYl8cf/q3ya/FVUa8pmkZqFc
			XlM5LTx2fYkQfnnGvxWpKKpTzK6UyIWV0Quk+2MnjBeKSqYqFNOEivD1ExbIRBuqZ46XyhTRG+Yp
			otbXzfxM8NlbSXEymTyuOlmBdUM1CxTJseNKZix4M0kh2j8tfP/+9clz4mbsF4x7c9bM8QL0XO8T
			LFiX9Nt1deOq93+mWPRWTRwRvkH4PgIbJnxl814ZaAWveDOfWdfzvd3PLwQy+YVAKHPGnwrULsHu
			VVb9XvXlX0WQflRR80AIE280L3j9e2CxSpxNxOI5zPe5YtOuVvqU7/wIlq0R83/K5s3Dct/fr/RV
			+QoDQft7/w3vnaeb7RxK4CtnkQt/ceIwdituIfnbkT2hUXyhixaFiTnO4prDcEiYWPHgB32a9iiU
			L2vy+ISExASxWHLkvfc47AKC+e7OLFv9Hc2VlSNqsbGbzBI02R1uC+hfR4+6q/zo0TX/M097RaPR
			22s9JqPRSqmtWJJrZRilkmH0NGN953Stx4709Rj1Nmu/U0X3u/r7XTi412H1AHw1GmwFjZ2u7Ha3
			u9/cj6ORgM5YBewxuu0eeBIOWHAp6TvOW1XegQqc8n3em3PF5Tyj8mUbbvBR3xO835lEfTeznTa8
			2c5bNh/e+u7yvMS/JSbK+a6u9/k0Hx3KN14eJ4ydGjkhbk60cGFk9DxptCAuPHZO7P75i6ZNl0pi
			xi2IjJ0qUsjEclFspGjanM/mz4iNHLcwOlYYHVsgiY4SSaWR4xPlE0Oip0wLEURLsUYoSiKNmamQ
			lkrFgmmSBXGC9KkCsTAatuABSZRYLlYIp04Nj5PLxkXGgSaeHisJmR8dMx49BZEiBZb4SsMFkQsE
			0ZJ50THj4JWi2Bk1m0okkmiRXBgbK5mgkIsXRs6Gd7dIOkUiTJcuVMyQyoPwfVQ2EuXr072v8GFf
			L3p9DB4Ku4GYHXCHtVf4H+fVQebFbxTb+uLiRTYNq4AtAuYozCpfPg2aa8fhTb1a6S34Hah8/QO/
			4wdB13vD4ncIH/M9xe/vVwqetvKNJ8FFcg6S5sxhmBuDIn8iE4EUoSHwrqfydyf8XMhyWB5b9BQm
			Ej0Ke2TK19s9XC5PjJi2gXc4v7/nr3/967Y973uBex/43he/BL5mk8fhNjsYj7qsZ/uhC4e3LJ+P
			DmNSKOR2UxRtPe8yW22M2nbb4VCq9bbtp07X2ilQv5TbYXD1u/QqpdPlBPZSlBUOoyE1wpTHTmk8
			drtG4zExGsoNGlmjSlVRRqMH2Wv8L7vJqUTla2MbWmFCc5VP+T7/+c+qiN4lna/YG8BvQzVH37MI
			3z3elCsyVZCVvgjfC8VXSW5zHKHvMOH7tJUvsA57acSxpbRYjhunWKCI3j8e3b+wV46tpWAJk8sX
			yvBJcXKxLB4zuPHpWPOrgC9VjsnygD7sdSGWk5phbJwBz8AjYBMqbJOBe0lTDFmcmK0UxhJD+UK5
			Alt1iMUiLDcmDbZkCzAFcKECzyiLmyZVxC14U6KQw7FkC9n++oBw0MpwfACxcJx0Ifk8CcL3Udgw
			4Zvw8isvX3zl4kDlO5f3QHOJz/cXwENTd5DyZaVvBK990ffM83feQD/zKwVc8w2CXnJvJVyWrOTy
			sbwlvy/45T/zZwoN9C6PH5q/vmKkiyu5JhvnVg7Tnnad74A//4WBHy+BfScfj4nloWE1NROL6sbH
			CpOLYmPDIseJY2uEsUWC52qqpTXji0RjL/T86JQvtp7k0QEfhRE1+1D97vnrn//857/+lYevj667
			KwflW1W+dx/bRrzODrcV8Evre2y3Nm/TLt+6I0+DALW7XS6X2eOgNHdMZgtts3XbrFZrD9D3VI/V
			AZSlVHaTQed0ubAmCUcOetwWN6XDlliYUmW0eyjkcH+9RanxaLRIY4p2O0D52o1mNzzZBex1OonG
			ZdUvNrpqqPYSuLqiiiUwv4ZHqxo46bt3DxkNuM1X63v4KGlylXVVPqJP/tGifP1/6N6tBen7pMM6
			7T2aNyfIhznD1ze3Bn7PFh45IRyUFo7/kUtrBELptAV++3ybAOKIN6uFMvnjnV8YhO9gmzfY58wr
			YJL+zEeAX/kJ+t7T+MEKCF8/yct6oFnh+4cItu8UX3zEZTn7377C5UCTsmAuAfoFUn3E6l+y9v7m
			z5/JohXxO44sQyU/e2/mzR0udHl72nW+gacZCN/4JwDfaelh8nVHhOJY6dToonHiExNlUbOra4QT
			TqyLT09Ofk5QGvoMwne4yjfwpxNPmg6Nj91H4Pvnv/Ju55/Ot7p/yNfkNjAek4MuKyzc8tGWrWt2
			aR2IS7fR3G92YbsNUK65WlWOXu2wWru3FzJKh8Fqsro9KsptsbosLir17ypQtR6jg6G1GobxWO3Y
			RNL0XwBf2mzud5ldHk0qRQY2KB2MnfGYLWaAr9PV7+xDvzPb2pm4mxsIY1n24oXsZOH8PLuT77Ox
			d89e0L4Y9CWDjI4ePXz4bNZVnJYW9kDwfdrKd+i/fNH4kGF9NY9ucAL8nonHjxfHD/pq5RNlYvH4
			CFgP/Q5AVUeMxxaVj/U7EoTvIEt4+eV5L7/8yrxXLvqYy4MX+00W8Nx95V4O6BHAd2j7Q0REVIDy
			LSBal0XuK97ek8QPzRUDk1xs0gOLazvJFgLzZ1o4c/5ML28RvTN5/A4lf1npe19H8wujS/mGTU7w
			/4OVxy+c6P+XI5M9AbfvxImhEllo5JHnwpMlNRGhyeLoIxGxdYJxRePqoouiTkRFjsE+049S+Q7+
			S0uQJy7Oefuvf932Pudp3v2g8N190GCot5iMLqvbbDE41L3qLVu35ZzdoXWbzZTL1N8PN1c0Opuh
			T6mkNItVmi5lt7W70+qhlAarlaFSNUaHxaHU6ED1pv5dY/eQzliO2tra/zLa3W67ndKpNABfs9ut
			Yc3jYBxWkMRmg9loNNR39/U5+37HotendxsQwXzDqyq//GeWv6TTc92RD/buQeXLjRY8fPjt7MWJ
			iTimUzHCD/9RqHz9/gbl8id9VhKynTgEycWk06UYlqFelsD6oOPl4iB8H5UNX/kCel9+BdaB+rcg
			gMMB6VfDJTAHbf5MPrez167+4aq34aTPBirfJbzo9Y5FWrnE24SDrQGeS9a8C2bBzJkgfWdy7F3E
			S98A/RvhV3M0fx4b7vUj7+/vj+NhemgeW51vwH/LMvnCAM3whOA7ISRkQliYPCQkBIgklk0Qh4rl
			E/BrwQSwCWNxyMPjUb7en5IiLk4BAu9qReVAvA72Ot8fvmUGg8ELX1C16lubtx0uv6UD0euilP0u
			igbpqu7us2AhkV6jvaLSUTalw+FmrA4rTdfWOtR0Wg59mmFuU5TLfYfWqlR2ay3jqa213SZRX5WG
			MZsc7lps04Edot0mt8sE8O13GY31ZTt/51QqnfxUQc7vXNVQzS1gvkDw876nIH1PfLB1D99jcm/F
			lcTF8lAZCXqOuLXhqFa+qCMfrxt36NPKBzcjgZ3xExGw8RPv8VblYTIyW+mxvrUgfAcZxnxxmQfi
			NzD0i0HfAh69Pvzy5PXdBuLWu+MVnr/8qbzVvcBcfn2VKN95A6K+XKSXnXfEI7jAN/wI1yTreaV3
			DPFcfIw/0wJQvjMXzQfs8sp3ZkDu1RD696c9zS/4S+CnHPMNlfvDNyFs4UL/Pxz5k4GvPEQsCwud
			MFEeKgYehYUqwsSAYkCweGKYfMJY7DP9WJWvTCGXTVYkYNt8uCdI3uBH032DI7z3g+/79QbSYsNk
			ZRyA4fpuW3Fh+c7jNO12m006leqKSkure253d/dhCytnn9Om0WmJXzmNsVp7bp+uPVW2eWeO7jZT
			e9qNcxLcAFtTT20t7aG7sEMWADdN5Tadrj19Wq3VqDykytdj8njsJuC7tfuWzXnnjmsHJjnzSreB
			hS5r1dy1yhsHxm5XZNDRiSPvgvLds7ehafFiklxFpu/9RFXR0J/mo1n5xoOOfOJjeEku1qDTysjQ
			QF+GZvzQj8uD8H1kNtzPh/kvv8zyl6wGEZgTwX7pz37S95VA+r7ivXrzpBHb/C8DcTGzwvcqwS9B
			8VWu1tev4VUB12rDO30QAezzQC/xzl9Y4ptFSIw/0wIkLxvsXcQJX3/Vy2/7ZUOTet/7u55HkdsZ
			zDfBWyZTiMPCxHLvXZyw8LQxNjbtsSrfAR94oFDChDVvVd4j3+q+tg3hi0MODIyuu77bYNWlpam7
			u/Vau91ktuNAo1PIzXrD+VytHgHcZ6a1VzRqNaXRMtavzpw6dWzr4S3l6tra2tMek8llMnlUKuYU
			lgAzdHEuCGWVSpujYk7DUU5RpFs0BQD2uB0YE3b19f1umbO/3/J53QWetENZFRHBxP3MOaex4OjE
			iSNFEnmCON43KP4Bu/mPauUbtIEWhO8gY2O+84j2JTbQ/eyXexXogX5lycAlYOXb5E/FopZVvRH+
			zmdsr4Flvrz4jfBiGBs/+5X63sPm8pDmz7RgJgdcdkH88sQdkHoV4es8ObjT5LnRC1+c3svTVj4R
			P3/EPvjKw4LwfSB7rMo3wEjBCKbGyOQRs09sqNw9Ium7vR70rtltNJpt6p4em5vR5aTpenrSVPbX
			jCajSpWK2Ky1dxucOTqL+1yPAACAAElEQVQVKF+Qv1ZKpUqzMRStZ6jeU9t3ZOcePvYOCF81xeCY
			Xo8qFRjbe7qWPr756I4mhG9nqgYkcu3pWkyhVlEU4/G4QfmaDf8yWFz9/eZ+y626Cycu1GGLK1jq
			kLdknDG23fACuIFLxMIE6IaKmlIRGQSP+oyU3zzUp/moVr5BG2BB+A62+Sh82cs8onyBvvMCEFzA
			jz3yIteb/PzKEu+Nl7a+J7K3AcrXz+nMepzxQq7zoqKisNckwfLFqIvz5g0sP7rIFyUV8M0nCwJj
			xf7wnUmgO9Mfv4Nynv2zn/FsI8h2ftrwnRwWppCzikEsDiPGttwgU7WD7H0we3LKN56tyMZ/mEg0
			Th4Rmbz+vtVFA+CL/a2MJqtb2W1Vq3U5upxcqlAF8LXbmVTVYoZ0kbTWO9P+70Ilep6dzn5sG6m5
			3cN4aF3u8TXFuW83vFNbezutS0Njbw1Nqkr191QVfWvLjqMXKvKAvqlXVTZyGBpeCY/SFO2hnG6X
			2eJ243gFi8v2ETtY4QIweLBx/udqEg+uSC+9sjgRwQtfLhkA9fBpvkHlO6YsCN9BloBuZ7R5xP2M
			q4uDJPAAAeyNAvM3frv98MxfuTPJvalWfhs+BTzPl4VFuHwxKoLMOiKTiLAFpZ9eJh05+BdEIbVx
			NS+K/6JIzJel7kwC3pmDo7zzvE045nEtOdhBC3OHVXb01OFLekqJMbaLUCAfPhhiFWPAdewFW0eJ
			PTnlO4ShDAwVRSe/uZtVvfdRvmy+ld3t8HjUalpPa9LSdMU2nRZrfCmQqYsp9DqfOm0x6HTnnef7
			CH2tmsWobnWgY7W3ty9fc/Tw8dpaSpumAbQCXFOLsbdVY+elnLeLz+ZoCYr11lrAOE2lLl4MMG6i
			PR7GhOnQRuzv7Op3Hn37KJltRMYr4JwFsjqBUhg1McjguqrlpYKIxAS2SzMpfcb0qpEmNg/9aR5U
			vmPJgvAdbPPZWiOevK9wCVhI08GdJwPx66+DeeBy/mnvE/yUr6+1xgDuRkQEZEFzT5kXRYgbNY/Q
			1Qttfi5SRNRFFr0+agfAd4DbeeZ8MmYwAL7z5/m2+CGDxIeN4xXmskMW5pJJC3NHIXxZC5vMkRfh
			SxTvxOBUowe1J6h8Bxmb9kJSZuTiCGls8vr7wtdicNk9Zo+bcTDqwlzlrVwtAPhKjo3WaYGmGub0
			6dMmh8fq1DmXEfb2gfRdrEql2P6RVNnWrVt23VCTFhupKHNTaVqn06kyuy7t2LLm7VtpOtidylit
			Hms3drhKVakZ2m1yM2aT2w4AtttNLpdzyweHjx4F/h7B2b6w/oizCxfOXqhIb8y7+jd5ojyRtHKS
			yx9VOavv03zEyveJZ0A9qCV47Wm/k0dnQfgO/jHPJ95mP+H7Mul59cpFDsT34O+SgST2oXcJHyDm
			7nNnkgX0lWRB6nf/amAHDm7yIKt4fXwdWCAc4c/vCP6LWjhzJgtdn+OZHygY0NzK22SDPDDPj8Ar
			Oebyq4IBgnjUwDdoj9CeqvLl/yDJaAz2Q3dhlHR20VuDJXC3xep0ue12o9liddi6d+4o7zyeQ/dZ
			rEoNw2BVLqYr200mD2W1OJ3drPLtd4HwdVNajYbSeywHt24vzNWRPCpKr9apdGq9ntHT2pxjW7aU
			bf7RBrs0Gtpk9Disakqr0+pot9sB8HW73SY4sdvucildWw+TqbwI4KNnkb8fXDpblZUpHB+aII9P
			kD9mcoxQ+XLpXQljzLzvfMz853CvH9eTJqDPRit84+d7nc68XfRmPw/Ivyq4J4QDRfErfrJ3COV7
			dRBpB0CYZW+UH2K52DCvfa8GCGdf9TD/NS2YOdOb5DyOLTjyn+UbeHeeV/n69O/FggJutuDclQUr
			/Xs/r8S8rIIXg/B9Fu1pKt8hTCYTkxKQeHnoeJEk9sgGLii8u89isPS73C6sEgL6Fubqbbk0Y/V4
			PIwDGIlT/xi30WTCKUQmA8C3r8/Sb+4HLLvd3Q5Hn9NlxkYZSniNweLo+eqrU2r1j7mHyjqPd/bY
			9Hq12mZ1KPV6j4OxezxuJaNL0+Wq3Q6bkgH+Wswut8nkdrnOK7e+uwWWw+++++7ZqvTSvKuhiajb
			ExIed7Mk1h5A+SLC+KG15C0O2niKe2W+vYHw5d/52LYgfAfb/AHoZQUwJ3pf5i8DC5AGMDjQ5zzA
			+DNdvZ9FBPDYi90/DJa6XJGS9+INBV/1V76ctxnE7zjS7WoAZ/lN3uns08XzMJxM6IvuZ7gsmUvw
			W0BgXBBUvs+wjQbl62cggmWkNyWpgRXL5Xg/LGR8YzcmO5tNZpPbbbXe7r7V02PLvXW8x1Z7Kg2z
			pzygeT0Oo9GETzEytLUPXuBiPHYGdlv6zut0SkufwWax9HUzDOOwwqq2p7O4rNtm+1FP62iaZtBO
			nz6tp+FVHprp6flqu8NgUDIewLbBYrYYsIb4zoX00itX/75YznFCnqDgJdrD5TEPzx4g5ivzFjiN
			covnr/wbD8L3IWzUwnfFyzNhwcgvrMcXcM5ntvqIJD7zJcDDtwEIvo/yjRh0N6AEiQ8Nc3uveguD
			fa/gHyUrvkqcdLga51ffO2/+QKU7UPsOUL6+sYZzC+bOJUHggpUF3AqWIHyfRRtlynewsWBbXG+x
			YJmvxW131Xf33NoJ1Ow8vKVQefqUWqvS2R0O+orK42b0VqvZSmtUGo9NqU5VuSnd9txlzvM5Obo7
			ToRvf1+3krG6LI5umnqns8ymvH3qFE1Mr7epHad7ValAcqOHUn91+6tTt82goq0ms8Fkd1sOlpX1
			Oa2pJJFKToqGBom1x24jUL7snyt5b08bqyOl8DNjQfgOMtkKlr4vzxQJV0ZEzFs7SP9y0te3ORIO
			+ylf2dWftghO+PqnYg2kcwTnpw54LvsC/otayLmdSabVuEHw5ZzMERyE5w9AL8tfrt8Hm4AFN0sI
			gmFN4sFB+D6LNsqU72AjgjJxcbcF1KfRDTQ0Gw7q0wp3bt+++VBXGmjVXq2KsbspitIw6u1btm/f
			elxHaWgLaF2dVq3N6U5bdue8LjctzdLX12dxLltWZtPr09J0qSqdWkk7Tp/qAe7SjF6NEWClZvFi
			FUUZKa3u9una0yCA3UrGYrEY7UZLWXf3MqUzlYUtoYQcy3efaI7QCJQvodgYSmAaCN8x9NbvaUH4
			DraMOeEvvzx/5ss3C4QxV6MupqyMGuSF5oWvH4j5m58iMb6EP9MwwMvf/oEfd3R1AH19XumArGlO
			+vop30Xj0OHMZzrP54EawaI1YqhIL0FxgPplpe9cFL/sig0BLylYOcxvbhC+Y8pGvfJlbXG3wWIx
			u90mk9FkOZiWplcXLitM0+n06hxMZdYxZjBL9/aurs6tW62gkg0M7NaU0bY0fa7zjl7bRGP6syFN
			53RYddq81FSVVkXrmNrTX3Wn/fijmqHV6h6bnqEWU2oN41Dv3FV++5QeezwzDnR3243metstp9KV
			mhhAhSeMh5EoX96edvrUSPKsyJUlMPnP5qn+zj2CH9eTJqDPRit8ZTdv3lz78hKhQBixak54lGDF
			l6JA8TvvZa7vZEAdUgCFB6dn+UnlV17mT3U1ILeKs/ED/M8R/u5kXz5VQDaWLx/aL+/KP+EqbtxM
			gl1vZ8nBXmZuF7/yCeB5PKg57/Nc4nkuYAcKsw7olXODyveZtFGvfInJF5fVA3yNJrfJaLQezKXp
			NF1OjjaNUVIq1R+AkS4cSOTaciFneeGhbd2Gf1nMJhpHE+lsy3TaZXeWpelsd5x9fc47aqXBUcjW
			Gmk0Wqr2dFePslvpUNq6Hd23ymlaw1Aaj21Hw9bDJ9EF7fEAyQHrRqPJ0OdUInyf5vdhZMp3rNGX
			M6yK5vD7NL/Xj+LH9aQJ6LPRCt/4mylvrLr5RrhQJAx/I1IgmLMiImMOECgg/+oVVv/60fflAA6/
			4s/glwdsvxwY8x2EXz/+Rvht+fKoBklfH3NBGf/hqq8AmP/9DBu3aOa4cV7H88zB6c08ZiPY1SA4
			XyQ6mU+84m0ltxQEY77PpI0N5StfTBKujG67yWSylt1SpyF9aaWe0mInKg1lMvf3m/WHNxcWd275
			qMz5r36LycTouzSULfd3OUqbTufU3TH09znVlMdg7dTm6bREMAN91ad6HAyjz9Xr03YW6jUqYLZ+
			V3rmrk+2rLmyWEV5TPo7mOYF0rff6gL4DnOs9eOxkSpfUm9MPLncik8wHuoOtyG/p/3Eww9sA46p
			4N/1mI/+BuE72ED5ClcJhEJBZPja1wXSA2tF0hWiyzex4ujleQEe6FcGyFx/BvtJ34EY9lO+gb7l
			eziffTKXV7R+D/ktvp4bfLtoXvnKFgJ8Z84fN3PRopl+SVdDpFcFJmMNIjDL3rlz/QDM0jeofJ9J
			GxvKN35xGWlwZbdbzBaHOi0nV69Lo/V6tl+GNk3jcZkt3brmLVu3fHSh3EajDrbQOpCu+txlOWnn
			+3J1zvMGp9KBicxWfVpOWo6WHZ5AKW/rlTa9TqUqzunEA3koj3rX58uPLq/YqUdAeyjGYzQD800u
			s8ulHB3wHYbylcsWhHy2aBG5jGy5p7GH+wkbN+Qd78ZMv2XcvY4xH18w7iH7YI8CC8J3sMWsWiGI
			EUQJRYK1ojn5EZEZl6WrhMKMub+f+fLLA2K/3hDwy4MEboAU9n/OEMrXv5WVf5qzT/hG+PHZ247S
			m4TlKzL6g9flzEpg/mtC5TtzERfvXeTX09mv1Hce21aShS/7UMRA7YvwxTAvT9+5BZwPeu4wv7lB
			+I4pGyvKt8xgMZuMdpehvluvTtNpdWTgvVaDfFT1aoCkNM3Qvd1lB39XrNMwSsZFF2PHKm2aclmu
			rk/pNFvrXS4349ZQ6rJuvV6XqmUcDqfr/HlnnwWMVqVpU1WU3Wi02/Wfb9nS0NRwCAf7plIet92O
			wWaTy9I/WuA7nDpfWZRAIDh37vKIl0Dz23cZbeAjAxb2OZeHsC8HLj7z3+YsPFyqeCQdOZ/qj+tJ
			E9Bnoxa+3y8VhAujpCKR6KZUmCIVhs8RrVgVnnHzj+y0o4EdOF7x80UPvQzc8CrfPJHPcRzhbXIV
			EaCEI/xczwE3/k0o+QtXevQHNvvqqhe+sgXjeMnrbbIROETQr82kj8G+tCwveufyQV4S6OVKjVD5
			DvObG4TvmLIxoXwTFIvLgL0mo9Fi6Lal9fR1/85mW2azWR0OzKtSaTQ6DXX7VG2tw2z+l1Orhbsq
			jQq0rQb462AYh9NhVirrDQ63y+QwmXtsDK2jl52/c155noxg6PtXv5VEgdUGk/3/Z9d27jz80YWj
			x2trcR/lsRtN2NvZbHG6nIlPNQ45IuV78dyLD2LnHsIue28CqOu/yV2+ZDcGcZg1Ka4Uj3na7hP4
			cT1pAvps1ML37verJJIouAiFwhVrI1Ika4VvrM1flfKbF1D6sp2fB+Q/B1Yi/SSD+TMJhXn+knaA
			p5m/enteRQT6qP2Kj/4woLsGl/x81S/hatFM3zDf+Yu8E40IaCPmBcDXp4rn+zucSaLzypV+F7bG
			l8XvML+5QfiOKRsbyleW2G0x4zTf+npDd1m303kHc5cBnC4XjX0le2kNdepGbS2wF5Y7tCaXxHQ1
			qaq/p2pAB2PJUP1BkL6ufo/J6DY71LR1GaBXz7K3r77fiu2facpoNtoB27/bWXa8s7bWo1F57Ha7
			x42ZXsDeUQPfYSjfBNnFR0DTYfHW74Kil1sNlr4saQls+cu9+YvwfZrf6kfy43rSBPTZaIVvQsrd
			l2KEQolUKBAKwzOkKeE3JWvnrJiTkpLyMlsA/FPm6wjt3XzZd+9lH3yleT76Du4oefVqIJkH5T+z
			otcvv8p/OBK7gz8Tq3wXzecbPA81SzCCuw70SPNJznMLCryad2WB97aABXEw5vss2phQvvGyxbcM
			ZmxwVd/X/eduoC6oVnZsYJ/Vg+pUpdLWnjpdC4Tud1nMVE+uKicNJyjghWEYirYa6g86Lf39Fo/J
			7TbRtM2q18NBCHr7QPmCgtbkMnaj8TWMI2s0WpqGg2o8SGOTyWw2mg0GbBgtHyvZzgS+5wh6Xxzu
			gi94CMHrYzEnfs8NoXy5K4df7zUI30droxW+8Uvv3k2JyRM0igTC14Uxq1b8cWX42hWCmykpv0kJ
			nxchEoD6XeTH4Pn3RvCgYC+3iz9TXh7QN8pHXZFUyGU6B4A2oLZoAKy58O6g4G9gwhVpsjHTf64R
			QfA9J/l663txVCEZE1zA9ZMsWLkykMAFXKvnYX5zg/AdUzZGlK+8EOFrNhn6gKHoLtYDCM8jOPtN
			HpUOk5fpU6esAF+X2eVWdhdqtXqHEgGqc4DV0m5Dfdlft2zbri90uO6YKMpqVZ4/v4w9RJ/F4qJ0
			AGrPayBzNbpUFeNU4qQGt8NodZHGWsB9Q7dTeWfZ6IDviJTvkH7lR+JzftGH3sv+0WFc3zPm6yWv
			D8GXg/B91DZq4Zvy0vevXp4TKYmU5mVIpeGvZ0QJV8wRZIDyTcmIiMoXrgovePll0gJreEJ4kM3n
			zyTME+QJvfCNkkobBVKRv2P5Kt8/csiKYD7NmRW5f/DGe/l5gv7Zzvw0X67PFV7GDQ1fUL9e9HIZ
			VaSVpN9QwZWc8GW9z/D4kmCp0bNpY0P5xityEb4Gi8VqPbgMI7Xn0Zx9d5znXQ6NljiZawG+lvp6
			i4XS0Bpar3a4lZRa3aN0qPWULq3+4Pay48c++SiNBhmrVDPdBqezH8lrqO9T0hqNEmD72muvodzV
			eExmwDilNzkYjwMOasK+Wt19y5xKvWJUwHe4yndowHIq9xGGfL2x3ss8eofyPQe6mQM9z0H4Plob
			tfBd+uqrGUvzp0piJHkxEmFGBhA3Jfwmsvc3GVevSoThghVzCnwonUnE7/yR0Jc/k1AUAfi9Qhh7
			RdrU2Aj4leb50BrhK+HlgZt35UrelYD4r1+b5z8MnCv4B/5MpLezb6zROL+kq/EDA71siRFbVcSV
			FfGDjOZyipedqQDQxcRnbDAZdDs/mzY2lG+8IscAOKw/CPQts9FkWC/xGJ+HWzOlpmjGo2EcFGOw
			6WhKTzHqXJvS4WD0O8tsaXpap73SZNve7VCqt26+RVs9Hppm3HZGaUFXspLGkiMPkNpjNBqJExv7
			aJnclNLBUDTF3FGajS5Ld3f3sjt36NEB3+Eq33P3xOsjg69fjtW5wNjvwIQrb7YV52q+n+oNwvch
			bdTCd0rWtZrVNTWrVy+dci1ccPNmuCDqpvD3KUT5Xo1aJbw5J3KFYBVAd9EiXvrOv5//eZAt4s+U
			Byi9kgf8FUgFgF1YJBKpVCq6GuB09vmcI/KukCXval5EQEqWb8BC4GTfTP5MC/18ziTiy403IvKX
			u5nvbSHJDjEiRbxzyfyignl8W0nig55H+lyh/CWuZ9Jn8tHD9zHU6wdthDY2lG+C7IoBZO/BsoNW
			i/Vg3x0DoS93MXtqT5067fBQ6p5uG5Wm09MOa0+n7XgPo++81aMG+Gq0Obay7WUM3blty1enbisN
			eoZiHBoNINvt0elPwcs9ln6LxWh0eDQa7KdhNpsYjY72GO20sg/nCRq6y5Yt0yu1j3ti7/1tZMr3
			HCd0B5L1vsr3ARB8j/qkIZXv0Po3CN9HbaMXvlNWL31p6atLl06KfWlKZH7GColQEIVe59+k/AbY
			K7oZHpWx6vcZ4XPXvjx/Jud9Zhk8c3ieaC98QfVeETUBe5ukjcjdRgmsw8OlUn+qekmMnEbde0UI
			m1fwvn/0d8DwI2J5Xvh6la+XvPN57buIE7wFg4xrpHHRO1pwHsdnLD4i9GVXuH4MMd+n/bcRtPt9
			Powm5SuXLe62WHAir8Pa/ZVN2WfoYw3Er9VjvX36dK3DzXRbGRyZ0KTTddt+LLu1THlrS1lnby6d
			q9Fp1D3byzoLN1eVf3XaZrDorEqPm6E8FAXXUwhft8l1x+MwO/SUw2bFql6jXfN3FeX2UA4Xdtgw
			dP/ulk2pTFWMCvgOT/kiYYXnHqjgaKTClwWwT/cOgV4+3Mv5mn/C5xyE78PZaIWvLLs4Kyv9Wk12
			7OrVr76akb824w3RFeEcInxvzskQrhAQFGdErJX+X/MXvTxv7vyXF7HkXeSlK4/jReyVv/B3+VM1
			SQUCqbRJgKJXAhYOV8BvozRcGJDvjIS9chW5e0UE+OUwHMHjN7Abh2/Jy8zmz+Sb50umGpGio/lc
			1hVuzbs4GL1LCubiHMF5/oXA/jOOOCnMuqUfg/J92n8bQRsGfEeJ8k3EsUYunGrf3a2m9Wql8w6t
			VDqdJsAjA+w97TCaLLROl5NbXFyss6nVy26dd3aX3crV/aihKI1K5+jZvH3LzmPv1NZaLS4d7dB5
			3A4Hg4/cBvaeNpqUVrdDr8u1KX/sUVIU47FrsHGlSuM2ohPaUvY7YK8y8ek2fngA5XsP+PplTQ12
			SA+Puy8GOJwDVPC9/M6+It+fdDoH4ftQNlrhGx+dlZ4+aemU1a9+//33r/5wQLg2QyQVSjDjKuPm
			H9+IWiGMWvF6SspN0dq8m6+fK1iV8sdFM19e5NW/nPJd9LIPvzyRvTTmzySQNjWx3uZGCTG8aYT7
			jeFzhAG9NoC9iN4rVzn2An3z4I7oyhW/7Gdfi2e8js/LLC7mz4TKdybvc17E5zt7bTB6l7DK9+LA
			+l++y/M8rs8z3+GqYJjf3CB8x5SNDeWbIJPfMhisLrvd5ChzMHqlg1HStFZLOdxut0ZTW1vrsLoN
			uTm6tM7CzrS0TrWS7j7vPK/s1tNptIZS41NtPZ3l5b21tQwQnHbqr6ocbmsPal+6p/a0HeO+tE6r
			utWt7Oxx3NZjBy3CXo/RaDcC2EFlO5VKuWKsdLhKuH+TDf/6ooGpWCMN+57zCd5z/r2uzg0Wvn7u
			5p+kbxC+D2GjFb6y2JrVsdk1q2u+/+GH7+F6N2NVpDBfKgy/ezcjY2W4IHzt1ZuilN+kRIlWzMnI
			WJsPTH55/sxFGAFmF78Vx+DA/T7lmykBzjaixxkukUT4SngKz5FIfUVICN2IK+Sah9c8DP3izihg
			cUDvZ+/0o6uA3mJ/5bvID70BVUaLUPeu9IMuuyIeZa7bs38rLL/xvnzrDfRND9PfFoTvmLKxonwV
			uQaD2e32mJX1VnV3N4hWZZqGsbs9dqNG46Hsdpeh+3/m5Cwv/PFHNaVnmG4ngSWto7ANJZWr01HY
			CZoCFJvNLqVSq9L0uGm3kvbYPV857B6uKPiqtpvJ7SyD4zso0rrSA7rX7jAZLXC4fhetGB3wfbiY
			7wABO0j5DhO4LwZS18/5zK44/PrlWfk32bi/yzkI34e00QrfeADuDy+9SsCL1x8y3sjIyM+XrE25
			m5JxJUMqmHP13M2bKb+5KnwjPOVmyirRzZQUbJz8Mr8Q2JKbmS/79vpdvPCNJJq3kRW+kZESTgBL
			JZEI3/A50ggu2EtAy2lecmWlL9nCPd6WV76hg8heH3wXBBb5Di7uvThA/LLxXr7tc2AVsHfG0UUu
			AowWdDs/izZGlG+8/Eo3Nnc2O0z11r76bqvDY1VSaB6PSpNKu00uhy23uOvWLZuaUepUakt/X5+h
			T6nTel6ze1S06w7jYTQ4IlDHwMuVNh0IXY2OUtoA3MBXD85ZoOCZOV8xenVnt4222npyVKkqgLsd
			9TXpb+VSxctHBXxHonwHADag1Oicr6sGcVBznTYeUPkO3jmozsjb3+pLfvs+8JU91fj6o/hxPWkC
			+my0wleOwP3he+4Kq9+sWHFzUkZGxvSMuymiGMEc0fiolIybNyPyXhdkrLopEs25m5Lye173sqtF
			L9934c4ka2TZC8jNhAUB3BiOq0guABw+R8Ci9wpB7lXvFhC3KY/Nv2rKIxvedhwcrwG8pZnZ/sqX
			zBG8t4H6XRLI34sF83jJO8+v/QbrdOZXPHuD8H0mbYwo3/j4xd1YbGQ2ucxmp81qZRiHh+RL2e0a
			SqWxOyiPtbPweI6aRoGrs4JQvZVrUGoo+2seSuO2u0waCuBba1ffyjm7dcvONAp2a3SMu9YO8DU5
			aCXj8Xg0uttWt4dRqtWd6p7OH2ns7Gy0A4DdFqtS6XItVsSPuZjvoNxmn97lFSznbX4Q5RvIXT/d
			OzDq+6X/itO892VvEL4PY6MVvkT5+tv3f1yJDuab+Xfv3n0pY0W+MCMqI0XSeEW6IjxDIIyaezPl
			LmhinIKFYGUl8Ex2w+eM9oIXL/woykjW54zgJRcUv5JIVgRz7udGVuz6WQTrcWaZyypgEgD2CxCP
			ayrOzszOmh3rhW8YdrhiE6wW+atYf/qSPlYcd0lAl3vc72nzuKDvRZ/85e5fHOY3NwjfMWVjRPmC
			9L1lsBgMZheqX9qmtDpoj9tktDOgbP/LA4TVeBzqrls0TWtSVdq+/m7MtzIodcBNSkNhS0kM4Do8
			VPmONU3FOw4Vsu5oO8hdq9FgNlssIG2VepuHsTFI38JbZdt/7FFpsLczxnzNVhC+ykRFwtjLdr63
			8j3nJ339UrNGKHn9/M0DdK9/e0nO9Xz5p7Ocg/B9BDZq4fsXjrk/cG7nHzKEQtGKuykIX6BszNq1
			gtdT8iMlsw+syhgnurJW8BvYffMmO34S3c54M3ORl72BN7jw/x5HZjYicpG6kQDdSDRO+bJ74GYO
			z1tSEgzWdJVVvQjdJtbxTIx3PoMVZ2cXZwF9Y/0TroZsJDnQoYwx3Iu8+SYMBjwp4qL/kEGOv0H4
			PpM2NpSvXC6T5RiAvmaj2WR0O5Q0wJcxmftNJrvxNZPpNZC3lIbu6bYyGhoErZVtXWVweeyOstun
			T4GwNalUHuZ4mm5NFfyd5Wz+nNZSjIpB+LqNVrPBgKMa+vv6rMxppZ5hGLV6WafaptGiXxulsdkC
			59IlyJ5uHPKxKt8XRwjfIZ7nP2XBX/oOVL4/LXuD8H04G+3wZQFMECyMEuWn3F0B9E3540sZcyQC
			kLyvS1ZIMm5eEQkyBBkpd9/If/03F2fO9BGWp+2iofDLK19JZmkmSt7SyJjIyFJCXw67hMWcBBbx
			3uY87tIEBG5qyuO4y2tfMJ69xdmN2bEzSrOyu/iv6bMBKcucpg0Qtd46XjaS65drNc/7RD7XKsKH
			X1b4BuH7TNoYUb6JMkVqPcAXOz3a3XaadjgYHWOyWDAV2QjylNJoQaY67Mzi1FSN3tLn7DMYug0u
			o9FOW0+dOkWpQOeqGV2aenu6Nu+qdleV3mr1qDwmN8N43HaTwfn/niczFv5lcJxmrEqG0avVaodK
			77bb4egms6HP6nItlicmjgq38yOK+T4C5XvPmO9lH32/HKh8vxyG7g3C96FstMJX5g9flr43r1yN
			Sbl7NwPg+5s34FYyJ18okQhSYlblS2LWrsQGHNh+8oXxHG4HCF0//zN5wAsqQG8jXiWNSN8YpC2y
			N0bCyV4+DYvFbBPGd/O0TeTa1NjUxPIY103sY03E+dwI8C3Ojs0C+etLuGJnB3pH9LKzE+YF+pT9
			jHtgnveR+b5hCzxvAcG843le0O38bNrYUL7wRyuTdWOTK7PRbcfOFxaLhWGAxA5Prcdo/y+SrYz5
			yqmpqSqtzeIE+jrr6032116znwb46nQMlhRpek6dLEzP0xZvKWSsIJaNOEBQ4zECfPVOZ7+TyGUH
			o2ZMWM/k1mg9yHaj3Wwx2JxO5VPWvQ801Wiw7B2U+jxQHT8AfAOFL191FDjUyJfizPN3zpwDxObA
			3TkB4J1Dsp2D8H1gG63w9Ve+P9xl6RsVEf46+pzv3v3Nb5DCGRlzhDGCmMiUuaL81+f8cQXsSPnN
			3d/8dhGfcLXIi+EAAUwePtfIn6k4s7i0NBMJ60dfr/+Z90TDDatum1DvwkWLHAb6ct5mzhvN3r16
			JTMbbXZ2V1ZxsVf5LvA6kOcFMJbVu145PI8l8qDSXh9+fV02IvzTroLwfTZtbCjfeBxslGMA+ppN
			Hg9IX9C8FiVQ0+5WMg7A439pNFRtLbBXm6ah3+lB9PZ1d/dZ7a/ZjadrQfkWUjT9VS1z6tQ7H3y0
			fGdheRPFePRqK6koogC+Buf589yYBQOGgymKZigVrXSbMORrtvR1O/vpUQPf4fd2Frw4WPYOLPXl
			pe+Dw/eyz9U8hPK9PCDo65W939UkX7/etjp5dU3Nte/m8NSd8+UBrtQoCN8HtlELX/+Eq+/Rfvgh
			/0qMEKQt8vc3eJPxkiBPkj8nJmWFSJSR8se81zNWrUi5m3LTR9hFixYNSH72AtiHxNblXcDf4kwQ
			vxj3LY1mPc0k3SrSF/bNjCwlmVVNBLrkyhpP3yaOv3ApzsxG+pZmdWVlF2a38mfyKt95AxSuXzER
			fzfAGx2giP2UMK9+I4LK91m2saJ842Xxqd0WVL7oBgb8uh2UVutRfwVW67bbKZWm9lStNq9YT9F6
			us+A9DX066n/ophadVevmjpO69+pvf3VqTPFx3cWFhdrtUDYHD0GdO04sLeetjiB14a++j5Ln05D
			5dJalcftVLqNxteMJjOmYzkXy56qzzl+xMp3iC4bj0n5Xh4wYYEbLTjEZIUv/ej73eo2sHa0trYp
			31279t0BP+kbhO9D2KiF718C4Hv3+7twk5+fgUnNAN+UlJtvpNxdO1UonCTJSFklurI25fKcVRkr
			MgC+d38zbuaiexmP4QOFXvgub23uKi7+z/8shlVaZmZkTExmZrQkOjKSk75sBLgUb4jkZYGr9RKY
			j/c2cTlXeZnZxQDebHQ4p7cWd7X6KV8ffQexl3iZOfDOnz9I+c73h+88v9df9PM6B+H7TNrYUb4y
			+e8MFovJbTKB1MWhQx6NSv/VO2dOna6lKCwjMptuq2maoXW0To0a9l+Yb1Wr0egorcaWRlPKdxyn
			jn11QwemydGmqlSqVI0H/dIgbe0ug9li6D7e3Wcw/MupT7ttddCU26XsNwF9Eb7A3mVPdaAR+9N6
			6Hm+AcqX3/PQyvfc4KjvoJGCAZ02CGAPHDjwLcvetvaktvZv4c71Kfle/gbh+xA2WuGbEFBqhFFf
			7LaxNlIyPYWI35QMEUjftalCqTQjvFEaKUjJWHFZmPEbgO9v7r7g73H2u33ZuzW3tZdHoqwZ6Ntc
			2FX8j+L/xDhtZmlppjQyujEG475sDlYMXLkUaKJ1c2DxM9bbzG3lNSF6M0uJ9M1K7+pqDXA7z5vn
			5a83V8q74ffAEEnR/oHigYFfvuxomL9wQfiOKRszylcuk2vrLWaz0WR0u41mk9vj8DCnvjpdW1vL
			aAClqYzLZLbe7nEwDreOtgB8DWaPze3x2NS0Vq8/rqMdNltPz21aq7mlSoXn0xqVRmN/zWinNB7K
			QzFms6G721CP8O3R5TAMRbuc/WbgMkl2tirPq5627n0U83wDlC9/86hivv6FvoOE75d+spcXvte+
			+xbhu7GdU79tcP12UsycYMz3YW20wjf+L18H0JctOpoyFVOuSElvSviqlzIyBI2R+Y1SgSTmQHjG
			zSjBirs3Acspd1/hKDuBuz13eS6/zVpmZ5ef8mUtuyu76x8Azqys6MjMmBhkriSSRIFjYiR4G1nK
			0jfHC+CcprzGpkzCXFYJ5xH2FmcVx5ai8M3q6ur6h+9MCwZHeiPYUqGL3rJd34PzuRuOuhelF+dH
			zPN/1kX/rYig8n1mbcwo3/j4xMSdBjLY3s14jEBhq9t9CtB7upbWYrKVq9/Vb3E5HEYTA7QFjio9
			dI/dY/fQuk4blUszDlvZj72dOq1Ke0WnW+xxM263yvOakVJpPFjzqwT6GvrqQTAblDodQ3s8jMlo
			97iBvWaXWXnHOQpY8EDZzgMLjIbWwkNK3weq+fVtXh7CfClX/+PA6nbW67wRLxtZCYz3v/0O2fzZ
			046wP/yP60kT0GejFr5E+X7tgy/JufpekA+yN2UFrjJuHsjPiMmLzL8mjYyZVhqZsVY6V5CCj4H2
			XcLW+y6a/3LB79/IwEysjIwVn/HCd2ZUV1cnH4mVt2ZldbW2AoK7souL/wHszcpKz4yOiY6OzEev
			c3QkcBiWGKJ+IzObGhvhkoM3wN68Rrgl9CUZ0FeasrCfZFZxemZWcVZ6cRcx/mta4HMa+wtXNmiL
			Wcv+/PUxmC09EoikkQXzIvweDaw0CirfZ9bGjPKNl8kVOSB9Eb6UBqSv3chQDo9Ho9WmFXYWNmnM
			Lper38xgs2ZKx/T0nKK0lP0243BQWpWa1tNqR3enrver2jSNiqJVtNliNZk1lN3OeFA6q1QainZY
			DGhKtYb20Br0RhPZC8LXRd/RPd3OkuxP68F7O99zii/P5KF6QI94sG9g6tVQA339+2tca2v/FJH7
			aQB8cfn22oEv40bBfzsP+eN60gT02eiFb2CLK67caGn+VDbkixnPUVcyYqRN0pibgvD8GMHNlFVR
			V/OByXdTfvObu38MQczGZKTczLj5RgrOQkr5TQbvgQ5vLezq8qZBAR2LiwG9IH7JZk16bFbWtcj8
			6FIS8gXdCxyWogAG7QtqOLMRl6ZMxC7ANxO2c/K4YHBedmlxZnF2V3FsdithL+jerv/F/34uGMRN
			b4Eu1x7S50EOtIsXpdF5eULQ2UL/gYJcxrO32VUQvs+kjSHlq5AnlhkQviaPB+t/jB7K7tGotF07
			t2/eskPv6u+3GBxKPc1QGk3t7dO1lMdtcLjhKdpUms6l1T22wpx30E1ttphdFnO/02XRaOzwzNOn
			caqChtIwVoOzr09v0+vhRQhfLPEF9JpwFENiwuiB7wPM830Q5fviuQd1QV/29zsPCPp6i42+vJYM
			9CX4RfZ+yipgon3b2lZfU8jHuvQNwneQyX49oLvkD5hy9cMPk5Z+T7KdEaeiKxkrRXl50vybQsCw
			JCNlxRVRxkvhKUT7pqxcuWqOVDpnxc2UFSsIfTNS7i4imVgvN3Z2tnbm8qcigCwG9mah/E1Pz0rP
			ik3Pyp6WHx1dKhFERkYjfkvzSlnli2vgbibAl/ibM8mdJi1eGpvQ15ydBRI6Kzsb1kheWPgzLQgQ
			riw+AZ0XCwqiwAqiCkSwcdGfzxxpCwqE2U1NApDcILGlIumcSJH31fN40YwvHOYvXBC+Y8rGjvKN
			VyQoiustgEKj0e32mDD2a6coTe7Ords+Kt+2kzH/q96WW8xOJ2Ju19JaNzzX7vHQei2tpil1p03d
			9VXtbYfpX/1m4G+/pa9fQ50+der0qdO1WoCvx0M5DGpQvVbGg+2i2caSdjN2lFbeSUtIHD0JVw8w
			z3eouO69lO+AIqThOpv9Ozvze+41VZDPdkbdy6nfT1kZDADG0G9724Kg8n1wG63wxWznrwP5exe1
			b0w+KTVKwcyqm1E3bwqEgiuCjPwr4auk4XdTrlyRZqydEklqge+uiIkSCqSiFRlr829iCw4MFRPt
			Kyzu6g1Qvv8o/oe+GEjZmrU8vQbgC5Z1LXp2fv60yKa86BjALyzS0lJJJvqfS2NKJaWA3sxM0LqZ
			ZCOTLf3NxI6SwF0kb3oWR14w/p/DUJ/S5aK8rN4tKIiOZrt3wEFEUQPVb9TFi3NjsoqbrgB6s/Ma
			sxsbZ6fnRc3zU8sX+SZXw/zmBuE7pmwMKV95fEJimQVICPQ1uk0WVplSvbu27jlavnWz2mpV67R6
			Bot0NR5aR5pnuD0aygOA7Tmuzj1uVfbcZm5b/kVwajKD/LVRHgLf25SGZgC5VqtNrVcyjJICbU3S
			oF+D54HwpZSJsoSnL8QeXcw3sM3VvWK+D2wshIcI+HrH+XJ+5zbO7ewH3zbEb9vGtr8F4fvgNlrh
			O1D58hnP+Y2TiPRFlGa8fnOVFGt7JLMlUTGClPyU16/mHbj7x4y7bD1SnvDKHIlwbsbKORKJEGG9
			IuXuZ4sW/bYrN1dd2Pwtd6aE/0Tugvz9TxKhxYhtVixI30nRM65FRzdGNpZek0RGl8ZEN0bnYw/K
			Ukkk9uRoBP7mEfAS/DYih6OLuxpJknNXVzrK3tb/1dqKmpr/mhZcjLo4yHCEglA6tZSjb2NT3pWL
			L3uVcQR5ytyVk6Y2FsMThI2lTXnZ2U2ljXlX5vkfJYKdKjjMX7ggfMeUjSHlm5CQIE+rNyAM0fds
			YRxGymOn1du3bK3IfHdXd3da7o+dNiUOK9KAIobHGHgYFG3tqVPvqBmasSlP1dZaLf2IXpfRbHKZ
			NFoNkFmtKtZoPQzQ12G1OjweRgevfQ3RTkp8Teb+O7RWLk8Ya9nOg2O5w7YH8jf7GlwNJXx9pUY+
			6Xugpo3lLqpfL3w3tn3aBvwNxnwfwkYrfEH5fj1Q+iKAX4phlS/mNAOBv8y7IhAIJZJ80Kb/15yU
			jCtRc3DuL7L37k3BHOG08Ig5KSsENzOEc1dh/8k/rlgUIu3KLewtrGjjz1Sc25X2n/o0FsBp/4n8
			/c+urPTY6GzQvrMzo6Ojp0XGRM+Ojs6cNq1UEl3KWSTAN7O0tAm3CX0zAeLZOZgtDRcMH2McGXnu
			a7JxMQCYBVEFBSJY5s5d+eKXjVyxEiZyofj1V8Zzhecmza7JacKG0vB4XnYmkL9RwqI7qiDKK4CD
			8H0mbQwp34QEWeJijPqazQZkME3ZKY3JrTx+dOuehh1bOtPSjhfmgoDVaGmdxgay104xmMdM1aJv
			2aHWa+jbjA3ga3IDmzUes8lRS2uoU5TqCsCaAe46PJQNbyiP247NNzxuE9HITmXuYoX86bZ1Zn9a
			D658RwjfIW0Aky97VwNhzSddDZXq7K98v/zuOttjw9/aNrYDfD8NwvdhbLTCV/brrwG+X/sPNmKl
			b+lLGXfvfo/wxdBu+FVBhFQkFEojYyJXxESmhM8RXcGcK7S5kpiouasO5Ge8niF4PVII+MUBwDdf
			adKrCzsLm5v5UxWnpeUCeHP/0dWVi6HfZrg0Nxe1ZmWWzp59bVppaf5sybTo2fnR0ZEA4tJppRx/
			2aSrzKbS72Abx/YWZxU3FmdmdqHfuZXI6a7liGA/+Aai9+IfUPfOnSsUXo4mqdKsgYqOmuejbxQ8
			41z+9FfTozP5Ph6C0mx4J4ICAm9uAlIQvs+sjSnlq1Cwtb6GgwdJ3rMb4avO2bFr8+Ytt5q0nT3L
			snUMSF8dGQVoNJKZvXQv1iNhThV126b+MU2rU6VeVcEzTPba0x6NjqYpeIgU8xosHkptsFpMDnaS
			oN1uhtO4gL1auSL+6Yd8R5Xy9aF3sPYdSvoOpXxJwrOPuv6bQfg+lI1W+GKdb4D0/R5bPAN+JZH5
			KXe/R/yi/M0QCKIiroIcjAwXRGbEZAgk0isxbAvKu3OjokTh0vwVGVEZN9eulYYLRTfRYor1vb3l
			nZ3eNKjiNFIP9J/6f/QieZsrmitOLG8ravs2C7szX0Pxmz87f8a1GaCAEcGzAb8AYgwBA3kbm6K/
			iwbpS+YHFmc3ZjUBwItbs4oLu5oBvqSCmP/9DPUXvgW4iKLmFszFrDG+LTShr7SpUfAHXvginV8U
			SvInTclsxNomYV6TAJ4SHZ2dJUF0w9XrzI4a5v/9QfiOKRtLyjdeLpPhWF9LPRjmXRntHqNbqcnp
			/HHXLa02zWZd1qnTM5RGlapCx7G91qFGjUvV2j20VvV3jVqtprVaXZpKowbJe/r0qV59mk7noVUa
			TKty9dVbsHO01Ww2ejxG+2uvGU0Wyx2XU6/LTVQo4p9+yPdhsp0fhfIdCr9D3g+YrHA/5fvll5Pa
			2oagL2y1/TYI3we3UQvfX4Pu5elLtO9dtsVzzOwM7LHx/UuTZmSA/I2MEEZdjboqaoyUCCalZMQI
			hVcib2ZkgDq++/urV6MEwpurVgjXZohE0oy1K19fMedmfldXb3lXYa+v6SMb8gUCNze3VLS1VDS3
			JVdUVLckt6VnFWPu1LVpTY3TZs/OBxU8m9B32rTSaSA8QQE3loIYzUQ1nJ0NT87MIilXXa1dRdnZ
			XcVZXa2Fra3LK7zK9zOekQUFf0DRWjB3UmlTnmBKYx4/lYEdlERMEIVMjbqIbmnhi+EH8oua2JLi
			vCsk0N1UWjp7+hzh3LlwnAIMJkcF4fuM2lhSvjIQv/LUgwaLob4exxsBIO2vmRw0rT5+KyfVdpBR
			23pz9ErQuH9PJdqXohmrgYJtja0QCKvrVesLNSqQvhSjSVXdvt3Ve1ufBrSm3CZzv8GhtPUBfN12
			h8FEUp1NZrOl3+W4o1OmJsjl8aMABQ+R7fx4lO8Qe++Z6zyk8p3zZY2/4G1rb/uUvQ3C96Fs9MKX
			oPcb/z4bpMfzD3mRL72EPTamTMHWGW/kCUVXr16JEEmlBwTTMzLyV0WtyvhNChmwcFUglQhWhd8U
			hq9YJRII3pgrvCk80FXYtaO5U99Z4V/nq0fp29xc0dZWnZzUdqK6ohoAvLw4HfEL9L2W2Rg9Ddk7
			+1rk7GsYBEbti/RFXpZiWDg9vTirNAtznbuAvdk1sQDimq5WYHBR9nL+TKFcghUX7Z0799zaqaVY
			LczmWvFRX7T/CbcCEXm2COErXRWDdcVIX+EfcMKDKCpv9vSp0eFCIaFvVFD5Prs2lpSvDFOuEtNw
			ri9oVLvJ5EbfMGWzddv0Kq26W6/s1KepHQDfxVi2S9ldVoPFzGDpUZoWaKv7EQSv6u+LNRRTq1ep
			es/kaLty9Vab2m3EBGgPxfS5QEvbPVYzDgl2W3CEoUlJ07pEOO8oEL6PoLfzQyrfge2b7+1vHpzu
			/OUQyncOSbpq89O9bVybq7b2z4LwfXAbrfCV/fprwC+w14tf9Dmj4zlGkj9l7YwpS6dkTFqakpLR
			JCXwvRIlkebPyQfNG7N27U0S9k25GiGUhEsEUoFw7QqRSBiD7TgKC3t74dK7w9d3Cot8MS2qua3i
			xKykpLa2itaKExWzZrVlZWbVZJEJCdmZjbNnAHqvgeidfW327GnR2YDf7NmzS4GGjaXXirNjs7PS
			l5c2wrOzWrFFVnZWVmZ2Vldx6/KirHT+TAsQurzsnQtMPRcePiMZG1T6t4nGoC8nf/M4SM8VhMdI
			2NZaTewUh7wrUVdKY6dOk0hR+4pEIJP/EFUQhO8zaWNI+RJLVMhvGVD5mlxY72u0Gy0ug5VWa5ty
			1bTSlptrQ1GL7SI1lNXS5+y3qj0AX62O1tDqH9W3QRVrMAb8VW9O1zsXqjp1OoahGDNObAD4MqS0
			1+02mcxGu6neYDC7lHo6N1H+9HOtiD1Eb+dz58753dyHtsNVvvdgs99gwaFmKwxUvpjyvDqpjevr
			7FsDfIPK9yFstMKXi/l+g0lXPvlLJgu+FDl16uxJU1H5Ll06fZIoRhR19YoobxWQV5o/JSM/P2Mt
			OqTv3r0slYSHx+SLVgJ+gU8C4coV2b2dvV2dhb3NXb1+8O3q6m3tba46kdTWUtFWXdf2bVtzVUVb
			RUVXcVZ6VnZ2I4jfzOhr167NvjYjenb0tBnXrs0AAs9GDJfmXSF0Btimt5ZmZWWj7i3C/pI4VmF5
			a1F6a28vf6YJSF6kKSFqwcq5K1denpM/PTOvKTMnx6d6ef7ivf+PeJ1XCiSSpiYBsLeRuKhF8PXm
			XYmYHjsjWiIQwhdH2nNEFYiC8H0WbQwpX2IyhWxxWT2IX/MdFyZJ2UGfmhyMR5uqtjFqGyw0dorE
			oQk2Z7/zvLNPRanIfN40vdpG61SpianA3lM3TnXt2LJ9x9FbOkqXqvE4zG7aw3hIS0lkusXsNqLX
			uU+ppPWpitFCgYdQvt5y3nvA98WA+QoPwl2ftzmgt7M/gYeI+YL2jUn2hXrb2rwIDtb5PoSNUvjK
			ZDUgfIG9uHhjv9x8BQDv0qUvpby0dEoK0DdfILkCJhBGzgmPkc4hbZzzbwoy7qZk5K9aJYwKF8aI
			wtdKRRFCqeBAYVevGrOtmnsL1fy5WkloFqwCgJvUtrwiqaWioiId7rR2ZSJ8SzHzKjsamJsNBI6O
			jkYNDCjOBgZHl2ZfI+2ga6KRwMXLlxfnZNdkF2cXlWanty5vbu7tPemF72cEvQUkTQoW0UrhynPh
			B6bMyGrCKuGcxsYAAP9PNvFZOFcoFISH424BycUirucroit/uCKKnTQ1UipE+oIhfof5CxeE75iy
			saZ8FTLZZO1Bg8FiuuNxgzEOK9KS0Wp7bDabWm3TkykLGpV2me6Os7/f2Qe8xawrrUprsyk1qsV/
			T2VO9/T29h7asjO3p+xopw7zoBnG7XEwOsZkseAYI6PBTKzPqafvaOWKp99YkrWHUr7+Anig0n20
			yte76dW85+6pfHHru2Qeum1+G0H4PoSNUvjGx6++/vU3X//A0jcw8PvDD1NeemkpWMqkjCkZUyZJ
			MFp6JU8gkEhjJI35a9H3fBMh/Pobb+THRAoihIKoFStFEeFSULhgnaB7O9VqJX+m1tZecinsam1u
			aatYXlFxPel6UlFzUXJ1a1cOTgXMupaFhM0HxYvYnR19bcaMqVOngxK+hrr4H11ZrSh7s7GhRnFm
			TldhVy6o6cLcQnRyN9+4wZ9pAqEuayv/AMJX+KJgztqp15cS6uZkFufwowrz/JzQ/59QIMi7wjqd
			GzlNjJ5nQZ5IWjopUgK6nhO/QeX7bNqYU76yeHlibr3FYnbZLW6GNhgY7ENVq77Vefz4MnUP4BWH
			JGg0+vPLnH39fX195/VwD4GstVrMdOpiFVV7+navurP8cKFWd2vnIb3LraF0gF6Gpuxmyx3MuQLt
			Cxi2WPpyaaUuUZaoGGVu5+ErX+EA5fuij66DZy34tb16CO7yqc7nBujeL4dUvt4mz21ew8G+QeX7
			cDZq4fvrX/9w/TpSF/3O3/BlR+y0he+XvjQFxS/cLM2Ycq0U85Wu5EkkjdJIaWNKfnjGtZv5+fkx
			K4DCkRkx4W8IrqwKF0VJu3qbkbudne1q0L+88k1o5ejbDFZRsaaqoqKlLqkahO+aNek1rZlZWdda
			sxG/sVmod7H6aGrptWlE+wKSM0mMF+CbjQnOXcVqdZc6V63HC6xy1b03bpzhziQLQfR6+btyrnAl
			Kl9B6er0TC7IC+jOzOMkcBMhLZlg+P/lRSOIkbvYypJNeiYpz5LZpXMEAk78RgXh+0zaWFO+8FuY
			KJffAjDeMRndDpeFcbtfwxyp35WXL1vWw9BaLaWhailaeee883x/v8HpdHsoMCAywJfx0KCCGUqn
			1f3ucHlTzq3PD1rMJgYQq9fZHIzHaDHZPXYyyAjp26e/o09MkMtGQXMrYg+tfP2G+QYqX9/OR6J8
			uWyrcz+tfL30bRtI378H4fvgNmrh++/ffP3N6q+/ZsWv1/fMjzoC3TsJ0IsMnjR90jWJYFqeoPGA
			RDptjlCaMUWYnxEzNQb0LwA45uYbq1ZErV0pbMruzO0E2dt5oxlWHZ07+DO1dhUT/Da3tLc1t1RU
			VxS1nQDwrlm+pqK5tWh5dlb6tSygb/q1WFhml2YCg6NLZ5eWIn6zSrOyvstqbf1fvV2t/4CD9PZ2
			9aK8vgHWc+NGL7vJnymEZS6I3hfnvrgS0Cs8F75q6axo+OchM70C6ZqTk8O2iubUb04Tr4WFiGKw
			0mxsKo1NKEl+dF5mqSRcyuL3D6IgfJ9JG2vKl1hCYrcBu2y43War22HHpGer2tYJupcmPZodDG1z
			OkH4Ovv6nE4HgzFglY5y9JsZyqOnbCCF01Rp5cfKDy3fZcVGzx6GYhidx2R8zW4E9lowy9ltsfb3
			KfWLR0OJEW8P0OGKx+iLPHvP+QV+fcr3nL/wfWiHs5/LeUDG1dDKl3R59jmdvyX0DWY7P4SNVvjK
			/v2bb775yzfXr5N8q2+8SVf8pMHvJ61eunT1JBa/M6bmr8ovjcmPmR0dmT9HGpkx42ZGRn7MzQzQ
			vxIMAofHrGpsbu5Voxe4s7nX1lleXt7OnQmUb3Mnq34rWs+i47moBQTwcsBv0fLW9Jqa7GzQtunp
			166lT0qfMmkSEPfataYredHX8lH5YmlRa9aZjo7mGx1nziB8UeuWnzlzpvzGjf8403zmxhle+cZ/
			BuCdO/dF5K8Q473nwsNXxSRtnJWEIwqBvE0cbnMyi4kUzgMWc5K4MS+PuJ3hmUBf7C6J7TZEwN/G
			zNJISSPIfuTvMH/hgvAdUzbWlC8xeWJqWb3B0OfEBlRGk9nt8RgdVjA3rdUxbsbktvYR7sKq30Xr
			dCB8UzU0ZbVSqal0j5Wi1LROk3t8+9mGYo/bYrbbPYyd0TgtZhLwNQN7waxKs0u5+G9P+4v1twfr
			cOU/RCEg5co/5utF7rDpO9Sz/KYaDU3eIZTvHLKa5BW933L0DbqdH8JGK3zjf/HNF0Dftr98/c03
			KH/J5WvvXF8Uv9MnvYr+5+hJk6bMXvpSdPSMqTNw6O7aVVJBTMb0jBX5GUDfGGk+jhNcm9XcW1Gs
			7sQ6I7UN475nWvgzYVerZrJqxttZbckta1j4Nq9JByqnZxUDeyeBAI6dMmnKpPRrU69dywbhO/u7
			7K6srqx/lGe19nY0f9p+5mQ7IBjY+2P5mePlx4/f6OgA1Qvw9SlfhO9KzLN6ceWLL14OD5+zKib/
			1VmzNiUhTxG/jTlsPRHwNzsb9uQQ/LKh4EZiTaU4QbixNJPwFwCcJ2hiq46x6HiYfwlB+I4pG5PK
			V66QAX0tToMZ641eM6GgtXs8FGVnAL4mxu2wnu/rAzjDwlCAXgarjVQqtV6nUWnUOPBX52GYtByt
			VgdSGdjtoNwGg9nsYkuNsIlWv9nluONSyUZLrhWxB+ntPFj5+uDrl97s34fyAXWvf8NJ/2Bv+E8r
			3zlfzqlJ5oO9yN7/+DYI34exUQvff0f4fvMXLuvKl3bl8z1/P33p0qWxr05fPTV26exJ16ZOn56x
			ND8mslQoEUQ3hqe8hHlX+fkx+Sn54SlZhc3NhYW9O9Sd6t6O3htw7W3jz1RUTuDb3NbRXNHcXNF6
			pKUdlO+a5qI1ayoq2jANGsfztoL2TZ90LX1K7DUMAJdi9BXh2/W/Wpu7ess7Oto/ONb+4acge38E
			3XscdW8zOp/PnPG6nWUhKHhfFAJ5QfVeDl91ICY/f9Lq60mbNm6cER2dnl2aWUqgCtoXEJyZnZ7d
			yHufiQAGGgNisZ00PKsU5TLB7x+E2aXTpmUhvof5zQ3Cd0zZmFS+CnlCovYgep7N2GXSbjJ7aj20
			BwBMaSmHldbogboWwK+zT0npdVqd3kanAX+7aFqjpW7TlEYFT2N0qis6mlEyqHuxs7PL7XaTHs8Y
			UVa6lHf0mr+NroHuj1n5joy+Lw4K8/J3Lw90O5+7fN+Y7xxuuC9LXqJ+wYLwfQgbtfD9xTes/QD4
			/YbLeh7Y7Pml2PSlU6csnTp9ypRJS2dMzZ8O4jcjXyKJjIyUSKZnpGTczcjIx8LfOV0dhWp1V2Fz
			Z5e6t7e8vLBF2VzBn6m9ZQdq3ppm7OpcAdeWipaqIhL0Xb4mObmoNQvw25qV3gr0nQIye0o65jg3
			lv5nVte1f/wDByc0t3aUf7Dvw/ZPS/b13igvLz/e0Xu8+caZXsLeMz7lOw70LlwELwrOScPnHIiJ
			yZ8+Zen1TaB8N218dTaI6nQcJpyVXVoMcAXJ2xidnp7ZmIdxX6J9gcuNqIdR++JAwywWv4I8Ualg
			2uwZszOD8H0mbUwqX2x0lZh3sN5iMRH6Gk0uHEFkfM1N6WiHQ6tb1tdtQLdzn1Kjo0DeditzaYrS
			dOr1aWl6WgsS+TUjwPeqjnErlYzJqIGDmNx2xmh3mBG9ZqVDeYdWahVwnqf9xfrbA/V2Hqh8zz0W
			5evzOXuV74D2kl/eL+YL/L3GMpcN+IL0HRF8ZU/IRvbjetIE9Nnohe8XH7P0/fr6r3/N1xx988MP
			gXMGl06ZDeh9adLUGVOm5Ofnz5i0dNKk2TGNkaUSiTRjUgboXklGTEZ+V6Fe3aW+AcoX2dtx61Cv
			utw71WhdW3tLVUVHa0sRIPjbljYs961YvqYC6VvUXNRWsxrHIxSB9M1qxcjvtSnXsrKzvyOtJLO7
			Wm/0lrfeuNHR8Wll+6eVHTfKb4DuvYHcZdl77EyHN+Y785wAwSu4fDn8y1UxMVOnTpq0+tVZSZuS
			rl+ftWnT9aVLV69eWgNWlJ6dhXlVwF+Qv1ls4RHJvWpsyiptxLGCiF/Q3pnZmWzeVZ5Ekhnd+MzC
			V4wrWbw8XgZbROjI4Z6c7IZb2CETc39zcnxchv39ZTLYj7tlcjH7J4k74HGxTM6/LN57BPbC3hOT
			8QBP+4v22phUvsQSrxw0kMwoI9LX7DbZYcvDMA6GTrOh0/l8n0Wp0VA4SuFH+hbDUHR5r9pmc7hB
			93qMRnjaFS3jNnmwoZXJaDe68Th4RIvZ7dDTtFIlH+GH7WO3kWY7ozrlfc3nBpI1QPk+OHYv+7ub
			L/sV+A7VXZK9GRK/Xx6o+ZbIXjbmW/Pt3xKHC19Z6KInZQrFCAgchO9g+8UX33D0/QEAzKtfX7MN
			Xv9Oqbl2benSa5NWH7m+9Nq00vzZMVOvTZUAiCNjbuavmJEfCcI3u7BTndtVWNilxhqjlnJ1Z666
			2Rvz/TSJzFNob6uqaMMWVy1tLS1tGPBdDvhta625DuK3ubUmvSaLE6bFmY3FxV3FxSB7szqaz3T0
			grrt6DjT3vHpvpPl6Gpu7j1zrLy3F/ALDwTA99xlweVwEuw9kD990pSlS19NmpWU9JdZszZt3AgE
			vr4aCLx0dc3q5Jqa9PRslMA5maXZ6Zms85nEgjOx4AglcCNo38ZSeAqpCM6TSEsbG4f5zR1z8EVm
			EvhiD0FkK3JU7vcQkpP8vcnkMpa95P9sAmI5e4c9AD6VZbbM97EN8JURZHP34r2HGxU2JpUva4la
			zLpC/AI7zTjiyG63ux2MmqJy+wwGp9OipGicKqhN06s71QxNl+XqbWrGgS2v7HY9pUmlTSbG4/Fg
			o0oM9uJQQRTTTmUfTd8B3Tta4TvcOl+v0h0kd8+xWndAoe8ISoz82kgOHLLg6+o8KOHqS/5mcNR3
			DkhfInu5dc2I4RvCr0O8rAx5xNdF8iB87/EbN8zvya8x5vsFq335bhtfY+6Vn/T9ns1/fmlGdvSk
			kpL9k6Zemx2Nk/6iSyWl+TEHZhyYBtIXlq7c1q5C0LxqpfqG/tYhW+clfW+HF74t7S3tSe1tbQ1t
			HQhh9D2fwCLfijXLl69pA/pWtxWlt9bUfIsCOOtaTXpTJo7uLf5H9j+6Wns72ps7zjR3XOroaD/5
			aeUnZzDBClXvJyCCO94503HsZEeH9+d8OfwcLJfD58xZGzN90tLVr76a9JdNm2aB+P3LJoAv4Hd1
			UXJN7PQpq5OTi4pWgwLOzs7MKS7Ozsq8ksd23cjJQZczGSSM430bcZYw2/NZCKtntdRIfqII1kUn
			5OK66rrkdDFSNX3dm8lhgMnZR9YlR4BQPZFO9GzNifiJ1TUyaXWUOF524gRgWFD3ZlIkPJQgj6g7
			AUtyTfV4+B6I65IldWix8uRqQHFEXek0eLS6rk4giz3yZrVgNMynIzZ2la9ckZCKjSYNbOTXhI0x
			0HvM6PV62moxGAxuUkFE67Rqm14HUpY+rgcM0xQ2vPLQlIPxWM0O2u0CwWxk2Qu612W2WGmd8g7o
			3tHyM/LZiOt8z/EJVkN0z7hfm6ufcDB70RvQyZlPcz43oKmkP3u/5L3Og5Xvl9/V8G5nsh4hfEP8
			gfuYLCSofO/5GzfM78lfvv7ii2/YhTOWu/5eZy7z+ftXgVGVle9lpWdfi56RnTUtujizFDAMII6J
			lGSWfteV2wGiV61XY6JzYYf6RktX+Rqv27mtrT2pbVN7S1vb2ZYTLRXfVqD0xWoj9DxXnGhuba2Y
			hXlXRTXpy0EAt2ZlFX+Xmd1VnN2MEd2OY+0nz3R8cIzcvPtpx42OQ+XA3pMdZ8o7PgHZ23Gj1Qvf
			8aB5UfYCe9/InzJl9avXkzZt2rRxU9JfkjYlbbr+6vVZs5auRu7W1MTWFCXXJcMmTmsoLs5hc59J
			v+ccJC9o3qbSzDysPSrNRPyyYwiH+c0dc/CN37cOVkdKxPEl+9ZvKNknlI3fUFLy5nuVYRPh7luV
			+6Lj5SX7xsNzRPsq48UlJ+SRG0pC42WV+2TxNSWVb5asX4ce56iSDRvWr18ngqPJxaUlkuj1b23Y
			sKEm/s0NyfFwxKmxG97at++t9YIjJW8egVeMFvE7hpWvPEGWuvOgEztRmc3YiRkvJrPJwVCUx2Gw
			OhwOtwOkLa21OUAPE/jqKDvjwapfimawnQZD3cEZCoDe11jdazFb+vQ0o1SmykcxfEegfFmHsxex
			nCP6nF9hr38+1oj0rt8evrb33KBkK7bAyC/digv6Ds53JsW+PHnhZvgxX5/bOWQge0Mepf4NKt97
			27DrfH9A8H78MU9eciEJWAEA/p5MGrz+fdJ7773XBZTCEYA4U5ezrOzs6Oyuwt7m3i51r5pcCjtz
			y9s71Z253JkS2je1tG9sB+C2t3W0t7cDhrG385oKYs0t7cjd5OTrFZgTXdRa05rV1NSY3ZrdegPg
			29F+7BI6ljs+/KT9k0+Pdezq6Dhz5uSNcpLlfIYtNfK5ned/Gf4lupxXHXgjZunSV6+TPOdNG4HA
			15OSiABOSk6vqUkuSq4oAqupKQIZllyUjm034IvB8l8s/iVtoEnyVWNeHld3hAVITc9wtjMHX3n8
			hiPx8YJ9dfFvbZDEx4dEy5LemiqLD92wL0QOgIXnrN+wL168AeC7fsOb8vjKknjphnUggSPDQuGX
			KqqkBiTuxPj1JQvj498qAUJLFqLb+s0NJVNl4/BI8SVvwUEq18nCZAtHzef62FW+CQkKhfxvhdhp
			0kLMgCIYQWxlGA/jcZjcDqXD6NDodDaKdiB8y2h8wO7x4NAjBh53uxngtt3tAd1rNFsMZku/06rV
			ud13EicrEkdVlRGxEStfwYteBzOhrz82B8jg4Svfy36x3QBfM5G7A4f4Xubo+2VAoe9Qyhejvn42
			IviykB23aBxshfCk9JI3GPN97DbsmO9Lv/4Cc64+/sInfb/5mjieOfx+T4y7ub5+99kuAFRaZnZx
			TnF2cRboU7hXnJ2eHduV27W8qzdXrychX31nbq+6U9/Lwzd+B8Z4G9qq21qaQf3WEdXbgrIXAbym
			oq1tR3NzTdv1ooqarublRVk1rZnZrelZ6a1nWnsPXToGAvfSsU8vffrh3g8++LTj5JkbN06S4t6O
			Mzea4doBu07yZ5o/B8C7atXatW/E5IPqTcJQLyrfTUmw/RdYb9x0fVZsFojeoiLAb0VVRXrN8gqQ
			wEXpIHxzc4szsftGHsl9BuqWRmOpL3FBN0aXZjdlNmYOkxdjFr5iecmb8RMW7nsrpGQd/nnJ5fs2
			4MOR62Pl+9bvk8iiN7zFKd/1SeuTZfv2xddtEGE6VnwYUb7J0ZESEL3rY+NFG9LF0W9OLY2OjI9/
			ExSxMGr9VPj2layPlwGz64gT4X8f5ZuQEC+TJcTLExMT0DBZTc7ePuybl8FRtN0mEzLXYKg/CAvx
			QjsYhqHcRjfjsDiUGh1dqEWvs4f5isJOkyrKo1FpMOfKbmfcJlJfhPVKKHtdTp32jttEJT6CaK9M
			pgDDEH8CSZSFb4P8IXn+IHW+foDlgr9DxXx/Gr/+ucyBu/1Trvj2Gv7YHZTtPBi/pNjoy/+R7w/f
			4baXhJ/UBE70hsbFLRSHhYkXLIA7MwcK4Ie8JVdg7/CdVkH4Dv5h/frrb/zM1+GKg+33L+FwhSmT
			pubHxESCxYDyLc0mvSYiSw/EHFi7du2q8MvhQoFAMCdcEh2NGjg7J6e4q6uwq7mroqs3Ioc/046W
			9vaWTZvaWtqqALxtKIGXt7WsKd+xZkdFRdXylrbmitbW9Lbk60VFzcuzWluXZxWl4/jfMx3N5R3H
			OtpLPv2g5MN9YJ9+eqmj43jHjTO9P4LcBRW9r6Oj45MOn/K9uBbAe+B10L0rJgF4N4HU3YjsBe6C
			7sW7cC3KAvGbjsq3aPnyNVUNFRVFs2uqk1sq0pty0rqys9Kz0MlMOlCWZsdyqc9NGPvNbHrm4SuP
			L1knkazbMDVqQ/JC3D+xBB+QC9fXyEvqkjbISooQvhtOxEdukK5bPw3QDMSWxcvXv8m6nfdVluwb
			J5bv3hd/ZN9CcfT6kg2VlQDffQsr943fMGMiga9cPG5d5VuVyaOFvU9C+SYkcNCVc1uYTy7DPQ/7
			5jGV7W+pPW5krwXge7C7u9tpsLjcSmAsYycxXFC3NrVOawPhy3RTGsqOQpfCzGajHWO/RlLba8YK
			I3O/x6HUKU0OVYLiEcA3MRGT7eBICYTCRDI9ZOXqA9T5+rmWz50L8Cy/OCDVapgJV5cDLzyX/R3P
			Q3WU5LHrH/cd5Hf+H5O+9YV9h6t8OfgCGcVsdqMcvtlxn82c6U/NR0FgonyD8L3Hb9wwvyc4TsEn
			efmNr7lqXx+JX73+6kura/bv3//e/sq3yOy/7O9KS7/7DjCcDSSGm+jsrq5OjPmC2UD7Nqs7y3vV
			Xd55vhWbUPq272hP2tS+cRPOqzzR3JbUhuK3oaqqoqitrb25ubi4ubVmVnJrVXJRTev/+kdzVnFh
			cwcmWX2y71j7vk/+9OGH+yr37tt3sqPjxvGTZzo+ObkP4NwO9zr86nwvHlj7+huRb0SuYOGLgV4C
			X7CkWUmzrsN1VnV1Vtbymprk9CLQ3Sx/z7YU1RTFptdUV0vymopLs7Jq0jOx60ZmaWN6U2YeaX2V
			nYktOp7dbOd9b8XL49eVxMtLSkrWbyiC2/Xsn9e+ffgPx9QN0fJ968aXVJYsXI9u5yT0KMvWl8Cd
			5PVSEDYbNoQQ+Nawh6tZH15SLRaXbhCQ7Om3SsTSkrc2zAiTE/jikSe8tV40WgKKT0T5gsk55qIC
			RCFIYPSwbx4PNlmxOJd4nBG+t3am0XaL2WRlPB77f5nMJpPRYTRZHTb1bYailTYksslo9xjNZhPI
			Xo+HsoO5SKgXXua6Q9Mul3IxeYuP4rvLfrms2kf04jch/iEO/RAdrviaoyHHGQ1H+Q6UvoG1RT7l
			e/kewtdL33snPH/55XfeWt9vv/3tyOA7bhFgd3yoWB4qly9QyOL8he8jdDuPpNg3CN/B9vXX33wM
			yxeB+tc738hvyCAAuLKy8j1YKveR4X9gpdEk4QrbLkZPy+4qbC7EOUZq9W0c59vbWd5p6yzkz9Te
			vnFje8sHAF1AcPvG9vZ17e2tmALdUlGF3ueqFlC/5djpqg3o25aO2jcbJGhWc/mOQ8f2lXyyv7Lj
			2Af7AL97P/ng5Jny4+90XPrkk5MY+73xHyePdXh7OydcPPDGgZg3yDIliQhdgt6Nm2bBJSkJcJxU
			V5GUXLQ8fflyVvquKVqDd9as2VG1vAioXJXelJeD8rcmm8wALm3MQvqSvhuZ8N/GML+5Yw++b5VE
			TggveROU6Yl4UuSbvKFuXEjkkfjZ69+MCIkuKZHJS47E12wolb+JyvcIwFcaP6GyZEN8SMk+aUjE
			+vXxLHxDQiaEyOMn7CspiRLLo9dLQkJCxsW/tS8+PnbD+qlwXIRv/DrRxInJG4Y7puKx2+NXvgmJ
			CfKFCsVn876rWfrxn/608fp/iyn4TJ4YF/co8ItkS5RrO+sBv4b6+t/p9IwRRxIhdo2Y/ey2M26L
			Tdep1+loB3ahNJowvcpEEqNNbjepLzIYzP1ml9t0B/taaeXxikdQiE2oK09MXJx6JS8nrbi4uDAr
			MwK4gPbAHvcH63A1cGpgIG8HKt8X74XeAAoH1PZeHtLn7Kd7AzQvS90helxh1NfXaQPgO7yfghe+
			C+WhkihhlEgoEgB9x4XgPjBC4XHcnQe79R1ichC+9/iNG+b3BNtLfswXG3EtNljvc2Cnje+vv/rq
			9fcqd7+H9H0vNmvqjNnZ0xC50dHXoqNnT4OtaQDf3kI24aq3F+B7o6PT1tzJn+nNN98E+G7c2AKq
			d9PGjZ+C+t3Y0tCy5kRSe1JLEuuJLmrDvs+tybPaqpuba4rS03GgQnP5oUsnT3a0f3qso/LDTz75
			dN/uvZdulO84Vn7o2AdnSKbVjY5jJ8t9gxUuvrGCY+8b0zdinBd4uwm9zpvQ74w5V5tOVCQDc9Mr
			qpenp9cULS+qAPIuT88qTC9cs6Z8TcXyrOXLS0H+ZqUXVadjA+imzMY8MgaptLG0tDHzme3tHLFh
			w74NJaBeS9ZhEW480rdkQ8m60PiaErTx8fJ9R+TyaXICX5LtLJXLhSUl8TIpvLBkH5YqEbczHAfg
			fWLDOvj7jH5rw759+47Ev7lPhgecupC4ncUT91XCK6qf9tfstcevfBPk8Z8duP7P9va2b0mOBeY6
			VlZeaFwsfxS+XeLO/ltiThlqX0O3nnYZ2aYbgF8gLchbs9WqL84FKjOM2/4aKQbGsiK32+6Gp2F9
			kcHpdDldSscdWunSo+yVD7vI5d6G8F2syilOA9Pn6pft3Pn5Rx8debMuMjRe/NDwHVGHq4FdNAbU
			9A5UvvdWvwGuZv9SI+84hcE9rQY12bjsa3J1eaDwJdKXt5oRKd+ZsCjEMoFUGi2IlgjjFLLxPvLy
			qwe99a6Dyvfev3HD/J7885svvvDpXX/hS+jLO56vv7r6pdXXWfLCJX36taxoVu9GT5uaP3t2fnR+
			/owsVvn29uJIs84dnXCx+TpctbRUtazb+E/EbktVRcuaSy0NFS3VFQ0V7aCDAYsgiJs3tVU0V1Q1
			N1dcb7v+bVFz+nKkb2/5IUBv+7F3d528VLnv0/c+/eTGmebyG+W7zhwCudtxEtF748zJDj7hShZF
			4AuXAzGvYsh3FkI3iVsnndhEcJxcszyrpqgGXc6I4eUgvavWLC/Myios7LxVvmZNYeHy7MamvMai
			5OT0xqbGrLzM7Mys7MbS6MzG7KxnNuYbHy8oFcBHeJggir0rl4dESsaRTUlkBH6OCkWYNhQfJYwX
			C6NkIcIJ8By4I5PLhKVS9gcQKiSTj2EzRBgCHwjj8b4wKl4kEstlcuE4eIVIhN/DiEjJ+Kf9Bfvs
			cSlf4mSVJ8rkirjIj9vb39v36uqPSYEf/O3N2vhx5e5t2zasVShABibC8hBCk3iyFfLUwm7MeAaM
			msg0Xqz9BXMZ3SazQ6PRA3tpxmjHVhy0/TXYMBnJ48BeRC+toxG9SpVcoXi4eDyyG3uYJSaq0gh4
			8aq/9fnnO3de+ODNI++ue/OEBIOSCtYHPcKf1gMoXx6tQ4V6/YQu3+/q3DCSnv0Ljvz90EPlOvMJ
			zl/6ZzxfDmwyOccPwdeI8v2P1m+//SxxmMpXFj8BSTlOLJOPjxgfMS4iYkKcTB4xbhGHTXZhLw90
			611mInzZ2MGwflxPmoA+G7Xw/QXf4GpA3hXbY/IbtswIVO9qMIAvy973pkyafg2zrqJLp82eMWnG
			9NlTo6fOACB3FvYW4nDd3p7ezo7ynvLO3h3e6tuGijUVVRXr2hsqqtY0rFmOrKuoaKloWFPd0r6p
			HYPALc3Nm6ra2prhtjn52+rmiubl6c1dra3NIHGPHWvfdeiDdz/Zt2/vJx0d5R0dl87s2nHsJE4S
			PNZx5uSZ9pOfeJVvQQyrfA+sOPBq0qa/JM0iId/r11H0Xkcv9MZNSSdqltekZ4OwLaopqqgoqiha
			Azc74LJm+fKurtxC+MfhVnlnYXFjXmN2EWZBA4hLsQllKbqdn2H4glzF1pJitj1VPNvHinsAO1/J
			vA+QTli4JZOL5ey2txkW2+gKH4znt9jGktzB+EQNsWzUtNh4fMpXxiaMJ45L/7a1bX/7t+2VwF78
			l/dPX6z+7tpf9u9+f/f+L76YEifnOoA9lMkUisTF2lvdBovF5bIc7OvH/CnSdxIh67YzaiXoXpUH
			d3g8HiKNCZ/xeQ6l0nWHZpg7LqVmcaJC9pDNnFGKwz8Vi7XFHHuJ7AX07tz50dn16z9888SRdevS
			8Yt+AN/2A8V8/acZBcZ6edz6Vf36MD1kYjMvff2qe/3KjgY11kDAnvsyQPvet8/GHLbTxn+wbucR
			wBdzouZPgN+lBLb3qxww7HMYB9jMB7xlbXIQvvf4jRvmr/AvOOX79Te/ZrXvD760569Z5/NfroPu
			xXaM13n27l49Zcp0dDojfCdNmTRl+vSY6RmT8qe3dnbiHEGAbm8vIPJGee8O72CFijXNDWvWNFTh
			DEGsL1qzpqqiCjRwRUUbVv1uamupaC6v2ATrqpYTza3VFW1FRa1d6a1ZreWHjn1y8tihTy598uG+
			yg8+uXTp5I/tmIR1rJxU+Z7BzOeTH3QEwvfAgQOvR74OGheU78a3Nr6Fuvc6bNfNIj7oE1hlhNnO
			NXDB0G9FxfKKhqqGChC9nWsKc3MLbcsKQQQDfhuboouSi7KyS6Ob4L+NiqzM7KxhfnPHInyBpKRT
			JIdH8rnI/eETMsjlHEuw8YJMjE8Ts1SO5z9BSUYN9zSkLxfYk7FgSZDxfaHJn23CGILvA8d8EUHy
			f6vc/3H7f//nfrghf3O/AOX77bV/lvz5X/8q2w3bHy9VkLqjh/z5YfqW/G9XOrux0rce5/yStlcm
			0juDIJfCyl47oNfBeaXJAAWrq891R3nH7WaULpc2UTEip+LQliBTyBIS84oJd4nqzc1F8pa9/fbR
			S+9u+PDdD9e/ue5EXXRiIrBlpF/3gynfwBm9QwtfP+X7k8J3oCPae2+w8v0yf2k+8tdX6nvPBs+s
			/F3lTXiu+dsw4Qt/juh2DpkvGicnUQjC3qhxMwN5O/MhPc8zebdzEL5D/sYN81f4n198/M0Xb334
			z6+HEr7saN9XwVYvrVm99NX3uJAvKN9JsyNLJTOiY6ZOmbJ0ytLpk/InZUyZOimrubmzs7O540Zn
			b+fx8h03dnSWe5UvW85bxSZXkSm+cPeDlqrqlpZqgG8SSN+Kim/h2tzW0lZd0dzc2tZ2Caf/dnTc
			uPRBxweXdp081lH56Qefnvyko7y9vPkGoLejHKcZHcMOWO2ByvdA5Otr1646kISe5uubkL6z0PNM
			Up2x3jdpOeC2rnrW9aJ0dD5jyLcIu32crbqwA+hb3rkmd1l5oa0QLbO4sRQYnZWdnZnZlJXZWFTz
			LCtfzh6q+OVhCfJ07HEp3wQg4m8P7Aer3N++/+P9H3/8Bf7LC+p3f9vGym39/XfobgwA//PjcIX8
			Yb91ChSb6Opt6uzGzGdQvi7ELzadJBFeoxv0L0XZ3XxAmPSRdJmVSidNMW7Go1QCevHfrGF+4N/b
			ZIrExKsEuuwlN/fC22/vfBvQ++6ldz94990PP/zwzXVHTlQV5SWOfF7hSJWv/xSjc4FBXp7HPm3M
			P+HF+6N2YJ3R4MZW/ia5lnx9acw5r/bl6RuY7hzgdyZe5//AmO/wlS8BY4QoCu0iXESieTPH8a5i
			f7fzg3ue2SMF4Xuv37hh/gpvhL/5byp3/ynQ78y1mMQWz//n9dUsfV9dvZrIXhC+702aND06srR0
			0uwZU9AygMXTp0zKnzK9eUd5M3qcOztvHC/vKN9VfqOKP1MVilzi2K1gRxlhce0RrD5qq2rfiNbe
			0l7UnJTUXlHVjPMHWy61NDeXn+no2HHmw0tnTu774JNPOpp3dZw83nGyo+NM741mLDjCVlfYXfJk
			h1/C1YEVB15fe2DVgVUxs2b9ZRY2l4Sj40hBUmeUnFQ3K+lEenoFALXuel1RdmkdiN90eHdFVVj1
			VFUO/xs0VB8q7NxR3gnaF/RvbmF2dk1RRRZ2es5rLC363wC+/xva41K+AN/fbvzi448/3r//48pX
			Ufd+wdL3m/1ffNH+53/9P//Pnf4Pf/EL2PvPJOxE8VAGsleuILXDiam56H1GpzLOXHAZlJjgjKlV
			mPpsYq84u9fS1+10Ouk7Sj19545NrwLVmzjymXFDmFyRmAPMxdmFxH5XtnPNms8//+jC0cPvAnzf
			3Fvy4aefIn2XZy8e8eCGESvfcz7CDoz38jlXPvjywven1e/lABx7he9QGVfnvpx+ffXsOf69JQeG
			fH22ChOeW0dYasQpX1jGR4lEUbDAenwIZjv7E/ThF7wE4Xuv37hh/gpv/Oc3//znF5UfD9C9nOr9
			4S8Y7yWG8P0l0Ley8r3db01H+E6bBgJ46aRJIH0nZUzDmxmRscvLk3p7m8uby8vLb9zoON5Rvo4/
			E8reNRU7qkg6McZ8KxpaGrD+aFNL2wlSD3Si/URSczMoYHh9x6WO8hvN5R0dHS0dbR2fdFza/skn
			+z44iWMUdr1z5mT5jR4kcEfvGeRvx5n2k2dOvsOf6eKByAMHVq0C4XsdpO51UL4Y7cUGV5tmAYqv
			Y77VCUxkxjKj69XpWenVJ+pOFC0nfaYbGqpA/la1fFp1q/zsjmVrbnV25mYWlhcuhxfU1KRjDlZp
			5rM6WGGERipA5QMsHn2NT/udPZA9BuUL36DE+ITJFz/mDHRv26sEvn/6+IuPl+6v/PjTv9b/61/9
			/Xsx+wp4/IvPUHQ+BPdk3GkTEjDR6Uouyb0y1Hf3OfuUyjvoeAYYu7DvM8EvdoA29y27k6bT6e7o
			lbnaxaC9E9HpjA7sB38bpJ5ZvrhYn5abps9NWwayFy7LQPzmLEsrzs3NLfz88NG3L3y4cf26D47U
			Va3JDlGMsKjpQaYa+fN1YGHRIBx7XdBDAviyf6D3csDeIap8vQSek19Tc8Cb6Xx56KCvV/weINL3
			29ZhZzvDjz5kJsrSQeaPzUe0KGQJQfgO+Rs3zJ/VRvgQ+OefKisHCt8fsMXkD39hwfvSasy4enVp
			LBG+7+2eMWn6tJjZk2ZMmjJl6XT0O0+ZNH3SJCBw5PSs9IobneUI347ychC/x71TjUioF/3Ny1uq
			WN1b1VLV3pLUvqmlrv1E8vXqZMy82tRS1NICOD3b3vIBsLcFl7PN5YfKj+1r//TY8UuYbYVjfU8C
			h4+X3+htPkOkL4n98n/3Fw+8fmDtqlWrlmJnSaDtrE0bAcBJgHmAbzX6nDfNqqvAGqPkmuSk5Brs
			dZVVvSkJ30JFUUPFpYo1F84eufRpRUtLw8ZLFR+Ul9+6VdhZvqZo+fKaovTMvMxnOuFqBIYqjWSr
			+hlppDD6OgEPxx6D8iXDjhWRgN0vvPz9E4Hsxi9+8fF3m/7539u3HQT61n/4zS+++RMs//z3yw8H
			34BzJ4gTF6fZ+qyWvj5nvwuMINfcb3X1WfGu3WRyuUxm0L0ul9K5LCd1MXD3UZwb0A8Mv1pMvM36
			ZctyAcKspaXpmppycnS5nZ2/0y8rfnf9ujePtJxds6ZYNMKkq5HP8+VtJc/glQOqeoei70812/DP
			tArMdh4CvlKkbUzN9Dle6vrNOBpU63uASN//+I//+LZmBL2dQwh6EY7jZs70pTg/OuZ6052D8L3X
			b9wwf1b/xM+DbwLhS1zO2Obq/0R/8//B8vfVpbOza95jm2wkTZodPWnplJilmGs1ZSnAd3rGlElT
			JwkiY6SZyxG9HR07gJKdHZd2eOFLnM071pBEqzUA3paqqh1V7R+0tFS31bW0w7q6rQJo3N5S8cGl
			9kufftAOXO24dAno29F5vOOTyn0fftCBRUU3em8cv1G+6x1Yg317rAMHK5zBsC9/pouA3rUHVmE/
			541J10mlETqccbzCrKTqpF9ih6tkkmuVXIfQL8pKT1+evryo7q3qrBN1FRXVFaB+13ywpmVdVdVb
			/3zrxMZ1H+y4ZSvvLIT3DqCueLaznUdgCsSsbIDJH0XDiKdijyPmixHYKX/ykhe17xdA3y/Wf7Hx
			w4+n/OPbb7/Yve3P9QcP/+IX//wF8vfff/3vsx/R9w/9xmIxyNjE/zv3d7es1n4zW3pkciF8nXcw
			uwoAbEIKO5V67eLFcoU8TvFIZkzhpAeQ3Xo21KvX56Tl5OQ05ZCk5zTY0AGE05bhavm7SevWnahb
			s6Y0Tz6i5OoHUr4vPpjyHRK7Axtc8Xu98xaGGqlwWQq311ZfI601Lt8v23kV6fBM5vr+x9IRwXe+
			T+0+NsNDB+F7r9+4Yf6s1n/8xf6Pv/m45J8Bfmc23nsd85xf/R7I+9JLr66enZ29v5IN+lbGZs5Y
			PSlm6UsY8E1JAe2bP2WqJCZGEBMZ3hi9vLO5uXwHqNb28h3Hy8v5M5EEZ+J7RvK2NFRVwbUdA70V
			Fe1JbcnVdRVFRS1t7SB1P2z54NOOctJX8mxHx43e3t5jH37S/sGnJ8+U3+g4U37m+MkzN37sLEfB
			23EMwNvbC7r3HV97SZyqsOpVRO2mTdeRuqTB86zrG99iW1zBdlEWyNj02OvJ1cnJ1enZ2emk3VVF
			Ud2JI9VFRW/WtcC7rDhy4shbQN9PP9248YOzLTs6C9W3llcVgWQOwhctAaOLg0yMqudpv7UHsseg
			fBOBvf+NdTez7N1Q8qc/rX/33Q/Xr3+vtfKf3/73/fA3tXvPvm++/sUvfvHNN4jgf/5ixuRH+M9L
			IpbRyhIXq9LO93U7Wdaa4ap0ceZwKmlNaiLrtFCMqF/vvQ2OJL/CRnqV+mUodhub8qRNaUqHy2m1
			KZUOpZ6mgcU5uWnFH7z5VlJddUVW5pXEkcxwGPFUo4AGGgPZO4Ty9ZYd/YTw9S8y8sF4iDpf3zzB
			A0uXxnDDBHn2Xv5yqNlGX+aj9P22dWTwXTTfi8hFHIEfuewNKt972/+fvXeBaupO+/25SWdwinBg
			RhHtKxMth3IoqCQkJJWhlFdQ3kYiASI5GNDDpckfsqwkoMlh2mkliNZhRkSqloxI4rs0nuMMY0Ux
			q7UISJDhll5oRwUxNAw3Ya1y0XfW/3l+O+EmtODldGYWv9x2di47l733Z3+f67zNzmXZx2HPcGQi
			ywgLXGGg1ed/AfSiw5e6pKT4CAW4oyDSd7lPZOQ2TD/yiNz27baVHq6r13oke7i5L/dwb3YTcCV5
			+fl5+aYqQHDvRIUr402jUWW8mQ835FyI1yaT0tip1rNNRg6AF+jbqT+dV2+u1+nMbWZidM4b7uob
			7jIezTttPmau6ALwnj517nxXn1iMwreirQKk8DA2OOrqsq4Eft7e3ruWyxUKJeXqtVTXwH6CCkUH
			yuAOrQCrZ0nUWomEw+6QcIUCZC9XiylHapVGpZHL5KUS+MCleqVCLs+WKwDBWcb8PLGYq8rgzvPH
			/ReH74awsGAn5kz4BrOeLlL6xxvPQfnC4cnKq1bwlpVdPfzRux99VPTOOx8dPnrkjul2Zln31SNH
			jsDhb3d39+dIXlC/V19a8bQJtlMGnUXH+h6YgcRkbmmKD02PigpJjwgNRTCGxr+xJZhBkpPo2GiJ
			QQD8TKQvs4kKshJhvFV8POjeZvGVAarbUs2FC2NwJBDy1lh6c6JUWlVUqgH6cvnJjAWsOQtXvg4T
			jJ0MbL42WdZqZvmrGdWvviezaEIFT1TcmCPgmaLttVrv2tQO113TWwo+1tWXSF8ScvXVQloK2qwB
			+j6mVAPmqWjnPQIW4Tv3GjfP/yqnbN+RI2VHPiibLG5FVbY6k6nNjCTk/Tblf3T8EkDcQWPL9x87
			dvzY/uyXXsbOfGfObHPd9u239z3WLV+7eqn9Cjcvj7Xu7m65hqUCwC4w9JQ5f6LCFb3KiKOQujEa
			842FCF+FEqs7a0zGTo7RqJeogM9VZlORsR7RCxfTcB/QtaK+3nzYVF8+3DXYe+rUafN5c56oD+Fr
			butv+7q/vws7Ck6YndfUOju7gmRVYANfYnNWUlWtaFjdWYHpR1qBQCvkaTk8Hoej6eBIeAIhD/DL
			JRm/khx5Nic7Wy5n52SplbIsEL/dyF+dXJ5VlZ+XwZPM88f9V4cvM/js46OaQf9Xhe+ClC/xezMZ
			3lct1mYch08AfN45/O7Jk6ePHjHdds3B9KMjx4/nZKPwXdXdvWpVDsB3lX3Ds0rWYjBAhTKpWwYJ
			gsILSEwsp8VAzyydlGOwFGDeEPjUfRTQyw1vuEVExVg9EsUnxsdhrNWVmgsjoyOjNScRwDU1J05e
			+PMnQ1JpYnQUt7S01Ij0bVlARa0nU77T1e/UPoKPtVeYbn7+AZ/vtUl786Qefry082TBjZKUlFSL
			8q2d2drIe0rMFeksuGDlO6F9UfSS+zgLZ5LbIEodP80VMTvTLYV05vN3/b8m4OT4h4WvHBMgjh85
			ftXazwjh+y3ANzNSm7KUirdyXapM4cD4JUcNA64IiGk0Nvvl1wG+qW4rlnt5pRpWGNZu9zK4uXm4
			bxdguJXRnG/szJ8wO1fVA2zzCynha6y/WWisKi0ywZAZTWpjp1FiNHWqTSq0OuuKgLxVZnNeVVVe
			RN9wX4W5Pq/IdO7ocEVFRd/7h8q7ysv7IvK6hrsKKiq68iqkwzBZYZ4wOwN8OxTAXmxnROvAz0kV
			dFZSnX3hxNEKcgU8IdwIJDKs8izkCYUCIC+Pq9Kq9Fy1XiPPyebIFVk5OQo2cBi4myPHbGFdVlFV
			hnjR7EwGy5/x+FdZ9pPFaGfy49A3MFhhtkeIydmifY9+DNh5J+f4iZou0287vzIdP0K2vv05Oejx
			BfRiuj1w+GoAKU/0bL+exSUfSKcCuhC2pLvuM65ygkqbxDkje6tB98bHx0UPjYYPDFwYGwH6IoBH
			R2tqTp44OX5hdHQoOlokEheWlqoLJYLc1vl/6wUq38fCqWY6d69d+4GH5+TulAqTjVMnGmcPeLZc
			vF3ZS52dG2u9p7QZnEX63mv/6qs7Xy0w2plCLqVQCSkDcFD5uXZ2toTCMUFTn/YkU4u1neda4+b5
			m+SUdV8tg33A591XqaaCxOb8t79181NStq2kbM40FL5qfQdFXmAVh6PuYLMBbopXv/32WwcDP3fF
			uhVrUz3WRdq7uaWuWLt0paQz30yils2d1iWVGusRv4VE99403jAaFSaFjmT3GgHBRjQ7qxSdZlOx
			0Zxnhiejy7c+D4tV5hW1DevOFb/fdf58waFDp/LEfSh7h4cxzsrc1dWP6DVPKt+gxl/I5avk3Sh3
			0elL2vgSly+p8wz0TZHweDyBSosFNjQaLYerAukr5KlBAUu0WG3DqNbIs+TybD0NuKvIzlbIsxU6
			0MKop7NkWYupRmQQ9DJmnFj+/5wlNp618kWNyQqO75mwOe8r3r//NydOnvxo1dXfnTh3585Xl+7c
			jlQcP162f19ONzD3aveq7uJ3PtqHdSdXPZM2gzM+ENY7shCYKjgWSFUie7bLAYnNojOlWFZDFBKS
			Hh2dGC3qGR0DtTs6OlJTMzI6Pj5+eazmwigch1w4cfLyJ/CUqCgu23hTrxLy5+/1XaDyvTYjzOpx
			7+5C4Ptm4zQCT783pbnCrMNCW+/lHSkltRO1nmeydxd1tev2HYDvwszOVm0aMAWZEzHQUyA6RSAv
			bIp64SJ851rj5vmbKMrKuuHo+/O/lF3FKld/O/OXMyTHV8D7Fsfftm1zfVGr/bmEg2UYceAN5sf+
			8pecTCXbddu325oMBg+v5StXrl3nusJtxertHutcU1dzVKB7zfnlponykvWUwRmYfBOlLxvAq+sG
			/OqAvSTs6qbJaDTlV5lMxWZgbxU8s95UL+4b7hd3na7vqzKe6hkuL+jNKy/IGx4a6qpATy+Mr/uH
			h/vbAdTnJ5RvZSogslvOpropEN5izhFNKWd3EA4rOTwBTyLA4lacDo5agt0VAL4CmOQL4dvxVFyJ
			OluWpVfQFIpsuUKWpQP4rspG+Yv8zVmELxm46c3cKVDN4n/sT/ZE49kqX4Qv89Gjh79H4YsEPvrO
			0eKP0exc/NFvTnx8p938wdXOTNNxUwpnf/bVz3Ow0UJxzfVH0UWrAL6uYc/E9fojDEz0Dkwm3t6Q
			9BBAb3TUaM0JIC0o3pHxkfGHD+FqFEF8YeTClY9PXv5zaHxierqwtFSvVgkN86509STRzt8vf+ct
			emeEOE+RvBPRzhR456CvNdSqpKNjhbe3d+McPQUnpW9764KV74RvdkLgUgZjpCbmH015gpXB852i
			YB6wCN8517h5/lUKLLiTU/b558fLpoQ6/+1lHoHv3/72baSa80uUuhgVzEHy8ng+PB8tT5KSwuH8
			soP9rWsTyN0Vy1cu9VgbudLNa8XSdWu3p6amqPLzQMG2mTqti6LCrIwqyuWL4NVhiQ2dTIF30e4M
			8G0zG3UmM7p9q0D3mo3lwxH9fX0V5W15/Yl9wxF9XTB9qrwvYphYmrvM54f7h7+GaVC+Xw1bFhTo
			1g2EVBDfroLEW2G4FVZ5livIDY0NfJXwhGoeT8vBKZWGpxLwcgWSDJ4wl4fZv6DuMfhaky3P1qgE
			XKFAAEo4Oyc7Rw4Ezs6Z5wr3rw7fwEBSicF6oq4CsTzDj/3Jnmg842hnZiA9buTR+FG0OSN8jx0u
			zn4HIHTyoxMw7t3+w3tHPsiJ7Dx2PCdHDujNge3wxMjI+KPq4s9XdefUhdH/OS0ITDgmCxYhekUh
			6fGJ8dFRAwdO1MAYHR0fGbk8DvQdvTBSM3Zh9MLlMRTEF8bfCk0fivbSAH0L+bbPSflOjCQ8J82q
			fmeXxN+D38bpCb4zPMCzs7d2oqakc22JK83VzULamVU2dln4W9L+1Z07rfNu7DjF7BwwiVdicQ5w
			sQuwcwmgxpMmIllF9aLynXvM2+x8pKzsak73ZIov1czoFZ6AYm+mJAWUrpb0HwBkwTQPdS96gDt+
			2cFJ4aSsbnZfu3ZlpOs2j6WRa1evXJfqkfrttshtkcI2oGehcVL5otXZaDxF2KtD3QvkBYWqU5gK
			jSadSiUxmjLyzDoMcTZX1aPN2mQWiSOkPae68vLykhOjh7vEXeK8vN4+ELtdmGeE8EUKt1W0owi2
			LsmjW4GtC9kdpJ6kEn2/ig4lVtlQ0DpIdWeORKDlgfKFQwj4MgIArUogEAokXgJhLghggY9EWaoH
			6GpkchlPKJXIBHyhJAftzzkofvcvKl8yyLYXOHPQ/0lLOz9j5UtnMpgj10dG9lHhVnDeX7z/0AGU
			vidOfiz88vYXecfa7xwp278/Ozsba01evVp2ombk+vjDjzDlSBH2T+o5h8MvZjQlfEPi46PS00cH
			Pj5QMzAyTsb18QvjD0drLgOJxx9efjhWM1pTc/nP370VLUrkl5Zqbha6zfvfWqDyfZNEOz8T5ds4
			idlp6UVTeDy3z3fS8oxxVctpHWtndjPynip8S2pvo/Kdd51tCr4BMwGM8xpr73755b3bt++V3E1A
			D/B0pAZNsVUHzDWPMl4HWFONFuE7+xo3z99EXmbp5/sXS7AzVrb6y19SOs4ger/N1GqXAnR/ifFW
			xOaMHNYCeyWYIItZsmqtIddjxfLVS7ctz1y7DmTv0m3fbtsWGbt7Nzcv32wymqwrRZElzNmI5ucc
			hK+pG/kLZ5PKZMKyz0Z4gbkCXnPOVGQyg3IWD0sjRH3lANi8vqbk4a6evOG+4Z5hZO95rGrVNTz8
			VR/Q9+v+ruHJgCsPhWIVsBdV7xmSXqSk0TLJrTKTbYGvF4+rFWBpK3T+dmh4EqEQ6KtVozlavQ6b
			CHK0PL08Ry3k8Q1AZC7QWZOtxKwj0L+L8P1XHM9U+SJ7+UDa9yZCnY+X7Td9880JUIEfcoX8d9/7
			4Ngdk6kYR3Y24Pbzq2XHP66pGRkZ+QgTj16yf+YRV/9vBiPQaYvF6BwaL0qPGjtw8kDNhdHxh9VA
			25FxdPteuDw+doG0cwD0YuxVzcP00PREgYamUXPs5rlHf/Jo5+/lLhV5NbMBw/eanhsnM3unBmM1
			zq19pxiaUzk0113T4ptnOn7vtUe2NyxI+QIcJ2zFVrza2bnca29vv0dVi9aW+K2xs7H4fSc9w5PR
			VHPMoyKmiQV7Eb5zr3Hz/E32Hf/86oxevih/edozyN5vfy4h0MVBQIXKl0yRWCWUwGqOwMuwzstt
			5bYVK1OWrgYNjPDdFrndm5uHRSI11iUVVt003jRizHN9VT3AV6cD1QvSF84KY6e5iGtsrzfpdGbA
			rslYbzK3RUREDA+nRwz39vX2Dg8ODycO9mFVq+HyYVC+Zqx0VTHc1dXflTfc3tXeDyi2Lgngq6Ts
			zTQaO7MDOKzsyCTVo1EMY7lJACsoXZ6At1zA00gEGg5M84VajYrHxYArNXxNgUqbJVfIufA8KYAZ
			cCzgS9BACPRdhO+/5Hi2ypdJZ/3297//bVnZy5aizlfLcm5//dU3/I9OHPEuee/kieI7V3W6w8XF
			ulKNUnG17CV40u/QN1qTDQfC3atynrbFwo81iPANgREaHYLw7TkwemF0bLx6DB29l4G1qIAvX4Dz
			hbGaC+OjoydrRv78MDpanKgqLWVzJAuE78KUb9Kbbz5uc57ZWnCy8sYPWZwfd/1OFnaeg78TJSUt
			Krckhc1Z6z2DvZMw3lVbktquXRh8CRqnumqRni4J9+7c6YSzudNsMt25Xec3uzF5qtx9bN5EyY41
			i2bnucd89+b7JxN8qVsS8NzN6ziDCUfaDo4Gm94icWEQ5sLgogjmWIKvOBKBYfVtvkckCbha+S2i
			99vNmzcnJWnz8sxGa3lJurHIWH/zZpVRB8LXhEWjUPwqr3bn6BQ5pvw2sYlrLCpGY3N9PUZenReL
			Dz6IEEmHKrrEvYNDD251VfQOg9StQDszKatRAZq3fbjCPIwc7u+aBl+5UnmGaqVAOX2xyCQxQys7
			9OwODWziPj7whYTaXK5ExVELBNLcXC+hloNfViWU8Dh6mGLLVfAcLqBXJSg1CgVSvlSoySqVZ++f
			54+7CN9/qvFsfb6tgWsxhfe4xeN7FYTv8W/u3fv6nnZ/R5LkxMnfHLtT/JvDxRLF8eM5x0x37pV0
			Hz/+we8+/vjj/SCDc1Z1r/L95/Sc05lb0OIsigLlCwIY62qMjMPV+PgjgO4jvBpBB/AjkMAw9/KF
			gZoLNeN/fitaJG3WKNkS9xfmd9DxdMo3aQqDv1f5fv+YSOudo8LV3DHP1tYJgN3bNNpKN/ddFt56
			Tw24IndKUpeuX2DA1eP+XNuAhNt3OjtNnSZy7uzk1U3jbtAsL5s5b0qq7yJ8v2fMW/mWWVKMrPQl
			+P0LB9ONvtWmcF6kZK+EQJcHWhHNtFqMuOJZFDHQ12td6sqV21IjV26LBPZipBayd68qz9iZn29d
			UhYm9RqrquqL6qtkOd3dZTndum6UvSCCFfVteap8rKxR0Ympv+dN5eL+0z396dHpw13newYfPDhQ
			3lvQS+pYkShn0XBXeflw3/Bwf0UbzGmHeZOpRkT5YhcF0kNBqcBKGx2k0CT2V+jg0DpS9PDxBTw+
			8JYnlKglCF9BrlCg1gokai5PIES/tjpHIVNJeEJBLl8o0AqFQik/VyDl6dmKxYCrf8nxjCtc/fS3
			BL1W+paV7Td9/eW9r+6YFI23tR8fvdN56bbx8L6snFVXr2K27/HOO1eP//a3Hxy/+jlsHau6X5L/
			U1qdN7BA+IrSRT1DgN6Q6PCTJw8AfC9ggtHoWPWj0dHqh+MDCN/RGrRAP6oZrbkwAs/401vx0VJh
			6TpPF9sN86LvQpXvrJo36bFQq2nK9/tzfGf4e6cK4knwzp1wZA2s8t6VSlNKPKzonRbqjM0VvGt3
			lfgvEL6TqncyOhnhC/tWHaIXbjtvT0hfC06neogDZpkXNGmFxiodi/Cdc42b52+y73jZ1c+n1JY8
			Qzh8pgPh+6LWZ/ny5agQtRKr4OW9iALYR+DDI/NhvAgYc/OKdN0WuS0TyYvwfX1z0uakrcI2AOpE
			P19dka4op8hUZNIhbXU6XU437GSoOwpdYVt/fpvZ3Gk+bzJXmevbIsR5fxjujxYjZU8NDRYcOhgx
			VN7b1dc3HDEMind4qA9LSg535SF6u/q68tqmBFxhLq+CKiupxNsOckYaI4M5HR2g2jHASog1nVUS
			GgBWKgX2CrHHAnAZizxLONlyDRewLNR65eJjXKFUqpJIBXpdqWqxyMa/4njGeb42x48geD+3srf7
			eNmlOyW3U1NLOjok7+ru3Dl3IB0n9ecAAIAASURBVP+wXP75qhyg79WysiPdly5dLesuQ/iuWtXd
			3f3PqXxZwSJRSMTBQ6L06JCoqIEDB05eGB8fG7k+Hr9lS1NLU1PTp4nh4+MXsMjk2MPx8ZqxkfGR
			kZoLf/qveGlic7OLo4vd/LKNFq58HR4XvW9O9C6aVfm++QPKt/GxHKOphunvC7madPoibr06ZLSV
			u3Z5e9fWTmHwrsnEowUX2Zjw5E7QMyigBJQvevuAvJdMl3SmL+0eq50x3Qk8dd6aaSyeUL7zXi0W
			4fv42F823d9LRkrkGWDvUglKXdS6Wg5OWqQuD9ALM318fLSogLE6st4ndXvkNtdvtyF7X9+0I2lr
			EhmRIHU7rUvS4VFXjg7YC+ecnBy4wJpgpa8pX9WH3XvNJlO9uU8s7hGd6xsWDQ9Hi8QF5cM9BXm9
			PeJygtvh4cHB8uGuXlDBfV1tWIODMBjO1iV5EJcval9sI0hTsmmZ1L0ObKqARTc64IuBos3lCrQS
			NZsHYOXnCuHEU0skWHpDLdFylNkyvUot5OoV3epcviBXIORloKNYapBIF+H7rziecYUrGtG9FHp/
			C9d3OnOO5JTcvld7r9NVexjge/U373yU/VL3Sy9l/eEdOT710pGyS50deDDc3f2XVauW/lO2h2Jg
			LckDB0YfRYeIRD0nRkf/688jI9UXRuOBuy1NcS0udnbN4RdGx0ZJvY0LNdXVo+M1oIH/FJoYnUjg
			u3F+/9aCfb4Ueu8+Zni+Nr3PwpS7c5qd35wa79w4E8ZTehvNnXFkqWi1q9YbmFuiZbO197y9pyQZ
			1U6CuKSW9YPwDSR1lgGHNpYKkgHWcGU4xWCqUUBC+x2iecm4ZNIJmuwCgqaYlic8vVQ1yomJKW9E
			8dcytVjbea41bp6birzbkmb0l4nrq5/zMgG+mT/7+YuuL/r4vOiKJmafFct9lqPe9SHcBfxiri/Q
			1wdDryRJW2PXxr5OLM7btiUBfOG0NWlHiWoCvvQiY30R0rcYJbAOY61yyLXOROiLjRQIfItO5+WJ
			pX3cAlFE9MHoRHHPIXHf+z29EeXlXcS7O/ygF6Z684DJlN+3qw3zjPImfb5uWEGS0JZK8sXCGuQ+
			Bjp3AIHZHDSgA34FXjyJmiOQcoVCaW5urpdEolUr0dsL0leZrWTrFSqBOidHzuVJhbkSqdTAJwq4
			f54/7iJ8/6nGM67tfMRaVZLSv53HLv21DOF7b2lJqlbTeeeSqajwZs6rCkV2zfVH8Qfg2d3wgm/K
			Xv0c+xt1d6+6+k8JX6ZUNHTg0IGQkPShqKiTJ0bHL18evzA+9ijOpaUF4NvkEhBk1xI1hqlHD8fG
			akbGRkfP1tScHPnzW/HiRKG9i4utzXOKdk6aNDVPMzs/pnznVdZ5eqDzNDP0VAxf+76YZ+twq/V2
			ZSs6b+8qqfXeZY23QvJ+YeHvQuFrJaaVw2ts4abunoW9lzpR+eo6DS5BVMWriWCqadyext01MRTG
			p3B4Eb5zrXHz3FSyralGGPRsdf0ifP/S0ZHCSQFZi5FVWlcieYG1Vk8vyTviUJlH+HiS917XbSnb
			trnu2fv2VkJeYG/SjhTZRD9frCtJtG+Oroi6xVgrEL8mNERjJ0GzCdkLarkvMa+vfzhCFHFI2j+c
			d6pn6Oi5CKzlPIwtjCKQt71dlNiFqz5Ach6K4mlmZ8JfNk1JWZvZNCrJF9UvwFdC4qgEXtxcFU/b
			weEJuFIpSFuuF48rKZVLsMiVhC1XKuSyrByZQqIuFRqluUBoQYaA2y8F8bsY7fyvOJ6x8j1yfEpZ
			5+47l7ovdd454hr5xe2VtevWdRw3dZqU8hT2mQ7FyZHr448evksgfcR0pww2RazzvGrVs678aB3P
			FenBop6D7x84EIJBVwdI9PbI+FB1fFOLi0tTU1xcnJ1dkK1LCzAZK26MjZ6oGb1cjTU4/vwwMTGR
			7wjwtX0uPt+peb4zfL8zfb4/rHynCt7GmTOngncuy3PtVNszql/QviYUvyUUd6c4gL0XCt81FCNj
			1liYaU04QulLJC8aIUH3mKT8BHjIdmrc1RrqpeSFa6zvEjPJ8zWTcxbhO+caN89NJafs6udln8N5
			ivk5syPlzJkXXyQBzjzKuYuGZgEJeebCWQvXyGKJxNKRXqJdumMrnHa9vWPr1h0AXeqctKOjaCLa
			uUhnKjIS7dutKyoqMuWU5XQje3UofXWdeSYT6d9bbzK19UXnZ/QP9/VEVfT2D5vP9Q2/X95XMIxm
			ZrgM9iJzSW1JZDElemFMmJ3pbsTXy0bbM1XKmYbNFXAOR0nLpNHUKgGXJ/SCL8WFIwuaRCBB769A
			kMsF+HL0aFvWchTZWNI5OxteB8+HZ4JQlgqwCiWMRfj+K45nq3yXW8BLwfeO6ciR7iOdnR2ZnbdL
			3NycndetW87+H79wXen6c1rNCNL3JGlxcvV4CTFFdX/e/dIqD6dn/A0nutDQLRVSNjxzvDOb+g6c
			+vU7QyGh6VFDJ0+eHLl8eaTmys1kB0fPpqZP4z6Ns12yxNZ2TdPo+MORyw8fRg2cqBkfrxkFEj+M
			T0wUenq62Nk6zedTPWG0c9LjAH5y5TvdzNz4OIunPtg4rc2RtZ3ChIXZTWsyKTrvofT1rt01Fb1w
			Z0HwncXqTFy2Lq1fYMgV2d/CTXHnX+/cqQ0KsLM0WQiaStiAoDVTrc0UdYOmz1mE71xr3Dy3FcVx
			ELwvU7m+f/nbX1D7ajs6Os6w98n3ybPlWbIseVaprLRUo1apCzVqtV6t0ejVer2mFB6DuVh1UnZY
			rVYvJ7DFYUUvjljFhPI1FlGkxb+eCrwC7YvkRcNzUZvpPOre+npTvTm/ryc/P0IE4O3Ki4goP32l
			t7evhwquQuVLmgwCcocrhv+IBMYmvwDf3gnl60ZaCAKBsziYXkQ1FQQRrGBnKjM7OmgaiQCPIeAi
			EGh5HDUKYdLQV1AIxxIqCbq5ZYrsHCwkmQ0/wj51RgYP4MsTwvOkAr5AOs8fdxG+/1Tj2Srf/VaH
			L9L35Y7jR44fOXLn9suu7be/aHR3cHFwt891Xe69dsW6zCsjQN/rJ8uo/oKRZ4gVatXnq1bRnrVG
			nYAvg2GdfsZLcGJERx349TvvhLyVHjI6cLLmwuXxy2NR0rg4F8fk5Kb4uKYm26AXbGzt1iSGXAb+
			vvVJ+EDN9ZqTF+AnGI8X9fDtAb42LywEvvOPdn6swlWS9bxgn2/jjAIb0+Kep/U7miTvtcfV70RR
			SVS3JRJMB0HPrzdFXLyU1D6h2dlK3ckQKju7loTbnaZLsNMtRgAfu/PXNlNniZ+L3aTHd80Uck8h
			MWVzXmPV0RZT9iJ851rj5rmxdGNB9+7ulyy1reCGkyiIPANSUa/nUCHOJK9IAKDCAGG4XUca0Qt4
			eMcHFHCp8YZe+3PtWkLbHc47po+V1iWp8tG6rKMGsLeoWHf1qi6H3FVwzSaifDHm6rxY1C8ujxAN
			d4nzDorL806dEpf39A0P9xLlGyHGaOcuNDwjgXsJfivM56eZnUn7BDZNw9ZIOOj57UD924ElnrHC
			cxZHD9wF2PKwiZFEoxWogKxcAU+lVUuw0KSAR2MrgL3K7JycnGyORMKT8g25GB4NKlkozO2fZ+jh
			Inz/qcazVL5OTlbVS5KNUogBuvOre7fvfVN7547Wwc/OxdHR3sPew5VGe69mBE6/odzDyqvYZOHz
			qyB9u1exnlGVK9LIl8X6aSDD1t7NzQOGGwyDu6MLI9ApMJCF4xkshoX9CkVDA4cO9DwKFY2Ogu6t
			GRmvjv80Lr7JL8jTEP0awNfT02ZJ0JqWLVFjo+Pj/xVRPVozcnlgZKSm5k+hzdFSL0/PABvb+Sj+
			J1K+SRPITZjb8myJdf5Bh+805E5JLppul55ajWP2wCuKr97e9zjEI4u2Z+8Sgl1KAM9f+dInAq5i
			JsXvGspWvMbW1s7lLtqddUhf3aVzbQBfU6dbgG0APifImmM01bk7w+hs8QoTq/QifOde4+a5vWST
			AgBX4UJ5fK9ezeX7ZHawaaSElaX8oo/AS4BdfwTr4EIiruAapKAP5ftV09hHjh8/s2OThbfeBMG7
			yMSOpdYlFRqNxSB3i1DsmoqRwgodBjyb4NKWR3l8689jkQ3RcF9FRN8wgPVQX0Rf76lb/+eUeJga
			XcT2/KCraxADnytI3i+wtwABPKl8SSsjWimHI5dnaWjZCpS+CgWaoEH/ciR6NjGo87SAX4FEosEi
			IkhiLo+rMnLUWoFWnY3x2DnIXrlcY1AJcyVciUCK5mquNFcoXIx2/lccz1D5grIk0LVYnlOJ7Tnz
			q686Tfduu71Z6+AQ5GL3whpPpb2ja2TZB7/7+MSJ98pIvtHxTAzCuEpp389ZT9vZnhqBjECWUwMz
			uDkXkOthOSF98eII/H1GfQUBEQxm1NDQgQMhj+JB+R44OTo2/ijktbi4+JYAW7um9NB0odDRswV+
			wYAA/kD15T8/fIhe3/ELo0DpP78G8HVw8HSxd5lPstETRjvPOmb1Af9ghY2Zind6+NXkjCk4ftzu
			TJme0cnrVutF6FtkJPil0PsFBeYFwXfNRIjzhLGYcvvaBfjd60SLI9E8pvYvzGjprg0ICJoa67xm
			umKeUNFB1jhnSkgHBSzCd641bn6bC11e9jmp6X7VGun8Et+Q4rpcK5H8jPQy0qvVHL1exdGr9ZpS
			vUqvgluNWqJWcTQwzdGoseoz8fxyXAG1m4C5myZU7yacti4qy2g0Fuk6izqNRiSwDu3OumJFd32O
			rqgPyIvC95C5wFxk6uvtrYgu6OsqP3T+yIPevoq+8J6I4Qigbh9JK4LTIOkm2HURE44Gu6QVw11m
			acVUny96eNUctkIvERSXZmOksxz5q8hmc1SocblUvRAuT6gSgMRXwQTM5akF+lK9RJWlyKHgC/SV
			KyRcngHkspKrEnJztVxhqUQ4z53RInz/qcYzVL4Mxk/KJpWvKxqey66WfP3V14o3PT3XOPo5ptnb
			u6xx0K4G6Xv1yG9/+8ERZO9x7Kxdhlvj1as5uDWuf0bwDWRtYDaLhbkEuYS/HpZJg5vB4ObCeDb2
			bUAEMzhi6JOhA5+ExqeHhtQAVMdHHwJ8E1vWuLg0xf89OjGxydbBzs42ICaZxFyNjJ0cQ+GP8A2N
			i5Y6+vrZ8flLFgDf+Stf39mYmzQLi6lM33lzt3FyYloYVuNjT52t1uSk5dmt9jYVjazrvF3iTdXX
			qCXpRwuD7wQhqcgpCyyx4mRQQALStzinOEd37s4333TqLulMnARLjyNsfjTF7zst8nliakJSL/p8
			517j5rm9dONxNjnQpoKer/KEwhQqkopDqldhE8EJm/Nq4ToMTSJlrrBGBdqdQR2/SBofSVwJbYG3
			e/Fmk+WetcUNux6rShbrTGZVDsY06+qLclD6FpuOtZvrzefbzBX1VTBRb+7HwObegkN5xad7hvoK
			euEeZWoeHu7v66qI6CJlJtHenI7W5wrLaVL50pQKhRyOEfRsGU8il+fkKOQKYnBelaVSlepL4TOr
			KKXL46pLVRoQvwIu1rICHZyTLSnVaXLkFt2bk6PMUQvURoFMoxXk8pt5Ei1bIpnnj7sI33+q8Sx9
			vnRPS2FJuLrKJkQtU3R+fUexws6uMsA3zcHR09bTnq11X+3afbyMVOO4WnYGxTI5EKY2yFVBzwK+
			DDgUYAoP9IhFUgtxUfd6WNlLBLAnI5C+4anDu+gMOnNLSMjQ4EBIaHp69VgNyTN6FBcX1+RZ5+nZ
			Eh8SGh33RounXUuQbUvT5fGxmpqBqIGa6+Ojoxj7DPBNdPD1c+EbPefzbz2R8k26O2l5nnNcW6Du
			nQnjaTye9P3OqHdlBa816GpXrbfb7U4jEb8mzj3v2l2W8pILhe8UZK6ZSBNCwMYE2Lp8eQelb86l
			YlN7+9edum7dVcW6NQETLt9pOb0xEybmyTjnCVW9aHaee42b5/ay6nOrlYucr2b68Lx+yeG8uHqd
			1mc51tLgaQln18HJB23OxNCM5SYlWi5GJ0kkaj0H2xzBbeqmGQMRbF1SsbGoXqczgtw1GzHirshE
			LNA5uvp2szmvK++U+Xy9sb7+NNwB2PbDpff0ufN55b295UN9Fifv8PD/+a6rAv28gxXE0oy1ntHu
			XDGlpSAoX2Bvjuamil0qk2iQokp2tiIbhGx2qV7PU6uIyZkIX61ApVVr1FlqOVfFk/Akaplao0PD
			tMXsDNqXli2X8NQ8LVulEuQ28yUKo149zx93Eb7/VOMZKl/6hlxrWcnjR1KxbWfZy1fLvvk6J2WF
			vW+Qg72fo6f7GnsPj5+7Le/478dfoqo/lx3/q6mzjLJDEQKveiadjegMRuLBAwM9oHzdpo4J7Uuu
			XOhP38eBHkhnvhESMQbwTQ9JHyWFI8dHAL5NyXZBtnZN8W+FxsXHudh5tgTZuWy58Ah0cfXY6PjD
			8fHRkQs1f34tLjrayz7Nj+duP4/jgAUrX4fHLMwUiR9z+S5M+U6zPU+1Oj8WiDVN+dZarybyfUuw
			2AYPa+tiUCqK313euyyJRwuC71RP7QRIieE4KKD1C4x3zikrA+XbjsK3W1escQyYzDaaaloOmMX6
			PBF0tah8517j5rm9YGFZy8YOU59/3uHK08gAUWpic5aQ1gmU+hVYMo6QWsJ1golWC1o1aXzkI+F0
			aPfs3LRz5wwAW7dpY35ePhd7+pqQvYjevPocXZXJ3Gduy+vrKjhUdLrKbD5t7hou7xIfahOLK06f
			Ky8/NTw43BtBnL0VyN+LAN02DHA2w2n4IpVy1FXRjw5g63fC2s45cn2GSqPPylKUIonZbLQfy7Qy
			tgpAypUUYt4yil+AL0edxWbr0QzN4bKVKk6pQlkqy0bhi6I5m8NRarRKlUKj4guEuSqBhldKm+eP
			+9zgG+iEXrGGBiaDwaCz4AomWHQnOpmAK5Y/i4HN7WEwWCwMtsHHWSzYRKnn48twkOfgPUYgwzro
			OJM8TGewLAPeGRYI707fQJ4RSP/euq64QAwWgoGvQK8jhtdS70KCbanlkB0+3TIjcGLxEw+zLLM2
			MKYO67KnfF4G+YRMBu6D6BNjYT/qs1O+8BkYy49bmhkdKVOQZKOyl3K+1q5Surn7erp5rLFb42ZT
			6d3cI/6D66pVxz8vo+B755s7VuW7Cn2+btgceYHfYmLQyQ4Z/ofg8J4rFHw93Jzd8EwN/gSHDTDT
			3cnpqbUvfPEmUL6fYE+j9NEB7B54oebha02eLnYOti4tcfGhoXyBwMFmSVBAXcsFQO7IKCm28XAE
			SP3nkMR0qbuDp6eNs+dziHZeyLh2bV7Cd7Z0pKlpR1MZbJXDjwU8T4Y815J0X+x7YMaEIC3Slyp6
			5c36wRbZE/BdsibAerKONeRMgGzngnbnS7oyXbGJuH8vFZfpSlxQFwdMPp96wRqSAmydF7OGeqeg
			AOq9F/N8517j5rm5rCLBVldJti+cvtW+mqlk04CmxODsYy2t4eMjWI2GZypSyQet0EBijHvGYGhX
			DgIaexXs3In4JdcUendusu4KbmbkGfP6iqpM9aainDJTvVFHWvaeqjfn5fX15peT+lanykHUDg/3
			FUj7e8u7yk9VlJdjF8H0Lgt++0luLwpdYmjuuthFKeBhuLllWRIDuxrR2KUSGem+K8iWZyuz5RyZ
			RqCSqGSyrFK2WsbO0mDvQK1EWCrjqeR6NU8l4QqVWiBvqUSv0KDJeV+OAm/YSkWOWsjllXKFfIFB
			KFRlqGk/dsBVICKHQeyJhE+4k7XSk0XmUyOQIiWD7IUDcYrMINwicydZB1Qm88i7IYwDyS1BGU7h
			I4HU65F05DTrZ0PUUnsKKwPxAIDuhFfAAwApfYMlxXTKW5ClMCwvYOCbWL4GfZaB35FCM3VGopMD
			BPIZ6ZZPx3jm8J2v8sXdoA9akEn88tLjV4/D1OfdR9oVSu80b197DwdPB8cVHn6fjlx/NPZOznEq
			6BG3xCOdqd3E50virZ4OvtTnYDCTgb0HDxyg4Euh19ttl9vMYXDznF9Hg+9ZHvy9TekA37ceRYD2
			HQDle+HC5T+Htng62jq6tGxpaYmPNhg8bWGfbmfbUjM+9qi6Gktdoce3ZuRP/xWXnujm6OhpZ/vC
			fP6tJ6jtnDTd9Dyn7ZmQ9Yf5C09Mmq57p9TYmBLjPHFjNUtPy/Sdlu3rXXLHRPoO6TDsuWSXRf0u
			AL5TuvTGYP2qoIn7pB9CQMIXJNU3Z3+xTgcUzjl3qZjnOEXjBgRYa0P71Xk6WB+wqucpwVeL8J1z
			jZvn9rKKWJ0tZTaufn4mpUPJ/pkeUYrGZTgJtDyMc7bgljh64cYHr5HBPNJxEJ8v8dFK9Cst4N05
			cbbCd4Mxr6ewqC2jHutLFpkUpvqiojxzeZ759ClzXvlgV1+e+ZT5VP5gVznSt6s/Ai7D53sfDIt7
			KHVLcDv8R+zhSzl8CXFRAvcSGJsvWpcE8M3Sl8pL0XKcI+co2FTslHwVR6JUKEq1ajYbgJzDBt7y
			eBKjMkuhkHAkXC5PpRLwNGqtTlHKYWcTu7MyJ0ehyNZnq2S5GqFECN9VKNVolD82fOnusBd1aLF3
			cHB3t3es2x1DjdqkpLQ6v6CwyqC0pKSkGLiuq1xWGVS5O21zWtpuHEExMbutI4bciZmYsxnG7s34
			AMypDLI8ADPgtfhcMsJASE+Iyzk+HWPDC3Y4gnCsCapc4xfgRx0929ossVnywsafbNzY0NCAO0zL
			QQL1I7ywJIga1m7d+LKgoImeZmS/APdtbWC/Sz3ThlxsqGkbGyfGP5LypU5XFcePf74K+LpKSVvK
			XmnvVmdn6+np6ejhYz96/fqfHo3vJ35hy6ms7PadsrIc0xm0Oj8dfOFTwAEJUxoejuy1KF8yLNrX
			2yp/DQZ3gzvQ1575pMuyLHGDVfmGgvIdGzh54TKo2j+PNTk4eDomR8c32bU0Jbd42trYutjZNdU8
			HB+vfvTZyMjI5bExUMh/fis+lO8G0tfOZuPzVb7f5++dTc0+Hjo1yd+Zz5jK4BkFNyaaHE0rtlE7
			WWeSuHnvYds/qhaGtqSkZBeaoxcG3yk24oAYUKxTimMASxO+JGWuruaUKbC876Wyc8Uqw5rJrCRL
			RlFAgN+1Eg/3OjI5xRa9JsAaEr0I3znXuHluL4qrim5idIbN/vPP/9LRQetAjy6hL7E4E+FLqlxx
			sZgzlVxEVZe0nKkClJY7qTutYxN1mVC+9caMtvx8cUahTlcGZ6OpyFxv6so7by7I6+qFU/mh/GJz
			Xl85VrIaHhb1D/f3g+KN70fN+0cLfCuGL17sohoLInWpElcVZJw2T5qdlXIljahWGBJ5jgIU8D55
			DpyySfyyjq1RollZptZIVGqJXK9RKiR6rVHFVXE5HA0qX5VSIc+hAq5y5DI9J6tUr9HI1FoNO4dj
			YGf92PDdqGUraf9m8HFzV/MEwsg9m3Zs3ZG0ddP27fe379m0PXbr5qTY+/d3bI29v2dPzObNWzft
			vH///k447QW+bt1B/hkqJI5M4fV9fMqv7uPU/Z340NZNO3bAY2T+/VgSO0e8+JvDWMsYTCaDyXCa
			NSEE9aqT8+RwT/JNghtvODm729s7OGIJIztbMjZSe8yfbrSxtXWxCarzdUiyx4Gv87YM6/uQme7u
			7tfsHXxxgIxxgLf2TcKzPRxr+PqmrbH5CbwdXpzI51sgfZ+h8mXQvcpQ7pJGvpRDt+zVsn/v+OXP
			1q61d3dwtHd0WLGaN3L9+vWH40dfLiOun6uUAerIna8vXTruSirOuTOeCr5woMQMp9g7AV+PaXLX
			2WBodm+2T7ZPTk62NxjsGfPrKDTXEjcEst4IiSDwfZQehfD98+XLIxdaknwdPVtEIVje2dPW0dbG
			zsXFLnF0/PL46NgYpvuOjY6M1oz/PTG62Qukr8vzyfNNmid537Ri9Yctz0nkOdPyimb0VZgsM/mY
			8m205hpNUb4k3RftzlTgFWjfkl2ofucJX1JkgzITx1D25qnW5xiia1sTvmwnyb5Xu0l3ueJLuk7D
			xLPWWO3Ofm+W3Lt928EuYMob4FusiZl4+0X4zrXGzXN7we4/CjnJ871a9vnLNMzKITRFSQs05QlA
			+Hrlegm9hDxLlQ2ewCqELemyIBvVaHhWc2hsxfadO38Fp0kGW5dUmG/Ma8tv42aozPVVGHZlzqsH
			zZt37hTo3t6+4b7y3q6u6IiIQRLWjCPCInmHux4Mm0k+r8XFS+priCpukYirrgI0Q/eCIrYuyUOe
			rbEYjnOyZKBhFdkcgZaNXtxsKn9IKScBVTqFWqbi6tmSrGy5hs0rVUs4AGKVWmHEvgrk9Xglz5bJ
			4C2VWT40eDe5WqD5sYtsbHRX0/47jbdcq7b3kfhoV8fu2Lo5LGjzzk33728HAr+9OywsZuvWzXA3
			NnbTVgq+iN+302J2E/iSoHSLcYJ4B/BP+9X9++Qvw6fCvK2b7pOHkL9owthB8LtjB6hfABug12mO
			PTXDyd4eYLvDQs1rzhaYIn0BvnYI31Y4wUbBcGI6AXoBxp4udWlJ1xrtneFlO+DZu3Ds3buX3MJr
			KQyDariW5ODgAJh2doZ9H2meZZ/kDKckgK/tEoAjKGsn6vM9a/jOX/luoNuXWYOdie/385fLVpW9
			TKMpFR5r7R0c7N1Wp3hoa8bHr18fyUIyXyXpvWh5Pv5B+9edVyMzMQDS76mU7wY6wynjCowbH07A
			15Lh6wb/RbM9IhdGExmeTcnJze4LttVPX2IgfQvC95PQIWJ2Hr38J/iKNaNbWpqTk+MfxbW4uCS4
			2NrZuXi6uIhqakZqRoG6o+PV1RfQ5/soPt6wzsPN2dPzp/P5t56otrO1qVHS9yUaLWxMk7jTSds4
			9RmTPY6uTQt3nmp2Jh18b3dis3uEb+fSkhKC34XDd8aImZhKc0m4207cvVjot7v7UvE5VfKEXzcm
			BgEb4OdYC+jl+TgG2Fn4HTP9/dYsVriae8x3b85WKroVipzu7s9XXc3s4GA1xSwlCEN5FjpM5TqQ
			fHpNqUaj4ajhSq/Rl2ap4X6prFSDib94VsqUMlmWDF+hyMm+upOg91eW086dlgXRjWZM9K3Py8ho
			M+Xk55nbzpsrDpnLK0719uYN9oof9PYNIm8jege78PYBIWyFFbYXJzOKLqKdGe3Nt4gWriASGK4K
			rEvykHPUcoAmsFOenQUQLc7OLtVoZfuwXqRcKc9WyCn4oqrlqTjZEg5GRHM4ep6cnaVXqdTZbHU2
			PtnCX+B1tkamyFZms1E/a/Tz/HGfF3wDbbEGF5utXa1Ne1HNcXBL3bFzR1JYWNrmGAq/a685x2zd
			DMr3/p7YHaB1AZ9wULQzNjYJCGd1xiNyNxHcbtpEeep/tZMCMczcAecdpFA3IBfhC3p4xybiykfx
			689sAJH0UxubJbNseQyWL6hdbwQoItObqF4iXAE7jli9F5Vv6wsvbGQynZwaQAfZ2dh5etb5Tmhe
			Crweez32wKAIPCmEQT/bX7O/5u3cCHeSrpHXUPStw/bgtkFL1qNBGwC8xMZmIULu2SlfWAmdJsBb
			Zi0yefVztist5d/W2nvYO69TZK5if3RyZGTkpLKsm4p6tNLXdCQy8vhSvBvm9OQJuIEMBpN548Mr
			Nwtv3vzwQwq+uQS9BoN7c/MkdVvw3IKddmEWP/gHd/PfNxisLRFRQ0Ojb4WEpItO1lweH8fzhRMD
			4QJpaGicC/z5eHKpa8m4cgJGzcmTNWOXq0cvgPz903/FRwuWu7nZO3o+twpXiNukKQyej835e+3O
			STNsytOaGU0o36nvMrXEc63V8Dy1iaD3Lkz3tdD3NqHvk8I3ZgosJ4ZfS0LCl1+3deqK9+sU3Vht
			oT2ZejyGVJCEi6eDm9dtH622xK9uQgwHPPZei/Cda42b59aiVHZ3Z8sVgOBVHR2utJyOFA7HBy3N
			Ekwy0pKixyB4c720ahLxDNMSknsE8yj3r0CAUVlwpZZIOBxaBwck1K8m2Purnda/RldlNtfX60z5
			GUadEetpmM+b88wV5V2DvcMPhoeGHkREoOwFFVzxoLyLah9IwZcUswKBaxbjbVdBQUUFGp/NyGF0
			/8JdhO9Eoz8PhT6bGI33yfYjQLP0NGAtez9oYAxfRn+vkkxiV2G1JEtZJteys7OVCiU8BscdGr1C
			nt1B2Z0tjM7J4khyEN3kjUt/bLOzLU+rpr36ilog8HETCrw8nFdu3+5awgraHHt/Z+z92J3bV6+M
			BXDej93z9l5AKMAX9PB9eHDXepu6XW9vslgl7k/4B5C/v7JYo3dawQzY3kzwi4qYqGJLAPvWmDBQ
			v4A3G5vZ2r8x/FGOOlPilRreiEwKvmh3brGztWnd2LCR6cRsaFgC8LV1cXEJSKNEMrAXeAvgfdtj
			j8fbsR6xHhR/4f327rJg3HuXM0zu8CYC2xvVsvM1+6S0tDo/P781QN+NTiCpGTbPGL7zz/Ol0zeU
			YVcjkm9kiXt++erVl5WA15+vXu3h7Op6VXH8yO/f+/i945Srl0LvVdL7t/tImemSYtXVMhb9KRJ9
			GXTmh7++caOwsPDmjYMHB8LFIinfAGOSuy1W6k6MZi6XOe++7Y+NQCaDFSyKGBr7bigd4FtzYXz8
			z5htBCP9SmJ8aJyDI/7/np6OTeGjVy6MXED2wpPGakYA0o8exUmFq7087B0d5/OvLVz5Ti2y8b1p
			vjNMzo0/AOBJy/JUr2/j1NCrGbWgZ5R3nqp8Mbq5xBW0L9V79869e0jfeft8GXMo3ynotIO//I0v
			/9puOndOpzN1wkXYbDcVqn6e7h6597xu87S1fi5E+s6uopctwneONW6e24tCfrW7e9XnV7sVNEEK
			m0ZjqzmRHdhHkEPBVyjw4QmwssY6gZeQ1JjkCbxIiUm0PvuQGpQIXUz05XDUHDWt9BeIXsuAPbp1
			ScU6M4pfWVu+2Vh+qL4I04oAsr2DD4YePAD2Dg4ODkcMPhjsulgAPCYW5v5EUtKqi6rf3HWetPMl
			qpeakYeStwCnClD+WpfkocySWzUraPFsdSkWucrOUcjkoHthphzPORa7slwhV2Szs8hUtqxUgTHO
			2TKKzfvIGZ8Ixydq8jJSemOeP+7zgi8jOFfFeTHyFbY2l+PDz13n4/ZzkLtLPYJ2bQfKLr2/835q
			6upNWzfv2LRrx/1Nm/a8jXoY8Bm7c8/u9UG+SZt3ECfvpG9gJ9qZUQdT1J0IltuxdfNmELxos95O
			DNcUn1ETbw5jMAG+s7V/Y/g726OP1pvYjYGghJ1ubruI05do3xaA7wvBLzQ0AHxfsAPygibyI8rX
			m7DXY++et2PXAn7Xxq6FM2B4L9HCe/ZarNE4dnhbBPGuXTuAwdfQ7wvqN2BNkA3AF+hrY/vjKF/8
			6zeUWdKHSDRVGZVMdLXspZdXvaJI+R9rl0Yimo/AwMeuvkyh93PyvOMKeOTSpe7Py7BY8hPDl0XP
			uHmzsDBDksHlhodHiaTRiYlE8cY1xTU1vTHlHIfnNwh7M7jC4CddIEao05kiLHH1SVREdNTA6Pif
			L4/UnLg+Mj5S82l43KP45GZ0PLg7NB+8MBp+cuQCZhjVjFyuOQn0fRQaHyflerh5uDs4PseuRpP4
			vTtnqY3ZhG/jbMT9XhDP2nJwSp2NWmueb+10u3PtrlpMOLpzB63PptsI35KwH8zCng7ficQg6s40
			+K6xc2lpuhv3xddmpK/ukqm93WBn5W6An4tLgiHX4M7P9bq9zmGqzxjeMmYqhxfNznOucfPcXNho
			dV7VrVSwObwUeQ7pP79KLpeVlrLRzIxdi/QAVi3CFZOPSPErUlPjRY7k55IXfVK0ri/io7/s+Ldf
			cn75S+xXH2nhLmHwTmvFdl0xoNfcloFlnM3mU/WHzh/KK+/rHRwaGgTkwvlBF1xjxchyyusLhO3F
			cs7DlHWZxDiD9L1o6WREKjubv4LrizATtG+FdSXwUGRR0NRI5Bw2p1SvASXL1ityZHqksFXOZlPy
			GIUwqaZBmZdJI6NsZQ5J9M2xGp4x5xejpqkn7p/nj/vclK+NkCuQaF1pWr5E68OTLPd5cSnAcXvS
			5re3R0a6Lt15PzZ2L9qbgZOxm7Zu2rt5D9A1FqXv29cC1vjuTttMxVpRlmSL8oW71O3OHTsoRXx/
			547NqH4plzHwdzvxBlO1Q7eGMUBa2s62C/b3JiFWQF80Ha+N9cAbj71uEzFXSN/W1taNoH4bXrCx
			RfR6Ovo62Ft8vYS8ZMR6gPAF+iKI4Rreac9etETvsdqjMRUDRfEO5x1JVNSVX0AQwBdDqCnlO394
			PVPlSz+OowzgSqnfvxAAw/mlM1dpqyJpx3O6jxz5rSXLiCIvsJdKToJnHe++1Nmdw3J6Cvg25BZm
			cHkCoRRGNIx4GHE4LKS1DLibjCe8EmRkcMWGJ10gqSHNjI4YAvqGiKLTR2suXMaOCYSu1Y/GHkUn
			8nM9nO3dhe/W1Fy4cqVmDB88eQLkb83Inx4+iopPzNr/IqwiC4LvwqOdfyjkaiHFrZIakxqnOnUn
			aTu9n+AM7TtHnq+Vvrvuge4F+gJ8O1PXri0pYf3gD/K48o2xIjNgOoNxRktCQlxcv5kqtN/WLqXi
			qvz8/BLsDbkCrsCQcDchwc8vyG+68Xq62XlR+c61xs1ze1F0dys7ODSOltPR0a3MZCs6ePrj+zQc
			LNZMehpxSW0NYmDGtntUDWSuhNK9Ppjk6+ODRE5hZyo7aB1stlLZsf1Xk8r3V9bdka7epDPX15uM
			5j7zoaJ6c8X5goqCwcFeOA0OVvQ+wJBn9Pc+6LpFpC7J5u0Sd2FuEZXJW1BhDXomDxUMV1wcpkQx
			NazfyQOAuR94KZOoNDwVR6bXsNV6eZYiJyuHGI6tvlyc2pczY2RbizrnsPFZxRN35TI59XD2jw7f
			QIYwN1fC86F56Hk+HIPqZ5J1rttf375t++7NS7e7LsWYZ5C5bwNDY2Pfvg+g9IvZsXXT/Vgga+zb
			12J8k9J27yDe263o0bUq3Z3wHIs72BrnvGknMT1bAra2k0FpY3hdbIyT7azw3eBPuXq9nXeB7EXp
			6gESFk7ocKT8vi4tdkjf1lZsL0fQ6+joYO/uDc+HsYci73144Vp4HUJ4xdpUOBEGv72HskETAYza
			dweenHc4I33R8rxmDVG+TkwizJ8hfBdQ25nO6ECn73s141G/OX78avzBida+V7uvlq16qYxNRDFV
			TnLasLiJr5bpOlP9n1z50jds4Yql/EQDEbvN8XHJQN7muHjC3iYC4TgUvYS8cc34rDhhRh+3jyts
			eLIlEvgyWHGiKKRvuihqtGZ0BJTv5fHx8UejYxfGL4xGRcGeZJ1W/+5vPj7w4YELoyPVY9U1J0+e
			HB1B+KYnCrOyio9qtLnPR/k6TJSVTPp+CM8ufB8v1Zz0WC2OWbr6Ns54wpQSkzOCnacwuOR2p9lC
			36Ww+pf4/6AF5zH4+k2zFiN5qTl+MQExMYjfuMRv2rDI/p02KcIX03odvb14uQa+gKuW8F1cKJ08
			Db9+hOB+1LstKt+51rh5bi8vv6wkGUQSjvbniFvMHJJweDwJqF308XIFy71WWxJ9SS9BmOlFyjsD
			jHmrsbSGDyl0hb0VUvAdfDgd//arKcO6JFO9rrhIhyU1zOXnTx8632U2V3RFAG97u7BPwoO2iov9
			IGKHH1QMW6OcUeoOU0bnLnHFsHXmA7MZiXvxAWV+hvN5c0GF2Wxd0tr9+ym8lgo0PK5ax1FnaWQa
			mpytJMTNkVOyNttCWhKZZbEwW1mM6pcSxpaHiVXa+pL9P3a080/dVQKV0G0pe7njCj0W4OYtj9y2
			bVtkStLuPfdTl2LE8/bY2Ng9m+5v33T//o5NvkExm7fu2Rqze/NmTOMF+CZh6DIJqKKyslEJb4W7
			mzZZeEzNxjCrHRg1jWZqeNtfoe8YBDAVmRVkYzsbfOn+JDx5114QvkTBUteIX4CvJd+oxa6FhDwT
			2YvoBfaioRqULrE031+RSqhLUXjF/bWp92Fe7NvwtYC4O64lOTujSHZuTEra4QxfI2krnFD51tUF
			rAl64adODQynH1X57sZY55rr4/8RcvRISdRIz3GrBRokbvdLL+sPH5PZY03nnKuWYGfK7lxmITDW
			xqpEs/PC1ozJD8CUJiYmEu9uHLIWCAv4jccbRG7IJ9+FoKGXaN7mRKk4Iy8jI6MNLtwmzw1PmO8b
			yMCIK1HIEIz09Oio0dHx8ZELI+PjD6sBveMPT9S8W//rw8f2l/7+d3+4cQWoPDJ+tnp0dGx05PrI
			fz0MiRbqZaUaVUZG8vNVvvNw+v7wmGDqm4/Na5yIrJrQvlPqXk33+k4rszFZ5bm29rZF+nbewe1g
			XuUlN1jgu4aqT+U3YTOe4bQlEc2eLQn8/vY20zlT2zd3pS5+CQ72hntC4W2eQFVVVKR2s3MhlPUj
			2LakLMGVH/XmZHIRvnOtcfPcXhQdKTxEJk/wS7ZCyZYplaVU8HJWlqxUJpOVYlSzHodGg1HPMjab
			rYELuxR4xtboMRAa54O61LNlbJqeE0ljZ22bZO9965LqjfWYX5SPPXvLzeV55RXlBbduwbnr1oOL
			XRVvPRgG0l7EuGbi2SXxVjBHTIlbrPZcYa21Mdz1f7oeYG+jW+QxDH42A4GtS/JCYmZnl0okNwWl
			Er1cpwG5C7pXrlAQpmZT5uNsuWbCtkx5fy2YzWbL0EWcrcietDpb9S/1gnnuEZ8bfF/I5RVyeXy1
			Whu5fIWru2CdRPKLFKDvNu/1QW/H7kq67xoLIpfIVYTv1phlaVsrwypjYsLCgoKCKmN8g/w279iL
			NmUqvHknyfrdupWKbt5plb+WYGiM18KQq+0E6uRCpQfvCZoj4IpYg92AvShbVwB2PSgti+LXGfHr
			SMJeXVqsohfQa+8O8MV2O/C01BWpeCboXXGfnFLhCvi7NnbPXmf7pKRreOXsfC0tKQYF7+4k/PCb
			Md+oDiOuXnhh48aNL/x4yhd3SUDW341cv179aNQYd6HmkwfFhL6flylIhBU3QhyaLpb2Rw9L4wTN
			/H7Bba1eUSqTF+/fn32cqrhx5Ikb/WGB0CaryCXG5WSC32aic+FO+iffffdwbLz6EQI4XnwlPz8j
			r60N2Zvf3NRky2Q+ubWbKQqJGBqLioqODh17eBkbFl0fHz978sT4wwujA0WK+o8++vWBgwMDo6Mj
			YzUI5rGxs/AMUL7p0dJs2O8UcjOCn4vy9X1znmOmnm38nmCrH4Bz4+MuX6vVebLA1WNRV427dnmX
			8Cj6mjj3vBC+8/vb6QyWDRKSMNKPmrDctfh0p0Q9JxgEKlO9uf3u3W/cvG7zeO2Ce4LC+vrD9Tpj
			LspkOyrYys7yRtSbUBPER8xiLMJ39jVunptKB4cD8BXwSjkdHR0pNBobZRTJ3sUQZkEuP9fLy1Lc
			CqtbCadk+KItGkUwPkj6H0kkarWEw2HrlaWRv3p9pvKtKjptNB1W1ed15QEuzQhf862KWxW9aGm+
			ODw8SMH2ASFsBDD2QVdv73BXH7ZROA947SOOX6q2FWjlBxUPKrpuYbTVLdTQU83OXsjHYk0WFz5q
			rqRUIeeokZxaTbZGLtOzOTRSaiNbpuVxZASpVmlrFcDZcjbx8mZPuH2tlN6HcnifbJ4/7nODr52W
			L+BLhRy9eiUnV8vRCiUC7Yvbvt22rSTIKSDVOSgGLc73l2KM857Y+3t2JG3esSetMiwtKagyKKwy
			LCygsrIuqRF5RWzPVBQzkcHozCX43Ull+FI5vih1d+5Et/J2i/F5OwmfXmZjM8sROcPfY9cuN/Tz
			AjxXpBIJizBdsWIFxV83A4hfRwq6loHsdQf2IqHxJanrUvFFqamr8YWEvx573gb07nIGwPr6JjnA
			BXTubuAwpvvGBIGs303g6xkQFAT75fVLbH485Yu7pJzjx38P5Lk+Pho/WlMdP/Td+5bw5zKsv/H7
			ocHvvov/Il4sLujvHw5NT3+jWZgYEpLek54eGh3dz8+oOip/CvjSmQhaEk5FhVTFxX2K+I2LJ/xN
			Tw+JGkMwjj8MgcnwK/l5KjhlZOSJMRD6qeCbKMJso4goUXh6yNgFNDzDOPHxiZqaA+9+9IeTNWM1
			IxdGQfWOVI9iBSwMdwaB/Kf/ChVzYYvTFGbkzmvpT9PVaCE+34Vzd4qFeZrcnRYDPSPgeYbf17sk
			lddpwpgr053bt9etY82LvqRga9AMyqJ6JddrppEXLi4JCV+0m00C/j0uds+5164y1hcV6YqKjF6e
			j8ll63tOvM2agGWL8J1jjZvnpsLpkAi1WqEXm9ZBo3E4Shq7o4ODXea1pM4GcfYKhF7IXhLpTLoL
			8oRUkwWq3KQXeQT7FHC1WnQWdyiVtNeBvq/j1QR8jUXmvHyjLr+voryrdzgvr6CioABAenG4K+LB
			cMUgXlD3PiBxVFR4VYUl1rm8y+IF7hu2Rj7fIuUlK8wFF0mqL1C5YBp8C9kaLYfLLeSqJNk57GyV
			WrZPo1BraEpQxGy9DKtG5shkymz2vpyJUlbZxFO832KbVuQosykyTxG/5CxXzdMs9xwrXKlcmvhC
			lV67nCbx+hlHqMqV+PhEfrvNO80m7M1U+7DdWF9j+9Lty+97Y1kNjG6O3dMYExNTGbYM+BvmxAry
			BWwBbzGemfL07qDKbljMzgTEVEQ0UBihjByeIO/rxAe8bFbl2+BPRC+GSgFI161bh+Rdt2716nXr
			VqyAw/hc4C+g1uBu727vYJ+MEdBE9zq7WRUy8JYAO3X56u3LEcCgfD28vT327nVOSqpL863DGld1
			visjM2kYIpiZ4h1guyYtLSlpc1pamp8fqUJpE7TmR1W+DPfjx4/UAGOug/4bGU9PfzQafmQi9/f4
			kXODQ5+EfnXJdMdU8dXgW58MSQW5cQNDA+lDA598MhQhigiJanpiAAJ7k+MJfKcFVjXHNcfHoXe3
			ubk5CqRnDQZDffLJGOA+PC8/Lw9NzyoD0LeFSfW7eJLB3ILSd2goXSSKTx8dIyFXJ0+eHIDrmvAr
			ozUjaIseB+qOjAKCH40NkFQkOAiIlmbtK5bpuUKXecm8J/H5WszNCXNW2HhS0P4ggWfMmxZvNbPM
			BowOU6cOay8XF+O1TlnpP5/UZ6x3TrelnLJrrOS1xlnFWGZaI7CAoQ5ffnG7XaVqb2u792W7qagK
			2IulfyX2LrPFWQUETChoyvG7qHznWuPmuamAYhVItDw2yDwFW5klkytkaEdWyrKVWVn7srOzZKWl
			pTJ5aSlbloVTWaVyuKuBG4xc2rd//z4M6twPg4ruJGmNq67mbJugr3VJRbryU3mn2oa7KiiW9lb0
			guytGH6A6Lz4x4sI1Ajk6EWg6x97K27BPEuYM9VUgeohSHobwfXFij+i0xcQjjq6q+J0l7XIBsI3
			m1vKNQq1WTKZigNfRa7Rs4G0WRINjS1XkryjnBy9whLhjBfFhAPY6t+Vw7z9OZbYreJJAmPC0Y+e
			56uCAyCBVCKUaL18XDl6N56XYR3fo2Pb0gA7/7Cgdc5Jm4C82123r9wemxQWBHiNjYXLptjdQF7W
			en8WkxGWlISVm7du3U3ZmndgRUmKujstlSSxNBYJrYIbeIzI3vvbX7foXlDCrqAuZzU7Y9QU8dYC
			OJcvXw1j+fKV5NaKX6z2YAD8InuTgb327lhw2GOtJcCKxFitW7185fbVq7evWw0q2GOXt7N3I4hd
			e2d7ULy+aUlwpEhTKs+wlUo2m01buefaZgx3TvP19Avw86vzq6urC/oxlS+j4YPjR34Heq/m4Qg2
			jRdFi0J7VMctBa+OHPltOUBWZ+rsvtRpPjT03VvivMToAeDxJ0NDA0M9Q30i6ZNXWnZiBSfGx5Fk
			3pYWKpM3rqkZmJsobYbJ5ESDFHN8kL4XLlwYCwkJjY8OP5iXV4j8bXJocnwK+Aai3RnoGyESR4em
			j42TeOeagQsXagbgtmYUGwliyeeH46NjFy7X1FwhEVnjIVFSAexPigS5uQzWfJbzXLoaXSO695lA
			eKrYnRrxPCPXaBby1tZqgboI3nO6c2Xnyor372PNq+HjDOUbYyXvmhgrNmOmNC/yS2j8wvB1O8in
			9jbAbr0Re7wWmToFji74+mlpReTNKBzHWGzQMXaLyneuNW6em0pKJgdF7itsml6PybocthJmYDYR
			VdNZQBooWKQwae5rqSmJ2hcfXe1DGjBwQDD/XKv9BSeFnZn5CuwMM19//XWCX+uS6s29ZqJlMaBq
			+MEwFcQM0tZMsHpxIriqa7Br+P92lVdcNF+sOH++F6Hc24XW5d48tD1b+hg9uPhHrGpVMHx++BYm
			+5ZP+nw94ECCm8FTS9RaiUov0Shlar2KjV19tXoNWwOPZhENix0D5dk0mYaYoSlhuz9n/z4KyYos
			hXyiwuQU2ZslZ+//sX2+tlqBSp3B53qV8vgrluu1a92EXj4Cr+Xbtjkn+W1k1e113f6669KlkWgo
			Tm10BqzujCXyd3NYWCULKx87sQLqgpYtidmKnt7NVKQVVc6KSiQiEpgqw0Eygrdi4av726mQ519R
			U69vXzYrfDf4A0FXEOvx6tUrV65cuhKv4Ho5ghjp60ECn4n7F07uDmhzhvt7LeCljM/rVlMvWg0z
			vEEWezskOaQBe53t7dN8k1yVZ5RK5csKpVKhVLwMDGazO1auRfx6+sG+IQ3w/MzhuzDl28A5fuTI
			B7//4ABi7kLzG8H89E/Sz1kLXx0/0icaeqsT4Ks7d7BgcEgUFTH06LuQkPjBoQgsRxWVHrfsyVN8
			GU3xFHwJeJOxdlVzYkZicxxV0AouzelRUenSKNFA+NgoiN+QR/FRV/JhZBQS6fs08I0TkZirEFF0
			dHTIw1EMrMKsI8D9+IUBYmMe/fOf/u94zQmA8YkTNdhS8OF/xUdHFWbvK84S8g0Lg+9C8nwnQ53n
			Mj8jNt+cEUQ1S+7RvOk8q7+4cUa41Uz8lnD2A3mPHTtWdkx3Lufc/uL9DfMq+0mUb9AsMVZWSzGm
			6k7OSKj9ApRvu6m+vv706dNVRp3unM7Ecbe180RPcYzfVPCuCZjiObaMReU71xo3z00l06dDwtNy
			2CB71QBQfalGX6pHnGp5WlBX64RepLYGunVJM0EJaTKoJXHPcNdnnQ/hsI+W00H7JScypYOm7OiA
			XaKc/e3rZEzAlzhmqeAp9OlSgcvDVLpul+UhShJbPL8F5+HUdQsLWlVU9BZgCWcYEQ9u3TpPPL23
			Kk73nj9/a7gCngLPnALfbFqW3qg3qtRGgSS7VF9crNZJONn75XK9DPTsPhm2WcjZjzHR+/dnKzWy
			FAU1DaOMXJOALTmbmmUdhMD7ddn7ZPofO9rZjqORNNsbVDdv8vlqDy0WPCG9MLy2bdu+3I/BSNv1
			9n3X7Xu9V4L8Xbr9PnHixm7CkKnGsJiYyiD/hp8ynDAdJywgbTOJVdpqiX2m8n+J9qU6MBDDc+xO
			S6kNS8IRXBEBvMTGZpY9AMOJMhqjcl06baxElq4gEVgelkKHlPkZztjUfSIwC1Wv5cWpHu7OCGfn
			JAcHxzRfVMc+HI6STaqSKxTdLytextszbBObberQrvDwtqlbUwfiOC3tR1W+dFblkSPHf3v8A2xr
			WxMePdScN3T5YfphS87Rkd8fHIoeEne2d4oP9hx8vzxq6AA8/F+h8QN9fQNDoxHfDc0r7GjWJdNR
			+MY3U3Wskpv50sTm5vj+9v44IoSpOs4CVUZy7roXVcLEqKFPRsfGQqLjRYS+ecJkB0fHJy/xHMgI
			FolEaHiOio6Oj04fA2E7UnNyZPzk5YfV6GW+PnKh5k9/+tMFkt97smYU2xo9ik8P5+7LlmcVaQTB
			zHlJ/gUr3/m4e63wfdN+7p6+83MCT7U3Tzp6r83sajQzx4gMN1Px/mP7j4HqPXaseH/xMYTv/P54
			UL62xCzsFzNpObby1o9kG00iNK3k3l+/+Ka9vd18vr7KrCo6V6xTeTlYWpDFTDlT7xYTMPmueLtm
			Mc93rjVuvhtqIItq+koncepOG0j/dOxeDo+wWFR/V7ymk+RFvCG/N+zUYO4G7JROeq8GYndVeAPs
			poZPZ9GZpLE7c2KtwemJd8MO74GW3rH4OtICfrIjbSALX0w1kbVeNli71bImuqqTj8eytJmdqPJP
			Z1Bd28l7Mkh3V0vTV4YTHXvJk2dYhuWN6bO2jZ11Frwd80eHL02tNwi5vNxCAVfr5sMRSgq5fIGK
			J3DN3Ja6vnK9TdAa79Q9SUmxqdtJ3tHOt3fswJgpYCeGOO+pDfInjRGclrFYlWt2U0WcqVhnND7v
			QPBakpDu79yz834sSROOJTWuJiKufnV/+wuzw/enK1YQ8gI9XV1dfwEn10n8Es+vxfbsZsCTO55Q
			+gJ7veCxdSvWraSeu3Tl6hUlWMsZk4ZB87qv/jc2W2mSmUwgd5UW/L6k6Fa83K1QAHxpSlNnJ42z
			AkOyCHx/zGhnBosG9D3yhwMXampGoxPjWpojxkL+HpFH+WZMv5ami3vST72fd6CnX9xz4P2IExmg
			D//8WrRI3C9Of/gwlPmkVZZhHd8SnZiY2BzfnNicmCjtF4tFUulp0Wh8QkKzUZjc1JIQF/VZfGJT
			YpODY1NTXKLokwuffFKdDvTt6enJyABoO9o82aJJyguzOT0Ek30jRCL4FKHjf3o4jg17H45fRrE7
			cvnCyctwgYGdFcbHz14efxQaKv5DVfG+bFmpTMuYX1vhhSvfSfYmTb87E75JAX5vLgS0MyzN04s7
			P5b4Oz3PqPHaZEtBK4jdFMX7z+0nyvcYQXDxvOFLZ9lOCtbJ6xiSM0Syj/z8rErY78t733xz++v2
			9q/N9WbV6aKiTq1XwrSI6DWTd2Jm3MLzFlON5lrjFrC90GeZWsCLHl8DyKOz7Dnwrwq0vNJyO+Xo
			Hh4NfHx/Ezjb/UDLJ8DUtsDHPgrMsq4TgZYPSp/r7RY+FvAOzzHgarlXLo9naBJIMgR6iZqnAvJK
			1MKM3MzMyLVvViY5+Nl7JF0D+Rkbu9QVU3P37Ni0F/i5M5aCqrd/gxM202Uymf6VQbsxwnkHJX93
			bKYwTFXgQFzD1dYdW3daYp9jJ8pt3N9+f+Ps8P0JcfIuJ+z9BZAXB7Egg+6FC9qfLdZnayN3ZwMI
			31yPtSvQTL3cB5ntmpLS0ZFJe+WVV1+lvULreOUVLH6qlAF4s2QmmcKkMylMCgXy92W0PKPzV4Fm
			aMyDY2euSKrzfXPJj6l8Yb1cf+T48SPlQ6GjY32Jicme0Z98EhISEsElQc+3v+z/pi0vvrxc3Btx
			qip9qHz05LviEydrQqKHui5dGrj8cAvjSVdW+AcSo6XSaGlidDRAODpaKpbGNSVGjZzFxkW8w4am
			JtFY9Vj1ZyNnP3V0NB0TNkcPffLJmCgxPrpnoKcnD9jr6cl4YrNzIIMpIvAdGhNFo+Z++PBRzUnQ
			vxj0jD7wmo9Ha2oOYLLROJzHqy//V3x8dNSHxdmHi2Wy0vkW9XrCaOfHJh6DLzxWGWTfaNG9jbMy
			droJ2np67ElTMn6tmnd6befZw61KdCB30duLJ8TvgpSvH+AVJKofOcVQN4S4ON/Pz8XPeicAuwai
			8m1vb1OZjKp2niA3gTxIaVvLC2IsuCayl7xZDPXGi8p3rjXuybacxfEsx3OrcNXqw/O0l2h5/Fyu
			SqjO5RgEzSqBhGfgNTevzExx9b7m6+vr7Ou7a5eHh+/bgElsb4ThyrFoQUZv7t40Fmm758RiOW0M
			iNm8dTPVwwgFMJVzROKtNpEM300798Ri1vDO+xavL4Ev2p3XzwbfDYyNQNftlPB98ReRv4h8MfJF
			C34tg7hy163w8sr1WpuLwc8genM9vNYRS7NrZGRKZgeNdkbJBvC++uorr2AkPo2mUOgUMplMJ9OU
			AoKz4KQ0KXXE9IzKV4nF1YggNp0xKTtpbI5H5Y/p84UdE93n+PFzQwNDESFDQ6LmxIjvvouOjotO
			NOwH+nZ+9dcv2qNDxT09fT193LyBngMH3m17/+OxofT09GHTuZOJTk/cXojOYEpFIqqmZCJK4MTm
			5ObkxLMjI5+h7zfZkNwcVTN69mz12Mhok8HBrdGhSUSqYsR/lj50IK8HlK+n4xOnOQVuYDXEpYsI
			fYeigOhNcaEhl2tGxi/UkJwjMk6exLDny5evk0jn0GiRqIe7r7i0NKvUhzFPb/MTRju/+YP1NeC6
			Msj9iTKMGmeEVk1geEol6Cn1rWbp52uF77Fjl4jyLTt25NLxc/OHLyhfCpkzRgyStK6uzjPB+ijc
			uCRg40DtnTvmzvbO2zzBvS/v1mEBLOuLkL8Bs74dGYs+37nWuCfccBfHMxzPTfm6rNVyhMkSIb+Z
			KzDkevL4yQKuAc7S4CbBi5nbVmLGjW9dUpKvg7vDLouVOBW7E93H/oCxe0DYxjhRHXmdAp2Ckrai
			sXkrZXhG+G6mlK+luS92SkJr807M7d0+Ndd3/ezKd70rSFdicX4x8hfkhFeEv0sJXn2o8CtMPsLw
			ZzJWrF7qmpnZAbAFpfsKW3OovLxruK2TTdN0ouSVg8o1KQC9WTJUvnAmJyWi9yVF9yrK7qw8owQM
			0zrZJnZnp8nuR1W+gYEs+r7jA59cqBkLGQ3piY8DrIr6o+MjQqKzjuy/8775r/cK0uP7Dvb1icXi
			vvL33/mNuWLwQVdo+nDU+7o7TEbgk9KXTt+Cylcq5YuRvIkk7iruAsY2JwJ8uSqONH1slLTTDedL
			dDLHLwrOvXd6MOS77x6GhAwdyG9G5fvTp1C+LIR/FNA3fAgtz9FxTaEP/4yLx+69o5jgBOi9fBmj
			nsevYxvfKJH0xuH9h4uqsrICGfQfLmRM/q3nEe1M0ZdSvt8P2R96cCLKeaoXeJropYTv2tRdj0U7
			31Psx3CrSx+cO37pg2NHYHKBypfQFk/UGbWrZ4CnPf/evXvCXIP93YQ6C10TalNd2+98dccoUAna
			72E954BJ3Nalvek7482mvusifOdc455sy1kcz3I8N/g2eHG83N0EAhVPy0/mNwlzg1uEuUJuriDZ
			IDRIUjJdIz1gP9Lobu/mErRrJaVT7++Njb2/fVPSXgAqXHu7OSxhMBG/TP+0yiDs8ksKbCCA0QBN
			sfc+1W4BVS/oZ0ttjfsWBr++zWmW2s4IXwq4PwcJG/nzX8A03IFB0dfV1WqHXmoJhEYe+4DgBfC+
			eoYMdmn9qfJThw6dOnRKLIroajMVAW2LQOvKigC9RTITAa+JXFD6vqyQdyu6QfOaTCB/qdwjvVpP
			uhr9WMp3A3Ko7vefDF0YSB8bGLr854ehY+8fyhdI0z8ZEkl0bafM9/7aPhByYChvOEoq6is/VFWf
			Lx4+XzFg7uq602njtJB+TDP+AUYyIDdaGi36nbRJmIGBV54JInS7joyCAj5Xb0xO7j8kjW+Oj49z
			cWlyaGpuO50v+u4THN89HD3UTFKUnnz5GzYwmCJRCGnsG07oC4t69PDh+PjD8ZoLGHM1Pl4N00T2
			Anrj4UjhD0WHs2VFRVWe82b+gpWvw5Ts3iQLaK35RW9em8Lea77rbdwpeE5LOpoeAz29ctUMuTvl
			enpvhSmVnckoUSqUKbdLZihfDLg6B9QF3XvsA5DA+5kLUr5+MRZ8BkxcXBIM/W0w2uHc3i74xvBl
			QgK28ax78177nTt36tvaeLfvNSbAS3fHkNfUNa697Rp5hwez1ky+2YRoxjuLPt+51rin2HQWxzMa
			zw2+rRyOvds6iUQlNAi5N1ty+U0CFV8gyW3ObWlK5rtnZm6LjIxtdHPwc3dZ5ruWhDxvj92xFyCa
			unt3UlJqB/tnpT7rch2ZJOrKyYnlz9pNRVvtsERdbSVJviTW2drPl9AX0JtK6Asg39axsfVx+DLo
			jMqU/7ntf8I5hVz9HCAMLHZ9EdUwwvdFV3LHOiLJVSQNNC9wF/BLUxYfO3r09OnT9fWnDw339qVH
			DPVVEdCWgvbNylLgBMGv0WQ0Gk06YnnGC1DXpCTDxDZp2LbPGL4LUr7UjyH6Ln7sQEjI4KORmsuX
			L4/1twmbxaK+ocN94nfF9765JxYd6InoD0fp+179udOnTn/z1/7Ory9duje/eoKzLhK+sRR9vZ+N
			VmPAE7Yzak5uSk6Mjhobi26Ob5bmCZqa8wVFiXHxzVjxCqtxRIsiEL2jo4Dfd1Eqe7o8xXpPZzCb
			gL4A38GhiKH09ETspvQoNDQ+9NHDyxR6x0fGRwl634iPjhYJb9Qfri8qra8XNCwYvk+vfKfCl9DW
			N8zGvtFS6erNaxO5RvazR2E9rnAnZ03tr9A4YYCe2lUhRZGTo1OmrG2s9a6t9aZEcImS2J0/OHfk
			EsheOO9vmNevMtXsbPHOWkF5VyhA9rZ9ldfe1g/4/bpdcM/g4GKXkJBw7+s77eZ6uHs3YYKsb9am
			pmR2YFOlEpI0T/RwzMSbUk9a9PnOtcY9xbazOJ7ReH7Rzmq1wMNHy9HwBFzQuwKVfp0XsyVXmCtp
			SjY0C3KXZ27btm1laqPnEk8X+zTfvQjN1FhMNrofe61xtYJUTinN9bJ3wqhyf3+nF9D9G7Z78+ZN
			pOAGZYDeZOkruMmaaRRrFb0k52hbZqb/48qXQaczl2Sm/K9MGHD1v1L+JzmlUMoXyBupjYRzCupi
			LVyl/BxvUmhnAL2vAH3ZHRz24aL6oqLic4fPnXv//PneXtGV0FCxOO+UyUSErkmHHDbixZyfZ85v
			6ywy6boVlAImQlihIOL3mcN3ocp3A50ZPBQ+IBIPDI3WDAx9UjMqlt5tShTk5R3tGzpg/utf732Z
			KP6NKFHc35ORn3Eq//3T77+fd+ic6c5tFhwVPeFKxwTdKU2Pjo6uqRkdi0rHEZ0enWjgC2+S6Cu4
			B6PvUJ8oPT0kPV2ULhKJ4PBmaOCTwdGh0dGhwXekiSCVPedV1mGOr00PZCRSQVejg+FRqH2jQ0P/
			Dvh969Ej4uUdAfl7+eGjeMB8YrpIzC2u/0N+4Uc3VMz5x3kt3Oc7Udw56QfgWxdW6Ulx983ZGvnO
			on2nKdxp1G2clmlE8DtteGuVObocnYKT6l2LJwq+aHU+cuw4gheV77GFwXeWYc9D4g63t7eRU3vb
			V3D/Nv9ugkvCl7fb21WS3C8pW3SAZ0BdXePtFOAubGHdndp7dXM5fReV71xr3BNvOYvjmY3np3xX
			61XqXINW4sUzFjYXqtR6A781uNkgUAt57k25fK/ITMTv0pI6BwcH36A1IFlTU7ff37Tj/s77m5xl
			MpkS6FvKk3g5oPT19/e3td3o/1NW0G7s80tk71ZS2MqSnhR7f8fWPRb0WgttbHfN3Jb5U5vZlO8G
			m1f/PfPfM/8/ckIE/6/MlJSUnyN/AbMw/hs5p5BpuOqg0divsM/QMJ5Zpa4/d+7o0XPnAL2HzxXV
			1x8q6I0ICQ2PihjuHW7Lr6rXKZSEsIjfKsBvJwC4zWiSKRRW7Cq6uyn8Kp+12XnhyjeMxTw4MCSO
			GLoAorK3ZlTYlGBoTuw739c30HOuvTO1hC/84ENplFh8Kj+vL+8gwPfUoffNdxoWAKEZA5jJCk5P
			jxoYjXo0emBgaCgiIiQiPUSUcfT3v/+DKBruDA0OfgKz4QFA7nfkPIRNtQcHBgd6wsVCfqKUb0h2
			fBqzMwx0+yJ9Bw7Ae4qi46NDQPlGv/UoPWoM4Ht5fDwkNO7TpuT46PRH4lMffHD0ww8/LNRgduDz
			Vb4Tyb5Jc8AXJtIq/TfapBG5+2bjm2lpaQ6P6dzGmcBtnIXOjTOVL3L32jTDcy2o36UKHYhfhS5z
			LSpfguDO/fuPXTpy6QOQv0eOfUDgO88iGxb4Uk5Za6QV6dMraCNxzV/3f20lcFu74GvBFwktX7bf
			MXmB7CXw9bR19C5ZCuz9m6kb6NvJ0TaSB2L8prwvdWdR+c61xj3dprM4nsV4btHODQ48lYRnEPBa
			kpN5Bkmhl1ZdmOvY0sLlSQQ8rlAgEWgjOxC/rrsc1jimhV27H7t2z/btsaRXQopSJisFNGn0GqGX
			J8ZcMf3DAgKC1jhV7sZIKyx4tYnUeMaAq53E0hwL8/fs3P768vt7Yy3w3Qbv7z+rz3dD0KsdHf8b
			Tv+OJzhndgCDU1J+lkJoi3I3JSWTg7NSMjvYtI6OMzTgbietU99ZpTtajJq3+DDBb/HRo4ei03v6
			oiLKy3t6XwuNjuiqL1IosN5tETE547nT3NZmpGSxkjJAkwwkpcLW9kfM8yWDxaAHiwB/B04ODIzW
			1IQmNBkcBBl95b0RAx8Vm+40lpTkfvCBOB10fQbAVzycnnfw1PnOBibrieG7gUlnbUkPGa0ZGx2F
			hfYMWfArOve7I+8OYe2LgQPlB3oGe/oIcz/5BM6fDPaI0UKdGJ/clNzk2JRs4PObf/rkdTbIasCM
			RvpGhecfutI3JEK1LcLY6+bkprh4GHGJyXCdiLpbfPjYBx/8uufgDSwE8ByV71yhztN9vsDesI3+
			lWvSALww/Cr9KwMcrk0XsrMp36lYbpxG3antBKcUt8IzGp+9XZUKXTeclJEllPr11u7H+hpHMM+I
			CN8Fw9dvKnmp64S7X35xD0Vvf38/4Jc4gJG/39xNuHtH05hgiW/2rL3turSz81sQvp2Zd7S3b9++
			V1s3e/T0ovKda42b//5hLSu+IdiXyWTuxgPP7etcmDgYzJ0MBrMBpp4+NdYyAhnN6+pYuIXBkT0j
			jsEM27wBzZ6rhQGkCgaTuZdFZ9IZ84su+N7BbBIk4UKYTswwqthHg1MgLMBF6BCGZTmYwcyGBpYX
			kxTfePIauj8wnpvybWlpsfcSJjfzDQIHDZ/LM3AL9TwBSN5mAZcrbMrlJjcZJCB+M7ctTU2qc6hL
			27V3r3fs9vtA351vK2Voc2bjiUPzYbAa/BlO/gFJ19ICKmM2U+lGVJHJ+6RtL4ZWxaZ6N+6loOuN
			77N9+9Jt6Ff2t50t2plpQ9BLsRdPmZm/BPX7s8yU/4mK9+fk/DO4/zOSQtT5Co3N7uzsZHdqOouL
			ieg9fBjl7+GjIIHfPxAaVT4Y0dvTB9q3vLd8cPiUTgY6QZGlM1UZqWE2trWZzUYrfknuEUzIn3WR
			jYUrX8xCZ6QPvTZw8mTN6GhoesualrqEpraengN9h85d+goLLPA62/uj8vPE6aCQe0Xl5eVm5hPH
			OZMlBrLeCIkYGB04cPLECaDvJwS/EaLwg4cGh4YeDIHMFkX39fUNIX0/IQSOiopKx34LZJAuDM18
			Lxc67FyfYuVnMPiiEGxwFH7gwEFMOopGGic285ub45qBv4lwio4G+Oar1EXHfv+7dwobFrS4hSrf
			pIlUo++pdQVSNy0szJ/lv35NnQOQ2N4X7i1Z43jNfrp7d1qnoloKqiSYeYZvdxqjG2dYnK34LUH6
			kpw52lovwt/bOcf2nys7d+Q4cPcDonzn99/PbXbG4GVPl4Rmfi7/SxhSpO9XGH31jeCvX9zlsB0R
			sHVr1tSV3IkkfYQvdd6JdHVt18K47TtVQ0+OReU71xo375WYmc5o39EUluzLTOKzALmsxLAWZ/8W
			A3NzMN/QkuDIeHoUWgYrLoh5l1mZsMXAcMwNi27yZFYG81ksxl6m1L+Fz9jijIv0bmpKewbw3cxI
			DouzZzryw6QlDINfa6t3sMSeFbyV0dTaGtTkznrDLbgtyYHR7NlQyQ97Vl9w5nh+qUYCg6ekKTlZ
			IJC4e6m4PIEANK+Rp2pK5vEyDMEGlSE42d01hdietyc5Ozr4XtuzJ2lvaurbezftUZTKZMr//rJS
			ydbo2T7+/kyWE8M/IK0upq4yLAbQm7RjJ+lwtJWq70zSe+/v2hubGrtnD+YLox16OzYPft31J7On
			GlWi0kXLs4W+aHzOzETXLyV6Ozo6aK92vEp7pYMGpzOdNHankchYHVIXLqeBvcXI3vM96fGi10Ij
			BgFK5afKK/LKyy8+qCjCoSs6XF9VbyxUAXc7jaq2PLPR2IlvYiGwUvnM4btw5YuDESxNHx3AUd7P
			54ub70oPgeLrabtj+vqL2hLel0d09/Lyf/2+9MA7fX3Snr62YKbTU0CPsQHgGwHy9uQ7v373NwcH
			BkHbjmGl5QgLadHnGx0qEqWL0O783VB0fLQoIj0akAjgdQDwOmL5yaZmT8ZTwncDaN8o0L5R4QcP
			nDzYExUFy4xCB3M6UBj90DiiuFxYiW8ePvrezeCFebmfUPl+f6YvCOCAMH9///VL1nja2ztcezMI
			4WvraG8/w487rYAGCcRqnBLbPKV94PTJWeiLab5AXwUeUOpoHZwSN2+3EsX+4uJzx8qOENl7ZMHw
			jZk0PE+zPge4wPD09Lxr4H8D5K0A/qIV+l6n0sEC1LsUejs772hdl7rekWhv81Y41E1XvFYKLyrf
			uda4ea/ErC1Ltkb2x8XExdwP1jJYO8O2xOxtidWuZ90XhS1NDOI/edzlY5ujyL/lr+s3sdKadrsy
			edG2icG7tRuTWMy9zDcCdqzZmdnacF/Aio0OSnx6Gr4BeveN3a07JKzIN1jRMfwtO7Zs1rIYW/wb
			mFt2vOH7xuakLZvb4etVvhH0q+A9z+oLzhzPDb5BGok7P5mrUmmFTV56Pp8f3MT30uZqtRJusjCX
			l2toakp20WpTUpCRkbFvOvvW2a9wdt7lsfbtpGvKUqWy49tvt2VmvvpvpSuDwpjrbfzDAoIC0gJi
			6mKuge7dTLl7MdUIJ7Cm1dq1b8fG7t0L+I2FkbrdNRKovn37T2ZPNQL4/q9MyuMLqvffO16hEohe
			sdxaBo3WwaZ1ngH1azKa87Budz1SF8bRw7DrAel7ujz0tddC03t7b/WC6O0tKCgABOf1PsgrKiqt
			L62qLyzMKLxpzM8D/BaZ2/KBvmZVp9moUhUZifP3x/f54kpAZzBFB072iQZCyof7c/tPGdqlzcmJ
			/V3mNlO76Qtd7f4j3XeqrpwS//rD8ogesQANNk9hjGHQA+lviIbKD+TfyL9x9A9YuPkT4tclDt6I
			IZEoZCwkPTQ9Au3AgF9MA4oWpUststeROnl6NrU8pfLFqq3NWOVZFBXec/DAgXcO9IQDicVRxBcs
			Eg0Ag8VcFXYt5aqqPioMXmCI2cJ9vg7TqDsbgIGjDpX+CF8bF0d392v2IIM3blxi62nvfm26OXmC
			ptem1K2aKoindTGaXfrWWiOevRs7rBELbAVnbYm3d+f+4v3HQPoeOXLpt8eeSPlagVk3Fb91fi44
			384xV/jNX/vbKC9we/s3nbpr1JPr7t0B+MLp9u3bX93R3r5XW+JWl2YFbkzdovKdz1jA/oEhYElT
			mypb/LcztSzWzkBh6y5mjENrzM7+IP9ERlzYM4Mv/Y00prhy84atb2yOZHGjWa8t2/3fWM4I3/6G
			rcG7r72xOVbQuiya9R/z6mryvYPp0cB/Y/eWHSsZd7awElkuW3YzAb7M4LWML7bsfiMmeP3WLVu5
			CN+WoK2MXz314uYYzw2+/j58rSBXIlGrJVq9RtAkaG4ytLYYNABfZouwsJnflCxUqYQ+kSh9t21b
			uj3V3aXONyDI18PNOSlLpkj532R+5P3/4ZZW6eS/PiggIGyjQ1Kdr2/Sbqx2RfoHYidBOGFaEahe
			79pYzBO+H5uaGuu8FF+83bXjp3Mo35TIzH//36+C5n31lTMvv3xmtvEKWpzZbBobiGmuKMDuGKdP
			Hz5XZMHvufLh+P/4j7ceDA729naVl3f1lheg9AX2nsrrHc47dbMQTvUwQO3m57e15+Wb8/LMRYX1
			ZrPKnK/KL1SXZsl/1H6+k78HEw4ExYZmaX5Ef7tQKhLnSfnNiV9/1ZZx+tT5ttO1Kb/9rSQ3Ttzb
			19M3cCCO/uTFNcjAmuwtiYnR7x79SCzl/jpdhIIXznn9Ed9FhEREiKIjPomICI0m9I0ISY9vbm6O
			F0X1E/Y6EOzixbPJ5inhiyBgbhGRIe7ruXLwwDsfv3Pg11fCw8XiK+IDop6+K9wbGdgTXMrLuGlg
			Mhbo5n5i5Tt3OyMqxxfYC7x1cXRwdKxbs95/4ws2dgBf+6mK1wLZN/2CyPDDxh/u7o1TXbxTJfIk
			kGeqXkt9De/VSqJ8SaQCbXlJiRbYewkrXB058ttLTwRfQsu6aabiGIq/dZ51Lp53v+TfE7a3tX8F
			J2DwfmeK1m9q7+C4jcNVe+f23YQEF7+Aqcytm/QjLyrfuda4+W+tTnEsZhijJYD1wjUWg3E3IYzR
			6stsSF4f058gaWUFs56ZS5TFCE4IDvNnvFHpH3uXtYURzFoWfJdFZ951aGAEb2Y0eDYECBKWbmEG
			P12oBw5mcDOL1eLHqGM4bnBgJFcyw1jrg/0CGbC8LeS7bqlsbfVzYbq0MoKYu5/VF5w5nht8X2hZ
			l0JTqXzcJBwOR81TaVW5La3NuRKDA68p2CAIFvCbhJx1glw3LbE8b4t0Xeq8xsZzSVAa7EW0pQqK
			yVt3LG30qwsI868MCqr0Z4UlpcXA2Jy0dfMmLGZFgp2xINbeHSB5vffs3UUonJq61jdy2/bIbZGZ
			mU5zBFydOfMyQBcuOGEZfyNny102jaYB9nYiessrbsGpouI0cPf00XPnzueF/kfcf4QODg8+ePDg
			j398MPgAhG/vMCjf8kMFhxDCvX3Dp4qKjEVFuMfSmUzGemNeWxuc28xGOOWZzXkqc6FR96wDrp5I
			+cLByLJARoNDa2vLQVF/f3/IUPvX95q/+UYsLu/vzxPnC0tgByt5o/9AhPiKMJhOdmhPgV8GK5C+
			MZnXf/Agt0/EFwP50NYckch3i8DAq5DoRNC5ouhocYQIpK8oDkttJIvEIkr3Ojo2eVpG8NPDN5DB
			oMKuROLw8IyMKwffefe93733m49+89GHhTerbhRWoc1ZKBQKeMHYYuXJ4Dt/n+/3AtiazEuUL8DX
			1mb9Rv/K9UtsbG1sXTztne2vzRwA00rsPcOg27pT47EGvtOV70yzM6L3GgVfb63F8CzTKeXslSW3
			MdH32DEiez9YuNl5WqAzmahDuNZhRFUCGZ6eAGC+kAq6+qbtmDdF1nuoe9tv37udCvRtv411ODz9
			AiZkr1VE1y0q3+8bC412tnRCCAxkYFcCqrBrMC/oaXYDswzKfwwH5/ZkAVNaLDBhSXDjwlv/xGGe
			01fDDfSpa0XgRD8H6u3p5DCbHkh/4hK28xnPLdq5pZXTwdFweUIfCchfiVrIFTYbJCqVQKiSCARq
			0i5OJRAk52olKSkUaSNXO3g6wHH8Ekf3M9u2/fu3kUDPbVud1yyrrFxWGRQQZMMKqwQSB1WmeTcm
			bbpPpfje3wHCd2dtnV/Snvtvvx3juzY2dldq7NqVmdu2u2a++uoZgO8sPx8j6KUzFHf/9vIkeadw
			GFskaDT6zg6N8XwBjoryQ6ffP3e6/vS50zDOF4jf+A9xKFAX8DuI9H1wC5iLCvgWMT3n9Q52na6/
			ebNIB+jV6YqMxqoiEMF5yF9UvkZjXl5FXpvxx492tqyNuL6xbILL+/r6IiIGetq/+fqbr6N7+vrE
			MCNarAL6SpsSE8Vv4Nr5tBscENPGTcYTSqX8/gyeKDoOrbzpcU0tEUhf7J4QHx8dLQ2Pwgjk6Djs
			+wtPIWZn0HqOVvZ6vrCQNitzrKdw4MHcIsWkI7FYHM7NuPKHd957993DxUXvfVQE8AXZKxD1CwUu
			uO0v9HsvWPlSYVbfp3uJ8g3z9//pxhfWNzCdnND8bOfpAirY3s2SJTThxMX7byJ8Ab+2pCu1uz2Z
			aVW4szt5pwZaTa3pXJKCsleOVzIFe6WHaf+xI5eOHfng0nzzfOmWH3wi1egxBFsszwkJd0HPJjgG
			BODkPQx//mtnjhtyue5ueyey9xuifO/du5fgNzPJd6qUXlS+c61xT7vhbEAgPr39d44xhymbGTj/
			PL+nHFboPs/FPb8iGwaBl1bb1CJw03LUepWKo5eoClUqjYSfC/TlSHgSHhf7LWvdvHgSQl9A7dJG
			d88XXnBalrot8vXXX4erba9vc929jLU+LMg3Lakuxs8XGOyLXcNq3ybtF+6j3xevApbYOTfuWXst
			KGbv3h2xqUszt7lGZna82qH8yZLZ4Yuad6rqtQxy30SSijSdnZ1Gk9F8vqCit+A8Qvcwcrce1e/7
			75+OCI2OGBouB+ULJxggfcvLC27dunhxsLc3D7TvYNchVb2uyIT0hZPRVG8y1efnoQA2m+tVVaB9
			K/Ja/xGU78SvwmoVl0f3i4cujIrzvrn912jxQcBvT3NyxNjQux8ckRpaGD95RuvdxmRuhkAa3XOl
			Okokio9Hv2ticoKI2J3jo0HmSvvziq5gzFV0YnxcM1adliY3JTui8vUE/Lq42Lm4PGWqETXg2JbJ
			bEL6SkUC4O+VA+989Ouq+o8+vHGjKkPAI7o3+clCOhfu802aW/Zee3MqfJ1+8hNsdu3k/5MXELye
			2BPZvbHRfmqcM4DVHuAbBieAb7M9nhsbJyKdG2er5GzlrtXdayWvc+0u71SaTKbIkssRvjK2j4RE
			WpWRKhvzhi9KjFlSjaYajf3qvrx374sv7969W1sXAPdcvhS0Cwyq4lq/NODyPcLe20jfyMjIO9rG
			2eKsrBK4blH5zrXGPYMt54l7mv3woM/OWNJb93kt8//9eG7wtdHw+HxDsKdKy+Pw1CrJOgmHI1EJ
			9BK+AEtOarlCgZCrBVGsFXjl+mDYFaA2MjJ1he9PlqUBizP//f8jQN72emRMWENYWFBQZVBdoy/e
			BAWFBaUlXdu6g5iesaxk7I7da5bY2gWkOTun+dqnXUtFzdzR8cqrHR3LHle+DCt8Z2LXMgfByyZJ
			uaUm83kUvueRusDcw+fgikjfQ70Rr70WCkINNG8EKN/Bi72D5b3lt0D3ni8gducukMSnburIMJ0G
			+prq64sAwPVmM9AX+Ntpzmszt/yDKF/yuzBYLGazWNzfd6FG3H677Yv2vv6onihpsiHuZM3AO0eT
			MQXvGa13DYYqcWKi9GRNzWh1VHSiKCIiWljFReEbNRoliurpO5jPzQANHpEuBoUM/I2OjsYM30nl
			6+fi+Uw2RAadwWIAfhPR8ysF+vYcPHDwyqn8g/k3uAIxCF9pE5PJmF8nhZn/1lNEOz9ucp4YSQhf
			eDeW/7Kw9ZUgfB0MyZj47N745lTnLcGqRfkG2hD02ttTvJ2s4Xzt2rW5de+0bkbetd7r2HIlaF9s
			IALaV1u8/xLRvpT0XTh8Y+oeIy+F34TbkvZ2wV8T7rnVgaxNc0n4kmfQ6mr96urqSjDS6hsYt2+3
			A4RLGgPq6vzmHovKd6417hltx4vjKcbzU756fSnP0MID0Lq7SQzJuVq1WsXNVat5PIFE2KQ1tBqE
			AGYeh8PJNfA4pLjj65GRrivdlyx5e9vUsWdlmhOL5V9ZGbZsSVCd7xo0Pq3x803bvRvhux3zjHa+
			7f1mmq2jnX/QNe80P99rkZnbUPfSItdmOs2pfKeRF+4qUfOeUbJphLwymVIpqzJT5AXi6khy0blz
			RUje84cKuoZeA/oO9gJ3H/zxj4MPBkHw3rrVe4uIX2KCftA72HuKYi+puFFkqjLBVX1RFVLX3Jl3
			2pyX9w/h8534VegsLLmR2HdhoO0r8xWhaOhg36C42WF1q/iUoIGBO7Jn5eOhfylNbE4U/ebAyZrR
			AZEwHZWvNDwKdO9oTZRY9P6pqnwuty8iJCRdXAQQlDYnRktJjtGk1dnF81kdeLNYdGwbTeSvSBw+
			cOBAT09Pxk0ukFfYHMx8Ys/PgpWvw3TRe+3abOylAq5+8hMnVlgYHpSC8DUYmpsN/MZpiUONlNk5
			jMCXBfC1byZmZ4tl2mKWtlwmxrVpBJ6Itqr1hvOuXa5shYW+Mjjrjk2MI/Op7TwVvlMtzchga5Qy
			Nf9uCZaavP3FPUMdbu0uCXyexMTzck+r1Xbe+ebevZJ7oI2/qMUWR3V1AVPfLaZuWvrSovKda417
			RpvO4niK8dzga1uq0ehVQpUkuclRqEoO5klUarVAqNZLhMlcQYvAYBDyJRkCgUSr1Uo4Wh+tJCXS
			1fV1V9dUB8/Iqez9X5Fr05bBob6/XxocxcPG5eubVlcZBvSNSdq84z4lfXe+HVubVGLvuHH9Lucg
			3z0gfCM7OjpSnV1pcyvfGboX2Ms+w2abNCh5lXiuN58vMKO9uQjpe+7w4aOoe88fOv/+eXN5eUTo
			a/EhET3lXb2DDyLQ+dvb23vr4kXg761b5bdABfcOP3gwfOgwYhfwWwQ3VcZ6LLphRuMzJh3Vm/9h
			fL6WXwZkIJZ7CW66d7stXDRwcmC0j7vOwa6ygcmiMxlPGeU8bSQ3NzeLBg6+e/DkwEkpH7AXHnXl
			ZMRQRHrNiYE+8eH8wgyL8pVm1B+uz+CKohMxuXfC7ozjWX0WclDBwhI6LcnwUcKvHDzYk1EoEBpc
			mIFMrGj1hAr7SZWvpcLGtUlf71T2XkuqJGbnn/j7byTCt6nZIJXy+W6zKFh7At8wVqAtYS/Ad0Zy
			76yJvRZ/LxqbJ2Rv7a4S75ISLVBXCfSVo/ZVYMQV0b1Hzs0n4GoWs/OMWGfLbYBfQsIXVIZRblpa
			gF+dn4fRdKx4n4J3u7P9iy/9gipJdDNguS4gICCNMlbPFNJ1i9HO3zMWUIQHg/wDSbQhi74hkIGl
			8TcwGbBdwAkewNwH2HQ2UA8FYoABnZzQLM3A7YrFYjLp+CRMUGQwGaw5l0SHx+iBeNqAS4QzWprx
			LRjkDQKx0lUgBkvhdgkzMVaUQeKiYEEsrFUVCH85KUPHoH9PbgIuiY7vDhs4E/d5+NWw/ySDeu0G
			+CDw8em4LPymTFwAk3wcdFThknBBuEB4KvwwT7SLeG7w/Ylew9ZrtCqeUCBRa5uCBRJArKA1mcc3
			GLjc3NxClUol4SVzuRKuRKLlCXO9JCh+ly5NdXfLzHy1A5NvX33l1Vc7Ov7t31wDwvzDwiphO6wM
			CoqJ8QsK8vUOqPRNS9vx9qYdmNUbix2AY73X+Nm72LslNS7d5poa2bHUNTKlg73MxmZu5UuJ3TOm
			vylx2nQGkCszmUoVCpNCVm8uLzh/7ty5YoQvshfzi06fPn/+/UMF599/v6DvtVDQvn3ltx4MIn8H
			B3svIn2Rvbcw36i8AGVx36mqKgy2Olx0uB7Ii3duGM1VRnOb2VhlNpp+/K5G09ZJqt8qK5BYYpnM
			4GC4gnUS7liiAJ9R/AGdkdwcn3ilpubAwY8PHBD1o+LsOXkyCqTvyQMHT2UYMzIyeKB8vwsRift5
			3JuHD/dHS5uTAb+OnohfR0dfT1+7Z/VpCHzpJBCXgYXzgplUBT0GNZP4mp7kfZ8oz3emy9fasWiC
			v41J6/0bGja+8MLG9etbW1tampKbE4VCaa5hNvuxg0X5Anzdmy25Ro0TZufHxO5ENeep7QO9a3fV
			lgB+S0q813IUSqVSBvDNAvrmYKaRpcbGfuYP7n8m4LuGeHaJ2LWEOFsnqbvwSF1Cwpd/vffNPaHQ
			3dHBXqszdeqOFecUm9qF/OQmF08XFxcCa/L8GIuveOLNKBldt6h85x4LqHAlNYQxWVhNljhf8BCV
			xUhGaDFY5IAV7uNGAwQLbIBZLGdgFcsACNuAexEgmzcjkcUiuxEY0mBG5VzrR7MhAN6XxcInEpLC
			W7Y2wCy8i/eZBONMDJJEiLvhU5rxrfEeTBsYTaQDPL4Bs7m1cs4lBbsn4eeHT+/EbHBiNDBwpxdE
			ltEAXzSMhe8MS6GzsJwlk+GGXzMZl8Qkn43RzGgIIzoFP0hcZZDdk6iS51fhSqNhszV6vVqvMgib
			bVuWS1aoDLlNTbkt9l5cCY+nVnGBy8EGHlcl0UokPEMy0Jfg9/Y6/ZlX//3VM6+wz7z67avsxC1N
			yz3XLwmrDKtMakzy9Y1J8/Vbxkry87OPaby/dG/Stdo9tTuwnPP9a767nd3SnFNjt6UsTeno+EUH
			LeVVxbJZzM6BdBLtrESpe8YqeWlskL0yk0KpM8mUuqJD5gL08p47pyP+XnT3Hj5dj7rXfP786VO9
			6PN9LWQoVJT3fm8XaNwHXaB8LxLlC6fy3oKCvPJeoO/w+zduIHTJpQhvTxnzYRp0cKnJVPSPpXwn
			187pltZnHnBPp2/hJ4p6Bkau9FwJPyDCdCPRoY97xKKIiPff/SiDe1NlgW+ESJAIGph7UxTdLxXw
			KcOzZdg++zSAQDwuCLR8xAUmFj0+Fqp856woaSGvhZxv2jQ4NTQsCW7dAidgb1yzlCsWCg3WUClr
			aQzK5+uPypdu42A/Ee1sfd5EqHNtbe1EmBU1PT3OmQp2LinZVVKyjgbKV6aUZ6PhWbHv2LFzIH3P
			EZ/vD0pfK3zpayaDqyiDM6rUOitD4RQQ4OmZkNCUnNzM50pyl2uO6YyqomMotNsSpTgMzU2I37q6
			qczGl++eiNoiMxaV71xr3Pw3CWlCg/29pjRP37imOiemR/NGezdWnGOSh+PGjXvcWAZmkoOHlOnL
			MDjaJu/KTQhjrfgy2NHdzcvTgZ5818aen5yQykj09HBPCNrllpBQ59XUmjTXopLTnNxzm+oc3Fpb
			Pf2YHsn+OzxYWxzcnJtsg1bwWc1h9rvcDIwklsHTxuBmcNzN8LrLSDY0G+qcGS5NQXv4TZ5CRpND
			7t2E3WsNGxOcc5ODaudCYrCnjZubra+9G6PBz5Hp7hjg4cZiwis8HesEyaymsNy3DVsYHowmT0+D
			W3NaEjPXcY17c3yCYy6rJaHOwxDs2E9vqOXbJtjnNjckeEibKlc8Sbbz8/T5qjUaPeCXl8xLBt0r
			WafiCCQ8oUGr1XK5PLwIBU0ClYoD8NX68AwO8ECka6QrLzyc/e0Ztf6VM99++y07Kqqa72VfFxAU
			gMampMY0VmVdWtB6v2tpaUne27fHel/zdm5s3NW4N3bp9u2puxycU/fcz0zJzOx45ZUztI4zCn+b
			WeFro2QjcV95hY2iV8nWaEylGI5cBKJXyS4yd1WA6tWB1i06f9qEivc0gfD580BfrKTxANgb/9qj
			iNCh9IjeW4OY7zvY2zt4ixrlMKsXa12BJO7L//DGqRv1oHsBvEX19UZjvTEftG9RsQ4W1/oPpXwn
			xvOHbzBXHD5QMxAuihaJxeWY0CvtgamIiN8dPczNuAH05WaII0LS+25mSDMyuFxRT6K0kCtwp6pb
			AXodHJ2eSw6e9bvSnz7H72krXE04fO3tHewtA4hp72lrY9vS4tKCowmEL/5AAj7IWjgBNN2BnHD5
			0v1L90YHfyrVyAZ0b7O7wX2a1qUQay1iNZO2lLUZLm7eX3iXuNV6l5S4lZTcZgN7lWh6hlsq1Zf0
			Njr2w+XuJ+AbgKFTdUSi1lnYWUdm+e0mD3h6uji6C3kZcATWx83gCbKO6cx3TEeOHDlWXG/JCuvJ
			EPCbE1yol8fUTUEw9WYxdYvK9/vGAlqOShtaWM0Glq1v3JaWSqZ7q21QMyuOscubFZOb7EAPvvdG
			mEEanMTwaGipW7GWFcMwbHEJivHOZa5lerXEhCUaWB4MPsuL3xq2OS7RNij3DWbMXItqZm2pTDaw
			/NzgmDKJ6eYUFJPMamXw3Zhp/BYPOpMfHNMErGflslobDYkNSQw3RlCriyGR4cHk28bE/EciK5eR
			wGrmb3kh6Y0EWz/DlrCkOf53ZjAj2K/pLsuFH9wasIOZy2hMigtjhiXmMktyW7xZG9ycYrbYMtay
			+KxWt+Z4xq5AN1bd3ZYv4wL5zGab2qQ34vz/GhZc2ZTQEuAebBe0OzF42b1/JLNzoA1HrdfAUKvU
			qly1Ws1RSXwkEm2zQCXh8CS85BaeRMgXNktUEpWKmyHRanm5Xi9quT5LX+X1hGcooz57FB915tsz
			4dVRYtqrmSmpdZW+vgFBadeuBYVVpiUlpW5/OzZ17/09e3Ylwa7EY1dSUmzs9qWuy2Nr7293BfjS
			XkFRe+YVxbJZ4csM+u/IXjYKXxhsvdHSf8ikkGUV1ZsLCqgykjoS2kwinRG8QN7T508fev/0+72A
			3tdCQ9PTh4Ye9PZ2DXYBfi8St28BwLeg/BbQt7e8PA/LX+XfuJkP8pfAV2cqKjICgQuN9ab9uqJn
			XmTjGSnf5z7ojKJTIHqxl0G0qK98iCozdbCvR3S4qJ5bWHhDVcjlcgG+GYWqDClX1R/dl8j/XVUG
			LxfrbCB8HR1+7O/wg+Npo53tKc37poPDXYe7yeRinwwAdgToeno6GJpBGhpyhYKMwgwuL9fg5mYw
			YCENezxbWA3wpWOqkQ3qXjd42NmdurjXWi6NkydAd62BnKgbNzy5GbzdvA21AF5vb2BwyUrQvjKk
			L8BXVnwMexvhKG74wWP/Kcq3zm+qydnCzYk7Lk25qlJYD35940pPeB9X9YHOmNdm/OCDI2XFRRR8
			+3p6+sT9ickunhZyw2k3NTmNxYvwnWuNm/dKzGphMFv9ma1hrQ3MVjqjoZUJQAxmVQa3MG3RRJvE
			avUPbvGHJzErK23pLMZGJqPSfyO/lRXY0OrPamXaLmEEB7AYrawwJtOG9UJww5I5lhTYCi/2h+cE
			NzBaGYwGG0ZYMIvJaGW2Mmww5mQXo3U903YZHZZk09pKX894gclavzE40SaMwVziz2IyA9bDhBOj
			NTAsmGkHS2ZVzvW/MwMZrZVMG0bDRlYLM5C5JMw/mMFgwauWLWGG0QM9mJWtjNYXGEybjeuDtwRW
			sl5gLdu4vjVuCSyktXI9k2nbymJu3Mi0ZcGXhV+G4d/6jwTfDXZqlaZUw9aoJepCiV5Pk0g4bhyt
			RMA1AGglLcF8dPRqeSqthMcNRyUs4fn4rIs887e/scXhUQcfadg0tUBZWB0VxSYRUZGRa1eXOK9d
			t87LPeBaSex2kLl4Sl2bFBQUBJc619SlqTDezkxxTcFSzUjWV9iKn8wK3w1BSrZSeUZpUprYJlC9
			sqIiEwhfmUkmO3fefAtlLxmnz+tQ+J6zit5zRzHV6ND7pyLQ4/v30PShrq6CiopbXYMXMdeXJBsB
			ejHYGSbgXu/gYEFefn7+qXyQvzeL6nU63WlYVBGo33q88w+qfJ//YPFOXhD1S6XS6GhsIhiBeT4R
			vzn1m/6bVVUq+MEybnIzMiJCRBkqGInS6HRpolBwtJjLFRqaHEnCkcuP/RV+cDxhnm/SlFhngK/b
			8nXrhAKBj0AgWA6XdcJ1fL7BkJvrJRR64QUeI8nI61bAPZjl5QWPwSX3Hlw8kMIOvi7uXpYhXAGP
			GTzwCfi4ZfD5fDe+dQDDcfDxCqbdcJR4u6HuRcuzD02plMmUimygb1Zx8bH9x84du3SsuHXDD9md
			J5UvyltK5BLFSwnhibt1ycL64qNHP/roDx8evAKQzTha1NnWXgjszdGZ2vv6xOLw8J5wcZRIynf0
			9Jz20invRO4twneuNW7eKzGdEchiEZ8ui8UIpDOI4zMQnaJhTLyP0yyMRqKzKGcrgzTiC2bCPGzO
			hzFNMAujruAt4CVOzDmXhO7jwA3wsg0MEjUVRsV5wsucGBsCG0gIFhPDM0jkFX4OXBJM4QPwKjrJ
			WsBnsIjPdk4i4ocMJl+CZQkyRf8y+ZBhzMCGhkD8Qvh16PBWxKmMP0AwCcfCL4MpzkxWGB2fghFo
			rCdqrPjc4MuQEKuzRuWj4gF81SqVmiPhCQSqZJ7BU5Dr6KUljY24Qi5XfCVDLOBJuFpXEnb8clR4
			VPgjzZlXX4n+ECavnHmV0LcjMlIL+tjVx3Xl8qWrV65c6urquhROHu52YTb+lc5r396btBydxrF7
			X3ml48wrtFKkr3LZC7Obndk0PUertzT8A8VbZCo1lRYVVZm7LgI2T5NIq+LT9UT1njt9+DxIXlTD
			p08VFIDQHQrFfgqhQ73lBQUFt3p7C25hkSvE70XQvmhxLkAF3ItBWH2n8k4BfPNPfXjjMGhdNDab
			6quMqlP5QN8fS/mSGCMG7pUCseAU7qHQx4mfheyvsNFgIJ16nEHsr9Z6b3SqEhuubBgBSV6w8PUu
			kNlysmYgOj//HL9fLI4aGuon0vdYcZ64vupmRsYN7o2MwhsREf2FKpWkkJsYnR4t5QpUh393I4Pr
			5eDY5ODoML96hpODjp8zkARs4pl8J6yah9+BzCVoCAwkwZMbqHpWdPIKvMJNnoE/Cj6KAViUUfp7
			v/oTVLh6LNLqzTdXKzV6fWkWDlmWTFZaqpFwJBxNaakM58g1sJ2V6lV6GT5IZhXB1WG5LitLR71C
			xtZL2FlyObmDc0u1miyclOG76rJ1xcXkfbOzqaz0Yp2ek6XT4cvhWkaNUiVnrfcuYG9JyVIa5uEp
			lXIFUBierdMpTJ3aBZid10xKU4qRu63ClQJosvCj947+5uhvPvrDrw9eucLNOFekamtXfXAkp9tk
			bBP3i8N7rlwJF4ukYoGDp+Ud/CbxO+W9F5XvnGvcwrbW2XchMyam5UJMVIiiz/GqObbRx55KzZrt
			VRhnPdtbzOvPnnza7F9u1k818U0X9OvNOZ4bfBtyCwU3Ddi7V+KlUhP4agXJzQKhRKVy13IlAqG9
			RNiS3MzLzbh58GA4lweDFFs+87IED2xvKtlZcHslXGlJBnKN3BuZol0J8HXl8Vy1eALSpoCO9nJz
			s3f3WuvwprNEnRm5PXXpqx00WgetSkNj015Z/7jyxb1nq6qz0FiFze6r4GQywZE82psrSLCy2ap7
			SagVEcAofE+frj91CBBcPpiOOb6vpff0PgDOngeZi0U1ejHfCGs8k2jn99H+jJm/gxf7yvsO3jCe
			Av7eLCouKjqnqy8qMhqLqgqN9cU/WrQzOUTFLAA4bGRRoYwMisjk2DKQyiVgkYhGPOil42EvCw02
			8HRMPcAQQyBUYNiTRALDPxB88uSJK9J+4+HfHa0vzO9B9PaLiuvrpfn1VWJxvbhKWJgXESEuvHlT
			ryqMTg+JEInTRdHp6aJwlTAZle9Cl8sKJKGSgRhN6c/EzAVMTmCxwuD4OgyPmOErsjbQWWH4IzAx
			9xcTJVgsJ2YDg059ZVYgOfgOZFA/E4PlD/O+59964gpX1krOSOAVbI0GoZolB2Ky2aVstVqil7E1
			WQSgWVmlbI1MjTRml8qyAbHwRBjZ2XpZ9r5sHPJsmZ7DhpssObxADnPl8lKZRp0tV2aVZmXv27cv
			C66z2Pv27SenfdkcLzk1DQPeg5pQrCXoLSnxAO3LllH0ZctknJUrb99evY71g2lo1FEMge+ENN09
			6fCtm8Boc6L0CuD3PaDvwSsZGRkfnTYDfI8dKy42Gatu5mdcOXjwijhKnJHPdXTx8/SbfCESfIoI
			XvT5zr3GLXybXRzPejwv+DJaeCquKlclNOSq9BKelsdTCQw8PqBXwgWVK8TKknoVj8tvyi3Mv3Il
			SirkCiSW9kL6KBzh4VFR1eFR0SorfVdvjpRIgLUAXa11SBC+mCqs5UhW+8CbS1yxGS/SFxQCNkb4
			6azwZbYajfX12OqeSgSqh+P30+crMFr51q3zxNlL0KtD+BL0AmTR8Ay6VyyKeO0/QkP//lYUgLUL
			2YujoHywoOLW4OCtUwdB+aL2PVUAGhjTj3rFBXmnbtzIz883Hi46h21+TVjr6nCVMd9o+6N1NUIT
			SyCdCurHrDVWIEVaFp0YfzDMnk7SAwKpfDaSQ0c9m06F3OMEpruxFn4giJmDzR+fOHHy3d/97ve/
			P3asKAPRK+qvL6rvzysyAmjh1Bc1MJpeX3TTeEOcHvJdhCh96JOBoZCQEFEPL9nRYclCmU+Qygij
			Eg7JAQUajawJA050FmYX0Z2IdYwk8bGIBc2SdbQB8wLhYsmDgEsDi9FAfpW5/60n8/kmTaIXle8K
			NlsmR+EK0pWmB2rSaFp2aRbMJewFBKtBOpuA2AAAdmJJREFUisoAuFn6UjlFW8SuhobXyN99cppG
			z5bvA9jK5YBe4G22nO3FAeBmIaazlTBHzpEDfSn8ytz0+/bD6+Au3MveT4bSg4KvB7E8I3xlCoUS
			NjPtitWp6xYAX9aaqWFWE9LVz8pOl+TE+Pjo/oybH3744a/feffddwl8839/DjaYqo9ADueHw2F5
			/oe//pCH8CWv3j1hs7bK592Lyvd7xgK6GsGOgFh86aQWHGWAZZDUI2K2pTMaWDjFDFxGkoKsaUHB
			DCpVF9OBWUyWxXLrz8QNbo6/g9rJ0JmgaUlyMCn6Q+zcqAzoZPtloIUlGJ9HsiDR8Iy7IipXF/dg
			ZHdGLYw8MMf+x5IcFYjfyp98SgY9DPYG5LX4ncjBNrU8fGcW7Ozo+JHwiJwolTBqJ0i37k8Wvhd8
			bsq35UZhRmGuRGXIFWi5zU3JgtxcHlciAckrMGhV2uWpWq1alSEwBKtuHLxyJTycm8FlE6vzf1dm
			VIuqo8J7kL3hjx5VRxH6dpzpWO4q4SB9tSkSgC5SVyLpUHNUhWo1hwNyQHKzkKuCRzgdHR00TVER
			xnspZulqhGGstvVY8aKqqr6+/pDZbD51voJUyED4Vpyj1C6cMd7qXD1x96LX91CBubcg77PPPv2P
			1976e+ijvt6LDy7eKiio6AXa9t4q6Dp/8cGtwd7z5XkFaI4uv9UL71YAkrh3uBx078Eb9SB5i4rq
			iw4fJrf19caqH6u2M9Bvy8jI6GfXr1cHw1V48NmRT5l43sKAB+CGOcLYcnbkM+bo9eufBVfD1Vl4
			KvOz68HXr48EXw/+9Cy86vqWz65XN7BYT1JfPTCQKRVFhb937NjvcfSh0zciSiz+UCyqej9iaCgi
			IkJUU3PyD8XFXKkUGy6U9+QNDY0ORYWkPxJlcJMdWQstLsn49OwIfNdq5tmR659uOQtfawS+1k/w
			u41cH6lmwZcbqWZ+en3kbHA1XD4bcbo+cv0zJ/i+1Z+OMAMb8KXM6hEmE36VkU+Dz16vdjp7Haa/
			5996kgpXM4WvwwplKYpeVLRsmlIuA6XL0QOOszRqGXlAXsphszVylMYctjyb8BcITOMgZBHF+7L1
			WaXqrJ/pZRY1DBf5PniVTKZEPgOXYfwsa9/EeHEdvHQfBV0EMFG+HiWW4QH0ZSuVWGgjS8lm03xS
			16UuTPlapekkfidn+dXFJcaHxsfHxcXFJyZKhWIxt0/c3y/OwOv+/ihxOHZ/hPFhvsDTE+FrfR11
			vXuS64vwnXONm/92s4S+zHbZEpa/E/pJg+2cbBnB6xkNS5j0FkaDDYtpy/JtbQkO+4kdy63BFkDZ
			Esxcw2xosE1krmEwWxnwONPg3/BCw5oGd4BVMNPWibVx9v8jcAnjhVb/VlbYxgbGsmCmHQNeDe+R
			xEhr9Ye3CWz1b9po27os2JYhZbawmE42TFySv20yPJXRymIGsBjNLzjYMOxY92Dn0NDQwmIFs2bd
			SdCDWRtbNzawNja8wAxjMtYEtq4PXhNI38Nw3rieaRfIgCUF2zKDGlqdDIwW1ob1wczgFkZwUGsw
			yw6OuDfC0hlNQbWtTrYsgz8clYQFwDs9gQR5btHOwTxAoYCbkWwQCpKbDM0GQ7OEx80QJDfzuFxJ
			ode1tVqJih/cLCi88eGVnvDwK1d4L2Mv+9KMjKjqatS91Y+irgB7H0UpUQ+/eiYzJZVTqMrIkHA4
			HRzALYeD7RrU+sJCvb5Dr9cXqgrzC2/qkcMYaC0rLjUajVkNNkGP/fR0OsOmHi3OVefrzYcOHTp/
			vryCpAjBNcZaXbKgl1idkbqnzx06XXD+VsF5c7l56dn//CzuP0IehQyWF1y8+OCPDwpIThEgtqu3
			izT3LScRV8jdW7cuggYehJnlp/LzzQDf06bTJgDvadNhHQK4qPXHUb6BTBb90//cEoww/QyugqvP
			fgqTnzZc3xLIwqnq4OuM69UwdbZ6y/VPq/8zOPjsWZj47Drz+qfB8MRPzwZ/en0LzLn+6dwla75n
			wKEkq+nKlQ8RvL87+vvf9yBfIy4AbgeGxHmnDmB3pdGamprfHc46amiOFkVEvPveb8Q9A6NR6ekh
			j8Kv8FpZCywqQ2d++hkcNsAHPns2mInfBr7llutbquEefI9gOsB3y39+Bl8ZfpUt+KvAVyU/ypbq
			LWcbWNR3vX49mHH9swb8SeC1+E7+3/NvLVz5Jk04fK30vbZCSRgLZzYNvbZsDdG5WaVsGiV8ZaWw
			LaBDF056NeIX+CuXy/SWKaCtWl7KzpJIXlzhI9uHMEbpmy3T/CxL9ksZiOD92UBYfRbKXBz792Wt
			1qPgRerCPTmZUHqQkCtCXw9XNmhfhRJzftlKzuoFwReVL2UknmJ69psSMRWXGBpN0RdHE6FwdHR6
			dDr2foRdA7qjriB8hZ6eU17nN4Hx3dapRfjOtcbNe7thGIJbbRLdGna7M4IrpfEtLQ65fAwvZvq/
			aZfrHsasrUtdx6zjS1m7DLl3Y4J38xP5DUlucf79zUEMpsHFo9WPIWSmJbbcDXBmBqe57d24Mcxt
			jk03uaHOhZ/I2uTRwNgc1+Sy0V7aHMYKTmI41np63Q1i5tbx+Uz7kkTWiuhcR1/mm7lx/Ia9wpb1
			/CbP9Qy+7z1/Z4aB6Z3c6rDjNovp7sZv8PWLC5t9pQwOc3ZMTghzE7KYzlta6loN/OTKQOYe1g4v
			T/5dB0aub3Qcc21TU6XhC76jG3OttCUhLDc3zK+pwTGIketnYO1iNIWtbWlwfNuNxciN5wd7O7eE
			Ldz79vwaK/AE/FatSoCNA/nJAkGuypDME/IzklsMgiYvbobQQ9DS2hScfPPGDUwoEOffkJx55dUz
			Su7B6jHYwDJA9z7qiUL4VsuUyN4zkZElgNtCIK5aj8U70I8M3FUXqvXqDn2nXn2z8MbNmyS/CQfA
			t6q0qqhhVuUbaFtUX5WXf6j+/KFTZoDkRcJevD43MSiPL+YWUer3FAm6Mr8efrY6PvSt0L+/FdLX
			2/vg4sWLBaB7QeYWYI2NB4O3BssPlRecQgM18howXFAwfKviUH19FYheUL1YrgO5expOP5rPl8EC
			mjBZn113OguYaWABgoAscN4SGIjEuR4Mwu9T5tmfngUMf1p9lskA0FxP/AyQvKWBcf36p//J+PQ6
			EyVw8JM1HUBfczP/yoED733wwe+L/9CHLX2HTp488Yeq06fOHX2vp28oqubkyIkTH7/36/B03O/2
			/fpdadTQ2FB1SEhI+pVC5oJb+bI+3TJGPvDZaob/9c/gi4B2RRQzAuGbOwUyALdn8XiD8dnZhrPV
			1HEG/BRwP/gzBvxcW5peCL7+n58CfFnwsupAfO33Hnk8YYWrpInWvah87RG+lMNXU4oyF+3N2cBZ
			NhWEJUebNKzucmAvTANz9TJipM6m0YhNGWQtwFdGA4kre9GNA/ez2cQpLFeqtXI5m63P2o80JvqX
			Mjvvl//Mx6J39x/bn51lhS813FD7urLZJOgZDgZobO26det++P+Yrnz9psVJTShhvMTFW0acdcTH
			hwJ9MRs8KkpMop0t8LXar4nBenfdNIwvphrNPRaQasS8Hwy8ddydxAh2uP1lU6uvOz94GdPdneXp
			zXdgMZM9Ur1YYYm5nvZ8N0enDYIGb4Nnnf0bjv3NCcuYzR785CCG1Cksnt+02QNgvDE32T/Ja3b4
			0pkrgu1zk+s2eTOZbvyEBDt7QyIIUzcH27tr+Y4shsFDamCmGeLtcvn8Ohs6f9lad5etua13pXAI
			xnAXGup2M5pbHZriXDatW8ZKjjF4xjhLZ9ejgYx+prPBpa7Eg8lc29ziudvbPY4VxPRw8XTjGzxt
			GQYvaRxjb1OTr5uhOcCT/kaQwCXN4MEyGPw9HZggI+uS6C123i0taSv461mtSc0uSbnNrH8c+AYG
			CwT8LXweXyDl8/lNQrjX3JQrlHKbWzYmB7c0G5qlfGZrsEFw48Nfg/LtEWfcpL2q7DijCb9SDcK3
			Jyr9UXUUsPcR3JOh1RndwWt5hTfz8wsL1TQaDSCrv5kPrIUrALJaDby9eaPKCDc0tqYU9lM64Gtp
			1ixmZ4yTs8nvyTv1fl5+/aGCW5PjYgHJ7qXqWp2zJveSgCuigEEj57+uzVgbF/r3R39/NBRRDtTt
			AuAOUoFWg4MXL8IZPcB5pwrOF9wqKHj/UHl5HnD4VjkauIvqT5+GWyRw0enDRbrTh3+0aGcG/VMQ
			fp9dr0Y5W70l+PpZJ7iAngNJDNg5C1hGjcs8e/3s9eBqUMJnzzoRkQxPAv336VmEb8PZkS0sZtiC
			1zrLZ7DJqLlwYTQ8XNx29N1yYG/UUM9vio4drao/errnYNTQ6ImTwN/R0ZHRAZE0MVokjU7/ZOyT
			sTGgb98W1oKRj56jwLPXt4TBVwK9z2Iy/vPs2etO+N0As4xAFv4YWz69fhbEsD8jEOF7Fo84qj9r
			8MeYNHiQAa+rZiC4Eb7MQHyn79nmnqLC1YTyffPNFTR2Fvp8ZaUEqqVsFMJWFr+URalfBKEsi0BX
			rtToMYVdI/ulBmUvwpedhTFV+7JpbJo+O0vDUcoo37CekwXC12KnppQvFXKl9JFb6buPmjiuXFtS
			Mml4XutKA/GL2UZKNo2mXb2C9YNRptN9vnUzAqX8dluR7NkErI2fkL6fWugbmg4jBLWvBb6nVMK0
			yTAtvynKd8IKvQjfuda4+W82ra1OTMpp20BnMBuYVi8sk+XPtARPAKFzmQ2kxiOT+IJJRAiTsQFf
			iJWgSTwFg0H3IAUd53AYMRrS0KtLajSTuBJ8K+LvJdWhre7kxGASHElHdyyTxEySoA0GWRJZNsuJ
			xTSQd4H7sy6qYReWqvQnLmw6VbcSvgWpFUkq6cJ1IIvZxGzAtwskJTUDiYub+Iat36mBvLAZnuOP
			T1jg/ug5Kt9WoVDINRikGYaWZmBwsiCZ38wXCvlbmpJzgcPJwcFNwYZklbGq/tcf3rhypTBDxT7D
			fuWVjCsYaBUeXg2K99Fn1enA3kelL2H/P5DFKcv1xhv5hTfVsA8B/OoL828a9TdB7qo4elS8xqoq
			ZLKGBlelRcVzw5exYUnewUOHTr9/6BAm5KLiLTh/Hq4QvVSOL4m1IiHOBMEEv/XnzxecWvrt627x
			Ia/9PTT0UXrf4AN8OQreiwS+vRexw8It7OxbUFB+iAjgAqBveW/F+fpD9YerqupR8dbriouw3PPh
			o8864Gq+ypeOjP00+LPrn50FxfcpMwygyrz+2afXgWqfInevo/ADVJ2tPlvdAIRmnT3LsthimwA/
			/3kWngbrZ/X14AU7Xyf/Bu7A6EB43sEB2Jn2jIVERPUcOvqBsf53x947eOBK+FDfyRMnTtSQAdo3
			OjpRNPQJjBCgb2LwsieAbyCTAccRW86eBYX/GT2Ycb367Gf+cI/RAPClA3w/G/GHX6Wh+mxDMHFv
			f0ZM7FsA2oGsMCZB85YRpgW+YcEMfO33HHosXPlORa9l2HvR2BhNJSPZQnKZxsJYYoUmEVcyDGKW
			KWVUmDNq3mxUtjK25EWaDOG7f1+pBb6abPaLbGAxx2N5aTbOUP83Wal8H3EMo2zOJqzFmGkfdAbD
			OAbcJd5fhO8U7VtSsrID8KtQgA6nsTtcV/jPG75UtLPf7hm0tFii4bqpeVL4vmFRvvHxIH3TJwzP
			aHfOL8ydltY71fVL8XcRvnOucfPfbhA1pNkBg/oTSRsDkptHpeugxYOFD5MZgSRbkaSUYToC5veR
			lMVAOiYFY4RTYOCcpS/opHMaCV7Ct6KaLJAMQSwVTd9AepzgE1A8kP4LdOyQYKkHSxZHXoiPUnmD
			c8R24Xz8GIG4JGslWaoXBPl0dLI4ZqAlsZLk+1oKwFNfj1ShJdN0kqeIYWUL3B89N/gGBgZLhXwQ
			vTwuV8Dj3mwKFggFTckGXjLIX67Wq4Uf3OpiyL2SgZWfPvz1jYyMQv0rryhfYocjfMPDxwC9jz5D
			3TtWXV2lfOUVkoMU6akxEqGLMletBhl880Yh2poLVXqNHqaqqm7q9YTDhQhfTIVkLHnc7Ax/s+2p
			Q5g4VIAVqS5ahW/BFJOzRfXWTxKYzDB3vtixdKUgMfTvoY8eRSBpHww+uPjHP4LiBRD3wjTx+pYX
			nIITEhjbARP85gHs609jhNdp0+mionOgf88VHf3RlO+GQFCuYejdBMxUMj77LPg6ej4BvhvQ7Lzl
			OmV13YL2V6fqs8FOZ882IHyByywn1L/+aHYea7heTWc8SV3TDSTkUAx70ncLQkYHRkdHoyLEh6uO
			Hj569MbvPq4BPTw2dODEx0DfkydPnIwS9ScmJkYT+I6FPBQF46HvAheH288L1YFA3GoW8z8/Y6LZ
			+bOzTmhSB/jCITT5MT693kDMztRxhhNo3S3MMAY9jLWluuFsdfV1/F0+w+OSaiTw2e898liwz9dh
			gr3Wdgok1ahUJs9SlpJ4Zri1ZB0Bh9lsTDZ6Ce/KiGOYCF85xWCcKKVxZADU4/uQq6ho4Z5MrQaR
			q1ZnUXFXerUlHQmZq0HbNGAY6LtWSyKuiOjNJghG5ZtbMmWs7MCoK+xzRGNzlrMYC1S+1GX3tKhn
			6tqluXnS6NxE+BtPGZ6RviQToqcnP/8m7/9v7/2Dmky3fN8EkgCvwoYOCjFNKyJbsdtuOyGvgTDH
			6tM7Z1qKM2zdY/f26HUY3bXFDZO27uw3SUFTOLsHt/zInsO0kZbbdpAScC44t+yaOnVMpakRSWui
			eEUv94/7hzVOz0ztw9Htj1N11NnWnLvWet43CQjKjyBEn28g5DfJ+yTvJ9/1rGctTSxyY6gbCWhz
			+E73jpvbR5YrnlqwsLP1+q5d1w/tqNyxo/fo4GB+Y9dgb+2OK121ozscXb21+2px8VEo2BkE5xs8
			fDjYHLS9e3rjW4P28YphdLtPkb0fXLw4PLx1OLTh3Y1vAX9PZ1X7xhC3R2tru47Wtrc3g9odcEF7
			+2DoqMMfDARxWWhX7+DRUMDrkbAMwVTwhd3wzaaBtpOtA+eoGuQ5xl+lrFX/2f4BWeR+KeNKrnG1
			a8XeT8r3lWb8wS+efvDwwblz4HXJ+cLh3J1WQDBeBi645w7AF6iL875og3/d0/N3JwfC3d4w/QJ8
			Meu5u0O1OHO+GLW5MCR+iHO4FzDh6uLfUG6ROFRugiuER+U4Gzx8AeFbOlQK8KWEq3JGJCteglPD
			mL90cc7OFxf7Ym2Ne8OPHz169NXje2MdodDdpr9u83/11XePHj95UjH+8PG9747cs9fU1FTtbDy0
			/aO///vHAN+D5bjweNaVly0lJT/AJwwvKZpwlQavTYQXZUH4CpRiBRvggpxb9mExvMTSq+B8RZwe
			vngGvqOU0sQwZqhRwtVzvgTMzfl+O1HJuTYsh+EkmuIJiaVfkRl2OlnhDDyKQldGMMacbYO0kNfp
			ZnlUXXCprwh7iCg50RLSlhKg63B1UW8XxqHhyrV6W3TpEfz9Epzvuu/XnYjGnr/XF67ApOcGp9tW
			cLvoxd+GppvznbRGaNNl4759EeN7IWJ9P9j+gex8Md953N++Y59xwt0jK303RaZ/OXyne8fN7SPL
			FU8tmPO9sWN0p2PfLkdlb++Yb2ystwt7LLSPdSX3wQlH7T92DR4dHAsEA4cD4WAnmF+wt7dvv9Vl
			f/xkmMArC4zvsGPDxg20APjTZUXtoXZwyfBztNLhaG5pcfjB+bb7jzpARwG+oWAIp38DvWNeyetz
			Tu18YVd6s7vtZDeVwcCc5BGE8IAcc/4vZHZZoJlsL+GXjsJ7c7O3lx4q31Na+sEvPnrw4Jtzd4C1
			RN4H6ICR4cjfEUpzJts7QjlXPRSJbmOFor3dCN4ObBPcsVjrfIstYvkjgO+ZkscVex89sovDtIAG
			qAvOF5caXX1kLT/zeBjga300WjH06OKZR48uihcflQInyx+Vlp8pgZvhNKk4l9kOkmgpsf7oo48+
			uve3j7/77iuwuN6O457m7qaTFQ/vffcVvBGqth/86OFfgMvBmHNmdqjmIfrerQd/hMubZgtfC4bG
			ii88GhaG4ZVYz8CreVQFLxlfV8mj0WKx5OJj4fGZC48ePS69+GjYehG2woWSYny9AoadRbgrLcEa
			LcUlWKW4wey4TZ4zWnOZ8/12En3/KN9m67XJaGWQVTyuJC/0lZwSmuMofNlN6LzTJtW76py4cgjn
			fsHeOst84JNdrAIHLQlW4MuyoF3Ad2edqyy3ri467Xu8/suG3HWA3xj6njixLqevrKzg9meugqz5
			zPlOWCmEf3Zfl8POFyKRZ5z03S7Dl5yv37Ez0zgx4jyxzhV3vs/RLLKdLaZqmobNEE1UeQcnRnVW
			S0kpNe3FagG0tLZE3GKZblntDP9TSfENqj6w01os4Kp8jDEbi60lpSW0xBbOldBC4OLLxcVzqucY
			UbH1JnbstV7B+n3wkO8JpuJymlimaWwTVTIAj2bNFMX5/afnacGcr7H9StfYzvaj7cBaHxZ5pg5H
			vt4+m+1fgv6jg+BfB7sGgbuBw0Gwv52Dp08X/Ifb/nH78FaZu2R/MfvKvmFjw2en3934wwMrN5eN
			tVfuAPgig/2h5hZ/c3As6Mci/ABk4HhobCw4CPANYAvdQNjptaaon9l48C66AcaUEBkJOQ/EZjnT
			+iIWeB4YYMDE3Oedn+wd/aT80KHS8vIfPXwwMHAO9eDBuW8w8vzNNwBfbK8A+AWW99Cao1b209PT
			808AXwD5v3R7+896vF5PP8759sc77Dzz2s7yEnNRnmShiqkl7C9N0OApkVaa0xxKSQktSKe5FHYX
			nFsx0dGcBXbzetXWh9/du/fdY3vNDs//5z126quv7t2zV1Q8eXyv4qfYdeHzv246dXTs0OjoPofj
			/t//T2DvdfHFO/qp/pmJ5nioKbeFCYvAlmADcHpJeGwpsSivjqaTIrNU1LSb1QBj92a1roqf91Tm
			5Hwnwzd5nZMSmjEWDLSlgLNMX6e8zhej0fJFkhJwlpT1Sc6COoQv5l3V07JfqaAALkfu4i0Zeinq
			jPTFahs4XwxwLiocdMlFrurdLoTvAcQvo+9+nPjVA37XrSvM//lnfbm5L34jROC7+ZlWCn8c02SB
			Wivs2wuwjaQ7E4op7Cw7X2Cv3zEa7SQYeZRNkUejDkcCh+8077iZf26uNn58s/HDtzUlu7ZYd2us
			je9rGm/k77P88c4tNxtLRN3Okux/gOv3NZb8qSZ7Liv+o7IadpbmlxivWHZVl9zQi3rVvp3v5Vwv
			eXv0cmljiXW08UNdtnnn+ez8knU3ds4huXjCfxq9+v153U5rjcZaahD1xus739/1o+Ls69nWdWZx
			X+OHu3eK+svXT6h23twzv9f0PC1ckY3Knb4xx1hle8g3iPVou+CntteHiZi+9vaxwfajR//xaBc4
			3/BhzEIKdJ0+/cM/+6Fj3M5izk/ZH5zyfVK1YePpz06D9/2zT7/NHmt27ACTG2pvd7R3tjQ3A3w7
			Ab524HFoLBAIBsH8DvZi1aoOTyDs81q16il2CiXlrT3dPU2YL8XwO9AfIwo2gwtG0/vfBrrJsIa7
			+/tP/uhHVXvLD42W3/jphdL/8WCAanIAwR988+AbeeIX0PtAXn8EwG3raR2AHzj0YEnogZ62cHc4
			AMz1nO2HI/C/i9fVqJghSOYJMYaqJorElWKqKEMHutqiiAIHjD+U1jCXws4RYRrjJ1UffVRFq0hq
			Ko8d6wj86oh/+0HYz/Z87nfc3b79d59/8avDu67sHR3dear2yN9v3Vr1Sallzp+HYvba6IXjS2ev
			S/7uYWHXRLeCRX6VImVjRLaHvDFEVuf5OYM3pwpX306mb25MOJnynSVJMbnEYkCwmy1GinG+Pnle
			uLfL6QN2OhGr9TidC9d1FTmJu27JJZteWvrrZvU13JSI5a6vd9uKClxyhQ3JVVdvKyw8cAAjz0rS
			1Xrmfg0Hbv1jX26+OPMiG5sVv1odmy4Vc2a3cR/LucKJfhCb7pVt70P7XbvD3+yv3DfFXSc8Iofv
			9O+4GX9kLI1X1zVa//APR0sMJdb3LPtKTuhLL19uLPnj7/941/dbrN9aNSe+P5RiMFy99qeNJ+aF
			xOIrH35/SNz/hz8qMVjEbHF3iX67Nfk/jZZcu1K9p/FnYmPp+gONo4Lh+9RbH+9q3DLHRBOmG5af
			XhHX/7J0y/YScefVGx/+w+jVZMMnJSf2JY9+n1Gys3TdgZ3lJfv+4cOdO3/3/eZ5Yf55Wrhs59CN
			rl1XroyO7hnsdfqcvbW+wbEdcGpsrHcw0B4aDIWOdg36qMbU4YDPF2jYWPDDDaftfpbnLPteNL5P
			hqtsGzd8xgpt/Dyjt7m58qijvau9PRQKNPuBvoFgc7ujptLfSW37go5PEMPBgKcDnG/ANxV8i01i
			eevJ/6f7zn1Gz4jt/S/00z8QneQdaOqm69ow56riD2rsNZW79pSXH6r66Qcftcp29xyFnr9h9MVq
			zgjfc+B9W9u6T57sbsOM51bMv7rTCvRtwpAz4pe872JlO7NSIxEHx6rHWZTLGIdElqFIvLKI8oEw
			JEZuN793HxWzvF6FucwHt1dtr7p78ljwV4e3kz4ab2763fa9hzoP/0XLIWDv6N6//OLOwydbr89x
			YbHyqqMvVT4pRk4pvFW+asjXipSuOfEuYvT654zW7Nf5PoPe5D8qlIEKrLT5FPQShF3OBnYCOyQo
			mc54S1dk2ZHT5pTq65w2hbFwn8HeWkqIliTZ77pl21tXp/x1uRmGnThhXF9/HFlcb8sj+jL8YoNB
			1ufIcGLd91llO/KvvjDdM+p8GSWrL0f+VkfQWc3+YMLzB8pyXyyxIac6fwS+9yElO/t3XY+981QP
			ctnIw87TveNm/ImxZhrW7dv54c/2Xb2itTbqrTur9cKmy9f1W9Z9C25XXNf4g5360sYtexrP/2mG
			QTcfUFlvGgzXG8//Ybm4b5M4arAakveKf7r+huGP9OuvG0pM8B+u6K2G6nWNWwz7DMb5GFLRmr/z
			ZuPl9dYt19+2XjeIhuxRq0ZfatBfabxpWFPSCPa6UWzMHj2h019vtJjn8Z+eqwULO5c7rvftaky+
			kj3a7nP6MAWqCwxp71h7CKwpwXdscMwHkAwc9oHz9TWc3vjuxga7/8nw7+EwrISeh7cCiz/74Vtw
			9Wn82V+L93Y4gL1jwXBzM3jfACZA7zrkh+NgOBA8NOoIwlW+jg4p4J0avvBhvNHW3Y/VH0ew9nJP
			W9T1HiPD28/mfQG91FrB2+3t72468gcf/GXYsWfvob3lVf/xyX988BHmWX1DC40enBsh68sSr+7f
			OXfun0ZwzretCUtjDbS2YdLzQE/PyMjJtpMYcu7o8Hg83fGH7xz6+c4nbjxfYTjb+iN0uocOVR2q
			Ga+qGq859LuaQ+h8f3e352TN9t99/YV3196f7h3dN7p378P/+eRHFAdfvGc8G83F+X77rPN1UU8E
			pGqvM2Y2l6hLjpcKXrlirK9TmSN2STYnstiHWAX3Chc0NFBCFYG6ri6S6RzBLztHC37rXE6JVhmR
			+7Xl5N0C+gJ+0fCC7V2/f/96xC/w+OdlheIL8+6edb7Tynh9n7LYSMavEnSWl/mO+5sPXX/hw/A5
			32nfcTN+E8Ow0iJdnIFlM6KsujOtjRXFy9hmzyp+qLFi6715fRsvLimmBbv0TZ/Vj2bVla1UQTmZ
			eguaSjQ4xTz39Y3sRbH6z7K1wP+EDRCt2DARfpOpwrRouV5cgs9EmM9/ep4WCr6W0h3lu3btMO4I
			VVb2+nyDvVj/whnoxb7ygWBLexfAd2zMFxgLdIbDp5zehoaNG0//cGMN5ltRurPsfCvwpPN0Q8MG
			Rt+sLlzc66hxHA0FgoEWcL4A8+b2YOVo5S5HcycY6XZHKBAIeTvcHR5vOOAVpoKvKKqb+lvvy2nO
			rLKGXFWSpVaB9cVo8cCAh5lgDxrh1q0H27y79lTuOVS6/Q8eb314B60vwBZDzuR9H5y7j1Z45P7I
			HTC+tMroZFMbPc4AZV8N4OKjtm6Pp6O/ox+jz55F62q0NGShKual2w9t37t9L7mbll8dafZ2H+k5
			cuRXTQNNnx9q/vUx3669e/eNfjK6d7Siopy6iiYYfGcz5/vtM9nOhcriIbfTKXveaBjaKceio2lW
			bDKYOWDArs1nq7c5MeEKF/y664jFdI5izi7GXsX3umlu2M3SnHHJrwSe98t66fjx+i9tq/Jy8goP
			5DP4An3xcIK6DH5/oKzvqvVFgcAJzvf5qpbhSwDG+d4P9n5wUFloBPC9i/lWxk3VL3ocDt/p3nGz
			eR/HIHXyhixWGozOMwY24REn/3u6pFh5Lgny4Z+BFsz53thV2nV0cIcvEDg6NgbQHRsLjvl8Y75g
			c6gzGGwfGwu1Y0tSXxisb9jrbNjwQ6CvzfGYYbcCqMtizvjXt7HB1YDoffeH65Lbg+1Bx6FKhyM8
			FjgM8AWWg5dubm/2h/AknGkPBILhjrMdHnhsnPN9tqtRsajuH8FVRuci072slwLV02CLioCZbK4X
			5OlmtSabPh+r3VO190d7D92799HdntYH/xfa3/sPHnyDmc/fUPwZ067un0Ow03xvUyuz0AM489tE
			Va9O9vd3MPp6+uPdWGEOznfRBV+tr4RpHS/sYCt+V1l5aLyp6avv7n115N5j+71fV+4cBaHxraqy
			Fi/YBMwCaHbOFyzvM0uNrsFvoSSvHnLaIuuIqMgGFr1ySW7Jx6pqxF5H1+OFvrL0dHeX21ZXz1bt
			YqaVRFO/8vJekpLqTDSmCeB6eY1vHUae6+skQHDBqlW38m6R9V3HnO+J9evB/VLFjVtlV6/O1/n+
			LAa+8qTvJ4Ten+6Vna8860sJV45R44vQy+E7/TtusT8bXAs455vZvsMb6ur1YfsCX68vGAj0BgC+
			3mCoszPUGRrrHfM5nb5/8aH5DTidDVjCqmBD0P4Ere/THYa8SkCv/UkFnm0v6HM3nN648d3T7x5Y
			sSeE8K3ZU+n1egNgfAPhYDMcgnAyHA4Fx4DECN+zHc+F780enO5tnWB7lca98BNGZHazoHN3E0uB
			pjTosdodh/burTlVcXAcTOydcw8eYrbzOfK/GHWWl/yCsM9Ra1trK1noVvK+pP8GYA97kL6A38Xr
			57uEVGyyXr2+Zy/S9yDWsar6HwNHxr/77tF3X3333XePj7R+9NO9+8D37t1+HavJLfaznYVm53y/
			ZfSN5S4a32sEX+yD4HNKEbySz5WcmOTskxT0xlxFztcJtygrqgXU+nCVEfKUWi3UKZ2N3G7lDJvv
			xda9bMJXhi/mahUUuOrwlgWrclbl5EXizsDeS3BYL+ddFZ1/Ya2VKZzvz6YiJk7aGiNVrpjzBfhi
			ge+Dctj57rijUmOc6p4To9clHL7TvOMW+7PBtZDOt/LoWGjfTu8YuNEw0jfoDfT6Au1kTVua28d6
			8VKkr28MqPzD06c/O23bINntBN9h+H4L8H3yuOLpB8MV4w1lDZ8BnN+9vfHdj9dVhoL2GkeNw+f1
			BE4GA14vg2+I0q3gaCwYANYz+Iangq+puLiknGUq/113dK63P+p75XW9Teh7mwZY0JkWH51sP7pr
			9JO9LaN/cPDhfXC46HoJuvfZKiPsSgi+F/9gHjVb6ovdgKkpAxK4By8aAPoeO4YAXrxs56WjYpyC
			sV6H7zRHA469e+8faWqqqbiH6H009Oi7747c/wicD6C31Fry4SxbGS2uZut85cpWCnrl30K2zMhp
			c7qc7ok5zZjtbLNR+hTLX5b5C3aVVdCwOQvWNoB77ZXK+txS/XE2yStnVsngdUfCzu5IrlWEvnAE
			D1jm+7LOVbZsGYMvs74niLyXyP3iuRd/LYpxvtWxeVH0U315ws9lFneWnS9baRQTdwb47jBOuNOk
			h5N/uPOd7h232J8NrgV0vtZ9u3xhx65Q++GAPwAIRouKdOxsdgCAKx0hn9fXC/T1Ye+hgBNXEtlO
			NzScstuHn+ABfyqGWw5jb6Mq2zJXwcZ3b7/7242nt326LtTe7nc0B8fGvIHOgM/rHQPbG0b2hsHx
			4j/xeQOBjo46D7bMvaqaAr4m8UfnIknOx/qPy4HnAQW7GHVuYsDF0pLHjskNjvrbTgXCjpqf2it+
			+tGD+7Ss9wEVdqb6Gszx4jGg+M79O1gsunUgou5Wyr1iDO72BsLhUwHvy852toipoonNtYqiSRAs
			omCBe1P6QpIoplgsYhrVaMUjwcTSmrV0Hm4pYvoFZv/hvfFOosWIGQlpdDsBLprr+xCrm1/f1fzr
			Qx89GDnScrhl/B643kePvnv83Vf2h7/bt2/vPitb9TR3+IqiBd4KAmuWLQjw4kV84XiGXoyFdfkW
			U+gyM75Y2AJYUBZP4EtnmwFX/KaxR1GL+EDTj9Zsne/kCV9A77Vkcr6S2+l0A3zlBb/siOpr+CSZ
			uWRkme2V4et2S7a1Bc76emevy2arc+JiI6qq4cbAc52C31j21kks6BwpbtXQNWizObG8ZMGyVatu
			5VDC87qPv5e97350v5f2g/99cQrMFM53uknb6svGfRHji/zdTvWtlGW+CN/GGUSdOXynfcfN+WPE
			FTctmPO9uTPgDHQ6/I5AwB8CNDr8fjS9p4L+YCgQaA8FfE6n1+sE+P5LGPh7e+PG0xs2fOYK+b0V
			w0+OHPb7W079xZEnh3ufPm158rTL5czZuPH27ds/3nZ72bZ8muRtbg57sDyHV/Ji4BkdttcbJsJ7
			sYhFRwdmXHmngW/5uWjEWS6tweppsMpWrWh7v2bVNj7v71eKbvS3/cVfHD7csn14+IO7D9DjEnzP
			MQSPnDun0HcEz9EaplYFv01Uq5JN/cKftlOgwycDL3fOV0xSFWUCSAAteKTVIkPM2aKQakqzGOGi
			nBQxRYXmBC9PQcoAc6yFgsqkTYF7iyqEbo4pBYClt6hEU6qoQ+4KJgJX8hx9Ke4g4d+YrOWjew+e
			G7m799D2gxUV9/4WWyp8VbV3dPT6VZadaJ2H7y3OTWncIaalCFhjJVVrSdbC60kys2QSQUzJ1ap0
			sB1MxXr4Rzp8JYKYlp0piDrYuPiVA19lSpHJlIKk1phgEwpF8FDG54zWbJ1vJOqM1FUOhaySpE9y
			K+CVSUsLfW1Ot3zarRhgbKLAJnMlp63LJtW7Xb2uOtfxOklixpeY61TOuBh1MdMKnS/DsdzK1+Us
			GCywwbnjXwJ8kb4x1ne/Enlevx/s7w9eOPixc77VEfJWT/ytlqPR1/d9MsH5xk76kvPFKd/qZ1Yq
			TbS+PNt52nfc3D9IXPHSwhXZaA8Phhx2O62H72wZb8GleS2OzlNwDOj1er2S0+uUJOz+NzYY+PTd
			jac3NjR8VtM8aB8e9gd7/f5Th+3DnYP2Fr/96V7XZ+kNG9/9D59u+zRr24/X1R4dC7QHw15PuDno
			9UhofXFqGR0vhp3DHVS+sa4D2+ZOFXaGD2P5BPR209Ki7oH+JlZYsglRDEfHmgbYfO8Ag++Rx4/t
			w/bh74afbn1IoAXg3h+hhCsq6jyCgecHCF1a/HsH06sGiOfI9ZNy7LmnFf60tYVPnTrZefNlzvmK
			YlJjblGykCTm5wlivmAWsrOz8wW9IPQVCRajVmUoSk4CsJoM2RqToUibbEiGi8X8QrO2TKspTIOz
			Go0oFmmEvD6zwZCWUStYkhp1OtFQmA0E3mEQ0ubxVqSls9br7U2Vh4C+oMePv/vOf2jnaKlVpHIe
			FrrRnB8/15C5Q1ALRm2yvlAr9OlFobDQKKTp4IkXZQq6QlVKX59gahQM+bo0Y7YGbG2hkF2YA0gu
			SjKri3QmdWaasQ+sbnaRRtTkgmvWFulNmpznjNZsnG/1t88IyHvtGmY7uyRs2Cs5Y6PLDLO4qMgt
			Me4qBhhnfCno7LP5fGVOd/2XLqyWQcnLUiTODG7YFet6JYRwvRMcsRNLa5Ccg8DvXjct862/vawI
			485stRELPO/fvx7oe2k9GOD1M+/nOznbuXri32rG1OsE3k+U1UYfxHQ1qqm5O16pi3XNP5vaQ/N1
			vtO+4+bxQeWKkxZunW97eyDQUlMx7nfU+P3jNfYK+3iFvTkY9I/7MVgsSV7JIzmlwcoGn29sbNun
			t222hs92bPcH/E+ftIQG/RV2+9Onnb72w/7HTw9+1nDF5zz96Y9/vG3bpz/etn5PO1DXC6yl/gmI
			XC+WyfIQfIPUMFdm75RhZ6BQ+UB3LHr75XKS3SzjmYWbMcfZ0999jDKdkc49f/uvj/522P7B46dP
			n56jXoKtxN8H1FABF/uOPKCEK7lg9DmqHU1QB/QyU40cZm64Ceh7+KU6X0HMTMsrSklKEnNN+aYi
			kzlfzBeF7AyTpsiUrNKlaMSibAFjqXq9ztS4w5JdKGrFzNTCHG1KrSm5SMjNThPFfFNfsiW3SGzM
			F/V9YPzyLEaTIVdjErV9hnktOBCZCRWLxdLy66N7gzXbq/aWl2Kbr3kX86B3ZL4prW9HSppOqxfz
			UjS1GYDjQh28IH1qWXa2qCtUq/pMBku+xVCoS8nUJwsmoVDMLiwyGUX8vlKUKaYJxsw+k8bSWKSB
			rWGypJqL9CKcmH60ZuN8qyfFmyP2N5d4iiU2JLeygsgtL/yV1xrJecvkfl1uJZPZ6fRJPieS09nL
			qmVg2NkpL+l1g2mO1taA/0BhaImKYdHF9e4yYLa7wIkTwcfr6ruWLVt2C6wv0vd7FncG27sf2Yvh
			51nN+V6eVF0jaoMxBWu3Ef7s3vcJxZzpJ1JekuhbA1/pdxmrLxuN7B4RC1090UjzsPP077j5f6C4
			5qsFLLLhD7aP12DvTbu9pgJlr7I3hzrBAIfCiEzJg3Hn3nbMuxqrBfpu3Li6ssIf8g8/fWIfx8Sr
			p8Mtve2h8cdPLzb07nSEbn+6bRkY35/8+OcZu9ox08qD5TkkDDtjshVw2BOmrCvgso+Fnb1Y2/mZ
			T55FFG/0T2Qvpjb3M8h2t1GKM8tv7u8/1t1PTY7+aeD+3//Xf/3uu0df/eK//uvv/+c3ra2t5+70
			jNxBs8tmekfohwzxAFvFdI4CzxSw7h8AiuN/QfdLSVhNTV9//ZLX+QomUyq8+hRBtKRi7DRtB3At
			TcSZTTNNa5rhpJhk0psEwQSssJhS6AqLFqc2BTHFlIZBZlGLE71mIUVlSrGYRCHF1KgypsKpea1H
			VxBrsZRYqMC5VaTuncL8K2mxFy+a0yxCKjx/c6pgNhWrsGengCWqhLw0jUmwpGotmTTNnYoT2HCx
			xWxJheegxX+Plwg4py2aRZOQmoo9oanOVbzmfAm+yTF5ztdImO0s4XwvlrdyyQWsZKPLamzgql42
			4RsFr5td65R6sZ8RZj1LcijZ7YzY3QZbdH2vS57wdUfgC+ztrQMP3OXEpKs6d31XEcadyfquU6zv
			ifUUeQb+rp85fCc63ygpo4b1cvXPLhv3faKUdmbw3R7JuKqx33U0Gqs3TZ/mrFzGs52ne8fF4QPF
			NU8tWFej8hq7Yxx7846P2+GbakVFVQUc+VvA+PqDYZ/kAfx6HYBJp2/QFzhaeesny7Zty9pl9wdD
			FU+Hnzx+jMt9n7QEAd2Pn1b09o3u8TtWZ8Ftlm37yacHuo52hgC7OG+MDB8DRw1u2gNmOBweC4a9
			FHVG+nqszzpf3JWqj02a723q7w97WJWNpiYyv78iLPeHZfiOjIxXDP/+0e//9v94+q//+vvH6HTv
			37nz4A4ZXLm1kRKKjnQIPgfWd0Ap2yEbX0zsam1l0e1FzHa2EEafxRoGdmcZPUYUx22RPTVuwE7W
			IuuGvdDpzZRFhRPByr+P30PPyflemzDpe+3at4UAUTS/NoW5ctQZuwmi63U6ZerSdW+6ZffL3DIe
			Sb2Yg4WTuVg3I1pSAxcgsQVGdZKEYWkJwOtkJZ/BLffVAnuP10kA4OPH4bZrl+2gSV826yvXeN6P
			phfxO0vnW/0sdasjc7ZGjCMbr3/yyUT8Rhv62u9WXjFWT3iQyNEER82d73TvuAX+VHHNQAvnfO3j
			FVXj6Hrtdj/C186agVXAOXC+QE6P5AlXBsH7Dvp8zTU1hw7t6lseGL4XPGzHspIVaHwfhwJVFY/t
			FVWOz/ZcCfode9b95Cc/yfpJ1jZnZWfY48PIM3Y09QaDndjBCM56mQP2eDs6ZPhOuc7XwuB7jBnf
			JsJjP/ndNpbl3ITlNZooCN3dNtADuBwZ+cff/lmlf/jxd09//+Tp3dZWTHVuld3uyH0Wfn5A1TXY
			ZXCLc3QYYJO+/U3wgIzDTSwDq63t2OKt85Uzmp8NC1hmnbQsRo7iJIBvsdVK/nc+OVYzEm4CS1yf
			fURznPO9xhYZMX2bva6B0NvrjHG1eGigFr/OyDpfFnlW4MzqXQF4+3YM9rqcQFr0vvXKSiJKc26g
			qpJueZa33uUk48taG5UV2aQ6ucyVG9cb1XdlLWPW90DhgXXKYt8Tl9bvB98LPy8uuP2M852YcRXj
			YDGRmeA7FXsx7Hy3cp9xstt9xv1W8znf6d9xC/yp4pqBFgi+Fgw7H6qxo8/1wzHFnWtq0Pza/c3t
			7UBJgK8kHXYEnL5enzPkwGt2rdgz/Lg5YFcqOz+xd3oP+Z/YqyoOFazY5oAHq123bNk/Z/1km7Qr
			6D3r9YVx7ljy+AIBcNNeyRvAdGcwwCzb2dPhfS58mfk9xtKc+8PhJjhgXBingxG8YUrE6kfu3gGU
			/tNn//23//1//W9FlYeK/jnX0fMAMPvgTv+dVpzXHcH1RjThS4HnEXnGl/3gtG8TwR3/Gy4cxn/Y
			hv9n0Wo7i0rHntjKcRa2dcQJBeUmYVWMfbo4IWuSGT4jfMnt+Kx4j+IS5jJZrjP+d+quBPtnbL2L
			tVVLaKjggmL2y9YZ0T68pITuV1yCV83ifRn7SiObgs03Ry61RLK7xGkfRtlwuO5o2pc+W+d7LRpz
			JuvLlG/DEs1lvZI8letik7tyPQ2nr0G5IFqxyk0VrkCDZTl9TqcNkSr5cNpXkpOpqIKzU+4iaHMy
			9oKVdnZhp19XwWCv22ljPY0wAxrrY5UhfJfdYkt9v1c6++7HdGfE78zha9k8CbfVE+HJThiv73uG
			vgcjznfPdaMy2Vsd+1jVE9Omedh5unfczD8zXAulBXS+NVX2cQegFtOdx2sQxA4ywuPNYW+vz0MZ
			V75gsxd7j/rad1XaK37+709VPPEHxmX4Dj+uCHj3+oeHqyqqbh/4mWPc7/Cszjvw8ccHbgccoRBG
			mX3OsxLO7AabO9Hw+sLeWlxv5MWMqw6XBy67OnW2czTsPCDb3raTTWBN25pYXpSnm+LN4FKpSDNC
			tPX4cenL3/7fv/1fKFvrA7jsG2xehD4X6cv6G+Ea33OthFwqoMUqWILPRccL5hdhzxYQt4IZ/mJR
			uhpZ2GreyBmLRblUOT9h8pamNaM9jGKeL2KXrX+d6dsCaYqGtqSkBMAJx1RvjB6zhI6xxTA8DQxi
			irjrREaLdAYuQtRhWXVswYudd6khb/EcWgoL8otVXgS1KIp8zaDFvCZ2NGkjsTO45Jm9agy4T/vq
			5zbnS8Hmawp6r2XkON2SzxbxvdE/lIjV0CXJec7yRXStz+Xy2Xq7esuwKJZtkLKscG1RHa3vBa/r
			ssFvA/PAPgIy5mc5XbYud/2XbluOs/64E5kLl2KHpLr64wjfrKJby3Io7hxjfU9cYvCd7Zxv9SSb
			GjmW53J3x1hfttY36nwrd2ZuIuyCjNPM+V7m2c7Ti8N3CWgBE67sDoStH9Db7vDToiN7jd9eZbeP
			d4aBj/TNPBx0HAaE+tor97QHHJ9u81Y9tYcOy20VHj8ZD/j2PsE2C1U/3PZt5bjfc1aSenNWDLaH
			DgdbcL2SRzp7VvJ6aHmvz4NzvmCHQwE44amro3W+Uy81khOujrH2gTi3GwDyhtGNNtGqXs/XHnk2
			GKdnW0cGRs793V//puO46z9/+e7/W+Du6DwCgKVqzmh174+0to5QqQ1MgmYtggHICoFHKPLcj466
			Sa5UCf+0DQzxF4sy5wvcSEpR/qnCFdFiFiPnxdg2WjQhGr1ZUjQqnWK26EyieuYLgIC2hDkALzKz
			BO9YIjeoZ42Fi8lOI2TR7IpwE6zlgRUcRNZaGNFtYm3vLUhwAvRM3+3ySxbNUWKKaXKzQG1k4tdi
			zKTEAFPkK8gk+GJuWiq7BKuWxMv5RqpaXYtVHlvky0owR9Op5OCyzRYp06wc3G6nz42pWIO9rAyH
			zdXrhgswa6rOTQ64TpJ8dS6J4CtJbiwjacPsLdb1152eJ9XX+TA/63hdnc9Jnhngy+LO8lLf7z/+
			PtJhAek7ywpX1Yydl5WDfIERYAqnNhmxwuS+KeLODL6ORs3b1ZEIteJ/I4fIg/J+vtO942b4ieFa
			QC3YOl9Vu8Ph9wNx4Q9mXgGL/Y5Kv53Snmsc4Fs9QE1PwD8e9gUCle0hx1j77Z8HKp4Ot7TIQefH
			T+8FwwepvWDF7W3b9gC1fR2wM3H72tuD4XDnYa8T0Hv2LDDWFwCE01yvNxDEfrmUcOXxhD3Pg+8x
			uYcRnPw6jPDt7sdzcBGy9xgmQf8ddSQawQnckX86+fXnx/7qN+EvOn7dOd5zR85vRvhi2tV9ijSf
			i8Sb5RIbI0rkGcTC2CyPi4p6tH6xKHO+YOnyNWBuzSLrq2WhHr3mTLjAYkkRzODsjHINLHR5aaKO
			KjrBfwEXLDYKaIVFrGdVZBJUopgt0APN5PkDfN8T37MI2CzsQziTSk3DSljvMLikWKRrPrSUvkdN
			vRDC1OseW4sVv0fdvz4sJuiWWEvMrOEYcPoF/xZwSWTViuj44fknp4pU3gozmJNES1oavJ5kIUVI
			Q0srCEV5lNZs1sHN8TZm6twrUiBaFM1iUkqqxUjbxGRO0lHprylHa5bOVyZv1PlegkN2nnPQR862
			jhWnUhYaUZENZG9MonOkCgemOpd1UcozzuoWAJBdGGx2uQtqkbl9rgYMRqMhdvokoKzkk7CFAhXm
			6EvHRgxSndLcqBfpDPDdAfRddYtZ3+8V57ufCkzOJuxcElNesjomO8p4+W3A5qbNa7ZsUauTNm/S
			jE5g70+pyBXC1+44usegT9ZodNXIWcB1FMHRUHQ1d77Ti8N3CWjhsp2PhtqPhsDx+kMhv30cEex3
			NGPcGT48AOP2cPjo2Fgw0DyOa3QrHTWVXufPewm+h1nY+fHw03uBQNWTJ3Da/untdysxT9rjknb+
			PC+EKVtska8kdXgAvWOY4YxO2BsOU6/cjro6lnCVMiV81UrrXloG1N/9NUWcyZb+XWt39+cerOfc
			38aqU7UOtCJgW+883PrT3/zG95+/+GD8DhVwxllfDCzfx3W9dwbus2TnVjnYjLa3Ve6ddK6V5TxT
			ChcjMMWeF6WrkZCiMxTiMl2zaC7MU2fmWoqMKqHIkC0YU/INWrEox2xM06fp87PTsvOz9YKQWWQR
			9GZLYWpjdrbYaEoxqNRF2Zmq3D6TYM7XZ6cmJQszgq/FWiKUi6XlorW8tKS09L3SUmtpeanVWmq9
			WlpuvVpe/iFcUYrXlluLRbiNtdwKt8PblsOty61ieXm5le5TXnrVitU38JFeFPUGSObrU3XaZJ1o
			3pGTkpYvJBclAUOTDblipqhX5WemCJr8bNGYLZhyNUlJuXmFyWZ9erKgyTUmq5KSygxidm420Dk7
			ySCk7cgW1ebkxkxhR5EqMz9JVVSYIjwfvjOf81UynBXXi/QttHXR7K7SgMhNLpaFmm02pZKkS573
			dbEClJJU0DVIIWOidi9rpwB3c9oKBsHddsFtfBSBtlFlK5cTc5zdvrKuPhtVnkQuY8aVu/5LVoHS
			Dc6XrG8Os75R/GKhq/XrZz3nq6BXIeamTZu3bDm/RXsepLqp3rxGt3MvgveCgt/tNOkLxtfRXplv
			yNDojJs2b14D2rxpUxS9EdfLne9zxOG7BLRgYWd1e2ewM9Tc3Ol3tLf77e1+RwiccI29EnOfwQZ3
			djo6w55Qe6fdHwBEt/v9jsFtPof96RP/2Djg9vfDAN17AZ8f2fuBY+PpbXaskOV1SZ7TnwYCXlrc
			i1nTZ7HKBlDcK3lcOJEc8HaAGe5wE3uPTed81eRrGXmPYbJVk1xJA/78E+KXGDlAxZiRkiPn7vSM
			j1ccPPib44G/+nprT0/PyH2aCv7mwf2R+/fJ4rbeaWXGt5Xqb7B4M5v3xdP4eP0ygPu7j/X/JaJ+
			UZyvPkVjKMoXs/uMWiEnT1QVptUCn4oMZqPRbNALpqKiFKMoGAxiRpq+SMgGT5wjqkxFYlpurmCw
			5Fr6krXmQo1KLfZZBFWeJTstU9DPLF3YWnJxyHrmjLV86KL1wpB1+OKFoaGhC+VDF0rPDFmtQ3jF
			maGLpUNnzgCP4ezFoVK8RekwXgo3EYeG/uaR9czfnCkfGr5aOnTBWmIdGhaLS17wb0VR05inViXp
			BDFdqxfzLclFyWaLJducrzVaMgrzk4TU5LxsU6ZYaC5MVqsshXkaQczRiMYi0ZySpKoF7BaJFo1g
			yMkWhaJkizolOTfT3NeXpM1Wq4qSsqdZ7DvrOV85y4oI/K3ifHOxFlU005mqRrLMK8lVgJ173Uoi
			FlsDTGt/Xa5BCRGMTHXXS730AEhfV51zrc3ttrHgdJ1vkOo4I6QlqSy9sIzVlsRpYUrCklhzhePw
			W5bVl7UD62xQV19i7/dKxtX+WWY7R8ArkxLc7vn3f/D+++9rz78Ph/Pnb6rOr8nct/PQ3gnOF1T1
			uxqHY0e+IVtjzNys3qJSnT9Pd9uyZfMmJdlKOa7mznfad9yMdzlcC6aFm/MNBHzBIJW/CAX9ldjL
			qL29xYHzwA5ywHZ/zamz3nZ/S43fgZ7W3+L7XyHH+FasiVWB6VaYcWXHdUcfXHxacPvTbZiyNe51
			ebyf3kLUhjuDRFw8eL1jmD5Ni4sCYUy2AtV1nJ16qRHWdr7xBQMtotBLS4woxRkXGSEvRwbYxCxL
			hO4eAGN7v6fn7kdVAN/jf1Xxiw8eHmm9Qw73wQOsJ0lTvWh0aXFRZJ3vgJKuhVU34DEHjrFaWgP9
			X/QTgLsXx/mK4lXRJOpF0SywuswmsyklTbSkUucEM03Liji5KghwWaopFZfCYtUJURBTqRsBtmSg
			UDRlHokplhmGnS0Xh64On0m98H+eES4MXUD4AotLh4atQ0Mi/JaWD5VefCQMlZaIxXDWemZIeDQs
			AKlLh8rFob+B34vWofIzw9ZiYK516IJYDGwWS17UzA5fDFazNqUJVAhEtJgpo0qwCBYMmacJWGoE
			NqJFzBdSU6myNQaasQSHYEqrFcxYi8QipqZZWFMJ3GRpVKKDujKY5u98xepYx0vgVeZ8KSJM5pZN
			+Uo+pX7kYBnjcHTKF/v7ohnGfgvRJoMKvmmR79q+Llcd1ox0O3slrHIFfrcoLye9r29QqYNVT2uC
			4VgiBNcfrz/+VxR2zmKTvqzEpDznyyo8z7TIRnFkzjfiUy9fXvOD98zvvY86/76sFO3NGzeu7xvd
			uXPnXuouuHf79kNA3prKXXvyd17R6DKTiLznz+O7PTPTaKx+W3c59oG5832OOHyXgBautjO29wPk
			BuC43W4P+XyBow6gbKU/FAz5MevZb3c4vYfh2IHrgO0VNZX//u7dZnDF4xUs7jwM5hdrTD6t6ry9
			bdvP4YqaFq9bCpcdCCB8sZQkENfj9nhcPq/PifD1gCEGO9zRcayD2hpJU8O3WLzR30Y5xyz+G+7+
			uv+LblkDaF2p3tWAnAmNKc9kfCsqDv6m/vgXH23devCjh3fuA2/vU37zHaw1+YAys9icL63vVaZ9
			2cwvPCjO+lINSyLwF+i6F2fOl2ZocYmMJVVgC4YEwG0azvGih8N1PyK1/6FJTpOYSvnOJpr0FGhX
			RuuRMIMpVX7yM3O+xcUX0caKwxeHxAtDZxC+pWfAxj4CW1t84cwjgu8QwNd6lViMPwDmi2CBrcLQ
			8MXioYvlCN9ScWgYTO8Fq/Xi0yFxBv0c8KWJlhRGSkFgLwK/UJiEFPkF06sV5TKX8lIjuoLd3aRM
			+ZroiwZ1QrLI8WZx/nO+BN9rydcm4vcSZjtTjUhFyEqZvdjqT5Ii17jkNb5YkkNqkORiV9TV19eL
			fYwklk3VVzTIallJvTZwyba+3GxNUa9P4S45YaD08ePKqfrjXx7/8st6OezMnG8uNVeIJDzPvMJV
			Mct2rp6QIwXwRfcKMIUfLXnZ91PgeyngF/h7ZeehPXv2/G7X7+D40M6dV65kJ2sy1UhelSoJqGvU
			6XQaOESqPUfoy53vtO+4Ge9yuBZMC9fPNxToDQZ6sewjwNcPqGzHToD+EBjWdj+w1+HvPOXoHMd8
			aPTBFRXje/LHa6qAwc0VTwi+v4c/w+NPD56SbA0bTq/1A5UDTo/k7V3m9QF8fafCAd9ZoK/LczYc
			Ig7DSSzyHEbjK2HK1TTOt9hyA5jK1t52nwp3e7/2HsNSzljNub/13Dnwwa1yYSoKTA+0DvS09fRg
			2PlY/W/aHj6seLj1IRAX06CxwgbS9gGCthtXICn5VizRGR5JqXdFXRaUQtJkgvsXxfmaxCkylOTV
			NsomomXAprjUdYzZ8Oh8Hw2dAWwOCRfODJ1hzrd86PEFoPGZYYxAE3yH7CLAd/gCUJnB9wya3wtn
			4JqhiyVnhh5F4AuPVDqLKljTvp5iXC5sUdYMT14+NMVa4hlsmVk4X5HBd5LxvXTtUvalPLSy5GAZ
			ZBmKkbS2QYn5WSXZipoqoNXFwlbUONBNac++AoSwkyZ3awu7fDSjW99ra+gqyi2w9QKE3czisj6C
			iOh6JrcLKVwvw3cHxp1ZvnM+Wt8/VzoLntg/W+cbk+JsrN7yAzPAVyVry5Yt5/HvTfUNdLS667rr
			oH3X94Gu6+isMTMzM2mzsVr3tk7R27qo8+Vzvi8Sh+8S0AI6X1z9c8rrDYSDgaPY3z7oCAZw0ZHD
			D7/2Gqy+UVEzbh8H9lZRHazKneCGqyp2HTr4lBYbYZ7zxaqQ792NvQW3b/eNg/UMSB2S17fNCT7X
			C14a4OuRnF7JO4bNFDAAjfCFG3V4OjzTVrgi59vNGit0f40et9/T34YWuImKP46MUI7zCJXC6Jar
			XHU3nbyLztd7rOaDh/fvPrzX09oKN2dG9z4WtqJCzj2tkarOrLTzyACLO7OodGtsP4dj8NCLV+Fq
			siwTSyjLC2niC1+gPljY4TPA0aELF4aG/0aB7zBwFhh75qLifEUR2To8LDvf0qHSkotIbLjNcMmZ
			YasM36tw3dCFF2Y7z2VjxOFRZu98I1lW7HDtEvwWYqkql8+mFNmQ6pRqG70+KbbyBpv3ddok5Sy7
			HPBrK8OHwLZFTl96us3GikoOvlFb1uDCRoNI8Pr6SBdfXAzMXDAW1yDjexzh28cyrli+c/736+RZ
			X9bX971ZON/q6mplSRD9rEH4Muu7heir2qKCT4baaLy8KXPTpk1ob42ZSFwjnaK/meh4meVFBGuA
			vtXRZUb0H7jznfYdF+9PDNfstXBzviFscoDLiHoDPnDBPmx3P9YebAbLa0f+jtMcLrDXX+UH9ztu
			by7a89De6zias6y33T5+pMLur7AHnbaNBRvhu/mnn+6wV9jtQems5HX+uMHnk7xeXyDoPStJHkCx
			FyPMSF+0vz6Arg/nfHHt0RTwFU0I3/7+zwG63v6vPz/m+RrM7R2Ebms/VXHGjvdNPQNybYwwlXg+
			2VJz927NuPfYwX97CBS+29JGjQf7kbp3WB3JntYmDDHfiUadqc4GYBwDz2iTib6U6/zFcerasHi1
			nSdLfBnwtRajwwX4XgTuAnRl+J65OFSOYB0+Q/AF1FoFMLXlaGsJvnAvcfgMYvkiWeRSgc35gh0e
			BhrHvTikGFf4znjOd3LMmQ555GadNpvEVvrWuRT69irslcGLLtfW5XRLzshN3O4ODDiXSU4nENjt
			ttW5XV1luOqoztmHOJaw/obLTbRF/CJ84Twj8XFs5Hsc/gB868qy0rOUSd8DhazK1Tol7HxiVs4X
			VwdVy0eoNe+b4XBeNr6YRgXsVd9MMmZuugzsjXRQgBNGI6IYQAxgRvRGfC/+VscIH5w732nfcfH+
			xHDNXgvmfEv9ncFQZ8AXPhpqd7BGf45QaLw52I5TvHZ/ix1dr328xT9eUdXS2ezvbN5VM14RvJiv
			z/n0tq+q+S2/vaFhQ0NDw+kNDb22jduOAqn97bB78Trf6fJhN2BvOOCTznpcTh9Wq/TKqVcebxg8
			t7ej7pgH61wJqapnnptoEm8co7Cv5/Pur/ubmtoQo3JYmPU9aG3Do5NtbW0nT/bg36aW8fG7d8fv
			jtf82y8egsaPoGWGe7FyViMUfW7tBnvbc6dVjjifA5oPyNWs4FatlH4FdvpY/0D3F1Td8rhqiThf
			i0nAhbs484mNfUT8ScPJTUEFHMIZYcGkplnPeYHOKhJ8AbkXz1w4U4phZ4w1I3PxUD4kZzsPg7cV
			4ZLyM6UX4JLyM2eG4Q7WR+VszvdvwCjj7xk0zPATN+eLpb1wKhdOpc6icNd0ozVz5zsh7Hzp0iWF
			vnAqxwmu1emjhgfRKhuY8+yj1r1s7W8dRqYbnC6s9OybkBuNfRO6ugadLlsZVtmoq+vqLcPVwUVZ
			uLaoC1cWuaONfanFES7xddWxOHQ9kPc4IvjnCN8dy5TWRrnY2UjuLIh1NmYH3xj8gkFdQ4nORN6b
			QF4wvlvU6HzJ6F42sppXRF4mZO9l5nzf3v02Enj323gq8qDyX+MPSiwcvlO+4+L1ieGauxYKvmJ5
			6HAwFDgaCIUC3mDwaCAYDHaG2v3+YDAEf4KOFir5XGPvRPsLThj+7IBTgYuNGZpvf/n900MHntZ8
			CroNvz/vbfjJ5iBYZEetE/sYFaz1er1OL6Zcwc7H42UtFdD5epweTxgrPGNjBSy5US+mTAVfyw1E
			39f9n2NI+eTn3U1tA90YFCY20vqittbWO60tJ082ney5c+dOa9vJ5pa7VfaHH22t+MXTrQ8rgL5A
			7F+NYB8Flk/F+gciX8nutkbyrWjKuJX5afLUbIXTcSrzsUScryiqzYJWSBHUgGCVWmtJU6UKKrMo
			WDI1ZouoxsIb6mSzWUyxqOZDJGtJ+QWx/EL5hQ9LL5ReuFpeXnrhQrm19IIVDnCMF8L5qxcuXLAW
			l9Cl1qvlF0rxghsXrHib8hK8TcxvCdwvbv4cvlpoBTFJo1al4beOOMF3hnO+lyZ7XhaCzsEEKicz
			qErSFYWVMfHKyYBM5lXCxbq4wMjnUnKzkMmSC+A76HO6qLpknXvQYChc1VdWq66tc7l6bU62BHgC
			fN312IfBzfKc649/ic63vhbDzkqRqzyqMPk9CzvjeqP9s4KvsXqCAL7nMep8XqYv4hcOazYZFZdr
			3GSk07vh3G4kMtDXKPtdnWY3hZ6rdZOMb3W1wOE7zTsuXp8YrrlroeBruREIU7pzgJodhIJeYG4o
			hBcF2rH41fg4TvY2B48CeJub4eS442jFuL+rUn9N/+2lEwcPHXp64s//fH92csa31y71Fvzzzxzj
			d6s6j4IFCHs/vQ28dXrx0aWzHR6XBzsDS4hbnPQNgfMNYz9fbLJwfGr4gvPt7/b2e77uRlP766bW
			tu5+Yi7hsu1I20Bbd1uLv2X81y0tgOGek+COW3ruVnx0sOLhv/1iK+jhw5a27iaq7DxwB7k9MoKQ
			bmUElqd5abVR/wDDequM4FaWQY2TvseWypyvKGanqpIN+YUalc6g1uYIejE7zwBvj6JCXVphTrbW
			XLRD1ORmq9V5mvlYX5H6FBXDATOJi0usJaJYYsE6kRasFGmhK4rFkg8/vGotxgrQcHXxe3gEx9h2
			QaQaWBa6v1gCD0Y/cQs7w4Pq8/IEjZiTlKab4fKp54zWrJ1vtmJ45aNLlzIyVklEVnKn7mjDXpfP
			6ZbrXim9FCjfikAdrQLtwoVHuM4XU6zqnGW9gwXA27Lasq7kBsyEdjW4qGy0zN961moBC3DUY9gZ
			2Qu2F51vLbJXXul7K+9ALq70la3v+lkuNYr6U5yjfdu45v33U84z5jLnS+YX4WuM4vcy/mQad2de
			ztxkjMz54mwv5V1htrNRqXil/APufKd7x8XrE8M1dy1gwlUAV/oCcAO9IV84EGgPOfw1nUFHKBDC
			wDN1O3I0Bx2doWCouaaiYrzdAQTe6VgH+5x1Hx+qqBr9+H8/kZ18/bpGf8u37d9d2zU+XhX2OZ3g
			cX/8Wzh2en0A9rPuDnS8GHXGslYezLHChGdMt/J6w55pnK94s//rrz///FfdJ4GsbW09rRRCphyr
			1p6enjv+k21Npw63/Hrc/+vmtjZc/9t08mRbz/jd8fHH//aLf3v6dOtHd/0tTf1NA93nBpp6yNHi
			ZC/2HqQ8LCXyTElWI3R9N1vzy7KuWJMjhO+ScL7AtRwh2aApFERto6AvMulFTZ5etKTmFGrMjXlm
			dWpfkZCcp1cn5elS1XM3hERMIi0BuLgEyzTDWVosXMLKSGK5ZgvWm/wQyz9jDWcsCF0Cd7BgaegP
			S8QP8XbYoIGRumT2jRWmkUXUitkpuYIxJSdZtCTp4gTf2TjfS5F48yX5T5FLrh1JhGQLduGH2vhG
			UMxKVLGlRVT0qi7iknHGuHZHH1DZ1pde5qZCk5gOvSqdcrMk5yBWfVasL7UYrHe76sn2Mud7nDnf
			vnS20nfZqpy8W4VKbyOlytUc5nyjzvf997Xvo+tVM/7e3EIAXrPpspxqRQDejT+bgMBw8WWMRmPQ
			WUO/OsX5Xo41vkbufKd9x8XpE8M1Dy1ktnM44PV5we8GAh6fL+hob2+xA44Ph4PNmF/V4ve3hDD9
			OQB+2F8x/rCy8m7Fk4qaS5fybp24pN/ZaDjx57fyG69c2Zmx3/mTf/52H1hln1QL3+vDn/5Wgkf2
			YXQZ4OvySFRXEhwwwJdKPYexoyBNANeL2mmc7+eerz8Hpja1th5pbZXznHHOt7Wt6e5DcLz+ZvC9
			zW2Hw+BTAa9tbS2/vlth9x95COz9t6e/ePqwpampqZvymbtbqZwGsBfo2kS0leHbyoLN5Ia7I8lX
			rGoWTvkeX5SuRs+KFq4KYEqpaARb48sqaLBpYAGLa9Cf+U36EnwtIvYjsliKP8Sz2EKhBOszW0uw
			mHMJtlJA+IryD3IZOxuRCyanDNYZ2Qv3LrZai+ke83hKEyRQZ0GLKJjhtZpn3C9iutGarfNVeBs9
			delS9ipqzUs9AJXQM7JXctNcLaNsHRlcttgoUvNKKUW5w1CY3pfcN9g1SN18sboVdleQihqwqEYd
			PlLMnK/bSYWt2IQvJVvVK843XbG+OVhnI/f76FLfWSdcRadmsZnCGqyuQc6XgVe9hbSGZVoZMfp8
			eTciN5J4JTtfht63dZrdGIGODTizk9z5TveOi9cnhmvuWjj4hoGBvjAQODQ46PGFQ46a5mZ/J07U
			hvw1DpzjrbAfDgY7W8LN4/7QuH+8cofdbn9oz/pPv8zKurV+vf7bS9nZo/uuX9+XvarrwJ/8MtPe
			3NElHZWcDc6C32LUGUxwkDUSl6hHg3TWfdZFNjgQDnQA771OT8eU8MVs52MY+f0cmwiySlf93ce6
			W8bHxw+frGk5chcc78mWX7ecPHnq1Ne/QrbeudNz5+7Dh1srHm79xVNyvvfGW3uamvqBpm1NZHyp
			sS/AtwfMdKTe1QhlOlOdjQFGZWXid2ApzfnKmyWmuW/cV+8o/2PSGctUNykunmRmI7ea0uTGOSU7
			bprzOt9LlyKZV5cuLWPsVWZxyd3WIWJd7mgUmmLOBGB24zrW8miwq7YoV5+/o8vdVyYhT93Y0Mgt
			1WFkOs+J/K5jKdNEd+S70+mql5x1rLAVkFdOdj7uru3ry6LeCjTrqzhfxfvuf3H8YRJ8Y7RZyXQm
			w6vGZGdcarRmEwWaM43y38t0ksWc0fq+vVvOc6Zj+KmexF+e7TztO26xPxtcCwlfu98fCoR9wUDQ
			2xsIOhw1oWZ/M2DRG/Q3N7c0Y9jZXtEcxgXAh0MhOFt7CI4e1lw5cCn7Vn7+Fb3+SvbOK6P79iWf
			WNZQdOlP/nTc7xn0OIJHx8INv23whr2Y7Rz2uNwd7rO4xMiFcWeKPmNZS/C+eCDn+8xOAdf5Hvv6
			V5//ZX/359RWoX+gG0svt8FXgpa2kz09d4HCON17EuPNn3djpnJrz/i9hxUf3b1bAfT9xdOtT7fe
			7elpaqOFu91w3MRmfTGoPNDfNKBEnUdk/A70U2Ba5jAcd7PmRjeXxpwv10Jods6XCjkruVYRrb9U
			RGUzXNHOCdSySKJpXol6FVH0WbJhVjQuM2L+VrIV5dR2FfR2DdrcUm9vkext6xG+7nosQ5keacgg
			Qx2LOZMJllwsz1kBL67zda/oo4wrLLNxaxUuNso/EKkweeLSvOC75n1MtpJzrW6qt6jhBw5rALib
			jCzrCiPNeKSwGC/SxdTYoCIbkagzZjrjMYfvdO+4VK5F14LB93pw3D7eiVO9AU/Y42gPnQoHHTjN
			Gwj6O4HFzY5Dh8btFf6At7kzGAyGWsYrHTVgh/17TlzSJF/JbjQkN47uvHIFIHzp0jrfL//k39n9
			Ho/DgcWypB83AF0lL5DdB/B1YeDZhRWdPU6s7IzdfYMBLPZ8dlr4qjv6/5LaGH1OvQ5wDW5Pd0vL
			+J2enrYeqgg50NTU1tQEvhcrXAFM23rGHz6En4dbSU8O3r9z/07TwB0KISOGZfUMDDS1YY+jEdkM
			U4pVzwAuIW5lc8AD5ICpp8ONpeR8ueKr2TlfZXlRJOFKRvAqJ9laGcES9kBw+mwNCGA6JzHrio7X
			h+0REK6Sb7A3p5ZKXWFPQcmHsGbpVPWSC0+4nM50qoDlliigTZWjXdIgq0GpBJ3rccKXAdjVB853
			245IvjOr7xyxvrOE78Teu5uxkZE83atS2AvON9OomN3LlPC8ia08MsoAxiQrze63WcwZfa/cToE5
			XzzB4TvdO+4q16JrweBrChxuqWkOoEP1eELBsA877YZaHM3BULjdEerEueBgsMXeHDyIJTb8/uYd
			lXCHw46+Ewf0yckGfWO2/sqV0dEr+vX7f/lL27aPD+z0N/vtLcGv28ecn36GyVUeML/ejroYUT+F
			umOYa+Xx0NmuFNUU8DVZRM8Xf30MG/pi6tOx/rZu4GNbWxM1N+qm6hlNTZQRRV0GgZttTW2YblVR
			9fCh/WFFhf3u+BFyxpS53I03xrvAo7AINOGb/WmlpoSsQ0O33KNQhu/x8E0Vd76vrGblfHWXFPZe
			uhRjfddfWvYZlriS3JHIM7UGVALOyGRnr1TnJDDj1G+dr6u2rLYMVwDTRehny1j9SEqocrL4ckNB
			2VqaNnZRtBkJ7Bwc9LklqmqFFTYo0VlxvvVS37a+bXKRq1sA31tgfb8/oFjf/fMLO5/XbpGznYnA
			anC/N9eo11CoeZMxanovswW+l43kgCPVNZDA1TqscKWIWWDufKd9x129auaHRT4sGHxF0XK1tJQA
			n4pH7wnC1VIzXJQmwDm6QkwV4BalN29qb5aWlppTbl4tTSspNb+X8r4KdlkpWrX6ZopKDTuw8+fF
			86kfnoe7X33vaolgvvo+PBw+IHx5iPkegcI/V63wR/7fV5OmhC8mF1nh2pvyPekPPIlSq/w38gDw
			BOlpl15NKSXB6ZulEeEjCGmRh6BXVor/Hi5JSbOa4c6l+Czh+lR2NT7FVMFsZv9ZFWf4cue7hDRb
			5ytT99oE+l5aFpPTLK/yjfTwZY63d9AmYU0rl8tZ4KobzEt3upHVeAm2DayrkwaVr6fgantZe16X
			ZOsaLHOxtcCEYFeDDe1vHfU2qpNnfFnC1ZfH65xgfPvkuLNcZ4Osb8T5irOA7+XqaGJyNTlfVmFD
			pcaMK/WWNWh+yfky4rIwM/7B/GdCMEA5Nua8m+Z8Fc8rT/zyOd9p33GL7fq4FtL5Flvw86RlR9rI
			aUU3I6e02onXTLxiiquUB9PSbWSp2FHsPZSzU6ZhFpvMkSfGHilyn8gffNCYJzrl84her1VNf0st
			e77y04v+Ky3Bdxa782mHJzGcr6jKNprSzJhQrBFFQSfKnf2wuJbFIsCPHrsZiiYhlfUfwhuIVHsL
			G/jBUX4mXmIymVgWtmjRa0VBmPcTWxDN0vlOqOksa/+l9cs+k7sBRgCMbY5ialhJPh8t3gX+Om1u
			d1der4sSp9wUmcYYsrNXJi+WjqTSzvVud72zF+7jwxB0A9LcaXPa6B8561hd5+PyQiPyvnUu2fki
			e29hwnPhgdx8jDr/+azDzpuecb5UXkNNvlcN4GVh5y3M+TLiXpYBLJOXlh9pNDrlgKWdNUqRDXTA
			Op7t/Dxx57sEDgsHX5PJrFbJh8gJ1VQXTXFt5IrpLo85w6SSj5+9rXbqZyeKL37sZ89OeE7Pv+2U
			Vz1zWZzhu8Sdr6gTxWyNQRT0+RqtIaXWbE7WqfWiXp8sJmmSBSElQ59tTs4WdcakxkwhGU5l6w2C
			WZ+UrTfp1Qa4ZY7ObEgziPpMk14vZGfqtfnZemGJpjvP0vnK07wxppfCzllSjPOVO/rabGW90cgz
			QNbnxLlgadDldNaWOZ0ud1cXXUotfJ22XqWEFaVp+Xzgl4HFTptEfXvBSQ+u6CqQyPPGLDKiOd96
			LO4MvzjnS85XWepL1vdAZNJ3fvDdomLhZjbfi1Fn+KglySaXzC5N+l6WcSyv89VgxFkjl3h+O6a2
			s06GMF/nO907brFdH9dCOl+5ASzX8zW7taSJ7nxNumSVIbcPDG6+3pydnWfRWopq9RoxL1/IzDWk
			iaqURlGjUaWJO/qA0436ZMGQ0Wc25ycZVMl6fW2KWsjNNuen5Kca8oUiUaPPTy2qzRd1i/2qptFs
			ne/kTGdG36zoXG+d8iO5e9PTnYzFFEJmnYx6e7vy+6jGJCt4RSUl6wHIvhj4AnelXnC/OLdrQ5fr
			cktvpHdhnLoeb1BfF3G+cnVJOrj7VmyjfOcdyqwvJjxTytV8na9uM3YzYolWpM3ws2Xzzc1sfteo
			BJ/lbCuKQuMvc75vK+4X4auLkLdax4tsTC/ufJfAYSHhyxV3JbrztRhTRUMy+Fy9IduYrcnXpoi5
			GnCyO3QZRoNeZ1Kb9aIOvK5QpDNo9Xo9WNx8fbbWoCsyCIbMHLWlMV+TqVfrBYMmrc8g6FWNmUUG
			0bjYL2sazcX5Tqbv/ktZkRqSdWzWl3VScNlsvQ0uudAGLjXC0lV9Rdi6yIWLgH3Y+ZfWHEkup22C
			83XV1Uk+LA0NphhZ67OBbWbZWHJ0mkwv66qgwBedr0xfcr6y9V33/ceMvh/OfM53CudLPQQZfjdv
			YVFn9Rq1UUHvZfkoUmeSpn8RuUrUGdOudJMf18jhO907brFdH9fCOl+uuCvRnS/Vq0qDo3w91tMS
			RDPO8FrERjwWjFRbC2d44QVhmyUTTvxSnS29SBdg+SmBai5bTI1Y/co8/05LC6c5Od/J+I0635g2
			ReycbXBQTl1m1THqCvpcMpndwF1mfMEG17t80c4JLmzW66pz2orSbVjEGats0KolXEPM2h4Rfuuj
			tSXlsDM43219WdHmCrcOHMg9sA4TnpG+s0i4mirsLBN3izKNRO7XGC3pTLFmAvDuTFbv+fJunSb2
			EIWvLuJ+OXyne8dx57v4Bw7fhFKiO1+aimCojBCToZS1D6ZMKrantBCW5WsxQwuvpOtEE52JNBym
			WpWL/cKm0pzmfCdO++6/tD49MtVbFzkl19xo6MI1RDhVixc6y2qjadDOOioziQFpxHC0ZZGEHhkT
			r4p8FIR2OvtsTnnxEmVn1SmmF9Odj0cmf1216Hz7sLyzku+MNSYPKIHnWZeXjIXvFuohuPlm5ICn
			1WoZvUaGXvkkCz7jSRm7fxTBb/VE76urRvbOuPL3awZfrsUWh29CKdGd75z1AroubfjOOtt5QuC5
			LxprjhXi1y2V1UYSn6WywUixScntZOuRJCdFpaUIe8EfN1AJLGcZ2WDJ17cCqzvX1yuLkerJ+NZF
			ClxRicn641KtstBXWeqbw+B7YN3HJz4G+Ja8cAxN08F305YtcsyZ/C+gN2lzEjpfRtvdl4275U6+
			LOl5N0Owku1M/AXn+/bkxwX4Wjh8p3zHcee7+AcO34RSwjvfuSqh4Tvzdb4ydq89A9/oOqMIehlm
			u/q6bBSHtg1Kkag0rTqiFcHUjyECX+rH4HZSBUk4hflVvc4CmlJm8EVPXB8Ved7jX9JJgC+lO0cD
			zzlEX3S+H6+bN3y3JJH3TcLDGnVSEhB4TRKRN+J3d+NPJBK921gNxI1INxV83+bwne4dp05Scy22
			Zg7fxX6mXM8brcnOd7GfaZyVNK+rF0kzd774CpKir0N5OUnyxTGvMmnSi532lc94kyQ9//Lo1WuS
			1ihnb8TcjJ5iUtKs/iHe+gbdSXndSeqY1zrpL20GZfMkyXeb9MyVR4keZrcV1LPYFcZfi9JYgXqL
			8cMiHmbhfBf9ufLDLJzvoj/XOB5Mz99VmJbonmTmzpdZr+IJLjEyhwoXi2zqUjZxeOYFr1y5Ykbb
			9pkLi02YPYX3jvyDqHmVhVVRLMr8vHztTMdyal8cCV/gSfbgyr9gR+xEzCNYopoi+MEywGYxXC+b
			gFHxrkavpXjYOZH02s75JqRm7nwX+5kmrCxx7CfJ4cv1csXhm0h6bed8E1Kzdb5ciyoOX66XKw7f
			RBJ3vokk7nwTShy+XC9XHL6JJO58E0nc+SaUOHy5Xq44fBNJ3PkmkrjzTShx+HK9XHH4JpK4800k
			ceebUOLw5Xq54vBNJHHnm0jizjehxOHL9XLF4ZtI4s43kcSdb0KJw5fr5YrDN5HEnW8iiTvfhBKH
			L9fLFYdvIok730QSd74JJQ5frpcrDt9EEne+iSTufBNKHL5cL1ccvokk7nwTSdz5JpQ4fLlerjh8
			E0nc+SaSuPNNKHH4cr1ccfgmkrjzTSRx55tQ4vDlerni8E0kceebSOLON6HE4csVJ6mS1yenmUxp
			2evfTnvOzTh8l4TmPVrc+b5EzXS0uPNdEor3rjD+4vB9pZSctXLlyiyd/Gf623H4LgXNf7S48315
			mvFocee7FBT3XWH8xeH7Ksm4MlZZqmlvyOG7BBSH0eLO96Vp5qPFne8SUPx3hfEXh++rpMIJ77iV
			hmlvyOG7BBSH0eLO96Vp5qPFne8SUPx3hfHXUoKvoBVftElFrTDDW76WSp/4jiuc9obxga9ZZxSm
			vkYep+kFb7zo6dd0NOMwWjN2voKKSZhyZPBaGgSd/vnjpjUkLfZWWyzNfLTi63yFTJ35RbcRtTi0
			ptf3o/Ss4r8rjL+WEnz1y6cPDshSLV+G70TNamPkIrPmhfd6bbTyZcLXnPfWm28W6GM/7UadfE61
			XP/cJyrmvBn9Lvq8cX+VRzcOozVj56t5k0k/5cjQtRsNoil3beZzn7LmreeP6yusmY9WPJ2vuL7g
			zTffytE+/1aq5TB+b2WppvwoCZqkxd52i6D47wrjryUEX8sM4Ktd/qbeYrLEwte4WrPYA71klEtv
			tG3y78KGncWc1dmC1rABxiOiwizZOGlfAN+ktavTle/zzx33V3l04zBas3G+mtXZYI+mgi98njQq
			lWFDtkl8gcmymF9bZzXz0Yqj8y3O2JCrErJXL3tBQGK5AcZ3bY4w1UfpRZ/FV1Px3xXGX0sIvpGv
			bRZdzkq92ZSUr4Odhj5DhPPp69m7T7V87Wodc74WY2H6OpXJmLNhmV7QGGCvka0X1Pk6Q5Y25g6v
			lyZmGaxc0IQrzcZkOBZzl6txw8NAZQv6N94pNJqEjPRcI37gzYaVeUZLZDxNGoNu1Tp254x3MlZT
			BmJSXroGxl0DI2mCwYP7pMND4ElDeq52ytEVk5ctS34VGBCH0ZrNnC/7HgPwTU7PSzKZlE1NY4lf
			ZtOyCi2wpc2GXBBubPybDfdYtzJfjdtfk5Whzo988F43zXy04uF85cHRrsjBd3ryRp3ZkLw+PRMG
			Y0Vukkm7DoZSA6MCl+Kt2Tcqw3IV7kIF+HxkCHCVJgMHWp1bkG4ww6CteK0GLf67wvhrCcFXcUAW
			/YZVue+s1JrT80SwSBlwPsfwDoWb8Stezkot7SwyNuRkrFyhYrtnuiv4LuPqtVnrUmLu8HrJYmDf
			85jWT3/DOMDXwEZLV6AhwytkFTL4inkFOTkrV+tN6hXLc4s2ZETG06TfsDaHPSehKEe1Ih+4rFu9
			Mjd95XKVcTXsRDLWZsJ9DDkFyQCKd1blFMB4Pju62tyC3HWrc18B+sZhtGaT7czgq13+RlbuO+8k
			mZRNbTLJkSQhK0eELY3whSEk+K7asM5kXLtSn7XWaCoseKcwGR9D/uAt9tZ72Zr5aMXB+SqDg58u
			JtXy1Svzk2AwctMLdMKqHFFY9ZYGBoeuZ+ZW/44axk/IWWswwOcDfEpW4doVKgZfTUFexsqVL4he
			v0qK/64w/lpC8FWcr3q5wWLKXJsB59WwQ05SL88wwXl6l8FXPPUbuSLsLCyZOgvtT2ifEt09w31j
			7/CaKTUnEm1Zuc5UPO3t4gBfOcSsfkevwJddpsMdevIGPdB5jcmSv0IbHc8CnamYnpNxbbLJsEJr
			EnPSU0zmLNhjZOXB3mSVgBda8uVxzAYkPDu6tL/RrDWaEl/zH625OF/wUsYCtv1xU+NVBF/NaoP8
			ERRzV6jxYvOyZWYxrwgGt6jQUgjDiY8R+eC9bprxaMXB+SqDw74VqWi6AMZNzIPPi1BUJGQsV6lX
			vJNvymC7THK+2vR0M8IXp3gNb2jpDghvujI33WxK0b1O0cC47wrjryUEX8X5agow3Azf7TLXJgur
			8kRNgT45OXsFTVzgV7zk1cn0ntRq9FlvMfhaortn3DPH3OE1U7H8lgPlLGyFq2IZvklrJ8EXvn/T
			3kBYhhEz3WpdZDyjE1IG+FqF+wXtGzgXg5dnLFcnvZMsLMtKTk5eh05Yw5Dw7Ojq12YkJ2e8El+t
			5j9ac3G+enl45E1tQuf71jvLV79ZZGbwtSQX0JSAxQAGWftGIdwuJ0ug8abHkD94r5tmPFrzd76R
			waEdnT6SKMc+LxnvqI1rdZqV+nRtDkWlYVBXL3/nrXeMNH5iEtxzuYoGGseL7qkpyMpQW0yvkeK+
			K4y/lhB8FedLbzhL4TIByJv5TrJJsyEHZ58U54vfy/XgfPUbVuQaCp5xvrjTjrnDa6e0nBm84eLh
			fAmyQNeNmknwxaHAvTtegKMTGc8IfM3plHmbJ7K5KrwcyAv8FbLewJEzmCfAd+Lo6gsK8TavgvOd
			/2jNac5XHh55U+NV9HU1SZS3tHEtS6JLxrkA1fJ0NgeswDfywXv9NMPRmr/zjfkcKHO6yrjBueS1
			meZ0Q35h0goNxvjoeviGhL4Wpw2KNi5bl7dcpZoAX4sxby1+u3qdFOddYfy1hOCrOF+MSZq0K/Lh
			XbYcJxYpziiyOT76OqdeUbDaqMJg5oSws5gj755j7/D6iX3hMzz/RvOHr8VYgLtoMWeFFriYZkpZ
			KcOXbBNeWYj5zBlrkyLjGU2o22iAL/aFy9VpWRRLo8HLW1VosRQWwR5EZANrmQBfZXQtGlwN88qM
			7jxHa47OF44im9pkiq4eoI+gekUhbV3GYCEL5+YFeZoBHiPywXsNNbPRmr/zLVYGx5yehcCEzxQh
			FGdncConxWRYuTJZyFr1DlsZpiQ04/jRWBqega+Ac0Gv2aDFd1cYfy0h+LKAYrJRWPWGUWvAZFj1
			8g3wyRdWrTQKGasjzhcTbVcbU1YUCimFb2pMSWsNWotmQ16mYaMM39g7vIZKy8VJjueHmOKx1Ch3
			Q26mZhnmPGe8tS6zcAPAN3+5UVCtyEpKynpLb9IVGLTGNzAzRB7PCHzz6QROPOo3ZqgyVuPZ5A1g
			oU261XrzmqwiIeJ8nx1d7cpVa8yGF6xHTRzNc7Tm7HwjmxqviizdQ+e0bLkRS26oV6QnqVQplozV
			2YLxjXyLAt/IB+911IxGa6LzndOuMDI4mo3pmiRDQa4cJMooyDBr1sK3H92GtUkmw5tZyiIQeY4N
			xk9XkCwa34iBb8qKHJWYtyJJ1BfoTK+X4rorjL+WEHwtegpGFpq0RW+9uVaDa1QK6bsani9YL09u
			4LtMXAc7C83qNwvy4b0lGjasSIGjDfl58u459g6voywGw4tuEgf4WkT96jffXKGDcUrNe2ujIavQ
			ZMlc8WaGSbccNj6MkyV79Ztv5ZhNkfFU4KtdUYifBwF2LkLuhjeLDCxQDRaa7vNmujrqfJ8dXUvS
			yjfZ2+PV0PxGa87ON7KpTZOcr3E1fgrBQdGnMUsQDRtpGCNzvsoH77XUTEZrovOdy2erODo4uhVv
			vrlxnSDzFQdjA5yDs5jbuEF+MrHOV8zf8OaKwhj4ArHXJqnS33yzIOOV+dDMVPHcFcZfSwi+Md9Q
			hJSJbxOsmhabr4anLUqhPAueEy0WS/H0d3i99OLPWHzKS1pSJqVPsn8cqWAYOTF5PGM0+aqY8ocs
			JDrF6JpTXqW9yLxGaz61naObOvIULM+/HbvNC2uHvsqawWjFwfnGbvSJJSPF5xaQxGdnUe7w/H3o
			66E47grjr6UEX66XJt5YIZEUH+fL9XIUB+fL9fLE4cv1csXhm0haIOfLtSCKj/Plekni8OV6ueLw
			TSRx55tI4s43ocThy/VyxeGbSOLON5HEnW9CicOX6+WKwzeRxJ1vIok734QShy/XyxWHbyKJO99E
			Ene+CSUOX66XKw7fRNKM4JvC4bs0hPBN4c43UcThy/VyxeGbSOLwTSRx+CaUOHy5Xq44fBNJHL6J
			JA7fhBKHL9fLFYdvImkm8E3l8F0iYvBN5fBNDHH4cr1ccfgmkrjzTSRx55tQ4vDlerni8E0kceeb
			SOLwTShx+HK9XHH4JpK4800kEXxTOXwTRBy+XC9XHL6JpBnAly305aO1BLRGy+d8E0gcvlwvVxy+
			iaQXwzeFw3epqJjDN6HE4cv1csXhm0h6AXzTuPNdSlozocAVh+8S12sF31epD3qiyjJz+PLhWnQ9
			d7QmFHfmo7X4sqyZYWln/tlaCpr5rjD+eunw3SIs9ubmMsEo8OFKGD13tCZkXKn5aC26BPUMk535
			Z2spaOa7wvjrpcM3ZQv/vrfYKt6SwocrYfT80ZqY7sxHa7FVvGWmK434Z2sJaBa7wvjrpcNXUG0R
			+HtuMWURtsxi1PlwLa5eNFoTJ33VfLQWVTBa6glR5zT+2VrCmt2uMP4ofPn/MmXLGq7F1Oy+7PHh
			Wly9YLTSJkz6atXqxX6+r7fUatXM4cs/W4utxfS9iwJfLi6ueCltYtxZpVKrk5KSMjMzjUajjqTh
			WjDRBoYtbYQNDpsd0KuSo84vTnbmet3F4cvFlciaAF8twjdKX4W/Og1HcLyl08jbNpa9ahUzvjOZ
			8uV63cXhy8WVyJpY40o1kb46hb4RBOs0/Hcev7oodBl5J7NXNdMSG1yvvTh8ubgSWTGTvrHWN2mT
			7H2NE/jLFU8x9BozNyF7Y41vyoymfLleb3H4cnElstKms75JEfpOMsBccZDMXWZ7o+ydZHw5fLmm
			F4cvF1dC6xnrq3hfpEKEv8YoiPnPvH4mKtP4LHtnmOvM9ZqLw5eLK6EVzXdOpdVGUfomZW6aCr9c
			8RKZXkJvlL3c+HLNUBy+XFwJrdi4cwx91Wvk2DMzwHjgiptogyYZcfvK6I2ylztfrhmJw5eLK7E1
			DX2TmPtlBFYgzBUHyVtU9rxrktRrJrCXG1+uGYnDl4srsaXAN+UZ70vuVwYwQZgf4nEg7GbKW1ad
			tGYK38vhy/VCcfhycSW20mKrXEXoS/hVr1mTFAEwVzy1hn7XEHkRvVOwl8OX63ni8OXiSnClTQg8
			R+jL8EsERgTzQ9wP8vZVcfZyzUEcvlxcia4ofCP0ZfiN8DdWa3A6mB/mcJhCqih6o+zlQWeuGYjD
			l4sr0ZUWM+07Gb8q5IOaK+6SsRtB72T2cvhyPV8cvlxcCa9JgWeZvshfrSpGxGEVo4ZaxY9ndaxm
			22+y5C0dg17OXq4ZicOXiyvxFUPfWPML+GUWmDFYSwd2RrmEH8/wWMu2n8Jctjlj0Ut9BDl7uWYq
			Dl8urldAsd6XHZC/CoJlTKhkGE+4hB/P7FgV2X7RK4i7cv9e7nu5ZicOXy6uV0ETva8cfQYApzA+
			aLniqhR5q8qWNyWy4Tl7uWYoDl8urldCabH4TYniNyKZGVpO4jkpZtM9s2nlXDcFvZy9XDMQhy8X
			16uhyfSVQ9DyD1ecpWzZmK3N2cs1C3H4cnG9IkpLm5R3Jc9ERjkRgwx+mOVh0pEcak6JkldBL2cv
			14zE4cvF9aooLW0yfxUGp8aQgv/M7SfmSLksOtWbGt32i/0u4EoQcfhycb0ySpsav9FI9KITLJF/
			okfPKI2zl2u24vDl4nqFlDZBqVwLrolbfLHHnytxxOHLxfUqKW2yFhtOr7Ke2diLPfpcCSQOXy6u
			V0xpXIuixR53rsTS/w94IlhR2ROzLgAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAyMi0xMC0xNFQwNDox
			NTo1NyswMDowMH5lXQgAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMjItMTAtMTRUMDQ6MTU6NTgrMDA6
			MDD5cJVdAAAAKHRFWHRkYXRlOnRpbWVzdGFtcAAyMDIyLTEwLTE0VDA0OjE1OjU4KzAwOjAwrmW0
			ggAAAABJRU5ErkJggg==`})),'ottokit':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:40,height:45,viewBox:'0 0 137 141',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('g',{clipPath:'url(#clip0_94_39)'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('rect',{width:136,height:136,rx:36.6154,fill:'#D2F059'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('g',{filter:'url(#filter0_dddd_94_39)'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{fillRule:'evenodd',clipRule:'evenodd',d:'M67.9896 95.4199C83.1335 95.4199 95.4077 83.1441 95.4077 68.0011C95.4077 52.8581 83.1335 40.5822 67.9896 40.5822C52.8456 40.5822 40.5714 52.8581 40.5714 68.0011C40.5714 83.1441 52.8456 95.4199 67.9896 95.4199ZM67.9896 116.387C91.1203 116.387 110.46 100.156 115.241 78.4616H128.141V57.5385H115.241C110.459 35.8451 91.1195 19.6148 67.9896 19.6148C44.8596 19.6148 25.5201 35.8451 20.7384 57.5385H7.83594V78.4616H20.738C25.5189 100.156 44.8588 116.387 67.9896 116.387Z',fill:'url(#paint0_linear_94_39)'}))),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{fillRule:'evenodd',clipRule:'evenodd',d:'M196.46 91.2888C208.288 91.2888 217.876 81.7005 217.876 69.8728C217.876 58.045 208.288 48.4567 196.46 48.4567C184.632 48.4567 175.044 58.045 175.044 69.8728C175.044 81.7005 184.632 91.2888 196.46 91.2888ZM196.46 107.666C217.332 107.666 234.253 90.7452 234.253 69.8728C234.253 49.0003 217.332 32.0797 196.46 32.0797C175.587 32.0797 158.667 49.0003 158.667 69.8728C158.667 90.7452 175.587 107.666 196.46 107.666Z',fill:'#FEFEFE'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{fillRule:'evenodd',clipRule:'evenodd',d:'M243.079 80.4664C243.079 80.5443 243.081 80.6222 243.081 80.7001V75.933V80.0348C243.081 95.2752 255.42 107.634 270.653 107.666C270.658 107.666 270.665 107.666 270.67 107.666C270.684 107.666 270.699 107.666 270.713 107.666C270.727 107.666 270.741 107.666 270.755 107.666C270.761 107.666 270.768 107.666 270.773 107.666C276.29 107.654 281.428 106.025 285.739 103.228L278.076 90.6257C275.989 92.0801 273.45 92.9329 270.713 92.9329C263.59 92.9329 257.815 87.1582 257.815 80.0348V60.0664H281.614V45.3332H257.815V44.1999H257.813V22.6667H243.076V45.3332H235.146V60.0664H243.076L243.079 80.4664Z',fill:'#FEFEFE'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{fillRule:'evenodd',clipRule:'evenodd',d:'M292.966 80.4664C292.966 80.5443 292.966 80.6222 292.966 80.7001V75.933H292.968V80.0348C292.968 95.277 305.31 107.637 320.545 107.666C320.552 107.666 320.557 107.666 320.564 107.666C320.576 107.666 320.587 107.666 320.599 107.666C320.61 107.666 320.623 107.666 320.633 107.666C320.64 107.666 320.647 107.666 320.653 107.666C326.173 107.656 331.313 106.026 335.624 103.228L327.963 90.6257C325.875 92.0801 323.337 92.9329 320.599 92.9329C313.475 92.9329 307.7 87.1582 307.7 80.0348V60.0665H331.498V45.3332H307.7V44.2V22.6667H292.961V45.3332H285.033V60.0665H292.961L292.966 80.4664Z',fill:'#FEFEFE'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{fillRule:'evenodd',clipRule:'evenodd',d:'M372.348 91.2888C384.176 91.2888 393.763 81.7005 393.763 69.8728C393.763 58.045 384.176 48.4567 372.348 48.4567C360.519 48.4567 350.932 58.045 350.932 69.8728C350.932 81.7005 360.519 91.2888 372.348 91.2888ZM372.348 107.666C393.22 107.666 410.14 90.7452 410.14 69.8728C410.14 49.0003 393.22 32.0797 372.348 32.0797C351.476 32.0797 334.555 49.0003 334.555 69.8728C334.555 90.7452 351.476 107.666 372.348 107.666Z',fill:'#FEFEFE'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M415.406 107.585V22.7552H430.74V69.7553C434.364 68.9912 437.807 67.501 441.07 65.2847C444.333 62.9919 447.161 60.0496 449.553 56.4577C451.944 52.8658 453.032 50.0835 453.973 45.4217H470.286C469.125 50.3128 467.822 53.5154 465.212 57.7188C462.675 61.9221 459.703 65.5903 456.294 68.7236C452.886 71.857 449.335 74.1878 445.638 75.7164C448.466 76.557 451.293 78.009 454.12 80.0725C456.948 82.0594 459.593 84.505 462.057 87.4091C464.524 90.2367 466.625 93.37 468.365 96.8092C470.106 100.248 471.266 103.84 471.846 107.585H455.533C454.809 104.069 453.612 100.898 451.944 98.0701C450.277 95.166 448.32 92.644 446.072 90.5042C443.898 88.2879 441.469 86.492 438.786 85.1163C436.177 83.7407 433.495 82.9001 430.74 82.5945V107.585H415.406Z',fill:'#FEFEFE'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M476.262 22.6667H492.127V23.8C492.127 32.5629 485.024 39.6665 476.262 39.6665V22.6667Z',fill:'#FEFEFE'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M492.128 45.3333H476.261V107.666H492.128V45.3333Z',fill:'#FEFEFE'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{fillRule:'evenodd',clipRule:'evenodd',d:'M504.453 80.4664C504.453 80.5443 504.453 80.6222 504.453 80.7001V75.933V80.0348C504.453 95.2752 516.793 107.634 532.025 107.666C532.032 107.666 532.037 107.666 532.042 107.666C532.056 107.666 532.071 107.666 532.085 107.666C532.099 107.666 532.113 107.666 532.127 107.666C532.134 107.666 532.14 107.666 532.145 107.666C537.664 107.654 542.801 106.025 547.111 103.228L539.448 90.6257C537.361 92.0801 534.822 92.9329 532.085 92.9329C524.962 92.9329 519.187 87.1582 519.187 80.0348V60.0664H542.986V45.3332H519.187V44.1999H519.185V22.6667H504.448V45.3332H496.52V60.0664H504.448L504.453 80.4664Z',fill:'#FEFEFE'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('defs',null,(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('filter',{id:'filter0_dddd_94_39',x:-14.4962,y:12.1708,width:164.97,height:141.437,filterUnits:'userSpaceOnUse',colorInterpolationFilters:'sRGB'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feFlood',{floodOpacity:0,result:'BackgroundImageFix'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feColorMatrix',{in:'SourceAlpha',type:'matrix',values:'0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0',result:'hardAlpha'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feOffset',{dy:14.8881}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feGaussianBlur',{stdDeviation:11.1661}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feComposite',{in2:'hardAlpha',operator:'out'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feColorMatrix',{type:'matrix',values:'0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.06 0'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feBlend',{mode:'normal',in2:'BackgroundImageFix',result:'effect1_dropShadow_94_39'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feColorMatrix',{in:'SourceAlpha',type:'matrix',values:'0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0',result:'hardAlpha'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feOffset',{dx:-3.34982,dy:11.1661}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feGaussianBlur',{stdDeviation:6.51353}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feComposite',{in2:'hardAlpha',operator:'out'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feColorMatrix',{type:'matrix',values:'0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feBlend',{mode:'normal',in2:'effect1_dropShadow_94_39',result:'effect2_dropShadow_94_39'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feColorMatrix',{in:'SourceAlpha',type:'matrix',values:'0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0',result:'hardAlpha'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feOffset',{dy:3.72202}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feGaussianBlur',{stdDeviation:3.72202}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feComposite',{in2:'hardAlpha',operator:'out'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feColorMatrix',{type:'matrix',values:'0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feBlend',{mode:'normal',in2:'effect2_dropShadow_94_39',result:'effect3_dropShadow_94_39'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feColorMatrix',{in:'SourceAlpha',type:'matrix',values:'0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0',result:'hardAlpha'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feOffset',{dy:3.72202}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feGaussianBlur',{stdDeviation:1.86101}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feComposite',{in2:'hardAlpha',operator:'out'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feColorMatrix',{type:'matrix',values:'0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.08 0'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feBlend',{mode:'normal',in2:'effect3_dropShadow_94_39',result:'effect4_dropShadow_94_39'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('feBlend',{mode:'normal',in:'SourceGraphic',in2:'effect4_dropShadow_94_39',result:'shape'})),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('linearGradient',{id:'paint0_linear_94_39',x1:67.9887,y1:116.387,x2:67.9887,y2:19.6148,gradientUnits:'userSpaceOnUse'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('stop',{stopColor:'#072F50',stopOpacity:0.95}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('stop',{offset:1,stopColor:'#172A39',stopOpacity:0.75})),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('clipPath',{id:'clip0_94_39'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('rect',{width:136,height:136,rx:36.6154,fill:'white'})))),'sureforms':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:40,height:40,viewBox:'0 0 64 64',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('rect',{x:0,y:0,width:64,height:64,fill:'#D54407'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('g',{transform:'translate(2 2) scale(2.0)'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M9.14307 6.85645H22.8574V11.4279H11.4288L9.14307 13.7136V11.4279V6.85645Z',fill:'white'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M9.14307 13.7139H20.5716V18.2853H11.4288L9.14307 20.571V18.2853V13.7139Z',fill:'white'}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M9.14307 20.5713H16.0002V25.1427H9.14307V20.5713Z',fill:'white'}))),'custom-layout':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{viewBox:'0 0 1736 660',fill:'none',x:'0px',y:'0px',enableBackground:'new 0 0 1736 660'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('image',{href:`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAABsgAAAKUCAYAAACpPr14AAAABGdBTUEAALGPC/xhBQAAACBjSFJN
			AAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAA
			CXBIWXMAABJ0AAASdAHeZh94AACAAElEQVR42uzdd3gU1f7H8c9sNg0SSgodpEkNRaRJr9KLKAoW
			FAW9Knb0ggUU/VmuBUVsgBdFvaJIr4L0Yui9V2kBEkJIIW135/fHbpJNSEIoIQl5v55nH9mZM2fO
			OTNnYuabc44RFXXRFAAAAAAAAAAAwFXauWuPWrVsntfFwC1szdpQ1Qupc8PzteR1xQAAAAAAAAAA
			AICbiQAZAAAAAAAAAAAAChUCZAAAAAAAAAAAAChUCJABAAAAAAAAAACgUCFABgAAAAAAAAAAgEKF
			ABkAAAAAAAAAAAAKFQJkAAAAAAAAAAAAKFSseV0AAAAAAAAAAACAVNsma+iEHW4b6uvprwerUV6X
			65rLLzV6cqyebni9Ge/QN89M1pZGgzVxSP28rmWBR4AMAAAAAAAAAADkC2ELPtSoeaX19NdjUwNi
			YQsma8sZSWXyunRXtmXSS/pmS2n1HTVWPVLKe2aJRo15SaN6jtCY7qVzntm2yRo6p4LGjOqsspKc
			gcKxeV1FJR+YrQ9/2KyL2aSp1P5ZPd25tDzzurDZYIpFAAAAAAAAAACQD5zVlk1nVbZn93Sjxcp2
			H5wWbMrPtk3WN1vq6+mvR6Qvb5nOGjOquzRvsuafyetCXj/PGn3Uv65NF6NiMv/4NFf/jvk7OCYx
			ggwAAAAAAAAAAOQLpVW2nBR2+qykrEdaOUeZnU397py+0Dn9oJ4cLE2YrC2p0zKe1fwxH2pWSmCq
			THe3EVlyje5aoDDX17Kpo7ycx61vPEJ9T3+ob7Zk3H+5LZt2qGzPEZlPBVmms/o2WqBv5u1QjyH1
			nXXYdKfG9D6pUanTMaZNJekciSZJOzTqmQVSo8GaOKR0apnSyuCadjH1RO7TUeakDhmOz+H0jbUG
			Dlar7V9rTezl17DHkO4qWwCGZxEgAwAAAAAAAAAA+UKjnt1VdsxkDR2TIZDlkjYFoysQdWZJulFZ
			WyZs1tNfj9XTktwDRBNdAaEtk17SqEmlnUGgM0s0asxmNUudDnGHvnnmQ31TLm29sLB5H2r9k2M1
			cYhca4tN1vxGIzIZ0XZWYaelso2zDuw1alxfmnM2NRinMws0atNgTfx6cFrdnpnsDHANGauJl02x
			eDZ9hq7gXtknx2piSnnd80hpsyzrcFbzx0xWWM+U9jmr+QvOKkcst+vRwc215ctQXXLbXLb7YPUt
			d5NulutUAGJ4AAAAAAAAAACgUCjTWWO+HqG+WqjRz76koZN2yDRTdu7QrHlS31FpwR+V6aweDdMO
			Tzc947YFmqXu+le3UjJNU6Zp6o6e3VV2y2ZtkbRl3gKp52B1L2269tdTn56ltWXTjrQMGw1ODZap
			YXf1LXNWxzOdJvGsjp8prUpXNRVkfT3tNlqrbPfuaqQdWr8tZ0dvmbdAYe7lkytAVSZDHleoQ9ly
			peRs4tLq0f3Ko8dS1X5AT7f0TXftnr6aNdbyGCPIAAAAAAAAAABAPlJaPUZ9ph7aoW+enawnn3VN
			G7hts7aotJplE4QqWy4tQBN2+qx0ZofeHrYwfSKjlMLOnJVOS2FbPtRT8430u0ufVZhrikf3/NLl
			2zCzQJAr8JTTIFmZChlGyDkDbMdzdHBWI9ac01SuP31Wanh5m2SsQ6PGpTV74it6snQ3vfNWJ5U1
			DBlXPHeatKkWC87UiikIkAEAAAAAAAAAgHyovp7+aoRzDbEFZ9WonDIJKl1Bme56J5OpGqWzmq/s
			1hTL4VSDbmVt1kialWXwzLVGWePuKiulTbN4nTILfl3V8d1HaEJ3acukl/X2swtUJps11jJluV2P
			Dm6liKOtCszUiqlFz+sCAAAAAAAAAAAAZM45IkqSMzh2ZrO2nMnZkWXLlZbOnMwiGOXMN+z01QbC
			staocX2FzVugLebl+8wzSzRrS2k1a5Rd8Olqpml0lj/ddJCuPMJOX33grNGQzzRhVHdp3gJtudqK
			175XrxSgqRVTECADAAAAAAAAAAD5wFnNHzNZW0wzdc2wdIGlMp3Vt9E5zZqwRKfd9s/flkV2Dbur
			b5kd+mbSjrT8TOd3SWrUs7vKbZmsb7a5nW/bZH2zLaflzXi+wXq60U59++zldRg9ZqGMnoPVwz34
			dWaBvllwNjXdlkmTtbVR9wxpTirMNJVJzC3T8p9eMFmz1V19G+akwBna5sxJhV3N/IoFHFMsAgAA
			AAAAAACAfKC0ypbbqW+HveK2rZT6jBqRGjRqNOQzPT3pZbd1xUqpz1udnf80jMvy6zFqsI4/+4Oe
			GuaW31sjnP8s01nvPHlST058RU+lHtJN74xK+ZLZelzZr9HVaMhnmrBtsp68rA6fpQ98SVKZ7uqr
			yXpq2DnXubvrnVH10/Y37K6+ZT5ytscdj2nCkNLpz1+ms94ZJY1+N2P53aeUzK4OpVXp9EdubVNP
			T381WI1y4crmR0ZU1EXz+rMBkBEd69oVoj9SAAAAAAAAAAq0nbv2qFXL5nldjAInbMGHGrXpTo3J
			dH00uFuzNlT1Qurc8HwZQQbkgvVHo/TRwoP6JyIur4tS4NwWVFT/7na7mlUpkddFAQAAAAAAAADc
			ogiQAbngo4UH9UqX29W+Tqm8LkqBs3zPOX208KBmPNMkr4sCAAAAAAAAALmGmbTyliWvCwDcio6F
			xxEcu0bt65TSsXBG3gEAAAAAAAC4dZXtPkITmF4xTxEgAwAAAAAAAAAAQKFCgAwAAAAAAAAAAACF
			CgEyAAAAAAAAAAAAFCrWvDipaZop/5DrXzIMI+UfLEx3g5imQ6YpGRYLbQoAAAAAAAAAAOByUwNk
			pmkq+uha/fXbHC3YsVNHDpxXhCTJW1VrVFaD+r3Uun83da7unwdNYco0dQsF6M5rwQvdNGKt9Nz3
			G/Rkw7wuT35wq11jAAAAAAAAAMhbXl6eio+Pl6+vb14XBbeg+Ph4eXl55kreNylAZsoM36Qf3x6h
			T0NjZRiuEWMWi2uOx2QdO3RARw9+qllFamvHC/VuTrHcxOyerelT58q4/3s9evNPj1yXqIg1szV5
			5k7d8e931alUXpcHAAAAAAAAAAq+4sWK68TJMNW4vWpeFwW3oBMnT6t4seK5kvdNCJCZStg9Wa88
			9a1WJRgKrtlFTz49WD2aVpG/d1qqxJjT2rviD/12PvdLlJnDf72vTxdIz92bN+dHbovV+t8/0ZS1
			LVXn33ldFgAAAAAAAAC4NZQpU0p79+7XAZmqWKEcI8lwQ8THx+vEydOKPB+p2rVr5so5cj1AZp6a
			rdFPfatVCT5qNvQzjR3SWP4el6fz9i+nhr2eV8PcLhCQj5mmKVOGLDmcAzIn6Z1r/hkyskjjcO3P
			LI+rLQ8AAAAAAACAwqd27Zo6c+acdu7ao6Sk5LwuDm4BXl6eKl6seK4Fx6RcD5BFaP5H72tBvKE7
			Hv1KXz1VT95Xdbwph8OUDEvWL+hNhxymZBiWTAMAzuBA2n8Nw5B7sMB0OGRKcu2WaTrkcLgOzuq8
			pinT7b+GKzMjqwiEacphmmllNE2ZrvWwMpYnLf/062VlmfeNlqFuqWXLuG5XxjplmZ1DpmnIsGSy
			7lfGc6WcI8s1wq7lfjBlOlzt6VamlGt8efld7Z6hTDel/fdvUrcfI3XS4q9Jb92l5lfsLJGa8fkm
			jVZZrXipnoIySxK+U8+MDZM6NdY3HQIu379nver/fFEqUlw/D2+mhj6XH7s6pLp2PcjwaAAAAAAA
			AABZK1OmlMqUYW0bFByWXM19zxz9uFZSkf4aNvRqg2OSto1TgybN1WDczmySNFeDJs318tyMczOa
			MqP36a9v39LL/Ts582nSVn0f/Lc+mb9fiZKknZrYxHn8oJ+cR40f0tyVNrPzmjKjj2jllLf00oPd
			1cGVrkP3QRr94TStP2umBtrcRcx9ObWMpi1ah+d8omHd27qOHaJP5uxTtM11BluEtk4Zlbq/QacB
			eunD2TocnUnGN5iZcEpb53yj94cNUt82rjZo011Dhn+hv/ZHy70E+77v5yz/FzuyyfGoZgxqrgZN
			hmrmiQztaIvQ1jlfaPSgAeqW0t6dBuilUd84z5VZda/lfjg3Ry83aa4GTbpr5FpJWquR3dOusft9
			Y5qmwv+epk9edau/q0wbzuV26zu0d1eUTlokH0eM/tqVlNsnTO/SRY1eeFy5f5cBAAAAAAAAAJD3
			cjVAtm/9HO2TFHxfFzW9ydOOJmz9RkO6D9Ir3y/RPqO8mtWtpWY1/RVzaKV+WrJPMa50xerWUrO6
			tXRHSef3ClWd35vVraVm6QbcmIre+I2GdB+g575couWnDFVzpauYfFCzpn+qId07afT8U1kHGWxH
			9Ncb/XTPl5uVGFxFzWoGyQjfpSljBunZ8TuUYDul+cP76dEv/1ZMcBU1q1tVFaKPadkf76vv499o
			b0Jutth5LXitnx5990f9vvO8glPaodglbVz5P7384FBN2JpWgFpdHlRbSRF/LNKGxCyyPLBcU/dI
			Rv2ualbRrSWPz9boLt016N1fNWvfeZVKaW/vM1q+8Ee98mAPDfl2hxJuRLTGUkIVXPlX85Ukb1Wr
			mXaNKxR1pbOf0l//7qQOwz7VTxvS6n+H8Y+WL/xR207nZttLchzTvK0OVbyzlIb6SFM3HUm9R92Z
			rpF7DtPM8j5LS6McB7yqFbXoyMZD+vW444pp05XB7QQZy2RmUgYzm3IDAAAAAAAAAHCz5OIUi+d1
			eKszqtC9cY2bXK2jmvl/P2hDfBU9990kPdnYP21X4mlt+ztl1FA9DZgyRQMkbfuiqR6ZIt3zxhQ9
			2fDyHM39k/Xsv37QdqOqBo5+R8O610y3llrE6nEa8fovmjn6ZZWv9KOequ9zWR4nJ/+ffmrymhb+
			ebfKu46N2fmDRg7+Wit/+kLvn47VrFO9NX7BcLVJGYkas0kTH39W4478oPFz++qr/uVyrdV8qj+k
			sf96SK1qBsrbrW6nZr2sR95do/GjflXbuYNVS5IqtlTH+p9o5Y65Ct36gppmMh/gvhVztE+G7h3Q
			ReVTNl5YrvcffF8zE3zUduhnentIYwW5nSvmwB/69JmPNX3SsxpdcaY+6hmk6xLUVq9MaSvpvOY/
			300j1jbW0M/HqkeGkb4xqybr/aUxCmrzhn7+pE/q9ZGkmKOLtffKcaPrkrj9rKY6LHqyXkO11V/6
			cmO4QmNrqbNfWhoz/rh+nXJI4/+xKcbTqgFdKivj7KsJ+7Zp1OxzWhgt+Rfz1ztd/HJ0/tZ3V1Wb
			RYf0/vTdav1CPVXMInRuRhzSd/87pklnHUq0WtSxflW90beqim1bp8bTY/Xow500vI5FUoyWTvhb
			L/7jq89fb61OfkqdsrFYz7v0UQv/HJULAAAAAAAAAIDckIsjyE7r1Frnv4oVverJFa/PuR3acFSS
			Wqhp4wwv4r3LqWG7LNZrylK0/vr+W22Tj3qM/kwje6UPjklSUOvnNfbtLgrWUY3/bK5OZZLLvqhW
			Gvbq3emCL/71HtOwp8pJ2qmZS5M0/B234Jgk+TfWgCfaSpJWbTuQ6aiiGyNQHZ9/Xh3rpA+OSVL5
			XoM1wFfS6R06nDrVYDl1GtBOhhI1c9UOXTaIzL5DK6eclor0V/d2addg37QvNDXe0B2DvtKnT6UP
			jkmSf4379PbXT+sOJWrBh//NenTaDXZ4xxxFSGrYrlW66yNJ/lXuVtNquXn2JG3dFaNEi7+aV5Vq
			1fSXj+I1b7vb1XaEa/q3+/TBSenuNrdpUr9yKh56SB+6zywatlMvTTmnZQ4/vdG3qsa2sujHmWHa
			kJMiFK2qYd395BMepi//zuIuC9+tZz4/okVFg/T9sMaa1dNfEVsPacic4/KuGaDukkKPnk0t79YT
			ko8lXttco9ISj8dotbzU9HaCYwAAAAAAAACAvJW7a5DllcCqqlNEktZp/cbo65/W7dxyzV8qqdxg
			Pdo96xFc/u36OwNJO9dpb8Tl+42+7TKdarJKnZbOf9R5UB3rZJJvzSZqKkkxF3WT4kXONkv5WMqq
			XCNJWqtTblMN+rfrr6FFpIjflmtbhoIlblykqfFS7UG91DQlPmrfqVVTTktqq0GDslmTrkYvPdBS
			UvxcbTtwc+pboWorGZK2LV+tk7bM15LLNYlH9ddeyadOsBpYJNUK1gCLtHTbcUWnpNl3RB+ESx27
			NtHbXWuqWYNaGvbMbeqROrLNoe3Lw7RavnrnmRYa0KS6mrVspu97+uX4nvG+s54+qiwtWLhTq+Iz
			7nVo36owrfYK0AePNVC9MiVVpXFjDaslHd55Tvv8SqlpsLTvSKQiJOlIpJZ6+aln6bSg2dHjl6Ti
			JdQw+Ca2LQAAAAAAAAAAmcjFAJmXvHNvNsDsedRT99daKdg4pq/+1UN9X/pC87eeUvy1Bj5OH9NS
			SWpZQ1U8sknnUU7lXYGkIycv393x9iqZHuZd1Mv5j4ZV0qYidFfUS8VuRruZpsyEaJ3cvVF/TftG
			P377sd4eNEhDut+jkWszK3hjte7vI+kP/bXKfdRRorYt/0MRKq+eLd0mATx/RHvjJdVpotolsitI
			oMpXc+az9+h53QxBnQbruaqGzq95X926DNH7U9bo8AWHzJsQKYvZfE5TJfWtUcG5tpdRQU1vl3Qq
			XIvDnWkizsQrUV5qXc1t9JVPsOqnBpuidOispMASalA8LYl3ZX+1znFJ/NXxnvJqY8Tq/elHlH7J
			uyjtPu6QEiJ1/6glavjmEjV8c6me3CtZEu1KVIAa1rBKYRe1N1E6vD9aEdXL6JGqVlfQLFy7jzhU
			sUaAcnUwHgAAAAAAAAAAOZCLa5CVU5UGhnTaVOjeI3qyYdWbWrHyvT7T7JpzNOHDLzVl7VS9seZX
			jSzeSMNeeV4D7q6l4lbj6jP1LabsJ4t0BXbW5iy7y1hv8lSU7sx47ZkyUiMn/q1jiSlt462qNSor
			qHoTtbWu0crTlx/WsNPjqj3la01dvknPdW7vDORFr9Nff0hG/YcyHRGnkl66Uk0rVGkhad3Nq79v
			PQ2dukANJ7+v96es1e/jX9Fv47zUuMtTevL5B9WsjEXXcMfkQIxWbnUO1/p95gr9PjNtj6Ekzdh4
			Tvd1T5tz00wXoLXLdCh9mNsi+aRPokTpiu2dKri2Xm8Xrm5Lj2hChUwmIg0spWlPVcsQyLXKX5Jq
			FlPFtVHafSJSF4/Y1K9FBVXzDZfP2ovae85D689LnbpVyJVWBAAAAAAAAADgauTiCDJ/1WnWUoak
			jYs26aTt5lfOv0ZvvfLfJdowe5I+GNREFaO36Ku3HtWzH69Nm7ouhwxJuhR9henqziviiCT5SB45
			yDQfCZ8zUg+M+1sxt/XR25NmaM2qUG3fuFIzf/lRE798Q92qZHFgnbs1sJ4h/blA6y84N0WvXaCp
			MtRvQJfMR8RdSLzitH8RpzdL0mXroeUqj0A1GfKpZi5fopljX9C9tSzavHicht43RNOP5NJIsqjj
			WnJKMkoF6OsHqmpS6qeUOknasfu0TkjyL+ElQ0nacfSSTNM5BaYj6pxWpw6w81PpQEnhMdodb6am
			uXgoKmdrkKWyqEL7mnojwKEJGyN1MXV7Cd1eRtL5GB20+cmvqL/8/fzlV9RPfkVd84ZWDVAni0Mb
			9v6jbWG+albTS6pWQv10SbvXXdRS+alZtVtzVlcAAAAAAAAAQMGSq2+rg1r30cAihrTrS305/+Q1
			TW9oSNKhw4rIdG+CEi9dOQ/vciHq/vx4LZjxhnoUkbb/8YlmXs3aVsXLq6khad1+Hcku0Gc7pcOb
			JRntVLty7rRp7tivBZPWSWqhV8a+rnsalJN/urXSEmQmZHVsObXu11KGVmp1aLSkCK1asFIy+qtH
			O//0SYsHq4Ihac9G7bmQ3c0QoUO7EyWVV53bA9PtuRH3wxV5+Ktqqwc1eso8TRlUVUb8Lr3z/UrF
			XH/OlwnfHK6lkno0q6lW9auraeqnjgbWkXQhUquPS951y+gxX2nmnFB9ufaQQjdu15gJp9wGK3qp
			SeMSqmTE6uWvN2je9kNavehvDVsSf/WFspTVgL6Buj3Kph1pG1W/SaBuN+L1ztd/69eNx7Xn4CGt
			XrZBn66JdCWpoGa3Sxu2ntea4BJq4CfJO1gNyjo0cdNFJd0WoAZ5OEgSAAAAAAAAAIAUuTuco0Rb
			DXqlpSxGohaMeUVfrgmXw2Eqq9CIaZpyuEfRKtRWD0PSul3afSnjUabMyBWa/0emOWUejKvYS/f3
			kaSwLAMp4eGZjC2r0kI96hkyTk/WD1kF+kxTF5f/rqnxhoK7dlRDfxUgSUo8LUm3qVzAZRWTeXit
			Fm7O+uig1l3Vz5BmLl+n6OPLtGCdFDygvepnDIZ436k2A3xkaKV+/HGH4jNvSDn2zdHUdZJRtY+a
			ui9Ydc33g7ujCr+Q2WkzKYuHvxrcO0AdJCnm4hVHvV29c1q6NVkWi796Nsp4w3ipQUgx+Vrs+nnL
			ccm7ql4ZUkEDi9k1adFRDV+RoPoP3KaBFkMWwzn5o3edRprQo5jqxETrjT+OamJ4Mb3dq4QsFkOW
			LOeHNGSxGJdPH1m9nt65wyP9sdXv0JSHS6uzV7zGztmvAT8e1didpupU9ksrc40isiSZKlYzSM4J
			GgNUq5qnkmWoTY1SKlDdAgAAAAAAAABwy8rFNcicyvd6Q5MODdOQqUc08cV+2tblKQ16oouaVQpM
			N31e4rmj2r5+rmZGdtRHg+s5NwaFqGk9Q/N3zNHE8W1V+6WWCko5Jmanprz6idYUkZQx2BWzS6t2
			llTTJuXST9EXs0mrV0qGUU/B6QcmKbhMLRnap782bdfLHVs612wyUoIP5dT9lcGaNXiyFo55RcU8
			39fLnaukyzti9TiNeGeJzhdtpQ+faZuvAgGmwyGHI4udhiGL4afguoa0e7qmzrlPDfqWS9t/bq2+
			GvGV9mbWzilKtFWPAT6a/usazah+XquN8nq1+52ZrHvlrSaD3lTPOW9p3k/D9Eqx8frgkXryd2vH
			mAN/6NNnv9UOSzU99+ZA1XK/ftd6P0iS/FSqvCHptDZsOaxBt7vmjDQsshjSqbWLdLFGO9UKSl/q
			U2tXaKkMlapUIReuaSkNGN5ZA7LY692wuTY2dNtQto5ef62OXndP9F5NvZL6xaoKLZrrpxbp89nR
			OJsi1GmqHe9ltsNL9e/rqB33uW+zyL92A31QW/ogi+z872qlHXel31ate3vt6H7DGw8AAAAAAAAA
			gGuW6wEyeQSqyUsT9FvpkXp53CZtXvylNv057rJRZIZhSDJkDOqkj1K3pgSmftDW319RxzmBalIl
			SIaSdHrfPyrV6yO9Uv9VjZiSIbP4o5r9/BA9Z/qpQZ1y8pQkJen03mMKM3zVc8Qb6l4x/SHlW/RW
			W8t+rfzjFd2zuabK+UrJbV7TT0OdwTrvkH/p/Q8j9fqIOfp91IP67f0ANa7iHCOTfPqAtl80ZBSp
			r+Hfvq/u5ZSvjB/aXOOz2jnoe+18oZ46Pd5HE1+drYXv99OGiTVVJUgy4sO08Z9k9Rz1qV5Z8oxG
			rM0qE2816Xyfgn/9WZ9+Jxn1X1PHOlkkLXW3Rn97WjH/+larvn5Srb9Ku0ZGxDFtDE+SYVTTwA8/
			1dDL5uO7xvvBVcb67fqr1LRpWvPJY7pnTmUFWqWKAz7XOz0CFb7lbQ160VRgsLPukmRE/KON4Umy
			VOuvD4dkFvADAAAAAAAAAAAFUe5OsZjCw1+1HhmvBUt+1fgR/XVvSDVVtFhkcX1KlamtZh366/XR
			k7T0qZB0h3qH/EsTpo7Rcx1qq7rlgjbvO6iwxCrq996PGv9GW1UwXPm4zxFXvLEGvtBVnWv56PS+
			g9q876A2n7Gobs/B+uyXeXr/viqXBzsq3qf3v31a91YrrrB/DmrzP5EqUcwvXZLyHV/Xj/Mn6YNB
			7dWsnM2Z777jii3TRANf+EwL5k/UoDqZhFEyK2O6/YZrf5YJXG2V5Tx5mR/l1sZZflzn9G/3un6b
			/KoevauafCOc9Yos2VKvj5+h93tVSc0ryyKGdNGj5Zxl7dSvvcpnUy7vOo/py/m/anyGaxTmX1X3
			DnpDU+b/qpEdM48yXtP9kHJss+c0cXR/tS1j0bFDB7X5jE3Bxb0kSdU6vaHnOtRWJdvB1OsaGdBC
			j474Skt/Ha4mJa6q6QEAAAAAAAAAQD5mREVdNK8/GxR6tn364Z5B+jSsvT7/6yN1LJHXBcpbjd5Z
			oV3v353XxSiwQl5frC2j2+V1MQAAAAAAAAAAt6ibM4IMt7yEjXP042kpeMD9alUir0sDAAAAAAAA
			AACQNQJkuH5mhP763x+KMMrrse6s1QUAAAAAAAAAAPI3a14XAAWUacphOmfnPDXrPX26zlCpbi/q
			njp5XTAAAAAAAAAAAIDsESDDtdn+gx79dJk8I45pU3iSjGoPacobbeWf1+XKR0xJRl4XogBiUUQA
			AAAAAAAAQG4jQIZrY03U6X0HFeEbqLb9n9JLz/RWVd+8LlT+UaVUUS3ffU7tagfndVEKnBV7w1Wl
			VNG8LgYAAAAAAAAA4BZmREVdZMAGcINtOBaljxcd0rHwuLwuSoFTObioXu1aXU0rl8jrogAAAAAA
			AAAAblEEyAAAAAAAAAAAAFCoWPK6AAAAAAAAAAAAAMDNRIAMAAAAAAAAAAAAhQoBMgAAAAAAAAAA
			ABQqBMgAAAAAAAAAAABQqBAgAwAAAAAAAAAAQKFCgAwAAAAAAAAAAACFCgEyAAAAAAAAAAAAFCoE
			yAAAAAAAAAAAAFCoECADAAAAAAAAAABAoUKADAAAAAAAAAAAAIUKATIAAAAAAAAAAAAUKgTIAAAA
			AAAAAAAAUKgQIAMAAAAAAAAAAEChQoAMAAAAAAAAAAAAhQoBMgAAAAAAAAAAABQqBMgAAAAAAAAA
			AABQqBAgAwAAAAAAAAAAQKFCgAwAAAAAAAAAAACFCgEyAAAAAAAAAAAAFCoEyAAAAAAAAAAAAFCo
			ECADAAAAAAAAAABAoUKADAAAAAAAAAAAAIUKATIAAAAAAAAAAAAUKgTIAAAAAAAAAAAAUKgQIAMA
			AAAAAAAAAEChQoAMAAAAAAAAAAAAhQoBMgAAAAAAAAAAABQqBMgAAAAAAAAAAABQqBAgAwAAAAAA
			AAAAQKFCgAwAAAAAAAAAAACFCgEyAAAAAAAAAAAAFCoEyAAAAAAAAAAAAFCoECADAAAAAAAAAABA
			oUKADAAAAAAAAAAAAIUKATIAAAAAAAAAAAAUKgTIAAAAAAAAAAAAUKgQIAMAAAAAAAAAAEChQoAM
			AAAAAAAAAAAAhQoBMgAAAAAAAAAAABQqBMgAAAAAAAAAAABQqBAgAwAAAAAAAAAAQKFCgAwAAAAA
			AAAAAACFijWvTmyaZl7XPccMw7hl6pJf0KbXjra7NrRb/pHdteA6FA5X6o8AAAAAAABAbsuzANmu
			3XsLxAsy0zRVL6TOLVGX/II2vXa03bWh3fKPK10LrsOtLyf9EQAAAAAAAMhteRYgk6SQurXzuv5X
			tHPXnhylK1O6VF4XtcAIO3M2R+lo08vRdteGdss/cnItuA63tpz2RwAAAAAAACA3sQYZAAAAAAAA
			AAAAChUCZAAAAAAAAAAAAChUCJABAAAAAAAAAACgUCFABgAAAAAAAAAAgEKFABkAAAAAAAAAAAAK
			FQJkAAAAAAAAAAAAKFQIkAEAAAAAAAAAAKBQIUAGAAAAAAAAAACAQoUAGQAAAAAAAAAAAAoVAmQA
			AAAAAAAAAAAoVAiQAQAAAAAAAAAAoFAhQAYAAAAAAAAAAIBC5dYMkDlsSkxMULLdTNkgW2KCEpPt
			Mq8r41uNKYfdJpvNQbsgb5gO2Ww22R3cgQAAAAAAAACAm6eABshM2ZMTlJiYoCR7Ji/WN3+u0qVL
			6/GZ51wbNunz0qVVeugMnbuq8+RmFRyy22yyZRoYMJ377LkduIpS6MT3NGL0Ih3O6/a4AUyHTTbb
			5R+CL1fmbDu7Mmsq02F3tmNuNOPhRRox+j19vT4qr5vgxjCdbXV5v04JRrs+V+jbKWmzbfOUZ0i6
			j72Q3u8Z2je17+ez4L9pymG3py9nrj/nAQAAAAAAAGTGmtcFuCbmMf08oKFeXGYoZNQKrXypYcGL
			9EVt0tefLNA/zR7VJ72rZNh5TLNH/6h1Fbvr9X81VUBel7WAODzvPX27XjIsFhlu2yv1eE7Dmpe8
			sSczHbI7HDIsVlmM688urznbrqL6DX9CLTI01YX1P+j9eSfUYvDb6lc9r0uan5m6uPVXfTD9kGzp
			+rUpe+R+zZsxT+uPx8vu4aWAWh31SL87Vc4zk5vHjNbmn8bpt4O27Ns85RliGLIYznw8ilZSgw6d
			1KNReflbb4EbM8eiFDrxC804YciwGM7+71lEVULaqXvnRqrkn/6ZkBdMh12xZ3Zq1V+h2nTsrOKS
			DUkeKlq2ofo/1kN1itz489kdhjysN77uuZk3AAAAAAAAcLMUyACZeXiF5i71ULnypbXzm1la9VRD
			tbvBLxdRUPmq8p0NVMErbUtAad8bfpb4I6v1y6KNKt1luHoRNIIkM+Gwliw8JFvG7XF79OsX07TD
			s4La3tNXpcNWaOa6eRoX76mRjzZQ8XQRBlNJB1ZpzkFbzk8cXEMtby8pyaYLB3Zqy5xJ2h8xWKO6
			31YIgxfBqnNXVQVIskUe0tat8/XlwQg9O7yrqnjkYbHMOB1d9JMmrDsneXjJv0oDtSzlI9mjdPxw
			jKKTJN3Qn2EJOrTiD83dUEq9R9ytG/uIys28AQAAAAAAgJunAAbIHNo+93v95TFMv3wsDXrwF63Y
			8JraFYIImWk65EidjsuQYbHIw234kulwyOE+pZhhkYeH21/4m6bsDrtM03W8xzWcx3TIZnc4R2mZ
			DjlMyfCwyiPfvIkP0h1tu142CirHbeRqJ4fDIYeZksq9DZxTpMWcOah9p2NVwm6TzebWBqYph8Nt
			qkL3/PN9212dnLSlabrSuLWHxWLJZtSds30dpiGLh4cznWu0XmoeFg9Z89uwPTNJBxbP1hbvYipy
			KVqX3OpzbvNybbP5qt3jQ9TjNkl3VJBP3Kf6YdtqbQ1voHal3LJJOKw5s3bIu4Sv4qPic3buKs3V
			p7trtFrX5lr21XgtWLtJuzrdpnpepkyHI920i4bFI91zQ6ZDdrf+bvGwyLTbZWa4ns5RQ2l9IvX6
			5CuV1bp719SgTZsVX+ujJaFat7eTqoRYc3DPmnLY3fq+xUMecrZfur6aXT+/jKmLW2dqwtpz8qjW
			Qc8OaKVy2fy4ulIZU66D4WGVxUy7JqnX1XTIbo/Vmf2HdDqmhHMaTllSR3tl93y/3rwBAAAAAACA
			gqTgBcgcG7Tom52yPv62Wnfw0bPWL/T51CV6oW0flbyF39CZDrvC9y7RjPlbdTTWJqtvgGq37qM+
			LcrL32JIitGxv5dr8drdOhJrkzy8FFCzjQb0bK7b/AxJDtnP7NC0uYu0/USyLEUD1aDb3Qoyr/I8
			hxdpxOQNqtS2p24/sULrTiSq8SNvqE+1vG6hHLRhcqyOb/1LC5bv0bE4u+ThpcAqd6p7z/aqG+CR
			FsSKOKA/Fy7VhmORSrBJHkUqqn6HTurRuLz8LVFa//14zTrhkCSt//kDbTSkux59S32rOo+dP2eB
			NvwTJ5vVW4E1WuuBns1Uyc8iowC33bW0pfNeWq45SzfraESSbPJQkUp1dHfnzmpWqWimwRUz+bzW
			Tv5Wc8+UUbtHH1b3Sl66sG+Zpi/ZoqMRic42bdhXz/WuoRs/LvBaG8OhmAOL9dumQHV7pIa2/bBY
			/6TuvKBDuyMkz2aqfVvKNh/Vql1L2rZTh08nqF0pH1c2cdq/aLY2BnTQ4Lq7NWn+iasviyVIlW6T
			dCZKMXHO8+9YuVBLNh9X+CWbZPVV5Tt6akC3mippdQY8Yg4t08/T1+voJYc8/aqq04C6Ov/dLIW6
			TfFqJsfq+PpF+n31QUXE22QtWlFNe/dVz1ol8nWAN7hCZUnnFBkTI8l6hWek5Eg+o/XTp2vBvkgl
			WXwUXK+Hegb/rUkLT6ZNd2leoZ9fdn+c0MqFh2Tza6zHBrZSuWxu3Jz0q5QpT5s//JJqHZmhPzaf
			UJzdSxVbDtDjnSvLL2qzvhu7SMcckrRZ/x2zVVITPTmmq6pe4fl+PXkXwMcYAAAAAAAACrkCtnSX
			qUurFuq/56x6onNTFfNprLuHWaWpf2pluHn92ecFh13JybYMH7scGeodsW6yPpu6Vcn1u2nwQwN1
			T0Nv7Vn0gyavj3SNBDivHRsvqWLb3hr80ED1bxqoi7v+1DcL9ipZknlxpyZ/O0tbzvirZvteeqRL
			HV1aPk1/nbna8zgdX71aSW2G6d2381uAx5TdlqEtTUnmJR2Y/62+nLtXMeVbqP9DA9W/9W3SsbX6
			YeJCHYhz1s4RsUFfj/9Nq074qH6Xfhrcv5vuDAjTltk/aPK6SJnyV63OA3Vf4xKSpOodB2rwQwPV
			tFTKsb9ro72+7nlooAb3aiCf/Yv1zf826Lxb4xWctnN+bPaMUdSctKXrXvp1nY75hKhX/4Ea2KOB
			As7s0PT//qq1EZf3V9MRp/3zf9Cck0XV8qGH1f02H+nEEo37eY1O+zd1tWlTBVyKVkJeN5V7m51b
			r8m/7lBQj75qHZTxbw4u6uxJSWUC5T6o0Vq0iDwlXYp3jRIz7Qpf96t+3BGoe+5trlLXGHQyHYmK
			vSTJKCJfb0mXjmjj0aK6s0t/DX6on3rW8NDR0KmasC5ckuQ4vlif/bBWx+xl1KxHP/VvW0K7fl2g
			zZlc7/HLzqhsm94a/FA/db3tgtb+PEkzDyfn9QXIrjGUGBcnyZBfEV9d6RkpM1qbf/le03fHyL96
			G/V/4G7Vj1uhn5ame0jmuJ+nOn9Chy5JRRo1UK3soro5fEal2D3vVy33uEMDerVRTf8kHV/5s2bv
			SZaK3q4uD/VUkwBJqqIuDw3U4IcaqtRVPN+vPm8AAAAAAACg4ClYI8jMKC2Z+rnOeTylzs2LSZLq
			t3hC1s+/08+LXlWfQVUK3jRPm37RG5szltpM97JSiXv155KT8mz6mP7VsYJzW9UeitzznRav263w
			u9qolCqr93OV5JAp0zSlaq79B0/qtOrIZ/Ny7bN5qfH9T2hAXeeIlVq1yujXj6amvQzP0XmcjPrd
			1ON2n7xuvUyc1Jxx72tu6vcKuuflx3VX8lbN2hgrrzsG6Ln7ajlHH9WsrpolpmjM9E36c3sL1Wzh
			r13L/tJxeyn1GPqE2rsqW6tuGXl/NEkrloTq0F09dHuV6qp2xk/SBQVXqK5a1SUpWTsW/KXjXk31
			9KPtVMkiSZV1X+RefbYsVNvONVenAtd2Lmb6cK3Cc9CWd57Rn0tOyl6mk14Z0krBFkmqroZlvDR6
			wlrNX3dUrfpUTeuvDmeA6IfNyarac4j6VHO2T8yZ04qTVLt+YzWo5iuLpZpqNcgvvdyUI/awZv6w
			ROcqddcrTUpIF3N4aIkAlXVr35gDC/XNn+Gq1PNpNQ+QIq+mGK4guxw2Xdg9V7N3WeRTq76qF5Hk
			01hPDGkkh+l8LlSraOqfnX9o29Gzim9TUgdDQxVjVFKfpx9X6wBJqquGVYrp4y+W6myG6121zxA9
			cIefJKXmE7r5kPpWr52PfpA4ZEu2KVmSLXKXpi/aI4t3Td1R1Ue6wjPytrNbtfigTUWbDNBzfau7
			7utaKjftU/2wLSX/ZOczIrt+XjpDkaIu6rSk24r5ZV/0nPSrFgGpyYs0uU/PtQuSJNUqFq+R/12v
			fSfOSHUrqlrNyjq7XNL5IFWqWd055WTiHs2+wvPdeq15AwAAAAAAAAVQ/nmvmQNm+Er9OVXSgGaq
			55WghATJq0EbPaLvNHn6ch19uIqqFrAxcQquoZY1AjJsjNSBNfvTXlCfOqZdNsm+4WeN2uSezipP
			XVKMpGCHXeGHNmrT3iM6+E+kYmOjFB0vybQpWbE6dThKUiM1qO0WmPEtrdvKSJtP5Pw8KQGyShVK
			59Obx1eV72yoCt4p34urlLcUc2CfwiU1rV8r3dR8/lVqqZKO6J+Ii5Iu6tAem1SmgRq4D4mwVFCt
			utKK9WcUHi3dnun6Ziedx9o3aOL7m9IFaj2tUlxs2veC03ZOyae3KfRI2npYMUdz0Jaue6lco7qu
			4JjLbdXVQGu1LixCF1RVKXd+zN45+vboSfk2HaTHmpVIy7P2Xbpz9SltnT1O766tpGatOqpNvdLy
			s+SDNY/sF7Tuf1MVqkYa0r+h/Ow2JdvszuC2K2hlsUqGa226dGIuKlxSaUnm+Q2a/L9N0p0P66FG
			fulG7TnsNiUnG7J6emRd35Qgu2HIMAx5BTXT4Hvryl+SaY9V2M5N+vvwCR06fVEJ0RcUJ0nx8YrX
			Gf1zSFKZWqrr/ggqVUHVpNTnT8r1Pj9vvEbNd0tntcozOk4xkkoqv9is78dskSFDhiEZnkFq+VBf
			NfR3TfmZ5TNSij9zUhckNa1T3e2+9lG5CmWkbSkPyRz084wBMh9PFZEUfSlJppTldcxRv1LahapW
			ISgtUUCgykn6J8mWddPk4Ple8lrzBgAAAAAAAAqg/PmePlOmji36Sf+TRR5/PKWQ6W67PCzSyu81
			Z8djerFhAYuQVWmuPt2qZNh4VDPcA2SmIbuksh0f19NNMwbTrPKVqfPrJ+uzeedUrundats1SKVK
			e2vPT99p0RlJsslwSJJF1nRvZ03n9IM5Pk9BEKQ72nZRiwxv7GMM1xpDjgyvqE3naD3DtT8lmJE+
			memKbzhfumfOkGGXVLqthj3RTIEZ9nr6SDqS121zbW0X+fdJhR5xWw8rJ21pGK51yMz0QQFXmpT9
			KXwDy8nn9En9c/asYpIry8fTFQDzr6UHXnpRrXdv0uKVoVo98zut3tRVw59oriCPPG6u6MPafsIh
			i7bov//ZklJB5/SorqDVXY8+o+KBkiKjFG1KAa5KJ1+MVrwMBRbz14VDe3TSYZE2/0/vpQzndI3a
			W//T+9pgNNGT73bLeqSOK8juG1BBlcqXV/VyJWS1SFKyDi78VhM2WFSzQwf1qR+kwIoXtPj/pmur
			JMkuW7ykAI/0I1btyUpy+2oznYVu0O8V9auRoQMY+e25EKw6LaopwDNQt1Uso9uqVVBJq/O6RGb7
			jJQSEhIlSRbD/Y415bC7TyOZg36eUamKqmORNm3aqqNt7lYVzyyCuzl8Rl2zHDzfr2rkIgAAAAAA
			AFDAFZxokuOoVkz/S/Jorkdfe1fvvuP2GdpVVmOXvl64IcPaXbeIss4XrKf3HlGM1VPePt7y8fWS
			t7envHytkqK0f/tJ2VRfXXs1UoMalVS6aJyiIlIyKKFSFb0k7dKeIzbZHQ6ZDodsF45o16mrOU/B
			5V+ukvwMafeu/YqxO+QwTTkcdsUcO6rjhkU1KgRJKqMq1SwyzuzVjnNp7WRPOqUDhySLfyWVL5aS
			o+tltt0uh8Mhh1lGVWpapDMHdSDGKi8fL/n4esvbx1Oe3t6ugMWtIUdtWbqSalgMnd65R+FJdjkc
			zjS240e0T4b8KpVNvyZXmWZ67KFm8j+5WJ9NXq/wZGfIxrTZZTOLqExIWz36zGt6vImPbP+sVGhY
			XreCJO9g1W/RTC3dP3dWUhHJGbRq0UxVigWpeq0iMi4d1IEwu+wOUw57nHbv3idZaqh2Fat8S9dJ
			n0eLZmpaxRl2KlW7mVq2qKTi2ZWjSnP16dZFdzerq1oVSrjdaye1a32sVL6F7mnXQDVvL6eAS3E6
			n3pgCZWtZEgn9+rABVfZHHbFHNyr3W7Zl6zgvN77Dv0jm7eXvH295ePjJS9vT3n75LfnQmW17tZF
			fTo1VsOaKcEx6crPSKlkcDl5Sdq+7x/Z7A45HA7ZkyK0c9dZt/yvoZ971VKL1sXlEROqn2bsUHiS
			TTa7XXbXx2ZzrpOYs2fUVTAkySG7qy7mjXy+Z8w7T685AAAAAAAAcG3y29vNLDl2zNb3Kw1ZBw3T
			26/1UDH3nQn1dGHuIn00eaFWvtBM7fO6sDdakVpq06KE9q9bqrETI9T9rloq6R2rsN07lNjkcfWs
			4qsifh6yGNu09K8KSipv09HQTdrrLck1K1a1+k1VMnSd1kyZpPjOzRXifV7r1hxUbICU+sb8iufJ
			64a4DhWaq2/IJv26fbq+jG2m9k0qSKc2acXfR+UT1EZdGjjXB2rYvo0WH1utRd99r3MdmimkSIJ2
			hS7Vlos+qt+/uWvNIalYsZLysJzQpsULVT7OV2aJjmraqplKHlyvhd9N0rkOzRVS0kcx53Zrc9Kd
			Gtalcl63wM1tS0tddWy/QodXLNPYSRHq3ryWfC7t15pl2xVdpK4GtqpwWba+1bromR5h+mTun/pm
			frBe7l1NyZt+0Y9hNdSqRgn5JkZo074kefjUUYWAayj3jVakslp3q5x+24UNOr7xH/3jPjL0rg6q
			ummh/vrpJyW3b66AMys1d49UsnVrNSwiZ4ArQ99KGbVXrVkX9bnmRZ485e1vkXFmvf5aV0IhRc9r
			69atbsuklVDd5jU17+QBzZjwkyLbN1fAxS1adeiiiklKnVSzQmN1rbpJM92ut39ilI7sPq2yPfup
			Sf6ZXzEbV35GqkqIWgVs1Ir1P2tcYke1rmro6IbVOmErIemCK5GPQq6hn1fqNFj3nPxWs3bP0cd7
			FimoWi1VK2GV4iN04KSX2j/+oO7K4TMqZ/xVPNBDlhPbNH9+abX2NlWyS6Mb9HzPLO+mrEUGAAAA
			AACAAqeAjGtJ0LoFk3XIp5KGP9AxfXBMknxaqdezd8on+lvNXRkjWazy8fGRl0fKlFQWWX185OPl
			kffrFqUwLLJ6esrTI7MSGfLw9JSnNWUqLquqdfmXht5dU8Gx+7RgznT9MnOFtl4qrSolJclHDXv3
			V7NyPjq9br5+m7dL3p36qnMpT3mmrF1UoZOef6SFqhaJ0va/5uu39TGq/0BftSrmluaK55FkeMjT
			01NWS75pybRW83DWJfOi+anh/cM0uH01+ZzdpDnTpmvOxggFN+qlZ55qlxr4UoV2eu6JXmpWKV67
			/5qvX+as0AFVU6dHhunhemkvqK2122tgwzLyPL9dcxYeUqKPZK3SRS8P7qC6QbHOY6fN0pLt8Spb
			qUSBbjvD4ix32q2as7as1OEJPXPPnap2yXkvzVhxUGb1Nhr83H1q6J964nRtUrJJX/Wq5qOEbX/o
			540X5Vu6nPwPr9CMadP1y5w1OlXqTvV/oqczsJQfZdavSzTWY090053+EQpdMF0L9koNegzRy50q
			ZJNNxjbP4bnSqaAOg+5WXf94bf9run5bG656fbuqvtuzxb9+Xz3To77K2k5pzYJZWnKylPo81FFV
			JbdpMEuo+WNDNLDpbTJPrdecadP1y8JQ/eNRTqWL5nWDpzaGLFb3Z1lGOXhGWiqo+9CBalfNRxd2
			LdOMhdtl3vGIBjQqKvfpVa/YzzNjKaHmj72o5++5UzVLWhV7ZLc2b9mu7cfi5F+2qsoXlXLarzK9
			Ny67F6yq26Gf7ixjVfiWxZpzMElFcvB8v/a8AQAAAAAAgILHiIq6mCezI+3ctUf1Qurkdf1vSDl3
			7tqjsmVK53VRC4ywM2dp02tE210b2i3nzKhQffnxIp1o/pg+7lX5hud/pWuRv66DqQNz/k8T1pfT
			va8+rrtK5HV5bg056Y8AAAAAAABAbiswUywCAG4w0yGbw5TFsMiQKYfp0NnNm3Rc17DmVYFnymF3
			yDQMGYYhmQ454vZqw2abDD/39QcBAAAAAAAA3AoIkAFAYXV0qcauvaSGNWuqrPWCDu/YoNDD0bIG
			NFPHulez5tWtIEqbf52jA0E1VaNiCdnO7VLo6t0KM31UtVPjtGlYAQAAAAAAANwSCJABQGHlF6zg
			+BVatWCXbJKsviVUrWkvde/YUOW88rpwN5uvAkp76NSWFdoVapfkIb9yNdWpbVfdXbNEXhcOAAAA
			AAAAwA1GgAwACqtSDfXYkw3zuhT5hI+qdX5Yr3XO63IAAAAAAAAAuBmYNAoAAAAAAAAAAACFCgEy
			AAAAAAAAAAAAFCoEyAAAAAAAAAAAAFCoECADAAAAAAAAAABAoUKADAAAAAAAAAAAAIUKATIAAAAA
			AAAAAAAUKtbcytjhcGS73zCMvK57jhiGccW6SJJpmnld1AKFNr12tN21od3yjytdC67DrS8n/REA
			AAAAAABIYbHc+PFeRlTUxVx5E7l7z75s9wcHB6pUcHBunPqGOhcervDw83ldDAAAAAAAAAAAgEKp
			bp1aNzzPXAuQAQAAAAAAAAAAAPkRa5ABAAAAAAAAAACgUCFABgAAAAAAAAAAgEKFABkAAAAAAAAA
			AAAKFQJkAAAAAAAAAAAAKFQIkAEAAAAAAAAAAKBQIUAGAAAAAAAAAACAQoUAGQAAAAAAAAAAAAoV
			AmQAAAAAAAAAAAAoVAiQAQAAAAAAAAAAoFAhQAYAAAAAAAAAAIBChQAZAAAAAAAAAAAAChUCZAAA
			AAAAAAAAAChUCJABAAAAAAAAAACgUCFABgAAAAAAAAAAgEKFABkAAAAAAAAAAAAKFQJkAAAAAAAA
			AAAAKFQIkAEAAAAAAAAAAKBQIUAGAAAAAAAAAACAQoUAGQAAAAAAAAAAAAoVAmQAAAAAAAAAAAAo
			VAiQAQAAAAAAAAAAoFAhQAYAAAAAAAAAAIBChQAZAAAAAAAAAAAAChUCZAAAAAAAAAAAAChUCJAB
			AAAAAAAAAACgUCFABgAAAAAAAAAAgEKFABkAAAAAAAAAAAAKFQJkAAAAAAAAAAAAKFSseV0AAAAA
			AAAAALheDodDDodDppnXJQHyhmFIFotFFkv242JsdlM2h0MO+gryOYshWS0WWT2MXMmfABkAAAAA
			AACAAs1ms2nrth06fuKU4i7F5XVxgDxRtEhRVapYXnc0rC+rNfNX/8l2U7+uP6E5287obHRSXhcZ
			yFbpYl7q3bCMBjarKM9cCJIZUVEXiRMDAAAAAAAAKJDsdrv+XLJMpUsF646G9VWyZIm8LhKQJy5c
			iNLWbTt09ly4unTuIA8Pj8vS/Lj2uNYduaCRPWurRhm/vC4ykK0DZ2L1wby9alG1pB5tWemG588a
			ZAAAAAAAAAAKrE2bt6pUqSB1aN+G4BgKtZIlS6hD+zYqVSpImzZvzTTNtI2nCY6hwKhRxk8je9bW
			tI2ncyV/AmQAAAAAAAAACqyjx46rUcMGeV0MIN9o1LCBjh47num+0xcTCI6hQKlRxk+nLybkSt4E
			yAAAAAAAAAAUWLFxcYwcA9yULFlCsXGsxQdcCQEyAAAAAAAAAAAAFCoEyAAAAAAAAAAAAFCoECAD
			AAAAAAAAAABAoUKADAAAAAAAAAAAAIUKATIAAAAAAAAAAAAUKta8LgAAAAAAAAAAAMi/HMk2xTvc
			NlgsKup5s8ffOJSU6JA8rfK62lM77IpLNtNt8ryWfPIFU7YkuxzWglr+/IMAGQAAAAAAAAAAyIQz
			GLP5jxV6/qAlbdvtlbXpwWoybmpZjmncO4ekh+/W8Do5P8qRbFP8ns1qOytOHqnVsqt//04aXvd6
			apBXgaoLmv3VJh3tcnXtcFM47IqzGSriZbnJ98a1IUAGAAAAAAAAAAAuZ0ZqxvjN+qhCDW0eXdm1
			8YJmTzutSEmBeV2+KxXfbtfG35fruUMlNXl0B9VL2RGxW+N2R0kqeR255+NAVV7Zt0nN/iyiFS/V
			U1BelyUHCJABAAAAAAAAAIDLnQ/TyggvjXi4stvGkurTP31gyZ5uCkZDvt4eqaO1Mu7z9vKQpyFJ
			ppKT7LJbLPJwOJRopu0zbXbF2dOmRPRKNx2i87hEM7N97hw6s3S1/hVZTn+Nrps+mBdUV8+3dSuf
			LPJzmzLStNkVZxqubenPJ8Oiop5SomtbcrJNsYnu9XJOBZmUmpt7e2Sss1ubmHbFpkwDaVhU9BpH
			YWXV3pnVU6ZDCUmmPF3ly9juVg8P+ViNdGk9UuuZUldThpeHLDab4pNNyTR1KdGmWIvrXA63emV7
			vW4+AmQAAAAAAAAAAOByQX6qYT2tQ2E2JQS4BUvc2JNt2jhthV50TcFo2ovqizebqJmXRYYc2jZt
			hZ5N3WfRC/9qo4HlLDJ0QXO+2qQ/61ZVlwPH9fF5L73+bCv1KmHXiWWrde/fDmdQybTr/vs762XX
			KK3k5AjNmbBTH5+XTLtNfe/tqNcapAXkUplH9dOKZD06qG62I912TVumh1Rdux6smrrt/KrVanem
			knY9WFX25AhN+3q7xl101sFeMlgLH7To/746o1VJkmPGKs22OMveO9ChhKQjGv/+cf3hCgKZ9qL6
			4o3GauLtIY/L6izZky166elW6n1+izrOjJUhhxL9S2ne8/VU3nq1IbKs23vvjOUakFxV2x+ultpW
			5rldev7LBD3/XlPVTrbp1Iq16r/O7grMOXTnXQ30aYcg53WP2K2Xxp5Xp5fa6d7glPMd07h3jqvK
			S+1Uc8UqDdlll2wx6v9hhIw6VRV6XyUl7NyktjPjnEG1DNcyrxEgAwAAAAAAAAAAmaishzudVI+Z
			y3X8bEN93LZk+hFApkNbfluu57xv10bXFIznV61Sp/G7tOil+iptHNdaz+oKTdm3YqU6TN2lzi/X
			V0qMZd2q0+r5YgeFBkmSQ2GLV+uedX768e3GCpGkiN2aE5FWoqnT9+nd553pz69apU6/bdTd9Zrr
			zoyjksLjdMgormG1rq8Fdk3bqo9K367tL1Zxfl+1W0ZQXY0dXVbTx27S0S4dUqdYtIft0vNfnVPI
			w50U6jrv+VWrdfeYjZrwbloZ168JU09XHXb9vkQPfbVMn5Yrr8WjmypQx/TFqAN6Z2V5Teh4tZNY
			Zt3eIQ2Ky3NKuLY5qrnKYercjkhtrFdZIaZDG39bpn9Fldfi1NF2xzRu9DY9bzTSd50DrziaLaR/
			B4XWXa+QP4tofsoUi+E79dJv8Xrz5Q66J+jya5nX8slANgAAAAAAAAAAkN8Etmml0GHl5PP3TnV6
			f7k+3WlTbLJrDr/wXZq4x19f9q6g2ESbYhNt8m5WTvdHRGpVuCRV1vP3VVJCyr7bS6pZRLxOu+Xv
			UbeieqcsWOU4qh9WSG8OcwXHJCmornq7BblatQ9JTR/YpoIeUrSW78uk4BHxWhfoo7LXWX8PD0PN
			Av0Um2iXXVJIm6xGpJnaseyM1tetpufdyhvYJkRvBkdr6d60aQZbtKubWoeQ9mXUQl56c0BKvpX1
			UDsvrTt78RpKm0171yqlRy3RWrzbde0c57V0V7Iea1DZdR3dy+DKa0Bxrd95Stcc0zIMWQ0flfW3
			KcFmXnYt89rNH0HmSFJcXKIchpeK+HmnH/ZoT1LMpUR5F/GXl4dkJscrNkHy8fN1m9MyI1O2xEQl
			W7zk62mRIzlBifaUfRZ5envJ6hq6l5iYLIuXjzxzFBZ0KDkxWfL0vnJ6h11xyRm2WQwVzdmJlDJP
			pzw9spx707TbdcluqIiXRYZrrk9ZLfLxyCZu6yqXj3cmw0uvVYY5SbNIlEvXBAAAAAAAAABw0wXV
			1djRdaV9m9R86nJN3VlFmx6qLs+IeK1TjLZ+uCr9+2Jv6cFIyQywK+7sbo2cGKGNrnfC8SqmZ92S
			tihdPO3Lvgj9YhTR/4KyLkqV0iWVI4Yhj4h4nTSl4GtZzMslpEFJ7fhtpzquKaov3rhTIZYM63il
			uqAj56RWDUtk2F5SVUtJi89ekOpmdRZfVc2mzjll2rJr78rqVP+gHtpxVCPqVZNj9yF95FFWy2pJ
			2hOvdUYRDctYhiBftYi4pNNS6oi/qxJUXp3LbdWLH67QnXc10EdtA9zWast7Nz0sYd8+XndXqqhK
			jd7TyrgMO7eMU8WKFTRui/PrudlDVbHiUM0Kyzo/03ZWf417Qy/POiI5krXrjzf18r/fcn5e/Vp/
			hSXLIUkXQjXu1RH6ebddpnJiv/739vv6394cJD2wXa0/WqMuY/9W17F/q+vYdeo08x/FJTtycLAk
			ndBXH67WVweyTnF+zXq1nrhf5yUp8qBGjf1bo/6OvnK5Ptyu3dd6sTItyH69doU8c++aAAAAAAAA
			AADyTK3GCh1WVq32nHROlWcY8lAxTRjVQaGj03+er2Xq3PLVaj0hWp2HubY/W0YtssvfMOQR6KPS
			N+KFcXBRtbPEa++Z7N/TG5kEa0z389dqrNDRHbSgU7Je/HCFWv92RMmZls+QxZAqBBXPmJscpmQx
			cjsqdOX2DulQVm3Oxemc6dC27dFqU7+8c8RYVu1umrIbhnN6RcO4PKBkmsq+dUuq97MdFDq6umr+
			vVMd/2+1pp3Jadwk993kAJld25f+oX0VKqpCxDgtWhd3nYERU2eX/0/Tb3ta3/SvLh2crz/Lv65v
			vvjY+Rl2m6a/O117HJICWurVYW21bsEK5Ur7B5bSrBGttHpEK60eUV9vRB1XuxnHZb/+nDM5V039
			Z0Qr/adV8evP64bLR9cEAAAAAAAAAHDtTIcSMgwEMUv4qIJhyMNQWhAqzOH2rt9UcrJDpqK0bneS
			7r+vhWs6QVPJyWb278yDi6pdZKSWuudnOpTjsSjugupqaAObPl56RLFJjvSxCNOhJJtzS/kyXpLD
			kRb0cth1OCwpQ11cU02OqqKBKcHBlOSp0bSSur2coanbjyjJrbymLUJ7zxmqUTaHI9+uWQ7aO6i8
			OnpEakXYES3e662OISWzbnc5lBR2SRvLFFV5SQoqqmqGlGhLqZyp5LA4HcpYDNNMy8Nhd7VFZT0/
			uoPmtZXeX34sl9sh525ugMy+Xosm7FPDYa/rmYYemjB3pS5cT4TMjNCOLR56qFN15/eaffVqm4C0
			/TXbaEDltdq6P+V7Wz3kMUeL9uR2NKa4evYrpbv2RWqn6ZweMS5jB3Rksk2mbEl2xSU6Pwn2rBrH
			oaREu1snS39cXCadPSExbb89m3Ne6Vjbla5Xvr0mAAAAAAAAAICrcn6PXvntSOr6YrGJNp1Yfkqz
			ygWpdZBcQSi7Pv1tl06kponQrBl7FamSur28Rb9vP5K6fc70s1qf3fmC6mpoA4fG/u6W3+ldmrM/
			h+XNIKR/dQ0+fFztv3YvnzPPr9dFSZICy/rJd99JTTvt2rd7s15Ine0tSvOmuZclTie8rK4pAg15
			Wg0dOhWh2ES7kk0ppEM5dTh0VJ/vdG+vPfrCq5wevsFrbyUn29Jdl9jk4jlo75JqXd/Qiqkn9XsZ
			1zXMqt0Tj2jcjEsa3DllXbISql42WR8tdct/xjltdM/eYpH3+Us6nOhap27/5nRtcfisLYvpKfPG
			TV2DLG7VIv0Q3kAvtRqoNpog49+LFPp2N3UPuLahhWb4LoVaGumZgKwSOGR3WNyGSAYo5M4q+mHb
			QT0WUlO5OqDRlOxK0PFIqcKu9bp7V0ktfra2UqfwPLBdrZf6ptuWnHxB837Yo08jJcmhO5vW1Ydt
			AzJZZ+yEvvrwqPRAO71US7InR2r6pN0aH+28sRzFAzX76ZR8TcWf2a+3fjyvUJmyJRXR5yPvUDNP
			i5zBsUjN+n6PvrjoPIejWIB+HVpLlTwtzuBY2D6N+CFSmy2SZNUrPYtlG+HP19cEAAAAAAAAAJBz
			QX6qefiIOn143G1baS14NiVoIoX0b6TRX23V/R+uSk3y4AMdFCgpsH91DX4n5Xgvvf5AOXX4Ld61
			XpkhTy+rfKzp3wqH9O+gydOWueXnpdeflSSLvLytGYb9ZLbNXWU9P7qyOqTLT5KKadJo1+ipWo01
			ucEyDZm0SuMkqU5VLeiUpB5nLZJK6nbPrenLMqyVa4RWSfXuXFLv/7ZTnf720uvPtlLvoLoaO0x6
			6atV6pRpe2VSZ8MiH2+PdGu4GVZrNoEkZx6zZ63SbPfNdaoqNNv2dgqsGyAtPqNHB6Vdw8zbXXpw
			YAc9nxrYK6neA8pp+VfH0/J/troGf3UybU2xWtU1utxWvfjhKmd52hdVmHtb1Kmu0P6Vr/1+vMFu
			YoAsTuuX/qrw8s+oaV2pbmJvVTDe1pxVb6tb34BrCoxE7NqqYxV6KfO16xxKDtuhDaeqq3WptK1B
			ZSvIEnpG4aqpUjk8z9VzKOnMJW2wFtEzgTk/atqcAxr9r1ZaHShJJzT+/3bqFaOBxrfPfujl7lk7
			9Umpqtr4TCXn9zX73dozRi/O9dO8Ea0UqIua9902PT3juDY+UFkejguaPnGXNjVoqNWu6Rp3z1yp
			e2cUUegDlaWz+/TK9xGq80AbfV5Dki5q3oRt2iB/PVXgrgkAAAAAAAAA4Oo4A0zPZ5vGuc5U7xwe
			33v0lY8L6d9BoVnkdeVtOc0vu/2VU79ne2ytxgodnWFbUF2NHV03520VVFdjM+QR2KZVNuXNrr2V
			TXtLqdMuWoqrUyYj2q7UTpnWLV37X162rNsi7920sWxm3HotGn9O5Qe30Z2S1KiNHi8vTV2wQpHX
			OM2iaTpUtXQmQ5VMuxIT9uh/7y+U9/0Pqa17kuBSqnrsnM7f8AqaupQ6FeE/+mpuvNq3raKrufQt
			W9dWz9SAWkUNbO2lv/ecuWJZPSyGmgYUTZ0+sW6rmm6RXy+NvDfle3H1bOsv7YvUbknm/mP6yAzW
			c038UqdQrNwsWE33RWqnaWrnqnPaULuynq2Rkpdr6siCck0AAAAAAAAAAIDsyc5pEaf9fk47GpRS
			SF4XKB+4SSPITF1YPksTJD1Zq5JiYmIkVVLtnpK+/V1/vtlXD1a6+lhd5LkTUukMGx3Jij+zRp9/
			uEDW+19Pv/5VbooM14NjI1NHbg24r5X+U+PqsritVPF03wNL+eTouLr1SmjHjL3q8ncRfTq8gUIs
			hoqmDr/0UeUsRrGdP5cgRcakK7ckydtTJyMvyhYutaxXXFcjX10TAAAAAAAAAACgvbNWacge5btp
			DvPSzQmQmRe0cs6PktVbPw2tr59Td/jIUwv1x/JjGvBo1asezhZY+jY5TLfhZ6ZdiTtn6cX/ntWD
			b3+cfpRSahpTDotx49e6CiylWe5rjLkxMjmZmYNRc6bpPNiQlG3yGg20eoR0fs169R27VklVKmnt
			/ZWveHENQ1JAKc0cVlvBl+29qDmGVC7IP0OhlO0aZPnqmgAAAAAAAAAAgCtPn1gI3ZQpFs1zK/Tn
			75LXPe/ql+nT9Ufq5yM94m1o2azlOuq4+nwNDw8dCzufGjxynFuhjyda9fIXwzIPxEgyz53Rkaql
			s1gjK3cElvaV1TSVnFJH06HTpxMuS5ecbE8LPrnSeJctquyXMTOVnOyQKSmwVTOt/ncl3b/vtObl
			YL7CwDJF5B15SUeS3RvfocRkh6TiqlbG0NSd/yjZdNt35pL+zibPgnJNAAAAAAAAAABA4XUTAmQO
			nV72m6bKS0MeGKgOd7VQi9TPAN37QnkZy//QikP2q845qF5j3X7qtM66ojH7l86So1czVYqPV7z7
			J9HmCtiYOnvqhKyVyt7cYExQEbW9eE4/7bYpNtGm2DP79fn65MuSTZ+7Q9sTXWnC9unj9R56s03F
			K2QerYWz9ul46nGXdMrLQ545GY5Vo4reLBun52f84zw20abYxH/07bxTkqS6ISXkdzhMM8JS9h3X
			hHmx2Y5MKzDXBAAAAAAAAAAAFFo3YYrFU1q9aJ2KFXtBPVsVy7DPR3e2f1TVvv1Sf6zapycaeatY
			sWLy9nDuNTyLqFgxyTOrMF5Abd3l8YO2nWurrqUtsnj6Kmzh53p5YYZ0lfvq3RdbKMhxTtu2nFbH
			vtVvbBUtHvLzsmQ9RWBgTY1oF6V75odq3nxJgcGaeV8JrV+ZcoxF3t5WPdovSKFjQ/Wi67AB97VS
			D9fwMcPqfg5nemd4s7iqee7UI2NTBkd66t9PNnMed95Dft6SR8aypm4rrh5Dq+ifD/9R97Gn0o4f
			2sz5zxoNtOq+7WozJVRfSZL89c2TZXRyYkL6PPPjNQEAAAAAAEChYBiGTNOUYbCAByCJ/gDkkBEV
			dTEHq2HlXxGrxmvk8XYa90Ad+XpmMyDOtClx+zQ9u+w2ffhyixyMVtqrH0dOlR5+R4/WzetaFiy5
			d00AAAAAAACA9KZNn60+vbopOJi3S4AkhYdHaPbchep/b5/L9jUes0Lb3ussCwE0FBAO01TDN5do
			06h2Nzzvm7IGWW4KavOgHo6YopdnHck+4YUNGvfDVnXqQSAmt3FNAAAAAAAAcLNUq1pZW7btkM1m
			k2kW6LEAwHUxTVM2m01btu1QtaqVM01TKaCIdp6IloO+ggLAYZraeSJalQKK5Er+BX4EWe7Zr1/f
			mSE9MFIDa+V1WQAAAAAAAABk5c8ly1SiRHE1qFdXJUqUyOviAHkiKipK23fuVlTURXXp3CHTNL9v
			PKUle8L1Utcaql7KL6+LDGTr0LlYjV10QJ3rBOv+JuVveP4EyAAAAAAAAAAUeFu2btexf04oNi42
			r4sC5Am/on6qfFtFNbqjQbbpft94StM3n1ZYVGJeFxnIVtkS3rr3znK5EhyTCJABAAAAAAAAAACg
			kCnwa5ABAAAAAAAAAAAAV4MAGQAAAAAAAAAAAAoVAmQAAAAAAAAAAAAoVAiQAQAAAAAAAAAAoFAh
			QAYAAAAAAAAAAIBChQAZAAAAAAAAAAAAChUCZAAAAAAAAAAAAChUCJABAAAAAAAAAACgUCFABgAA
			AAAAAAAAgELFmtsnsNvtcjgcMk0zr+uKfMIwDFksFnl4eFwxbZLdoWSbKcctfv9YDEOeVkNeHjc+
			Zk0fxI1W2PtwbvZXAAAAAAAAADdHrgbI7Ha7du/Zp8NHjik2Li6v64p8wq9oUVWrWll169TK9gV7
			kt2hX0NPav6OszobnZjXxc5VpYt5q0f90hrYvMINfelOH0RuKOx9OLf6KwAAAAAAAICbJ1cDZLt2
			79OZs2fVo/vdCg4KzOu6Ip8Ijziv5StWyzSlBvXrZpnuf6EntP7oRX08sIFuL+2X18XOVQfPxurD
			eftkytRjLW+7YfnSB5EbCnsfzq3+CgAAAAAAAODmydU/fd+3/4Dat2vNi3mkExwUqPbtWmvf/gPZ
			ppu2MUwjeta6pV6sZ+X20n4a0bOWpm0Mu6H50geRGwp7H86t/goAAAAAAADg5snVAFlMbCwv5pGp
			4KBAxcTGZpsm7GLCLfdiPTu3l/ZT2MWEG5onfRC5pbD34dzorwAAAAAAAABuHhZPAQAAAAAAAAAA
			QKFCgAwAAAAAAAAAAACFCgEyAAAAAAAAAAAAFCoEyAAAAAAAAAAAAFCoECADAAAAAAAAAABAoWLN
			6wIAAAAAAAAAAADgJrAnKTYhOfWr1auIfDyNTJOayfGKS5K8i/gqiyQF2i0XILMnxihORVTM20OS
			qeRLsUr29FORvLp6ZrIuxSTIUtRfPh553TqFiz0pWXF2Q0V9rbrxTe9QQrxd8vIsfNfVnqjoOKlo
			MW95KGOfy6l80DeRP5l2XUpwyJZuoyEfH6s87TbFJEs+PlZ5GaaSEmyyWa0qYuUeAgAAAAAAAK7M
			rsQtv+qJL1fLcH2ve8/beq33bcrs9e7FFZ/rXz9JT306Uu2D5QyuJRkq6uupW+GNXL6ZYtFMjld0
			dEz6T6L9qvPZ9d3davndXte3SM0dcbeGL4zMu4qFL9LwDndr/M68K0Lh5NDW35arzXubtPXqb6Mc
			OKbx7y7X+P15Xc9cYk9UdHSMEjJru50T1LLDBO1yfU3f53IqH/RN5E8Re/TKuyvU+ZM16pr6CdWf
			56XIdaGp/5YuaO43y/XKqguuA00lJSRnfs8CAAAAAAAAkHRQ0xZW0ndTJmnqlEmaOuXfum3a65q8
			LfOXaiU6j9TUKa7gmCTt+kUDxixXVF5X4wbJNyPIzi98U+3f3yL/Ip6pkcuE7h9o9QtNCtAIE7sS
			oi9J7qPFDE8VKVbwR4+ZpimbzSZPT89s0yUnJ8tqtcow8via2Y9q8QEfdSgdrcV7HGpcL9/EggsA
			U8mbxqvtC7PUf/wKvd44P9y8jDi7EQpOPy6mCW81U4OMm9u00ro2WR1zQXO/2aSjXe7W8Dp5VGwA
			AAAAAAAgX6ulh0fVSve918PV9MjmffrXnXUvT25PUmyC5FvUS0qMU3xCsmRPUlxcnDytPvJzDTuz
			J8YpPnVKKE/5FvVyzepmV2JcguTjIyUkKNltvyU5XnFJDuchbnmlHJM6CWS6fTdWvgmQSZKavqw5
			43opSJK0V+NaPakXq8/QhL7B15nxzbJX4zsMlSb9reENXZuCu+qTZV3zumDXxTRNnThxQlu2bFG3
			bt3k7e2dabrExEQtWLBAd955pypWrJinQTL7nnD9EVJJS8r8o47bjmh4SHV5pRYnZXpEqyzJNiWY
			zq1Wz7Sp2kybTTE2Q/6epmKSXAmUxXSNpl2XEkxZfaxu53BO8ZhoKYDTv5nnNOPHOWrXpoWmrdiu
			V+9slA/ml43U3BE99Venefq6d2BeF6ZAKoj9+DJ2m6KTdHk/NO26lGBXvCklJSUrOt5wTcOoy6Zs
			zKyfF7Waiks20+0DAAAAAAAAbn2mbDaHrJYs3ont+kUDxkgfTx8sj6kvaNTiJCnZ0CtPz5LRcbim
			PlpL9sQ4bf9xmP6zxvnGzrTdpX9/P0h3+HrK0D79POg9Jb82Qr5ffamFMpWc0ExvTH5IpZaP1fDf
			j0lmshKaP6/f/nWnvD1MJcdv05ShX2up1ZBkKrnNy5o+pG6Oa3Q18leALJ3aGjC8kToePyspWCkj
			SOze6Udjmcnxikm2uo08y549MUZxiZJXlmuCOUeBJaV+90pda8ktE0XHpaWQ1Uf+3g7FxLmOuxSj
			6GjXOSzJuhRjk6e/+yJ2Gc9hla/7fjPlGC/ZY9LSWX3Tj55JqUtqSXNpnbP4+Hh98MEHioyM1PHj
			x/XUU09d9nI9MTFR3377rdatW6fFixfr008/VZEiRW58YXLCtGvzthg92rS5AgPj1GbxSc04W00D
			yqS03TGNf/eQku6/QzXX7tKnkc5rckfTBvq4Y5CKWA2dX7VG7baV1NzOiXpoVpwzW5uvPh3RWM0y
			vpw/v08jxoarxXNt3c7hnOJxSqUmGte2ZN60w7U2X9g6Ld02QM/PriL1+VEzHrxDD5S7zqCBay2+
			1CCFryOTJPGKSfszg7T73UzWpZhYxdskW0KsoqO90vWF9P0gs76Udl5ZfXL8rLjVFLh+nJn9m9Xi
			Z+mX9zOMLju/X299E6ZVCZJ91hrN8/DUyKdbqVegXZdO7taIyee1yZBS+vmnnYLl46HUfv7fhtF6
			ca1Nd7VtqE/bFKz+CgAAAAAAAFwre+Jxhf59Qs07lLpi2hqPTtLUhpPVc2p5ffvB3SopSWaydk16
			Wh/4va5pU5wj06KWvKfBo5dowkfdFex6EfvnuF366JdJelQRWj76ZY0atEa+vV3HhC/XB899oikt
			/qehd0Ro+ZhPdGbQl5raNUhShJYvici1+uffeefsiTp0aJuKpg6dc65ZlHEtr/ML31TLEYt0PgdZ
			msnxWv9lT93d915N2pNVmp36uve96tbX+bm763itv5Qs0y2P6PXfqlNqmn7q9Poind/zo7r1Hanp
			kqaPcO6btEeuNcje1Nzw1Ax0KXqzxnXvl3qObj1H6fejbus9hS/S8A4j9PvRnfouNU1PvTjztJJN
			t7p801td3fbn1jpnRYoU0ciRIxUQEKC1a9fqu+++U2JiWmTO/aV6QECARo4cmacv1c2zuzXxQHF1
			rCkpqJw6lk7S0p3nU69hit9n7pPXA+217q32WvdWddVct1UvLHdLF3FOA/aXcu1vr3kdkzTs3UzW
			NMvsHPajWrzPWx3rFrSX7XaFrVmhzQ+3U0hwVz3x8DYtXXNG17Wsk5msS0dn6bWeaf3qjflH3Ybc
			us47f0xan+jdW8NnHnf2iYilGtV3iL7YIm0cN0Td+t6rUX85152yJ8Zo/Xd9M/SleFc/sSsh3Xld
			fTWvmziPFKx+bCouPlnRKZ8E+2X9N52gOvr0rTs0Ikh68P72WvdWK/UKkuxhu/TKpIvq/Ez6fv7Z
			HrcAbcQ5/c8aonVvtSc4BgAAAAAAgELCVHJ8nLZPHqWffR/TvzoHXVs2Z5fqj2WtNPK+ioqNi1Ns
			XJysLbqpy+F12nw2LVnP1x5SDUlSkNr3ay95dNR7j7qmegxur74dpNNhEZIMWa0WBZf0VWx8skwF
			qX3nWldfrhzKXyPIbAmKiY6RlyTtmqBnZz2on9bUviFZm8nxOjbzTb047yH9d8WTCskiXeRfG3T7
			tMVa65rVcdfXbTVweHUt/bqPSsmusJkj1Gu8v96evli9giUpUnO/2yCj3pNau6yFPmk8VBq3OG2K
			xXPp87efmqUX7/9Wxd6aprXdApwbd05Q84fv1j/j1rit97RBnz1WVz+uWqwXJGnnd2o69D+a0epz
			PVDOUPj8EXrq2HCtWNZDga48xufipalUqZJGjhypDz74QGvXrpUkPfXUU5J02Uv1SpUq5WJJrsTU
			2Z2R2hxS2XWNS6pVA2+N3nxaZzsFqYzb0KGW7UPUK7XfV9ZD7f9R261hOp/yMDCKa9J9lVPTB7ap
			qIf/PKgV+6XG6dY4yngOU0m7wvVH2WA9dY3PlTxj36kf/rNNgyY7+11I6wHaPPh/2nrvK7rWpcjs
			p2bpxYe/Vf3vlmp8Pee2Xd911uNbpMaps48e0Iyzg7R22QfOr+EL9UKvARpXfZ1ea9RVnyxrohnP
			99RfnaamTbFoJmvzlz31sv+3Cl3mek7s/E5NHxwh64zP9UDZ3Rp3/zhV/e9qja8vpfbVvG7jPFRw
			+nGMXvpkTdpIzaDSmvt0HV3d5Jqmdiw7K1uLO9S2aLKi4yWpvHq1OKZe249qZL1qzmRGcT1BYAwA
			AAAAAACFhl2JcSe19MMxmuL5mL4b1V4lrjWrs2HaqjXa9/SG9LOuFZV6Rkgqk8Vx1coq8zFrQWrU
			JkQTvnpBSyv21djX2yvIq4h8cmkNoPwVINvytR7qOzH1BXa74RNV6VKyzOudEi05Qcdmvq8HvvbV
			W9OyDo5JUmC3J9UzOV7R0c7hLZUa9pb+e1xhkkqZu/Xzf7Zp0OSVruCYJAWo11M5XWPM1I4/PtPm
			h/+rzSnBMUmq96QmPfyLBq7ZrZGN67vqatVD493KWu8+jWjaU39titQDvQN17swOWSs8JM/oeCX7
			+8qz3pMalsuXJ7OX66Zp5qOX6pLM81qxM0n3dSiv6HjXkn9VS6jJn5FacdZ0mwJRqlIq/UvxwFI+
			6fMK8lXZdBuK67Yg6Wgmpw2sG6x2f53T6nCpf/B5zVgao0d7NL/KF/p5z751qab5PKifXIEs1Wun
			QV6Pa/HWF9X4miJkaff8hHppW0OemqoRu3vqr9QttTXsKbsSomOcU4p611HTRtLak5FSoyxa8ewC
			TZraW58tq6Do6Bjnttu66oVGP2jlpkg9cNdphXk1UmO/GEUnFlEx76vpq7euAtGPVUwT3sowjeJV
			u6Aj4dLGgzvUdUP6wdLFghIVmfLlsn4OAAAAAAAA3Kqca3z9/OQ3injsI0291pFjKSwWWdVWb//4
			hOreoBhWic4jNbWzdODHIRr+r2mq3e8DvXlPOeXC6lL5LEDW9GXNGddLKZdk17ft1Xb481r41T3p
			Rv5cLdvKz9RvnU1vzHvPLbCVGefaYGFL3tNDX211BqpsiZLuc+4O/0fHdJ+eqnfFU2YhUkePSAMf
			v3xUXEiL+6T//qPzqu+qf1NVLpN1TiH3/lsdH3hT3eY00DM/jFKvoAxrL+WSzF6u55+X6pJ59rSW
			XrBo99w1mjfXbYeXTdp+Xv3LBGXZkUyHKVkMOZf+yzSFXEkuF1RHQ0JOac5Zh0zHaS29UFwv1Mzr
			1rjaxkvW5hV/qMnzU1UpOkbRkqQKatJPemrFdr16Z6NruL+yvufTnzpeMfE7NaHnm5pplZxrDrqP
			MMvEmeP62zpPu/r+mSGA7q+7ehlScFc98ehnempIP33R+//01+O1Je8iKuadG4/SgiW/9+Mbw5DF
			IjVp3VATO2UeZM292YsBAAAAAACAfMgepkVjxslz5I/6d8i15uFQ6gImZSqpmedSHTmRrDqVUgY6
			mUpOtMnqfS0Dn+xKTJS8vT2ca551WaS3nv1TB+4ZrBsz12B6+StAlkFIv5d116QVWhd+j/q5xts5
			HKbk1qwOh+2K+Wz09FHHImt04EiMEoL95ZPV+3H7Tn3W4QXN6TRS85d95Bz9s+1L1Rvi2m9YZFGS
			ku3StYUrnS9sk2yXZ2C3JUkWS85vmOCu+mRZV2nnBLUc0k9fXKqjV2Y4p1/Mbe4v1yXlo5fqDoVt
			j9TmkOra8kDl9Lv2b1CjHw9pa6eg1KkCk5JsssvqvBKmXSdPJci3XBkFyvXi3HQo3mZKVmeb2pMu
			6OAFH9XLIsga0rC4Bm04okfKuE/xWHCYYfM06Q8f7SoyVN2+dd9TRF7RP2rGg3dc8/11+T3vUFrX
			NXV2zgh1G7tHT3yzRGvrSdJ555SK2WVqscja6HnNyCaAHvLUYq19KlJzRwxQt56Jiu79hbYNb5gr
			f21Q0OTffnx90n5GlNTt5SzaGHZBCfbAtOe+3aYEWbP+OQAAAAAAAADcqnb9qe/s/fVtlTjFxrnv
			sMi7SA4G4Hh4yvvYcf0TFydvq4/8gtvr3m4/a+Q3f+qON1OmaozQmt+OqPnj1zJ14379b3K8+j/i
			WnfsnzDtK+qVa+9z83WAzJ4UL5vVU1aLJBmyelp16OAZ2RuVdTaIPUEHD26Q1CnbfO5q+7I+eayy
			Wg3rKfP9uXqlebHMX47uXqtp6qf/vt/VNTWeXQlxSZJzVTQpuKpq+n6oP0OfVv27isjLIkmmkhJs
			8vTxlCGLLFbJliGIlyZA1Wv56p3lm/RCg6YqmnK32RMUunyWfGtNyPGUfPaEBMnHRx71ntTaZfc6
			gwmu6RdvhpSX6yn/zhfsRzV5ZbIefbTy5ftqltKjHgf05x6HGrtGAE6ftUV317xDt0tSxB59+Len
			Rg1zO/Z8uD5dFaF37iohSdo1/ZjmNaiu17MadVqzlB79+ZjGRNg0uHtlFSymzv69Qhtbvqa/Pu2W
			4T7cqy9bP6mlf5/T/feWvsqovyEvby/9unyTXr6jWWq/sycc0f4NkrpK0gWFrtmgJsPnaJjr2pjJ
			8Yq3pc/H4iHZHI60TeWqqs2WRVp6vKcevC3trxFS+4YjWQl2q3w8A9Trw8Xqte1L1RuyWruGN7zO
			qftuHfmyH18zQ16ehg6eCtfFagHy9bEqpH05dRp/VJ/uvE3DUkZ0HtiqKT5N9VxBG+EJAAAAAAAA
			XC8Pb/mfna1Xn5mdYUdVPfnpSLUPyiS9n9vQh5CuGhYyUh8/s1Hq8Ip+fbSWajz6kYaNGZkuzx6v
			TnQFxzzk7eeXfuyEh7f8fdOPLvPw9pOvpyGplCqfG6mhz6Tsaa//m/KgauRSc+SvAJktXjHR0fJ0
			fd01Y4L2tBuuD4IkKUAtO7XVe+/8T6HdhjpH5xz4n16dY5XuyEHe9YZqzXipxTM9pA/na9idRVU8
			Y5SsXDV18F2iPUejVTVYkg7rh9fnKHWKRdXWg6+3U68Rb6nyD6PVM1iSIrVoyl51GtZNgSqjGq29
			NOfgP7pYPUDeRYspw6pWCrnvNXXqP1KvVvqvPkhZh2znjxq+sJ1G/Z7zQYK7Jnyl2Mdc7aAYJXv6
			pwXcbpJ890L9UJQW+Abou0xffFdWxwZH9dT+43rDFYQZeH8phX6yRi+4Ugwc2F693B8AQaX1hOcB
			df8kyfW9nOY+XNm10yIfX88MAwErq13tA5ocUV4fFrSX7/YzWrp0i9r0HJ1JkLa2HhzZUp3mrdTp
			vver/FVlHKCegx7Wh8Ne06ct5qYGwA7+/JZmW6XGrjTVaxfVloNHdDHaW5IUveJrfbHFfYrFAFWv
			6auNrjRWX38VDWqmzu3GasynM9Xiva5KWdVv/5RfVWTYUwqJWKRxy+vpqZR+Fif5FfNh9FgG+a4f
			Gx4q6mvN/Dp5WFXcN6XbGfLy8XR77pVUr84B+vD33eq+wUsjnm6pXkF19MnAeLX8fY0WpEy5GlRa
			c552ncrTU8V9PK5vjUsAAAAAAACgoAh5UL/++OBVpnffEKT2oyaqva60LUUtPfzjxMvzzDD9Wo1H
			J+o117+zzuvGyzcBMsOziIrv+16P9P0+beOAL7Xmw7SgUWC3lzVq5UD9u+9i1/7PNff1U+qzMi3a
			6OFTTMVTX60a8ipSLO0Far2hmvv6cfV5q78WDvhca57MEJAK6qrXX1+rPkP76xtJ0n36dvzDmvZC
			WhwksNu7mqu33NJId736qx6QlBoMeOEp9fhOGvDFnxpW1lNFi6WMNnOe4+Np0qv3O9PIdZ6Jy95N
			m5LPkuGYTOri4bM4rR0k3fXqVH2cEggorGreqbVvZb075L72cq62dMS1pbKGvVVZw7LJsmzrllrb
			OrM9zmPTsdsUa5faNCiX45GA+caeefpmXzuNGJP5PRTYtJ06fTJWM/fcr2EePipeLK1PpO9zmXAF
			p1u90F8LXZsGfDFVo44P1ErX/Rzy5Jd6rMOL6uFKcNern2tUu82p+yVXcPn+Ueqx0NnnPu4WoJ4f
			TpVGDEz33Ljr1V/1sSRZPBX+XcZ+NrTATX1Z6ATV0SdZ9eN0fbykej3dXr2y3J/NNpfALPs3AAAA
			AAAAgFudERV10cytzCdN/kmvvPhsXtcR+dSnn3+lIYMfyXJ/o3dWaNf7d+fCmY/ok9cPSQ/freF1
			Mk8RsWyF2m0P1IqX6inoStmZdsUlOGTbv1md5tg16pmW6UeiXYWQ1xdry+h2N6ym9EHkprzrw/nD
			je6vAAAAAAAAAG6efDOCDLh5MpseMb2rmnrt/H6N/uas/pbXdQXHAAAAAAAAAADAzUGADIVQJtMj
			ZnBVU68F1dEnb9XJYWIAAAAAAAAAAJDXLNefBQAAAAAAAAAAAFBwECADAAAAAAAAAABAoUKADAAA
			AAAAAAAAAIVKrgbIDMOQwzTzuo7IhxymKcMwsk1jMQzZHYXn/rE7TFmu0CZXiz6I3FLY+3Bu9FcA
			AAAAAAAAN0+uBshKFC+usLCzvKBHOg7TVFjYWZUoXjzbdLcF+mrHiYu37At2d3aHqR0nLuq2QN8b
			mi99ELmhsPfh3OqvAAAAAAAAAG4ea25mXqd2Ta1es06tWt2loICSeV1X5BMRkRe0Zs3fqlO7Zrbp
			BjQrry8WH9DznWuoWumieV3sXHX4bJzGLTmgAc3K39B86YPIDYW9D+dWfwUAAAAAAABw8xhRURdz
			9U/79+47oP0HDikmNjav64p8wt/PTzVrVFftWjWumHbaplOauTlMpy8m5nWxc1W54t66586y6t/4
			xr9wpw/iRivsfTg3+ysAAAAAAACAmyPXA2QAAAAAAAAAAABAfpKra5ABAAAAAAAAAAAA+Q0BMgAA
			AAAAAAAAABQqBMgAAAAAAAAAAABQqBAgAwAAAAAAAAAAQKFCgAwAAAAAAAAAAACFCgEyAAAAAAAA
			AAAAFCrW3MrYbrfndd0AAAAAAAAAAABQwHl4eNzwPHMtQLZn735ZrbmWPQAAAAAAAAAAAG5xNptN
			9ULq3PB8cyWCZZqmJKl5s8a52yoAAAAAAAAAAAC4Za1ZGyrTNGUYxg3NN1fWIEsJkAEAAAAAAAAA
			AADXIzfiTrkSIAMAAAAAAAAAAADyKwJkAAAAAAAAAAAAKFQIkAEAAAAAAAAAAKBQIUAGAAAAAAAA
			AACAQoUAGQAAAAAAAAAAAAoVAmQAAAAAAAAAAAAoVAiQAQAAAAAAAAAAoFAhQAYAAAAAAAAAAIBC
			hQAZAAAAAAAAAAAAChUCZAAAAAAAAAAAAChUrHldgMwkJ9tkt9tlmmaO0huGIQ8PD3l65svqAAAA
			AAAAAAAAIB/JdxGlxMQkrd+wSUeO/qPYuDgZV0hvSvIrWlRVq9ymZk0by9vbK6+rAAAAAADIjC1e
			UbGSXwnf/PfL6FVXJUqx8lcJX4/cOYHpkN1ul8NhKu1PRw0ZFos8PDxkudIvywAAAACyla9+J0lO
			tmn23AUqWbKEOrRrqaJFi8owsv+/ftM0FRcXp/0Hj2j23AW6p09PRpIBAAAAQB6xxUcpNtF9i3da
			QGzXJLUeIv286Tk1yOuCXqfdE7vpYU3UzudDbnjept2mpPhzOrz3kMLOxyre5pAkWay+8gssparV
			aqh0cS95ehAlAwAAAK5VvookrV0XqpIlS6hp4ztktVplGEaOAmQ+Pj5qWry4NmzaqrXrQtWubaub
			U2Bbsi4kmiri6yVvS3ZpJP+invmrsQEAyIotXlGxDhUpVlRerFYKAMgxU0lxF7Xh+/4aOSfttx97
			fHd9s/bmBMQcSXGKTvZUsaJeBXbBbdOepKgjm7Rhf6SSXdsMwyJDpkxbvKLP/qNtZ0+rWOVGal47
			SF4EyQDgprPFRynWUSRHP29ya8Tx1ZQByDU5mR3AkaTY6GR53dR3DM7/L71kuQF9L9/WETdCvrpc
			Bw4eVu2at8vLy+uaPrVr3q4DBw/fkLLYEpN0IS7rT6JD0t5QNX5ruWZHZJPR3lA1fitUO/O6cQEA
			ty5HkmKjohSblLO1O69o1yS17jRK8yKuPysAQCHiOKuZw/vqNd9xWv3XwtTPxMdu3nSKkYtGqfXI
			PxWZ121xrUy7Yg5t0N8pwTHDQ57ePioWUEqlSgWqRFEvWS2GpGRFH9uoDYdiZL9BP/4B4NZnV3xU
			lKLcP3FJclxDTrsndsvxz5vdE7up9cS9OcvYFq+oqDglZVEoR1KcoqLiZbvKMqCwyuSej4pSVLz9
			xp1i1yS17jRJu7NLE/GnXruOdwyOpLjUMtviM6lPpu9DIjVv5FX0vTyuI/JOvhrUFBMbq5IlS8jT
			01MWi+WKo8dSmKYpwzBUsmQJxcTG3pCy7J21TI+77npHUrKibIZKFLG6IoreevP59upj9VSAn9vo
			MVuyIhOkYn6MFgMA3Dy2UzP12v1fKfmV3/XdfWWu7q9fbPG6ECP5l3R7eWn1VcmSflmPjgYAIDMR
			G7VyY0998WXtdJvrDh1yeVpHkmIvXkodIeXtX0JF3H+JssXrQozbPI2eRVTcz+0v5FN+fvlLMTGJ
			kqevfBWvqEvJUvIlRV2Ikof7Mdnm51BibLQuJaftvqw8sunShVil5uDjl2kTOJJidTHOlk0+2XPE
			7NXmg1FpL2v9Kuquu2rKV6ZMGbJYPRS1Z4XWH7skUw5FHdysvWXbKqQYP7QBIDvO5/NOTejzjuZ7
			p71vNBsM1eQ37lbF4lf3+4/Vt4RK+uXCyK19P6rzY3v0yuzPNaB8xtwdOjtnpHqMC9FPq57MvTLg
			FrJXX3Uaqt/8S8jX/f9H7h+rVUNr5XXhcsim0zNG6b6LQxX6VC3nFNe/+6tkulFhdjV44luN6VLW
			7d2GRd5+JVTSl7f0yF6+u0M8PDxSp1bMaYBMkgzDkIfHjRuqXO+Brtro+nf44j/VfEuwFo1opGD3
			REHNtXGM2/e9oWoyWfrjs9a6Iy8bEQBQiNi09dev5NW2tTYuXanTfR9Qhav56b5rktpkXAsmZIhW
			LcnregEAChyLl4oWmaM//x6i2s2KyS/L+WUSFXP8T70z9Gutl2QmxqnL//2pEa2dLzQcSbG6uH6S
			ur39Z+oUNbaQxzRlVG9VLpm2llmbIYn65hs/vf76bKnJUA3TRH25Jk5K3q3B9/8go8mLmvV+F5W4
			LD9TSSHPat7YXgqSTZcuHNf0Mf/SxF2u3ycdSerx9nQ9m1oHmy5d2Kgv3V6qmn3f1QcJknzSauVI
			itWROe9p8HfbZbjl89xdOQ2SOXTmwCnFuW+KOa0d26OUeD5a8XZf3dasverVqiD/YwcULUmK06kD
			Z1SncTlekAJAVhxJOjHjdd333UG1f/1XrepaMnVX5KLR6tNnrZ78/j0NvD3nI57rDl2oVblR1pB2
			esTnRy39+5zuz/jHj45zWrl0m9qMfEd1JSm3yoBbzgNjF2p4w7wuxTWy7dQPX3jqjbluAb37P9Oq
			dGvA7tPXnZ9Rty866ZNlL6qVr1VSSfV4f6F65HX5ke/luwCZpGsKjl1N+hvGbcSYEpIUneAcyhkd
			m6RIGVmOJHMkJSkqKe27j4/XVf1VIQAAqWw79efMFuo49xFV7/ekfth6r95scvkPlYx/0S4fP/kr
			1vlX95JiLkTpgrydf22V2aiynP4lf3EPJWQ3IgAAcOsK6qKRr69T37fv1emhE/V/XQLkWTSzQNkc
			Df/2DS1YslABkiIXvaEuL32lLqHD1cRq0+kZr+ue70rq7WkL1SPIecTuiXdrYOcT+jp0uNJ+zM3R
			8C0TFLrkX67v/dRhzitq/1c7zRzXS85DbTp5WX4XNH/iBlkkOZK26bPu/9afj3+l1WNdL14i/tSr
			/XrrpeedI7OVtE2fdX9TF0f/kfpSNXLRaPV8T9L9KWWx6fSM0Xp4291asORDBbjyeblvN302dnWm
			P5svd17hF5IzbEtS1NkkybDI6lNURX0dsoXHKMEtRXLkGYWrnErn9fUHgHzKdmqm3vtitx6duFTD
			QtLvC+j6jmbrDXUZ+JVqhQ5XE6tzVLHdJ/3vMY6kWF1M8kr9HcgWH6UY+aUbnZLZ71yZjV5JSZf5
			z8ha6vhIEf2wdJ3O9uunsm67HWHrtHRbC/V+1/mzKLMy2OKjFJP6Q8KqIq6RcZendY2e9nDfZtOl
			CwnyuMrRdCjAcvh7fPr7Kqvf89OPts/8/naTYTaBzPuLQ4mblmp26/Z6Jii7itTSM0t+1W2v3aOn
			v+yora/dIavrHk/2SitHdvXIuzoir+W7x931BLpuepBsb6iajHKuL7Z39jJ1mXlR0kW9+J9l6vKf
			zcpshlNHUpIO/7VSnf+zTF3+s0xdPlysz7Ym6ZLtKs8NAIDrfxZntGynlkG19ODIFpqxfJtznUw3
			tvgoHZkxRj3uH6g+9w9Un/vv190T92n/zwPVZ9Q8SfP02v0D1ef+X7Rfcv5Vfue0+bUdSbG68Pd3
			6nZfyvED1eOtmTpywTn3vVKP+Uqhx//UO640vfv01md/u6UBANzyArq+o1W/vSa/759Vn/vu1Wsz
			julCbMb1XZpr5PAuziCSpICuA/WApmvlLkmO3frlkx165Mt3UoNjklR36Dg94jNdy3Y40udz7xWm
			B8o0v5LqMdR5/oj5UzSj5aua7T7NUFAXjRzZQpuXhirCLc1ItxEHAV3f0Tf3ZzxPsp59opmMC1G6
			cCFKFzyaqV9v6be/9+Ww9aIUm5j5HkuRcgppfqcqJh/Tll1hSnLfmRTvGk0GALicQzv++FybW76q
			B0MyTxHQ9SE96Dldf261Sbqg+a9309e70qeJXDRabV5PW+9r98RuajMx7fme1e9cl7HF68iM0ep2
			30CNWXYx0/LUvfdVtdm2QivD3H/mOXT27xXa3LKdWgZlXYbQifen/s7Wp98Y/X44VokOaf8PfdXm
			y51pv5s5zmnmq93Sb7Pt1Gedx2gRi5oVHjn5Pd6RpK3/HeB2X/XVZ3/HZnjvkKiYCzs1KSWN6/8B
			Y7NeTE+xh+fpzdR3DAPU7duNuhCf4e2B45xm/jhPjwxK+//GrJVUj4fvl+fvK+X830VnX35t0QXX
			KWMV+u296u1Wj9R+npd1RJ4jZHmD1HugqzbWWa1qk6X/jslqikW7Ti1ernsPldXyMfUVKEkROzTs
			P4v0kbWH3rnjxk0RCQAoBBznNPPHOWrT+wnn/yw2aac2Y6Zo5kON0uardyRp85e99cKfg/T90v84
			p+LQPn090TUtSJMvVW+I9M0StykW07nKv+TPckRAXjcWAOCmCeqi/yzp4lysfOC/dPfKJzTzS/cp
			gCuqclZ/BRxxXP/oXj112UvMWmp7v/TdyQtSo8Ar53PF/JzCTmxU8zajL3vpEnBnSzV/65jCJCmL
			NJefZ4dmPzNQE9PtKKGS9+f0h6Ahw5CUcY15eSq4Wl2VTtivvzceUXTG9yqGoTyYTwUACogLOnZU
			at6pSTbP8bKq2lx68+99erNJ2as/RTa/c6Vji9eFv7/SwO/80v1udZmgZurY8n3NcZ9m0XFOK5fu
			ULs+72ReD0eSNn/ZV6+V/Fbrlrj+6GPXBDUf9Lo8//hcA1oPkM9jK7Vj+B1qZHGNRtvpLZ+Nbtt2
			rNRvPlV1z5V+tqLASYiJ0oULad/Tj466wu/xkcv/n737jq+6uv84/ro7N3sxAmQww957IyIobtyz
			VO3QDm2trda2ttYOf63auqrWqq174BaQvfeegUxCCGSPm9x97++PDAIECEJIMO/n42FLvuN8zznf
			m9x7v59zPocN3d9h+YLagUI7/8WI7zxC6hf/5PqODcq4LppXF83lJ1A7G/87PGBufJ10X97HPHTX
			TmbOmcszdbP7H7qGic8+XTv7q+64ZSzfdQv3neRz3Ak6pTCORWQXwdD2x+4q+vIRfnjg5yxbcFnN
			79DOf/NC3c4WbKO0vFY3g+xbLZDOG4uDPHB1bwwODyUODyUhvbk+Fd7cntHStRMRkQtMzZeaCUwb
			UfshLn4UU8dtZdGagqMj9Qu+4t8fj+XX791d+0UNoDf3NnVB3jMdyX+yGQEiItL2xE/nyQXPcMvW
			Z3hre6Bp5xhNmHDjOWFwrQ+PC0zGM/wKe9Ly6nZb8Hq8HF+7gNeL12Kq/8J84jEB/P7jr3M5/5g7
			l+ULjvuvqe+5xBIZ0th2P2U5m9i0I/fE4BiALawJo6pFROTkokhMAovpGz4mbcp3Lr8Lx5rnueS3
			i5h93HerE8UwbupYNi1azZHaN5+a7343cVeD2cwn1OH9y3nyuo41s5hLyyjtfDH3Dd7A8k2l0H8i
			t1gy2Vc7K61o/VK23nobt4fUbQtwJDOTkFsnN2iDfFt8+tuj2WCuuuFmXj9mcuNpvsfHT+feS8Jw
			1L+uBnEVG8g5fFwZDV//8dN5+KHRrK2djX+smlmd3ntnM9ZUW2apgbFXXA7vr6zPZFO/3vrD1zf9
			NRnbmS4n2VVYsAtLQgyG0tqZYf3v5t66wFuLtVFaAwUrz6eiKrLw8tF/Fh+NUANgJbafZo+JiMiZ
			8HFoxVLWXnkzT5rqRoMZ6DN8MI8sWsahq2tH6h/OZe2Icfz5m44CPNcj+UVE5Nsr4KHaZya04VoM
			vmjiB1vYdKQciDl9GfHdSA39C/PX/ICB446ugeJzbmD+x6GkXnbqMoxGE3j9R4NZjZYXwO30YbFb
			6dx9Als/XUbmzFn0qFsTIuAhd8VStk6YSWcg3xbKpkXLyL3yepJr2xbw5LFrH9Dn6HV6hjzO/DX3
			MWTC0TU8Ax4nXrO9iWu5xNI+zkbOQfdxk8iCGEwWLCYTBrzH7TNgi09QgExE5KSMmExHBzo0/ue4
			mIx9MG5mAtDEAR0NNeU7V9Y7PPTWaq57edXRh/KnEDtiMhP/8BXL8q/mps5wZM1Stt5678kDBYdz
			WWuZy94bFh03qzia0VYjkECPcVtrZ6XFk7N/O7df9k+mMpln1hRww7WwbNF2br+vqYM65EJy49Nz
			eXDwyfae+nu8z1lG5cHF/P4Hr7DZCODHCdx4mjJiuyTChlzygWMnc9XM6tz62X1c9eqx58TEzGrw
			GWor8z+bwLTvNuHzY52CLNItFvo28oveb9ZDXHzzH7hq7gDuefkRLo8/bo2+FmijtA66H+eT0YCJ
			KP7124mMUs+LiMjZ8O3g9b9tJyJmP1ctaLgjSJhjA69vmcWjI8xgNGHxevGe/NvgqTUceX/Me9c3
			HMkvIiLfXkXzeXZxP743vUG4ZudHvJg+hV+PaOrDjd7c8sgUrvr170h+9TdcXpfa93+/4+spD/HJ
			aR4qxqb0IGxrOvtKy7BYQokKbzgWmGcAAIAASURBVKy8Eua/vY9L7ptB7Izbmf33n3Dzs0l8fU9t
			tKtoMU+/sp/Z/6gZTR076yEufv9J/jpnBE/Utq1ixcu8uIOjATJ6M/XOaO55+Hkmf350dHHx0ndJ
			m/CD08wUOKp9rySi8tMp8zcMg0XRZcRAupOBc346ZQ32GExRJPVq37TCRUTapBh69K4Z6FA/iPA4
			AU8OaRts9LwvBigGwB849gtUwO89+SWa8p3LFEJ4VCg5+7Jx9E8h3Hqa71Hxo5g24S980tTgldGE
			ZfB9vP/8tSScpOhxU8fyu8/WUnR1MvM/u4lrHoJ+3MTW59dSNB4W7biJ+5uayk7aCB9bnr2Ue+de
			wmMf1KUK3Mnfht9z+jO9bggJbyT4UBO0vurJz2ueWTQqwJHP/sunt97Lo00ehOujen86WydM4a+N
			nVOXAnznv5l470087+jF/R8+w02dAy3URmktdIfOJaMBCwH8J3tDjI8k1ZzLV1u8DBthaRAR9+I1
			W5o4qlBERAR8WxbxXshNvLvgB8eNIqzJa/2rJTv41YghmDt1Z/KOL1mYcSk396wb0e6j2gmh9toA
			Gp5TvHed3Uh+ERFpQ4xWil89fqTsLF5Z8Puj71VmOzExx38RNRMaE12/MXbG7/mU33F1w/W8bvgn
			y//U4MFgo+UA/a/nN1Nu4ZEbFsGI+/nkT9MbLW/0z9/mJgB6c++Cf8K0BxoMOBnJL99rsDZM/HSe
			fA8euvlo20b//G1euXMjP2xQg373zOUVLuWHNyw6Wp8bnmb5mcyuDk1lWO9yVu4twuMP1M4WKyNn
			1QZKqDwmOGY02YjvPYzU0PN3i0VELkT9Zj3E1Lee4PU10/nZmIZrL9XMHMn+9B2+iLqNV/sDGLFY
			LaTvO4xvaKeav/I+J/v2bwCmNX6B033nAuh6M0/+eiIP3XgPD/EKT157uiBZDDPvuInHnl/NoVGc
			fh2mTt2YuPUrFh64nFtTrPVf7XxOJ9hr6lQzK20n+9ak8+mtl/Mo1KRe3PoV+/bDppsvU3pFOc4+
			Vn4M1z3/u/rPRT5nJS7g2KzQbiodHgLhta89n5O1Sz4i5NbXGnlNxdCjl41Hl2zgZ0PGHP19bJiJ
			wHeYhct3cef3mjij0eektHIrL/96IbNfeLDRmfX1vwv972b5gmuY85PLWbiplJs6H2mZNkqr0aoC
			ZAaDgUDgG0xlrhUIBDAYWnB54g6RXGw+xI4DHrrFG4gMtxzXwd25ZNh+7vhgDRf1Gc2A2q3FKzew
			e/g4rlJaKhERaYqAh02n+CA2846beOw7i9h0/yBGxU/nrjuf4Z7Zz9O1fkT7Hl59N4YHf9i75stc
			yJfsyiija7yNiBj7ce9dZzeSX0RE2pC6kbmn0v9uli84fmNv7l0w95gtsTN+z/IZZ1oOQAwz/zSX
			mcdtPXV5Nde/94zbNpflx23pd89clp9+wPEp2bsOZ6xxKxv3FVLt9REIBPE6SigBwIDBaMRkDqFd
			6kiGJNvP7mIiIm1B/HQefmQ1Vz82C8tjH/G9Bt9hdr1yKT98fyy//6ruu1IM4y6exBO/f5u102u3
			pb/Lw19YYPDJyz/ld64Gxz35Hjx0/Xd5gP/w5OVdiAq3njzRR//J3L7jBV5/x4L14UdPHbyKH8W0
			Kc/w+FMfM+b306lLgr/v7fcJv+97NefGj2LquD/xwweM3PP6g7VHJNBj3Gf88AGY+vhdLX2npJm4
			KuuWZajT2Hf/xiTQa1IoX+7LprRrTdgp/d3f8SnHpx/8gof+0IP/Pjy55rW38988MDea2c82HuDq
			N+E2Yn78ME+N+eRo4LdoKf/LmMRPZsTg2/I2T1t/wcKTPW9wVVJaWnb0553/Y+YfvmL8I+/wy5Oc
			s+uV56m8ve73sxyPNao2SN0ybZTWo1UFyKKjoiguLqFTpwSCwWCTg13BYM24uuLiEqKjos55vYxW
			K7Gh5hPfsMwWYsMbdGL8QL4/7BDf/c9iXiCa//xhNAOOO2bAjTP4L/P47pOLj5bTrycbFBwTEZGm
			KlnCRwuimf30SUZT9Z/M7JgH+GjxXYyaEdPoiPabnq59EFn7Ze6H997MK8zixQV30++4UfnffCT/
			sTMCREREpCmMhCUPZVKnEnLS0jlQUIHTVzOQ1Gi2Ex6XQI8+3YjX6GMRkSaLnfF7lg+fz0M338xV
			x+yJJiLES1V5GaUWsIRFEjvjZ/xmee1sZIAbnubTR/K5evnRYJbZHk3MaWYR133nOubY+Ok8+Wwu
			Ex+4j6u21850PmmtezP1zv388P2R/LKRdZiOrUMMM//0DjxyC9+94fX6Y0b//G2erP8phnEXTyFm
			WyJT+x+/DaY1OR2yXDhqvpN/9oeb+fqY7Y1/9294Ts3GGGY++BDLGsyiv+npfzJ7zgNHTzLbiYm5
			jRfvKOK7N9xcX8rsZ+ceXW/PaCU85mhGGvrfzfJnYeIDDes1ixcXxNQOCP6CyRff1ejvhtkeTczn
			fzhuqYlZvLJg7nFBZCO28Oj6mZpm+6Kjv9PA6J+/w5O1garz3kZpVQxlZeXBsy/mWIFAgF279zJ+
			3OgzOm/tuo2UlZczacJYrFYrJpOpSef5/X48Hg/LVqwmOiqK0aOGn5/eExERERERERERkQtWzSyy
			mn+P/vnb9Q/NReT88+W+xw9vLuX+lT9Qyk85xspVa+nXtzdG47kdJNaqxnSPHjWcTz77ipWr19Gn
			dy9iops2G6y0rJw9e/fhcrkZfYmCYyIiIiIiIiIiInJ65yI9roicG2nzXiftzqcVHJPzplUFyACu
			vvIy1q7byNJlK6l0OJp0TkR4OD26d2Pa1MktXX0RERERERERERERETlD/e45cY1XkebU6gJkUDOT
			TGkSRUREREREREREREREpDloVV8RERERERERERERERFpUxQgExERERERERERERERkTZFATIRERER
			ERERERERERFpUxQgExERERERERERERERkTZFATIRERERERERERERERFpUxQgExERERERERERERER
			kTZFATIRERERERERERERERFpUxQgExERERERERERERERkTZFATIRERERERERERERERFpUxQgExER
			ERERERERERERkTbF3JyFe73elm6fiIiIiIiIiIiIiIiIXIAsFkuzld2sAbLNW7Y1Z/EiIiIiIiIi
			IiIiIiLyLTVq5PBmK7tZA2QDB/ZvzuJFREREREREREREREREzpjWIBMREREREREREREREZE2RQEy
			ERERERERERERERERaVMUIBMREREREREREREREZE2RQEyERERERERERERERERaVMUIBMRERERERER
			EREREZE2RQEyERERERERERERERERaVMUIBMREREREREREREREZE2RQEyERERERERERERERERaVMU
			IBMREREREREREREREZE2RQEyERERERERERERERERaVPMLV2Bxni9Xnw+P8FgsEnHGwwGzGYTFoul
			pasuIiIiIiIiIiIiIiIirVyrC5C53W42b95Gbm4eVc7qJp0TZg8lMbEzQ4cOwmaztXQTRERERERE
			REREREREpBVrVQEyr9fL/K8XExcXy5TJ4wkLC8VgMJzynGAwSFVVNfvSM5n/9WIunXGxZpKJiIiI
			iIi0kDPNCCIibY8yAYmIiEhr0KoCZOvXbyI2NoYRwwZjNpsxGAxNCpCFhIQwIiqS9Ru3sH79JsaN
			G908FQwG8Hj8OL0BvLXf9QwGA/YQC6Fmw9mVLSIiIiIicoFzu91s3bqDA7kHcVQ1LSOIiLQ9YXa7
			MgGJiIhIi2tVAbKMzGwuv+wSrFbrGQXIgsEgRqORvr178cVXXzdLgCzo81JRXMjKFVm8v7eaXV4D
			RoLYrRaumTmM+wdHnP1F/D4c7gBBs5kIq7G5ullEREREROSc83q9LFi4hJ49uzNwQD9MJlNLV0lE
			WqmKigr27ktn3vxFXHbpNM0kExERkRbRqgJkjqoqoqOjsFgsGI3G0wbH6gSDQQwGA9HRUTiqqs59
			xYI+SnZu4d4Py8mxmYmPiOT27iGE4yU/vxqH039urpO/n7/OycM9aChPToo99+0QERERERFpJuvX
			b6Jnz+50TU5u6aqISCsXGRnJyOFDWbthU/NmAhIRERE5hVYVIAMwmUz1M8eaGiCDmlSHzTVC0VeU
			xuMflpEZEsYjtw/mmuSwRo7yU1Xpw2k0ERtmpm7+l8/lpsxrIDzMSogRgn4f1e4ALn+QYG17I0PN
			BF1uyo6U8/HhAKN6eSmqdGO1WYi0GiHox+32U+0L4g/WtNVqMRFmM9VeJ4CryosjYCQqzIDb6ccV
			AIPRSITdgiXoo8p17DZNUBMRERERkXMpIzOboUMGtXQ1ROQC0je1J1/NW6gAmYiIiLSIVhcgA75R
			cOxMjj8zAfYuy2dh0Mz3rxnGNckhJzkuhxf/nM7r7RJY+sAA4mu37pqzjFt3Wvn9A5OZFe+jZP9u
			XlxYyNIScBKkU2x7/v6jgVR8sZLv7wgAsGn1Tq5aD6MnD+XvEyKpKjzI5/MO8EGOh8NBMBoMDO+T
			yI8u60a3UBMGyvjy5Y38rjCSf34vkvUf5/NJiR/CIvnNHYMZVZHGK3OL+KzMT9Aezi9vHM6VXa0o
			4YmIiIiIiJwrjqoqpVUUkTMSGRnZPJmARERERJqg1c0jOptAV/MEyYrYnRWAkCim9ws5u6LK9vPH
			Nw/zmS+CB67sxrNXduYis49KIGVsN54dbQegV+9OPDurG9/tHY6/MpOnXkrjbwdgyIhknp2VzI+S
			LGzelsVPP8ykMtDwAg5emltF6pQUftk3BGtlBb98Zw2PfeKgy/huPD7cjtXh4Dfv7yI32AxdJSIi
			IiIiIiIiIiIicgFolTPIWhcHuWVAnJWYsy2qqIpNQKcuHRjdI4EQq4nBAw01UcpOXRlaVgArIK5j
			B4b2iwUCZH+Ry3tOA3feNIJfDKwJ0A3t15GYl9bws70HmVfYkxs61F3AxJVXDOOaLkYYHIb7ye38
			sdhH8s3juX2ABYjBkbmeR4842O+AlIiW7lsREREREREREREROZ98fj9+v59AIEAwULMUUHMyAAaj
			AaPRiMlkwqysA9JKKEB2WlaiQwGPlyI/tDub393uiTzQxcFTe/ZzXVoOU4d15oYxSXSLNGJudPJb
			GbuyfEAEE/s3nL0WztCeFsjxcKAYqA+QhdK/S92kQCsWC0AYY1Ittdui6doOOOKnwgUoQCYiIiIi
			IiIiIiLSJni9Prw+L+kZ2eQePERBUTFVjiq8Pl+zXtdiNhMWHkb7+DgSu3SiR/cULGYLFovCE9Ky
			9Ao8rQ7077YX044S5u1x072vDWujiSkNmIxAIIgvSE1YnAD+hikQjR245nuxjE5P55PlhXy0LpN3
			NxTy6v2jGBXRWITMSE0wPYjHFwRr3TFBfP6ai5hPG7AzEWFt6T4UERERERERERERkZYQCATweDxs
			2raTHTt24/Z4MZtNmIwmLFYLVqvl7C9yCkHA7XKTfSCX9MxsVq/dwIABfRk2qD9WqxWjsdWtBCVt
			hAJkp2Vh1Oh2DEwr4D8fb6JX5GDGxFmwmWpiYH5/ECxmIqyRdIsHCirZWu5lSriBgKeEnUcaFOVy
			UhYwE9utF3d3684VS9cyY3EFn+2uYtSocDAYMAMerw+X1wdE0iPZQsjBapZuqWTw4FBCTODzVLM5
			04vZEk7/hJbuHxERERERERERERFpjfz+AHn5h1m+cg3FJWVYLRZSkjvTLSWZjh3aExYWisloJBCo
			SbRoMBgwGg2YTCZM5ygVotfrpbyikvzDR8jMzuHQoQI2btpGVlYOE8ePoXNCR0wmBcnk/FOArCm6
			DuDJi9dy51Inj72ykrCIMKZ2sWDFx8GDTqLGDuWP42Po18NKREkVz/93O2WjQqjaWsyblQ3KydrB
			95eYuGZYOLH42LbNTViIjYGdw2v2R4UyxFLOhvX7+V9oOHZrIrdNSOKmnTl88NVGSnM7MCMR0jce
			4e0iM8PHJnNxZEt3joiIiIiIiIiIiIi0NoFAgIzsHL5esJQg0LlzR0YOHUxSYmc8Xi8V5ZVs37GH
			vMOHqSivJBDwYw8JIS4+luQuXUhJ7oLFYj3r4JXFYiE+Lpb4uFgG9OvDgdw81m/eSn5+AZ99MZ9L
			pk2mR9dkzSST865VBcgMBgN+f6B27awz5/cHMBgM3+zkUzKSMH40cxL387/FBSws8LE4xwdGIz1i
			opjaJRww0mNabx6tTufFDAcvLXdy9Zhe/KV9Gr/aayHECMREMYACXlvswAPERsXws0t7cWOX2st0
			6sGvx1bwy61e3l5dwdXTrRDZnQd/YCbxs1zezyjiz/shzB7GrZclc9eIjvX1Cwmz0c5lwdKgzidu
			A4vdRruI2vqIiIiIiIiIiIiIyLdS3uEj9cGxAf1SmTxhLAAul5t1GzezeevOE86pqKziSGExu/fs
			p0OHeEYNGUJyShfM5nMXSkhK7ExSYmeWrljNjl1pfL1gKfYrZ5DYSenS5PwylJWVB891oYFAgF27
			9zJs2OAzOu+ddz9k2sVT6NwpAYPB0ORgVzAYJBgMknconwULl3DzTdedl84TERERERGRGi/861Xu
			nn17S1dDRC4w/37tf9z7g7tauhoi50GQgM+D2+PD5/MSCAIGE2aLBavVitlkpDmG/Uvb5fV6ee+j
			zyguKWPQgD71wTFHVRXzvl5Mbt7hJpc1YdwoBg/sh/kcpVxsaOmK1WzbsYe42GhunHUllm86e0a+
			tewhIaxctZZ+fXuf81mGrWoGWa+ePdi5aw+xsTGE2GxNznEaCARwud3s3LWHXj17tHQzRERE5Fso
			4HZQ4bUSGW7lm38c8+Esq8INmOwRRNg0pVtERC40ATzV1XgCZkLCQ1rXQ4UzbUPQTEjYKdrgc+Fw
			+TBaQwm16j1bRL6pIH5XFQ5HFYczV7F69X727dtNfjUYIjrTt98gho8aSd/EOMIjwgi1mRQok3Ni
			w+btFBaV0CmhQ31wzOv1Mv/rJWcUHANYsWod9hAb/fqknvN6Tp4wliMFRRzKP8KGzdsZO2pYS3ed
			tCGt6rPssGGDmff1IlatWkuf3qlER0c16byysnL27E3D5XYzedL4lm6GiIhI6+VzUuYynWWQp8Uq
			j7PMhTEynHMWVzqD/iha/jz3rx3JM7+ZQvtvdLEAbsc23nr4HTbbjHS79lc8ODH2vPagiMiFIOCp
			ptoTqPnBHEJ4SKv62iqUsOHNl1lenMq1D8/i3D8mO09tePdllpf05qqfXkvfkw1Uz/ySZz9KI37C
			97hnfPwZX8XncuDyHbfRaCU09OjnjqDPjcvjxV/7kjeaLNhCbJjqn44H8XvcuL0+AkEwGIyYbSHY
			zA0/uQTwuV24fQGCQTAYzVhsNqwmA+DD5XBRVw1zSDj6lRI5j4JeqssKSJv3Gi9/toUjjuravwsG
			rOHt6Bxbxq5Fb7P083cIiUpizA2zuXlSKh2iQzErSiZnwefzs33HLkxGI2NGHg04rd+0lQN5+d+o
			zJVrNtA1OYnQUPs5r++YkcP45PN5bN+xi5HDBmM2n/uZaiKNaXUfi2ZcMpVNm7aydPlKHFXVTTon
			PCyUrinJTKiNhIuIiMhJpH3KvXM6nEWQpyWl8+79n9Llb79k2pk/o2oF/VHC8qdf5tD1f+aFixQY
			ExE5mZL1b/LKilJsYSGYe8zkJ5edZZaQgBeX20PQZMd+wc4CCuJ3u3D7jFjDbK3vi3xr0qT7bSQ0
			LJpwoghtvoqw/8t/8sk+IyZzg7RpcRP47nfHEAfgd1O4dwlfLt9FscuAkSD22H5MvGwKvdvbMAF+
			ZyH71yxkydaDVAcNGCzRdB8/k+kDEwgxG4AAnsrD7Fj8JSsyyvAHg2DvwtBplzKuewxWYzaL/vMl
			GT4XVW4/qbMe4dpeLX2TRNqIoJfqg+t47S//ZLkjir7T76D/1n/xZRqAhfH3v8iD40KpXvV/3PJC
			kCsvN7D14z/zswUT+dmvv8vQhFAsCpLJN7QvPQOny01SlwSSEjsD4HJ72LJt5zcus7rayZbtOxk3
			esQ5r29SYmc6d+rAgYP57EvPoG9vvVnJ+dEqP1cPGzb4jNcvExERaWt8znIc7rqfTNgbzqzyOSlz
			eOqPtYVHYfGW46jygN9JRVk5VlsY0XYjbkclHksYVm8VTl9dOQHcjkqc9aOerYRH25v0weHk9Tqa
			XvDEMgO19YjAHqisP78+DaHPSZmjCjd+nBXllJkbnNtIW+3mo9cjPAKj62hb6vb7nI31RxNaeMz1
			ju+X4/rNbK+dnebDWVaJ0w/tw02UlTnq+yXgdlDh9NeXcEzqRZ+TMgeEh4PD4YG6OgY8VFY48Td2
			jojIt0IKF991Od3NtrMv6vAWPp63Bk/vW7lz7LkaYXG+Ochc8gGL93Zg8v0zL9BZW+dJk+53LENu
			vJchzVqRCkrKAXMc3QcnEVG3OTyBkNp/BrK+5s3Pd+CP682Y6f2ILd3FinWb+extL/YfXUE3o5N9
			8//HJ/ugfddBDE8O4+Ce9ez7+h3c1u9xXf8IjL7DrHrvddaXRdCl1xh6dawiY+sO1s/5EG6fzZRO
			KVx8191MTv+Cf36V0dJ3R6QNCeA+so6XHn2arZ2u5Xd/uZXeOS9yw3t1+82EmHw4qh0ETCGYSxZQ
			2m0OTz+3j7f/9Bf+72Ev9//1h4ztGHIBZv6Q1iDnwEEAenTvWr8tPSMLr9f3TYsEYN/+TMaOGo7B
			cO6jtz26d+XAwXxyDhxUgEzOm1YZIBMREZHT8bHzg9/z8uba8JI7jssefoDLk6wYAx4qN8/h529u
			qwlMBTyM/v4zjNr9BP9Y6gSXib89thTjuO/xwvXRLH/61ywd9EMm73+bj3OTuem39zExuoAlz/2N
			zw7XfB3zVffnrn/cwqjTBJB8znI2vfs7XttWmzrI25Frfv8zpsV6qKzYwYe/fo8NtWmMAu5BzP7z
			tQyLtmOmpLYev+L6qhd5eR3gdRIz/Rf89vIkbBlf88iLy3DiwvjME8wzjuOnz1xFqs9J2eZPeejt
			zTUfagIeht72R24fHo7NmM679z+N+95f033Fc3ycWxOMGjz779w90k7GF431x2lmKfidVOz8iqde
			X9dIGwK4HTksfO55vqzrt/aTeeiBS+hhz+bTx/7FgkoIvPEE2y01/TzWXk72klf529eHa7/4+uh4
			0Y95YHpyTcAr7VPu/T8PP70/jDdeXwfjvscLs5KozF7KP59ZSJ7x6Dm/uKwrTYnviYhcGMzYwsII
			q/sx4MXt9uLzBwhyYpq5oN+L2+PB7w/W7DdZsdutBFwOXEVZZB+pIjalGofDUbOelNFTs7aUxYbJ
			78YbqEs9d2w6OwCj2YrNZm2Q8u4Ugn48bjdef22qO4MRc0goFn9N2shj0tsFPFRXewg0SCMZ8Llx
			N0y3Zw7Bbg3grC7lYPZhSpxhuBwOHDRY/yvgw+32HNM3JqsNm6V2DZv6dbTs2IJuXN6a40xWOyFW
			Q83MtNptRosd+zda+yaA1+3G6/PX9JvBgNFsI8RmxhhwU13tJWC2ER7SIJdhXb1sYYRaDKdvRyP9
			dfx6aJzsfp8wk6yxddSC+D0uXF5/zb0zWQgJns1r2EvQC0T1ZdK0cTQWqisrLMALdBt9JeP6mTEE
			u+M9tJevMgsoqIRugY2s2uPG2OsKbps1ABswYlA7PnvpI3at3Exhv0m0y1zH2kKIHX09t07pCMCI
			HuG89soy1q7ex8Tr+mILM2PThwSR8ypQncmnf/0Hm7r9gKcenUZ7E5TlpHM0V1Y1X/31l5RN6sSh
			ZaupBlbvSuf+UX255Y9/o90fH+Cff/2UhCeup3uoQmRy5o4UFgHQuVPH+m2HDx8563LLyiuodFQR
			GRF+zutcV9e6uoucD/qEJCIickHKZq/9Xl54piagU7T0KX72nxWMfGwqHUtW8bcX8rn1qSe5KBYo
			WcXyQki9/kle6Psut8zpwB/qUwrWfPDM+mIZ0//yJC/UZf4ryaBs7CO8ULtGVto7P+b37w7nzdl9
			Tz6CMeBh21uP8mrlTfzpmdoHQWmrWG4EX/5C/vL7hQz4+VO8UDvsvWj5s/zy5x/w45fuYHDtJ5Ks
			L55l78+f4oWbgbSPuevJN1ky+hFmpF7FC8+k8tp3PqXLb+tSLAZwb/uAB96I4lfPP1kzmr5kFX/+
			1T9ZmPgrZibUlLn6tU/p+0RN24qW/4NfvDCHscNvZWCj/XG6bp/Lk/t/ysvPzKptwz/4xf0f8NN/
			38Fg8pn/9D/YM+m3R/vtvfv5w1uJ/OfuAdz0zK+Ie/zXHLz2SWb3q+mvTf95mBfKb+Wvdf1FOu/e
			9xR/Mf+axy/rWNvXa3k57We8WntNX95X/O3/Mpj6xJPUXCadt3/4f7yR9E9+MFgf7UTk28lTsJXF
			C7ewr9hBwO8naIqm+4TLmTE4AZvBS3nmGr5euYX8Uj8BjJhiBnH97ClULXyZz/d6ASjd9AGvbDMQ
			O+Y73Bm7hGc/SiN20ARSCrexryJA95k/4bJuFWStWsDKPXmUuv0EA35snYYz/dIJ9Ig+zd/YgJfq
			ogzWLVrG9sOV+DFgskTQ76rvMTjnTV5ZUXRservSDbz18jKKes/i4WtSwe/myPYFzF+3nxJXEAMG
			7F0v5taJ1cx5YyUFboBsFrzyMovpwRUPXEmPgIfK/B0sX7iOtBInhmCQoDmKLkOnMG1kN2Ksxvp1
			tOJG38gEz3IW7C7C6QnSfvAsrh4fSvaSr1iRXoLLEySq70xunNGP0zW1kRvEtkVfsyW9CIc/iD9o
			ILr7JGZOH0JC5VreenUVRcmX8MDNw+tnT7l2zOHZebl0ufRH3D7Qcvp2HN9fwPHroZlOdr9HH5/a
			+MR11PzOQvYu/4JFO4rwGm3Y2vdhRs8TR9k3uq5YnWPWF6uivAoI9VDtcODgxGBrbNdUOqwt5mDa
			NgpSUglzppGWbyakQyopUUBGEUVATHx7rHXXsPWgawLsSs8i1zEJS+1DxLiO7Y7WI6YHXSOXcfhA
			Frn0JaUZfidF5NQqV77GOwcH8YvHLqZ97VJK1vBozFC/JiCubFbPz679wUBsRO1cU1N7Lr7/Ptbf
			/X+8tWYGv50a1dLNkQuQo7IKgKjIyPptFZWV56TsSoejWQJkdXWtq7vI+aAhCCIiIhekHtw0K4nK
			snLKysoxJ/UmMbuQYgCjGaupPWHGcirdAYgdx8TT5GIyT7y0NthSK3YcN421U1ZbfofuI+DgEU41
			jitwZClz1kzggQcajJJOHcfE2AC7v/6U3Ik/4KYG9YifeCu3dl/Fxt2BBvVocEzqBG5KyeHg4cBJ
			rljEks9XMerOyXSorWeZsT8Xjcxh9fajNe1x/a31bYufOJ2J5HDomw5IM03ggQazzOInXsoU0yq2
			pEFg91Le9V/CrIGmo/024hISV25nd2NNKFrBnJXduHV2w1HlPbjpRxPIXb+Lgvpt3bh1Wt01a/rS
			d+nlDDTWtrmsHSMv7cLyLfs4WU+JiFzoHAfSKYnsy8RLZ3LZ9DGkWEvYPf8jlh0OQsUWPp6zkkxf
			V8ZMn8ll08fRw+ShGkgYPpPLhtaMmAjvMYnLZs5kUq+jD4pKdm7DP2Y2P/7xT7isG0ARmZkBOg2/
			mMtmzmTKwDicOWv4YN7uBimCG+c7soa33/iYjQUmOvWfxIyZMxjbPRSDnyYJZC/gnfnbKY8YzJSZ
			M7lsyhCigy68ET2ZNHMSPSMAEhgycyaXzRxJAuA7vIr33lzAnspIeo+bwWXTJ9E71smBle/z0crD
			NIzjOHYuYJNxENOnDKWzPcjhzZ/w0bufs9GfysXTxtAzEkp2fMrcnadraSOqckkviaLPxJlcNnMG
			o1OslOyez5wVhwm260tqnBGy97HLWXeCi7S92RisPRnZL+yM2nEqp7vfJ+cla8H/+GxLMcaO/Zg4
			/WJGxRUwb1XWCUdmL36V//znJP99tJWyBmX6/BZszi18+K8XeOHFF3jt41VklXmOvl+3H8nlU5IJ
			Zi7irVdf5pW3FpEVTOaiK0bS3ghExBFthJJD2ZQ6XbjcLlyOLPIKADy4PRAZE4fZAEeys6h21Rzj
			LM0mvwJwu077uhWR5hE1/lauapfG2s35VHtrpqOG9h3FwJDGH8Uabe2ZMLBmnaigt5r8bRvJancV
			141RcEy+Ga+v5t3TbDk6ezt4VjOjjzKco3KOV1fXurqLnA8aZiwiInIBCrgdVOSt5vm6NHsBDw5G
			1+yM7ceE/p/zxmNb6XjRj/nJxHbHrk/WiK4djh1Z7XOW49gx92jqQq8TOiaesk5FO7eQ1X007U7Y
			U8KRg9Bj3PHJhWLp0AWWHSk5aT0Aco+UQKOJiUrIz4Z1bzzBdkvD7VEQVVH/U+IJZeaQXwhNmzJ2
			nJR2xB3XhoQUOAgUHTkIuRtq0jU2PCQ6mbIy4PhqFBaSZUoi4fjt7drRNfsIxUBNgokuHG1CTV/m
			rn+eRxYfe0Ojk0s5WU+JiFzoYofdyA1+D36/H3+gMx2rD5C2MJv8PAfEF1EMhCb0IjUlEZvFSs8+
			5pq/xR1TSa3YCevA1i6F1F61fyVrB0oYu0/ikl5hDa7UnYtvT8Qb8OP3Bwh2nsiRve+z5VAu+Qw8
			xUwcN7uXraTQH0H/K27nim61a6f16ldzuYOnb6OjuASfAdp17UuvLpGYLT3pNdCIwQixvQLkLYU9
			hNGlV2rtGmRuti9fQyHxjLvuNibWZlBK7dMO03Nvs3nDKvZPvJ4+teV724/j+mk1afq6m4r4vy8y
			KPIP566rxtMO6Gsr5K8f7CH/UD4MTjl9hRuKGs4NN3rw+P34/UG6tB9BbtoisvMP4WA4w0Z0Yu3c
			bPbtcTFsaAg4d7I720DY0KGkWs6sHacSdrL7fTqu7WzY5cYYN57rbplIRyPQrx+JIf/itbUlxxya
			MvVu7pp0knKMtqNpQYmm6+AxJCW3g4JscrPTSc9dwwcfGfjO7MkkmGoCnJ/Mz4KOQ5gyJoXQ6mzW
			LNnCV5+sot0dU+jUsT/DkjaxPHcJb76XTZdoM97ig+RVAxgwGMDccyiDYrPZvn0O/yvrTju7n6rD
			uRwBMBi+QbpMETknQvvynd/dwWM/f4R/8wTfGdWe8HZTuOWaj0n/LB+n04M3EMRgtGC120mY+RDX
			pAbwVjsoWPc6j75azC1//wl9Q1u6IXKhsloseLxe3G4PIbaaecgR52DWl8FgICy8eV6Ybrenvu4i
			54sCZCIiIhecAPmL/smjX0Yx+/HaNHtFS/jdg3X5xGOZ+MCTTCSdd+9/kV/NjeOyR3/OlZ2b+rbv
			Y+dbD/Ps9uk89M/a1IW73uWWOac+y2gyQftYok/cQ82u40dwB/D7wWQywjea+1RT7rjv/4W7BzYW
			/dvbbHfg2DaYMBlr2594BY89NpWOTTnVaMScGE1kgGPn9AcC+EzGk0zzr2lz4tUP8cT0bxLhExG5
			EPlxFR9g+9atHCgooLjag9tRs4qLx+2G5KGMTkhn0/4veDUzii79RzJ+eCrtI0IwnyY6ENsh4Zgv
			xQFPJYf3bmTb/kMcKXbg9FZTVQ0ETjcTJ5/cQ0B4X4bVBcfOUGTfUfTeVkrmuv/yr23x9B42meH9
			O9MuzHqS94SDZOcAUan0bfjGY0whJRE27y2lpLxBWzsnUFczs62m1eHdex4d2BLTnlj2UOQ+8zlH
			fnchB7ZvZtuBIxwpdeN1V9ass+Ny4wbi+42i56I89qbtxDV0OOzZR7YhnOGpKUDGGbWjWRw8SDYQ
			3advTXCsVsfO7YBjA2QEgycfgR8McPRtvR0Dp9X2bq9UhoyfzM6PnubzfdvYlT+ZhC4e9qxYQ2Gw
			M5fMms6QcIBUugQO89z8NazYO44bB8Yy4tqbYf48NuQeIa/KTGzqJYyL/JjFGXZCbYAlhUtumolp
			7lLSCvLIM4WRPGwq7bZ8xRZPGHq2LtKCOkzjod8U8MQTD/HYrrv5/k2D6TLrT/yh83t88OEadpd7
			sUT1Zcx1N3DDyI64i/ax/t2X+Pd6O5f95lGmdWjpBsiFLDIqgqKiEkpLy0joWPPdMaFDe3bt2XdW
			5UaE2Y9J23gulZaW1ddd5HxRgExEROSCU0ba1hxG3fN8berAAO5q59H0Qz4nTuzYzT246ZknmTz/
			T/xsUTpX3tG7Zr8/cJpwVCbb13Th2j9eUTtC3YezynPaWsV37o79rS1surUPo+oWgvd5cBtj6dzd
			zusbt3Fn/2HU7Qq4D5J90E6PsbFAU3Me+vHXVz6elN5W5mcfxN0/qX6GXMDtxGuxn3LG3LFFnq4/
			Gh7rpNodoK5wnzOX7EOp9O0A8cbu2HPzyHH66FjXSHw4nWC3N/KRq0Nn+hxaxqaDk0lIqnv46cOZ
			nceh3t0bmYkHUNOXubm5OH3tOXqZunve1IaIiFxAXPv56u057LcmM3rsZAbExtKpeBHPzcus2W/s
			yPjb7qVv9hbWrtnA/i1zeWP7Xq64+wb6h5/J/JkABWvf5Y1VpbQfOIUxk9sR2x52vvM2G8pOd64P
			nw8IoSalounYvUZjzV95v7/BzkCAY+Is4alcObsLh9M2sGL9LvYtf5ftO8bwnTsnk9DoQOqaQRME
			fPiOGWzhx+8HDCaMp3kvtNmsnD03++f/j4/TrCSPGsfkQe2JTShk8XNzyaw7xJLKkP5hpG3ex67q
			fgTTsjHGja+dqNbUdtQOHvH7OdqLAQLnJM1TACNg9PsJQv2sK7/vxPyY2Ytf5av0kxQTM4bbbh9J
			bKM7LcTHRQNlOFwAFVSUAxFdSGgwiTG0YxfCyaOiogKIB1tHRlz5HUbU7g/6svn6RTDGJtG57rzI
			VKbemMrUutZUb+C9xQbMfVKaNmhHRJpNaOqtPPFMP95+6hn+8LM3SBpxJZPGjOfOX11ef0xZ4U6W
			vv4fPlt/AJJn8otnbmVQ7FlcVISaYFhRUQm5eYfqA2QpKYmYzWZ8Z5HCsFfP7s1W59y8Q/V1Fzlf
			9BhFRETkghNL515h/G/DNm5M6Q5UsPG9r8mtS7G4/3PeqriEWbVreeUcKSImtPYt32wj9OBBcsrK
			sFnDiWl0WHE8Kf0KWLQhm7ETY4FcvvzvRuhw6hSLpE7izgF/5pV3t9HrmtoPzWmb2NJzKhdNu4GB
			j/2PtzZ1r69X0aoPmRtxA4+fZn20o8yE2A+SnVVGqdVGRHQsE6+8mHeeeYd5/b9fv85Y0dpF5I+c
			deyaaict8vj+OM1Ho4Nf8+7y/nx/RM2IuX0f/49tl/yIH8QCsZO4c8Af+deb/eh1fd2Xhmw+/zqc
			O27ocWJZseO49pLP+PubC+lz79ja1IgZfPLfXcz48R0nTZWYOu0GBv72Dd7Y1J0b6/ou42vmhd/A
			zU3uSxGRC0jubvY5IWbQFMb0b4/B7+VIRoMpRW4H5X4LEUlDuCRpEMNXvcGrqzPZuq+a/kPDwGDE
			AAS8btxeD2Cm8TlepWSmFQLdGXnxYHqZgvhceylt0nr2CXRNtrAncw/bskYTlWjBagK/10fQEkps
			XDxGCsjPzsbVPQkTfpz5h3A0KCFQXYHLGEJc6niu6TWS/V++yCd7trLt0GQSkmtSLYIPt8uD1wAG
			W3sSEy3syNzPzoNjiO5owWwI4nMfICsfTBHJdIoCCpv7BuWwZ68boocxeexA2hv8eAvSOX7SV0qf
			PoRv3UDa+rW4s40kzBhWOxikie0ghngTFOTnkO3qQZIJ/NX55Fcdd6HG7rflNJHCdp3pZNrDwYw0
			CkdGE2M1EvR5SE/PO+HQJqdY9Lhw+IJYzGaM+PG6C9i5twSDuROd4gCsWELNGHIzySgYS1ysBWPA
			S2lmJhUGM4m1wUufuxpv0ITZZCDg8+HYs45d1VY6jepf238BvE4XfqMZkzGI3+ujYM0mcsxRDBzY
			XQ99RFqD2MHc8sfXuf7IbpYt+JKlr33Om+Xe+t3WqGT6jJnK/X8ax6BEzfuUc6NrShI7d6eRnpHF
			sMEDMJlMRISHM3hAHzZv3UngGyxIZrVaGNC/KUmPz5zf7yc9IwuDwUDXlKSW7j5pQ/RZSURE5AKU
			et29zLj/FR7dBZDEjT+8gYF5hTVv7B26UPbSn3m07uDx9/L8dbUBmtRJ3NH/r/z3sd0w/h6evy4W
			W0Q0EcdMt4pl4nduYP0fXuLRxQBj+cmPp7Jmro1TP16KZeL9D8Mzf+XRx+q2jeUnz9T8/4OPwd/+
			0KBeKVfx+P11gSFjI/U4flsPpt3cj9+982d2MJafPHMVqalX8fjNB/ndP//M1/XtvYfnYwHMhEZH
			H/dp57htJ/RHI4GsutrYwonpfwPX2D7n0ccO1LbhBh6fXXdOLBPvv5f8+vtSe29+e98x7WkYg0u9
			7q/8/MNf8sxjy+q3TfzxX48Gvsx2Yo5vQuxYHvxxIfe9+Gd2NOjL399/9q8rEZFWyRZFtNVE6Y4V
			rIrqQXhJOnszXUf3H1jCm6sNDByQQChV5OwpwRISQ2LdtJyIeOIsRoq2LWJJaCImy0CmNboERwjh
			0SGYS3JYt2gTno4+juzczREr4DxdJcMYOGYYa/O3sOPjVzncZzADOhko3JcGI+9mRudkEkP2k7t9
			Lp/ZhpNiPMSOHbl4G5RQunUOcw4lM7BbJGZvIXty/djCUugUDxBJdDsb5qIMVsxdi8tqJH7meAaO
			GcGGI5vY8sH/KBkyiO5hTjK2beKAL5KeF48huamzqc9KKJHRVkwV21i5MoLu4SVkpGXiOv6wpMEM
			it3EynVrwJzIjJ51oaSwJrYjkaSkEPbnbGHepyEMTzFyaNc2co+f5NXY/R4ad+omRPVjULfVFGSt
			4q13Khg+pB2B7B1kldpPuPlmWxjmpmTRzFnAS0sq6d2jG/HksWd3FoUeOzH9JzAopuaeDhrbjy2f
			7WHt+x9QNbIfMWW7WL+jHHtcP8YMrBmMc2DZO6yv7kTnhBAqMvezN8+BJXkSM4fXjQSqYPsXH5Np
			TyEp2kVOejo5JT5i+l/J1G565CPSmlg69OXi2/py8W0tXRNpC7p3TSYyIpwjBUWkZ2ST2qtmEOfI
			4UM5cPAQhUUlBM8gSGaxmBk7egTRUVHNUt/0jGyOFBQRFRlB967JLd190oYYysrKz0lCgoYCgQC7
			du9l2LDBLd0+EREROYcCbgflzkbSMZjsREWcLoDW2vmoLnM0usaMLfzYwJaIiJzohX+9yt2zbz/r
			copWvswrK+K49uFZtal+3Rxe9Rmfbc/H7TMTljKeq1NzeWt+BrGjbuPWlBw+nLuG/Iqa9ydzZAJ9
			x0xnUq+69THc5Cz9gK92leDDTMrkO7nCvpRnv6w9f2SDKceVu/hqzjIyKnxgiWXgpRcTuuJ91pZ2
			57Ifz+R0SYXc+VtYtGIDOUdc+DBji+nC6JlXMjAGKvYt5vPFOynxgjm2PxeNs7Px8w2U9JjJjy/t
			TlX2Yj5fuJdCpw8wY+uQzIgJFzMkoTYaU7Kdzz9dSbbDhzl8KNfMHk/HE67ZSPszvzyxrY1tK93A
			W2+uqa/PyZWw4c03j+kTd/5KPv9yO/lOH+bwFMZdlcrBt+aTETOGW28bUZ9y0LHhVZ5dWIClz7Xc
			f3XqMQNATtsOgMo0Fn+2iF0lNfen30UTCF3/KRuOuT+N3O9+YadtA+7DbPj6SzZmV+EzmontPZUr
			EtN5Y34jr5OmKFjDu19sobCq9nVpb0fy8AlMGtiFsAYfmKoObmDxog1kV/jAaCaqw0AmXTqe5Noq
			H171Jl/tKKHKC1iiSOg9mkvGpxJZ33lV7P7iXVbmVuH2nfw67PuIP3+URuqsR7i21xn/Wjarf7/2
			P+79wV0tXQ0RkW+drTt2s2zFGqKjI7lp1lX1qZULCgqZt2AJZRWO2vTPp2a1Whk6sB9jRg9vlnq6
			3R7e/ehTysoqmDRhDIMH9G3prpNWxh4SwspVa+nXt3d96vJzRQEyERERabKi5c/zuzkHTtyRchW/
			r58NdqFK5737X2F5I3sm/rDBrC4REWnUuQ6QXfOra0nFgOFMlhFrTgEP1dWeRtetNFpDCbVe2MNE
			jm1qNdWeRluKNTSUb9bUAKWrX+Vfy50Mu+knXJLS0q1sO4LBIOybw1/mKEAmItLWfPTpl+TmHqJn
			j65cPGVifZCsvKKS1Ws3kJ1zEJ/Phz/gp+GEMqPRiMlkwmqzMGbEMAb0690s9XO7PSxcspz96Vkk
			JnZi1lUzW7rLpBVqzgCZxkKLiIhIk8VPvI/nJ7Z0LZpLD2585q/c2NLVEBERwEV5QQEFIVF0iApp
			6crUKN/Gx2+uoaSRXd9ohlErVrZ1Dm+ta7SljL7tNkbEnElpfrxuPwH/EbZuL8IcPZK+WlrkPHJR
			XlCOu8x19kWJiMgFZ9KEsXzy2Vz2p2cBcNGk8VitFqIiI7j0kovIyjnA/owsDh06jNtTk/zZgIHY
			2GiSkzrTt3cqYaH2c14vv9+Px+Nl8bKV7E/PIjw8jEkTxrZ0d0kbpACZiIiIiIiItBpGayjh4cWs
			f/891p823d95FDOCW388oqVrcV7EjryNH488V6Xls2XJfgoP72B3dQz9Lh9Pl2/PZLsLQB6r3/+S
			DCA8PJwQPQUSEWlT4mNjuHT6VOZ9vZj0zByKSkoZOXQwKSmJmE0mkhO7kJKUiMFgwOl04fP7sIeE
			YDaf2zeMYDBIMBjE7/fj8/vJzs5l/eatlJVVEBERzoxLLiI+9oxG4IicE/poJCIiIiIiIq3GuQ3O
			SMtzU7R/B5nmMHpPvYbLetlaukJtTHcu+/FPWroSIiLSgjondOCqK2awYtVaDuUfYf6iZbRvF0e3
			lCQSOnYgMioCq9kCgNFgxO324HZ7zmkdPD4vFeWV5B8+Qmb2AQoKi7FYzCQldmLCuNEKjkmLUYBM
			RERERERERJqJAjQiIiItLT42hmuuuJStO3azY+duyssr2bB5O4FAgGAgQPDsL3FKBsBgNGI0GjGb
			TMTFRjOgf18GD+jb0l0jbZwCZCIiIiIiIiIiIiIi33KDB9QEpTKycsg9eIjComIcjiq8Pl+zXtdi
			NhMeHka7+DgSu3Sie9fklu4KEUABMhERERERERERERGRNqN712QFqUQALY0rIiIiIiIiIiIiIiIi
			bYoCZCIiIiIiInLWDAZDS1dBRC4wgUBAfztERESkxShAJiIiIiIiImctOioSj8fT0tUQkQtISUkp
			0VGRLV0NERERaaMUIBMREREREZGzltqrJ5nZ2fiaeZF3EbnwBQIBPB4Pe9L2k9qrZ0tXR0RERNoo
			c0tXQERERERERC58Q4cOYt78RZiMJhI6dsRgVNo0EWmco9JBelY2Xq+XoUMHtXR1REREpI1SgExE
			RERERETOiRnTp7J58zaWLFuBo6qqpasjIq1UeFgYXVOSGTppfEtXRURERNowBchERERERETknBk6
			dJBmhIiIiIiISKunNchERERERERERERERESkTVGATERERERERERERERERNoUBchERERERERERERE
			RESkTVGATERERERERERERERERNoUBchERERERERERERERESkTVGATERERERERERERERERNoUBchE
			RERERERERERERESkTVGATERERERERERERERERNoUBchERERERERERERERESkTVGATERERERERERE
			RERERNoUBchERERERERERERERESkTVGATERERERERERERERERNoUc3MWbjAYWrp9IiIiIiIiIiIi
			IiIiIsdo1gBZiM3W0u0TEREREREREREREREROYZSLIqIiIiIiIiIiIiIiEibogCZiIiIiIiIiIiI
			iIiItCkKkImIiIiIiIiIiIiIiEibogCZiIiIiIiIiIiIiIiItCkKkImIiIiIiIiIiIiIiEibogCZ
			iIiIiIiIiIiIiIiItCkKkImIiIiIiIiIiIiIiEibogCZiIiIiIiIiIiIiIiItCkKkImIiIiIiIiI
			iIiIiEibogCZiIiIiIiIiIiIiIiItCkKkImIiIiIiIiIiIiIiEibYm7pCjTG7fbg83kJBIJNOt5o
			NGA2W7DZrC1ddREREREREREREREREWnlWl2ArLraycZNW8g5kEtVVTUYTnNCEMLCQklOSmT4sCGE
			htpbugknCLhcHHEFCQuzE2lp6dqIiIiIiIg0H7fbg9fnJdjEAY8i0vYYjAYsGugsIiIiLaxVBcjc
			bg9fzv2a2NgYJk0YS1hYKAbDqSNkwWCQqqpq9mdk8eXcr7ny8kub9QOW3+miwB0Eg5H4KBtNiXcV
			L1/G+Hlu7p59JQ8POM+dKiIiIiIicp5UVzvZvGUb2dm5OKqrWro6ItJKhdrtpCS33oHOIiIi0ja0
			qgDZqjXriI2NZvjQQZjNZgwGQ5MCZCEhIURFRbJx81ZWrVnHRZMnNFMN/WTNXcz0lT4MIbG8+9tx
			DA853RQ3ERERERGRbz+328NX8xbQs2c3Lrv0YkwmU0tXSURaqYqKSvbtT+eLr+Zx1RUzNZNMRERE
			WoSxpSvQ0P70THr36onNZsNqtZ7Rfzabjd69erI/PbP5Kug9xMKdPsLCzES7Snh/SzVKGiIiIiIi
			IgKrVq+jZ89upCQlKTgmIqcUGRnB8GFDiImJYdXqdS1dHREREWmjWlWAzOFwEB0dhdlsxmQyYTKZ
			MBqNp/yv7jiz2Ux0dBQOh6PZ6ufZncNbZQZuuqwrsyzw+bZsKgLHH+XHXeXiSJmT/DInxVVe/Mcf
			EvTjrHJRWHvMkXIX1f6m1UFERERERKQ12p+eSWLnzi1dDRG5gDT7QGcRERGRU2hVKRYBTCZTfWrF
			06VXbMhgMDTvKMWgh40bSjhkjmDMgO7Y0tL59/ZDzC/uww3t6uKMAVxlB/nqwz38bb8ft81En66d
			mB3TcJ5ZAFdxNh98ksmHB7wcDoDdYuEH35nGzckt0uUiIiIiIiJnzVHl0MwxETkjkZEROKqab6Cz
			iIiIyKm0ugAZ8I2CY2dy/DcRcOzn471g79GBEeFWrIMisW8vZ96WUmZdEocJwFfKl69t45eHzYxP
			7cStI+0UrT/EH9d6GpRUzsL/7eL3+TZ+PLMHE+Igf3ce+c4W6WoREREREREREREREZE2p9UFyM4m
			0NV8QbIAxWsPMSdg4PrBiYQD9GzHFeZy3l+bTtZFcfQwQyAnnVdyIWZQD16+sxdWgP7JJL22kDt2
			1M0iqyC3yIAhNIKh/RPpFmJiQN8eaDlaEREREREREREREWluXp8Pv8+H3x8gEAxA8OzLPCUDGA1G
			TCYjJrMZi7nVhSWkjdIrsSn8pSzc5gTs9Ekwc6jUCcQzMCGd93OLWZDpo0cvM8XZZewH7h7YMOBl
			p1dnK+xw1/6cyKVTMvlgZTkPPLWYIV3bc+NFvRmVGE6ksXlnwYmIiIiIiIiIiIhI2+T2ePB4vOxP
			z+RA7kEKioqprKzC5/M163XNZjMREWG0j48jKbELPXt0w2q1YLNq2oi0LAXImsB3IJ13DoHZ5Obp
			FxfxdP0eI1Z8vL02m7t69cCIAQPgCgaAo+uSub0NQ/AGUi6exLyBuXy9PJtXdhdy/3NHuPqWiTw+
			PLL+LBERERERERERERGRs+UPBHA5XWzcso1tO3bj8XixWMyYTCbs9pDap9rNJ0gQj8dLTm4e6Zk5
			rFyznkED+jJ8yCBC7CGYjHoqLi1DAbLT8rF3YzG7MDCkZzzTO1ga7HOzenURy7fnsdHVnbGJ4cQZ
			XCzemcmPU1OIsBjwuktZkeZtcI6LymIDhqhOTLuyE1NHb+dHT+Xx4fpcHh7eryZ9o4iIiIiIiIiI
			iIjIWfL5/BzIy2Pp8tUUF5cSYrPRvVsy3bqm0DmhPVFRUc2e8tDr81FeXk5efgGZWdkcPJjP+o1b
			ycjKYfLEsSR17ozZbGrprpI2SAGy0wi6svhiiw+DJYLv3TSaSyIb7vUwrPJrVm0u5+NNVYwek8h9
			Hcp5asde7nKVc2dfC4Vbi9jgMwN1QbI8Xnsui8CoBHqEQUlmAVtsFoalxCg4JiIiIiIiIiIiIiLn
			hD8QYF9GJnPnL8ZgMJCU1JnRw4eSnNQFgGAwiNfrpdrpJBCoWYvMYDRgMpowm02Yz1HgzGI2Ex8X
			R3xcHIP69yHnwEHWbtxMXt5hPv50LpdOv4jUnt01k0zOOwXITsO7r5gFdjvJvZKYHHn8XitDRycw
			JKuEtXsOUD2uL3d8zwvvZfHGkTKeLrJw7fi+PMp+0pZ5iLQARNIn2cJzG/P5KAhWq52rJyRx34xO
			Ld1UEREREREREREREfmWOJh3qD44NnhAXy6aPL5+n9vtobSsnP0ZmeTlH6aivAKf30+o3U58fBwp
			SV3ompJEiM2GyXRuZ3clJ3UhOakLi5euZOuO3cydv5iwUDvJiV1ausukjWlVATKj0Yjf78disXyj
			8/1+P8ZzHGW2DhzNooGnOKDHMN77TYOfo7txx/e7cccxB3VixcS6f7dn2nfaM+2c956IiIiIiIiI
			iIiICLg9HhYtXUkgEGDY4AH1wbEg4Kx2snrdRjZt2X7CeZWVVRwpKGLX7jQ6dmzHqGHD6NYtCes3
			fGZ/KnV12rR1B4uWruTWG6/FZrW2dNdJG9Kq5izGREdRVFwC1EzvbKq6Y4uKS4iJjmrpZoiIiHxL
			eHEUFePwnn1JTb6io5gyV6ClGy4iIiInFcDtqKCioprz+BHh3LehqrYNp3r04KumoqICh1ufTUTk
			XAji9zqpqqygrKSY4uJiikvKqHA48fgCNP1JqEjTrNuwmcLCYjp16njMzLHKyko++WJeo8Gx4x0+
			XMinX85jy9YdeH2+ZqnnRZPH06lTRwoLi1m3YXNLd5u0Ma1qBlnfPr3ZtXsvsbEx2ENCmjx1MxAI
			4HS52LV7L3379G7pZoiIiHxL7OftH/0Vfv0G3xtwfq64972f8Vbnv/GXGe1auvEiItJCAm7H0YCE
			xU6k/dyPVpazUcLGt19meXEq1z48i9SWrs43bMOm915mWUlvrvrptfQ92Usscy7Pf5RG/ITvcc/4
			+DO+itdZgfP4KKLRRni4rX60ctDnotrlwV/7kjearISEhmA21J0QxOd24nL7CAAYjFhCQrFbGo53
			DuB1VuPy1j5gN5qx2e3YTAbAS3WFk7pHmubQSEJb1ZMgkbYgiK+6gvKKSvIzVrJy5T727dtFXrUB
			Y2QX+vYdxMgxo+iXFE9kVCQRdjOGs7+otHFer4+t23dhMpkYP3pE/Xa3x8OXcxeSe/DQGZW3dMUa
			QkJCGNi/DwbDuX+Fjh89gg8+/oKt23cxZuRwLBa9Wcn50apeaSNHDOXzL+exZu0GUnt2JyqqabPB
			ysvLSdufgc/nY+SIoS3dDBEREREREfmGSja8zSsryrBH2DH3uIwfzeh+dgX6PVS73ATNYYTZWlUS
			lTMQxOeqxuU1Youwo5DhKTTpfhsJjYgl0hhDWLM9hQ6Q/tVzfLLPiNliOvqwO24Cs2ePJg7A5+TI
			7qXMXbmbEo8RUzCALaYv42dMpk9HO2bAV3WEfWsXsWz7IZxBA5gj6TZuJpcM6kSo2QAEcJcfYseS
			uazMKicQDBK0dWLIxTMY1zMOm/EAy/77FRk+J5VOH6mzHuHaXi19k0TakIAHR/Ehds39D//6dCsF
			lZVUewEMhEQlkNS+kr1L3mbJZ+8QGpPEmBtmc+uUfnSOD8eiKJmchb379uN0ukhJrlnrq86a9Zs4
			cIbBsTrLV6+jR7dkwsLCznl9k5O6kNglgeycg+zdt58B/fq0WN9J29KqAmQAV8ycwfoNm1m1Zj2V
			jqomnRMRHkb3bl2ZNnVyS1dfRESk+QVclJX4CYsPq39A5nUUU+YPIzYqBNMxx9jxlZfitsUQ5iul
			zFV7Qkgk7cKb+ngtgLO8tD7Voj0qjoan1qRFrPsphOjj61W/z0x4bBR240nODYls6Z4VEZFWI5mL
			Zl9Od7Pt7Is6vIVP5q3F2+dW7hx75rOAWgcHmUs+YElaBybfP/MCnbV1njTpfscy+PofMLhZK1JB
			STlgjqf7kCQi6jaHJRBS+89A9kLe/nIHgfi+jJncl9iy3axcs4Uv3vUR9qMr6GasZt/Xb/FpupGO
			3QYxIimMvL3r2b/gXdzWe7h+QCRGXz6r3v8vGyqiSEodQ88OVWRs28GGTz6C22ZzUedkLpr9XSam
			f8E/v8po6bsj0rYEPVTmrOSVP/2TldWx9Jt5JwM2PMfnewGsTPjZyzwyMYyq5X9i1j/9XH21hW2f
			/pX7F4znwUfvYWRSBFYFyeQbyso+AECvHkcHGjndbjZvPX1axZOprqpm45btTBo/plnq3KtHd7Jz
			DpKVfUABMjlvWl2ADGpmkmkmmIiIyEmUrufp+9O44rV7GG4BCLDrrZ/x++xbeP7P0+kEULCMxx8s
			5q43p5HztwdZOPhRbq5+kZfXAfhxDriZp24d1qQgmbMih6UvPcvHB8DvLGfgd//JveNqgmBeRzHr
			3nuM/26pKcfvHMDsp25mTFQIJrxse+8xXq7fF8OMX/+Ca7vVBPG8jmLWvfUbXttRG9QbdQd3uE5b
			HRERaRPM2MLCqB+fHPDgcnrw1OWhOy7NXNDvwely4/PXrOBiMNkIDbMRcFbgLMwip6CK2BQHFRVW
			jLZwwk0uKqp9GK0hmH0uPIG61HM16ezcHh+1RWE027DbbZia8pAy6MPtdB1dS8ZgxBoajtVXkzby
			mPR2ATcOh5tAgzSSAa8Lp7tBuj2LnTBbgCpHMQdzDlPiDKW6ooIKzNgjQ2sGpAS8uJzuY/rGbLNj
			t9bOWvJV17TVFkZI0Em1p+Y4kzWM0BADPmc1Tm/NNqM1lLCQb5DaKxjA43bi8fhr0gBiwGQJwW63
			YPS7cFR5CJhDiAy1Hj3HW02F04cpJIIwq+H07Wikv2rWQ3PgDtT0Bye73yfMJDv2vJrSambpOT1+
			goDBZCX0rBYE8hLwAlF9mDh1HI2F6sqKCvECXUfOZGxfC4ZgV9wHdzM3q5DCSugW2MiqvW6Mva7g
			llkDsAHDB7bj85c/ZOeqLRT0n0T7jHWsK4K4MbO4eXJHAIZ3D+f1V5aybvU+Jl7fD1uYGZu9VT7+
			EfkW8+PMW8XzjzzD9qTrefyp2+mT9U+u/F/dfjM2g5vySh9+gw1z8XyKu33Js//ax//++ARP/srD
			A//3UyZ2sdO0BWhEjnW4oAiALp0T6rft35+B13N264il7UtnwtjRGI3nPnpbV9e6uoucD/qEJCIi
			cqGJ68e4nq+yavt3GD7MAoF8sg+GYM89wCEvdLKAN+8Aub1TaQ/kAJmf/5N9v3qWl28HKGbpnx/h
			e2+E8P59g0+bpmnVfz5h0JNP8XIcFC39Oz959m3GjbyH4SYXm954hH/HP8jrz/UEavf/ZRHJT8wk
			0ZjNvvCf8HLdvsVPcu8ryxj35+l0CrjY9MZDvFQ1m6efG1/z0GjvHL7zF+h4lpm0RETk28dzZCuL
			F20jvcRBIOAnYIik2/iZzBjcmRCDh9L0NSxYvY0j5X4CGDFFDeS62VOoWvwqX+z1AFC6eQ7/2WEg
			bsyd3B6zhOc/SiN24HhSineSXhmg+6U/Yka3CrJWLWBV2iHK3H6CAR/WjsOYdukEesWc5h0z4KGq
			IJ11i1ewo8BBECNGSxh9r/weg3Pe5pUVRcemtyvdyDsvL6Oo9yweviYVfE7yty9kwfoMSt1BDAYD
			IclTuXWSk0/eWMkRN0AOi//zKsvoyeX3X06PgJvyvB2sWLSe/WVuDAQIGiPpNGQSF4/sQZzNWL+O
			Vtyo6xnnWcWStCKqXAHaD7qGK8eFkr10PqszS3C5A0T2uZQbZgzgdE1t5AaxbdECtmYWU+UHfyBI
			ZLeJzJw+hE5V63nn1ZUUJU7j/ptHYK99nubc8THPz88j8bL7uG2A+fTtOL6/gOPXQzOd7H6Pij2u
			wieuo+arPsKe5V+xZFcxPpMNW3wq03p4T2hqo+uK1TlmfbEqKqqAUDeOigqsnBhsjU1JJcFeTF7a
			Ng4n9yLMuY+0fAuhHVNJjgIyiikGYuLbUx9atHUnuQPszMjioGMS1uISAGLaN1i/NaY7yRFLyc/N
			5iD9SGmOX0oROaWAI50P//Q0m3vex3O/m057E5Rm7+dorqwqvvjTg5RO7sShpauoAlbv3A9j+3H7
			n56h/e9/xNN/+pBOT95KaviFmh5YWlJlpQOA6OijSxjlHTp81uWWllVQUVlJdNS5zwBTV9e6uouc
			DwqQiYiIXHDiSOoWwosb9/KjYQMgfytrbRdzae95rN91F8MHw66Na+kz9lria8dxWybfxy29j54/
			+apJvPCHHey9bzADTnO1XjfdweS4mn/HT76Uyf/6K5v33sPwdsv4YMVw7n4ulsKi4poD+o9j1L/m
			sq1gJokde3LL9S7KiorxAnRJJTGrgGKgU8EyPljRg9ufH390RHXva/n5hE95q6W7V0REWh3HwSzK
			o/sycVQ7Qr2F7F6xij1ff0xown1cErqVTz9ZxZG4AUy9JJUoKsjcXIITSBg2k8tC1/LR2oOE95zE
			Jf0isMVFQu3A5JLdO0m6+k7u61k3V62Y7APQefjFjI02U31gFYs2ruWj+XH87KZBnCrhozd/DW+/
			vZpyWwe6DphE36RQqjK2UulvWhsD2Qt57+sdmJPGMmVkJ0Kr89mS5cYb0YOJM01s/Xo+uysSGDJz
			NF2IJAHwHlrF+2+vpyIiiX7jBtMtrJrMrWvZtepD5nju5DtTO9cPhHHsWsy2viO5ZHIZG5dvIGfL
			Z8zJi8TYri8XT4N9K1eze+fnzEvsxc2DzzC1ZXUemeUx9J04mnahPgp3LWX1nq/5OKwT907rS++4
			NazM2ccu5wiGhwJBJ2lpORhsfRjZLwzvocVNbsepnPR+n07QQ9aCt/hib5CoxP6MHZwMB7aycM2B
			Ew49sOwN5qafpJyY0dxy6whqwnFe/AErIa5tfPzKJnyBIKGdhzNt+jh6xNUG0doPZ8akXN78egnv
			vr4CQ9CH25DIJZcOp70RiIgnxgQleZkUV0UQZjQQ9OaSVwDgwe2ByJg4LIYCCrIzcKQkYjIECVRl
			kl8JBFy4z+xOisg5UrHqNd45OJhfPXEJ7WungFkjYmuycNQd5Mpi1bys2h8MxEbWBjJM7bnkgR+x
			6s6/8ObaK3j84uiWbo5cgPz+mg8gZtPROYgVlZXnpGxHVVWzBMjq6lpXd5HzQQEyERGRC1DvERdh
			f+MAh/x9YeNmQsbex6X+dP6ck49/AGRl92Dc9XFAIQDdOsYdW0C79nQjv0nXSjr+3DqFBWSykVcf
			23PsQ6t4aFcG/qhySg6s5Pl/LOKQkZp10Rhz9FxzMl3iEBEROa3Yodcxy+vG5/PjD3YkfnA2exbn
			kJ/ngHbFlAKhHbrTPbETIdau9OhtqQlAdOxFr4odANjik+nVs3ZYRm2AzNhtAtN6NlxovhtTb+mM
			x+fF5w8S6DCWQ7s+Ytuhg+Qz6BQzcdzsXrGKokAkA6+4lZldawNMPfvWXO7g6dvoKC3Hb4D45FS6
			dYzAautOzwEmDEaI7Rng4BKAMDr37EXNJDQX21aspYh2jL/2FibUZNejV+92GJ9/i00bV5M+6Xrq
			VvDwdhjLrKk1afq6GQv4vy8yKA6kcveVNen/+lgL2fvBbvIP5cPglNNXuKGoYVx3nRuPz4fPH6Rj
			7BBy9iwhJ/8QDoYzdERn1n6Vw749ToYPs4NzJ7uzDYQPG0ov85m141TCTna/T8e1nQ273RjjJ3Dt
			TRPoaAT69qVLyEu8tqb4mEOTp3yX2RNOUo7RdjQtKDF0HTKG5KR2UJhDbnY66Xlr+WiOgTu/O4VO
			JvAeWsmnX+dg6DSUi0YnY6/OYe3Szcz7dCXt7phKl479GJa8hRUHlvH2+zl0jjbjLckn3wVgwGAA
			c8+hDGqXw/adn/BWWTfi7QGqC/IoADAYzjxdpoicE9Hjb+e6OX9k1foDDJmcRITNQFj/sQwNXcm6
			6sAJxxtDOzNlcGcAgu5KDmzaQHbCdfxyTHRLN0UuUFarBbfbg9vjIcRW+7nkrFIHN3CuyjmO2+Op
			r7vI+aIAmYiIyIWo92Auzn2brYXDYKONCQ/EEl/Qjfw3dnJkFKzM78Y9sac43+/HazadXT57kwkL
			o/npP2Yz+ISC/OR++hS//CqO7/35KSbHAoUL+dWP84+emxhFhB+OVsKP/+zSoYuIyLdR0IezMIdt
			27ZzsKiQUqcPt6Mm9Y7H7YakIYzqnMHmzHm8kRVBp37DGTs0lY7RoVhOEx2I7ZBwzJfigLuMvD2b
			2JFxmKLSapzeaqqcNGEmTj4HDwFhfRjS9QxnX9WK7DuSPjtKydz4Fv/eHkuvIZMY1q8LHSLrUvYd
			L4+cA0BUL/p0bLDZmExyF9i0t5SS8gZt7ZRQPwPObKtpdXi3Hkdncse0IxYocp/5nCOf8wg527ew
			I6+QwjIPXk9lTRoxlxs3EN9vJD0X5bInbSfOoSNgzz5yjBGMSE0GMs6oHc0iL48cILp3n5rgWK2O
			neKBYwNkQb8P38k+r5jMBDDX3q94Bkyt7d2evRg0diI7P3qaz/dtZ1f+FDp18bB31TqK6Mz0a6cx
			KAygF50Dh3hu3jpW7p3ATYNiGX71DbBgAZtyizly2ERM6sWMifiYJVl2Qm2AOZlpN1yGef5y9hUc
			4UhlKElDp9Bu01ds8YQT2sxdJyInEdaP7/5+No/e/wgv8Udmj+1EdLuLuP36j0j/+CCVDheeQBCD
			0UpIeARdrvwVs3r7cVeWcWj1azz6Whl3PvNz+oWdfVWkbYqKiqSgoIjiklI6J9S8wUZGRpx1uQaD
			gfDw5nlhFpeU1tdd5HxRgExEROSC1I7k3gfZmZ4N5hHcGgvEDmV6/lIy0iH/4sn0bnC011GJ098O
			uwnAiyP9APn9+tD+bKrQMYkBIQvYn+NiQLeQ2jiXH6fDizW8mj1bsxl1z6M1wTH8OCurjqYT6diF
			vrmLWJt3CYlJNaPD/M4c9mcDyS3dtyIi0qq49vPVux+TbuvKmLGTGRgbS0LRAp6rS0tl7Mi4W35A
			n5ytrF+7kfTtX/PmjjRm3nUjAyPOZP5MgCNr3+fN1eV0HDyF0QPbEdM+yI633mbjaQM0vppBHiFB
			OGbwR20VjTUhE7+vwc6A/9gB2GG9uPyOzhzet4lVG3aTsep9duwcxR13XkRna2PXNGEyAQEv3gAc
			jaL58fkBgwnTaZatsdmsnD0X+79+i0/2hZAyZhyTBrUjtmMBC5+bS13iMMy9GNI/nL2b9rGrui/B
			tBxMcRMZnHwm7TDW7PL7j3ZxMID/XIxiNwQxAUa/jyDUz7ryNRIJO7D8v6dIsTiGW24dTuNjlCzE
			xUYDZVS7ACqoKAfCutDBfvSo0PZdCCePysoKIB5sHRl++e0Mr90f9GYy70UwxiXTpe75ZEQvplzX
			iym1PwYc63h3oQFL3xQ6IiItpuMlPPxYAX98/Ff8btd3+f7NQ+h87Z94vPN7fPDBGnaVebFE92PM
			9ddz4/AOVOXvZss7L/GfTRFc8dijXKJfYDkLnTp2oKCgiJzcvPoAWaeEjmzfueesyo2MCGuW9IoA
			Obl59XUXOV8UIBMREbkgxTJobCovPfci5ssf5acA9GTE5L/w6+fMXP3YPcccnTvvY5YO/Q7DIwH2
			88Hru7j8wXtoYuKhk1RhPNdf+iFPvDaf/j+tW0usmLXzChhz23iSekfy+rpNFKb0BMrZ+N58cutS
			LMb2Z/KQObw6dxOTZ/UEoGzjZ3yVD/ooLCIixzi4h/1OiBk4gVF9O2Dwezi8v+LoflclpX4zYV0G
			MfW6AQxe9QavrcliR3o1A4eEgcGIAQh4nLg8bsBCSKMXKiVrXxHQnWFTBtLDFMTn3ENpk9aJT6Br
			ipXdGXvZmjGKqEQrVjP4vV6C1nBi4+MxUUB+dibV3ZMx46M67xANiw5UlVFtsBPbcwxX9hjK/q9e
			4tM9O9h5+CI6JxkxGAG8uJxuPIDR3o6kJCs7MtLZeWA0UQlWLIYgXlcOWYfAHNWVhCjqsi03owPs
			TXND9FAmjOpHB4Mfz5F9VBx3VHKfPkRsWc++9Wtx55hIuHRI7WeHJraDWOJNUHAom6zq7iSZwVeV
			R37VcRdq7H5bTxMpjO9MJ9NucjPSODI8ihibCbxu0vcfOuHQJqdY9FRT4QlitVgw4sPrKmBnWgkG
			Sxc6xQFYsYZZMBRnkHFkNHFxVowBDyWZGVQYLCSF1AQvfU4HHsyYTAaCPi+Vu9ezxxVClzH9avsv
			gKe6Gp/BgtkUxOf1UrB2Cwcs0Qwa2E0PfURaWFjv2/jzs/15829/548/f5PE4ZczcfQYbnvo0vpj
			ygp2sui1V/l8Qy6Grlfw8LO3MTj2LC4qAnTvlsy2HbvZn57ByKGDMJvNdOuahNVqwePxfuNye6f2
			bJb6+nw+9qdnYDAY6N5No2bl/NFnJRERkQtU/OCxDI0/TNLwox9Q23cdRLv4Lozqfeyx3a67HPvH
			T/Dr2qHc3W7/Lff2Pt0VLITHx3HsAmPHbut942+56+AfefqxZfVHTP7RU8QD8Tf+hMt/9CK/fgwg
			hVt+dAtD8wpqT41l8s9/C3//Y+1+6Hb9o/zy0gN8Yj+rxI8iIvJtExJNjM1E6c6VrIzsQXhZJulZ
			DdIAHlzG26uCDOjXkVCqydlbijU0jsSOtaGKiHbEW9Mo3L6YxfZELLZBTAtv9EJExNixlOSwbtEm
			PB19FOxOo8gKOE9XyTAGjBnGusNb2P3ZaxxJHcSABChM349x5N1M75xCUmg6OTvm87ltGCnGfHbv
			zqPh46nS7Z8w52ASA7pGYPYWsSc3QEhEUm0wJZKY9nbMxZmsnLcWl9VEu5njGTBmJBsLNrJtzluU
			DhpIt9BqMndsJTcYTa8Jo0g2nq7e50IYUTE2TOXbWbUynO7hZWSlZ52YkjJxMIPiNrFi/TowJ3Fp
			/dpvYU1sRxdSUkJJz9rK/M9sDEsxkb93J3n+467T2P0eeppFT6P6Mqj7GgozV/POexUMG9yOQM5u
			DpSFnnDzzbYwzE3JonlgEa8sriC1ezfiyWPPnmyKvWHEDRjPwJiaezpwbH+2Fu9h3Ycf4Rjeh9jy
			PWzYWUlou/6MGVAzOv/AivdYV5VA5442KrIy2JdfjTV5IpcOq3t6XsGOLz8mIySJpGg3BzIyOFAa
			IG7AFVzUVY98RFqF2MHc9qf/cePhXSxZ8DlL/vsFb5cdfQewRHel37hLePDJcQxOVE5FOTd6dOtK
			VFQkhw8XkrY/g359UokID2fooAGs37SVQCBwxmWG2GwMGtC3Weqbtj+Dw4cLiY6Ooke3ri3dfdKG
			6NOSiIjIhSp2PL96bvwxm+In/YSXJzV6MJN//hSTj9/sd1FWWsWJ48fMhMf05Jbnnjpu+/HbTlJu
			g2NvabBl8nOnq9NT/Kple1VERFqbxHFcNbqUL3ccJm19GaFJ47hycgTvLsgk3GaEyC50NK5l5/oD
			AJgiejBi6jQmJtSe33EE00YcYN6uUrK37iNp0iiwhBIVFVVzfr0wBkyfTt4ny8nM2cz6vBj6T7+c
			kas+Yn1ZKKddLj5xCrdfH8OSVRvJyd3J+lwTtugujIwBwgZz2WWlfLlkN8VpmymL6cuUmZ3Z9NVG
			SkNrSg5JSCZqTxqb19ckELQl9OeicRcxIAzATJ/xF5NRuooD+TvZGjaYqwASJ3LLrMiaa6ZtZj1g
			ikhhxJRpTKwLQDXW1sa2GW2ER0XhDT1dS43YwqOI8tX1SWfGXTma0rk7OJK2nrKwZMZeMZmIdxeQ
			Gd5w/bR4Bg+KZ8XCAqy9R9K/4TPgprSDMAZdehklXyxmT8leNlfE0GfKFYzf8AUbG96fxu73adsQ
			xoDLb8C9YC6bDhxg5/o8YlIv4uoBGby5wHfc66SJItuTaM3jQNpmDgCm0ET6DxvPhAGd69eCs3W9
			lFtmtWPJ4o1kb1lPtsFETLfRTJg+juTag0LD7bizs9iZD5gjSR4xmWljexFZXyULoaFQeXAvm3PB
			FNKe/hcdex0RaR0sHftxye39uOT2lq6JtBUjhw1m0dKVrF63iW4pydjtIYweOYzs3FyOHCkiGGx6
			nmKr1cqE8aOIiY4+5/V0Ol2sXrcJk8nEyGGDW7rbpI0xlJWVn4uM3ccIBALs2r2X8eNGt3T7RERE
			2rhC5v7mQZaN+xt/mdHuxN0lK/nLb+eQecKOFG75w09q1w8TERE5vb8/8zx3zz77p35FK1/mlRVx
			XPOra0nFgOFMlhFrTgE3jkoX/kZ2mUIivlkQpZUKuB1UuhptKSER4XyzpgYoWfVvXlrhZvjNP2aa
			siedN8FgEPbN4S9z0kid9QjX9mrpGh3r36/9j5/ff19LV0NE5Fvp/Tmfk52TS68eXZl+8RTs9hCO
			FBTy5fyFlJZWNLre5vFCQmwMGzKQ8WNGnvP6OZ0u5i9cwr70LFKSE7nh2itausuklVq5ai39+vau
			X9v3XNEMMhERkW81E/boOKJPlrawkVloIiIiLc9F2eHDHA6JISEm5OyLOxfKd/D5O+sobWRXzIib
			uXnEt2dUSdn2z3h3Q6MtZeTNtzA85kxK8+Nx+Qj4D7NlRzGWmFH0TWzpFrYlLsoOl+IqcbV0RURE
			pAVcNHkcH378JfvSa9ZbuPiiicTFxnDtlTNZuWYdWVm5eLxe/H7/MTPKjEYjFosZm83G2FHDz3lq
			RZ/Ph8vtZuHi5exLzyIyMoKLJo9r6e6SNkgBMhERkW+1U6VAFBERaX2MtnCiokrZ/PEcNne/lHun
			d2vpKtWIGc7N9w5v6VqcF7EjbuHeEeeqtHy2LEmj8PAu9jhjGXD5ODp/eybbXQAOse7juWQCUVFR
			nDaDpoiIfKvEx8Zy+aUX8+W8RaRn5lBY/Cmjhw+hW9dkLrloEjm5eaRnZnEo/zBulxcIYjAYiI2N
			oWtyIv36pBIWFnrW9QgGgwQCAfx+P16vj8ysHNZu3EJ5eQVRUZHMnDGV+Nhvz2AjuXAoQCYiIiIi
			IiKtxrkNzkjL81CatZcDpgj6TL2KGT21Mtb51Y0Z9yp9oYhIW9alUwKzrr6MZSvWcPBgPnMXLKFD
			h3i6paTQKaEDI4YNwWo2U+104vP7sYeEYDHXhA38fj8VFZVnXQePz0d5eQWH8o+QmZ3NkSNF2KxW
			uqYkMmnCGAXHpMUoQCYiIiIiIiIizUQBGhERkZYWHxvLrKtmsmXbTrbt3E15eSUbNm2tT63YML1i
			czAYDBgMBkwmE2azifbt4xnUvy9DBvVv6a6RNk4BMhERERERERERERGRb7khg/ozZFB/0jOzOJCb
			R0FRMY7KKrw+X7Ne12I2Ex4RRvv4OJISO9OjW9eW7goRQAEyEREREREREREREZE2o0e3rgpSiQBa
			GldERERERERERERERETaFAXIRERERERE5KwZjfp6KSJnJhAI6G+HiIiItBh9ChEREREREZGzFh0V
			jdvtbulqiMgFpLi4hOio6JauhoiIiLRRCpCJiIiIiIjIWevfL5XM7Bx8zbzIu4hc+AKBAG63m737
			9tO/X2pLV0dERETaKHNLV0BEREREREQufCOGD+XzL+dhNpvo2L49BoOhpaskIq1UZWUV2QcOEAwG
			GTF8aEtXR0RERNooBchERERERETknLhi5gw2bNzMilXrcFQ5Wro6ItJKhYeF06N7ioJjIiIi0qIU
			IBMREREREZFzZsTwoXroLSIiIiIirZ7WIBMREREREREREREREZE2RQEyERERERERERERERERaVMU
			IBMREREREREREREREZE2RQEyERERERERERERERERaVMUIBMREREREREREREREZE2RQEyERERERER
			ERERERERaVMUIBMREREREREREREREZE2RQEyERERERERERERERERaVMUIBMREREREREREREREZE2
			RQEyERERERERERERERERaVMUIBMREREREREREREREZE2RQEyERERERERERERERERaVPMzVl4MBhs
			6faJiIiIiIiIiIiIiIjIBchgMDRb2c0aIHO53c1ZvIiIiIiIiIiIiIiIiHxL2UNCmq1spVgUERER
			ERERERERERGRNkUBMhEREREREREREREREWlTFCATERERERERERERERGRNkUBMhERERERERERERER
			EWlTFCATERERERERERERERGRNkUBMhEREREREREREREREWlTFCATERERERERERERERGRNkUBMhER
			EREREREREREREWlTFCATERERERERERERERGRNkUBMhEREREREREREREREWlTFCATERERERERERER
			ERGRNsXc0hVojNvtxuv1EggEm3S80WjAYrFgs9lauuoiIiIiIiIiIiIiIiLSyrW6AFlVdTXbt+0k
			79BhnE5nk86x2+107tSRgYP6ExYa2tJNaCZeykt8VJpMJERZMbV0dURERERERBpxpgMeRaTt0UBn
			ERERaQ1aVYDM7XazaPFy2sfHMXniWEJD7RgMhlOeEwwGqa52kp6RxaLFy5k+bcq5/4DlcXPQESDE
			biPeflxWSr+HonI/LquZLuGWZuydXF75Wzqvt0tg6QMDiG/GK4mIiIiIiHwTxwx4dDVtwKOItD32
			kLYw0FlERERau1YVIFu/fhPxcTEMHTIQs9mMwWBoUoAsJCSEoZERbNy8lfXrNzFhwthzW7H0rcx4
			s5wJFw/nxYtij91XksZvns5nRf8e7LylW0t3oYiIiIiISItwu90sXbqSmNhoJk8cR2RkREtXSURa
			qYqKSvZlZLBo0TKmX3KRZpKJiIhIizCefRHnTmZWDr179cRms2G1Ws/oP5vNRu9ePcnMymnpZoiI
			iIiIiLQ569dvomfPbgwfMljBMRE5pcjICIYPGUxsbAzr129q6eqIiIhIG9WqZpBVVVcTHR2F2WzG
			aDSedvZYnWAwiMFgIDo6iqrq6pZuBhDA6/RQ6griCdbk1g4PtRJprYlHBv1eHFU+HD7wc+J+gIDX
			Q1mVn+pAzf7I8OAZX8fvdJHvDBJhNxN0+3AEDMREhRCmBcxEREREROQcy8zKYfiwIS1dDRG5gPTu
			1ZMv53597jMBiYiIiDRBqwqQAZhMpvrUik0NkAEYDAZMptYQ+QniqShh9Yp9vL7DRU4AbAYzF03s
			zfdHtCPKasCVt5+35hUwryRIuT+AMWhh+pTe3Du6PeEmwOska8tunllUwkafiTh7CNfOiMJxhtcp
			XbOWGQs9zBrTmbDcEpZUW/npd0cxI/abtUxERERERORkqqqrW8l3MhG5UERGRrSSgc4iIiLSFrW6
			ABnwjYJjZ3L8N+VyusktOe6DW7kfV8Of/ZWsmbOVXxyyc9u4FB5oDwe2H+CJL7fjDRvDI4PDcOVV
			kR3fgZ9OCCXWW82ShXn8+8sdtE+cwneSDLjSdvDjT8qpjI3grsntGUQlH319mKVneJ06n20r48/f
			G8tD7fVlVUREREREREREREREpNUFyM4m0NXcQbIta3dx48bjNgaDNAyZ+fPSeW5fgKFTenHtgJog
			VewkJ1O25fHOllx+Nrg3MSMH85g7gNMbwB2AK4cX8+951ezKdUCShZVryzhgsvH4rSO5JqEmXeKI
			lO1899nDrD+D69TpN7InMxQcExERERERERERERERAVphgKw1S+wSzfVJtmM3VpfxwSYnWbU/lmZV
			sAcIX7+Hu7c2OC4mhM4BcAV9eA4fZtGGw+wvcrK/Go5UegBwuH1AKbuzgZhYRiYcXZOMhHD6Qn2A
			7LTXabBpcJf2Ld11IiIiIiIiIiIiItLCvIEgTk8Aly+A1x8kEIRgM1/TABgNYDEZCDEbsVuNWIzN
			nxFO5HQUIDsDXXp2446LjlvAq3AHaxoEyEwGI2Zg2pSB/HKwhWN+zQ1WwqoO8MR/0vnYHsXDU5KZ
			ER9O18NpjP20boWxYM1fjGCAYACoi5F5AzgbFHXa6wBFLd1hIiIiIiIiIiIiItLivIEgFU4/aYUu
			lmdXsjXPQXaJh3K3H3+geUNkJqOBKJuJlFgrgzuHMzElgtR2IUTaTQqUSYtSgOwci0mOItXkYs3e
			I5T0TyE+xIgxGMTtDmAJs8C+Qj5wwtBhKcwYEIvJ5+fALneDEqLpl2jAkF3O4oMurmlvwhL0U763
			hLVnch0RERERERERERERafMcHj/b8538d2MhizMqzvv1/YEgJU4fJXk+NudV85/1BVzUPZI7hrdj
			YIKdcKuWB5KWoQDZuZaczA96lPGHrAM88N9KrhoSRqzXzd40FwOvG80loXb6h1Sya0s6b0fF0qm0
			nFXpDSP00YweHkXikQqeeWM9JaPb0dVfzvwDHjoAOU29TlxLd4SIiIiIiIiIiIiItKQKl5+3txTx
			j1VHjs4UM9T+TzBY+8O5m0EWZjVhtxixmAwYDQYCwSBePzi9fqq8gZprBWFxRgXLsir56bgO3DIk
			nsgQBcnk/FOArCmsISTGemlnN564z2SlXWwoieF1s7aimXJbf8K/zOTfmS7eWeMCs4FBHWLpHgHE
			9eJPk3w8saWaOWuK6dMtgYemO9jyZWV9+WFDB/Iv9x6eWVfF/G3FxLSL4pc3dmbDKznkR1kxNeU6
			gMluJzHWTLS1pTtQRERERERERERERM4nh8fPC2sL+M/6gpoNdbGwIBwNip2b4Fi4zUR0iJnL+8Yy
			MjmSrrE2wq0mHB4/WSVu1udU8MXuEspcPhxuPxhqZpY9teIwZe4APxrbXjPJ5LxrVQEyo9GI3+/H
			YvlmKQL9fj9Go/EbnXtKPQYx98GT7ItN5Q8Pph67zRTHiCvjGNHoCSEkTRrKS5OO3Tq3z3HHjBnC
			U2OOPWbQg4nc3eTrQMyYUcwdg4iIiIiIiIiIiIi0Id5AkDc3Fx0NjsG5nCh2jJhQMzcNac/dozrS
			PvzEZ/s94u1M6xXNPWMS+Pe6w7y7pYDSal/9/v+sLyA6xMhdI9trTTI5r5ohmvTNRUdFUVRUDEAw
			2PTf1rpji4qKiY6KaulmiIiIND+PgyMFDjzn7YJ+nKWFVJ6/C4qIiIiIiHyLBPF7q3FUlFNSVEBB
			YQEFRSWUV1bh9gaaK24hbdiuw07+sfJIs18n2m7m0WlJPDI1sdHgWEPtwy08MjWRR6clEW0/du7O
			P1YeYddhZ4v2mbQ9rWoGWe/UHuzak0ZMTAx2ewhmc9Oq5/f7cTpd7NqTRu/UHi3dDBERkea3/wse
			+D/49es30e+8XLCUlc89ysFrX2L2+bmgiIiItEp+XBUVOP1WwmPC+Gb5X1qaH1dlTRvCosKwnmyg
			ureKUocHkz1S66KIyFkI4K2qoKy8gvzMtaxbl056+l4OVxswRnQitXd/ho4cRu8u8URFRxERamld
			MxrkguQNBPnXmto1x87tEmPHCLEY+cXkLtwwqN0ZnXfDoHa4PAEeX3gAlzdQn27xX2uO8Ow1KZpF
			JudNqwqQDR48kAWLlrJm3QZ69ehOVFRkk84rL69gX3oGXp+PwYMHtnQzRERERERE5BvyuyqocPpr
			frCGExN2YYZgvr1K2fTuyywvTuXah2eRevYFtkgbNn/wCstKUrnqp9fS92Qvsax5/OujNOInfI97
			xsef8VW8VaU4jp99b7ITGRlCXbgt4HVS5XTj8wfBYMBksmEPs2OpfzoewOeqptrlxR8Eg9GE1R5O
			qLXB4/NgAI/TgdPjJxAEg8lCSGgYIWYD4KWq9GjWAWt4DPqVEjmPAh4qCg+yZ8GbvDFvF4WVFVR5
			AAzYY7qQHO4ia/VHrJg3h7CYzoy48lZmTexDl3aRWBUlk7Owr9DF4oyKmh+acXrilB5R3DGiwzc6
			944RHViZXc7cPaX1dVycUcG+Qhf9OtjPc49JW9WqAmQA06ZOZuvW7axZtwFHVXWTzgkPCyUlOZEJ
			47XgloiItDF+JyXFDrwA2IlpH4716E6cpSVUeGt/tIQTH2OvfyDjqSyktD57gYXIuGjspsbPtUQE
			TnNtsETEEms31Z/rDInG7iqjwnt82SIiIidXuvFdXllRTmhUKJbul3Lv9G5nV6DfjaPaRdASTsQF
			OwsogNdZhdNjwh4VeoHO2jpPmnS/TYRFxRFjjiW82QaoB9g/70U+3WfEbDUfnQ0SO57vzB5NHIC3
			msO7ljBvdRplXhOmoB9LVCrjpk+hX6dQzATxOg6zb+1ilu04jBsjmMLpOuZSpg3uQpjFAPhxleWx
			fek81mQ7CBAgaO3IoKkzGNcznhBTLivemUumt5ryai+psx7h2l4tfZNE2oiAh4rslbz+91dY74mj
			7yU303vjS8zbD2BlzH3/4MFxdpyr/o9bnvdx2eV29n79LI8uHcG9v5jNyCQFyeSb+3p/ec0/mnH2
			mNlo4K6RHc+qjLtGdmRBWhm+BjPdvt5frgCZnDetLkAGNTPJNBNMRETkdJyUZq9l/suLycWPs6Qn
			tz11K+MjrICf6pJ0Fr36BouLah4OeaJHct+PptM3wgp42PHx33hzV004zV8dzqT7f8LV3e2Yas+d
			+9J/WFlWsz/x4qtJ9ja4tN9Jyf6lvPTv1RSYADzEjfouP7k8lUhrTTrGJf2+x5SDn/BVXiLX/ep7
			jItp6f4SEZELRzJTvnM5PUy2sy/q8FY+nbsGX9/buHPsmc8Cah2qyFryPov3dWTK/TMv0Flb50mT
			7ncMg2Z9j0HNWpFySssAczt6Dk0mom5zWCfqHvn5sxfy7tydBNr1Z+yUPsSW7WHlmm189b6f8B9d
			SXdjFWlfv8PnmSY6dR/MqMRQDu3bQNqi93Fb7+a6QVGYvPms/PBNNlXGkNJ7ND3aV5O1fTubPp1D
			8JbZXJyYzJTvzGbi/i/4x1fpLX13RNoQP1V5q3j5Dy+TlnINjz54I72ynuf6d+r2GzEHHJSWu/AF
			zBhLV1Cc9CF/eTqT9//2d55/7GW8j/+QiYlhXKhDO6RlbTzgqP1X80XIkmNDGJXctAxwJzMqOZLk
			2BAyipz1dT1ad5Hm1yoDZCIiItIUm3jzyz488dfHiaOUVU//nuffHsrI7w/C6slj7vMvk3PRozxd
			G5na/+HP+ePbSbzy/UFYOUh2xPd5+q81o/KLl/+Dn72xirF/uJgETx5zn3mRxUN+wvPX1O5f9SK/
			zodRtVf25C3kH88f5JI/PF4b+Mrk/R8/xf9SnuK+oTXHZC9YQ+ifHudpBcZEROSMmbCFhhJa+1PQ
			78ZZ7cLjCxAEDAYT1tCjaeaCPhdVThc+X7BmvzmEiAg7gapSHEeyOFBYTUxVBaWlppr1pExOSh1e
			TDY7Zp8Ttx8s4TGEW45NZwdgtNgJCwvB3JSZRgEfrupqXD4/wWBNPW3hkVh9NWkja65Re6zfRUWF
			E3+DNJIBT3VNur3aidtGaxgRIQEcFYUcyDlCqTMMR2kppVgIjwnHAgQDHpxVzmP6xmwPJcxmxgDg
			ddS01R6BPVBNldtPEDCHRBBuN+KtclDtqdlm+v/27js8qipx4/h3ZtL7pBAgJCQkIfQqHemioLKK
			DbCXVXdd3d9a1rWsuq4ru66u7mLZtTcU69oWlSZIld5JSEICIYX0PpNkZvL7YyYhgQChhInk/TxP
			noe5c++559yZ4c7c955zvAMI9PPkpDtV1dupsVRjrbXhcFYCk6cfAf5eGO0WysqtODz9CAnwbiy7
			vraS0qo6TH7BBHkbT9yOFo7X4fnQnMeDY73eR/Uka76d6+hTZ6miusbZBoOHDwGndT2xDkcdENyL
			sRPH0FJUV15cRB0QN+wiRvb2wujojvXATr7NLKKoAuLtm1mbUoMpaQazLu+HNzC0fwS8+gk712yh
			oP8EIvatZ0MhhI2ayTUTnENcDY335+1Xf2DDuhQmRPfD288PdeUXObscFXv54rl/s6vnHTzz4CQi
			TFB6IIPGATywsOgfj1I2tgu5q37CAqzfkwGjenH1H58m4m8P8J/n/kuXP8+hV6C6kcnJSy+ucf6j
			vu3GVxzc1f+MlZNeaGmsa2PdRc4CBWQiIiI/W3Fcc71riB7MjJk6kpf+vofUOwbSa8+PfFY3gUcT
			6ziUnw9AUL8JRP11B3tuG8hAUw+umGGhOD/fOURipx5EHSikGOi050c+yx3DY08eHtIqbMxVXLFs
			KwcBsLNnyTfUTbyXhLp8DuUDBNBvYmee2rqXO4c4h1jwPP9C9RoTEZEzou7QVpYv286+0mocdjt2
			AogdPY2LhkTja6ihKHUdS9dtJ7+8nnoMGIL6c+XNE6n+8V3+t8d5kaVs25e8t8dI6MjruS7kB/79
			WQrm/mOILUkms8pBjwt/xdS4cvatXsza1EOU1dpx2Ovw7DSIyReNIynM6/jBkd1KeV4a65evZndh
			NfUGA0aTH71n3M6g/Qt4bWVh8+HtSjfx0asrKOx1BQ9dngR11RzctoSlGzMoqwMj4BU9iWsnWPjq
			vdXkWQAOsOK9d1lNAhffczHxdiulB7ez6odNpJfVYKQeh8GfLgPHMWlEIhE+Jsj4nn9/lkLo8CsY
			U7eOFXsLqbLYCO9/GZeO8WP/j0v4KbOEaksdgb0u4qqLBhDmdZIRWW0+235YzPbMEqrt9djtDgJi
			x3LR1KFEWzbyyRsrKeh2Ab+dMww/A0A91h1f8O9FuXS/+C7m9DWeuB1HHi/gyPnQPI71eg8PPaLC
			R8+jZqvMY/eP37JiTzEOD1+8wxOYGFd3VFNbnFesQbP5xaoprwZ8LZSXlGDi6LDVHJtElH8h2clb
			ye2WiJ81lZQ8TwK6JtE9GNhXRDEQHBp+eAht7zi6R8LO9EwOVoFXUbGzrE5hh+sREkf3wB/IzdrP
			QfoR21YfTBE5por1C/giuy+/fXwCEa582jvIjHMsDxfrAX5acsD1wEhYsKuvqSmC8b++jVW/fIHP
			Nl3KIxOC3d0c+Rkqs7rmc23DHmRdgrxOv5Bm5TjrerjuIm1PAZmIiMjPVhSdjhFAFeVnQ+4W/v3c
			+uZDckRGU1kOdu8SCg+s482GIRLt1RQz7PC2PUYTccz9lpCfDdlb3uGvPzW/GzkyppJS179jI5SO
			iYjImVGVc4CK0L6MGxmBb10Be1auZteSL/Hr+msu9N/KV1+toSB8AFOmJhFEORlbSrAAXYZMZ5rP
			Oj5dl4V/wngu7BeId1gwFDjLLUneTdxlN3JnQkNftWKysk10O28yo0M8sGStYen69fx3UQS/mz0Q
			n2PWsJ7a3HV89MFayvy6ED/gPHpH+1G1bxsVjhM2DwBH5hI+XbITj+5jmDS8K77VeWzLrMUWmMi4
			6R5s+f47dpd3YdD0kUQTRBfqqc1ZxacLNlIZHEvfMQOJ868mY9tP7Fz7OV/UXc9NU6Ib5yur2vMj
			O/sOZ+qEEjav3MC+bd/wRW4QHpF9mTwFUletZueu//F9dBJzBvu0rtINqnM4UBFGn/NHEeFno2D3
			ctbsWsJX/lH8ampveoevoeBACrurz+M8fwPUW0hOOYDBpw/D+vhSm7O01e04nmO+3idSX0P6kg9Z
			mGLA3H0AwwbGQNY2lq/PPGrVrFUf8F36Mcoxj2T27KE4vwHVYa/3wbduF1+9vRWbzYFv1yFMnjqW
			xAhXiBY+hCljDvDBkh/5ZP5ajPV1WOqjmXLBEMKNQGAEZtMeirL3UVARgL/RQH1dFln5ALXU1LrC
			M0M++RlplMdEYzLU46jaR04F4LCie/BF3CN49Gwu+/pv/LRhP/3HdyfY24hv75EM8l/D+qqjTwxG
			/yjGD+gKgKOmjP0bN5EddTn/N0LhmJwak8GAva0mHzsLdRc5WxSQiYiInINMHh7QZRoPPTmFLkc9
			ayfr65f409JO3Py4a4jEwh94/P5Dh7cNDTo8V4ZrG1vjTdQmPDwgavpveXpaZAt7L3R380VE5Bxj
			HjyTy2qt1Nls2B3hmPvvY9fyA+TlVEGnEsoAn4hYuneJxMcnlvgkT4wAkYkklm0HwDs8hsQE10B3
			roDM1ON8pjSGYwBxTLymK9a6Omx2B47wEfTc8Tnbcw+Sx8Dj9MSpYc/KNRTWBzPw4tlMj3PNnZbQ
			G4DCrBO3sbKsAocBQrolEBMRhJdPD+L7mTAawZxgJ2sZgB9RCYkkAmBl68r1FNKJ8y+fxVjXKTkx
			KQLDy++zcdNaUidE08dVvq3TKC6f6Bymr4chn2e+SaPY0YtbLxlNONDLK589H+8mLzcPBseeuMJN
			BQ/m8strXMetnohRA8nYtZwDeblUcR6Dh3Vj7f/2k7LHwtDz/KB6F7v3Gwg4bwiJHjUn1Y7j8TvW
			630i1h1s3FODMWIcl189lkgj0Ls33bz+w5tri5qt2n3Czdx0/jHKMXhz+N1kpseQkcRGR0DBfg7u
			Tyf14Hr++4WRG26eRJSHM+D8esl+jN2GMmlEd3yr9/PT8k0s+noVna6fTHRkX4bGbWHl/h9Z8MkB
			uoZ4YCs9RJ4VwIDBAKaEIQyK3M+23V/zYWksYb4OLIW5FBgAg+Hkh8sUkTPDtxfXPnw9f/nDU7zF
			I1w7IorQ8HHMuuJrMr7KorzcQo2jHoPRG9+gIKIvvpcZiXZqyorJ/mk+Ty+o5Nq//pZevqdfFemY
			wv09yCmvpa16jwHklteefiHNyqlvrLvI2aJ3m4iIyDkorFsiQblZpFfU0iWwYbiCWsorICiwirSd
			WQy+4feuIRDtVJdVUte4bQ/83tnMluv7McLP2UOstiKDfQdwXfQx0y0xgOwDGZTXRtI4GkJtJeUE
			cIZGWRAREXGqr6PqUCbbt+8gu7iIUquN2grn5O21NTUQPZgR0Rls2b+Y99/1p0vvoYwckkTX0AA8
			T5AOmDt1btbT2m4t5eDuTezMyKe41ILVVk2lhVb0xMnjYC4Q0JtBDeHYSQrqPZw+O0vZt2UBb+40
			kzjofIb0jaZzsA8tzx6VzYEsIDiRXk3vVzHGEBMFG5NLKSlr0taunWmomcnbWaJ/j/jDc2OFRGAG
			CmtOts9RPXXVeWRu38rOnCKKymqx1VVQCWCtoQYI7zOcxKUH2J2yC8vQ82BPCgeMQQxPigHST6od
			bSL7IAcAc1IvZzjmEtk1HGgekDlsNdQcc4hFI96+JtfrFU6/ia6jm5DIgFHns+vzF/gqZTu7cycR
			FV1Hypr1FNKNCy+bwgB/gESi7DnM+249q1PGMWugmaEzroalS9h8sITCQg/MPScx0v+//JDph78P
			4BHD5CunY1q8ktT8Qgqr/YgZMoGIDQvZYgvgzMwOIyKnpNMk7n2ogL8/8yR/S57DDVcMoOv0R3k4
			8gu+/HI9yeV1eAb1ZtgvfsFlg8Ioy97Fjs/e4YMdQUx76PdM7OTuBsjPWa8IH2dAZjC02Txk23Or
			qLXX42U69dsxau31bM+tcj5w1bVXxEn2ZBc5DQrIREREzkWJ53P9oL/y1gebSby8YS6xLBb9aOb6
			K3vQrVcI8zds5lC3HkAl279aTrZriEUSBzIt8j8s/i6N2LHOQYIO/vAVOzxhREPxk69iyJ8W8N6G
			HlyZ6FqYsYIVoVdxdeJJ1FNERORELKl8+/EX7PPpwejRExgYaqZz/mJe/D7D+byhE6Nm3U7v/VvZ
			sH4zabuW8MGuVKbfcjUDg4wnsSM7+es+4YO1ZXQZMomRAyMwRzjYPv8DNp4woLFjtwMGO/U2jvql
			bTI5IxOb7fCT9XY7zQbZ8ktg+vVRHNq7iTUb95C59lN27hrO9TdOpluLN584e3TjqKPWDodTNBs2
			G2DwwHSC5nt7n4m7WqykLvqQL9N86TFqDOMHhWOOPMSSF78jo2EVj0QG9wtkz8YUdlf1xpFyAFP4
			eAbGnEw7jM6nbDYaj2K9HXsrh7A8LoNrt7Y6HDjnfwOoq7MdtWrrh1g8kgfmkCCgnOpagArKywH/
			rkQ26SHi06krARykoqICCAPvSIZOv5ahipHWpwAAYBBJREFUrufra9P57t9gCutOVEN3tcBEJsxM
			ZILrob1iHQsWG/DsG0vnM3B4ROTU+SZew2PP9ObjF1/mn49/SpeBUxk5dDBX3DWxcZ3Swj0sn/8u
			i7bmYIq9iHufuYb+Gq1eTtOo2ECWpZfTlj3I9hZY2HywkpHdA0+5jM0HK9lbYHE9qm+su8jZooBM
			RETk58grgMhI8DrmMjNj7rqDvAff4q/PNawQzZV/uB2AxMvvYFrjc9FcedtVDMkrdG3bgyv+dgef
			PfgWf/3JueXY2x7g+sJ/kNewQ/NIfntXIb97fR5/bSg+5mIevQvAhF9oJ0L9Wr7fXURE5KRkJ5Nm
			gZD+YzivVyQGew15KU0SK2s5xTZP/KP6M+HyvvRf8y5vr81gZ7qVgYP9wGjECNhrqrHUWAFPWh6x
			qpSM1EKgB4PP70cPj3ps1XsoqWxNJbvQI9ab3WkpbE0bTlCMN94eYK+tpd47CHNYOCYOkZuxj8oe
			3fGkjqrsHKqalGCvKqXK4EtI/Agu7jGI1IWv8lXyTnblTaZbjBGjEaAOS5WVGgMY/ToRE+PNjrRU
			du4fTlBXb7wM9dRaMtmXa8AjJI6uwTQOJ9l2skjZWwMhgxk9rDeRBjs1eSkcmSnG9O5N4OafSPlp
			HTUHTHSdPtjVe62V7SCUcA84lJvJvsp4untCXWU2udVH7Kil19v7BN9JwrsR5bGbA+kp5J0XTKi3
			CWqtpKblHLVqq4dYrKmitKYeLy9PTNiotRxiZ0oJBq9oosIAPPH298RQuI+0vApCw7wxOmooSt9H
			ucGT7r7OWdfqqsupqffEw8OAo66Wij0b2GP1pdvovq7j56Cmsoo6oyeepnrqamvJX7eFLK9QBvWP
			R9/GRNoB8wCu/uO/uTw/mVXLvmPlJ0v4orxx/Ho8g2JIGjGZu58cRf8ojakoZ8bkhCBeWJlLVe2Z
			uJPk2N5an8eALn74eZ38Gae61s5b6/MOL6gHfy8jkxOCzvbhkg5MAZmIiMjPUeIlPP+3Ey3rwRV/
			+zNXtFjA0c+NOdG2iX9uYX+XtFC2mTF3/Zkx7j5GIiJybvA1E+bjQdGu1awK6kFA6X727W8yxl32
			ShasctCvb2d8qSYruRRv/wi6d3FFFYGdCPfeS8GOH1jm2w1Pn0FMDWhxRwSF+eFZfID1yzZR09lG
			UXIaRd5A9Ykq6Ue/UUNZf2gLe755m/yeA+nbBYrS0zAOv40Lo2KJ9U8jc+ci/uc1hBhTHinJOTTt
			n1S64ys+P9iNfrGBmOoKSTnowDc4lqhwgGDMkX54FmWw+vt1WLw8iLxkLP1GDWdTwUa2f/EBJf0H
			EOdfTcaObWRjptf5I4g5mQ50p8yfkDAfPEp2sGZlAD0CS8nct5+jRiHsNpBB4Rv5ceN68OzO9Ma5
			3/xa2Y5oYmP9ScvYzuJvvBkSYyIvdQ859iP209LrPSTs+E0I7sPAhLUUpK9jwUflDB0YjiMrhewy
			P8DSbFWTtx9+tELWMt5cVk5iXBzhZJOccoAieyAR/cfQPwQgiP6jBrCteDcbPvucyqG9CS3bw6bd
			lQREDmBkP+fFwaxVn/BTZWe6dvamPDOd1DwrPnHjmDakoXtJBbu+/Zw0n2iig2o4kJFBVlk9Ef0v
			ZmKc4jGR9sSzUy8mzurFxFnurol0BN2Cvbi8r5n3txSBgTbrSLZwTzGj44K4ZlAEPh6t/+JhtTn4
			ZHshC/cUOxe46nh5XzPdgjVvg5w9Z+XrsoiIiIiIiMgp6TaaGSMTiPQtIW3TNvbW9WbahCTMZjNB
			PiYIjqar5yH2bNrE5k17KA5MYPj0qxnbMLZc5HlcMKw7YX7VZO3ch83XFzwDDm/fyI9+F1zIgG5m
			7Ae3sXlrDoHjLmZ4pBmzOQDPE9ZzAtdeOYkBPQKx5exh86ZU8uhCVCjgP5CLpg+le5iJkvRt7CwI
			ZczFY+luNmP2d5bs27U75up9bNu0ic3bs7FFDWDSzIvo5wdgotfYKfTpGo4pfw87S4zOuaW6nc+s
			mZMYEOtFefo2Nm9PpTwgjuHT53BpX1eM01JbW1pm8iGoSX2OzYRPUNNjEsXoS0eSEOlHSfomtqbW
			0XvaBJLMZsxBTedPC2fggHBwGPDuOZx+TSfHak078GPARdMZ0j0cU2kq23YfwjzmEsZGH/H6tPR6
			n7ANfvSbfjXn9+lCoC2bPVt2kR86lhnnx7bwPmml4EhifKrJTt/GtvRCbIExDJg4k9lTejTOBecd
			dyGzLx9Hn9BasrZvYltWLaHxI/nFNRfSw7WSf6A/dcUH2LM9lezqAOKGTee6mUMxN17N8cQvwEhV
			Xirb9hyg3BB51H5ERKRjumV4JyICPNtylEUAnvz+AAv3FFNRY2/V+hU1dhbuKebJ7w8cXlgPEQGe
			3DJck+/J2WUoLS074x8Rh8PBrt3JDB06yN3tExERERERkbPg5X+/wW03X3/a5RSuepXXVoZy+YMz
			6WkwYDSc+sTvZ5TdSnm5hZYu/Zh8g04tRGmn7NZyyi0tthTfoCBOral2ila9waurahk25zdMiXF3
			KzuKeuod9dSnfs7fPt9L0hUPM7Onu+vU3Otvvcev77zV3dUQETknLUwu5YnF2ZRabKdf2AncN6Eb
			1wyKIMDbhK+nEQ/j4e9wNkc9ljoHlTV2PtpawHPLDzbbNsTXgycuiGJ6rxB3HzJph3x9fFi1eh19
			+/TCaDyzfb40xKKIiIiIiIi0M1ZKcnPJ9Q0lKrSdzMdSsYtvP1pPSQtPmc+bxTXnmU+6yPaqfOdC
			PtrYYksZNmsWQ0NOpjQbNRYbdlsuW3YU4Rk2kt7d3N3CjsRKSW4xliKruysiIiJuML1XCKVWO/NW
			5VFUbWvT4RafW36Q75KLubh3KCO7BxEZ5IXRAI56OFRey7r95fxvTzG78lxjV7vqEubnwd1jOysc
			E7dQQCYiIiIiIiLthsknCLO5hG1ff8W2Hhdy59Qe7q6SU8hQrrlzqLtrcVaYz5vFneedqdJy2fpD
			CvmHdpNSG86AC0YTpckezqJcNn79PfsAs9lMwAnHChURkXPNnEFhhPiYeO7HXIqrbVTVOpzhFAao
			r+dMpma78qobA7AgHxN+Xiaqa+2UWx3OfRgMjbvz9zQS6ufBfeO6KBwTt1FAJiIiIiIiIu3GmQ1n
			xP1slB1II9sjhD6TL2VqgmbGOrt6MPXOX7m7EiIi4mbTe4UwoIsf720qYNHecqrqHFjrHNQ5wO5o
			my5l5VY75dbDQzabjAY8jQZ8PE34exqZ2jOI64dG0C3Yy92HRzowBWQiIiIiIiIi0kbimHrnne6u
			hIiISIfXLdiLhyZFcf3QCH7MqGBbThWZxbWU1dhxtFFI1sBoNBDsbSI21IuBXf0ZFxeoYEzaBQVk
			IiIiIiIiIiIiIiIdQLdgL+YMCmPOoDB3V0XE7TTyt4iIiIiIiIiIiIiIiHQoCshERERERERERERE
			RESkQ1FAJiIiIiIiIqfNaNTPSxE5OQ6HQ/93iIiIiNvoW4iIiIiIiIictpDgYKw1Ne6uhoj8jBQW
			FhESHOzuaoiIiEgHpYBMRERERERETluvpEQyMjOpq6tzd1VEpJ1zOBxYrFaSU9PolZTo7uqIiIhI
			B+Xh7gqIiIiIiIjIz9+gQf1ZsmQ5JpOJyIhOGAwGd1dJRNqpyspKMg5kgaOeQYP6u7s6IiIi0kEp
			IBMREREREZEzYsqUCWzduoPVa9dTVV3l7uqISDvl7+dPbPdohWMiIiLiVgrIRERERERE5IwZNKi/
			LnqLiIiIiEi7pznIREREREREREREREREpENRQCYiIiIiIiIiIiIiIiIdigIyERERERERERERERER
			6VAUkImIiIiIiIiIiIiIiEiHooBMREREREREREREREREOhQFZCIiIiIiIiIiIiIiItKhKCATERER
			ERERERERERGRDkUBmYiIiIiIiIiIiIiIiHQoCshERERERERERERERESkQ1FAJiIiIiIiIiIiIiIi
			Ih2KAjIRERERERERERERERHpUBSQiYiIiIiIiIiIiIiISIfi0ZaFGwwGd7dPRERERERERERERERE
			pJk2Dch8vL3d3T4RERERERERERERERGRZjTEooiIiIiIiIiIiIiIiHQoCshERERERERERERERESk
			Q1FAJiIiIiIiIiIiIiIiIh2KAjIRERERERERERERERHpUBSQiYiIiIiIiIiIiIiISIeigExERERE
			REREREREREQ6FAVkIiIiIiIiIiIiIiIi0qEoIBMREREREREREREREZEORQGZiIiIiIiIiIiIiIiI
			dCgKyERERERERERERERERKRD8XB3BVpisViora3D7nC0an2T0YiXlye+vr7urrqIiIiIiIiIiIiI
			iIi0c+0uIKuoqGTzlm1kZ+dSZanGcIL16wF/Xz+iorowZPBAAgMD3N0EERERERERERERERERacfa
			VUBmsVj4btFSIsLDOH/sSPz8fDEYjh+R1dfXU11tIX1fJt8tWsol06eqJ5mIiIiIiIibWCwWamrr
			cLRyRBAR6XiMRiPeGglIRERE3KxdBWRr1q4nPCyUwYP64+HhgcFgaFVA5uPjQ1BQIJu3bGfN2vVM
			njT+zFasppr0shZ+3Jk8iA3zweTuAyciIiIiItIOlFdUsGPHLg5k5VBdXe3u6ohIO+Xj40O3qC4M
			HjyAoMBAd1dHREREOqh2FZClpWdw6cUX4u3tjclkanVAVl9fj8lkIqlnAl//7/szH5Dt3cTUt0rw
			9DAS4NGkPhFRfPe7QYSfwV05aiwUVtrxDAjA7H1mmyEiIiIiItJWqi0WlixdTmJCDy68YCImk24l
			FJGWVVRUkJqewXffL+WSiy/ETz3JRERExA3aVUBWWVVFcHAQHh4eGI3GE4ZjDerr6zEYDAQHB1FZ
			VdVm9YuOCefa2CapVWAoPmd4HxXJW3nkmyIGzLiEu/u3WVNERERERETOqLVr15OQ0IOY6Gh3V0VE
			2rnAwECGDBrAxk1bWNsWIwGJiIiItEK7CsiAZj3HWhuQARgMhja/QzGmZwI3TW2pv1g9dquVoio7
			VXZwAF4eRsyBPgR4Gg+v5qijsqKWkpp6agGjwYC/jydhgV6YsFNRZCF1XxnLihyEllWSng8hwQGE
			eTu3rSivpbi2Hhvg5WEiPNgXXxNALUX5tZSaTER6OSiy1GPz9iI+2KvNXy8RERERERGA1LQMBg8a
			4O5qiMjPSFLPBL5ZuFgBmYiIiLhFuwvIgFMKx05m/TOtrqqc7T/t5NW1ZeypNeJw2AkK8mfm5H5c
			MyCcQA+gvpairP389/tMvjpoo8QI9Xbo0zOauy7pyQBzJcs/XM/T2XUAfPvdKtYsgWtmXcRvkpzb
			frQwna/zodLhIDQwkBsuG8LF8f74GDJ59a/JvB4WxmOJNXyTCWU9e7Dosli3HRMREREREelYqqqr
			NKyiiJyUwMBAqqrbbiQgERERkeNpdwHZ6QRdbR2SVVdZSM+vbHzs5+9LF786Uhat5bo1DuITI3lo
			hJmwyhI+XZ7Hsx9spDZoAr9O8KGuKJVnXk1nsVcwV43pzrRoSNuYw7yd+/g/i4FPb01k2LSePLkm
			hTu31DFxVE9ujoPQKFzbZrCuUwT3XRZBDFUs/W4/v39rA50eHM/5Qa4KFZXwfZ9+vHV/LAHGU2uj
			iIiIiIiIiIiIiIjIua7dBWTt2Za127hmw+EQbtSUkcwblsdbq2sxdY7h5dsGEeMKpoZ3/oldLx1i
			3opM7khIJHPFfj61GLnzmhE8MMA5c9mgPl0Ifnk5dyZn8d2hvlwb3wNTeioAnWN6MKgPgJ3URfv5
			1OLFQxf3pa8rDLt4aD4vLyznu91Wzh/pqpApkLsvVjgmIiIiIiIiIiIiIi2rrLFTXefAanNgs9dT
			X1/fpvszGAx4mAz4eBjx8zQS4K1RB6R9UEB2EqJjwrk21rvxcWiMFxwo5lsHDOnXpTEcAyDezFgO
			kVxQTTEl7Mm0AcGM7efTZKVABiV4QVoNB4qAri3ttYTdGTbAwdsfr+PDJs/EhvvhsFkPLwgLJEHT
			jomIiIiIiIiIiIjIEUosNsosNhallLD+QAXJBRYOVdRhrbO36X59PE1EBnrSK8KX4TGBTE0yE+zr
			gdlX8YS4l96BJyGmZwI3TQ1vvnCvCX/AUmOjDvBsWF5nxwJ4epowYcLLE8BBdY0DfBuSNAc1tfWA
			EW/PY+3VBAYAfx65Yyjn+xwxjKSnP1Dg7kMjIiIiIiIiIiIiIu1Qjc1BQWUdb27I45MtBZRa2zYQ
			O5K1zs7+Yjv7i618n1LCvJXZXDU4gluGdSYiwBNvDw2JJu6hd97pigrnEl8D23Zms7GwmgpLLdVV
			1eTsLGadwUjfnmGEYiYx3ptAQxWLfiomv6IGi7WG0pJiVqfV4u0byKAoZ3FGkzMAK6usptJiobLG
			TL8kL/yoYvmOWqodXphM3hjxoLrOC18vvYQiIiIiIiIiIiIicrTqOgfL08u4ecFeXlub1ywcMxgM
			cIZHVwz0NhEZ6EV0iDfdzT5Eh3gTGeBFkM/hvjqlVjuvrc3j5gV7WZ5eRnWdw92HSToo9SA7Xf4J
			XDcul9WrC7jv1fVcOyyU0MoSvtlYhaVTBI9N6AZA/Lh4btiZxoLvN1CWFckF0bBvcz6fl/owblw8
			kwKdxQVGBBDpVcPXS9aTUOlFeLfRXDYqll9sz+Db7zZQmhXJ1GgP7KXlrC0J4tGbBxDm7mMgIiIi
			IiIiIiIiIu1Kjc3B/3YX8fDC/S0Oo1hfX+8avez0BfqYCPPzZHpvM8NjgogN9cHfy0hVrYPMYivr
			D5SzcE8JRdV1VLhCuuT8an7zeTpPT+/OjL5h6kkmZ127CsiMRiN2ux1PT89T2t5ut2M0tsGHyNuP
			+E51dPFvafJAI/EXjuD10F28taaMLzcVgtFI797deODSfgxyBV8EJnDvnR7EfH2AT3JK+U82+PsG
			c/Olsdw0rEtjaV79knhm6C6eS7fx8TYbv+kNhPXiqVs9iPnuIN9mN2zrxfBBoTiL9yKsUwDxYT5o
			ekMRERERERERERERWZNZccxw7EwK9/dk1uAIbhnuHDLxSPFhPkxODOG2EV14c30eC7YUUFhVBziH
			X3x44X7C/b2YmBDs7kMmHUy7CshCzWYKCgqJju5GfX29s4tnK9TXO/uBFhQUEmo2n/mK9RzKoj8c
			bwUfYoYN5fFhJygnOJYrr4vlyuOtYwxj7FXjGHvk8sgEbr8xgdtb3CiW2/8Qe4znRETk3FVDaU4x
			VYBXcCci/HWbhIiIiIiISPtUj62miurqWmpqrNQ5AKMnPj6++Pr54uNlOlMdeUQAKLHYeHrJgTYP
			x0L9PHjkghiuHBB+wnUjAjx5cFI08eG+/HnRfoqrbYAzJHt6yQEGRfXG7NuuIgs5x7Wrd1u/vr3Y
			tWcvIeYQ/P388PBoXfXsdjtV1dXs2rOXfn17ubsZIiIiZ4GdyoL1zP/TVyQHeBB3+QPcOzb0DJRb
			Q2l2BR6dwwlQ3iYiIiJHsWMpLaHa7k1gWCBe7q7OabYhIDQQ72Ndka6toKiiBpOvmRA/fTESkVPl
			oLaimMKiUnL2rWXdujRS0/aQW23AFBRFUlI/hg4/j97REZjDwzAHeKFB5uRMeHl1Dsn51W26D19P
			Iw9M7NaqcKypKweEY62z8+SiA1hc848l51fz8uocHpkS47ZjJh1PuwrIhg4ZxLffL2H9hs3E94gl
			KDCwVduVV1SQvi8Tg8FZhoiIyLmvmJX/ep28q55n3pQzEYw1SOfj+z4jet4fmRbh7jaKiEhHZK8u
			pdTivJsYryDCAn+eEcy5q4TNH7/Kj0VJzHzoCpLcXZ1TbMOWz19jRXESv/jtTPoca5aHzEW8+lkK
			4effzi/HntyFP4DaikIqao9YaPInJMS3cXoER20VFVVWbI56wIDRwwf/QH+8Gq+OO6irrqTSUosD
			wOCBt38gAd7NAzuHzUp1ZRU1pkDCAr2af46O2KeInEUOKyW5mez4/j3e/i6ZovJiymsADPiHxxEf
			Yidr3ef8+O1/CQrvxtBLZ3PVhP7EdTHjrZRMTkNFjZ0Fm/PbfD+TE0O4bmjkKW173dBIVmeU883u
			4sZlCzbnc8/5UQR666wlZ0e7CsgApl04hU2bt7Jp8zYqq6patU2Avz894rorHBMRkQ6ihtLsfEpr
			wWyycjC7kBBXjy9bZSF5ZYevxHgFR9KpWVewGkqzi6hsfOxPRFQw3gA1ZRwsLKKSWkrzcjhYe+Rz
			h8/LAeFdCfE+XB7hYVBYRGXT8kRERE5ByeaPeW1lOQHmADzjL+TOC+JOr0CblfKqauq9ggn2/ble
			bHFQW1VBdY0Jv9CAn2mvrbOkVa+3iUBzJ8K8wglss/HM7KR9/ypfpprw9PY43BskdCw33jSCMIC6
			SnJ2LmfRur2U2z0xOeowBfVk1AUT6NctAE/qqS3PIWXdD6zcnU+dwYjD4Ef3ERdyweDuBHoZcNRW
			Ul5ZQ0X+Hjb8sJqUzpfx0OVJlO/5nk82FGItL8MSMp5f3j6Gk4/4ROS0OKwU713O68+9zmZ7J/pN
			n03vtS+xcC+AF2PumcdD5/tRvXIuM1+o4eIZQexd8jKPLh/Cr35/G2PiQ/FRSCan6JtdRZRa23Zo
			RQ+TgZuHdz6tMm4e3pnvUkqw2Z1TKJVa7Xyzq4jZQzqdtWMlHVu7C8jA2QtMYZeIiMixHGTRP95m
			UQHYPptHhncMVz/yK4Ybc0j+4QP+varIdYKvIWT4rdx9cS9nSGavIj9vM1/MXcgOV4Jlq0zkqseu
			YExUMN77V/C3/yynlAp2vDGPNaZR3P3cDHrWlHFwzVc8+c1uZ/Blr6LXLx7jxnHhBJjS+fi+v1F5
			x2+J+OYT1uPaxt2HSEREfuZiGH/DJSSYzsAtF4e28tW367D3uY4bR/9cI4IqMlZ8yg8pnZn4u4t/
			pr22zpJWvd5m+l9+K/3btCLllJQBnhEkDomlcXwc/674uv5pz1zGx9/vpD5yAGNG98JclszqNdv5
			7hMHQb+ZQbyxkpTFH/FNpifdEgbTN9qPnJQNpPzwGf/zvpWrBoVQve8HPluSQTV2LBV2cF2nNA+8
			jBt657Pu3ff4yd2viUiHZKNi/wpeefI10uKv4vHfz6Jn+gvMeKfheRPG2jIKS6qpqzViKl5DQczX
			/P2f01jwzDO8/Pgr2P5yD5PjAtvnxVtp937cV9bm+4g1+zA8pnUjwB3L8JhAYs0+pBVamtVdAZmc
			Lfo/VkRE5Gcnnquf+z2Bf7yfrKvncnt/wF7Fqpce5w37LTz73CjnXcmk8/FvnuOvXg/xzOXR2A98
			x1+fWs3IB//BPFeCVbTqRe5/6EMCXruT4T1nMO+5BF6d9RnRjzQMsWincuOHPPRZV/744lxn8FW8
			lrkP/JPvE57gimhnOT8t2M+f/zOX6919aERE5BxhwtvPDz/Xo3q7lepKC1ab607oI4aZq7dZqKyy
			UGtzAAYMHr4EBfvhqCikIi+DrIJqzJWlFBXhnE/Ko9o5t5SPP5511Vjt9XgFhhPo5aCuuooqay32
			eteQd55+BAb64tGankaOOiyVVVjqbNS76ukTFIJPrXO4O+c+XOvaLZSWVmFvMoykvaaKyuomw+15
			BRDs56C89BAH9h+ixOpHRVEhRRye/6veXkN1ZXWzY+PlF0CAjwcGaDKPVgh+9ZVUWG2AAQ+fYIL8
			DdRWVlBZ41xm8gkk2N+Lk+5UVW/HWl2JxVrnHAYQIyZvfwIDvDHZqigps+DwDCA0yKex7Pqacoor
			azH5hxLiYzxxO1o4XkfOh8axXu+j5g9raR41Zy+9KmsdDgwYPHwIcpzOe7gORx0QlMSYCS333iov
			LsYGdB9yAcN7eWN0RFOduZ3vMospqoJ422bW7q3BlHQhV/+iH97AkL7h8NrH7Fi7hfwBE/Gx2PGP
			GcL43rUs+XQdJQ2Fe3jj5+GrIdpE3MRetodPnvk3e3r/hucfnkyECUoO7OPwbFDVfPfsQ5Se34Xc
			leuoBn7avQ/G9mbWE88Q8fTvePGZT4j66430C/659n4Wd9p1yPluMxgM1NfXt8k+Bkf5n7Fy0got
			jXVtqLvI2aCATERE5FyQv5LP18Qz5+WGcAwgnqvvOp/P3t7Focu7kv/9V2SPe5irm3TvChs7hznL
			fseG3b9k+OCWfngVsOyrtQy+Yi5+2TkcBKA7IwYe4JttBY0BWc+rxqvXmIiItJnaQ1tZvmwnmWUW
			HA4bNocf3UdO48KhMfgbrRSkrGXZ+l0UVkI9YAjoy8ybJ2FZ/SEL9zjvSC7b8T8+2GskbPh1zAlZ
			xqufpWDuN5rYslQOVNcTN/V2LogtZ9+axaxLz6e8zkG9rQZj+EAmXTSO3uHexw+O7BZKc1LZ8ONa
			9hRZMBiNGIw+9Lr0dgbt/5jXVhaSdMXDzGw4YZZu5pNXV1DY6woeujwJ6irJ2rqUH7bsp8JmwEA9
			nlETuHZCDQs/XENuFUAWKz/8kLXEM/0304m3Wyg+sI3Vy7eQUVGH0eDAUe9H5ICxTBqeRCc/U+M8
			WqHDZjLKtp7VaYVUVNUR3m8Gl4z2J3PVMjbuL6G6upaApKlcedEgwr1PMiKrPcS2H5aw80AZ1Y56
			7HU2/LqP5qKp5xFTs4XPX/+R/Kgp3HPtcPwNAPVYdn7Jq4sOEXvJr5ndx3Didhx5vIAj50PzONbr
			Pdx8RIWPnketriKHXT9+z8rkEuq9fPEO7cH42Nqjm9rSvGINms31VU15NeBbTWlRIYYWwlZzbC+6
			BRaSk7KF7KgE/KxppOR5EditF92DgH0llADBoeGHh9X0jiU6Anbs2092FZw3+DJmDQaKVvPD2fgw
			ikirVG74iC+y+/C7pyYS4fqZ5R0chjdQ07CSdT/rFu93PTASERLs/Kcpgol33cYPN/2DzzZdQb9J
			we5ujvwM5ZbXAVDvqOfk73xpnc5naJ7YhnIa6tpQd5GzQQGZiIjIuaCwgAyv7nQLPWJ5eARx+3Mp
			ppi8bOg5PuKIFULpHAVLDxUDES0UXEzeftjy2Twymo1y1RWiDs9JFh0ZioiISFupzs2mOrwf40aF
			41tXSPLKVexY9iX+UXdxof82vvlmHQXhA7nggiSCKCdjayk1QJfB05jms5ZP1mbhnzCOi/oF4h0a
			BAXOckv2ptDjsuu5Pb6hr1oJ2XmeRA+bTEywB5astSz9aQNfLo6gx+xB+ByzhvXUZK/l4wU/UREQ
			RcKAYfSK9qMqYzuVrbxp2565jM+X7cIzdiwTh3fFtzqP7ftt2AITOH+aB1u++5Zd5V0YNG0U0QTS
			hXpqslfx2cebqQ6Jo+/YAcT5VZOx/Sd2rvuCL+qu46YLYhqDlarkVST3G84F40vZsnI9adsX8kVe
			MN5d+jF5CqSuXsWO3d+yKKY3cwb7tK7SDSx5ZFdH0Pf80YT72Sjcs4LVO5bxVUA0v57am94Ra8jP
			SmF31TCGBRigvprk5CwMvn0Z1tuXmuwlrW7H8Rzz9T6ReivpSz7iu71GQuMGMGxADBzczo8bDxy1
			ava6T/k+/RjlmIdzzTVDcMZxNhz44m9PZuF726mz2fHuPJhJU8eS1MkVooUPZMKIDBb8sJr/frQB
			g6MWS30UkyYOJNwIBEYQ6gGFB9M4VOZPgAkctVlkFQDUUnOsoE5E3C549LVc9eXTrF2bxsDJCYT6
			GvHrO4bzAleyuuLoeaFMgd2ZNKgrAA5LMWk/bSCn+1U8MFLhmJya2sYe2W23jzPVL62xHMMRdRc5
			CxSQiYiInAs8PPDqEoCfHWjaEcxmo9bLAw9MeHiCOejIIRDs2OrA0+PYk9h7esHIW5/irhZ7mO12
			d8tFRKQDMA/8BZfWWKi11WF3mBnWN5UdK7LIy62CTqWUG8AnPJpuncLx9YkhrqeX83QYmUBC2TYA
			vMOiSYh3DXTnCshMcWOY3BiOAcQy/srOWOtqqbPZcYQMJWF7Fjtys8ljELHHrGENe1avo6g+hEHT
			r2FarOuukvheABQe4ISqyyupN0JQ11i6hgbjExVLj74eGI1gjrdzwBPAj67xCSQAYGHLqg0UGSIZ
			d9nVjIl0lpPQMwLDy++xYfM60ibE0MdVvi1yJL+Y4BymL448nvkmjZL6JG6bPpIwIMnzELs/3kVe
			bh4Mjj1xhZsKGsSMGRastXXU2R2Yh/UlbcePZOXlUsV5DBrWjbXfZJKSXM155/lD1S52HzAQeN4Q
			EjysJ9WO4/E71ut9IpYdbEyuwdRpPJddOYZII9CrF1Ger/LmmsJmq8aMu4EbxhyjHKM3h99NZnoM
			GUVsdDgUHiB7/z5Sszbw5RdGrr9lMt08nAHnN8uy8Ig5j4nDY/CtPsD6FRtZ/M0qIq6fQvfIPgyN
			28rK/av5+LMsugR7YC8rIL8GwIChDS96ishp8uvN9Y/exJP3P8XrPMz1Y7oTET6ea6/+kn1fZFJS
			WoXVXo/B5IN/iJnYSx/gsp42LCUF7F/9Hk9/ZOXGZ6+nt9/pV0U6pgBvD8qtNlfX+rbZR275mblT
			o7EcV10DvBVZyNmjd5uIiMi5IDKWQYULWZM2iagkf9cJvobS5EwK+g+kE6GYkoJ5fd16SgeeT4jr
			up2tMp3k7GD6TGraA6yWOlvDvyNI6O/Pf/emUzmgJwGmhu3KsPoGNz4WERFpM/W1VOZlsG3HLvJK
			Syiz2qitrACgtqYGogcxMiaTLVnL+HC+H5FJQxgxOImo8EC8TnBByNypc7P7SuyWYg7s3syuzEJK
			yy3U2CxUWAG79fCQWC3KIzsXCOjFwFhvTkVgr+H03VXOvu2f8u6uYOIHjGVw3xi6mn1p+XSbQ1YW
			EJxAUmSTxcZooqNgQ3IpJeVN2tqlMw01M7nmbvOPiz88NHNIOGagsOb4LW3hBaK2MoeM7dvYnVdC
			SUUdtroKKgCsNdQA4b2Hk7h0P7uSd1E9dBgkp5BlDGZEr2gg/aTa0SZysskCzD2TnOGYS2SXMKB5
			QGavrcZyzCEWDXj7NLxeYfSd4Dq68Qn0HzGG6M9f4KuUHezJnUy36FpS1mygiGgumjGJ/v4ACXS1
			Z/PitxtYu3cc3QeaGXLplfDDMrYerKCkxIQ5cRLD8z7nh0w//E+yo5+InGWRk7n/jwX8be5TzE2e
			xQ1XDqTb9Ed5tPMXfPnFevaU1eEZ3Jvhl/2CywaaKcrcyrZP32XBLjOX/PFBJkeefhWk4+pu9mZH
			rg2Dse3mINueU0WNzYG3x6lPeFljc7A9xzk6TUNdu5tP7buUyKlQQCYiInIuCB3FFdO/4tmPvqPP
			rQ3zkKWz8LP9XHrPnYQBYRfMZsSTHzJ/TTy/cM1/UrT+K36MmM1TjROIeRMYnEdacg4HHf5ERIVy
			/i8u4oPnPuLrPrdyvitHK9qymvLRVzU+FhERaTOWVL795Esy/BIYM3o8A81mIvMX8eL3Gc7nDZ0Y
			cfVtJB3YxsYNW0jfs4wFu1KZdss1DAo+mQs2dg6t+5QF6yqIGjqJEYMiCAm3s33+B2wsO/G2DjuA
			DYeNo35pm0zOyMRWd/jJersNR9OV/OK56NquHErdzLpNyWSt/5xdu4dx3Y1TiG7xOpEHHh6AvZaa
			Zj3Ibc4bXQweeJzgRhZv7zMxd4iF1MUf8VW6H/GjxzBucDjmTnksfvE7MhqrmsDgfoHs3pDC7sre
			OJKz8IiYwMDok2mHyfmUzUbjUay3Y3O0vqbHZDA4y6urxQE0vGtqa4+eA6X1Qywe/XqFBAcB5a6A
			rZKKCsC/MxG+h9fyCe+MH1lUVFQC3uAdyZCLZjPE9Xx9TRrf/gdM4bF0U88SkXbPr+cs/vRcHxb8
			ax7znviczgMuYOTQgVz2q3Fc5lqnrDCZZe+tY9G2XDzipvP752YxQL+z5DQNjgpgR25Vm4VjAKmF
			FjYdrGR0bCuGMz6GTQcrSS10zh/aUNfBUQFn92BJh6aATERE5GfJREBE18aeYAA9r5jL/TzEvH9s
			bFx2/j1zuboh/Aodxb2PwT/+Mo+/NazQfQZP3TPq8N3jxDP1+iE88d95/I1R3P3cDHr2nMFT12fz
			xNvzWNOw2ujbmBcK4E1IVFfQDV4iItJWslNIt0JI/5EM6RmJwWYlN7lJYmUto7DWk4AufRk3ozd9
			17zLO+sy2Z1hZdAgPzCaMAJ2axVVVn/AC/8Wd1RKZloREMeAMX2I9ainrmoPxZWtqWQXevTwYdfe
			FLbuPY/A7r74eICtpoZ6nxDM4eF4cIjcjDQq4mLxpI7KrByqmpRgryymAj+C44ZxUewAUhe+xtcp
			u9lzaArRMSaMJoBaqiotWA1g9I+ge6wPO/amsTNjGEFdffAy1lNbncG+XAOe5h50DQLy2/oFOsje
			1BoIHsTIIUlEGm3U5O3hyEwxulcfgjatI+WnddRmedB1+iDX949WtoNQwj3gUG4G6RU96O4JdRVZ
			5FYfsaOWXm+fEySFEd2I8tjF/n3J5AwNJszHBLUWUtNyj1q11UMsWisostbj4+WFiTpqLIfYubcE
			g1cMUWEAXvgEemEo3EdqThnmcB9MdiuFafuoMHoR5ucML2urSrHWe+LpYcRRW0P5ng0k1/gRM6ZP
			k+9vItKuhQ5g1hOvccWhPfy47Ft+/HwZX5YdDuA9g7vTe+RUfnf1KAYo+ZYzZHJiCPM352N3tF1A
			BvDW+kMM6OJPgPfJDy9TWWPnrfWHmi0zGQ1MTgw5m4dKOjgFZCIiIj9LoZx/z9yjlva8Yi7zrjje
			ZqO497lRxy05bOyvmDf2xMuc4rn6ubmIiIi0Gd8wInw9KNi9mlWBPQgoP8D+rCY9e7JX8/EqG316
			R+JHNVkpZfgERtK9s+siY2AnOvmkcGjnD/zg2w0v38FMbfHGZF+CwwPwKs5i/bKN1ETaKU7bR4k3
			UH2iSvrRd8R5bDi0hZRv3yM/oT99Oxso2peOx8jbmNo1jtjAdDJ2LeZ/XoOJMeWTmpqHrUkJpbu+
			4fMDUfTpHoBHXREp2fX4m2OJCgcIIrSzP16Fmaz5fi1WLy86XzqWviOGs7lgEzu/WkBJv37E+VnI
			2LWDXGMYvc4fTvSpj3h0EgIIjfDFo2gna1b5ExdQTtaBLI7qe9VtIIMiNrJi0wbwiuXihIaLwH6t
			bEc34noEkp6+g8XfeDM4xkR+egp5R/Yga+n1HnKCKCmoNwN7rqMgbT0ff1LB4AHh1B9MJbfcH7A0
			W9Xk7UerLl8fXME7y0pJiI0ljBxS9mZR4ggmcuAY+oUABNJv5AC2F+1m83+/oGpwEubyFLbsqSao
			8wBG9g10FrP6M9ZVRtKlkzcV+/eRnl+LX49xXDjY3JpaiEg74hnZm8mzezN5trtrIh3BpMQQYs3e
			pBdZ23Q/3yUXMzo2kFmDO+Hr2fovHpY6B59sK+C75OJmy2PN3kxSQCZn0Vn5uiwiIiIiIiJySrqN
			5JJRPekSUEHGtp2k2/tw4fgkwsLCCfEzQXA03bwLSd22nW3b0igP7snwaVcxprNr+8ihTBkWR6eA
			WnL27Mfh5wtegYe3b+RH3ylTGRATBrm72bbrEEHnT2d4l3DCwgI54WCE3cYxe+ZEBvQIhkNpbNu2
			jwJTFFFmwH8AF007j7hO3pRn7ia5OJwx08cSFxZOWKCzZN+ucYTV7GfXtu1s251HfbcBTLzsQvr6
			AZhIGj2Fvt064VWURnK5h7MXXLexXH3ZRAbE+VCduZttuzOoDurB8GmzuaSPK8Zpqa0tLTP5EtKk
			Psdmwjek6THpysiLR9GzSwDlmdvZlWGn94XjSQoLJyyk6fxpYQzoHwYOAz49h9O3aTe+1rQDP/pP
			ncbQuE54VWSwa28hYWMuYWzMEa9PS6/3CdvgR9+LruT8vt0IcRwidXsyRWFjmXF+bAvvk1YKjiTW
			r4a8zN3syiyF4FgGTLycaybFNXa8946dyjWXj6NvuI2c3dvZlWMjPHEUM66aSpxrJf/gQBxlOaTu
			ziCvNogew6Zx7WVDMB95NafVr5+IiHQUt4/qgs9pzA/WWk8tzuKb3UWUWW2tWr/MauOb3UU8tTir
			2XIfDyO3j+rilmMlHZehtLTsjPezdDgc7NqdzNgxI93dPhERERERETkLnnvhJW67+frTLqdw1au8
			tjKUyx+cSU+DAaPB4O6mOdmrKSmpxt7CUyY/M+ZTCVHaKXt1CSXVLbYUP7OZU2uqncKVr/PaGhvD
			Z9/F5Bh3t/IcV1+Po76ANa+/zkrG88vbxxDu7jodw+tvvcd9/3eXu6shInJOumXBXpamltDGIy0C
			8H/jorh6UARBPib8vUx4GA9/h7M56qmqtVNutfPx1gJe+DG72bZGA0xONPPmrJ4nu1vpIFatXkff
			Pr0wGs9s6KshFkVERERERKSdsVB08CAH/cKJCW8n87FUpLD0vxsoaeEp89CruHLIuTPkXXnyEv67
			qcWWct5VVzE45GRKs2GtqsVuy2XLzmK8wkbTu5u7W3jus1fkk116iNI6wNPdtREREXd5aEoMGcVW
			9hVZ2jwke+HHbBallDCtdyjDYwKJDPTCaABHPRyqqGX9gQq+3VPM7kPNx642GqBHmC8PTdHdM3L2
			KSATERERERGRdsPkZyY8vITd33/H7rgL+OWUOHdXySlkMFf+crC7a3FWmIdcxS+HnKnSctm6PJn8
			Q3tIrevEgKkj6arJHtpcedqPfL+pBLzCCQ/x49zp3ygiIicjMdyHZ2fE8ftvMjlQbMVqc5x+ocex
			+1B1YwAW6GPCz9NEdZ2dCqu9xfV9PIzEhPrwzCWxJIb7uPtwSQekgExERERERETajTMbzoj72ajI
			yeCQKZS+ky/mgnjv0y9STkifIxERaTC0WyD/vjKR55cfZO3+ckosNuyu7mQGg4F6Rz20wYjWFdYm
			wVg9GIwG6uud+zUZDZh9PRjVPYjfTeimcEzcRgGZiIiIiIiIiLSROC745e3uroSIiEiHlhjuw8tX
			JvDhlnw+2VpAVmkt1XV2rHUObNDmwy8ajeBhBB9PZ6+y6BAvrhoUwezBndx9aKSDU0AmIiIiIiIi
			IiIiInKOmz24E7MHd2JZainrD1SQUmAhv7IOS5399As/Dl9PE50CPEmK8GV4TCCTEkPcfShEAAVk
			IiIiIiIiIiIiIiIdxqTEEIVUIoCmxhUREREREREREREREZEORQGZiIiIiIiInDajUT8vReTk2O0O
			/d8hIiIibqNvISIiIiIiInLaQs1mrFaru6shIj8jhYWFhJrN7q6GiIiIdFAKyEREREREROS09evb
			i32ZmdTW1rq7KiLSztntDqotFvampdOvby93V0dEREQ6KA93V0BERERERER+/oYOGcTC7xaTeSCL
			iPAwDBjcXSURaacqq6rIOpiN0Whk6JBB7q6OiIiIdFAKyEREREREROSMmH7RBWzavI0NG7dSVV3l
			7uqISDvl7+dPj7juDB0y0N1VERERkQ5MAZmIiIiIiIicMUOHDNRFbxERERERafc0B5mIiIiIiIiI
			iIiIiIh0KArIREREREREREREREREpENRQCYiIiIiIiIiIiIiIiIdigIyERERERERERERERER6VAU
			kImIiIiIiIiIiIiIiEiHooBMREREREREREREREREOhQFZCIiIiIiIiIiIiIiItKhKCATERERERER
			ERERERGRDkUBmYiIiIiIiIiIiIiIiHQoCshERERERERERERERESkQ1FAJiIiIiIiIiIiIiIiIh2K
			AjIRERERERERERERERHpUDzasvDq6mp3t09ERERERERERERERER+hvz8/Nqs7DYNyJJT0tqyeBER
			ERERERERERERETlHDRk8oM3KbtOArC0rLiIiIiIiIiIiIiIiInIqNAeZiIiIiIiIiIiIiIiIdCgK
			yERERERERERERERERKRDUUAmIiIiIiIiIiIiIiIiHYoCMhEREREREREREREREelQFJCJiIiIiIiI
			iIiIiIhIh6KATERERERERERERERERDoUBWQiIiIiIiIiIiIiIiLSoSggExERERERERERERERkQ5F
			AZmIiIiIiIiIiIiIiIh0KB7urkBLqqqqqamtwWF3tGp9o8mIt5c3/v5+7q66iIiIiIiIiIiIiIiI
			tHPtLiArKytn67Yd5OTmYbFYWrWNr68vXbt0ZtDA/gQHB7m7CSIiIiIiIiIiIiIiItKOtauArKqq
			msVLfyAiIpzzx4zAz88Pg8Fw3G3q6+uprq4mPWM/i5f+wLQLL1BPMhERERERERERERERETmmdjUH
			2dp16wkPC2PQgH6YzWZ8fHxa9Wc2mxk0oB/hYWGsXbf+7FXYWkVKbiVlthOtU0Xr+sKJiIi0A9Yi
			UtNyKbedflEiIiLNWItITSvC6u56nJGmpJNadC60RERETpa1KJ3UnHJa85Oprc4XJ1MHkTbTmu92
			tnJyzvo1BjvlOWfos9du2yhnQrsKyNL3ZdIzMR5vb+/GPy8vr+P+NV23Z2I86fsyz0hdLCXlpOQe
			688ViqVuZvrfV/N98XEKSt3M9L9vJtndB1dERM5dtnJy0tLJKbefmfKSP2DmrGdZUnz6RYmISMdj
			LUonNa3pX5MLCskfMHPWB6S4u5JnQMr865g5P83d1RARkVazUph2xDnqFAOmlPnXMfOvKyht7bqt
			PV+c4GZFW3lu43n1ZOogHVUL7/m0MxzYtua7XfEKnjqNawy28tzGOh/9PdP5d/T1kFKW/PUMfVc7
			C20U92lXQyxWVlUREhKMh4cHRqPxhMMrNqivr8fDw4OQkGAqq6rOSF32r9zMva53va2ygnSLB/ER
			vq4D5slvbx3DhT7+JHUxEtxwFK1VpJRATBd/fN19MEVEpMOwZnzKU7fOp+rOt3ljTvTJndytRaQe
			hOiEMHwalvmEkZhQQ1C7+pYgIiLtn53ynEx+/PRB3lzTeFbBWjSCuYvvZuBZqIGtPJeMSn/iuga1
			rx+7IiLiVrbyXDLyt/PJPW+zMcjUuNze4xIeuWU8vWK7nNTvH5+weBKr2+Bck/klt163gds+fZEb
			Yk1HPGkn+5snuf790byz8Pq2q4OcQ9J4e9Yv+SoqnvCmF6svfYLPr01wd+VayUrGx8/yK89fseTG
			BFLmX8d1X0eRGObTbJ2YKQ9x14TYJtc2TAR1jT9iPZGjtbv/QxuCsYa/1jIYDBiNZ65DXK8ZE1jo
			+nfBou8ZuTmC+Q8MIaLpSqFDWPhAk8epm5n+Fnz6j/MZ7M6DKCIiHYiVTR/MJ2DqRHYuW0zGzFtI
			PJnvf8kfMPM2eH9jkwuXvebw+QJ3t0tERH52bDl88dhvWDBxHgsXHL7okjL/g7NWhdLlzzJzyQR+
			+NelhLv7eIiISPtgKyfl4yf51dcVTP39K3w+IaTxqdLlz3LjPc9y0RMPc/PwJjcNnkDSte/zeVvU
			tdc45phfY+maHObEHnHzoy2HFcv2Mu7euSQBtFUd5Jwz40/vc/8gd9fiFFm38fa7/jzwRZNA79In
			+Pyefk1WSuPtWX/kV+/24f/++wCXhPkAIUz5w/tMcXf9pd1rdwEZcErh2Mmsf8Y06TFGSTkHSpxd
			OQ/kluOH6Zg9yWyVlaRXOBofh5qDiFCYLSIip8K6jYVLxzD5i1kkXXcHb2+aw1/GHH1Scd4xWX14
			gTmKaLLJyi4FICstHT9CnHdbtdSrzFpE6sHSw9v7RTS/O79hm1hPijMLaOjPbe4WT7jOcSIiHUPx
			VtZtHc0jLza/Iznp2jlHr2srJ+d454vWnne6QdbBUvALI5wi9uVXQ3UB+9LSKWm6zXHLc/Z8O9T0
			NHnU+ctKYVo2JY0rRLV4CI483+o8KCLiftaMT3nm3WxufPUrbu3V/LmQCffzDk8x49cvM2DVHxnj
			4zwn1IY2///7yB7K1qJ0smjei6Wl31wt9V5pWM+/Uyxdg47sJZbAxOsieHvZarKvnkX3JldubQdX
			s3TvGOYMCXG2q4U6WIvSyWo8WfkR6eoZd/S6rnOfd9NlVgrTSvA6yd508jPWyt/xzd9Xx/p+0/y7
			Usvv7yaO+C7Y8ufFTvnaRaycOJkHQo/XkARuWvAK3R6fze9e3MaUx0fg43qPVwYcrsfx2uG+Noq7
			tbv/7k4n6DrrIVmTHmO+Kzdz7zbn2/2F9zfjSxD/eGAIR5x3sVVWsnHpTzy21+Q8+DYLI8aM4dfD
			FZKJiMjJcn5ZXDp2PA+EJjDi3jFctGQDD444v9kPGmtROtv/+zpPLMlyBV5WCkc/wWthf+Whj4sA
			ePnRFHyYztwFc0g6oleZrTyXjJUf8Ku3tjSWa+02iSfu/AUDGkK05A+YeVspc98exKanPmIbYC/P
			pd9dH/PHi1t/J6aIiPyMeQQR2Wk5C5fOIe78410wKCUreQVfHON8cVLnnX9G8ea8ZTDoWm5mPq//
			mAuV2fzl0WWYBv2SN/8wnoCjyrNT3m0OC569lHCsFKbt4pN/z2XxQdfZylbOeTc/z02NbbBSmLaC
			V5sMy2WfcAe/LAHMh1tlK89l8zev8Jev9mFqUs7tkxWSiYi4j50dX75Gytin+GevltcImXAlV/rd
			zMJNDzBmTBVL/nod+25Z26zHzZE9lFPmX8d1vMYOVy+WY/3m+rFZLxfAWsTmj5/l4e8OMeE3L/Jo
			k95sDZIu/S3j3viUFQevajLMop3sNStIGXslI1xBQUt1WDK/yTDHlmgueOQerh3ShdwvfsOVB59g
			w+MjnPWz5fDFY9fx9+gXDi+zbuP5WV8watFcLjluGCHnjNb8jreVs+mTR3luueu9aCmi9+1v8uCF
			TYPUUrLStrH20Xkscm3T+aLHefTqQS1/H7SVk7N5IS888w1pDd/NzruJV24e3zxAsuXwxfw1zLn/
			j4ScsDEhTLn6MvxvXMWOR0YwzMM5B9mSKd/w8owwbOW5LHnrd7y2Mcj5Pc1SxOg/fev8nLuzjeJ2
			7S4g+7nqNWMCC+NWEv8W/OOBYw2xWEP696u5rzCGbx7o7fwtVbyH3z+7nGd8LuTvw73d3QwREfk5
			seXwxfzljJt1t/PL4pDxjHvyA764cfThH1K2cta+eDt/2XErL33qGoqDNN6e7xoWpO88+t8Gcxcc
			a24YKxkfP8mtX8fz2FvvM6Xxx9iV/HJWNnNX/ZHDHdaW88IX4/h0wfuEAKXLn2LG/S+zaXLTdURE
			5JwVOp7f/n4at7z4O57KfZzfTQg5xp21xztfnOR5J+0/LFlwi+vxNEb1uY+JSybwRuMQi1ZSjyqv
			lCXzt+EB2Mo38Pwtf2fnHf/gy2ddPd+KV/Cn627noTLn3J6Ub+D5W17C68l3G4flKl3+LHM+Ay5t
			qItzfoyH82bw6YInnefl4hU8es11PB/yQ4u9u0VE5GwoJesADJky6DgX2DvTYzi8timNv4zpcvK7
			OM5vrmasRaQufZn7v+7CY28913iOO0roUCaPfZoPmg6zaMthxbJMplw3tOV22MpZ++JveDmhyTDH
			ye8x5fYn8X/3RW4YcxXm6xqCA1dvtP0hmLc2WbZjFV+ZE7lB4dg5pyQ7ndSAw4+b9446we/48i2k
			9nqFz+8Mca6e/CbjrnuS/oNeYVZUkzL+EM9Ln77PneD6LvV7HvJreZ50a8anPPVEPjPff59nGr6b
			PT6bmS+GHA5sAWvGYtblzOG3xwi3j9IllpEsIqsYhnVq/lTBoid5KO8uVi640PkZSv6AtxuedGMb
			xf3O3KRdcmK2DBasrueasVHk55aTkltOSk0UY7rD53v2u7t2IiLyM+P8UTORqa4hNpw/pPaydE0O
			toaVDi3m7aVjeODVOa4fagAJ3NTaCXltu/nk35nM+dv9zX7AJV37V+aYF7Jih73JysP5v1+Pb/zB
			FjLhMmawkLXJ7j5SIiJytoRMuJ/PX72Prkue58E//I6nPt5Kak754fMScNzzxcmedy49wfmsxfJC
			mHKtc/8Fiz5g6djf8k7T82LoeH577xhSlq2noMk6v21yl3/IhPuZe+mR+6nmiqndKEhLJzUtndTi
			bowcC19tSnP3yyIiIscVSGRn8Pc6xX4ErfnNVVtCztKXufXVFG454hx3tBBGTBpDyrLVZLtOoM7f
			fldxfQs9zhrr8PVofj3C4DwHpaWT6tGHK3puZd32Uug1miv90thz0HkeLdi4goxZ1zPH3LDMTnZq
			GuZZ45q0Qc4VK199nAcfPfz3TWbTZ0/wOz50PDeNNZLT+L6K4ny2crDgiDKavv9Dx/Pbu4ez2fVd
			qjlnr86qmRfQvdhVZloR3YePhq/Xk9K4nmu+9Xsvbf17MiiCTsd4qrwqG/9AKEjLpdwG9JrDTQ3B
			m9vaKO2BepCdTcXVHMDO8oWb+a7ZE0EkdVHvMRERORlWMpasYPPYy3i0OJ3UYudSc4+ebF62mIyZ
			t5DoAxTksHnQMJ471bsAi7M5yHQuPuqOrQRGXQr/yS0FwlzLuhKtuw1FRCR0PI8uGA/FK3jq13O5
			dd103njRdV4Cjnu+ONPnnWOW55Sfs5UhI5866m78kAHDGPKHTPIBjrHO0fvJZNU/HmdxsyfiSbxU
			9wiLiLiPCS8vqKqsxkbYMS6EFpKeDCOv6AzYT654aN1vrgNf8NSCNVz0yqrDF+WPI2TIeMY92TDM
			ImSvWUHGrPuOHRQU5LDZbwOlj6bQvN92PEOCTEBnksbudfVKi2DfrkzmXPMKE3mPp9fkMKcbrFiW
			yZz7W3kjpfyszPjT+82GDG3u+N+nrEXpZKVv4LXGoQKtFAIzTlBGSJeusDWHfKB5v0xnr86Mlc/z
			4JLm2yQmTG/sWWUr38DCVROZendI6xt6KIMUP3+GtvBBT7r0Pi759Ws8eF80FzxyG1NCj5ijzw1t
			lPZBAdnZ5GHEC3/+dPcExumTICIip8O6jbf/nUl0wns8+GjTJ+xE5rzG25vmOIdz8vTCv7qKKhuE
			n8pZ38MLL0qptELzb3FWKkvAK9F0CoWKiEiHEDqeRxdEEjTuZj7ZcSMPD2vFOeNMn3eOWZ6Tp5df
			ixdNbdVVVPl54QnU0dKFVTu1tYBX0/2M5pG3NaywiEj7EkJi/whSmt5EeARb+V52bA2h1/0hgHOO
			5to6OzSJmupqq4+9i9b85vIy0zU2goPbtpKTNOg483S6hA5l6sRnea+14ZWnF/495/Cvf8+i+zHq
			MGLSGB5fsJ6Cmd1YuOoqbngckriKjGfXUzAelu6/iodbO5SddBBWNr14HQ9tvoLH3moYKnAnz573
			yxNvWVUK5qgWvn45Q+vzf//6cYagtpP9zQesnHUff2n1TbhWCrfuJmPi5MZ5+pppuIEr+QNmPvEo
			n+WEcMO7L3JDbJ2b2ijthYZYPJM8jATgoMZ2jOdDzfT1Kefr9VVYmiy2VVRRZmvNDkRERJysmxbx
			lflqnl/wPp83+3uFhyaF8NWSrVgBuvTigv0rWLip0PnYuTUFha5Hnl74U0vtMc9d8fSPXM7CJbnN
			zlXWwuUsXNqJ/j1C3H0oRESkvbCVU1B+xJ33Fk88e/pRWlbRujJO87zj4ekF1bXUHbc8O2WFzmEf
			u/aaSMayRWwuPHyWxFZOyuIVZEzqRVfAJ6QTKcsWkdKkbbbyvWxsOoRwaDy9zAtZuKTp+RZs5YX6
			rSci4mZJl97HtNz5vL0kjQJL8+eshWls/ugLfoq7gYm9AEz4B/iRsjXz8P/nlkI27dp67B2c6DcX
			QMxlPPrqfUR9/yRPfbSV7PIT9VQLYcqcq8lYtpqMfatZlzvHVb9j1SGBcXtXsDC5+bDG1sLDdQoZ
			Mp5xe3ezackiVjYMpdhrNFfu3c2mLbtJuWK0hleUI2SyaSlc9OjvGocFtRYepOSo9UrJajqktqWQ
			JUsWHmPIzhASe4fw1ZLlzT+PTb9HWjJZuC6HG8e2skejpZC9qct59eXd3DpnfIu9/hs/C73m8PmC
			F/n1INfwo+5qo7Qb7SogMxmN2Gyn/uvBZrNhMrqxSZGhXOhjYX1yOck5zUMwp+5MGRnEpu828H1O
			Ocmuvw0rt7Ou3H3VFhGRnxlbOWuWLMQ86/wWv4hNnn015q8Xs6bcDqHjue7mSr5+9BWWpKaxNzWN
			vanLeefLg87Vu/TiAnMaGzelsTe1+UU9pwSueGAaO195lg82NWyfxpIP3iB5+r1coV9QIiLSoHgF
			r320tfFcsTc1jb1LF/J11TQubJgv84RO77wT0qMPkXt3syk1jb055dhaLG8rX366gUogZMIsbq36
			jvtfWn64zpsW8s6iSm6d7bzAknTJvVxa9hUvNWlbyvKv+Hp/83pPvDmBLf9ser5NY/Oir9mo33oi
			Iu4VOp7fPjCN5Hfu47Wlac3OU0teup5b/wO/fmm267dVCCOmTiX7vQ8O/3+++WteW+933PKP+5ur
			yXqP/Odeov73KA9/tNV1njqOpPOZs38Fb3+4gYDfnWAeptChXDi9lM9e/YTNTdq35tNv2d9knclj
			l/PQE2uY0xg8dCZp7HIeemI54xI6u/uVkjZScrD5+77l3/4t6UzfqZ04uPXwd6BNX77ByqPWW8PL
			ry4+/N5b+grPbEng1mMEXEljb6Dnln/yQtPP46bFfLbZeUOVdfMHvBNwz7G/95UcPOL75of832Pz
			qX/gFW48xjYpHzT9fGZSGRBLlGv4UXe0UdqPdjXEYmhoKAUFhcTERFNfX4/BYGjVdvX19QAUFBQS
			GnrmJz/xCAykVyffow+Wjz+9uoJvYwN6c8vIQ9z33Wa+J4jn7h9CryPW6TVjAi+znPs+2Hy4nJ5x
			/E9ztoiISGuVb2FtcgK3zjrG3VRJ53Nr4p9Yu7mCSRNCSJrzHs9zPQ8/9qfGVWY88Z7zH6Hjue7m
			13n4hT+xhOk8/eFsknzD6Zl4eCSqkAn38w7PcusLf6Jx+OxL5/LZnCb7P2IbJx8iEhOanChFROSc
			5hFE/bIXeGhZ04XTef7D2Ycv6rXifHHq5x0g6VIemn43Lz/2Jxh4G2/8YXyL5Q25Y57r7uIEbvxw
			Lsz+Ew891lDIQH79n/eY3PAbLXQ8j/wH/nLX4bYNuWMez9+8k4eb1KCl8y2XPs5n+q0nIuJ2IRPu
			57MBw/jLXX/ioWbPJBBtruZQRhp7y8A/Mo6oCXccPpcAXPo47zxQxK3rghqvDfqEJ9DzBOeAht9c
			zdYNHc8jf8vhiide4KEi13nqmLVOYOLNlTz8dTy/bmEepuZ1CGHyH16Bv97N3x5b3rjOkDvm8cjh
			o8CIqdPomRHFxKQjl3ESN7PIz4fzO9ba+Ue+71v+7d90G+f3shAm//pe1jX5DjTjibncuuRPh3/n
			+4bTM/EGnp5d2+z9f+vf3jscVnkEEZXYheCGD1DSbD77G1zxRNN6TefpD0NcNwSv4YKpd7f42fAJ
			T6Dn2vlNvrc5t33+w/eOCJFNBHdNcIVg4BO+l7ea1G/IHa/wyATnHs56G6VdMZSWltWf6UIdDge7
			diczdszIk9pu85Zt5B3KZ/So4fj7+ePp2br8rq7ORlV1FWvWrqdzZCeGDB54do6eiIiIiIiIiIiI
			/GylfHA9D3/t/PeQO+Y1XjQXkbPPuvcN7rjLyMOLb9aQn9LMqtXr6NunF8YzPIJgu+pBNmTwQL5f
			tIyNG7cQF9udwMCAVm1XUVFJRuZ+TEaTwjERERERERERERFplaQ57/HZHHfXQkQA9m9cTuXNjysc
			k7OmXQVkABdOncTmLdvYun0nVVVVrdrG39+fuNgYhWMiIiIiIiIiIiIiIj9DSXPe4zN3V0I6lHYX
			kIGzJ5nCLhEREREREREREREREWkLZ3bARhEREREREREREREREZF2TgGZiIiIiIiIiIiIiIiIdCgK
			yERERERERERERERERKRDUUAmIiIiIiIiIiIiIiIiHYoCMhEREREREREREREREelQFJCJiIiIiIiI
			iIiIiIhIh6KATERERERERERERERERDoUBWQiIiIiIiIiIiIiIiLSoSggExERERERERERERERkQ7F
			oy0Lr6qqdnf7RERERERERERERERERJpps4DM29uL3XuS3d0+ERERERERERERERER+Zny9vZqk3IN
			paVl9We6UIfDgc1mo77e0eYHRkRERERERERERERERM5NBoMRDw8PjMYzO2tYm/QgMxqdlRURERER
			ERERERERERE5HWc6HIM2HGKxLSorIiIiIiIiIiIiIiIicrqUYomIiIiIiIiIiIiIiEiHooBMRERE
			REREREREREREOhQFZCIiIiIiIiIiIiIiItKhKCATERERERERERERERGRDkUBmYiIiIiIiIiIiIiI
			iHQoCshERERERERERERERESkQ1FAJiIiIiIiIiIiIiIiIh2KAjIRERERERERERERERHpUBSQiYiI
			iIiIiIiIiIiISIfi0dY7sFqtWK012B0Od7dV2gmT0YiPjzc+Pj4nXLekuo6Sqjrq7Of2+8fTZMTs
			74nZz9PdVREREREREREREREROee1aUBmtVrZvWcvBYWF1NTUuLut0k54e3sTER5On949jxuSlVTX
			8dH6g2w9UE651ebuarepIB8PBsUEcc3wbgrJRERERERERERERETamKG0tKy+rQrfuGkr1ZZqxowe
			Sag5xN1tlXaiuKSU1WvW4efrx3lDBx1zvZeW7SOrtIZ7LkggNtzf3dVuU5mFVfxrcRrRId7cNamH
			u6sjIiIiIiIiIiIiInJOa9M5yFLT9ykck6OEmkMYM3okqen7jrve11sPdYhwDCA23J97Lkjg662H
			3F0VEREREREREREREZFzXpsGZFVVVQrHpEWh5hCqqqqOu05+RU2HCMcaxIb7k1+hoUhFRERERERE
			RERERNpamwZkIiIiIiIiIiIiIiIiIu2NAjIRERERERERERERERHpUBSQiYiIiIiIiIiIiIiISIei
			gExEREREREREREREREQ6FAVkIiIiIiIiIiIiIiIi0qF4uLsCIiIiIiIiIiIiIiIichZYitiXV9H4
			0C+sG52DWo6K7OW57C+CiOguBJ6DadI51yRLwV72E0OvCB/ARunBfVQE9iA62E1NtZWRlX4I75ie
			dPJ199HpWCwlFWRajMR29efMH/oa8nNqITSQTj7ubqmIiIiIiIiIiIiIyIlYKfrpW577Zhcm1+PO
			A2/gjisHE9bCRfSq7V/wwhcw++FfMSoUZ7hW4kX3roGu7X/e2s0Qi7aybJJT9jb/K7CedDl7P7yR
			qz5Mcz0qY9kzNzJ3RZn7Glb8I3OvvZF3U9xXhY6phk3/XcfN/97GppN/G7VCNu++uJZ397m7nSIi
			IiIiIiIiIiIirZHNyh3xzH12Lv96di7/evY3JK38J29vafkietDYX/GvZ13hGMDer7hn3lrK3d2M
			M6Td9CArXfEPrnouncRuwY3JZX7ijbz/u6nu6/110qzkpxyApr3FPIKJTvr59x6z2WxUV1cTFBR0
			3PXKy8vx8/PDw8PNr5l1PwsP+jO9axULd9Uwdqi3e+sjIiIiIiIiIiIiIuJW8Vx2d3yzx5Mui+H6
			nencN7rv0atbitiXB13jwqAwk5y8CqgpYn9GJiWBnekR7hxezVqYSU7jqI2BdI0Lw/UMRRl50Lkz
			5OVR1uR5z/Jc9hfVuDY5XFbDNo3dnpo9d2a1r+Rp4K28+q9LCQcgjTcvuZNHFg/h3Ss7u7tmrZTG
			u9f+El5fy/2DXItCx/HQ/HHurthpcTgc7Ny5k507d3LRRRcRHh7e4nqFhYV8++239O/fnwEDBmA0
			uq+DomVXIav6d+erzhlctC2D0oG9CGl8tzcMj+iHV3k1uTbn0oBAP6IDnfGsraKSVIuJxCAHqcUO
			13bHGK7RZiEr305gp4Am+3AO8VjocbhMEREREREREREREZH2w0Z1ZQ1+nseIivZ+xT1Pwt8/uxmf
			H//DC0uLoMSL117ajmn0bfxrZjzWwkxWff5PvtrrDLHs5bFc/sQcJnYNxEQ6X9z/FKW330vU4s9Z
			g42KnGiu/csMwrf/lzdX5oOtgrxul/PKXZMJ87VRkbOaT+Z+x+4gD8BGRd+beOvmvq1v0kloXwFZ
			MwlMuymB53MKgc40zCdWG9a8N5atLJu0igASugW3qjGWgr3sL4bQY84J5uwFVtz42Ez3pIjmoYil
			gOQDJYcf+0eSEFZL2gHXdgf2kuzr2odnGVnplQTGRzUJT47chz+dmz5va9gmjNr0w+v5d24+l1pD
			WxqEttE8ZzU1NXz00UdkZGSQk5PDLbfcclRIVlhYyBtvvMGWLVvYvXs3SUlJ+Pq6qduczcKabRau
			nRBFiLmCcd/m8kVOIjfFNARV2bz7YhrF0/syNP0ACyoAaomKjue+SV2IDjRRumEjV20K4rVJ9fxj
			ba2z2Aq46cYBTD0yJKvYz7x/59LntnFN9uEc4vGr3sN5ZlSwe46DiIiIiIiIiIiIiMgxWAt3sHxL
			FRMu7nTCdeNmzuVf8W9xyYIonpo7FTOArYItbz/NJz0e5D+3O3umla96nl8/u4Tez1xOlCvO2PJV
			LjNfmsssSlj7zIP85f6dRF37IP95Nh6K1/LP+/7FJ7vGc+d5Jayd9zrFV73Mvy4wAyWsXVV8wrqd
			qvYbkFkK2LDzAN2TGrrOOecT23dLk95ZuIZmXDKBHxp7nh2brSybxS/9H6+mRnD1Y+9wQ1JL62zl
			o8de4UePhmrEc/ubv2W6K4CzlWWTtmIB98zfjjOrslHWdRYf3FbFH5/8L/kAb/+FVF+49LF3uMH8
			I3OvXc6Uhc8xsxOu8Gs17943n60NYZelKxMeuJmrBrkCruIfmXvt/+g77yY8XnyFJa7j4XvRs/zr
			lj6EeLja8vbveXura0hKSwEjHlvY7NicKb6+vtx9993MmzePzZs3AzQLyZqGY3Fxcdx9993uC8cA
			W04ybx8M4Y89ALowuWsW7+8o5LqYyGZv+GUrDzL5zlF8YgbI5s25u3nYw5O3Lo50rlBSwl/ye/HN
			b6IAKN2whhkvbiPssdGMbdqj09zCPqz7WZjpy+TLFY6JiIiIiIiIiIiISHtioyLnID99/gZrul7L
			3LHmUyvm0I98sbYfV11hYl9GpnNZ1AAG71/ElkOXE+W8tM7E22cQB4CZUReOgq2ePDDTNdRj6Cim
			jvoXH+eXAB74BXjj7ShjX44H3buaGXWqdWuF9hWQVR0iNWUvhQApC5i7cQ7vPJFwRoq2lWWz4aN/
			8OKeG3jxo1n0PMZ6lVsz6fvKO9ztmnRu75vTueLxvgx74wq6YGXfR3/mju968vjr7zApFKCMZR9u
			wyPpUj6Z349nz/slPPbO4aAqv3n5lvRPeOTuxfR+5FU+Ge8KT1IWcMndN5L92A883Zi8bOPjv2fy
			2ufvcAdAyvtMvf1ffHnBi9wY50HB4j/zSP6vWDn/QkJcZbzbhi9N165dWwzJgKPCsa5du7ZhTU7E
			zsEdpezv39P1GgczYqAvj6/K4eCFkcQ2ecePHNuLyY2frShmjk3nHxvzKW0IyDyCeGZaVOP6IcOi
			uPLrFNbtg7F9mu7zyH3YKd1ayKrunfl92312RUREREREREREREROkpWijD38+MEH/BB0LXPvHkXQ
			qRZVmM8udlL6Ui7eTZfHGYmvOs523TsR1uITZgaMH8HHX/yHv60ZwK9uGkXnsG50DmqbKKt9BWRp
			3/D3J1fSMEjdBTdNw3GwDFsrh088popDbPjoDR5fGsUfXjl2OAYQMn4W48qySU5xvXrhI2FbDvlA
			F9tuPnn1AHPm/9sVjgEEM2l2a+cYs7HjqzfYP+s93h3fpGdR0iz+Metdrli7myfHDnG11Z8r/9yk
			rknTuHPgSyzZUcaNcWFUWPII8LeTl5IN8VGEJM3ihjZ+eVoKyerr69tROAbYClm+u46xo4LY0zAr
			YJAfiSWlLM+xNxkCEbqFNe/dFRLm3bwssw/NO5YGEmWGjBZ2G9KrMxcszmJtAcRGFPLFSgvXXpHg
			DC9FRERERERERERERNzOOcfXF88uwTb7Yf51ur2zPD3xYyi//usdDDxDaVPQ2F/xr7GQ8flDPP/P
			1YQN/T8evD4Bn9Mv+ijtKyAbeCuvNhkqce97l3Hj49fw4X9mN+v5c7Iqf3qDe9dUcc+X9zYJtlri
			nBssfeN8/r4ws3HoQpjmfLo4m2ymcUnSCXd5DGUczIJLLzi6V1zPIdPgzWxKGeJq/0CiIo5dUs+L
			72XG3W/wx4dWMuGBm5kcesQ8Zm2kpZCs3YRjgC0nh6UWb6xbd/LY1iZPhDpYuiWfa2K6cKzBH211
			DvAwOofSbHENO7U2A14tHWNzAtf338/bOTVcVZfDUkvDEI8iIiIiIiIiIiIiIu2AJZOv5v2XkN++
			yBU9T7GMmjrqGv7dOZ4xQV+wM7mCfv0CXZ2fbFQUWvALD8R00oVbKSqEsHAf55xnI/7Hg/esJOP6
			BHq3weFoXwHZEXpeeCuD/7mczcWziXV15amptTWrdl1t1QnLSQ2MZEbMcnZs2svkUNc8Xy2xbOWF
			a59k+9V/4P3545y9f7bOo/9tDUfLC29KqLAApzTFlgfe3lBcaYUj8k5LZQl492z9CxI6jofmj4OU
			BVz15J/48mAg177tHH6xrTUNyYB2E45BDfu2OIdX/PHyqOZP7dvEuNcz2HRhl8b5w4qLq7Dg73wp
			bRb2ZNbQJTaEEHAO82mrI7fCTnig82NsKSlkh8WfyccILnsODGHV8gz2RDYd4lFERERERERERERE
			pB3Yu5IPa8bwlGcm+5oNleZNRHQXAk8UL/gGE5GXzvaMTHoEdqZH+ChmXPo5T87/hr63NwzVWMLu
			NVbGXXsqQzfuZ+GCg4y52DU/2d58SuPC2qT3GLTzgMxSkkelfyABHs6qBgT6k7IlA8vwRGeoYSlg
			/c5twMXHLWfwiFt56IYYrn7odzzPP/i/C5KIbCng2reNH5jMP+91hWNYOHSgGHB1OwtNYECXv/O/
			xQfpN72bq7eWjdKCKgIigvHAE29/KD8ixDssmMQBnXlqyTKy+k8lOti1jqWARUt+pMuAa1s9JJ+l
			oAAiIvBNmsUn8y/g83suaRx+8WxoCMka/t0uWPfz1k8Orr0t6ujnenTmWt9d/G9XDWOHOhetXpfM
			ph6JzrFOS9J4IzWQP9zaZNuKMj7ekIdHr0AA9i7JI3l4T54+Vq/THp25dv5enimDm38RhYiIiIiI
			iIiIiIhIu+EbRrxpHW+9vOOIJ6KZ/dCvGBnawvo9mnT36TmRO0b9nQ9ffhVG3co/Z8YTN/Nh7sj+
			e7MyJ/7yaVc45kNYj7jmHY58w4jvGtSsd5lPeBxdgjyATiTWv8M/X17qemYkf3h2BnFtdDjaV0BW
			lUdqcgoFrod7Fy3BesldDA8FCGb41At59rEPWDTeNTdX4Vre2eRPq45O0iw+ngsz77+LF3iJG0bF
			0DviiJSsS2+md/mSDetTCAwFKObHt9cDF7lWiOfy+y/mlmefZ3747a7hGstYv7ySX9w5iRA603dS
			KG9v2cyeoGBCuycReUQ1el78O2b8+nnmLgjn7oZ5yPYu4vW0i/nDPfGtPlR7P3yZzKkNc5SVUREY
			fzhwO0vaTTDWIKeWtK6R3Nzi0IZRTByWxSMFhY1LLp3emYzPd/NP1+MZM0cyuWn4ZQ5ndmAej32e
			5XoczZsXNQRf3kR2DTqiI2AUI+N38VZ5DPM0vKKIiIiIiIiIiIiItCc9Z/DPv884yfWbLjAz8u6n
			GcmJljWI57K/P310mUcMvxY382lud/372GWdee0mIPMI7kbvmtU8/9TqwwsvfpqPZx8OjULG384f
			Lvkt/35qruv5P/Lm/SXcvj64sSG+EUn0bowjPQiJTjocHCXN4s37c7n9tbk8XvXHZmUDEDqOu+/f
			xO0vz2UFABfx1NzrWfrnwwFnyPjf8SbPN1kHBv/yn66eX8FMmnU9//7zyzy+Ei7949tcHxFMdK9u
			h+cGCx3HQy/D3Huc6+Daz3Pvzzo8JJ/HEdu00BbfiAzmNxwHYPAvX+KhhsCto+rRj09+c+yne140
			kk8A2OdaEsX1v4ni+uMU2WnYUD4Z1tIzzm2bsVaRaTEwbmDXVvcEFBERERERERERERGRs89QWlpW
			31aFv/7We9z3f3e5u43STj33wkvcdvOx46khf1rOzqentsGe9/Hsw2lw3VTu79PyGoXLljNhWxjL
			f9ef8BMVZ7OQlV9H5b5d3LPRiz/cOLR5T7ST0O/hRWx+fEIbtFlERERERERERERERBq0mx5kImdP
			S8MjNucRGEjvTr6t+4BUZPPe54Vs4fTCMREREREREREREREROTsUkEkH1MLwiEcIOebQii0wJ/Dw
			bxLc3SgREREREREREREREWklo7srICIiIiIiIiIiIiIiInI2KSATERERERERERERERGRDkUBmYiI
			iIiIiIiIiIiIiHQobRqQmUwmbDabu9so7ZDNZsNkMh13HU+TEWud3d1VPWusdXY8TcqsRURERERE
			RERERETaWptejQ8LDWX/gYMKyaQZm83G/gMHCQsNPe56SZ39WZde3CFCMmudnXXpxSR19nd3VURE
			REREREREREREznkebVl4395JbNm6HYfDQXBQoLvbKu1EWXkF27bvpG/vpOOuN3tENxasO4DN7iDK
			7Ovuarep7BILn244yOwR3dxdFRERERERERERERGRc56htLSsvi13kJ6ewb6M/VRVV7m7rdJO+Pv5
			0yOuO/HxcSdc99sdh/h+Zz75FbXurnab6hToxYX9OjGtf6S7qyIiIiIiIiIiIiIics5r84BMRERE
			REREREREREREpD1p0znIRERERERERERERERERNobBWQiIiIiIiIiIiIiIiLSoSggExERERERERER
			ERERkQ5FAZmIiIiIiIiIiIiIiIh0KArIREREREREREREREREpENRQCYiIiIiIiIiIiIiIiIdyv8D
			w4q4ff0hPhQAAAAldEVYdGRhdGU6Y3JlYXRlADIwMjItMTAtMDNUMDk6NDA6MTMrMDA6MDCkbUOv
			AAAAJXRFWHRkYXRlOm1vZGlmeQAyMDIyLTEwLTAzVDA5OjQwOjEzKzAwOjAw1TD7EwAAACh0RVh0
			ZGF0ZTp0aW1lc3RhbXAAMjAyMi0xMC0wM1QwOTo0MDoxMyswMDowMIIl2swAAAAASUVORK5CYII=`})),'bookmark':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:24,height:24,viewBox:'0 0 24 24',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M5 5C5 3.89543 5.89543 3 7 3H17C18.1046 3 19 3.89543 19 5V21L12 17.5L5 21V5Z',stroke:'#4B5563',strokeWidth:'2',strokeLinecap:'round',strokeLinejoin:'round'})),'caret':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('svg',{width:20,height:20,viewBox:'0 0 20 20',fill:'none'},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)('path',{d:'M8 6L14 10.03L8 14V6Z',fill:'#9CA3AF'})),'star':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg",{width:"16",height:"16",viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg"},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path",{d:"M13.9539 6.51343C13.9015 6.34266 13.8041 6.19076 13.6727 6.07517C13.5413 5.95959 13.3813 5.885 13.2111 5.85997L10.1805 5.40055L8.82517 2.53574C8.74921 2.37495 8.63162 2.23954 8.48572 2.14486C8.33981 2.05018 8.17141 2 7.99958 2C7.82774 2 7.65934 2.05018 7.51343 2.14486C7.36753 2.23954 7.24994 2.37495 7.17398 2.53574L5.8186 5.40055L2.78804 5.85997C2.61811 5.88583 2.4585 5.96074 2.32723 6.07624C2.19595 6.19173 2.09825 6.34321 2.04514 6.51357C1.99204 6.68394 1.98565 6.8664 2.0267 7.04035C2.06775 7.2143 2.1546 7.37281 2.27744 7.49799L4.47102 9.72813L3.95322 12.8765C3.9237 13.0532 3.94229 13.235 4.00687 13.4012C4.07145 13.5675 4.17943 13.7115 4.31854 13.8169C4.45766 13.9223 4.62233 13.9849 4.79384 13.9976C4.96536 14.0103 5.13684 13.9725 5.28881 13.8886L7.99958 12.402L10.7103 13.8886C10.8624 13.9717 11.0337 14.0089 11.2049 13.9959C11.3761 13.9829 11.5404 13.9202 11.6793 13.815C11.8182 13.7097 11.9261 13.5661 11.9909 13.4003C12.0557 13.2344 12.0747 13.053 12.0459 12.8765L11.5281 9.72813L13.7217 7.49737C13.8452 7.37272 13.9324 7.21429 13.9735 7.04025C14.0146 6.86621 14.0078 6.68362 13.9539 6.51343Z",fill:"#F59E0B"})),'chart':(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg",{width:"16",height:"16",viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg"},(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path",{d:"M2.70588 9.33331C2.31553 9.33331 2 9.63198 2 9.99998V13.3333C2 13.7013 2.31553 14 2.70588 14C3.09624 14 3.41176 13.7013 3.41176 13.3333V9.99998C3.41176 9.63198 3.09624 9.33331 2.70588 9.33331Z",fill:"#94A3B8"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path",{d:"M6.23529 6.66663C5.84494 6.66663 5.52941 6.9653 5.52941 7.3333V13.3333C5.52941 13.7013 5.84494 14 6.23529 14C6.62565 14 6.94118 13.7013 6.94118 13.3333V7.3333C6.94118 6.9653 6.62565 6.66663 6.23529 6.66663Z",fill:"#94A3B8"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path",{d:"M9.76471 9.33331C9.37435 9.33331 9.05882 9.63198 9.05882 9.99998V13.3333C9.05882 13.7013 9.37435 14 9.76471 14C10.1551 14 10.4706 13.7013 10.4706 13.3333V9.99998C10.4706 9.63198 10.1551 9.33331 9.76471 9.33331Z",fill:"#94A3B8"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path",{d:"M13.2941 6.66663C12.9038 6.66663 12.5882 6.9653 12.5882 7.3333V13.3333C12.5882 13.7013 12.9038 14 13.2941 14C13.6845 14 14 13.7013 14 13.3333V7.3333C14 6.9653 13.6845 6.66663 13.2941 6.66663Z",fill:"#94A3B8"}),(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path",{d:"M2.70518 7.3333C2.90776 7.3333 3.10824 7.2513 3.24871 7.0933L6.23529 3.70795L9.22188 7.0933C9.49082 7.3973 10.0379 7.3973 10.3068 7.0933L13.8362 3.09328C14.0861 2.81061 14.0452 2.38994 13.7459 2.15461C13.4452 1.91861 13.0012 1.95727 12.7513 2.23994L9.76471 5.62529L6.77812 2.23994C6.50918 1.93594 5.96212 1.93594 5.69318 2.23994L2.16376 6.23996C1.91388 6.52263 1.95482 6.9433 2.25412 7.17863C2.38612 7.28263 2.54565 7.3333 2.70518 7.3333Z",fill:"#94A3B8"}))};/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Astra_Admin_Icons);

/***/ }),

/***/ "./assets/src/common/common.js":
/*!*************************************!*\
  !*** ./assets/src/common/common.js ***!
  \*************************************/
/***/ (() => {

window.astWpMenuClassChange = function (path) {
  const pageSlug = astra_admin.home_slug;
  const pathMap = {
    "custom-layouts": "custom-layouts",
    spectra: "spectra",
    woocommerce: "woocommerce"
  };
  const queryPath = pathMap[path] ? `&path=${pathMap[path]}` : "";
  const pageUrl = `admin.php?page=${pageSlug}${queryPath}`;
  const bodyClasses = {
    settings: "ast-admin-settings-page",
    woocommerce: "ast-admin-extensions-page",
    "starter-templates": "ast-admin-starter-page"
  };

  // Remove all possible classes.
  document.body.classList.remove(...Object.values(bodyClasses));

  // Add the appropriate class if it exists in the map.
  if (bodyClasses[path]) {
    document.body.classList.add(bodyClasses[path]);
  }

  // Remove 'current' class from all items.
  document.querySelectorAll(".wp-submenu .current").forEach(item => item.classList.remove("current"));

  // Add 'current' class to matching items.
  document.querySelectorAll(`.wp-submenu-wrap li > a[href$="${pageUrl}"]`).forEach(item => item.parentElement.classList.add("current"));
};

/***/ }),

/***/ "./assets/src/common/skeleton/Rectangle.js":
/*!*************************************************!*\
  !*** ./assets/src/common/skeleton/Rectangle.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Rectangle_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Rectangle.scss */ "./assets/src/common/skeleton/Rectangle.scss");



function RectSkeleton(props) {
  const {
    width,
    height,
    style
  } = props;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ast-skeleton ast-skeleton--rect ast-skeleton--wave",
    style: {
      width,
      height,
      ...style
    }
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RectSkeleton);

/***/ }),

/***/ "./assets/src/common/skeleton/Skeleton.js":
/*!************************************************!*\
  !*** ./assets/src/common/skeleton/Skeleton.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Skeleton_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Skeleton.scss */ "./assets/src/common/skeleton/Skeleton.scss");



function Skeleton() {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ast-skeleton ast-skeleton--wave"
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Skeleton);

/***/ }),

/***/ "./assets/src/common/skeleton/Spacer.js":
/*!**********************************************!*\
  !*** ./assets/src/common/skeleton/Spacer.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Spacer_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Spacer.scss */ "./assets/src/common/skeleton/Spacer.scss");



function SpacerSkeleton(props) {
  const {
    height,
    style
  } = props;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ast-skeleton-base ast-skeleton--spacer",
    style: {
      height,
      ...style
    }
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SpacerSkeleton);

/***/ }),

/***/ "./assets/src/common/skeleton/Text.js":
/*!********************************************!*\
  !*** ./assets/src/common/skeleton/Text.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Text_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Text.scss */ "./assets/src/common/skeleton/Text.scss");



function TextSkeleton(props) {
  const {
    fontSize,
    width,
    style
  } = props;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ast-skeleton ast-skeleton--text ast-skeleton--wave",
    style: {
      fontSize,
      width,
      ...style
    }
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextSkeleton);

/***/ }),

/***/ "./assets/src/common/skeleton/index.js":
/*!*********************************************!*\
  !*** ./assets/src/common/skeleton/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RectSkeleton: () => (/* reexport safe */ _Skeleton_Rectangle__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   SpacerSkeleton: () => (/* reexport safe */ _Skeleton_Spacer__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   TextSkeleton: () => (/* reexport safe */ _Skeleton_Text__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Skeleton_Common_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @Skeleton/Common.scss */ "./assets/src/common/skeleton/Common.scss");
/* harmony import */ var _Skeleton_Skeleton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @Skeleton/Skeleton */ "./assets/src/common/skeleton/Skeleton.js");
/* harmony import */ var _Skeleton_Text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Skeleton/Text */ "./assets/src/common/skeleton/Text.js");
/* harmony import */ var _Skeleton_Spacer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Skeleton/Spacer */ "./assets/src/common/skeleton/Spacer.js");
/* harmony import */ var _Skeleton_Rectangle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @Skeleton/Rectangle */ "./assets/src/common/skeleton/Rectangle.js");





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Skeleton_Skeleton__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./assets/src/dashboard-app/DocsPopup.js":
/*!***********************************************!*\
  !*** ./assets/src/dashboard-app/DocsPopup.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/components/transitions/transition.js");
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/components/dialog/dialog.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @DashboardApp/pages */ "./assets/src/dashboard-app/pages/index.js");






const DocsPopup = () => {
  const [open, setOpen] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const kbData = astra_admin.astra_docs_data && astra_admin.astra_docs_data?.categories;
  const docsTrigger = () => {
    if (kbData) {
      setOpen(true);
    } else {
      window.open(astra_admin.astraWebsite?.docsUrl, '_blank');
    }
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Tooltip, {
    text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Knowledge Base', 'astra'),
    delay: 50
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-8 sm:w-10 h-8 sm:h-10 flex items-center whitespace-nowrap justify-center cursor-pointer rounded-full border border-slate-200"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    onClick: docsTrigger,
    className: "text-xs sm:text-sm font-medium sm:leading-[0.875rem] text-slate-600 doc-icon"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "30",
    height: "30",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    "aria-hidden": "true"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.5",
    y: "0.5",
    width: "31",
    height: "31",
    rx: "15.5",
    fill: "white"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M16 11.0347C14.6731 9.84713 12.9209 9.125 11 9.125C10.1234 9.125 9.28195 9.27539 8.5 9.55176V21.4268C9.28195 21.1504 10.1234 21 11 21C12.9209 21 14.6731 21.7221 16 22.9097M16 11.0347C17.3269 9.84713 19.0791 9.125 21 9.125C21.8766 9.125 22.7181 9.27539 23.5 9.55176V21.4268C22.7181 21.1504 21.8766 21 21 21C19.0791 21 17.3269 21.7221 16 22.9097M16 11.0347V22.9097",
    stroke: "#475569",
    strokeWidth: "1.4",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "sr-only"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Knowledge Base', 'astra'))))), kbData && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_5__.Transition.Root, {
    show: open,
    as: react__WEBPACK_IMPORTED_MODULE_1__.Fragment
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_6__.Dialog, {
    as: "div",
    className: "relative z-10",
    onClose: setOpen
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "fixed inset-0 top-8 z-10 overflow-y-auto ast-kb-section"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex min-h-screen h-full items-end justify-center p-4 text-center sm:items-center sm:p-0 ast-kb-inner-wrap"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_5__.Transition.Child, {
    as: react__WEBPACK_IMPORTED_MODULE_1__.Fragment,
    enter: "ease-out duration-300",
    enterFrom: "opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95",
    enterTo: "opacity-100 translate-y-0 sm:scale-100",
    leave: "ease-in duration-200",
    leaveFrom: "opacity-100 translate-y-0 sm:scale-100",
    leaveTo: "opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_6__.Dialog.Panel, {
    className: "relative transform bg-white text-left transition-all min-h-screen w-full h-full lg:ml-40"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages__WEBPACK_IMPORTED_MODULE_4__.Docs, {
    setOpen: setOpen
  }))))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DocsPopup);

/***/ }),

/***/ "./assets/src/dashboard-app/MainNav.js":
/*!*********************************************!*\
  !*** ./assets/src/dashboard-app/MainNav.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MainNav)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/components/disclosure/disclosure.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var _DocsPopup__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./DocsPopup */ "./assets/src/dashboard-app/DocsPopup.js");
/* harmony import */ var _whats_new_library_useWhatsNewRSS__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./whats-new-library/useWhatsNewRSS */ "./assets/src/dashboard-app/whats-new-library/useWhatsNewRSS.js");








const CoreVersion = () => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_3__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
  className: "flex items-center"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, astra_admin.version), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
  className: "ml-1 sm:ml-2 text-[0.625rem] leading-[1rem] font-medium border border-slate-400 rounded-[0.1875rem] relative inline-flex flex-shrink-0 py-[0rem] px-1.5"
}, " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("CORE", "astra"), " ")), astra_admin.pro_available && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
  className: "flex items-center pl-3"
}, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, astra_admin.plugin_ver), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
  className: "ml-1 sm:ml-2 text-[0.625rem] leading-[1rem] font-medium text-white border border-slate-800 bg-slate-800 rounded-[0.1875rem] relative inline-flex flex-shrink-0 py-[0rem] px-1.5"
}, " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("PRO", "astra"), " ")), wp.hooks.applyFilters("astra_dashboard.after_navigation_version", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null)));
function MainNav() {
  // Initialize our library hook.
  (0,_whats_new_library_useWhatsNewRSS__WEBPACK_IMPORTED_MODULE_5__["default"])({
    rssFeedURL: astra_admin.astraWebsite?.whatsNewFeedUrl,
    selector: "#astra-whats-new",
    triggerButton: {
      beforeBtn: '<div class="w-8 sm:w-10 h-8 sm:h-10 flex items-center whitespace-nowrap justify-center cursor-pointer rounded-full border border-slate-200">',
      icon: '<svg width="18" height="18" viewBox="0 0 18 18" fill="none"><path d="M8.16667 3.90182V15.0335C8.16667 15.8434 7.51008 16.5 6.70015 16.5C6.08038 16.5 5.52752 16.1104 5.31907 15.5267L3.53039 10.4024M14 9.83333C15.3807 9.83333 16.5 8.71404 16.5 7.33333C16.5 5.95262 15.3807 4.83333 14 4.83333M3.53039 10.4024C2.33691 9.89508 1.5 8.71194 1.5 7.33333C1.5 5.49238 2.99238 4 4.83333 4H6.36007C9.77727 4 12.7141 2.97159 14 1.5L14 13.1667C12.7141 11.6951 9.77727 10.6667 6.36007 10.6667L4.83331 10.6667C4.37098 10.6667 3.93064 10.5725 3.53039 10.4024Z" stroke="#475569" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"></path></svg>',
      afterBtn: '</div>'
    },
    flyout: {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("What's New?", "astra"),
      formatDate: (/** @type Date */date) => {
        const dayOfWeek = date.toLocaleDateString('en-US', {
          weekday: 'long'
        });
        const month = date.toLocaleDateString('en-US', {
          month: 'long'
        });
        const day = date.getDate();
        const year = date.getFullYear();

        // Format the date string
        const formattedDate = `${dayOfWeek} ${month} ${day}, ${year}`;
        return formattedDate;
      }
    }
  });
  const navMenus = [{
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Welcome", "astra"),
    slug: astra_admin.home_slug,
    path: ""
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Settings", "astra"),
    slug: astra_admin.home_slug,
    path: "settings"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Free vs Pro", "astra"),
    slug: astra_admin.home_slug,
    path: "free-vs-pro"
  }];

  // insert starter templates menu if not white labeled and if promotion enabled.
  if (!astra_admin.is_whitelabel && astra_admin?.starter_templates_data?.is_promoting) {
    navMenus.splice(2, 0, {
      name: astra_admin.starter_templates_data.title,
      slug: astra_admin.home_slug,
      path: "starter-templates"
    });
  }
  const redirectUpgradeAstraProPurchase = () => {
    window.open(astra_admin.astra_cta_btn_url, '_blank');
  };
  const menus = wp.hooks.applyFilters('astra_dashboard.main_navigation', navMenus);
  const query = new URLSearchParams((0,react_router_dom__WEBPACK_IMPORTED_MODULE_6__.useLocation)()?.search);
  const activePage = query.get("page") || astra_admin.home_slug;
  const activePath = query.get("path") || "";
  if (activePath === 'spectra') {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_3__.Fragment, null);
  }
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_7__.Disclosure, {
    as: "nav",
    className: "bg-white border-b border-slate-200"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-w-3xl mx-auto px-3 sm:px-6 lg:max-w-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative flex flex-col lg:flex-row justify-between h-28 lg:h-16 py-3 lg:py-0"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "lg:flex-1 flex items-start justify-center sm:items-stretch sm:justify-start"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: astra_admin.astra_base_url,
    className: "flex-shrink-0 flex items-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    className: "lg:block h-[2.6rem] w-auto",
    src: astra_admin.logo_url,
    alt: "Workflow"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ml-4 sm:ml-8 sm:flex gap-y-4 gap-x-8"
  }, menus.map((menu, key) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    key: `?page=${menu.slug}&path=${menu.path}`
  }, menu.path === 'starter-templates' && astra_admin.starter_templates_data.is_available ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    index: key,
    href: astra_admin.starter_templates_data.redirection,
    target: "_self",
    className: `${activePage === menu.slug && activePath === menu.path ? 'mb-4 sm:mb-0 border-astra text-astra active:text-astra focus:text-astra focus-visible:text-astra-hover hover:text-astra-hover inline-flex items-center px-1 border-b-2 text-sm leading-[0.875rem] font-medium' : 'mb-4 sm:mb-0 border-transparent text-slate-500 active:text-astra focus-visible:border-slate-300 focus-visible:text-slate-800 hover:border-slate-300 hover:text-slate-800 inline-flex items-center px-1 border-b-2 text-sm leading-[0.875rem] font-medium'}`
  }, menu.name) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_router_dom__WEBPACK_IMPORTED_MODULE_8__.Link, {
    index: key,
    to: {
      search: `?page=${menu.slug}${'' !== menu.path ? '&path=' + menu.path : ''}`
    },
    className: `${activePage === menu.slug && activePath === menu.path ? 'mb-4 sm:mb-0 border-astra text-astra active:text-astra focus:text-astra focus-visible:text-astra-hover hover:text-astra-hover inline-flex items-center px-1 border-b-2 text-sm leading-[0.875rem] font-medium' : 'mb-4 sm:mb-0 border-transparent text-slate-600 active:text-astra focus-visible:border-slate-300 focus-visible:text-slate-800 hover:border-slate-300 hover:text-slate-800 inline-flex items-center px-1 border-b-2 text-sm leading-[0.875rem] font-medium'}`
  }, menu.name))))), astra_admin.show_self_branding && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "absolute bottom-2 lg:inset-y-0 right-0 flex items-center pr-2 sm:static sm:inset-auto ml-auto lg:ml-6 sm:pr-0"
  }, !astra_admin.pro_available && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm font-medium text-slate-600 pr-3 tablet:pr-2 border-r hover:text-[#1E293B] hover:svg-hover-color"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: redirectUpgradeAstraProPurchase,
    className: "inline-flex items-center text-[#046BD2] hover:text-[#1E293B] focus-visible:text-[#1E293B]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "16",
    height: "12",
    viewBox: "0 0 16 12",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    className: "mr-2 svg-focusable"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M3.3335 11.3337H12.6668M1.3335 0.666992L3.3335 8.66699H12.6668L14.6668 0.666992L10.6668 5.33366L8.00016 0.666992L5.3335 5.33366L1.3335 0.666992Z",
    stroke: "#046BD2",
    strokeLinecap: "round",
    strokeLinejoin: "round",
    className: "svg-path"
  })), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Unlock Pro Features', 'astra'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center text-[0.625rem] sm:text-sm font-medium leading-[1.375rem] text-slate-400 mr-1 sm:mr-3 divide-x divide-slate-200 gap-3 pl-1 sm:pl-3 border-r"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(CoreVersion, null)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm font-medium leading-6 text-slate-600 pr-3 tablet:pr-2"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DocsPopup__WEBPACK_IMPORTED_MODULE_4__["default"], null)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Tooltip, {
    text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Whats's New", "astra"),
    delay: 50
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    id: "astra-whats-new"
  }))), !astra_admin.show_self_branding && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "absolute inset-y-0 right-0 flex items-center pr-2 sm:static sm:inset-auto sm:ml-6 sm:pr-0"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center whitespace-nowrap text-sm font-medium leading-[1.375rem] text-slate-400 mr-4 divide-x divide-slate-200 gap-3"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(CoreVersion, null))))));
}

/***/ }),

/***/ "./assets/src/dashboard-app/SettingsRoute.js":
/*!***************************************************!*\
  !*** ./assets/src/dashboard-app/SettingsRoute.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @DashboardApp/pages */ "./assets/src/dashboard-app/pages/index.js");





// Define a mapping of paths to components.
const ROUTE_MAP = {
  "getting-started": _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_2__.Welcome,
  "starter-templates": _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_2__.StarterTemplates,
  settings: _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_2__.Settings,
  "free-vs-pro": _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_2__.FreeVsPro,
  "custom-layouts": _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_2__.CustomLayouts,
  spectra: _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_2__.SpectraScreen,
  woocommerce: _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_2__.ExtensionScreen,
  docs: _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_2__.Docs
};
function SettingsRoute() {
  const {
    search
  } = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  const query = new URLSearchParams(search);
  const page = query.get("page");
  const path = query.get("path");
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (typeof astWpMenuClassChange === "function") {
      astWpMenuClassChange(path);
    }
  }, [path]);
  if (astra_admin.home_slug !== page) {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, "Fallback Route Page");
  }
  const Component = ROUTE_MAP[path] || _DashboardApp_pages__WEBPACK_IMPORTED_MODULE_2__.Welcome;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(Component, null);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsRoute);

/***/ }),

/***/ "./assets/src/dashboard-app/SettingsSavedNotification.js":
/*!***************************************************************!*\
  !*** ./assets/src/dashboard-app/SettingsSavedNotification.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsSavedNotification)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/components/transitions/transition.js");
/* harmony import */ var _heroicons_react_outline__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @heroicons/react/outline */ "./node_modules/@heroicons/react/outline/esm/CheckCircleIcon.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _heroicons_react_solid__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @heroicons/react/solid */ "./node_modules/@heroicons/react/solid/esm/XIcon.js");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);








function SettingsSavedNotification() {
  const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_2__.useDispatch)();
  const settingsSavedNotification = (0,react_redux__WEBPACK_IMPORTED_MODULE_2__.useSelector)(state => state.settingsSavedNotification);
  const query = new URLSearchParams((0,react_router_dom__WEBPACK_IMPORTED_MODULE_4__.useLocation)()?.search);
  const status = query.get("status") ? query.get("status") : "";
  if ('' !== status && 'imported' === status) {
    dispatch({
      type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
      payload: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Successfully imported!', 'astra')
    });
    setTimeout(() => {
      window.location = astra_admin.astra_base_url;
    }, 1000);
  }
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (settingsSavedNotification !== '') {
      const timer = setTimeout(() => {
        dispatch({
          type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
          payload: ''
        });
      }, 2000);

      // Cleanup function to clear the timeout if the component unmounts or notification changes.
      return () => clearTimeout(timer);
    }
  }, [settingsSavedNotification]);
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    "aria-live": "assertive",
    className: "fixed inset-10 z-10 flex px-4 py-6 pointer-events-none sm:p-6 sm:items-start"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-full flex flex-col items-center space-y-4 sm:items-end"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_5__.Transition, {
    show: '' === settingsSavedNotification ? false : true,
    as: react__WEBPACK_IMPORTED_MODULE_1__.Fragment,
    enter: "transform ease-out duration-300 transition",
    enterFrom: "translate-y-2 opacity-0 sm:translate-y-0 sm:translate-x-2",
    enterTo: "translate-y-0 opacity-100 sm:translate-x-0",
    leave: "transition ease-in duration-100",
    leaveFrom: "opacity-100",
    leaveTo: "opacity-0"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-w-sm w-full bg-white shadow-lg rounded-lg pointer-events-auto ring-1 ring-black ring-opacity-5 overflow-hidden"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-4"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-start"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex-shrink-0"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_heroicons_react_outline__WEBPACK_IMPORTED_MODULE_6__["default"], {
    className: "h-6 w-6 text-green-400",
    "aria-hidden": "true"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ml-3 w-0 flex-1 pt-0.5"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm font-medium text-gray-900"
  }, settingsSavedNotification)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ml-4 flex-shrink-0 flex"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "bg-white rounded-md inline-flex text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500",
    onClick: () => {
      dispatch({
        type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
        payload: ''
      });
    }
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "sr-only"
  }, " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Close ', 'astra'), " "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_heroicons_react_solid__WEBPACK_IMPORTED_MODULE_7__["default"], {
    className: "h-5 w-5",
    "aria-hidden": "true"
  }))))))))));
}

/***/ }),

/***/ "./assets/src/dashboard-app/SettingsWrap.js":
/*!**************************************************!*\
  !*** ./assets/src/dashboard-app/SettingsWrap.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _MainNav__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MainNav */ "./assets/src/dashboard-app/MainNav.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _SettingsRoute__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SettingsRoute */ "./assets/src/dashboard-app/SettingsRoute.js");
/* harmony import */ var _SettingsSavedNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SettingsSavedNotification */ "./assets/src/dashboard-app/SettingsSavedNotification.js");






const SettingsWrap = () => {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_router_dom__WEBPACK_IMPORTED_MODULE_5__.BrowserRouter, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_MainNav__WEBPACK_IMPORTED_MODULE_2__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_SettingsSavedNotification__WEBPACK_IMPORTED_MODULE_4__["default"], null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Routes, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Route, {
    path: "*",
    element: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_SettingsRoute__WEBPACK_IMPORTED_MODULE_3__["default"], null)
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsWrap);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/Welcome/AstraIntegration.js":
/*!********************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/Welcome/AstraIntegration.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var _Utils_extensions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Utils/extensions */ "./assets/src/utils/extensions.js");




const classNames = (...classes) => classes.filter(Boolean).join(" ");
const AstraIntegration = () => {
  const handlePluginActionTrigger = e => (0,_Utils_extensions__WEBPACK_IMPORTED_MODULE_3__.triggerAction)(e);
  const getStatusClass = value => {
    if (value === "activated") {
      return "text-[#4AB866] pointer-events-none";
    } else {
      return "text-astra bg-slate-50 px-[0.8125rem]";
    }
  };
  const renderBlockCards = astra_admin.integrations.map((plugin, index) => {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: index,
      className: classNames(plugin.isPro ? "bg-slate-50" : "bg-white", "box-border relative border rounded-md px-5 py-4 flex items-start gap-x-4 snap-start")
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex flex-col"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex justify-between"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, plugin.logoPath.internal_icon && _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"][plugin.logoPath.icon_path], !plugin.logoPath.internal_icon && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: plugin.logoPath.icon_path,
      width: "40px",
      height: "40px"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, plugin.isPro ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Pro', 'astra')) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "text-astra uppercase text-[0.625rem] leading-[0.0625rem] font-semibold bg-blue-50 px-1 pt-0.5 pb-[0.1875rem] rounded-[0.1875rem]"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Free', 'astra')))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "mt-2"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-base leading-[1.625rem] font-medium text-slate-800"
    }, plugin.title), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "text-sm leading-[1.375rem] text-slate-400 mt-[0.1875rem]"
    }, plugin.subtitle), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
      "data-type": "button",
      "data-slug": plugin.slug,
      "data-redirection": plugin.redirection,
      "data-action": (0,_Utils_extensions__WEBPACK_IMPORTED_MODULE_3__.getAction)(plugin.status),
      "data-init": plugin.path,
      onClick: handlePluginActionTrigger,
      className: ` ${getStatusClass(plugin.status)} inline-flex items-center capitalize mt-3 text-sm leading-[0.875rem] font-medium rounded-md py-[0.5625rem]`
    }, 'installed' == plugin.status ? astra_admin.plugin_activate_text : plugin.status))));
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid grid-flow-row auto-rows-min grid-cols-1 gap-4 sm:grid-cols-3 pt-6"
  }, renderBlockCards);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AstraIntegration);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/Welcome/BulkExtensionController.js":
/*!***************************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/Welcome/BulkExtensionController.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");




const BulkExtensionController = () => {
  const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useDispatch)();
  const blocksStatuses = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useSelector)(state => state.blocksStatuses);
  const handleBulkTrigger = action => {
    const value = {
      ...blocksStatuses
    };
    for (const block in blocksStatuses) {
      value[block] = action === "activate" ? block : "";
    }
    dispatch({
      type: "UPDATE_BLOCK_STATUSES",
      payload: value
    });
    const formData = new window.FormData();
    formData.append("action", `astra_addon_bulk_${action}_modules`);
    formData.append("security", astra_addon_admin.update_nonce);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      url: astra_admin.ajax_url,
      method: "POST",
      body: formData
    }).then(data => {
      if (data.success) {
        dispatch({
          type: "UPDATE_SETTINGS_SAVED_NOTIFICATION",
          payload: action === "activate" ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Successfully Activated!", "astra") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Successfully Deactivated!", "astra")
        });
        refreshCache();
      }
    }).catch(error => {
      console.error(`Error during ${action}:`, error);
    });
  };
  const refreshCache = () => {
    const reFormData = new window.FormData();
    reFormData.append("action", "astra_refresh_assets_files");
    reFormData.append("security", astra_addon_admin.update_nonce);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      url: astra_admin.ajax_url,
      method: "POST",
      body: reFormData
    }).then(() => {
      dispatch({
        type: "UPDATE_SETTINGS_SAVED_NOTIFICATION",
        payload: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Cache Cleared!", "astra")
      });
      location.reload();
    }).catch(error => {
      console.error("Error during cache refresh:", error);
      // Handle the error, possibly showing a notification to the user.
    });
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "z-0 flex shadow-sm rounded-[0.2rem] sm:justify-center w-fit sm:w-auto"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    type: "button",
    className: "focus:bg-indigo-50 focus:text-slate-500 focus-visible:text-astra hover:bg-indigo-50 hover:text-astra -ml-px relative inline-flex items-center px-4 py-2 border border-slate-200 bg-white text-sm font-medium text-slate-500 focus:z-10 focus:outline-none rounded-l-md transition",
    onClick: () => handleBulkTrigger("activate")
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Activate all", "astra")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    type: "button",
    className: "focus:bg-indigo-50 focus:text-slate-500 focus-visible:text-astra hover:bg-indigo-50 hover:text-astra -ml-px relative inline-flex items-center px-4 py-2 border border-slate-200 bg-white text-sm font-medium text-slate-500 focus:z-10 focus:outline-none rounded-r-md transition",
    onClick: () => handleBulkTrigger("deactivate")
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Deactivate all", "astra")));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BulkExtensionController);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/Welcome/ProModules.js":
/*!**************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/Welcome/ProModules.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _DashboardApp_pages_welcome_ExtensionCard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @DashboardApp/pages/welcome/ExtensionCard */ "./assets/src/dashboard-app/pages/welcome/ExtensionCard.js");



const ProModules = () => {
  const astraExtensions = astra_admin.extensions;
  const renderBlockCards = Object.entries(astraExtensions).map(([index, module]) => {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_welcome_ExtensionCard__WEBPACK_IMPORTED_MODULE_2__["default"], {
      key: index,
      slug: index,
      moduleInfo: module
    });
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid grid-flow-row auto-rows-min grid-cols-1 gap-4 sm:grid-cols-2 pt-6"
  }, renderBlockCards);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProModules);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/Welcome/QuickSettings.js":
/*!*****************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/Welcome/QuickSettings.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");


const classNames = (...classes) => classes.filter(Boolean).join(' ');

const QuickSettings = () => {
  const allQuickLinks = astra_admin.quick_settings;
  const onQuickSettingTrigger = sectionLink => {
    window.open(sectionLink, '_blank');
  };
  const renderQuickLinks = Object.entries(allQuickLinks).map(([index, block]) => {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: index,
      "data-redirection": block.quick_url,
      onClick: () => onQuickSettingTrigger(block.quick_url),
      className: classNames(block.isPro ? 'bg-slate-50' : 'bg-white', 'box-border relative border rounded-md cursor-pointer h-20 px-3 py-3 flex items-start gap-x-4 snap-start hover:shadow-md transition astra-icon-transition group')
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex-1 min-w-0"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-base font-medium text-slate-800 leading-7"
    }, block.title), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      className: classNames(block.isPro ? 'pointer-events-none' : '', 'focus:text-slate-400 text-slate-400 text-base truncate leading-[1.625rem] focus-visible:text-slate-400-hover active:text-astra-hover group-hover:text-astra-hover'),
      href: block.quick_url,
      rel: "noreferrer",
      target: "_blank"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Customize', 'astra'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "relative inline-flex flex-shrink-0 py-0.5 px-1 text-[0.625rem] leading-[0.7rem] text-gray-50 rounded-[0.1875rem] group-hover:text-slate-300"
    }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]["customize"]));
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid grid-flow-row auto-rows-min grid-cols-1 gap-4 sm:grid-cols-3 pt-6"
  }, renderQuickLinks);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (QuickSettings);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/Welcome/UsefulPlugins.js":
/*!*****************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/Welcome/UsefulPlugins.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _Utils_extensions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @Utils/extensions */ "./assets/src/utils/extensions.js");





const UsefulPlugins = () => {
  const handlePluginActionTrigger = e => (0,_Utils_extensions__WEBPACK_IMPORTED_MODULE_4__.triggerAction)(e);
  const getStatusClass = value => {
    if (value === "activated") {
      return "text-[#4AB866] pointer-events-none";
    } else {
      return "text-astra";
    }
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, astra_admin.useful_plugins.map((plugin, key) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: `${plugin.status === 'activated' ? '' : 'hover:bg-[#F8FAFC] hover:shadow-hover'} flex justify-between items-start p-4 border-t border-slate-200 bg-white transition `,
    key: key
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-grow"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, plugin.logoPath.internal_icon && _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"][plugin.logoPath.icon_path], !plugin.logoPath.internal_icon && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: plugin.logoPath.icon_path,
    width: "40px",
    height: "40px"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ml-2.5 flex-grow"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex gap-1 justify-between"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm leading-[1.375rem] font-medium text-slate-800"
  }, plugin.title), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    "data-slug": plugin.slug,
    "data-init": plugin.path,
    "data-redirection": plugin.redirection,
    "data-action": (0,_Utils_extensions__WEBPACK_IMPORTED_MODULE_4__.getAction)(plugin.status),
    className: ` ${getStatusClass(plugin.status)} p-0 m-0 inline-flex items-center capitalize text-sm leading-4 font-medium cursor-pointer`,
    onClick: handlePluginActionTrigger
  }, 'installed' == plugin.status ? astra_admin.plugin_activate_text : plugin.status)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm leading-[1.375rem] text-slate-400"
  }, plugin.subtitle))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UsefulPlugins);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/custom-layouts/CustomLayouts.js":
/*!************************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/custom-layouts/CustomLayouts.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var _astra_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @astra-components */ "./assets/components/index.js");





const CustomLayouts = () => {
  const query = new URLSearchParams((0,react_router_dom__WEBPACK_IMPORTED_MODULE_4__.useLocation)()?.search);
  const allowAutoPlay = '1' === query.get('astra-activation-redirect') ? 1 : 0;
  const videoID = 'FWRkzJQwcKU';
  const onFreeVsProClick = () => {
    window.open(astra_admin.free_vs_pro_link, '_self');
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("main", {
    className: "relative"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-full absolute inset-0 blur-md"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]['custom-layout']), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative z-10 pt-[4rem]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-w-[39rem] h-max bg-white m-auto shadow-overlay-modal text-center rounded-lg p-8"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mx-auto flex items-center justify-center"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]["astra-logo"]), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-3 text-center sm:mt-5"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h4", {
    className: "text-2xl font-semibold leading-7 text-slate-800",
    id: "modal-title"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Site Builder', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-2"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm leading-[1.375rem] text-slate-500 text-center"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Upgrade to Astra Pro to get access to the Site Builder, which allow you to create a unique header, footer, 404 pages, and custom content.', 'astra'))), astra_admin.show_banner_video && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative pb-[17.5rem] mt-5"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("iframe", {
    className: "absolute inset-0 w-full h-full rounded-md",
    src: `https://www.youtube-nocookie.com/embed/${videoID}?showinfo=0&autoplay=${allowAutoPlay}&mute=${allowAutoPlay}&rel=0`,
    allow: "autoplay",
    title: "YouTube video player",
    frameBorder: "0",
    allowFullScreen: true
  })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-center mt-5"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_3__.ProButton, {
    className: "w-auto justify-center rounded-md border border-transparent bg-astra px-[2.9375rem] py-[0.6875rem] text-base leading-4 font-medium text-white shadow-sm hover:bg-astra-hover focus:outline-none focus:ring-2 focus:ring-astra-hover focus:ring-offset-2"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "w-auto justify-center mt-4 text-base leading-4 text-astra font-medium",
    onClick: onFreeVsProClick
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Free vs Pro', 'astra')))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomLayouts);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/docs/Docs.js":
/*!*****************************************************!*\
  !*** ./assets/src/dashboard-app/pages/docs/Docs.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _SubSection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SubSection */ "./assets/src/dashboard-app/pages/docs/SubSection.js");
/* harmony import */ var _UpgradeToPro__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./UpgradeToPro */ "./assets/src/dashboard-app/pages/docs/UpgradeToPro.js");
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var _SearchResults__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SearchResults */ "./assets/src/dashboard-app/pages/docs/SearchResults.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var _astra_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @astra-components */ "./assets/components/index.js");
/* harmony import */ var _astra_hooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @astra-hooks */ "./assets/hooks/index.js");










const Docs = ({
  setOpen
}) => {
  const [searchKeyword, setSearchKeyword] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("");
  const [searchResults, setSearchResults] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);

  // Debounced filtering of docs based on the search keyword, updating results only after typing pauses.
  (0,_astra_hooks__WEBPACK_IMPORTED_MODULE_8__.useDebounceEffect)(() => {
    if (searchKeyword === "") {
      setSearchResults(null);
    } else {
      const data = astra_admin.astra_docs_data.docs.filter(item => item.title.toLowerCase().includes(searchKeyword));
      setSearchResults(data);
    }
  }, 300, [searchKeyword]);
  const is404 = astra_admin.astra_docs_data?.data?.status === 404;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("main", {
    className: "bg-white"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: ""
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", {
    className: "sr-only"
  }, " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Welcome to KB Docs", "astra"), " "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-full flex justify-between items-center bg-gray-50 py-5 px-6"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: astra_admin.astra_base_url,
    className: "flex-shrink-0 flex items-center ast-box-shadow-none"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    className: "lg:block mr-3 h-[2.6rem] w-auto ast-box-shadow-none",
    src: astra_admin.logo_url,
    alt: "Workflow"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-w-5xl mx-auto w-full relative"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "search",
    placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Search", "astra"),
    className: "w-full ast-docs-search-fields text-base",
    onChange: e => setSearchKeyword(e.target.value)
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "absolute top-1/2 -translate-y-1/2 left-4"
  }, searchKeyword ? _Common_block_icons__WEBPACK_IMPORTED_MODULE_5__["default"]['close'] : _Common_block_icons__WEBPACK_IMPORTED_MODULE_5__["default"]['search'])), setOpen && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => setOpen(false)
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_5__["default"]["popupclose"]))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "sm:max-w-5xl mx-auto w-full flex flex-col"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col lg:flex-row gap-8 pt-10"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-full px-6 lg:px-0 lg:w-2/3 mb-5 self-center"
  }, is404 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-4xl font-bold text-gray-800 mb-4"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("404", "astra")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-xl text-gray-600 mb-8"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Oops! Documentation not found.", "astra")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-lg text-gray-600 mb-8"
  }, astra_admin.astra_docs_data?.message), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link, {
    role: "button",
    to: astra_admin.astra_base_url,
    className: "sm:inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-astra focus-visible:bg-astra-hover hover:text-white hover:bg-astra-hover focus:outline-none mr-4 mb-2 sm:mb-0"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Go to Dashboard", "astra")))), !is404 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, searchResults && searchResults.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mb-8"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_SearchResults__WEBPACK_IMPORTED_MODULE_6__["default"], {
    data: searchResults
  })), Object.entries(astra_admin.astra_docs_data.categories).map((item, key) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_SubSection__WEBPACK_IMPORTED_MODULE_3__["default"], {
    item: item,
    key: key
  })), !astra_admin.pro_available && astra_admin.upgrade_notice && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-10"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_UpgradeToPro__WEBPACK_IMPORTED_MODULE_4__["default"], null)))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-full px-6 lg:px-0 lg:w-1/3"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_7__.PromoCard, {
    id: "vip-priority-support",
    className: "border border-sky-500 mb-5",
    icon: _Common_block_icons__WEBPACK_IMPORTED_MODULE_5__["default"]["support"],
    title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "font-medium"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("VIP Priority Support", "astra")),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Faster and exclusive support service designed for VIP assistance and benefits.", "astra"),
    linkHRef: astra_admin.astraWebsite?.vipPrioritySupportUrl,
    linkText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Know More →", "astra")
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_7__.PromoCard, {
    id: "view-documentation",
    className: "border border-slate-200 mb-5",
    icon: _Common_block_icons__WEBPACK_IMPORTED_MODULE_5__["default"]["book"],
    title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "font-medium"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("View Documentation", "astra")),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)(`Browse documentation, reference material, and tutorials for ${astra_admin.theme_name} Theme.`, "astra"),
    linkHRef: astra_admin.astraWebsite?.docsUrl,
    linkText: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "inline-flex items-center gap-2"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("View All Documentation", "astra"), _Common_block_icons__WEBPACK_IMPORTED_MODULE_5__["default"]["redirect"])
  }))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Docs);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/docs/SearchResults.js":
/*!**************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/docs/SearchResults.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var react_html_parser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-html-parser */ "./node_modules/react-html-parser/lib/index.js");



const SearchResults = ({
  data
}) => {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, data && data.map((item, key) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: item.url + '?utm_source=free-theme&utm_medium=dashboard&utm_campaign=knowledge',
    target: "blank",
    className: "flex items-center justify-between text-slate-800 rounded-md p-2 pl-0 hover:bg-gray-50 group cursor-pointer",
    key: key
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center ast-kb-caret"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_1__["default"]["caret"], (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-base leading-[1.625rem] text-slate-800 ml-2"
  }, (0,react_html_parser__WEBPACK_IMPORTED_MODULE_2__["default"])(item.title))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-slate-600 invisible group-hover:visible"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_1__["default"]["redirect"]))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SearchResults);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/docs/SubSection.js":
/*!***********************************************************!*\
  !*** ./assets/src/dashboard-app/pages/docs/SubSection.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var react_html_parser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-html-parser */ "./node_modules/react-html-parser/lib/index.js");





const SubSection = ({
  item
}) => {
  const [categorySlug, category] = item;
  const [open, setOpen] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);

  // Subcategories.
  const subcategories = Object.entries(category.subcategories);

  // Docs.
  const docs = astra_admin.astra_docs_data.docs.filter(doc => doc.category?.toString() === categorySlug);
  const docsCount = docs.length;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "py-5 border-t border-slate-200"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    onClick: () => setOpen(!open),
    className: "w-full flex justify-between items-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__["default"]["bookmark"], (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h4", {
    className: "text-base font-medium leading-[1.625rem] text-slate-800 ml-2"
  }, (0,react_html_parser__WEBPACK_IMPORTED_MODULE_4__["default"])(category.name))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: ` ${open ? "rotate-0" : "-rotate-90"} transition-rotate duration-300 ease-in-out`
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__["default"]["expand"])), open && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-5"
  }, !!subcategories.length && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ml-2"
  }, subcategories.map((subItem, key) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(SubSection, {
    item: subItem,
    key: key
  }))), !!docs.length && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "space-y-1 mb-5"
  }, docs.splice(0, 5).map((doc, key) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: doc.url + "?utm_source=free-theme&utm_medium=dashboard&utm_campaign=knowledge",
    target: "_blank",
    className: "flex items-center justify-between text-slate-800 rounded-md p-2 pl-0 hover:bg-gray-50 group cursor-pointer focus:outline-0",
    key: key
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center ast-kb-caret"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__["default"]["caret"]), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-base leading-[1.625rem] text-slate-800 ml-2"
  }, (0,react_html_parser__WEBPACK_IMPORTED_MODULE_4__["default"])(doc.title))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-slate-600 invisible group-hover:visible"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__["default"]["redirect"])))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: astra_admin.websiteUrl?.docsCategoryDynamicUrl?.replace('#category#', categorySlug),
    target: "_blank",
    className: "text-base font-medium leading-4 text-astra flex items-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "mr-2"
  }, `View all ${(0,react_html_parser__WEBPACK_IMPORTED_MODULE_4__["default"])(category.name)} docs`), _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__["default"]["redirect"])), !docsCount && !subcategories.length && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("No docs found!", "astra"))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SubSection);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/docs/UpgradeToPro.js":
/*!*************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/docs/UpgradeToPro.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _astra_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @astra-components */ "./assets/components/index.js");





const UpgradeToPro = () => {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative flex bg-blue-50 py-5 pl-4 pr-10 border border-sky-500 rounded-md"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mr-3"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]['checkbadge']), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h4", {
    className: "text-base font-semibold leading-5 text-slate-800 mb-1.5"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Upgrade to Astra Pro', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm text-slate-600 mb-3"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Get access to powerful features for painless WordPress designing, without the high costs. With all the time you will save, it’s a product that pays for itself!', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_4__.ProButton, {
    className: "text-sm text-astra text-medium"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "absolute top-4 right-4 leading-[1rem] font-medium text-[0.625rem] text-white bg-slate-800 rounded-[0.1875rem] py-[0rem] px-1.5"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('PRO', 'astra')));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UpgradeToPro);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/free-vs-pro/FreeVsPro.js":
/*!*****************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/free-vs-pro/FreeVsPro.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./data */ "./assets/src/dashboard-app/pages/free-vs-pro/data.js");
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var _astra_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @astra-components */ "./assets/components/index.js");





const FreeVsPro = () => {
  const checkStatus = value => {
    if (value === "yes") {
      return _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__["default"]['check'];
    } else if (value === "no") {
      return _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__["default"]['xclose'];
    } else {
      return value;
    }
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("main", {
    className: "py-[2.43rem]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-w-3xl mx-auto px-6 lg:max-w-7xl"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", {
    className: "sr-only"
  }, " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Astra Free Vs Pro", "astra"), " "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-row justify-between items-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-lg sm:text-2xl font-semibold capitalize"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Astra Free vs Pro', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_4__.ProButton, {
    className: "inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-astra focus-visible:bg-astra-hover hover:bg-astra-hover focus:outline-none"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-8 flex flex-col"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "-my-2 -mx-4 overflow-x-auto sm:-mx-6 lg:-mx-8"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "inline-block min-w-full py-2 align-middle md:px-6 lg:px-8"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "overflow-hidden shadow-overlay-light md:rounded-lg"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("table", {
    className: "min-w-full divide-y divide-slate-200"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("thead", {
    className: "bg-white"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tr", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("th", {
    scope: "col",
    className: "py-3.5 pl-4 pr-3 text-left text-base font-medium text-slate-800 sm:pl-8"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Features", "astra")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("th", {
    scope: "col",
    className: "px-3 py-3.5 text-center text-base font-medium text-slate-800"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Free", "astra")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("th", {
    scope: "col",
    className: "px-3 py-3.5 text-center text-base font-medium text-slate-800"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Pro", "astra")))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tbody", {
    className: "divide-y divide-slate-200 bg-white"
  }, _data__WEBPACK_IMPORTED_MODULE_2__.features.map((feature, key) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tr", {
    key: key
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", {
    className: "whitespace-nowrap py-4 pl-4 pr-3 text-base text-slate-600 sm:pl-8"
  }, feature.name), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", {
    className: "whitespace-nowrap capitalize px-3 py-4 text-base text-center text-slate-600"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-center font-medium"
  }, checkStatus(feature.free))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", {
    className: "whitespace-nowrap capitalize px-3 py-4 text-base text-center text-slate-600"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex justify-center font-medium"
  }, checkStatus(feature.pro))))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex items-center justify-center text-astra hover:text-astra-hover text-base font-medium text-center bg-white py-4 border-t border-t-slate-200"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_4__.ProButton, {
    className: "flex items-center justify-center",
    disableSpinner: true
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "mr-2"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("See all Astra Pro features", "astra")), _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__["default"]['redirect'])))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    className: "mt-6 py-10 flex flex-col bg-slate-200 items-center justify-center shadow-overlay-light rounded-md"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mb-3"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "ml-1 sm:ml-2 text-[0.625rem] leading-[1rem] font-medium text-white border border-slate-800 bg-slate-800 rounded-[0.1875rem] relative inline-flex flex-shrink-0 py-[0rem] px-1.5"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("PRO", "astra"))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h4", {
    className: "text-2xl font-semibold text-slate-800 mb-3"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Do More with Astra Pro", "astra")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-w-2xl text-center text-base text-slate-600 mb-7"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Get access to powerful features for painless WordPress designing, without the high costs. With all the time you will save, it’s a product that pays for itself!", "astra")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_4__.ProButton, {
    className: "inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-astra focus-visible:bg-astra-hover hover:bg-astra-hover focus:outline-none"
  }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FreeVsPro);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/free-vs-pro/data.js":
/*!************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/free-vs-pro/data.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   features: () => (/* binding */ features)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);

const features = [{
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('24/7 Premium Support', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Access To Pro Updates', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('CSS File Generation For Speed Optimization', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('White Label', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Page Background Styling', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Sidebar Designing Styles', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Colors and Backgrounds', 'astra'),
  free: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Limited Features', 'astra'),
  pro: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All Features', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Typography', 'astra'),
  free: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Limited Features', 'astra'),
  pro: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All Features', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Spacing', 'astra'),
  free: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Limited Features', 'astra'),
  pro: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All Features', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Full Width Site Layout', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Max Width Site Layout', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Padded Site Layout', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Fluid Site Layout', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Multiple Page Headers', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Custom Header', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Custom Footer', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Custom 404 Page', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Hooks Support to Add Custom Code', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Sticky When Scroll Up', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Shrink When Scroll Up', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Hide Sticky When Scroll Down', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Sticky Header Animations', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Mega Menu', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Multiple HTML Elements', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Multiple Button Elements', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Divider Elements', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Color & Typography Options', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Archive Page - Post Content Layouts', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Archive Page - Post Grid Control', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Archive Page - Post Readtime Meta Option', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Single Post Page - Post Readtime Meta Option', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Single Post Page - Author Info Box', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Single Post Page - Post Navigation Visibility Control', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Breadcrumbs Shortcode', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Search Box Shortcode', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('WooCommerce Mini-Cart Shortcode', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('EDD Mini-Cart Shortcode', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('WooCommerce', 'astra'),
  free: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Limited Features', 'astra'),
  pro: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All Features', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('LifterLMS', 'astra'),
  free: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Limited Features', 'astra'),
  pro: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All Features', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('LearnDash', 'astra'),
  free: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Limited Features', 'astra'),
  pro: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All Features', 'astra')
}, {
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Easy Digital Downloads', 'astra'),
  free: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Limited Features', 'astra'),
  pro: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All Features', 'astra')
}].map(feature => ({
  ...feature,
  free: feature.free || 'no',
  pro: feature.pro || 'yes'
}));

/***/ }),

/***/ "./assets/src/dashboard-app/pages/index.js":
/*!*************************************************!*\
  !*** ./assets/src/dashboard-app/pages/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CustomLayouts: () => (/* reexport safe */ _custom_layouts_CustomLayouts__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   Docs: () => (/* reexport safe */ _docs_Docs__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   ExtensionScreen: () => (/* reexport safe */ _woocommerce_ExtensionScreen__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   FreeVsPro: () => (/* reexport safe */ _free_vs_pro_FreeVsPro__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   Settings: () => (/* reexport safe */ _settings_Settings__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   SpectraScreen: () => (/* reexport safe */ _spectra_SpectraScreen__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   StarterTemplates: () => (/* reexport safe */ _starter_templates_StarterTemplates__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   Welcome: () => (/* reexport safe */ _welcome_Welcome__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _welcome_Welcome__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./welcome/Welcome */ "./assets/src/dashboard-app/pages/welcome/Welcome.js");
/* harmony import */ var _free_vs_pro_FreeVsPro__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./free-vs-pro/FreeVsPro */ "./assets/src/dashboard-app/pages/free-vs-pro/FreeVsPro.js");
/* harmony import */ var _settings_Settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./settings/Settings */ "./assets/src/dashboard-app/pages/settings/Settings.js");
/* harmony import */ var _starter_templates_StarterTemplates__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./starter-templates/StarterTemplates */ "./assets/src/dashboard-app/pages/starter-templates/StarterTemplates.js");
/* harmony import */ var _custom_layouts_CustomLayouts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./custom-layouts/CustomLayouts */ "./assets/src/dashboard-app/pages/custom-layouts/CustomLayouts.js");
/* harmony import */ var _spectra_SpectraScreen__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./spectra/SpectraScreen */ "./assets/src/dashboard-app/pages/spectra/SpectraScreen.js");
/* harmony import */ var _woocommerce_ExtensionScreen__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./woocommerce/ExtensionScreen */ "./assets/src/dashboard-app/pages/woocommerce/ExtensionScreen.js");
/* harmony import */ var _docs_Docs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./docs/Docs */ "./assets/src/dashboard-app/pages/docs/Docs.js");










/***/ }),

/***/ "./assets/src/dashboard-app/pages/settings/ContainerSettings.js":
/*!**********************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/settings/ContainerSettings.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _DashboardApp_pages_settings_LoadFontsLocally__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @DashboardApp/pages/settings/LoadFontsLocally */ "./assets/src/dashboard-app/pages/settings/LoadFontsLocally.js");
/* harmony import */ var _DashboardApp_pages_settings_PreloadLocalFonts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @DashboardApp/pages/settings/PreloadLocalFonts */ "./assets/src/dashboard-app/pages/settings/PreloadLocalFonts.js");
/* harmony import */ var _DashboardApp_pages_settings_FlushLocalFonts__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @DashboardApp/pages/settings/FlushLocalFonts */ "./assets/src/dashboard-app/pages/settings/FlushLocalFonts.js");
/* harmony import */ var _DashboardApp_pages_settings_OldHeaderFooter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @DashboardApp/pages/settings/OldHeaderFooter */ "./assets/src/dashboard-app/pages/settings/OldHeaderFooter.js");
/* harmony import */ var _DashboardApp_pages_settings_UpgradeNotices__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @DashboardApp/pages/settings/UpgradeNotices */ "./assets/src/dashboard-app/pages/settings/UpgradeNotices.js");








function SettingsWrapper({
  state
}) {
  const wrappers = wp.hooks.applyFilters('astra_dashboard.settings_tab_wrappers', {
    'global-settings': (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, " ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_settings_OldHeaderFooter__WEBPACK_IMPORTED_MODULE_6__["default"], null), " ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_settings_UpgradeNotices__WEBPACK_IMPORTED_MODULE_7__["default"], null), " "),
    'fonts-performance': (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, " ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_settings_LoadFontsLocally__WEBPACK_IMPORTED_MODULE_3__["default"], null), " ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_settings_PreloadLocalFonts__WEBPACK_IMPORTED_MODULE_4__["default"], null), " ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_settings_FlushLocalFonts__WEBPACK_IMPORTED_MODULE_5__["default"], null), " ")
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, wrappers[state]);
}
const ContainerSettings = () => {
  const activeSettingsNavigationTab = (0,react_redux__WEBPACK_IMPORTED_MODULE_2__.useSelector)(state => state.activeSettingsNavigationTab);

  // Parent Div is Required to add Padding to the Entire Structure for Smaller Windows.
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "lg:col-span-9 border-l"
  }, wp.hooks.applyFilters(`astra_dashboard.settings_screen_before_${activeSettingsNavigationTab}`, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(SettingsWrapper, {
    state: activeSettingsNavigationTab
  }), wp.hooks.applyFilters(`astra_dashboard.settings_screen_after_${activeSettingsNavigationTab}`, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContainerSettings);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/settings/FlushLocalFonts.js":
/*!********************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/settings/FlushLocalFonts.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");





const FlushLocalFonts = () => {
  const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useDispatch)();
  const enableLoadFontsLocally = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(state => state.enableLoadFontsLocally);
  const [regenerateAssetsState, setRegenerateAssetsState] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const regenerateLocalFontAssets = () => {
    setRegenerateAssetsState('loading');
    const formData = new window.FormData();
    formData.append('action', 'astra_regenerate_fonts_folder');
    formData.append('security', astra_admin.update_nonce);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
      url: astra_admin.ajax_url,
      method: 'POST',
      body: formData
    }).then(data => {
      if (data.success) {
        dispatch({
          type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
          payload: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Assets Regenerated!', 'astra')
        });
      } else {
        dispatch({
          type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
          payload: data.data.message
        });
      }
      setRegenerateAssetsState(false);
    }).catch(error => {
      console.error('Error during assets regeneration:', error);
      dispatch({
        type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
        payload: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('An error occurred while regenerating assets.', 'astra')
      });
      setRegenerateAssetsState(false);
    });
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    className: `astra-dep-field-${enableLoadFontsLocally} block border-b border-solid border-slate-200 px-8 py-8 justify-between`
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-full flex flex-col sm:flex-row justify-between"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "p-0 text-xl leading-6 font-semibold text-slate-800"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Flush Local Fonts Cache", "astra")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "mt-2 text-sm text-slate-600"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Click the button to reset the local fonts cache.', 'astra'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-2 sm:mt-0"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    type: "button",
    className: "inline-flex px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-astra focus-visible:bg-astra-hover hover:bg-astra-hover focus:outline-none",
    onClick: regenerateLocalFontAssets
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Flush Local Font Files", "astra"), 'loading' === regenerateAssetsState && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    className: "animate-spin -mr-1 ml-3 h-5 w-5 text-white",
    xmlns: "http://www.w3.org/2000/svg",
    fill: "none",
    viewBox: "0 0 24 24"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    className: "opacity-25",
    cx: "12",
    cy: "12",
    r: "10",
    stroke: "currentColor",
    strokeWidth: "4"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    className: "opacity-75",
    fill: "currentColor",
    d: "M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"
  }))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FlushLocalFonts);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/settings/LoadFontsLocally.js":
/*!*********************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/settings/LoadFontsLocally.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/components/switch/switch.js");
/* harmony import */ var _astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @astra-utils/helpers */ "./assets/utils/helpers.js");






const LoadFontsLocally = () => {
  const abortControllerRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)({});
  const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useDispatch)();
  const enableLoadFontsLocally = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useSelector)(state => state.enableLoadFontsLocally);
  const enableLoadFontsLocallyStatus = false === enableLoadFontsLocally ? false : true;
  const updateLoadFontsLocallyStatus = () => {
    const assetStatus = !enableLoadFontsLocally;
    dispatch({
      type: 'UPDATE_ENABLE_LOAD_FONTS_LOCALLY',
      payload: assetStatus
    });
    (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.saveSetting)('self_hosted_gfonts', assetStatus, dispatch, abortControllerRef);
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    className: "block border-b border-solid border-slate-200 px-8 py-8 justify-between"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mr-16 w-full flex items-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "p-0 flex-1 justify-right inline-flex text-xl leading-6 font-semibold text-slate-800"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Load Google Fonts Locally', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_5__.Switch, {
    checked: enableLoadFontsLocallyStatus,
    onChange: updateLoadFontsLocallyStatus,
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.classNames)(enableLoadFontsLocallyStatus ? 'bg-astra' : 'bg-slate-200', 'group relative inline-flex h-4 w-9 flex-shrink-0 cursor-pointer items-center justify-center rounded-full focus:outline-none focus:ring-2 focus:ring-astra focus:ring-offset-2')
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: "pointer-events-none absolute h-full w-full rounded-md bg-white"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.classNames)(enableLoadFontsLocallyStatus ? 'bg-astra' : 'bg-gray-200', 'pointer-events-none absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out')
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.classNames)(enableLoadFontsLocallyStatus ? 'translate-x-5' : 'translate-x-0', 'toggle-bubble pointer-events-none absolute left-0 inline-block h-5 w-5 transform rounded-full border border-gray-200 bg-white shadow ring-0 transition-transform duration-200 ease-in-out')
  }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "mt-2 w-9/12 text-sm text-slate-500 tablet:w-full"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Enable this option to download Google fonts and save them on your server. This can be great for improving speed of your website and to comply with GDPR laws.', 'astra')));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoadFontsLocally);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/settings/OldHeaderFooter.js":
/*!********************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/settings/OldHeaderFooter.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/components/switch/switch.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @astra-utils/helpers */ "./assets/utils/helpers.js");






const OldHeaderFooter = () => {
  if (astra_admin.show_builder_migration) {
    return '';
  }
  const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_2__.useDispatch)();
  const useOldHeaderFooter = (0,react_redux__WEBPACK_IMPORTED_MODULE_2__.useSelector)(state => state.useOldHeaderFooter);
  const useOldHeaderFooterStatus = false === useOldHeaderFooter ? false : true;
  const updateHeaderFooterVersion = () => {
    let assetStatus;
    if (useOldHeaderFooter === false) {
      assetStatus = true;
    } else {
      assetStatus = false;
    }
    dispatch({
      type: 'USE_OLD_HEADER_FOOTER',
      payload: assetStatus
    });
    const formData = new window.FormData();
    formData.append('action', 'ast_migrate_to_builder');
    formData.append('security', astra_admin.update_nonce);
    formData.append('status', assetStatus);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
      url: astra_admin.ajax_url,
      method: 'POST',
      body: formData
    }).then(() => {
      dispatch({
        type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
        payload: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Successfully saved!', 'astra')
      });
    }).catch(error => {
      console.error('Error during API request:', error);
      dispatch({
        type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
        payload: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('An error occurred while saving.', 'astra')
      });
    });
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.classNames)(astra_admin.pro_available ? 'border-t' : '', 'block border-b border-solid border-slate-200 px-8 py-8 justify-between')
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mr-16 w-full flex items-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "p-0 flex-1 justify-right inline-flex text-xl leading-8 font-semibold text-slate-800"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Use New Header/Footer Builder', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_5__.Switch, {
    checked: useOldHeaderFooterStatus,
    onChange: updateHeaderFooterVersion,
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.classNames)(useOldHeaderFooterStatus ? 'bg-astra' : 'bg-slate-200', 'group relative inline-flex h-4 w-9 flex-shrink-0 cursor-pointer items-center justify-center rounded-full focus:outline-none focus:ring-2 focus:ring-astra focus:ring-offset-2')
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: "pointer-events-none absolute h-full w-full rounded-md bg-white"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.classNames)(useOldHeaderFooterStatus ? 'bg-astra' : 'bg-gray-200', 'pointer-events-none absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out')
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.classNames)(useOldHeaderFooterStatus ? 'translate-x-5' : 'translate-x-0', 'toggle-bubble pointer-events-none absolute left-0 inline-block h-5 w-5 transform rounded-full border border-gray-200 bg-white shadow ring-0 transition-transform duration-200 ease-in-out')
  }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "mt-2 w-11/12 text-sm text-slate-500"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)(`${astra_admin.theme_name} Header/Footer Builder is a new and powerful way to design header and footer for your website. With this, you can give a creative look to your header/footer with less effort. Activating this feature will add advanced options to ${astra_admin.theme_name} customizer where you can create awesome new designs.`, "astra")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "mt-2 w-full text-sm text-slate-500"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)(`After years of evolution and updates, the old header footer builder is at the point where it can no longer handle all of the new features. We recommend that you upgrade to the new header footer builder which has an assortment of new features and provides a more seamless experience.`, "astra")));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OldHeaderFooter);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/settings/PreloadLocalFonts.js":
/*!**********************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/settings/PreloadLocalFonts.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/components/switch/switch.js");
/* harmony import */ var _astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @astra-utils/helpers */ "./assets/utils/helpers.js");






const PreloadLocalFonts = () => {
  const abortControllerRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)({});
  const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useDispatch)();
  const enableLoadFontsLocally = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useSelector)(state => state.enableLoadFontsLocally);
  const enablePreloadLocalFonts = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useSelector)(state => state.enablePreloadLocalFonts);
  const enablePreloadLocalFontsStatus = false === enablePreloadLocalFonts ? false : true;
  const updatePreloadLocalFontsStatus = () => {
    const assetStatus = !enablePreloadLocalFonts;
    dispatch({
      type: 'UPDATE_ENABLE_PRELOAD_LOCAL_FONTS',
      payload: assetStatus
    });
    (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.saveSetting)('preload_local_fonts', assetStatus, dispatch, abortControllerRef);
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    className: `astra-dep-field-${enableLoadFontsLocally} block border-b border-solid border-slate-200 px-8 py-8 justify-between`
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mr-16 w-full flex items-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "p-0 flex-1 justify-right inline-flex text-xl leading-6 font-semibold text-slate-800"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Preload Local Fonts', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_5__.Switch, {
    checked: enablePreloadLocalFontsStatus,
    onChange: updatePreloadLocalFontsStatus,
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.classNames)(enablePreloadLocalFontsStatus ? 'bg-astra' : 'bg-slate-200', 'group relative inline-flex h-4 w-9 flex-shrink-0 cursor-pointer items-center justify-center rounded-full focus:outline-none focus:ring-2 focus:ring-astra focus:ring-offset-2')
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: "pointer-events-none absolute h-full w-full rounded-md bg-white"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.classNames)(enablePreloadLocalFontsStatus ? 'bg-astra' : 'bg-gray-200', 'pointer-events-none absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out')
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_4__.classNames)(enablePreloadLocalFontsStatus ? 'translate-x-5' : 'translate-x-0', 'toggle-bubble pointer-events-none absolute left-0 inline-block h-5 w-5 transform rounded-full border border-gray-200 bg-white shadow ring-0 transition-transform duration-200 ease-in-out')
  }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "mt-2 w-9/12 text-sm text-slate-500 tablet:w-full"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('This option will load the font files right away on page load. Preloading Local Fonts can speeds up your website even further.', 'astra')));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreloadLocalFonts);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/settings/Settings.js":
/*!*************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/settings/Settings.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _DashboardApp_pages_settings_ContainerSettings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @DashboardApp/pages/settings/ContainerSettings */ "./assets/src/dashboard-app/pages/settings/ContainerSettings.js");
/* harmony import */ var _DashboardApp_pages_settings_SettingsSkeleton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @DashboardApp/pages/settings/SettingsSkeleton */ "./assets/src/dashboard-app/pages/settings/SettingsSkeleton.js");
/* harmony import */ var _astra_utils_helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @astra-utils/helpers */ "./assets/utils/helpers.js");
/* harmony import */ var _SettingsIcons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SettingsIcons */ "./assets/src/dashboard-app/pages/settings/SettingsIcons.js");









const Settings = () => {
  const query = new URLSearchParams((0,react_router_dom__WEBPACK_IMPORTED_MODULE_8__.useLocation)()?.search);
  const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useDispatch)();
  const activeSettingsNavigationTab = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useSelector)(state => state.activeSettingsNavigationTab);
  const initialStateSetFlag = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useSelector)(state => state.initialStateSetFlag);
  const navigation = wp.hooks.applyFilters('astra_dashboard.settings_navigation', [{
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('General', 'astra'),
    slug: 'global-settings',
    icon: _SettingsIcons__WEBPACK_IMPORTED_MODULE_7__["default"]['global-settings']
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Performance', 'astra'),
    slug: 'fonts-performance',
    icon: _SettingsIcons__WEBPACK_IMPORTED_MODULE_7__["default"]['fonts-performance']
  }]);
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    // Activate Setting Active Tab from "settingsTab" Hash in the URl is present.
    const activePath = query.get('path');
    const activeHash = query.get('settings');
    const activeSettingsTabFromHash = activeHash && 'settings' === activePath ? activeHash : 'global-settings';
    dispatch({
      type: 'UPDATE_SETTINGS_ACTIVE_NAVIGATION_TAB',
      payload: activeSettingsTabFromHash
    });
  }, [initialStateSetFlag]);
  if (!initialStateSetFlag) {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_settings_SettingsSkeleton__WEBPACK_IMPORTED_MODULE_5__["default"], null);
  }

  // Parent div is Required to add Padding to the Entire Structure for Smaller Windows.
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-6 w-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mx-auto mt-10 mb-8 font-semibold text-2xl lg:max-w-[80rem]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Settings', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("main", {
    className: "mx-auto my-[2.43rem] bg-white rounded-md shadow overflow-hidden min-h-[36rem] lg:max-w-[80rem]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "lg:grid lg:grid-cols-12 min-h-[36rem] h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("aside", {
    className: "py-6 sm:px-6 lg:py-6 lg:px-0 lg:col-span-3"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("nav", {
    className: "space-y-1"
  }, navigation.map(item => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link // eslint-disable-line
  , {
    to: {
      search: `?page=${astra_admin.home_slug}&path=settings&settings=${item.slug}`
    },
    key: item.name,
    className: (0,_astra_utils_helpers__WEBPACK_IMPORTED_MODULE_6__.classNames)(activeSettingsNavigationTab === item.slug ? 'border-astra text-astra focus:text-astra-hover active:text-astra hover:text-astra-hover stroke-astra fill-astra focus:stroke-astra focus:fill-astra hover:stroke-astra hover:fill-astra' : 'border-white text-slate-800 stroke-slate-800 fill-slate-800 focus:text-slate-900 focus:border-slate-200 focus:stroke-slate-900 focus:fill-slate-900 hover:text-slate-900 hover:border-slate-200 hover:stroke-slate-900 hover:fill-slate-900', 'border-l-4 group cursor-pointer py-3 pl-5 flex items-center text-base font-medium'),
    onClick: () => {
      dispatch({
        type: 'UPDATE_SETTINGS_ACTIVE_NAVIGATION_TAB',
        payload: item.slug
      });
    }
  }, item.icon, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "truncate"
  }, item.name))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_settings_ContainerSettings__WEBPACK_IMPORTED_MODULE_4__["default"], null))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Settings);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/settings/SettingsIcons.js":
/*!******************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/settings/SettingsIcons.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);

const SettingsIcons = {
  'fonts-performance': (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    className: "flex-shrink-0 mr-4 stroke-inherit",
    width: "18",
    height: "18",
    viewBox: "0 0 18 18",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9 3V1M9 3C7.89543 3 7 3.89543 7 5C7 6.10457 7.89543 7 9 7M9 3C10.1046 3 11 3.89543 11 5C11 6.10457 10.1046 7 9 7M3 15C4.10457 15 5 14.1046 5 13C5 11.8954 4.10457 11 3 11M3 15C1.89543 15 1 14.1046 1 13C1 11.8954 1.89543 11 3 11M3 15V17M3 11V1M9 7V17M15 15C16.1046 15 17 14.1046 17 13C17 11.8954 16.1046 11 15 11M15 15C13.8954 15 13 14.1046 13 13C13 11.8954 13.8954 11 15 11M15 15V17M15 11V1",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  'global-settings': (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    className: "flex-shrink-0 mr-4 stroke-inherit",
    fill: "none",
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.32463 2.31731C8.75103 0.560897 11.249 0.560897 11.6754 2.31731C11.9508 3.45193 13.2507 3.99038 14.2478 3.38285C15.7913 2.44239 17.5576 4.2087 16.6172 5.75218C16.0096 6.74925 16.5481 8.04918 17.6827 8.32463C19.4391 8.75103 19.4391 11.249 17.6827 11.6754C16.5481 11.9508 16.0096 13.2507 16.6172 14.2478C17.5576 15.7913 15.7913 17.5576 14.2478 16.6172C13.2507 16.0096 11.9508 16.5481 11.6754 17.6827C11.249 19.4391 8.75103 19.4391 8.32463 17.6827C8.04918 16.5481 6.74926 16.0096 5.75219 16.6172C4.2087 17.5576 2.44239 15.7913 3.38285 14.2478C3.99038 13.2507 3.45193 11.9508 2.31731 11.6754C0.560897 11.249 0.560897 8.75103 2.31731 8.32463C3.45193 8.04918 3.99037 6.74926 3.38285 5.75218C2.44239 4.2087 4.2087 2.44239 5.75219 3.38285C6.74926 3.99037 8.04918 3.45193 8.32463 2.31731Z",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M13 10C13 11.6569 11.6569 13 10 13C8.34315 13 7 11.6569 7 10C7 8.34315 8.34315 7 10 7C11.6569 7 13 8.34315 13 10Z",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }))
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsIcons);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/settings/SettingsSkeleton.js":
/*!*********************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/settings/SettingsSkeleton.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Skeleton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @Skeleton */ "./assets/src/common/skeleton/index.js");


const SettingsSkeleton = () => {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-6 w-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-w-3xl mx-auto lg:max-w-[80rem] mt-10 mb-8 font-semibold text-2xl"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Skeleton__WEBPACK_IMPORTED_MODULE_1__.RectSkeleton, {
    width: "100px",
    height: "32px"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("main", {
    className: "max-w-[80rem] mx-auto my-[2.43rem] bg-white rounded-md shadow overflow-hidden h-[36rem]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "lg:grid lg:grid-cols-12 h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("aside", {
    className: "py-6 sm:px-6 lg:py-6 lg:px-5 lg:col-span-3"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("nav", {
    className: "space-y-1"
  }, Array(7).fill().map((i, index) => {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: `setting${index}`,
      className: "flex justify-left items-center py-3 space-x-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Skeleton__WEBPACK_IMPORTED_MODULE_1__.RectSkeleton, {
      key: `icon${index}`,
      width: "24px",
      height: "24px"
    }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Skeleton__WEBPACK_IMPORTED_MODULE_1__.TextSkeleton, {
      key: index,
      width: "120px",
      fontSize: "16px"
    }));
  }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "border-l lg:col-span-9 p-8"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Skeleton__WEBPACK_IMPORTED_MODULE_1__.TextSkeleton, {
    fontSize: "35px",
    width: "225px"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Skeleton__WEBPACK_IMPORTED_MODULE_1__.TextSkeleton, {
    width: "80%"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "h-8"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Skeleton__WEBPACK_IMPORTED_MODULE_1__.TextSkeleton, {
    fontSize: "35px",
    width: "300px"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Skeleton__WEBPACK_IMPORTED_MODULE_1__.TextSkeleton, {
    width: "60%"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "h-8"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Skeleton__WEBPACK_IMPORTED_MODULE_1__.TextSkeleton, {
    fontSize: "35px",
    width: "210px"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Skeleton__WEBPACK_IMPORTED_MODULE_1__.TextSkeleton, {
    width: "65%"
  })))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsSkeleton);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/settings/UpgradeNotices.js":
/*!*******************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/settings/UpgradeNotices.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _astra_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @astra-components */ "./assets/components/index.js");






const UpgradeNotices = () => {
  if (astra_admin.pro_available) {
    return '';
  }
  const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useDispatch)();
  const useUpgradeNotices = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useSelector)(state => state.useUpgradeNotices);
  const [upgradeNoticesState, setUpgradeNoticesState] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  const updateUpgradeNoticesVisibility = () => {
    setUpgradeNoticesState('updating');
    let assetStatus;
    if (useUpgradeNotices === false) {
      assetStatus = true;
    } else {
      assetStatus = false;
    }
    dispatch({
      type: 'UPGRADE_NOTICES',
      payload: assetStatus
    });
    const formData = new window.FormData();
    formData.append('action', 'ast_disable_pro_notices');
    formData.append('security', astra_admin.update_nonce);
    formData.append('status', assetStatus);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4___default()({
      url: astra_admin.ajax_url,
      method: 'POST',
      body: formData
    }).then(data => {
      if (data.success) {
        let payloadStatus = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Deactivated!', 'astra');
        if (assetStatus) {
          payloadStatus = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Activated!', 'astra');
        }
        dispatch({
          type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
          payload: payloadStatus
        });
        setUpgradeNoticesState(false);
      }
    }).catch(error => {
      console.error('Error during activation/deactivation:', error);
    });
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    className: "block px-8 py-8 justify-between"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mr-16 w-full flex flex-col sm:flex-row sm:items-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "p-0 flex-1 justify-right inline-flex text-xl leading-8 font-semibold text-slate-800"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Build Better Websites with Astra Pro', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_5__.ProButton, {
    className: "inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-astra transition focus:bg-astra-hover hover:bg-astra-hover focus:outline-none h-9"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "mt-2 w-full md:w-9/12 text-sm text-slate-500 tablet:w-full"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)(`Access powerful features for painless WordPress design without the high costs. Powerful tools, premium support, limitless opportunity with Pro! Toggle upgrade notices on or off `, "astra"), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    onClick: updateUpgradeNoticesVisibility,
    className: "cursor-pointer text-astra focus:text-astra-hover active:text-astra-hover hover:text-astra-hover",
    rel: "noreferrer"
  }, 'updating' === upgradeNoticesState ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('updating...', 'astra') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('here.', 'astra'))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UpgradeNotices);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/spectra/SpectraScreen.js":
/*!*****************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/spectra/SpectraScreen.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);





const spectraFeatures = [{
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Super Fast and Stable', 'astra'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Spectra works with the native WordPress editor with no dependency on external code. So, it is fast and stable.', 'astra'),
  icon: 'superfast'
}, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Secure and Integrated', 'astra'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Clean code written using the latest standards to maximize security and work flawlessly with any WordPress plugin.', 'astra'),
  icon: 'secure'
}, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Native WordPress Interface', 'astra'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Spectra Integrates into the same WordPress editor, making it super intuitive website builder.', 'astra'),
  icon: 'nativewp'
}, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Google Will Love and Rank', 'astra'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Score 100% in CWV. Clean code output and lightning-fast load times keep visitors and search engines happy.', 'astra'),
  icon: 'googlelove'
}, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Zero Bloat, No Dependencies', 'astra'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Fewer external scripts and dependencies keep the code clean, resulting in small file sizes and faster loading times.', 'astra'),
  icon: 'zerobloat'
}, {
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Just-in-time Compiler', 'astra'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Loads assets dynamically on demand. Assets are loaded for only those blocks that are used on a page.', 'astra'),
  icon: 'compiler'
}];
const SpectraScreen = () => {
  const query = new URLSearchParams((0,react_router_dom__WEBPACK_IMPORTED_MODULE_4__.useLocation)()?.search);
  const allowAutoPlay = "1" === query.get("astra-activation-redirect") ? 1 : 0;
  const videoID = 'GLNzTxArR6Y';
  const handleSpectraPluginAction = e => {
    let spectraPluginStatus = astra_admin.spectra_plugin_status;
    const formData = new window.FormData();
    if ('install' === spectraPluginStatus) {
      formData.append('action', 'astra_recommended_plugin_install');
      formData.append('slug', 'ultimate-addons-for-gutenberg');
      formData.append('init', 'ultimate-addons-for-gutenberg/ultimate-addons-for-gutenberg.php');
      formData.append('_ajax_nonce', astra_admin.plugin_installer_nonce);
      e.target.innerText = astra_admin.plugin_installing_text;
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
        url: astra_admin.ajax_url,
        method: 'POST',
        body: formData
      }).then(data => {
        if (data.success) {
          e.target.innerText = astra_admin.plugin_installed_text;
          activatePlugin(e);
        }
      }).catch(error => {
        console.error('Error during plugin installation:', error);
      });
    } else if ('installed' === spectraPluginStatus) {
      activatePlugin(e);
    } else {
      // Do nothing.
    }
  };
  const activatePlugin = e => {
    const formData = new window.FormData();
    formData.append('action', 'astra_recommended_plugin_activate');
    formData.append('security', astra_admin.plugin_manager_nonce);
    formData.append('init', 'ultimate-addons-for-gutenberg/ultimate-addons-for-gutenberg.php');
    e.target.innerText = astra_admin.plugin_activating_text;
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default()({
      url: astra_admin.ajax_url,
      method: 'POST',
      body: formData
    }).then(data => {
      if (data.success) {
        e.target.innerText = astra_admin.plugin_activated_text;
        window.location = `${astra_admin.admin_base_url}options-general.php?page=spectra`;
      }
    }).catch(error => {
      console.error('Error during plugin activation:', error);
    });
  };
  const getSpectraPluginTitle = () => {
    if ('install' === astra_admin.spectra_plugin_status) {
      return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, " ", (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "mr-3"
      }, " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Install Spectra - It’s free", "astra"), " "), " ", _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]["download"], " ");
    } else if ('installed' === astra_admin.spectra_plugin_status) {
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Activate Spectra", "astra");
    } else {
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Explore Spectra", "astra");
    }
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("main", {
    className: "bg-white pb-14 pt-20"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mx-auto px-6 max-w-[45rem]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", {
    className: "sr-only"
  }, " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Spectra - WordPress Free Page Builder", "astra"), " "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col items-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "absolute top-0 tablet:none"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]['spectraBackgroundLogo'])), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative flex flex-col items-center"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]["spectra-logo"], (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-4xl sm:text-[2.5rem] text-slate-800 font-semibold capitalize mb-2 mt-7"
  }, `${astra_admin.theme_name} + Spectra = `, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-[1em] leading-[1em]"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]['heart-logo'])), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base leading-[1.625rem] mb-7"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Spectra is 100% beginner friendly and enhances the default WordPress block editor.', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: `inline-flex w-[35%] justify-center items-center px-4 py-3 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-astra focus-visible:bg-astra-hover hover:bg-astra-hover hover:text-white focus:text-white active:text-white focus:outline-none mr-4`,
    onClick: handleSpectraPluginAction
  }, getSpectraPluginTitle()), astra_admin.show_banner_video && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative pb-[25.375rem] mt-12 w-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("iframe", {
    className: "absolute inset-0 w-full h-full rounded-md",
    src: `https://www.youtube-nocookie.com/embed/${videoID}?showinfo=0&autoplay=${allowAutoPlay}&mute=${allowAutoPlay}&rel=0`,
    allow: "autoplay",
    title: "YouTube video player",
    frameBorder: "0",
    allowFullScreen: true
  }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid grid-cols-2 gap-12 mt-16 px-0 sm:px-8"
  }, spectraFeatures.map((feature, key) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    key: key
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, " ", _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"][feature.icon], " "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h4", {
    className: "text-base leading-[1.625rem] text-slate-800 font-medium mt-4 mb-1"
  }, feature.title), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm leading-[1.375rem] text-slate-600"
  }, feature.description)))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col items-center justify-center mt-20 mx-0 sm:mx-[4.5rem]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "text-[2rem] leading-10 font-semibold text-slate-800 mb-6 text-center"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Build Ultra High Performance Websites, Without Coding", "astra")), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: `inline-flex w-[45%] justify-center items-center px-4 py-3 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-astra focus-visible:bg-astra-hover hover:bg-astra-hover hover:text-white focus:text-white active:text-white focus:outline-none mr-4`,
    onClick: handleSpectraPluginAction
  }, getSpectraPluginTitle()))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SpectraScreen);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/starter-templates/StarterTemplates.js":
/*!******************************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/starter-templates/StarterTemplates.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var _Utils_extensions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Utils/extensions */ "./assets/src/utils/extensions.js");




const StarterTemplates = () => {
  if (!astra_admin.show_plugins) {
    return;
  }
  if (astra_admin.starter_templates_data.is_available) {
    window.open(astra_admin.starter_templates_data.redirection, '_self');
    return;
  }
  const handlePluginActionTrigger = e => (0,_Utils_extensions__WEBPACK_IMPORTED_MODULE_3__.triggerAction)(e);
  const getTitle = status => {
    if (status === "activated") {
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Activated', 'astra');
    } else if (status === "installed") {
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Activate', 'astra');
    } else {
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Install & Activate', 'astra');
    }
  };
  const onLearnMoreGuideClick = () => {
    window.open(astra_admin.astraWebsite?.templatesUrl, '_blank');
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("main", {
    className: "relative tablet:my-16"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-full blur-sm opacity-40"
  }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]['starter-canvas']), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-w-[39rem] h-max bg-white m-auto shadow-overlay-modal text-center rounded-lg p-8 absolute inset-3 top-[150%] sm:top-0 sm:inset-0"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mx-auto flex items-center justify-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: astra_admin.starter_templates_data.icon_path,
    width: "40px",
    height: "40px"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-3 text-center sm:mt-6"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h4", {
    className: "text-2xl font-semibold leading-7 text-slate-800",
    id: "modal-title"
  }, astra_admin.starter_templates_data.title), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mt-2"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-sm text-slate-500"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Create professional designed pixel perfect websites in minutes. Get access to 280+ pre-made full website templates for your favorite page builder.', 'astra'))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-center mt-5 sm:mt-6"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    "data-type": "button",
    className: "w-auto inline-flex items-center justify-center rounded-md border border-transparent bg-astra px-4 py-2 text-base font-medium text-white shadow-sm hover:bg-astra-hover focus:outline-none focus:ring-2 focus:ring-astra-hover focus:ring-offset-2 sm:text-sm",
    "data-slug": astra_admin.starter_templates_data.slug,
    "data-init": astra_admin.starter_templates_data.path,
    "data-redirection": astra_admin.starter_templates_data.redirection,
    "data-action": (0,_Utils_extensions__WEBPACK_IMPORTED_MODULE_3__.getAction)(astra_admin.starter_templates_data.status),
    onClick: handlePluginActionTrigger
  }, getTitle(astra_admin.starter_templates_data.status)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "w-auto justify-center mt-4 text-astra",
    onClick: onLearnMoreGuideClick
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn More', 'astra')))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StarterTemplates);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/welcome/ExtensionCard.js":
/*!*****************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/welcome/ExtensionCard.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/components/switch/switch.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ToolTip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ToolTip */ "./assets/src/dashboard-app/pages/welcome/ToolTip.js");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);






const classNames = (...classes) => classes.filter(Boolean).join(' ');
const ExtensionCard = props => {
  const {
    title,
    title_url,
    links,
    condition = true,
    deprecated = false
  } = props.moduleInfo;
  const slug = props.slug;
  const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useDispatch)();
  const blocksStatuses = (0,react_redux__WEBPACK_IMPORTED_MODULE_3__.useSelector)(state => state.blocksStatuses);
  const moduleActivationStatus = blocksStatuses && undefined !== blocksStatuses[slug] && slug == blocksStatuses[slug] ? true : false;
  function getAddonTitleColorClass(condition) {
    if (condition || !astra_admin.pro_available) {
      return 'text-slate-800';
    } else {
      return 'text-[#475569]';
    }
  }
  function getAddonLinksColorClass(condition, classes) {
    if (condition || !astra_admin.pro_available) {
      return classes;
    } else {
      return 'text-[#CBD5E1] ' + classes;
    }
  }
  function getWrapperClass(condition, addon) {
    if (condition || 'white-label' === addon) {
      return 'ast-addon-active';
    } else {
      return 'ast-addon-inactive';
    }
  }
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    key: slug,
    className: classNames(!astra_admin.pro_available || !condition ? classNames(!astra_admin.pro_available ? 'group' : '', 'bg-slate-50') : `bg-white ${getWrapperClass(moduleActivationStatus, slug)} `, 'box-border relative border rounded-md h-20 z-0 px-4 py-3 flex items-start gap-x-4 snap-start hover:shadow-md transition astra-icon-transition')
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex-1 min-w-0"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: `flex items-center text-base font-medium leading-7 ${getAddonTitleColorClass(condition)}`
  }, title, deprecated && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "inline-block align-top max-h-4 px-1.5 py-1 ml-1.5 text-[10px] leading-[10px] border border-slate-200 text-slate-400 rounded"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Legacy', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "group"
  }, astra_admin.pro_available && !condition && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "group inline-block align-middle ml-1 leading-none opacity-30 text-base dashicons dashicons-info"
  }), astra_admin.pro_available && !condition && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "w-max max-w-[17.125rem] absolute -top-[2.8rem] left-4 rounded-[0.1875rem] z-10 opacity-0 group-hover:opacity-100 invisible group-hover:visible transition-opacity duration-300 ease-in-out"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    id: "pro-tooltip-top",
    role: "tooltip",
    className: "text-left inline-block z-10 h-fit px-2.5 py-1.5 text-[0.75rem] leading-[1rem] text-white bg-slate-800 rounded-sm shadow-sm opacity-1 tooltip"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)(`${title} plugin needs to be installed / activated to enable this module.`, 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ml-8 mr-auto w-2 h-2 flex -mt-1 rotate-45 bg-slate-800 overflow-hidden"
  })))), links.map(link => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    key: Math.floor(Math.random() * 100000),
    className: classNames(getAddonLinksColorClass(condition, link.link_class), astra_admin.pro_available && !condition ? 'focus-visible:text-slate-500 active:text-slate-500 focus:text-slate-400 text-slate-400 text-base truncate pointer-events-none' : 'focus-visible:text-slate-500 active:text-slate-500 focus:text-slate-400 text-slate-400 text-base truncate'),
    href: link.link_url,
    target: link.target_blank ? "_blank" : "_self",
    rel: "noreferrer"
  }, link.link_text))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classNames(!astra_admin.pro_available ? 'text-[0.625rem] leading-[1rem] font-medium text-white bg-slate-800 border border-slate-800 rounded-[0.1875rem]' : 'self-center', astra_admin.pro_available && !condition ? 'relative inline-flex flex-shrink-0 py-[0rem] px-1.5 opacity-30 pointer-events-none' : 'relative inline-flex flex-shrink-0 py-[0rem] px-1.5')
  }, !astra_admin.pro_available && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('PRO', 'astra'), astra_admin.pro_available && 'white-label' !== slug && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_5__.Switch, {
    checked: moduleActivationStatus,
    onChange: () => {
      let status = false;
      let moduleId = slug;
      let moduleStatus = moduleActivationStatus ? 'deactivate' : 'activate';
      if (!moduleActivationStatus) {
        status = slug;
      }
      const optionsClone = {
        ...blocksStatuses
      };
      optionsClone[slug] = status;
      dispatch({
        type: 'UPDATE_BLOCK_STATUSES',
        payload: optionsClone
      });
      const formData = new window.FormData();
      formData.append('action', 'astra_addon_update_module_status');
      formData.append('security', astra_addon_admin.update_nonce);
      formData.append('module_status', moduleStatus); // activate/deactivate.
      formData.append('module_id', moduleId);
      _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default()({
        url: astra_admin.ajax_url,
        method: 'POST',
        body: formData
      }).then(data => {
        if (data.success) {
          dispatch({
            type: 'UPDATE_SETTINGS_SAVED_NOTIFICATION',
            payload: moduleStatus === 'activate' ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Successfully Activated!', 'astra') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Successfully Deactivated!', 'astra')
          });
          const reFormData = new window.FormData();
          reFormData.append('action', 'astra_refresh_assets_files');
          reFormData.append('security', astra_addon_admin.update_nonce);
          _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default()({
            url: astra_admin.ajax_url,
            method: 'POST',
            body: reFormData
          }).then(data => {
            if ("advanced-hooks" === slug) {
              location.reload(); // Reload the screen.
            }
          }).catch(error => {
            console.error('Error during cache refresh:', error);
          });
        }
      }).catch(error => {
        console.error('Error during activation/deactivation:', error);
      });
    },
    className: classNames(moduleActivationStatus ? 'bg-astra' : 'bg-slate-200', 'group relative inline-flex h-4 w-9 flex-shrink-0 cursor-pointer items-center justify-center rounded-full focus:outline-none focus:ring-2 focus:ring-astra focus:ring-offset-2')
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: "pointer-events-none absolute h-full w-full rounded-md bg-white"
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: classNames(moduleActivationStatus ? 'bg-astra' : 'bg-gray-200', 'pointer-events-none absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out')
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    "aria-hidden": "true",
    className: classNames(moduleActivationStatus ? 'translate-x-5' : 'translate-x-0', 'toggle-bubble pointer-events-none absolute left-0 inline-block h-5 w-5 transform rounded-full border border-gray-200 bg-white shadow ring-0 transition-transform duration-200 ease-in-out')
  }))), !astra_admin.pro_available && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_ToolTip__WEBPACK_IMPORTED_MODULE_2__["default"], null));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExtensionCard);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/welcome/ToolTip.js":
/*!***********************************************************!*\
  !*** ./assets/src/dashboard-app/pages/welcome/ToolTip.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);



const ToolTip = () => {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "absolute right-2.5 -top-[1.75rem] opacity-0 group-hover:opacity-100 invisible group-hover:visible transition-opacity duration-300 ease-in-out"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    id: "tooltip-top",
    role: "tooltip",
    className: "inline-block z-10 px-2.5 py-1.5 text-[0.75rem] leading-[1rem] text-white bg-slate-800 rounded-sm shadow-sm opacity-1 tooltip"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('This option only available on Astra Pro.', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ml-auto w-2 h-2 flex -mt-1 rotate-45 bg-slate-800 mr-4 overflow-hidden"
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ToolTip);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/welcome/VideoPopup.js":
/*!**************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/welcome/VideoPopup.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/components/transitions/transition.js");
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/components/dialog/dialog.js");



const VideoPopup = ({
  allowAutoPlay,
  videoPopup,
  toggleVideoPopup
}) => {
  const videoID = 'TBZd9oligCw';
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Transition.Root, {
    show: videoPopup,
    as: react__WEBPACK_IMPORTED_MODULE_1__.Fragment
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Dialog, {
    as: "div",
    className: "relative z-[10000]",
    onClick: toggleVideoPopup,
    onClose: toggleVideoPopup
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Transition.Child, {
    as: react__WEBPACK_IMPORTED_MODULE_1__.Fragment,
    enter: "ease-out duration-300",
    enterFrom: "opacity-0",
    enterTo: "opacity-100",
    leave: "ease-in duration-200",
    leaveFrom: "opacity-100",
    leaveTo: "opacity-0"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "fixed inset-0 bg-slate-800 bg-opacity-90 transition-opacity"
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "fixed inset-0 z-[10000] overflow-y-auto"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex min-h-full justify-center p-4 text-center items-center lg:p-0"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Transition.Child, {
    as: react__WEBPACK_IMPORTED_MODULE_1__.Fragment,
    enter: "ease-out duration-300",
    enterFrom: "opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95",
    enterTo: "opacity-100 translate-y-0 sm:scale-100",
    leave: "ease-in duration-200",
    leaveFrom: "opacity-100 translate-y-0 sm:scale-100",
    leaveTo: "opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative w-[24rem] md:w-[34rem] lg:w-[60rem] h-[14rem] md:h-[19rem] lg:h-[34rem]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("iframe", {
    className: "absolute inset-0 w-full h-full border-0 rounded-md",
    src: `https://www.youtube-nocookie.com/embed/${videoID}?showinfo=0&autoplay=${videoPopup ? 1 : 0}&rel=0`,
    allow: "autoplay",
    title: "YouTube video player",
    frameBorder: "0",
    allowFullScreen: true
  })))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VideoPopup);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/welcome/Welcome.js":
/*!***********************************************************!*\
  !*** ./assets/src/dashboard-app/pages/welcome/Welcome.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _DashboardApp_pages_Welcome_QuickSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @DashboardApp/pages/Welcome/QuickSettings */ "./assets/src/dashboard-app/pages/Welcome/QuickSettings.js");
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var _DashboardApp_pages_Welcome_ProModules__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @DashboardApp/pages/Welcome/ProModules */ "./assets/src/dashboard-app/pages/Welcome/ProModules.js");
/* harmony import */ var _DashboardApp_pages_Welcome_UsefulPlugins__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @DashboardApp/pages/Welcome/UsefulPlugins */ "./assets/src/dashboard-app/pages/Welcome/UsefulPlugins.js");
/* harmony import */ var _DashboardApp_pages_Welcome_AstraIntegration__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @DashboardApp/pages/Welcome/AstraIntegration */ "./assets/src/dashboard-app/pages/Welcome/AstraIntegration.js");
/* harmony import */ var _DashboardApp_pages_Welcome_BulkExtensionController__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @DashboardApp/pages/Welcome/BulkExtensionController */ "./assets/src/dashboard-app/pages/Welcome/BulkExtensionController.js");
/* harmony import */ var _VideoPopup__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./VideoPopup */ "./assets/src/dashboard-app/pages/welcome/VideoPopup.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _astra_components__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @astra-components */ "./assets/components/index.js");
/* harmony import */ var _astra_components_icons__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @astra-components/icons */ "./assets/components/icons/index.js");













const classNames = (...classes) => classes.filter(Boolean).join(" ");
const Welcome = () => {
  const query = new URLSearchParams((0,react_router_dom__WEBPACK_IMPORTED_MODULE_12__.useLocation)()?.search);
  const displayBannerVideo = astra_admin.show_banner_video ? true : false;
  const allowAutoPlay = "1" === query.get("astra-activation-redirect") ? 1 : 0;
  const onCustomizeClick = () => {
    window.open(astra_admin.customize_url, "_self");
  };
  const [videoPopup, setVideoPopup] = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(false);
  const toggleVideoPopup = () => {
    setVideoPopup(!videoPopup);
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("main", {
    className: "py-[2.43rem]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "max-w-3xl mx-auto px-6 lg:max-w-7xl"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", {
    className: "sr-only"
  }, " Astra "), astra_admin.show_self_branding && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid grid-cols-1 gap-4 items-start lg:grid-cols-5 lg:gap-0 xl:gap-0 rounded-md bg-white overflow-hidden shadow-sm px-8 py-8"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid grid-cols-1 gap-4 lg:col-span-3 h-full md:mr-[5.25rem]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    "aria-labelledby": "section-1-title h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "sr-only",
    id: "section-1-title"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Welcome Banner', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex flex-col justify-center h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: ""
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "pb-4 font-medium text-base text-slate-800"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Hello ", "astra") + astra_admin.current_user + ","), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "flex"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "text-slate-800 text-[2rem] leading-10 pb-3 font-semibold text-left"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Welcome to %s", "astra"), astra_admin.theme_name)), astra_admin.pro_available ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "ml-2 h-full inline-flex leading-[1rem] font-medium flex-shrink-0 py-[0rem] px-1.5 text-[0.625rem] text-white bg-slate-800 border border-slate-800 rounded-[0.1875rem] -tablet:mt:10"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('PRO', 'astra')) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "ml-2 h-full inline-flex leading-[1rem] flex-shrink-0 py-[0rem] px-1.5 text-[0.625rem] text-astra bg-blue-50 border border-blue-50 rounded-[0.1875rem] font-medium -tablet:mt:10"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('FREE', 'astra'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-base leading-[1.625rem] text-slate-600 pb-7"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("%s is fast, fully customizable & beautiful WordPress theme suitable for blog, personal portfolio, business website and WooCommerce storefront. It is very lightweight and offers unparalleled speed.", "astra"), astra_admin.theme_name)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "relative z-0 inline-flex flex-col sm:flex-row justify-start w-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    type: "button",
    className: "sm:inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-astra focus-visible:bg-astra-hover hover:bg-astra-hover focus:outline-none mr-4 mb-2 sm:mb-0",
    onClick: onCustomizeClick
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Start Customising", "astra")), displayBannerVideo && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "inline-flex items-center text-base font-medium text-astra focus:text-astra focus-visible:text-astra-hover active:text-astra-hover hover:text-astra-hover",
    onClick: toggleVideoPopup
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "pt-0.5 pl-4 pr-3"
  }, " ", _Common_block_icons__WEBPACK_IMPORTED_MODULE_3__["default"]["play"], " "), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)(`Watch the Quick Starter Guide`, "astra"))))))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid grid-cols-1 gap-4 lg:col-span-2 h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "astra-video-container"
  }, displayBannerVideo && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("iframe", {
    className: "astra-video rounded-md",
    src: `https://www.youtube-nocookie.com/embed/TBZd9oligCw?showinfo=0&autoplay=${allowAutoPlay}&mute=${allowAutoPlay}&rel=0`,
    allow: "autoplay",
    title: "YouTube video player",
    frameBorder: "0",
    allowFullScreen: true
  })))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid grid-cols-1 gap-[32px] items-start lg:grid-cols-3 lg:gap-[32px] xl:gap-[32px] mt-[32px]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classNames(astra_admin.show_self_branding ? "lg:col-span-2" : "lg:col-span-3", "grid grid-cols-1 gap-[32px]")
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    "aria-labelledby": "section-1-title h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "sr-only",
    id: "section-1-title"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Quick Links', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-[2rem] rounded-md bg-white overflow-hidden shadow-sm flex flex-col justify-center h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative w-full flex items-center justify-between"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "font-semibold text-xl leading-6 text-slate-800"
  }, " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Quick Settings", "astra"), " "), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    className: "lg:flex-shrink-0 text-sm font-medium text-astra focus:text-astra focus-visible:text-astra-hover active:text-astra-hover hover:text-astra-hover no-underline",
    href: astra_admin.customize_url,
    target: "_self",
    rel: "noreferrer"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Go to Customizer", "astra"))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_Welcome_QuickSettings__WEBPACK_IMPORTED_MODULE_2__["default"], null))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    "aria-labelledby": "section-1-title h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "sr-only",
    id: "section-1-title"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Do more with %s Modules', 'astra'), astra_admin.plugin_name)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-[2rem] rounded-md bg-white overflow-hidden shadow-sm flex flex-col justify-center h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative w-full flex flex-col sm:flex-row sm:items-center sm:justify-between"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "font-semibold text-xl leading-6 text-slate-800 mb-4 sm:mb-0"
  }, astra_admin.pro_available ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('%s Modules', 'astra'), astra_admin.plugin_name) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Do more with %s Modules', 'astra'), astra_admin.plugin_name)), astra_admin.pro_available && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_Welcome_BulkExtensionController__WEBPACK_IMPORTED_MODULE_7__["default"], null), !astra_admin.pro_available && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_10__.ProButton, {
    className: "lg:flex-shrink-0 text-sm font-medium text-astra focus:text-astra focus-visible:text-astra-hover active:text-astra-hover hover:text-astra-hover no-underline",
    isLink: true
  })), wp.hooks.applyFilters(`astra_dashboard.pro_extensions`, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_Welcome_ProModules__WEBPACK_IMPORTED_MODULE_4__["default"], null)))), astra_admin.show_plugins && astra_admin.show_self_branding && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    "aria-labelledby": "section-1-title h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "sr-only",
    id: "section-1-title"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Astra Integrations', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "p-[2rem] rounded-md bg-white overflow-hidden shadow-sm flex flex-col justify-center h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "relative w-full lg:flex lg:items-center lg:justify-between"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "font-semibold text-xl leading-6 text-slate-800"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('%s Integrations', "astra"), astra_admin.theme_name))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_Welcome_AstraIntegration__WEBPACK_IMPORTED_MODULE_6__["default"], null))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    "aria-labelledby": "section-1-title h-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "sr-only",
    id: "section-1-title"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Your License', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "ast-welcome-screen rounded-md bg-white overflow-hidden shadow-sm flex flex-col justify-center h-full"
  }, wp.hooks.applyFilters(`astra_dashboard.welcome_screen_after_integrations`, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null))))), astra_admin.show_self_branding && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "grid grid-cols-1 gap-[32px]"
  }, astra_admin.show_plugins && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    "aria-labelledby": "section-2-title"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", {
    className: "sr-only",
    id: "section-2-title"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Extend Your Website', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "box-border rounded-md shadow-sm overflow-hidden"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: ""
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "text-slate-800 text-base font-semibold leading-5 tracking-[0.0125rem] bg-white pt-6 pl-6 pb-4"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Extend Your Website', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_DashboardApp_pages_Welcome_UsefulPlugins__WEBPACK_IMPORTED_MODULE_5__["default"], null)))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_10__.PromoCard, {
    id: "vip-priority-support",
    className: "border border-sky-500",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("VIP Priority Support", "astra"),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Faster and exclusive support service designed for VIP assistance and benefits.", "astra"),
    linkHRef: astra_admin.astraWebsite?.vipPrioritySupportUrl,
    linkText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Know More →", "astra")
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_10__.PromoCard, {
    id: "join-community",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Join the Community", "astra"),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Got a question about the plugin, want to share your awesome project or just say hi? Join our wonderful community!", "astra"),
    linkHRef: "https://www.facebook.com/groups/wpastra",
    linkText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Join Now →", "astra")
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components__WEBPACK_IMPORTED_MODULE_10__.PromoCard, {
    id: "rate-us",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Rate Us", "astra"),
    linkHRef: "https://wordpress.org/support/theme/astra/reviews/?rate=5#new-post",
    linkText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Submit a Review →", "astra")
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-slate-500 text-sm pb-2.5 pr-12 flex items-center"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-xl text-slate-800 flex mr-2"
  }, [1, 2, 3, 4, 5].map(item => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_astra_components_icons__WEBPACK_IMPORTED_MODULE_11__.Star, {
    key: item,
    fill: "#334155"
  }))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "text-xs leading-4 align-text-bottom text-slate-400"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Based on 5k+ reviews", "astra"))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "text-slate-500 text-sm pb-5"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("We love to hear from you, we would appreciate every single review.", "astra")))))), displayBannerVideo && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_VideoPopup__WEBPACK_IMPORTED_MODULE_8__["default"], {
    allowAutoPlay: allowAutoPlay,
    videoPopup: videoPopup,
    toggleVideoPopup: toggleVideoPopup
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Welcome);

/***/ }),

/***/ "./assets/src/dashboard-app/pages/woocommerce/ExtensionScreen.js":
/*!***********************************************************************!*\
  !*** ./assets/src/dashboard-app/pages/woocommerce/ExtensionScreen.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Common/block-icons */ "./assets/src/common/block-icons.js");
/* harmony import */ var _Utils_extensions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Utils/extensions */ "./assets/src/utils/extensions.js");




const ExtensionScreen = () => {
  const handlePluginActionTrigger = e => (0,_Utils_extensions__WEBPACK_IMPORTED_MODULE_3__.triggerAction)(e);
  const getStatusClass = value => {
    if (value === "activated") {
      return "text-[#4AB866] pointer-events-none";
    } else {
      return "text-astra bg-white px-[0.8125rem] shadow-sm border border-solid border-[#0EA5E9] shadow-sm";
    }
  };
  const renderExtensionCards = astra_admin.woo_extensions.map((plugin, index) => {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      key: index,
      className: "rounded-md px-5 py-4 bg-white border border-solid border-[#E2E8F0]"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "grid gap-3"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex justify-between"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "w-10 h-10 block extension-logo"
    }, plugin.logoPath.internal_icon && _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"][plugin.logoPath.icon_path], !plugin.logoPath.internal_icon && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: plugin.logoPath.icon_path,
      width: "40px",
      height: "40px"
    })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "star-rating flex items-center"
    }, Array(5).fill(0).map((_, i) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      key: i
    }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]['star'])), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "text-xs text-slate-400 ml-1"
    }, plugin.ratings))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "text-base leading-[1.625rem] font-medium text-slate-800"
    }, plugin.title), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "text-sm leading-[1.375rem] text-slate-400"
    }, plugin.subtitle)), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "flex justify-between"
    }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
      "data-type": "button",
      "data-slug": plugin.slug,
      "data-redirection": plugin.redirection,
      "data-action": (0,_Utils_extensions__WEBPACK_IMPORTED_MODULE_3__.getAction)(plugin.status),
      "data-init": plugin.path,
      onClick: handlePluginActionTrigger,
      className: ` ${getStatusClass(plugin.status)} capitalize mt-3 inline-flex items-center text-sm leading-[0.875rem] font-medium rounded-md py-[0.5625rem] hover:bg-slate-50 focus:outline-none focus:ring-2 focus:ring-astra-hover focus:ring-offset-2`
    }, 'installed' == plugin.status ? astra_admin.plugin_activate_text : plugin.status), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "installation-count flex items-center mt-3"
    }, _Common_block_icons__WEBPACK_IMPORTED_MODULE_2__["default"]['chart'], (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "text-xs text-slate-400 ml-1"
    }, plugin.activations, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('active users', 'astra')))));
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "px-6 w-full"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "mx-auto lg:max-w-[80rem]"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: " mt-10 mb-2 font-semibold text-2xl"
  }, "WooCommerce ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Extensions', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-sm mb-8 text-[#475569]"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('WooCommerce extensions that will elevate your online store from good to exceptional.', 'astra')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("main", {
    className: "my-[2.43rem grid lg:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-6 "
  }, renderExtensionCards)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExtensionScreen);

/***/ }),

/***/ "./assets/src/dashboard-app/whats-new-library/useWhatsNewRSS.js":
/*!**********************************************************************!*\
  !*** ./assets/src/dashboard-app/whats-new-library/useWhatsNewRSS.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/**
 * === Whats New RSS ===
 *
 * Version: 1.0.7
 * Generated on: 8th October, 2024
 * Documentation: https://github.com/brainstormforce/whats-new-rss/blob/master/README.md
 */


var __assign = undefined && undefined.__assign || function () {
  __assign = Object.assign || function (t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
      s = arguments[i];
      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
    }
    return t;
  };
  return __assign.apply(this, arguments);
};
var __awaiter = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
var __generator = undefined && undefined.__generator || function (thisArg, body) {
  var _ = {
      label: 0,
      sent: function () {
        if (t[0] & 1) throw t[1];
        return t[1];
      },
      trys: [],
      ops: []
    },
    f,
    y,
    t,
    g;
  return g = {
    next: verb(0),
    "throw": verb(1),
    "return": verb(2)
  }, typeof Symbol === "function" && (g[Symbol.iterator] = function () {
    return this;
  }), g;
  function verb(n) {
    return function (v) {
      return step([n, v]);
    };
  }
  function step(op) {
    if (f) throw new TypeError("Generator is already executing.");
    while (g && (g = 0, op[0] && (_ = 0)), _) try {
      if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
      if (y = 0, t) op = [op[0] & 2, t.value];
      switch (op[0]) {
        case 0:
        case 1:
          t = op;
          break;
        case 4:
          _.label++;
          return {
            value: op[1],
            done: false
          };
        case 5:
          _.label++;
          y = op[1];
          op = [0];
          continue;
        case 7:
          op = _.ops.pop();
          _.trys.pop();
          continue;
        default:
          if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
            _ = 0;
            continue;
          }
          if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
            _.label = op[1];
            break;
          }
          if (op[0] === 6 && _.label < t[1]) {
            _.label = t[1];
            t = op;
            break;
          }
          if (t && _.label < t[2]) {
            _.label = t[2];
            _.ops.push(op);
            break;
          }
          if (t[2]) _.ops.pop();
          _.trys.pop();
          continue;
      }
      op = body.call(thisArg, _);
    } catch (e) {
      op = [6, e];
      y = 0;
    } finally {
      f = t = 0;
    }
    if (op[0] & 5) throw op[1];
    return {
      value: op[0] ? op[1] : void 0,
      done: true
    };
  }
};
var WhatsNewRSSDefaultArgs = {
  rssFeedURL: '',
  selector: '',
  loaderIcon: "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" viewBox=\"0 0 100 100\" preserveAspectRatio=\"xMidYMid\">\n\t<circle cx=\"50\" cy=\"50\" fill=\"none\" stroke=\"#9f9f9f\" stroke-width=\"10\" r=\"35\" stroke-dasharray=\"164.93361431346415 56.97787143782138\">\n\t\t<animateTransform attributeName=\"transform\" type=\"rotate\" repeatCount=\"indefinite\" dur=\"1s\" values=\"0 50 50;360 50 50\" keyTimes=\"0;1\"></animateTransform>\n\t</circle>\n\t</svg>",
  viewAll: {
    link: '',
    label: 'View All'
  },
  triggerButton: {
    label: '',
    icon: "<svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M8.61703 13.1998C8.04294 13.1503 7.46192 13.125 6.875 13.125H6.25C4.17893 13.125 2.5 11.4461 2.5 9.375C2.5 7.30393 4.17893 5.625 6.25 5.625H6.875C7.46192 5.625 8.04294 5.59972 8.61703 5.55018M8.61703 13.1998C8.82774 14.0012 9.1031 14.7764 9.43719 15.5195C9.64341 15.9782 9.48685 16.5273 9.05134 16.7787L8.50441 17.0945C8.04492 17.3598 7.45466 17.1921 7.23201 16.7106C6.70983 15.5811 6.30451 14.3866 6.03155 13.1425M8.61703 13.1998C8.29598 11.9787 8.125 10.6968 8.125 9.375C8.125 8.05316 8.29598 6.77125 8.61703 5.55018M8.61703 13.1998C11.25 13.427 13.737 14.1643 15.9789 15.3124M8.61703 5.55018C11.25 5.323 13.737 4.58569 15.9789 3.43757M15.9789 3.43757C15.8808 3.12162 15.7751 2.80903 15.662 2.5M15.9789 3.43757C16.4247 4.87356 16.7131 6.37885 16.8238 7.93326M15.9789 15.3124C15.8808 15.6284 15.7751 15.941 15.662 16.25M15.9789 15.3124C16.4247 13.8764 16.7131 12.3711 16.8238 10.8167M16.8238 7.93326C17.237 8.2772 17.5 8.79539 17.5 9.375C17.5 9.95461 17.237 10.4728 16.8238 10.8167M16.8238 7.93326C16.8578 8.40942 16.875 8.8902 16.875 9.375C16.875 9.8598 16.8578 10.3406 16.8238 10.8167\" stroke=\"#94A3B8\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>",
    beforeBtn: '',
    afterBtn: '',
    className: '',
    onClick: function () {}
  },
  notification: {
    setLastPostUnixTime: null,
    getLastPostUnixTime: null
  },
  flyout: {
    title: "What's New?",
    innerContent: {
      titleLink: true,
      additionalClasses: []
    },
    excerpt: {
      wordLimit: 500,
      moreSymbol: '&hellip;',
      readMore: {
        label: 'Read More',
        className: ''
      }
    },
    className: '',
    closeOnEsc: true,
    closeOnOverlayClick: true,
    closeBtnIcon: "<svg width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M6 18L18 6M6 6L18 18\" stroke=\"#94A3B8\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>",
    formatDate: null,
    onOpen: function () {},
    onClose: function () {},
    onReady: function () {}
  }
};
var WhatsNewRSS = /** @class */function () {
  /**
   * Initialize our class.
   *
   * @param {ConstructorArgs} args
   */
  function WhatsNewRSS(args) {
    this.rssFeedURLs = [];
    /**
     * UnixTime stamp of the last seen or read post.
     */
    this.lastPostUnixTime = 0;
    /**
     * UnixTime stamp of the last seen or read post for multi feeds by feed key.
     */
    this.multiLastPostUnixTime = {};
    /**
     * Total number of new notification counts.
     */
    this.notificationsCount = 0;
    /**
     * Notification counts for multi feeds by feed key.
     */
    this.multiNotificationCount = {};
    /**
     * Check if has new feeds.
     */
    this.hasNewFeeds = false;
    /**
     * Check if has new feeds in multi feeds mode.
     */
    this.multiHasNewFeeds = {};
    this.validateArgs(args);
    this.parseDefaults(args);
    this.setElement();
    if (!this.getElement()) {
      console.warn('WNR: Cannot find element with', this.getArgs().selector);
      return;
    }
    this.setID();
    this.setRSSFeedURLs();
    WhatsNewRSSCacheUtils.setInstanceID(this.getID());
    this.RSS_Fetch_Instance = new WhatsNewRSSFetch(this);
    this.RSS_View_Instance = new WhatsNewRSSView(this);
    this.setNotificationsCount();
    this.setTriggers();
  }
  ;
  /**
   * Validate the passed arguments in constructor.
   *
   * @param {ConstructorArgs} args
   */
  WhatsNewRSS.prototype.validateArgs = function (args) {
    ["rssFeedURL", "selector"].forEach(function (requiredArg) {
      if (!args[requiredArg]) {
        throw new Error("".concat(requiredArg, " is a required argument. It cannot be empty or undefined."));
      }
      switch (requiredArg) {
        case 'rssFeedURL':
          var arg = args[requiredArg];
          if (Array.isArray(arg)) {
            arg.forEach(function (rssFeedURL) {
              if (!(rssFeedURL === null || rssFeedURL === void 0 ? void 0 : rssFeedURL.key)) {
                throw new Error("The parameter \"key\" is required for \"".concat(requiredArg, "\" parameter in multi-feed mode."));
              }
              if (rssFeedURL.key.includes(' ')) {
                throw new Error("The parameter \"key\" cannot have spaces for \"".concat(requiredArg, "\" parameter in multi-feed mode. Ref Key: \"").concat(rssFeedURL.key, "\""));
              }
            });
          }
          break;
        default:
          break;
      }
    });
  };
  /**
   * Parse the arguments passed by the user with the defaults.
   *
   * @param {ConstructorArgs} args
   */
  WhatsNewRSS.prototype.parseDefaults = function (args) {
    var _a, _b;
    this.args = __assign(__assign(__assign({}, WhatsNewRSSDefaultArgs), args), {
      viewAll: __assign(__assign({}, WhatsNewRSSDefaultArgs.viewAll), args === null || args === void 0 ? void 0 : args.viewAll),
      triggerButton: __assign(__assign({}, WhatsNewRSSDefaultArgs.triggerButton), args === null || args === void 0 ? void 0 : args.triggerButton),
      flyout: __assign(__assign(__assign({}, WhatsNewRSSDefaultArgs.flyout), args === null || args === void 0 ? void 0 : args.flyout), {
        innerContent: __assign(__assign({}, WhatsNewRSSDefaultArgs.flyout.innerContent), (_a = args === null || args === void 0 ? void 0 : args.flyout) === null || _a === void 0 ? void 0 : _a.innerContent),
        excerpt: __assign(__assign({}, WhatsNewRSSDefaultArgs.flyout.excerpt), (_b = args === null || args === void 0 ? void 0 : args.flyout) === null || _b === void 0 ? void 0 : _b.excerpt)
      })
    });
  };
  /**
   * Returns parsed args.
   *
   * @returns {ConstructorArgs}
   */
  WhatsNewRSS.prototype.getArgs = function () {
    return this.args;
  };
  /**
   * Sets the HTML element queried using passed selector.
   */
  WhatsNewRSS.prototype.setElement = function () {
    this.element = document.querySelector(this.args.selector);
  };
  /**
   * Returns the html element according to the selector.
   *
   * @returns {HTMLElement}
   */
  WhatsNewRSS.prototype.getElement = function () {
    return this.element;
  };
  /**
   * Creates unique ID for current instance, that can be used by the library elements.
   */
  WhatsNewRSS.prototype.setID = function () {
    var data = [this.getArgs().selector];
    var rssFeedURL = this.getArgs().rssFeedURL;
    if (Array.isArray(rssFeedURL)) {
      rssFeedURL.forEach(function (_rssFeedURL) {
        data.push(_rssFeedURL.key);
      });
    } else {
      data.push(rssFeedURL);
    }
    this.ID = btoa(data.join('-')).slice(-12).replace(/=/g, '');
  };
  /**
   * Whether or not multiple feed urls is provided or not.
   *
   * @returns {boolean}
   */
  WhatsNewRSS.prototype.isMultiFeedRSS = function () {
    return 'string' !== typeof this.getArgs().rssFeedURL;
  };
  WhatsNewRSS.prototype.setRSSFeedURLs = function () {
    var _this = this;
    var rssFeedURL = this.getArgs().rssFeedURL;
    if (!this.isMultiFeedRSS()) {
      this.rssFeedURLs.push({
        key: null,
        label: '',
        url: rssFeedURL.toString()
      });
    } else {
      if (Array.isArray(rssFeedURL)) {
        rssFeedURL.forEach(function (_item) {
          _this.rssFeedURLs.push(_item);
        });
      }
    }
  };
  WhatsNewRSS.prototype.getRSSFeedURLs = function () {
    return this.rssFeedURLs;
  };
  /**
   * Returns the current instance unique ID.
   *
   * @returns {string}
   */
  WhatsNewRSS.prototype.getID = function () {
    return this.ID;
  };
  /**
   * Checks and counts new notification for the notification badge.
   */
  WhatsNewRSS.prototype.setNotificationsCount = function () {
    return __awaiter(this, void 0, void 0, function () {
      var _this = this;
      return __generator(this, function (_a) {
        switch (_a.label) {
          case 0:
            return [4 /*yield*/, Promise.all(this.getRSSFeedURLs().map(_a => {
              var key = _a.key;
              return __awaiter(_this, void 0, void 0, function () {
                var lastPostUnixTime;
                return __generator(this, function (_b) {
                  switch (_b.label) {
                    case 0:
                      lastPostUnixTime = 0;
                      if (!('function' === typeof this.getArgs().notification.getLastPostUnixTime)) return [3 /*break*/, 2];
                      return [4 /*yield*/, this.getArgs().notification.getLastPostUnixTime(key, this)];
                    case 1:
                      lastPostUnixTime = _b.sent();
                      return [3 /*break*/, 3];
                    case 2:
                      lastPostUnixTime = WhatsNewRSSCacheUtils.getLastPostUnixTime(key);
                      _b.label = 3;
                    case 3:
                      if (this.isMultiFeedRSS()) {
                        this.multiLastPostUnixTime[key] = +lastPostUnixTime;
                      } else {
                        this.lastPostUnixTime = +lastPostUnixTime;
                      }
                      return [2 /*return*/];
                  }
                });
              });
            }))];
          case 1:
            _a.sent();
            return [4 /*yield*/, this.RSS_Fetch_Instance.fetchData().then(function (res) {
              Object.keys(res).forEach(function (key) {
                var data = res[key];
                if (!data.length) {
                  return;
                }
                _this.multiNotificationCount[key] = 0;
                var currentPostUnixTime = +data[0].date;
                var lastPostUnixTime = _this.isMultiFeedRSS() ? _this.multiLastPostUnixTime[key] : _this.lastPostUnixTime;
                if (currentPostUnixTime > lastPostUnixTime) {
                  data.forEach(function (item) {
                    if (item.date > lastPostUnixTime) {
                      if (_this.isMultiFeedRSS()) {
                        _this.multiNotificationCount[key]++;
                        _this.multiHasNewFeeds[key] = true;
                      }
                      // Keep a record of total notifications even in multi-feed mode.
                      _this.notificationsCount++;
                      _this.hasNewFeeds = true;
                    }
                  });
                  _this.RSS_View_Instance.setNotification(_this.notificationsCount);
                }
              });
            }).catch(console.error)];
          case 2:
            _a.sent();
            return [2 /*return*/];
        }
      });
    });
  };
  /**
   * Returns total number of new notifications.
   *
   * @returns {number}
   */
  WhatsNewRSS.prototype.getNotificationsCount = function () {
    return this.notificationsCount;
  };
  /**
   * Sets the triggers for the library, eg: close, open, fetch.
   */
  WhatsNewRSS.prototype.setTriggers = function () {
    var _this = this;
    var triggerButton = document.getElementById(this.RSS_View_Instance.getTriggerButtonID());
    var flyout = document.getElementById(this.RSS_View_Instance.getFlyoutID());
    var flyoutInner = flyout.querySelector('.whats-new-rss-flyout-inner-content');
    var flyoutCloseBtn = document.getElementById(this.RSS_View_Instance.getFlyoutCloseBtnID());
    var multiFeedNav = document.getElementById(this.RSS_View_Instance.getFlyoutMultiFeedNavID());
    var injectContents = function (key) {
      /**
       * Fetch data on flyout open.
       */
      _this.RSS_Fetch_Instance.fetchData().then(function (res) {
        flyoutInner.innerHTML = '';
        var data = res[key];
        if (!data.length) {
          return;
        }
        var currentPostUnixTime = +data[0].date;
        var lastPostUnixTime = _this.isMultiFeedRSS() ? _this.multiLastPostUnixTime[key] : _this.lastPostUnixTime;
        data.forEach(function (item) {
          var isNewPost = !!lastPostUnixTime ? item.date > lastPostUnixTime : false;
          var contentTitle = _this.getArgs().flyout.innerContent.titleLink ? "<a href=\"".concat(item.postLink, "\" target=\"_blank\">\n\t\t\t\t\t\t\t\t<h2>").concat(item.title, "</h2>\n\t\t\t\t\t\t\t</a>") : "<h2>".concat(item.title, "</h2>");
          var innerContent = "\n\t\t\t\t\t\t\t\t<div class=\"rss-content-header\">\n\t\t\t\t\t\t\t\t\t<p>".concat(_this.RSS_View_Instance.formatDate(new Date(item.date)), "</p>\n\t\t\t\t\t\t\t\t\t").concat(contentTitle, "\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t").concat(_this.RSS_View_Instance.createExcerpt(item.description, item.postLink, _this.getArgs().flyout.excerpt), "\n\t\t\t\t\t\t\t\t").concat(_this.RSS_View_Instance.listChildrenPosts(item.children), "\n\t\t\t\t\t\t\t");
          var additionalClasses = _this.getArgs().flyout.innerContent.additionalClasses;
          if (!!key) {
            additionalClasses.push('`inner-content-item-feed-key-${key}`');
          }
          flyoutInner.innerHTML += _this.RSS_View_Instance.innerContentWrapper(innerContent, isNewPost, additionalClasses.join(' '));
        });
        if (_this.getArgs().viewAll.link) {
          // If we have link provided for the view all button then append a view all button at the end of the contents.
          flyoutInner.innerHTML += _this.RSS_View_Instance.innerContentWrapper("\n\t\t\t\t\t\t\t<a href=\"".concat(_this.getArgs().viewAll.link, "\" class=\"button view-all\">").concat(_this.getArgs().viewAll.label, "</a>\n\t\t\t\t\t\t\t"));
        }
        _this.RSS_View_Instance.setIsLoading(false);
        flyout.classList.add('ready');
        _this.getArgs().flyout.onReady(_this);
        /**
         * Change focus to flyout on flyout ready.
         */
        flyout.focus();
        // Set the last latest post date for notification handling.
        if (!_this.isMultiFeedRSS()) {
          _this.lastPostUnixTime = currentPostUnixTime;
          if (_this.hasNewFeeds) {
            if ('function' === typeof _this.getArgs().notification.setLastPostUnixTime) {
              _this.getArgs().notification.setLastPostUnixTime(currentPostUnixTime, key);
            } else {
              WhatsNewRSSCacheUtils.setLastPostUnixTime(currentPostUnixTime, key);
            }
          }
        }
      }).catch(console.error);
    };
    /**
     * Open flyout on trigger button click.
     * Flyout has three states: `closed | open | ready`
     */
    triggerButton.addEventListener("click", function (e) {
      e.preventDefault();
      _this.getArgs().triggerButton.onClick(_this);
      _this.RSS_View_Instance.setIsLoading(true);
      flyout.classList.remove('closed');
      flyout.classList.add('open');
      document.body.classList.add('whats-new-rss-is-active');
      _this.getArgs().flyout.onOpen(_this);
      if (!_this.isMultiFeedRSS()) {
        injectContents(null);
        return;
      }
      var navBtns = multiFeedNav.querySelectorAll('button');
      navBtns.forEach(function (navBtn) {
        _this.RSS_View_Instance.setMultiFeedTabNotificationCount(navBtn.dataset.feedKey, _this.multiNotificationCount[navBtn.dataset.feedKey]);
        navBtn.addEventListener('click', function (e) {
          e.preventDefault();
          var currentFeedKey = navBtn.dataset.feedKey;
          _this.multiNotificationCount[currentFeedKey] = 0;
          _this.RSS_Fetch_Instance.fetchData().then(function (res) {
            var currentPostUnixTime = res[currentFeedKey][0].date;
            _this.multiLastPostUnixTime[currentFeedKey] = currentPostUnixTime;
            if (true === _this.multiHasNewFeeds[currentFeedKey]) {
              if ('function' === typeof _this.getArgs().notification.setLastPostUnixTime) {
                _this.getArgs().notification.setLastPostUnixTime(currentPostUnixTime, currentFeedKey);
              } else {
                WhatsNewRSSCacheUtils.setLastPostUnixTime(currentPostUnixTime, currentFeedKey);
              }
            }
            _this.multiHasNewFeeds[currentFeedKey] = false;
          }).catch(console.error);
          navBtns.forEach(function (navBtn) {
            navBtn.classList.remove('selected');
            var feedKey = navBtn.dataset.feedKey;
            var innerContentClassName = ".inner-content-item-feed-key-".concat(feedKey);
            document.querySelectorAll(innerContentClassName).forEach(function (item) {
              if (currentFeedKey !== feedKey) {
                item.classList.add('hidden');
              } else {
                item.classList.remove('hidden');
              }
            });
          });
          navBtn.classList.add('selected');
          injectContents(currentFeedKey);
        });
      });
      navBtns[0].click();
    });
    /**
     * Handle events for the closing of the flyout.
     */
    var handleFlyoutClose = function () {
      flyout.classList.add('closed');
      flyout.classList.remove('open');
      flyout.classList.remove('ready');
      document.body.classList.remove('whats-new-rss-is-active');
      if (_this.isMultiFeedRSS()) {
        _this.RSS_View_Instance.setNotification(Object.values(_this.multiNotificationCount).filter(Boolean).length);
      } else {
        _this.hasNewFeeds = false;
        _this.RSS_View_Instance.setNotification(false);
      }
      flyoutInner.innerHTML = '';
      _this.getArgs().flyout.onClose(_this);
      /**
       * Change focus back to trigger button after flyout close.
       */
      triggerButton.focus();
    };
    if (this.getArgs().flyout.closeOnEsc) {
      document.addEventListener('keydown', function (e) {
        if ('Escape' !== e.key) return;
        if (!flyout.classList.contains('open')) return;
        handleFlyoutClose();
      });
    }
    if (this.getArgs().flyout.closeOnOverlayClick) {
      flyout.querySelector('.whats-new-rss-flyout-overlay').addEventListener('click', handleFlyoutClose);
    }
    flyoutCloseBtn.addEventListener('click', handleFlyoutClose);
  };
  return WhatsNewRSS;
}();
var WhatsNewRSSCacheUtils = /** @class */function () {
  function WhatsNewRSSCacheUtils() {}
  WhatsNewRSSCacheUtils.setInstanceID = function (instanceID) {
    if (!this.instanceID) {
      this.instanceID = instanceID;
    }
  };
  WhatsNewRSSCacheUtils.prefixer = function (key, prefixKey) {
    if (prefixKey === void 0) {
      prefixKey = '';
    }
    if (!this.instanceID) {
      throw new Error('Instance ID not set.');
    }
    return !!prefixKey ? "".concat(this.keys[key], "-").concat(this.instanceID, "-").concat(prefixKey) : "".concat(this.keys[key], "-").concat(this.instanceID);
  };
  WhatsNewRSSCacheUtils._setDataExpiry = function (prefixKey) {
    if (prefixKey === void 0) {
      prefixKey = '';
    }
    var expiryInSeconds = 86400; // Defaults to 24 hours.
    var now = new Date();
    var expiry = now.getTime() + expiryInSeconds * 1000;
    sessionStorage.setItem(this.prefixer('SESSION_DATA_EXPIRY', prefixKey), JSON.stringify(expiry));
  };
  WhatsNewRSSCacheUtils._isDataExpired = function (prefixKey) {
    if (prefixKey === void 0) {
      prefixKey = '';
    }
    var key = this.prefixer('SESSION_DATA_EXPIRY', prefixKey);
    var value = window.sessionStorage.getItem(key);
    if (!value) {
      return true;
    }
    var expiry = JSON.parse(value);
    var now = new Date();
    if (now.getTime() > expiry) {
      window.sessionStorage.removeItem(key);
      return true;
    }
    return false;
  };
  WhatsNewRSSCacheUtils.setSessionData = function (data, prefixKey) {
    if (prefixKey === void 0) {
      prefixKey = '';
    }
    this._setDataExpiry(prefixKey);
    return window.sessionStorage.setItem(this.prefixer('SESSION', prefixKey), data);
  };
  WhatsNewRSSCacheUtils.getSessionData = function (prefixKey) {
    if (prefixKey === void 0) {
      prefixKey = '';
    }
    if (!this._isDataExpired(prefixKey)) {
      return window.sessionStorage.getItem(this.prefixer('SESSION', prefixKey));
    }
    return '{}';
  };
  WhatsNewRSSCacheUtils.setLastPostUnixTime = function (unixTime, prefixKey) {
    if (prefixKey === void 0) {
      prefixKey = '';
    }
    return window.localStorage.setItem(this.prefixer('LAST_LATEST_POST', prefixKey), unixTime.toString());
  };
  WhatsNewRSSCacheUtils.getLastPostUnixTime = function (prefixKey) {
    if (prefixKey === void 0) {
      prefixKey = '';
    }
    return +window.localStorage.getItem(this.prefixer('LAST_LATEST_POST', prefixKey));
  };
  WhatsNewRSSCacheUtils.keys = {
    SESSION_DATA_EXPIRY: "whats-new-cache-expiry",
    LAST_LATEST_POST: "whats-new-last-unixtime",
    SESSION: "whats-new-cache"
  };
  return WhatsNewRSSCacheUtils;
}();
/**
 * Class for handling the data fetching.
 * It also handles the session caching of the fetched data internally.
 */
var WhatsNewRSSFetch = /** @class */function () {
  function WhatsNewRSSFetch(RSS) {
    var _this = this;
    this.data = {};
    this.RSS = RSS;
    this.RSS.getRSSFeedURLs().forEach(function (feed) {
      var sessionCache = JSON.parse(WhatsNewRSSCacheUtils.getSessionData(feed.key));
      if (sessionCache && sessionCache.length) {
        _this.data[feed.key] = sessionCache;
      }
    });
  }
  WhatsNewRSSFetch.prototype.fetchData = function () {
    return __awaiter(this, void 0, void 0, function () {
      var fetchPromises;
      var _this = this;
      return __generator(this, function (_a) {
        switch (_a.label) {
          case 0:
            if (Object.keys(this.data).length) {
              return [2 /*return*/, this.data];
            }
            fetchPromises = this.RSS.getRSSFeedURLs().map(feed => {
              return __awaiter(_this, void 0, void 0, function () {
                var res, data, parser, xmlDoc, items;
                var _this = this;
                return __generator(this, function (_a) {
                  switch (_a.label) {
                    case 0:
                      this.data[feed.key] = [];
                      return [4 /*yield*/, fetch(feed.url)];
                    case 1:
                      res = _a.sent();
                      return [4 /*yield*/, res.text()];
                    case 2:
                      data = _a.sent();
                      /**
                       * There was an issue with the xml content parse
                       * And during parse we were getting "<parsererror>" because of the ‘raquo’ entity.
                       */
                      data = data.replace(/&raquo;/g, '&amp;raquo;');
                      parser = new DOMParser();
                      xmlDoc = parser.parseFromString(data, 'text/xml');
                      items = xmlDoc.querySelectorAll('item');
                      items.forEach(function (item) {
                        var _a;
                        var title = item.querySelector('title').textContent;
                        var link = item.querySelector('link').textContent;
                        var contentEncoded = item.querySelector('content\\:encoded, encoded');
                        var content = contentEncoded ? contentEncoded.textContent : '';
                        var rssDate = item.querySelector('pubDate').innerHTML;
                        _this.data[feed.key].push({
                          title: title,
                          date: !!rssDate ? +new Date(rssDate) : null,
                          postLink: link,
                          description: content.replace(/<a\b((?:(?!target=)[^>])*)>/g, '<a$1 target="_blank">').replace(/<p>\s*<\/p>/g, ''),
                          children: JSON.parse(((_a = item.querySelector('children')) === null || _a === void 0 ? void 0 : _a.innerHTML) || '{}')
                        });
                      });
                      WhatsNewRSSCacheUtils.setSessionData(JSON.stringify(this.data[feed.key]), feed.key);
                      return [2 /*return*/];
                  }
                });
              });
            });
            return [4 /*yield*/, Promise.all(fetchPromises)];
          case 1:
            _a.sent();
            return [2 /*return*/, this.data];
        }
      });
    });
  };
  return WhatsNewRSSFetch;
}();
/**
 * The class for handling library trigger button and flyout elements.
 * It also provides some necessary methods that can be used during development.
 */
var WhatsNewRSSView = /** @class */function () {
  function WhatsNewRSSView(RSS) {
    this.RSS = RSS;
    this.createTriggerButton();
    this.createFlyOut();
  }
  WhatsNewRSSView.prototype.getTriggerButtonID = function () {
    return "whats-new-rss-btn-".concat(this.RSS.getID());
  };
  WhatsNewRSSView.prototype.getFlyoutID = function () {
    return "whats-new-rss-flyout-".concat(this.RSS.getID());
  };
  WhatsNewRSSView.prototype.getFlyoutCloseBtnID = function () {
    return "whats-new-rss-flyout-close-".concat(this.RSS.getID());
  };
  WhatsNewRSSView.prototype.getFlyoutMultiFeedNavID = function () {
    return "whats-new-rss-flyout-multi-feed-nav-".concat(this.RSS.getID());
  };
  WhatsNewRSSView.prototype.setIsLoading = function (isLoading) {
    if (isLoading === void 0) {
      isLoading = false;
    }
    var flyoutWrapper = document.getElementById(this.getFlyoutID());
    if (isLoading) {
      flyoutWrapper.classList.add('is-loading');
    } else {
      flyoutWrapper.classList.remove('is-loading');
    }
  };
  WhatsNewRSSView.prototype.setNotification = function (notificationsCount) {
    var notificationBadge = document.querySelector("#".concat(this.getTriggerButtonID(), " .whats-new-rss-notification-badge"));
    if (!!notificationsCount) {
      if (this.RSS.isMultiFeedRSS()) {
        notificationBadge.innerHTML = '';
        notificationBadge.classList.add('is-multi-feed');
      } else {
        notificationBadge.innerHTML = notificationsCount > 9 ? "9+" : notificationsCount.toString();
      }
      notificationBadge.classList.remove('hide');
    } else {
      notificationBadge.classList.add('hide');
    }
  };
  WhatsNewRSSView.prototype.createTriggerButton = function () {
    var button = '';
    var label = this.RSS.getArgs().triggerButton.label;
    if (!!label) {
      button = "\n\t\t\t".concat(this.RSS.getArgs().triggerButton.beforeBtn, "\n\t\t\t<a class=\"whats-new-rss-trigger-button has-label\" id=\"").concat(this.getTriggerButtonID(), "\">\n\t\t\t\t<div class=\"icon-badge\">\n\t\t\t\t\t").concat(this.RSS.getArgs().triggerButton.icon, "\n\t\t\t\t\t<div class=\"whats-new-rss-notification-badge hide\">0</div>\n\t\t\t\t</div>\n\t\t\t\t").concat(label, "\n\t\t\t</a>\n\t\t\t").concat(this.RSS.getArgs().triggerButton.afterBtn, "\n\t\t\t");
    } else {
      button = "\n\t\t\t".concat(this.RSS.getArgs().triggerButton.beforeBtn, "\n\t\t\t<a class=\"whats-new-rss-trigger-button\" id=\"").concat(this.getTriggerButtonID(), "\">\n\t\t\t\t").concat(this.RSS.getArgs().triggerButton.icon, "\n\t\t\t\t<div class=\"whats-new-rss-notification-badge hide\">0</div>\n\t\t\t</a>\n\t\t\t").concat(this.RSS.getArgs().triggerButton.afterBtn, "\n\t\t\t");
    }
    this.RSS.getElement().innerHTML += button;
  };
  WhatsNewRSSView.prototype.createFlyOut = function () {
    var wrapperClasses = ['whats-new-rss-flyout', 'closed'];
    if (this.RSS.getArgs().flyout.className) {
      wrapperClasses.push(this.RSS.getArgs().flyout.className);
    }
    var multiFeedNav = [];
    if (this.RSS.isMultiFeedRSS()) {
      multiFeedNav.push("<nav id=\"".concat(this.getFlyoutMultiFeedNavID(), "\" class=\"whats-new-rss-multi-feed-nav\">"));
      this.RSS.getRSSFeedURLs().forEach(function (feed) {
        multiFeedNav.push("<button type=\"button\" data-feed-key=\"".concat(feed.key, "\">\n\t\t\t\t\t\t").concat(feed.label, "\n\t\t\t\t\t\t<div class=\"new-notification-count\"></div>\n\t\t\t\t\t</button>\n\t\t\t\t\t"));
      });
      multiFeedNav.push('</nav>');
    }
    var flyoutWrapper = document.createElement('div');
    flyoutWrapper.setAttribute('id', this.getFlyoutID());
    flyoutWrapper.setAttribute('class', wrapperClasses.join(' '));
    flyoutWrapper.setAttribute('role', 'dialog');
    flyoutWrapper.innerHTML = "\n\t\t<div class=\"whats-new-rss-flyout-contents\">\n\n\t\t\t<div class=\"whats-new-rss-flyout-inner-header\">\n\n\t\t\t\t<div class=\"whats-new-rss-flyout-inner-header__title-icon-wrapper\">\n\t\t\t\t\t<h3>".concat(this.RSS.getArgs().flyout.title, "</h3>\n\n\t\t\t\t\t<span class=\"whats-new-rss-flyout-inner-header__loading-icon\">\n\t\t\t\t\t").concat(this.RSS.getArgs().loaderIcon, "\n\t\t\t\t\t</span>\n\t\t\t\t</div>\n\n\t\t\t\t<button type=\"button\" id=\"").concat(this.getFlyoutCloseBtnID(), "\">").concat(this.RSS.getArgs().flyout.closeBtnIcon, "</button>\n\t\t\t</div>\n\n\t\t\t").concat(multiFeedNav.join(''), "\n\n\t\t\t<div class=\"whats-new-rss-flyout-inner-content\">\n\t\t\t\t<div class=\"skeleton-container\">\n\t\t\t\t\t<div class=\"skeleton-row whats-new-rss-flyout-inner-content-item\"></div>\n\t\t\t\t\t<div class=\"skeleton-row whats-new-rss-flyout-inner-content-item\"></div>\n\t\t\t\t\t<div class=\"skeleton-row whats-new-rss-flyout-inner-content-item\"></div>\n\t\t\t\t</div>\n\t\t\t</div>\n\n\t\t</div>\n\n\t\t<div class=\"whats-new-rss-flyout-overlay\"></div>\n\t\t");
    document.body.appendChild(flyoutWrapper);
  };
  WhatsNewRSSView.prototype.setMultiFeedTabNotificationCount = function (key, notificationCount) {
    if (notificationCount === void 0) {
      notificationCount = 0;
    }
    var tabBtn = document.querySelector("#".concat(this.getFlyoutMultiFeedNavID(), " button[data-feed-key=\"").concat(key, "\"]"));
    if (!tabBtn) {
      return;
    }
    var el = tabBtn.querySelector('.new-notification-count');
    if (notificationCount) {
      var _count = notificationCount > 9 ? '9+' : notificationCount;
      el.innerHTML = _count.toString();
    } else {
      el.innerHTML = '';
    }
  };
  WhatsNewRSSView.prototype.innerContentWrapper = function (content, isNewPost, additionalClasses) {
    if (isNewPost === void 0) {
      isNewPost = false;
    }
    if (additionalClasses === void 0) {
      additionalClasses = '';
    }
    var classes = ['whats-new-rss-flyout-inner-content-item'];
    if (isNewPost) {
      classes.push('rss-new-post');
    }
    if (!!additionalClasses) {
      classes.push(additionalClasses);
    }
    return "\n\t\t<div class=\"".concat(classes.join(' '), "\">\n\t\t\t").concat(isNewPost ? '<small class="new-post-badge">New ✨</small>' : '', "\n\t\t\t").concat(content, "\n\t\t</div>\n\t\t");
  };
  WhatsNewRSSView.prototype.createExcerpt = function (content, readMoreLink, options) {
    var wordLimit = options.wordLimit,
      moreSymbol = options.moreSymbol,
      readMore = options.readMore;
    if (!wordLimit) {
      return content;
    }
    var plainText = content.replace(/<[^>]*>/g, '');
    var words = plainText.split(/\s+/);
    var rawExcerpt = words.slice(0, wordLimit).join(' ');
    if (moreSymbol) {
      rawExcerpt += moreSymbol;
    }
    if (wordLimit > words.length) {
      return content;
    }
    if (!!readMoreLink && !!(readMore === null || readMore === void 0 ? void 0 : readMore.label)) {
      return "<p>".concat(rawExcerpt, " <a href=\"").concat(readMoreLink, "\" target=\"_blank\" class=\"").concat(readMore.className, "\">").concat(readMore.label, "</a></p>");
    }
    return "<p>".concat(rawExcerpt, "</p>");
  };
  WhatsNewRSSView.prototype.listChildrenPosts = function (children) {
    var _this = this;
    var _children = Object.values(children);
    if (!_children.length) return '';
    var details = document.createElement('details');
    var summary = document.createElement('summary');
    var itemsWrapper = document.createElement('div');
    _children.forEach(function (child) {
      var postContentDoc = new DOMParser().parseFromString(child.post_content, 'text/html');
      var itemDiv = document.createElement('div');
      itemDiv.classList.add('sub-version-item');
      itemDiv.innerHTML = "\n\t\t\t\t<div class=\"sub-version-header\">\n\t\t\t\t\t<h4 class=\"sub-version-title\">".concat(child.post_title, "</h4>\n\t\t\t\t\t<span class=\"sub-version-date\">").concat(_this.formatDate(new Date(child.post_date)), "</span>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"sub-version-content\">").concat(postContentDoc.documentElement.textContent, "</div>\n\t\t\t");
      itemsWrapper.appendChild(itemDiv);
    });
    summary.innerHTML = '<p class="text-see-more">See More</p><p class="text-see-less">See Less</p>';
    details.appendChild(summary);
    details.appendChild(itemsWrapper);
    itemsWrapper.classList.add('sub-version-items-wrapper');
    details.classList.add('whats-new-rss-sub-version-details');
    return details.outerHTML;
  };
  WhatsNewRSSView.prototype.formatDate = function (date) {
    if ('function' === typeof this.RSS.getArgs().flyout.formatDate) {
      return this.RSS.getArgs().flyout.formatDate(date);
    }
    var currentDate = new Date();
    var timestamp = date.getTime();
    var currentTimestamp = currentDate.getTime();
    var difference = currentTimestamp - timestamp;
    // Define time intervals in milliseconds
    var minute = 60 * 1000;
    var hour = minute * 60;
    var day = hour * 24;
    var week = day * 7;
    var month = day * 30; // Rough estimate, assuming 30 days in a month
    if (difference < minute) {
      return 'Just now';
    } else if (difference < hour) {
      var minutes = Math.floor(difference / minute);
      return "".concat(minutes, " minute").concat(minutes > 1 ? 's' : '', " ago");
    } else if (difference < day) {
      var hours = Math.floor(difference / hour);
      return "".concat(hours, " hour").concat(hours > 1 ? 's' : '', " ago");
    } else if (difference < week) {
      var days = Math.floor(difference / day);
      return "".concat(days, " day").concat(days > 1 ? 's' : '', " ago");
    } else if (difference < month) {
      var weeks = Math.floor(difference / week);
      return "".concat(weeks, " week").concat(weeks > 1 ? 's' : '', " ago");
    } else {
      // Handle months and years accordingly
      // This is a rough estimate and may not be accurate in all cases
      var months = Math.floor(difference / month);
      return "".concat(months, " month").concat(months > 1 ? 's' : '', " ago");
    }
  };
  return WhatsNewRSSView;
}();
async function getCSS() {
  return `.whats-new-rss-is-active{overflow:hidden}.whats-new-rss-trigger-button{display:flex;align-items:center;position:relative;width:auto;padding:5px;cursor:pointer}.whats-new-rss-trigger-button.has-label{align-items:end;gap:10px}.whats-new-rss-trigger-button.has-label .icon-badge{position:relative;line-height:1}.whats-new-rss-trigger-button.has-label .icon-badge .whats-new-rss-notification-badge{top:-12px;right:-10px}.whats-new-rss-trigger-button .whats-new-rss-notification-badge{position:absolute;top:-8px;right:-5px;width:20px;font-size:10px;line-height:20px;text-align:center;border-radius:10px;color:#fff;background:red;transition:transform .2s ease-in-out}.whats-new-rss-trigger-button .whats-new-rss-notification-badge.is-multi-feed{top:-2px;right:-2px;font-size:0;width:10px;height:10px}.whats-new-rss-trigger-button .whats-new-rss-notification-badge.hide{display:none}.whats-new-rss-trigger-button:hover .whats-new-rss-notification-badge{transform:scale(1.2)}.whats-new-rss-flyout{position:fixed;top:0;right:0;bottom:0;width:100%;z-index:99999;transition:visibility .3s ease-in-out;font-family:Arial,Helvetica,sans-serif}.whats-new-rss-flyout .lightbox-trigger,.whats-new-rss-flyout.hidden{display:none}.whats-new-rss-flyout.is-loading .whats-new-rss-flyout-inner-header__loading-icon{display:block;margin:auto}.whats-new-rss-flyout.is-loading .whats-new-rss-flyout-inner-header__loading-icon svg{display:block;background:0 0;width:25px;height:25px}.whats-new-rss-flyout .whats-new-rss-flyout-contents{position:fixed;display:flex;right:0;width:30%;height:100%;flex-direction:column;background-color:#fff;transition:transform .3s ease-in-out;z-index:9999}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-header{display:flex;justify-content:space-between;align-items:center;padding:16px 20px 16px 24px;border-bottom:1px solid #ccc}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-header button{border:none;background:0 0;font-size:30px;cursor:pointer;color:#94a3b8;padding:0;margin:0;box-shadow:none}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-header .whats-new-rss-flyout-inner-header__title-icon-wrapper{display:flex;gap:10px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-header .whats-new-rss-flyout-inner-header__title-icon-wrapper h3{margin:0;padding:0;color:#0f172a;font-weight:600;font-size:16px;line-height:24px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-multi-feed-nav{display:flex;padding:0 30px;border-bottom:1px solid #ccc;gap:2em;overflow:auto;white-space:nowrap}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-multi-feed-nav button{position:relative;background:0 0;color:inherit;padding:15px 0;border-bottom:2px solid transparent}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-multi-feed-nav button:focus,.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-multi-feed-nav button:hover{border-color:inherit}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-multi-feed-nav button.selected{border-color:#5d5d5d}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-multi-feed-nav button .new-notification-count{position:absolute;top:0;right:-10px;width:20px;font-size:10px;line-height:20px;text-align:center;border-radius:10px;color:#fff;background:red}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content{flex:1;overflow-y:auto}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .skeleton-container{margin:30px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item{border-bottom:1px solid #d8dfe9;padding:30px 24px;color:#475569;font-weight:400;font-size:14px;line-height:20px;display:flex;flex-direction:column;gap:13px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item>*{margin:0}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item.skeleton-row{height:25vh;margin:40px 0;background:linear-gradient(90deg,#eee 25%,#ddd 50%,#eee 75%);background-size:200% 100%;animation:shimmer 1.5s infinite}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item.rss-new-post{position:relative}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item.rss-new-post .new-post-badge{background:#ff3d3d;border-radius:5px;position:absolute;right:45px;padding:0 5px;color:#fff}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item .rss-content-header{display:flex;flex-direction:column;gap:15px;padding:0 0 8px 0}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item .rss-content-header p{color:#94a3b8;margin:0;padding:0;font-weight:600;font-size:14px;line-height:16px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item .rss-content-header h2{margin:0;color:#0f172a;font-weight:700;line-height:28px;font-size:20px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item h2{font-weight:700;font-size:18px;line-height:24px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item h3{font-weight:700;font-size:16px;line-height:22px;margin-top:12px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item h4{font-weight:700;font-size:15px;line-height:20px;margin-top:12px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item h5{font-weight:700;font-size:14px;line-height:18px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item h6{font-weight:700;font-size:13px;line-height:16px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item p{padding:0;font-size:14px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item p:last-child{margin-bottom:0;padding-bottom:0}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item a{color:#1170ff;text-decoration:none}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item figure{margin:10px 0}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item figure.wp-block-embed.is-type-video{position:relative;width:100%;height:0;padding-bottom:56.25%}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item figure iframe{position:absolute;top:0;left:0;width:100%;height:100%;border:0}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item img{box-sizing:border-box;height:auto;max-width:100%;vertical-align:bottom}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item video{vertical-align:middle;width:100%}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item strong{font-weight:600}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item ol,.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item ul{padding-inline-start:20px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item ol li,.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item ul li{margin-bottom:5px}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item ul{list-style-type:disc}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-flyout-inner-content .whats-new-rss-flyout-inner-content-item ol{list-style-type:decimal}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details{line-height:20px;font-size:.9em;margin:10px 0;background:#f9fafb}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details summary{display:flex;justify-content:space-between;cursor:pointer;padding:20px 15px;height:1em;line-height:20px;font-weight:800}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details summary::after{content:'⌃';font-size:20px;transform:rotateX(180deg);font-weight:800}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details summary .text-see-more{display:block}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details summary .text-see-less{display:none}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details[open] summary{border-bottom:1px solid #e2e8f0}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details[open] summary::after{transform:rotateX(45deg)}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details[open] summary .text-see-more{display:none}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details[open] summary .text-see-less{display:block}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details .sub-version-item{position:relative;padding:1em;border-bottom:1px solid #e2e8f0}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details .sub-version-item .sub-version-header{display:flex;justify-content:space-between}.whats-new-rss-flyout .whats-new-rss-flyout-contents .whats-new-rss-sub-version-details .sub-version-item .sub-version-content{margin-top:1em}.whats-new-rss-flyout .whats-new-rss-flyout-overlay{position:fixed;top:0;right:0;bottom:0;left:0;background:rgba(0,0,0,.5);transition:all .3s ease-in-out}.whats-new-rss-flyout.closed{visibility:hidden}.whats-new-rss-flyout.closed .whats-new-rss-flyout-overlay{opacity:0;visibility:hidden}.whats-new-rss-flyout.closed .whats-new-rss-flyout-contents{transform:translateX(100%)}.whats-new-rss-flyout .whats-new-rss-flyout-inner-header__loading-icon{display:none}@keyframes shimmer{0%{background-position:-200% 0}100%{background-position:200% 0}}@media screen and (max-width:1024px){.whats-new-rss-flyout .whats-new-rss-flyout-contents{width:40%}}@media screen and (max-width:768px){.whats-new-rss-flyout .whats-new-rss-flyout-contents{width:85%}}`;
}
async function addStyleIfNotExists() {
  const styleId = 'whats-new-rss-styles';
  if (!document.getElementById(styleId)) {
    const style = document.createElement('style');
    style.id = styleId;
    style.innerHTML = await getCSS();
    document.head.appendChild(style);
  }
}
function createWhatsNewRSSInstance(args) {
  return new WhatsNewRSS(args);
}
function useWhatsNewRSS({
  selector,
  ...rest
}) {
  const instanceRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    addStyleIfNotExists();
    if (!instanceRef.current) {
      instanceRef.current = createWhatsNewRSSInstance({
        selector,
        ...rest
      });
    }

    // Cleanup function
    return () => {
      if (instanceRef.current && typeof instanceRef.current.destroy === 'function') {
        instanceRef.current.destroy();
      }
    };
  }, [selector, ...Object.values(rest)]); // Adjust dependencies as needed

  return instanceRef.current;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useWhatsNewRSS);

/***/ }),

/***/ "./assets/src/store/globalDataReducer.js":
/*!***********************************************!*\
  !*** ./assets/src/store/globalDataReducer.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony 