<?php
/**
*	@package	WPDigiPro License
*	@author 	WPDigiPro Team
*	@version 	2.0.2
*/

// This is the URL WPDIGIPRO API query request will be sent to. This should be the URL of the site where you have installed the main license manager plugin. Get this value from the integration help page.
if(!defined( 'WPDIGIPRO_REMOTE_URL' )) : define('WPDIGIPRO_REMOTE_URL', 'https://fasterthemes.com'); endif;
// This is a value that will be recorded in the WPDIGIPRO License manager data so you can identify licenses for this item/product (textdomain).
if(!defined( 'WPDIGIPROTHEME_DIRECTORY_NAME' )):define('WPDIGIPROTHEME_DIRECTORY_NAME', 'bizzbeepro');endif; // (Folder/directory) name of the product here.
// Prodcut Reference 
if(!defined( 'WPDIGIPROTHEME_REFERENCE' )):define('WPDIGIPROTHEME_REFERENCE', 723);endif; // product id here.

class WPDigiPro_Theme_Adapter {
	/** License call remove action
	*	@access for relative the family
	*	@no arguments - ajax action
	*	@return json result
	*	call for the License Active action call remote server.
	**/
	public function WPDigiPro_Theme_API_Action($licenseDatas) {
		if(is_array($licenseDatas)) :
			// API query parameters
			$licenseParams = array(
				'wpdigipro-action' 	=>	$licenseDatas['action'],
				'license-key' 		=>	base64_encode($licenseDatas['key']),
				'registered-site'	=>	base64_encode(home_url()),
				'reference'			=>	WPDIGIPROTHEME_REFERENCE,
			);
			$remoteQuery=esc_url_raw(add_query_arg($licenseParams, WPDIGIPRO_REMOTE_URL));
			// Send query to the license remove server.
			$response=wp_remote_get($remoteQuery, array('timeout'=>20,'sslverify'=>false));
			if(!is_wp_error($response)){if((isset($response['body']))&&($response['body']!='')):$responseDatas=json_decode($response['body']);return $responseDatas;endif;}
		endif; return false;
	}

	/** License material settings for check license user scheme
	*	@access for relative the family
	*	@no-argument
	*	@return License Datas from the database.
	*	call for the License data geting.
	**/
	public function WPDigiPro_Theme_Schedule() {
		$datas=$this->WPDigiPro_Theme_Get_Code(); if(isset($datas->scheme)) :
		$nextDay=strtotime('+1 day', $datas->scheme);$today=current_time('timestamp');
		if($today>=$nextDay) {return true;} else {return false;} endif; return false;
	}

	/** License material settings get datas
	*	@access for relative the family
	*	@no-argument
	*	@return License Datas from the database.
	*	call for the License data geting.
	**/
	public function WPDigiPro_Theme_Get_Code() {$optionName='wpdigipro-'.WPDIGIPROTHEME_DIRECTORY_NAME.'-theme-secure-license-material';return $this->WPDigiPro_Theme_License_Material_Open(get_option($optionName));}

	/** License material settings datas
	*	@access for relative the family
	*	@one argument datas is array formate $originalDatas
	*	@return Encryption data string result.
	*	call for the License any datas encryption formate using serialize & base64_encode
	*	first of array data convert to serialize string after then this string encryption using base64_encode
	**/
	public function WPDigiPro_Theme_License_Material_Close($originalDatas) {return base64_encode(serialize($originalDatas));}

	/** License material settings datas
	*	@access for relative the family
	*	@one argument datas is encrypted formate string $encryptionDatas
	*	@return Decryption data array result.
	*	call for the License any original datas encryption formate using base64_decode & unserialize
	*	first of encrypted string data convert to decoding using base64_decode string after then this string encryption using base64_decode
	**/
	public function WPDigiPro_Theme_License_Material_Open($encryptionDatas) {return (object)unserialize(base64_decode($encryptionDatas));}
}
?>