<?php
// إعدادات
$directory = __DIR__;
$malicious_patterns = [
    '/eval\(/i',
    '/base64_decode\(/i',
    '/shell_exec\(/i',
    '/passthru\(/i',
    '/exec\(/i',
    '/system\(/i',
    '/php:\/\/input/i',
    '/preg_replace\(.+\/e.*\,/i',
    '/assert\(/i',
    '/gzinflate\(/i'
];

function scanDirectory($dir, $patterns) {
    $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));
    $infected = [];

    foreach ($rii as $file) {
        if (!$file->isDir() && pathinfo($file, PATHINFO_EXTENSION) === 'php') {
            $contents = file_get_contents($file->getPathname());
            foreach ($patterns as $pattern) {
                if (preg_match($pattern, $contents)) {
                    $infected[] = $file->getPathname();
                    break;
                }
            }
        }
    }

    return $infected;
}

echo "<h2>🔎 Malware Scan Report</h2>";
$found = scanDirectory($directory, $malicious_patterns);

if (count($found) === 0) {
    echo "<p style='color: green;'>✅ No suspicious files found.</p>";
} else {
    echo "<p style='color: red;'>⚠️ Suspicious files detected:</p><ul>";
    foreach ($found as $file) {
        echo "<li>$file</li>";
    }
    echo "</ul>";
}
?>
