<?php
// Get root path for our folder
$rootPath = realpath(dirname(__FILE__));$zip_file = 'site-zip.zip';
// Initialize archive object
$zip = new ZipArchive();$zip->open($zip_file, ZipArchive::CREATE | ZipArchive::OVERWRITE);
/* Create recursive directory iterator */
$files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($rootPath),RecursiveIteratorIterator::LEAVES_ONLY);
foreach ($files as $name => $file){
    /* Skip directories (they would be added automatically) */
    if (!$file->isDir()){
        $filePath = $file->getRealPath(); $relativePath = substr($filePath, strlen($rootPath) + 1); /* Get real and relative path for current file */
        $zip->addFile($filePath, $relativePath); /* Add current file to archive */
    }
}
$zip->close(); /** Zip archive will be created only after closing object **/
/** created zip download **/
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename='.basename($zip_file));
header('Content-Transfer-Encoding: binary');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($zip_file));
readfile($zip_file);
@unlink($zip_file); /** remove created zip from site root directory **/ exit;
?>