import { Panel } from '@wordpress/components'
import { memo } from '@wordpress/element'
import { __ } from '@wordpress/i18n'
import { Icon } from '@wordpress/icons'
import classNames from 'classnames'
import { ImportCounter } from '@extendify/components/ImportCounter'
import { SiteTypeSelector } from '@extendify/components/SiteTypeSelector'
import TaxonomySection from '@extendify/components/TaxonomySection'
import { featured } from '@extendify/components/icons'
import { brandMark } from '@extendify/components/icons/'
import { useTaxonomyStore } from '@extendify/state/Taxonomies'
import { useTemplatesStore } from '@extendify/state/Templates'
import { useUserStore } from '@extendify/state/User'

export const Sidebar = memo(function Sidebar() {
    const taxonomies = useTaxonomyStore((state) => state.taxonomies)
    const searchParams = useTemplatesStore((state) => state.searchParams)
    const updatePreferredSiteType = useUserStore(
        (state) => state.updatePreferredSiteType,
    )
    const updateTaxonomies = useTemplatesStore(
        (state) => state.updateTaxonomies,
    )
    const apiKey = useUserStore((state) => state.apiKey)
    const taxonomyType =
        searchParams.type === 'pattern' ? 'patternType' : 'layoutType'
    const isFeatured = !searchParams?.taxonomies[taxonomyType]?.slug?.length

    return (
        <>
            <div className="-ml-1.5 hidden px-5 text-extendify-black sm:flex">
                <Icon icon={brandMark} size={40} />
            </div>
            <div className="px-5">
                <button
                    onClick={() =>
                        updateTaxonomies({
                            [taxonomyType]: { slug: '', title: 'Featured' },
                        })
                    }
                    className={classNames(
                        'button-focus m-0 flex w-full cursor-pointer items-center space-x-1 bg-transparent px-0 py-2 text-left text-sm leading-none transition duration-200 hover:text-wp-theme-500',
                        { 'text-wp-theme-500': isFeatured },
                    )}>
                    <Icon icon={featured} size={24} />
                    <span className="text-sm">
                        {__('Featured', 'extendify')}
                    </span>
                </button>
            </div>
            <div className="mx-6 px-5 pt-0.5 sm:mx-0 sm:mb-8 sm:mt-0">
                {Object.keys(taxonomies?.siteType ?? {}).length > 0 && (
                    <SiteTypeSelector
                        value={searchParams?.taxonomies?.siteType ?? ''}
                        setValue={(termData) => {
                            updatePreferredSiteType(termData)
                            updateTaxonomies({ siteType: termData })
                        }}
                        terms={taxonomies.siteType}
                    />
                )}
            </div>
            <div className="mt-px hidden flex-grow overflow-y-auto pb-32 pt-px sm:block">
                <Panel className="bg-transparent">
                    <TaxonomySection
                        taxType={taxonomyType}
                        taxonomies={taxonomies[taxonomyType]}
                    />
                </Panel>
            </div>
            {!apiKey.length && (
                <div className="px-5">
                    <ImportCounter />
                </div>
            )}
        </>
    )
})
